/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Mapping;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Target;
import de.interactive_instruments.ShapeChange.Type;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Excel
implements Target {
    private static final String NS_SS = "urn:schemas-microsoft-com:office:spreadsheet";
    private static final String NS_O = "urn:schemas-microsoft-com:office:office";
    private static final String NS_X = "urn:schemas-microsoft-com:office:excel";
    private static final String NS_HTML = "http://www.w3.org/TR/REC-html40";
    private PackageInfo pi = null;
    private Model model = null;
    private Options options = null;
    private ShapeChangeResult result = null;
    private boolean printed = false;
    private Document document = null;
    private Element root = null;
    private Element styles = null;
    private Element table = null;
    private String outputDirectory = null;
    private boolean diagnosticsOnly = false;
    private String documentationTemplate = null;
    private String documentationNoValue = null;

    @Override
    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        int i;
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        this.diagnosticsOnly = diagOnly;
        this.outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter("outputDirectory");
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter(".");
        }
        this.documentationTemplate = this.options.parameter(this.getClass().getName(), "documentationTemplate");
        this.documentationNoValue = this.options.parameter(this.getClass().getName(), "documentationNoValue");
        File outputDirectoryFile = new File(this.outputDirectory);
        boolean exi = outputDirectoryFile.exists();
        if (!exi) {
            try {
                FileUtils.forceMkdir((File)outputDirectoryFile);
            }
            catch (IOException e) {
                this.result.addError(null, 600, e.getMessage());
                e.printStackTrace(System.err);
            }
            exi = outputDirectoryFile.exists();
        }
        boolean dir = outputDirectoryFile.isDirectory();
        boolean wrt = outputDirectoryFile.canWrite();
        boolean rea = outputDirectoryFile.canRead();
        if (!(exi && dir && wrt && rea)) {
            this.result.addFatalError(null, 601, this.outputDirectory);
            throw new ShapeChangeAbortException();
        }
        this.result.addDebug(null, 10005, this.pi.name());
        this.document = this.createDocument();
        this.root = this.document.createElementNS(NS_SS, "Workbook");
        this.document.appendChild(this.root);
        this.addAttribute(this.document, this.root, "xmlns", NS_SS);
        this.addAttribute(this.document, this.root, "xmlns:ss", NS_SS);
        this.addAttribute(this.document, this.root, "xmlns:o", NS_O);
        this.addAttribute(this.document, this.root, "xmlns:x", NS_X);
        this.addAttribute(this.document, this.root, "xmlns:html", NS_HTML);
        Element e1 = this.document.createElementNS(NS_O, "DocumentProperties");
        this.root.appendChild(e1);
        Element e2 = this.document.createElementNS(NS_O, "Author");
        e1.appendChild(e2);
        e2.appendChild(this.document.createTextNode("ShapeChange"));
        this.styles = this.document.createElementNS(NS_SS, "Styles");
        this.root.appendChild(this.styles);
        e1 = this.document.createElementNS(NS_SS, "Style");
        this.addAttribute(this.document, e1, "ss:ID", "Default");
        this.addAttribute(this.document, e1, "ss:Name", "Normal");
        this.styles.appendChild(e1);
        e2 = this.document.createElementNS(NS_SS, "Alignment");
        e1.appendChild(e2);
        e2 = this.document.createElementNS(NS_SS, "Borders");
        e1.appendChild(e2);
        e2 = this.document.createElementNS(NS_SS, "Font");
        e1.appendChild(e2);
        e2 = this.document.createElementNS(NS_SS, "Interior");
        e1.appendChild(e2);
        e2 = this.document.createElementNS(NS_SS, "NumberFormat");
        e1.appendChild(e2);
        e2 = this.document.createElementNS(NS_SS, "Protection");
        e1.appendChild(e2);
        e1 = this.document.createElementNS(NS_SS, "Style");
        this.addAttribute(this.document, e1, "ss:ID", "s0");
        this.styles.appendChild(e1);
        e2 = this.document.createElementNS(NS_SS, "Alignment");
        this.addAttribute(this.document, e2, "ss:Horizontal", "Center");
        this.addAttribute(this.document, e2, "ss:Vertical", "Top");
        this.addAttribute(this.document, e2, "ss:WrapText", "1");
        e1.appendChild(e2);
        e2 = this.document.createElementNS(NS_SS, "Font");
        this.addAttribute(this.document, e2, "ss:Size", "8.0");
        e1.appendChild(e2);
        e1 = this.document.createElementNS(NS_SS, "Style");
        this.addAttribute(this.document, e1, "ss:ID", "s1");
        this.styles.appendChild(e1);
        e2 = this.document.createElementNS(NS_SS, "Alignment");
        this.addAttribute(this.document, e2, "ss:Horizontal", "Center");
        this.addAttribute(this.document, e2, "ss:Vertical", "Top");
        this.addAttribute(this.document, e2, "ss:WrapText", "1");
        e1.appendChild(e2);
        e2 = this.document.createElementNS(NS_SS, "Font");
        this.addAttribute(this.document, e2, "ss:Size", "8.0");
        e1.appendChild(e2);
        e2 = this.document.createElementNS(NS_SS, "Interior");
        this.addAttribute(this.document, e2, "ss:Color", "#FCF305");
        this.addAttribute(this.document, e2, "ss:Pattern", "Solid");
        e1.appendChild(e2);
        e1 = this.document.createElementNS(NS_SS, "Style");
        this.addAttribute(this.document, e1, "ss:ID", "s2");
        this.styles.appendChild(e1);
        e2 = this.document.createElementNS(NS_SS, "Alignment");
        this.addAttribute(this.document, e2, "ss:Horizontal", "Center");
        this.addAttribute(this.document, e2, "ss:Vertical", "Top");
        this.addAttribute(this.document, e2, "ss:WrapText", "1");
        e1.appendChild(e2);
        e2 = this.document.createElementNS(NS_SS, "Borders");
        e1.appendChild(e2);
        Element e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Bottom");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "2");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Left");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "2");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Right");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "2");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Top");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "2");
        e2.appendChild(e3);
        e2 = this.document.createElementNS(NS_SS, "Font");
        this.addAttribute(this.document, e2, "ss:Size", "12.0");
        this.addAttribute(this.document, e2, "ss:Bold", "1");
        e1.appendChild(e2);
        e2 = this.document.createElementNS(NS_SS, "Interior");
        this.addAttribute(this.document, e2, "ss:Color", "#99CCFF");
        this.addAttribute(this.document, e2, "ss:Pattern", "Solid");
        e1.appendChild(e2);
        e1 = this.document.createElementNS(NS_SS, "Style");
        this.addAttribute(this.document, e1, "ss:ID", "s3");
        this.styles.appendChild(e1);
        e2 = this.document.createElementNS(NS_SS, "Alignment");
        this.addAttribute(this.document, e2, "ss:Horizontal", "Center");
        this.addAttribute(this.document, e2, "ss:Vertical", "Top");
        this.addAttribute(this.document, e2, "ss:WrapText", "1");
        e1.appendChild(e2);
        e2 = this.document.createElementNS(NS_SS, "Borders");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Bottom");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "2");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Left");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Right");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Top");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "2");
        e2.appendChild(e3);
        e2 = this.document.createElementNS(NS_SS, "Font");
        this.addAttribute(this.document, e2, "ss:Size", "11.0");
        this.addAttribute(this.document, e2, "ss:Bold", "1");
        e1.appendChild(e2);
        e2 = this.document.createElementNS(NS_SS, "Interior");
        this.addAttribute(this.document, e2, "ss:Color", "#B0B0B0");
        this.addAttribute(this.document, e2, "ss:Pattern", "Solid");
        e1.appendChild(e2);
        e1 = this.document.createElementNS(NS_SS, "Style");
        this.addAttribute(this.document, e1, "ss:ID", "s4");
        this.styles.appendChild(e1);
        e2 = this.document.createElementNS(NS_SS, "Alignment");
        this.addAttribute(this.document, e2, "ss:Horizontal", "Left");
        this.addAttribute(this.document, e2, "ss:Vertical", "Top");
        this.addAttribute(this.document, e2, "ss:WrapText", "1");
        e1.appendChild(e2);
        e2 = this.document.createElementNS(NS_SS, "Borders");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Bottom");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Left");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Right");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Top");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e2 = this.document.createElementNS(NS_SS, "Font");
        this.addAttribute(this.document, e2, "ss:Size", "10.0");
        this.addAttribute(this.document, e2, "ss:Bold", "1");
        e1.appendChild(e2);
        e1 = this.document.createElementNS(NS_SS, "Style");
        this.addAttribute(this.document, e1, "ss:ID", "s41");
        this.styles.appendChild(e1);
        e2 = this.document.createElementNS(NS_SS, "Alignment");
        this.addAttribute(this.document, e2, "ss:Horizontal", "Left");
        this.addAttribute(this.document, e2, "ss:Vertical", "Top");
        this.addAttribute(this.document, e2, "ss:WrapText", "1");
        e1.appendChild(e2);
        e2 = this.document.createElementNS(NS_SS, "Borders");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Bottom");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Left");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Right");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Top");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e2 = this.document.createElementNS(NS_SS, "Font");
        this.addAttribute(this.document, e2, "ss:Size", "10.0");
        this.addAttribute(this.document, e2, "ss:Bold", "1");
        this.addAttribute(this.document, e2, "ss:Color", "#0000FF");
        e1.appendChild(e2);
        e1 = this.document.createElementNS(NS_SS, "Style");
        this.addAttribute(this.document, e1, "ss:ID", "s42");
        this.styles.appendChild(e1);
        e2 = this.document.createElementNS(NS_SS, "Alignment");
        this.addAttribute(this.document, e2, "ss:Horizontal", "Left");
        this.addAttribute(this.document, e2, "ss:Vertical", "Top");
        this.addAttribute(this.document, e2, "ss:WrapText", "1");
        e1.appendChild(e2);
        e2 = this.document.createElementNS(NS_SS, "Borders");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Bottom");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Left");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Right");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Top");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e2 = this.document.createElementNS(NS_SS, "Font");
        this.addAttribute(this.document, e2, "ss:Size", "10.0");
        this.addAttribute(this.document, e2, "ss:Bold", "1");
        this.addAttribute(this.document, e2, "ss:Color", "#008080");
        e1.appendChild(e2);
        e1 = this.document.createElementNS(NS_SS, "Style");
        this.addAttribute(this.document, e1, "ss:ID", "s5");
        this.styles.appendChild(e1);
        e2 = this.document.createElementNS(NS_SS, "Alignment");
        this.addAttribute(this.document, e2, "ss:Horizontal", "Left");
        this.addAttribute(this.document, e2, "ss:Vertical", "Top");
        this.addAttribute(this.document, e2, "ss:WrapText", "1");
        e1.appendChild(e2);
        e2 = this.document.createElementNS(NS_SS, "Borders");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Bottom");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Left");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Right");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Top");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e2 = this.document.createElementNS(NS_SS, "Font");
        this.addAttribute(this.document, e2, "ss:Size", "8.0");
        e1.appendChild(e2);
        e1 = this.document.createElementNS(NS_SS, "Style");
        this.addAttribute(this.document, e1, "ss:ID", "s51");
        this.styles.appendChild(e1);
        e2 = this.document.createElementNS(NS_SS, "Alignment");
        this.addAttribute(this.document, e2, "ss:Horizontal", "Left");
        this.addAttribute(this.document, e2, "ss:Vertical", "Top");
        this.addAttribute(this.document, e2, "ss:WrapText", "1");
        e1.appendChild(e2);
        e2 = this.document.createElementNS(NS_SS, "Borders");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Bottom");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Left");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Right");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Top");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e2 = this.document.createElementNS(NS_SS, "Font");
        this.addAttribute(this.document, e2, "ss:Size", "8.0");
        this.addAttribute(this.document, e2, "ss:Color", "#0000FF");
        e1.appendChild(e2);
        e1 = this.document.createElementNS(NS_SS, "Style");
        this.addAttribute(this.document, e1, "ss:ID", "s52");
        this.styles.appendChild(e1);
        e2 = this.document.createElementNS(NS_SS, "Alignment");
        this.addAttribute(this.document, e2, "ss:Horizontal", "Left");
        this.addAttribute(this.document, e2, "ss:Vertical", "Top");
        this.addAttribute(this.document, e2, "ss:WrapText", "1");
        e1.appendChild(e2);
        e2 = this.document.createElementNS(NS_SS, "Borders");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Bottom");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Left");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Right");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e3 = this.document.createElementNS(NS_SS, "Border");
        this.addAttribute(this.document, e3, "ss:Position", "Top");
        this.addAttribute(this.document, e3, "ss:LineStyle", "Continuous");
        this.addAttribute(this.document, e3, "ss:Weight", "1");
        e2.appendChild(e3);
        e2 = this.document.createElementNS(NS_SS, "Font");
        this.addAttribute(this.document, e2, "ss:Size", "8.0");
        this.addAttribute(this.document, e2, "ss:Color", "#008080");
        e1.appendChild(e2);
        e1 = this.document.createElementNS(NS_SS, "Worksheet");
        this.addAttribute(this.document, e1, "ss:Name", "Matching Table");
        this.root.appendChild(e1);
        this.table = this.document.createElementNS(NS_SS, "Table");
        this.addAttribute(this.document, this.table, "x:FullColumns", "1");
        this.addAttribute(this.document, this.table, "x:FullRows", "1");
        this.addAttribute(this.document, this.table, "ss:StyleID", "s0");
        this.addAttribute(this.document, this.table, "ss:DefaultRowHeight", "10.0");
        this.addAttribute(this.document, this.table, "ss:DefaultColumnWidth", "100.0");
        e1.appendChild(this.table);
        for (i = 0; i < 7; ++i) {
            e1 = this.document.createElementNS(NS_SS, "Column");
            this.addAttribute(this.document, e1, "ss:StyleID", "s0");
            this.addAttribute(this.document, e1, "ss:AutoFitWidth", "0");
            this.addAttribute(this.document, e1, "ss:Width", "100.0");
            this.table.appendChild(e1);
        }
        e1 = this.document.createElementNS(NS_SS, "Column");
        this.addAttribute(this.document, e1, "ss:StyleID", "s1");
        this.addAttribute(this.document, e1, "ss:AutoFitWidth", "0");
        this.addAttribute(this.document, e1, "ss:Width", "12.0");
        this.table.appendChild(e1);
        for (i = 0; i < 9; ++i) {
            e1 = this.document.createElementNS(NS_SS, "Column");
            this.addAttribute(this.document, e1, "ss:StyleID", "s0");
            this.addAttribute(this.document, e1, "ss:AutoFitWidth", "0");
            this.addAttribute(this.document, e1, "ss:Width", "100.0");
            this.table.appendChild(e1);
        }
        e1 = this.document.createElementNS(NS_SS, "Row");
        this.addAttribute(this.document, e1, "ss:AutoFitHeight", "0");
        this.addAttribute(this.document, e1, "ss:Height", "19.0");
        this.table.appendChild(e1);
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:MergeAcross", "6");
        this.addAttribute(this.document, e2, "ss:StyleID", "s2");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e3.appendChild(this.document.createTextNode("Application Schema '" + this.pi.name() + "' (version " + this.pi.version() + ")"));
        e2.appendChild(e3);
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s1");
        e1.appendChild(e2);
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:MergeAcross", "8");
        this.addAttribute(this.document, e2, "ss:StyleID", "s2");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e3.appendChild(this.document.createTextNode("Application Schema <provide name of source schema>"));
        e2.appendChild(e3);
        e1 = this.document.createElementNS(NS_SS, "Row");
        this.addAttribute(this.document, e1, "ss:AutoFitHeight", "1");
        this.addAttribute(this.document, e1, "ss:Height", "40.0");
        this.table.appendChild(e1);
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s3");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        e3.appendChild(this.document.createTextNode("Type"));
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s3");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        e3.appendChild(this.document.createTextNode("Documentation"));
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s3");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        Element e4 = this.document.createElementNS(NS_HTML, "B");
        e4.appendChild(this.document.createTextNode("Attribute\r"));
        Element e5 = this.document.createElementNS(NS_HTML, "Font");
        this.addAttribute(this.document, e5, "html:Color", "#0000FF");
        e5.appendChild(this.document.createTextNode("Association role\r"));
        e4.appendChild(e5);
        e5 = this.document.createElementNS(NS_HTML, "Font");
        this.addAttribute(this.document, e5, "html:Color", "#008080");
        e5.appendChild(this.document.createTextNode("Constraint"));
        e4.appendChild(e5);
        e3.appendChild(e4);
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s3");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        e4 = this.document.createElementNS(NS_HTML, "B");
        e4.appendChild(this.document.createTextNode("Attribute / "));
        e5 = this.document.createElementNS(NS_HTML, "Font");
        this.addAttribute(this.document, e5, "html:Color", "#0000FF");
        e5.appendChild(this.document.createTextNode("Association role"));
        e4.appendChild(e5);
        e4.appendChild(this.document.createTextNode(" / "));
        e5 = this.document.createElementNS(NS_HTML, "Font");
        this.addAttribute(this.document, e5, "html:Color", "#008080");
        e5.appendChild(this.document.createTextNode("Constraint"));
        e4.appendChild(e5);
        e4.appendChild(this.document.createTextNode(" documentation"));
        e3.appendChild(e4);
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s3");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        e3.appendChild(this.document.createTextNode("Values / Enumerations"));
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s3");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        e3.appendChild(this.document.createTextNode("Multiplicity"));
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s3");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        e3.appendChild(this.document.createTextNode("Voidable / Non-Voidable"));
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s1");
        e1.appendChild(e2);
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s3");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        e3.appendChild(this.document.createTextNode("Type"));
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s3");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        e3.appendChild(this.document.createTextNode("Documentation"));
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s3");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        e4 = this.document.createElementNS(NS_HTML, "B");
        e4.appendChild(this.document.createTextNode("Attribute\r"));
        e5 = this.document.createElementNS(NS_HTML, "Font");
        this.addAttribute(this.document, e5, "html:Color", "#0000FF");
        e5.appendChild(this.document.createTextNode("Association role\r"));
        e4.appendChild(e5);
        e5 = this.document.createElementNS(NS_HTML, "Font");
        this.addAttribute(this.document, e5, "html:Color", "#008080");
        e5.appendChild(this.document.createTextNode("Constraint"));
        e4.appendChild(e5);
        e3.appendChild(e4);
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s3");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        e4 = this.document.createElementNS(NS_HTML, "B");
        e4.appendChild(this.document.createTextNode("Attribute / "));
        e5 = this.document.createElementNS(NS_HTML, "Font");
        this.addAttribute(this.document, e5, "html:Color", "#0000FF");
        e5.appendChild(this.document.createTextNode("Association role"));
        e4.appendChild(e5);
        e4.appendChild(this.document.createTextNode(" / "));
        e5 = this.document.createElementNS(NS_HTML, "Font");
        this.addAttribute(this.document, e5, "html:Color", "#008080");
        e5.appendChild(this.document.createTextNode("Constraint"));
        e4.appendChild(e5);
        e4.appendChild(this.document.createTextNode(" documentation"));
        e3.appendChild(e4);
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s3");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        e3.appendChild(this.document.createTextNode("Values / Enumerations"));
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s3");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        e3.appendChild(this.document.createTextNode("Multiplicity"));
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s3");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        e3.appendChild(this.document.createTextNode("Voidable / Non-Voidable"));
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s3");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        e3.appendChild(this.document.createTextNode("Status"));
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s3");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        e3.appendChild(this.document.createTextNode("Remarks"));
    }

    protected void addAttribute(Document document, Element e, String name, String value) {
        Attr att = document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    protected Document createDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(null, 2);
            String m = e.getMessage();
            if (m != null) {
                this.result.addFatalError(m);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            this.result.addFatalError(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        return document;
    }

    private void supertypelist(Element e, SortedSet<String> st) {
        Iterator i = st.iterator();
        while (i.hasNext()) {
            SortedSet<String> st2;
            ClassInfo sti = this.model.classById((String)i.next());
            if (sti.isAbstract()) {
                Element e1 = this.document.createElementNS(NS_HTML, "I");
                e1.appendChild(this.document.createTextNode("\r" + sti.name()));
                e.appendChild(e1);
            } else {
                e.appendChild(this.document.createTextNode("\r" + sti.name()));
            }
            if ((st2 = sti.supertypes()) == null) continue;
            this.supertypelist(e, st2);
        }
    }

    @Override
    public void process(ClassInfo ci) {
        int i;
        int cat = ci.category();
        if (cat != 1 && cat != 6 && cat != 4 && cat != 5 && cat != 7 && cat != 8) {
            return;
        }
        if (ci.isAbstract()) {
            return;
        }
        Element e1 = this.document.createElementNS(NS_SS, "Row");
        this.addAttribute(this.document, e1, "ss:AutoFitHeight", "1");
        this.addAttribute(this.document, e1, "ss:Height", "20.0");
        this.table.appendChild(e1);
        int rows = this.createAllPropertyDefinitions(this.pi, ci, true);
        List<Constraint> constraints = ci.constraints();
        for (Constraint co : constraints) {
            rows += this.createConstraintDefinition(this.pi, ci, co);
        }
        Element e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s4");
        this.addAttribute(this.document, e2, "ss:MergeDown", "" + rows);
        e1.appendChild(e2);
        Element e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        Element e4 = this.document.createElementNS(NS_HTML, "B");
        e4.appendChild(this.document.createTextNode(ci.name()));
        e3.appendChild(e4);
        SortedSet<String> st = ci.supertypes();
        if (st != null && !st.isEmpty()) {
            e3.appendChild(this.document.createTextNode("\r\r"));
            e4 = this.document.createElementNS(NS_HTML, "Font");
            this.addAttribute(this.document, e4, "html:Size", "8.0");
            this.addAttribute(this.document, e4, "html:Color", "#808080");
            e4.appendChild(this.document.createTextNode("Supertypes:"));
            e3.appendChild(e4);
            e4 = this.document.createElementNS(NS_HTML, "Font");
            this.addAttribute(this.document, e4, "html:Size", "8.0");
            this.addAttribute(this.document, e4, "html:Color", "#0000FF");
            this.supertypelist(e4, st);
            e3.appendChild(e4);
        }
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s5");
        this.addAttribute(this.document, e2, "ss:MergeDown", "" + rows);
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        String s = ci.derivedDocumentation(this.documentationTemplate, this.documentationNoValue);
        e3.appendChild(this.document.createTextNode(s));
        for (i = 0; i < 5; ++i) {
            e2 = this.document.createElementNS(NS_SS, "Cell");
            this.addAttribute(this.document, e2, "ss:StyleID", "s5");
            e1.appendChild(e2);
        }
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s1");
        e1.appendChild(e2);
        for (i = 0; i < 9; ++i) {
            e2 = this.document.createElementNS(NS_SS, "Cell");
            this.addAttribute(this.document, e2, "ss:StyleID", "s5");
            e1.appendChild(e2);
        }
        e1 = this.document.createElementNS(NS_SS, "Row");
        this.addAttribute(this.document, e1, "ss:Height", "5.0");
        this.table.appendChild(e1);
        for (i = 0; i < 7; ++i) {
            e2 = this.document.createElementNS(NS_SS, "Cell");
            this.addAttribute(this.document, e2, "ss:StyleID", "s3");
            e1.appendChild(e2);
        }
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s1");
        e1.appendChild(e2);
        for (i = 0; i < 9; ++i) {
            e2 = this.document.createElementNS(NS_SS, "Cell");
            this.addAttribute(this.document, e2, "ss:StyleID", "s3");
            e1.appendChild(e2);
        }
    }

    private int createAllPropertyDefinitions(PackageInfo asi, ClassInfo ci, boolean local) {
        if (ci == null) {
            return 0;
        }
        if (ci.pkg() == null) {
            this.result.addError(null, 139, ci.name());
            return 0;
        }
        int ct = 0;
        SortedSet<String> st = ci.supertypes();
        if (st != null) {
            Iterator i = st.iterator();
            while (i.hasNext()) {
                ct += this.createAllPropertyDefinitions(asi, this.model.classById((String)i.next()), false);
            }
        }
        for (PropertyInfo propi : ci.properties().values()) {
            ct += this.createPropertyDefinition(asi, ci, propi, local);
        }
        return ct;
    }

    private int createPropertyDefinition(PackageInfo asi, ClassInfo ci, PropertyInfo propi, boolean local) {
        if (!propi.isNavigable()) {
            return 0;
        }
        if (propi.isRestriction()) {
            return 0;
        }
        Element e1 = this.document.createElementNS(NS_SS, "Row");
        this.addAttribute(this.document, e1, "ss:AutoFitHeight", "1");
        this.addAttribute(this.document, e1, "ss:Height", "18.0");
        this.table.appendChild(e1);
        String ao = "";
        if (!propi.isAttribute()) {
            ao = "1";
        }
        Element e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s4" + ao);
        this.addAttribute(this.document, e2, "ss:Index", "3");
        e1.appendChild(e2);
        Element e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        e3.appendChild(this.document.createTextNode(propi.name()));
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s5" + ao);
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        Object s = propi.derivedDocumentation(this.documentationTemplate, this.documentationNoValue);
        e3.appendChild(this.document.createTextNode((String)s));
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s5" + ao);
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        Type ti = propi.typeInfo();
        s = ti.name + "\r";
        ClassInfo ei = this.model.classById(propi.typeInfo().id);
        int cate = -1;
        if (ei != null) {
            cate = ei.category();
        }
        if (ei != null && ei.pkg() != null && (cate == 3 || cate == 2)) {
            for (PropertyInfo vi : ei.properties().values()) {
                s = (String)s + "\r* " + vi.name();
            }
        }
        e3.appendChild(this.document.createTextNode((String)s));
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s5" + ao);
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        Multiplicity m = propi.cardinality();
        if (m.minOccurs == m.maxOccurs) {
            e3.appendChild(this.document.createTextNode("" + m.minOccurs));
        } else if (m.maxOccurs == Integer.MAX_VALUE) {
            e3.appendChild(this.document.createTextNode(m.minOccurs + "..*"));
        } else {
            e3.appendChild(this.document.createTextNode(m.minOccurs + ".." + m.maxOccurs));
        }
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s5" + ao);
        e1.appendChild(e2);
        if (propi.voidable()) {
            e3 = this.document.createElementNS(NS_SS, "Data");
            this.addAttribute(this.document, e3, "ss:Type", "String");
            e2.appendChild(e3);
            e3.appendChild(this.document.createTextNode("voidable"));
        }
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s1");
        e1.appendChild(e2);
        for (int i = 0; i < 9; ++i) {
            e2 = this.document.createElementNS(NS_SS, "Cell");
            this.addAttribute(this.document, e2, "ss:StyleID", "s5");
            e1.appendChild(e2);
        }
        return 1;
    }

    private int createConstraintDefinition(PackageInfo asi, ClassInfo ci, Constraint co) {
        int i;
        Element e1 = this.document.createElementNS(NS_SS, "Row");
        this.addAttribute(this.document, e1, "ss:AutoFitHeight", "1");
        this.addAttribute(this.document, e1, "ss:Height", "18.0");
        this.table.appendChild(e1);
        Element e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s42");
        this.addAttribute(this.document, e2, "ss:Index", "3");
        e1.appendChild(e2);
        Element e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        e3.appendChild(this.document.createTextNode(co.name()));
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s52");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_SS, "Data");
        this.addAttribute(this.document, e3, "ss:Type", "String");
        e2.appendChild(e3);
        String s = co.text();
        e3.appendChild(this.document.createTextNode(s));
        for (i = 0; i < 3; ++i) {
            e2 = this.document.createElementNS(NS_SS, "Cell");
            this.addAttribute(this.document, e2, "ss:StyleID", "s5");
            e1.appendChild(e2);
        }
        e2 = this.document.createElementNS(NS_SS, "Cell");
        this.addAttribute(this.document, e2, "ss:StyleID", "s1");
        e1.appendChild(e2);
        for (i = 0; i < 9; ++i) {
            e2 = this.document.createElementNS(NS_SS, "Cell");
            this.addAttribute(this.document, e2, "ss:StyleID", "s5");
            e1.appendChild(e2);
        }
        return 1;
    }

    @Override
    public void write() {
        if (this.printed) {
            return;
        }
        if (this.diagnosticsOnly) {
            return;
        }
        Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        outputFormat.setProperty("indent", "no");
        outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "0");
        outputFormat.setProperty("encoding", "UTF-8");
        try {
            File file = new File(this.outputDirectory + "/" + this.pi.name() + " Mapping Table.xml");
            FileWriter outputXML = new FileWriter(file);
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            serializer.setWriter((Writer)outputXML);
            serializer.asDOMSerializer().serialize((Node)this.document);
            outputXML.close();
            this.result.addResult(this.getTargetName(), this.outputDirectory, this.pi.name() + " Mapping Table.xml", this.pi.targetNamespace());
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
        this.printed = true;
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
    }

    @Override
    public String getTargetIdentifier() {
        return "excel";
    }

    @Override
    public String getTargetName() {
        return "Excel Mapping";
    }

    @Override
    public String getDefaultEncodingRule() {
        return "*";
    }
}

