/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Util.XMLUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MapEntries
implements MessageSource {
    public static final String SC_CONFIG_NS = "http://www.interactive-instruments.de/ShapeChange/Configuration/1.1";
    protected List<ProcessMapEntry> mapEntries = new ArrayList<ProcessMapEntry>();

    public void add(ProcessMapEntry me) {
        this.mapEntries.add(me);
    }

    public void add(Collection<ProcessMapEntry> mes) {
        this.mapEntries.addAll(mes);
    }

    public void toXml(File outputFile, ShapeChangeResult result) {
        if (this.mapEntries.isEmpty()) {
            result.addWarning(this, 1, outputFile.getAbsolutePath());
            return;
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.newDocument();
            Element root = document.createElementNS(SC_CONFIG_NS, "mapEntries");
            document.appendChild(root);
            XMLUtil.addAttribute(document, root, "xmlns", SC_CONFIG_NS);
            List sortedMapEntries = this.mapEntries.stream().sorted((me1, me2) -> me1.getType().compareTo(me2.getType())).collect(Collectors.toList());
            for (ProcessMapEntry pme : sortedMapEntries) {
                Element e1 = document.createElementNS(SC_CONFIG_NS, "MapEntry");
                root.appendChild(e1);
                XMLUtil.addAttribute(document, e1, "type", pme.getType());
                XMLUtil.addAttribute(document, e1, "rule", pme.getRule());
                if (pme.hasTargetType()) {
                    XMLUtil.addAttribute(document, e1, "targetType", pme.getTargetType());
                }
                if (!pme.hasParam()) continue;
                XMLUtil.addAttribute(document, e1, "param", pme.getParam());
            }
            Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
            outputFormat.setProperty("indent", "yes");
            outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            outputFormat.setProperty("encoding", "UTF-8");
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            serializer.setWriter((Writer)writer);
            serializer.asDOMSerializer().serialize((Node)document);
            writer.close();
        }
        catch (IOException | ParserConfigurationException e) {
            result.addError(this, 2, outputFile.getAbsolutePath(), e.getMessage());
        }
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "No map entries to write to file '$1$'.";
            }
            case 2: {
                return "Encountered an exception while writing map entries to file '$1$'. Exception message is: $2$";
            }
        }
        return "(MapEntries.java) Unknown message with number: " + mnr;
    }
}

