/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Ldproxy2;

import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.MapEntryParamInfos;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.TargetConfiguration;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class Ldproxy2TargetConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("associativeTableColumnSuffix", "cfgTemplatePath", "dateFormat", "dateTimeFormat", "descriptionTemplate", "descriptorNoValue", "forceAxisOrder", "foreignKeyColumnSuffix", "foreignKeyColumnSuffixDatatype", "labelTemplate", "maxNameLength", "nativeTimeZone", "objectIdentifierName", "primaryKeyColumn", "serviceDescription", "serviceLabel", "serviceConfigTemplatePath", "srid", "_unitTestOverride").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;
    private TargetConfiguration targetConfig = null;
    private String targetConfigInputs = "";
    private Options options = null;
    private ShapeChangeResult result = null;

    @Override
    public boolean isValid(ProcessConfiguration config, Options options, ShapeChangeResult result) {
        this.targetConfig = (TargetConfiguration)config;
        SortedSet<String> inputIds = this.targetConfig.getInputIds();
        if (inputIds != null && !inputIds.isEmpty()) {
            this.targetConfigInputs = String.join((CharSequence)" ", inputIds);
        }
        this.options = options;
        this.result = result;
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTargetParameters());
        isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, config.getParameters().keySet(), result) && isValid;
        TreeMap<String, ProcessMapEntry> mapEntryByType = new TreeMap<String, ProcessMapEntry>();
        for (ProcessMapEntry pme : config.getMapEntries()) {
            mapEntryByType.put(pme.getType(), pme);
        }
        MapEntryParamInfos mepis = new MapEntryParamInfos(result, mapEntryByType.values());
        isValid = isValid && mepis.isValid();
        isValid = isValid && this.checkMapEntryParameters(mepis);
        isValid &= this.checkNonNegativeIntegerParameter("srid");
        isValid &= this.checkNonNegativeIntegerParameter("maxNameLength");
        isValid &= this.checkStringParameterNotBlankIfSet("cfgTemplatePath");
        isValid &= this.checkStringParameterNotBlankIfSet("dateFormat");
        isValid &= this.checkStringParameterNotBlankIfSet("dateTimeFormat");
        isValid &= this.checkStringParameterNotBlankIfSet("descriptionTemplate");
        isValid &= this.checkStringParameterNotBlankIfSet("forceAxisOrder");
        isValid &= this.checkStringParameterNotBlankIfSet("labelTemplate");
        isValid &= this.checkStringParameterNotBlankIfSet("nativeTimeZone");
        isValid &= this.checkStringParameterNotBlankIfSet("objectIdentifierName");
        isValid &= this.checkStringParameterNotBlankIfSet("primaryKeyColumn");
        isValid &= this.checkStringParameterNotBlankIfSet("serviceDescription");
        isValid &= this.checkStringParameterNotBlankIfSet("serviceLabel");
        isValid &= this.checkStringParameterNotBlankIfSet("serviceConfigTemplatePath");
        if (StringUtils.isNotBlank((CharSequence)this.targetConfig.getParameterValue("forceAxisOrder"))) {
            String paramValue = this.targetConfig.getParameterValue("forceAxisOrder");
            try {
                EpsgCrs.Force.valueOf(paramValue);
            }
            catch (IllegalArgumentException e) {
                ShapeChangeResult.MessageContext mc = result.addError(this, 107, "forceAxisOrder", paramValue);
                mc.addDetail(this, 0, this.targetConfigInputs);
                isValid = false;
            }
        }
        return isValid;
    }

    private boolean checkStringParameterNotBlankIfSet(String paramName) {
        if (this.targetConfig.hasParameter(paramName) && StringUtils.isBlank((CharSequence)this.targetConfig.getParameterValue(paramName))) {
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 106, paramName);
            mc.addDetail(this, 0, this.targetConfigInputs);
            return false;
        }
        return true;
    }

    private boolean checkIntegerParameter(String paramName) {
        String valueByConfig = this.targetConfig.getParameterValue(paramName);
        if (valueByConfig != null) {
            try {
                Integer.parseInt(valueByConfig);
            }
            catch (NumberFormatException e) {
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 4, paramName, e.getMessage());
                mc.addDetail(this, 0, this.targetConfigInputs);
                return false;
            }
        }
        return true;
    }

    private boolean checkNonNegativeIntegerParameter(String paramName) {
        String valueByConfig = this.targetConfig.getParameterValue(paramName);
        if (valueByConfig != null) {
            try {
                Integer i = Integer.parseInt(valueByConfig);
                if (i < 0) {
                    this.result.addError(this, 104, paramName, valueByConfig);
                    return false;
                }
            }
            catch (NumberFormatException e) {
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 4, paramName, e.getMessage());
                mc.addDetail(this, 0, this.targetConfigInputs);
                return false;
            }
        }
        return true;
    }

    private boolean checkMapEntryParameters(MapEntryParamInfos mepp) {
        boolean isValid = true;
        for (Map.Entry<String, Map<String, Map<String, String>>> entry : mepp.getParameterCache().entrySet()) {
            ShapeChangeResult.MessageContext mc;
            ShapeChangeResult.MessageContext mc2;
            String ruleName;
            String typeRuleKey = entry.getKey();
            String[] keyParts = typeRuleKey.split("#");
            String typeName = keyParts[0];
            ProcessMapEntry pme = mepp.getMapEntry(typeName, ruleName = keyParts[1]);
            String targetType = pme.getTargetType();
            if (StringUtils.isBlank((CharSequence)targetType)) {
                isValid = false;
                mc2 = this.result.addError(this, 108, typeName);
                if (mc2 != null) {
                    mc2.addDetail(this, 2, this.targetConfigInputs, typeRuleKey);
                }
            } else if (!StringUtils.equalsAnyIgnoreCase((CharSequence)targetType, (CharSequence[])new CharSequence[]{"FLOAT", "INTEGER", "STRING", "BOOLEAN", "DATETIME", "DATE", "GEOMETRY", "LINK"})) {
                isValid = false;
                mc2 = this.result.addError(this, 109, typeName, targetType);
                if (mc2 != null) {
                    mc2.addDetail(this, 2, this.targetConfigInputs, typeRuleKey);
                }
            }
            Map<String, Map<String, String>> characteristicsByParameter = entry.getValue();
            if (characteristicsByParameter.containsKey("geometryInfos")) {
                if (!targetType.equalsIgnoreCase("GEOMETRY")) {
                    isValid = false;
                    mc = this.result.addError(this, 101, "geometryInfos", "GEOMETRY", targetType);
                    if (mc != null) {
                        mc.addDetail(this, 1, this.targetConfigInputs, typeRuleKey, targetType);
                    }
                } else {
                    isValid &= this.checkParameterRequiredCharacteristicHasValue(characteristicsByParameter, "geometryInfos", "geometryType", typeRuleKey, targetType);
                    isValid &= this.checkParameterCharacteristicHasAllowedValueIgnoringCase(characteristicsByParameter, "geometryInfos", "geometryType", new String[]{"POINT", "MULTI_POINT", "LINE_STRING", "MULTI_LINE_STRING", "POLYGON", "MULTI_POLYGON", "GEOMETRY_COLLECTION", "ANY"}, typeRuleKey, targetType);
                }
            }
            if (characteristicsByParameter.containsKey("initialValueEncoding")) {
                if (!StringUtils.equalsAnyIgnoreCase((CharSequence)targetType, (CharSequence[])new CharSequence[]{"FLOAT", "INTEGER", "STRING", "BOOLEAN", "DATETIME", "DATE"})) {
                    isValid = false;
                    mc = this.result.addError(this, 101, "initialValueEncoding", "FLOAT, INTEGER, STRING, BOOLEAN, DATETIME, DATE", targetType);
                    if (mc != null) {
                        mc.addDetail(this, 1, this.targetConfigInputs, typeRuleKey, targetType);
                    }
                } else {
                    isValid &= this.checkParameterOptionalCharacteristicHasValue(characteristicsByParameter, "initialValueEncoding", "false", typeRuleKey, targetType);
                    isValid &= this.checkParameterOptionalCharacteristicHasValue(characteristicsByParameter, "initialValueEncoding", "true", typeRuleKey, targetType);
                }
            }
            if (!characteristicsByParameter.containsKey("linkInfos")) continue;
            if (!targetType.equalsIgnoreCase("LINK")) {
                isValid = false;
                mc = this.result.addError(this, 101, "linkInfos", "LINK", targetType);
                if (mc == null) continue;
                mc.addDetail(this, 1, this.targetConfigInputs, typeRuleKey, targetType);
                continue;
            }
            isValid &= this.checkParameterRequiredCharacteristicHasValue(characteristicsByParameter, "linkInfos", "urlTemplate", typeRuleKey, targetType);
        }
        return isValid;
    }

    private boolean checkParameterCharacteristicHasAllowedValueIgnoringCase(Map<String, Map<String, String>> characteristicsByParameter, String meParamName, String meParamCharacteristic, String[] allowedValues, String typeRuleKey, String targetType) {
        String characteristicValue;
        Map<String, String> characteristics = characteristicsByParameter.get(meParamName);
        if (characteristics.containsKey(meParamCharacteristic) && StringUtils.isNotBlank((CharSequence)(characteristicValue = characteristics.get(meParamCharacteristic))) && !StringUtils.equalsAnyIgnoreCase((CharSequence)characteristicValue, (CharSequence[])allowedValues)) {
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 103, meParamName, meParamCharacteristic, characteristicValue, StringUtils.join((Object[])allowedValues, (String)", "));
            if (mc != null) {
                mc.addDetail(this, 1, this.targetConfigInputs, typeRuleKey, targetType);
            }
            return false;
        }
        return true;
    }

    private boolean checkParameterOptionalCharacteristicHasValue(Map<String, Map<String, String>> characteristicsByParameter, String meParamName, String meParamCharacteristic, String typeRuleKey, String targetType) {
        Map<String, String> characteristics = characteristicsByParameter.get(meParamName);
        if (characteristics.containsKey(meParamCharacteristic) && StringUtils.isBlank((CharSequence)characteristics.get(meParamCharacteristic))) {
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 105, meParamName, meParamCharacteristic);
            if (mc != null) {
                mc.addDetail(this, 1, this.targetConfigInputs, typeRuleKey, targetType);
            }
            return false;
        }
        return true;
    }

    private boolean checkParameterRequiredCharacteristicHasValue(Map<String, Map<String, String>> characteristicsByParameter, String meParamName, String meParamCharacteristic, String typeRuleKey, String targetType) {
        Map<String, String> characteristics = characteristicsByParameter.get(meParamName);
        String characteristicValue = characteristics.get(meParamCharacteristic);
        if (StringUtils.isBlank((CharSequence)characteristicValue)) {
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 102, meParamName, meParamCharacteristic);
            if (mc != null) {
                mc.addDetail(this, 1, this.targetConfigInputs, typeRuleKey, targetType);
            }
            return false;
        }
        return true;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: Ldproxy2Target configuration element with 'inputs'='$1$'.";
            }
            case 1: {
                return "Context: Ldproxy2Target configuration element with 'inputs'='$1$', map entry with type#rule '$2$' and target type '$3$'.";
            }
            case 2: {
                return "Context: Ldproxy2Target configuration element with 'inputs'='$1$', map entry with type#rule '$2$'.";
            }
            case 4: {
                return "Number format exception while converting the value of configuration parameter '$1$' to an integer. Exception message: $2$. Ensure that the parameter value is an integer.";
            }
            case 100: {
                return "Parameter '$1$' is set to '$2$'. This is not a valid value.";
            }
            case 101: {
                return "Invalid map entry: parameter '$1$' is set, which is only applicable to a mapping with target type (one of) '$2$'. Found target type: '$3$'.";
            }
            case 102: {
                return "Invalid map entry: parameter '$1$' is set, but its characteristic '$2$' (which is required for the parameter) is not set or has no value.";
            }
            case 103: {
                return "Invalid map entry: parameter '$1$' is set, with characteristic '$2$', but the value '$3$' of the characteristic is not equal to (ignoring case) any of the allowed values, which are: '$4$'.";
            }
            case 104: {
                return "Parameter '$1$' is set to '$2$'. This is not a valid non-negative integer value.";
            }
            case 105: {
                return "Invalid map entry: parameter '$1$' is set, with characteristic '$2$', but no value is defined for the characteristic.";
            }
            case 106: {
                return "Parameter '$1$' is set in the configuration, but has a blank value, which is not allowed for that parameter.";
            }
            case 107: {
                return "Parameter '$1$' is set to '$2$'. This is not a valid value (case matters for this parameter).";
            }
            case 108: {
                return "Invalid map entry for type '$1$': the target type is undefined.";
            }
            case 109: {
                return "Invalid map entry for type '$1$': target type '$2$' does not equal (ignoring case) any of the allowed values: FLOAT, INTEGER, STRING, BOOLEAN, DATETIME, DATE, GEOMETRY, LINK. Check for typos or whitespace characters and correct the target type.";
            }
        }
        return "(" + Ldproxy2TargetConfigurationValidator.class.getName() + ") Unknown message with number: " + mnr;
    }
}

