/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Ldproxy2;

import de.ii.ldproxy.cfg.LdproxyCfg;
import de.ii.ogcapi.features.html.domain.ImmutableFeaturesHtmlConfiguration;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.foundation.domain.FeatureTypeConfigurationOgcApi;
import de.ii.ogcapi.foundation.domain.ImmutableFeatureTypeConfigurationOgcApi;
import de.ii.ogcapi.foundation.domain.ImmutableOgcApiDataV2;
import de.ii.xtraplatform.codelists.domain.CodelistData;
import de.ii.xtraplatform.codelists.domain.ImmutableCodelistData;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.crs.domain.ImmutableEpsgCrs;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.ImmutableFeatureSchema;
import de.ii.xtraplatform.features.domain.ImmutableSchemaConstraints;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.transform.ImmutablePropertyTransformation;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformation;
import de.ii.xtraplatform.features.sql.domain.ConnectionInfoSql;
import de.ii.xtraplatform.features.sql.domain.ImmutableConnectionInfoSql;
import de.ii.xtraplatform.features.sql.domain.ImmutableFeatureProviderSqlData;
import de.ii.xtraplatform.features.sql.domain.ImmutableQueryGeneratorSettings;
import de.ii.xtraplatform.features.sql.domain.ImmutableSqlPathDefaults;
import de.ii.xtraplatform.geometries.domain.SimpleFeatureGeometry;
import de.interactive_instruments.ShapeChange.MapEntryParamInfos;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SingleTarget;
import de.interactive_instruments.ShapeChange.Target.TargetUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class Ldproxy2Target
implements SingleTarget,
MessageSource {
    protected static Model model = null;
    private static boolean initialised = false;
    protected static boolean diagnosticsOnly = false;
    protected static int numberOfEncodedSchemas = 0;
    protected static String associativeTableColumnSuffix = null;
    protected static String cfgTemplatePath = "https://shapechange.net/resources/templates/ldproxy2/cfgTemplate.yml";
    protected static String dateFormat = null;
    protected static String dateTimeFormat = null;
    protected static String descriptionTemplate = "[[definition]]";
    protected static String descriptorNoValue = "";
    protected static EpsgCrs.Force forceAxisOrder = EpsgCrs.Force.NONE;
    protected static String foreignKeyColumnSuffix = "";
    protected static String foreignKeyColumnSuffixDatatype = "";
    protected static String labelTemplate = "[[alias]]";
    protected static int maxNameLength = 63;
    protected static ZoneId nativeTimeZone = ZoneId.systemDefault();
    protected static String objectIdentifierName = "oid";
    protected static String primaryKeyColumn = "id";
    protected static String serviceConfigTemplatePathString = null;
    protected static String serviceDescription = "FIXME";
    protected static String serviceLabel = "FIXME";
    protected static int srid = 4326;
    protected static SortedSet<String> dbSchemaNames = new TreeSet<String>();
    protected static boolean isUnitTest = false;
    protected static String outputDirectory = null;
    protected static File dataDirectoryFile = null;
    protected static String mainId = null;
    protected static MapEntryParamInfos mapEntryParamInfos = null;
    protected static List<ClassInfo> typesWithIdentity = new ArrayList<ClassInfo>();
    protected static SortedSet<ClassInfo> codelistsAndEnumerations = new TreeSet<ClassInfo>();
    protected static LdproxyCfg cfg = null;
    protected ShapeChangeResult result = null;
    protected Options options = null;
    private PackageInfo schema = null;
    private boolean schemaNotEncoded = false;
    protected Map<ClassInfo, SortedMap<String, List<PropertyTransformation>>> serviceConfigPropertyTransformationsByTopLevelClass = new HashMap<ClassInfo, SortedMap<String, List<PropertyTransformation>>>();

    @Override
    public void initialise(PackageInfo pi, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        String dbSchemaName;
        this.schema = pi;
        model = m;
        this.options = o;
        this.result = r;
        diagnosticsOnly = diagOnly;
        if (!Ldproxy2Target.isEncoded(this.schema)) {
            this.schemaNotEncoded = true;
            this.result.addInfo(this, 7, this.schema.name());
            return;
        }
        ++numberOfEncodedSchemas;
        if (this.schema.matches("rule-ldp2-all-schemas") && StringUtils.isNotBlank((CharSequence)(dbSchemaName = this.schema.taggedValue("sqlSchema")))) {
            dbSchemaNames.add(dbSchemaName.trim());
        }
        if (!initialised) {
            PackageInfo mainAppSchema;
            initialised = true;
            dbSchemaNames.add("public");
            outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
            if (outputDirectory == null) {
                outputDirectory = this.options.parameter("outputDirectory");
            }
            if (outputDirectory == null) {
                outputDirectory = this.options.parameter(".");
            }
            mainId = (mainAppSchema = TargetUtil.findMainSchemaForSingleTargets(model.selectedSchemas(), o, r)) == null ? this.schema.name() : mainAppSchema.name();
            mainId = mainId.replaceAll("\\W", "_").toLowerCase(Locale.ENGLISH);
            isUnitTest = this.options.parameterAsBoolean(this.getClass().getName(), "_unitTestOverride", false);
            cfgTemplatePath = this.options.parameterAsString(this.getClass().getName(), "cfgTemplatePath", "https://shapechange.net/resources/templates/ldproxy2/cfgTemplate.yml", false, true);
            dateFormat = this.options.parameterAsString(this.getClass().getName(), "dateFormat", null, false, true);
            dateTimeFormat = this.options.parameterAsString(this.getClass().getName(), "dateTimeFormat", null, false, true);
            descriptionTemplate = this.options.parameterAsString(this.getClass().getName(), "descriptionTemplate", "[[definition]]", false, true);
            descriptorNoValue = this.options.parameterAsString(this.getClass().getName(), "descriptorNoValue", "", false, true);
            String forceAxisOrderString = this.options.parameterAsString(this.getClass().getName(), "forceAxisOrder", "NONE", false, true);
            forceAxisOrder = EpsgCrs.Force.valueOf(forceAxisOrderString);
            foreignKeyColumnSuffix = this.options.parameterAsString(this.getClass().getName(), "foreignKeyColumnSuffix", "", false, true);
            foreignKeyColumnSuffixDatatype = this.options.parameterAsString(this.getClass().getName(), "foreignKeyColumnSuffixDatatype", "", false, true);
            labelTemplate = this.options.parameterAsString(this.getClass().getName(), "labelTemplate", "[[alias]]", false, true);
            maxNameLength = this.options.parameterAsInteger(this.getClass().getName(), "maxNameLength", 63);
            String nativeTimeZoneParamValue = this.options.parameterAsString(this.getClass().getName(), "nativeTimeZone", ZoneId.systemDefault().toString(), false, true);
            nativeTimeZone = ZoneId.of(nativeTimeZoneParamValue);
            objectIdentifierName = this.options.parameterAsString(this.getClass().getName(), "objectIdentifierName", "oid", false, true);
            primaryKeyColumn = this.options.parameterAsString(this.getClass().getName(), "primaryKeyColumn", "id", false, true);
            associativeTableColumnSuffix = this.options.parameterAsString(this.getClass().getName(), "associativeTableColumnSuffix", primaryKeyColumn, false, true);
            serviceConfigTemplatePathString = this.options.parameterAsString(this.getClass().getName(), "serviceConfigTemplatePath", null, false, true);
            serviceDescription = this.options.parameterAsString(this.getClass().getName(), "serviceDescription", "FIXME", false, true);
            serviceLabel = this.options.parameterAsString(this.getClass().getName(), "serviceLabel", "FIXME", false, true);
            srid = this.options.parameterAsInteger(this.getClass().getName(), "srid", 4326);
            List<ProcessMapEntry> mapEntries = this.options.getCurrentProcessConfig().getMapEntries();
            if (mapEntries.isEmpty()) {
                this.result.addWarning(this, 15);
                mapEntryParamInfos = new MapEntryParamInfos(this.result, null);
            } else {
                mapEntryParamInfos = new MapEntryParamInfos(this.result, mapEntries);
            }
            File outputDirectoryFile = new File(outputDirectory);
            if (!diagnosticsOnly) {
                boolean exi = outputDirectoryFile.exists();
                if (!exi) {
                    outputDirectoryFile.mkdirs();
                    exi = outputDirectoryFile.exists();
                }
                boolean dir = outputDirectoryFile.isDirectory();
                boolean wrt = outputDirectoryFile.canWrite();
                boolean rea = outputDirectoryFile.canRead();
                if (!(exi && dir && wrt && rea)) {
                    this.result.addFatalError(this, 5, outputDirectory);
                    throw new ShapeChangeAbortException();
                }
            } else {
                this.result.addInfo(this, 10002);
            }
            dataDirectoryFile = new File(outputDirectory, "data");
            Path dataDirectoryPath = dataDirectoryFile.toPath();
            cfg = new LdproxyCfg(dataDirectoryPath);
        }
        this.result.addDebug(this, 10001, pi.name());
    }

    public static boolean isEncoded(Info i) {
        return !i.matches("rule-ldp2-all-notEncoded") || !i.encodingRule("ldp2").equalsIgnoreCase("notencoded");
    }

    @Override
    public void process(ClassInfo ci) {
        ShapeChangeResult.MessageContext mc;
        if (ci == null || ci.pkg() == null) {
            return;
        }
        if (!Ldproxy2Target.isEncoded(ci)) {
            this.result.addInfo(this, 8, ci.name());
            return;
        }
        this.result.addDebug(this, 4, ci.name());
        Optional<ProcessMapEntry> pme = this.mapEntry(ci);
        if (pme.isPresent() && !this.ignoreMapEntryForTypeFromSchemaSelectedForProcessing(pme.get(), ci.id())) {
            this.result.addInfo(this, 22, ci.name(), pme.get().getTargetType());
            return;
        }
        if (this.schemaNotEncoded) {
            this.result.addInfo(this, 18, this.schema.name(), ci.name());
            return;
        }
        if (ci.isAbstract()) {
            ShapeChangeResult.MessageContext mc2 = this.result.addWarning(this, 20, ci.name());
            if (mc2 != null) {
                mc2.addDetail(this, 0, ci.fullNameInSchema());
            }
            return;
        }
        if (!ci.supertypes().isEmpty() && (mc = this.result.addError(this, 103, ci.name())) != null) {
            mc.addDetail(this, 0, ci.fullNameInSchema());
        }
        if (ci.category() != 5) {
            if (ci.category() == 6 || ci.category() == 1) {
                if (typesWithIdentity.stream().anyMatch(t -> t.name().equalsIgnoreCase(ci.name()))) {
                    mc = this.result.addError(this, 125, ci.name());
                    if (mc != null) {
                        mc.addDetail(this, 0, ci.fullNameInSchema());
                    }
                } else {
                    typesWithIdentity.add(ci);
                }
            } else if (ci.category() == 3 || ci.category() == 2) {
                if (codelistsAndEnumerations.stream().anyMatch(t -> t.name().equalsIgnoreCase(ci.name()))) {
                    mc = this.result.addError(this, 125, ci.name());
                    if (mc != null) {
                        mc.addDetail(this, 0, ci.fullNameInSchema());
                    }
                } else {
                    codelistsAndEnumerations.add(ci);
                }
            } else {
                this.result.addInfo(this, 17, ci.name());
            }
        }
    }

    public boolean ignoreMapEntryForTypeFromSchemaSelectedForProcessing(ProcessMapEntry pme, String typeId) {
        if (StringUtils.isBlank((CharSequence)typeId)) {
            return false;
        }
        ClassInfo type = model.classById(typeId);
        if (type == null || !Ldproxy2Target.isEncoded(type) || !model.isInSelectedSchemas(type)) {
            return false;
        }
        return mapEntryParamInfos.hasParameter(pme, "ignoreForTypeFromSchemaSelectedForProcessing");
    }

    public Optional<ProcessMapEntry> mapEntry(ClassInfo ci) {
        return Optional.ofNullable(this.options.targetMapEntry(ci.name(), ci.encodingRule("ldp2")));
    }

    @Override
    public void write() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAll(ShapeChangeResult r) {
        this.result = r;
        this.options = r.options();
        if (numberOfEncodedSchemas == 0) {
            return;
        }
        if (!diagnosticsOnly) {
            if (StringUtils.isNotBlank((CharSequence)cfgTemplatePath)) {
                File cfgFile = new File(dataDirectoryFile, "cfg.yml");
                try {
                    if (cfgTemplatePath.startsWith("http")) {
                        FileUtils.copyURLToFile((URL)new URL(cfgTemplatePath), (File)cfgFile);
                    } else {
                        FileUtils.copyFile((File)new File(cfgTemplatePath), (File)cfgFile);
                    }
                }
                catch (IOException e) {
                    this.result.addError(this, 123, "cfgTemplatePath", cfgTemplatePath, cfgFile.getAbsolutePath());
                }
            }
            File serviceConfigTemplateFile = new File(outputDirectory, "tmp_serviceConfigTemplate.yml");
            if (StringUtils.isNotBlank((CharSequence)serviceConfigTemplatePathString)) {
                try {
                    if (serviceConfigTemplatePathString.startsWith("http")) {
                        FileUtils.copyURLToFile((URL)new URL(serviceConfigTemplatePathString), (File)serviceConfigTemplateFile);
                    } else {
                        FileUtils.copyFile((File)new File(serviceConfigTemplatePathString), (File)serviceConfigTemplateFile);
                    }
                }
                catch (IOException e) {
                    this.result.addError(this, 123, "serviceConfigTemplatePath", serviceConfigTemplatePathString, serviceConfigTemplateFile.getAbsolutePath());
                }
            }
            ArrayList<ImmutableCodelistData> codelists = new ArrayList<ImmutableCodelistData>();
            for (ClassInfo ci : codelistsAndEnumerations) {
                ImmutableCodelistData icd = this.createCodelistEntity(ci);
                codelists.add(icd);
            }
            TreeMap<String, FeatureSchema> providerTypeDefinitions = new TreeMap<String, FeatureSchema>();
            TreeMap<String, FeatureTypeConfigurationOgcApi> serviceCollectionDefinitions = new TreeMap<String, FeatureTypeConfigurationOgcApi>();
            for (ClassInfo ci : typesWithIdentity) {
                String typeDefName = ci.name().toLowerCase(Locale.ENGLISH);
                LinkedHashMap<String, FeatureSchema> propertyDefs = this.propertyDefinitions(ci, new ArrayList<PropertyInfo>());
                ImmutableFeatureSchema typeDef = new ImmutableFeatureSchema.Builder().type(SchemaBase.Type.OBJECT).name(typeDefName).objectType(ci.name()).label(this.label(ci)).sourcePath("/" + this.databaseTableName(ci, false)).description(this.description(ci)).propertyMap(propertyDefs).build();
                providerTypeDefinitions.put(typeDefName, typeDef);
                ImmutableFeaturesHtmlConfiguration.Builder fhtmlBuilder = cfg.builder().ogcApiExtension().featuresHtml();
                fhtmlBuilder.featureTitleTemplate(this.featureTitleTemplate(ci));
                if (this.serviceConfigPropertyTransformationsByTopLevelClass.containsKey(ci)) {
                    SortedMap<String, List<PropertyTransformation>> serviceConfigPropertyTransformations = this.serviceConfigPropertyTransformationsByTopLevelClass.get(ci);
                    fhtmlBuilder.transformations(serviceConfigPropertyTransformations);
                }
                ImmutableFeaturesHtmlConfiguration fhtml = fhtmlBuilder.build();
                ImmutableFeatureTypeConfigurationOgcApi serviceCollDef = new ImmutableFeatureTypeConfigurationOgcApi.Builder().id(typeDefName).label(typeDefName).addExtensions((ExtensionConfiguration)fhtml).build();
                serviceCollectionDefinitions.put(typeDefName, serviceCollDef);
            }
            ImmutableOgcApiDataV2 serviceConfig = cfg.builder().entity().api().id(mainId).entityStorageVersion(2L).label(serviceLabel).description(serviceDescription).serviceType("OGC_API").collections(serviceCollectionDefinitions).build();
            if (isUnitTest) {
                serviceConfig = serviceConfig.withCreatedAt(1000000000000L).withLastModified(1000000000000L);
            }
            ImmutableConnectionInfoSql connectionInfo = cfg.builder().entity().provider().connectionInfoBuilder().dialect(ConnectionInfoSql.Dialect.PGIS).database("FIXME").host("FIXME").user("FIXME").password("FIXME-base64-encoded").schemas(dbSchemaNames).build();
            ImmutableSqlPathDefaults sourcePathDefaults = cfg.builder().entity().provider().sourcePathDefaultsBuilder().primaryKey(primaryKeyColumn).sortKey(primaryKeyColumn).build();
            ImmutableQueryGeneratorSettings queryGeneration = cfg.builder().entity().provider().queryGenerationBuilder().computeNumberMatched(true).build();
            ImmutableEpsgCrs nativeCrs = cfg.builder().entity().provider().nativeCrsBuilder().code(srid).forceAxisOrder(forceAxisOrder).build();
            ImmutableFeatureProviderSqlData providerConfig = cfg.builder().entity().provider().id(mainId).providerType("FEATURE").entityStorageVersion(2L).providerType("FEATURE").featureProviderType("SQL").connectionInfo(connectionInfo).sourcePathDefaults(sourcePathDefaults).queryGeneration(queryGeneration).nativeCrs(nativeCrs).nativeTimeZone(nativeTimeZone).types(providerTypeDefinitions).build();
            if (isUnitTest) {
                providerConfig = providerConfig.withCreatedAt(1000000000000L).withLastModified(1000000000000L);
            }
            try {
                if (serviceConfigTemplateFile.exists()) {
                    cfg.writeEntity(serviceConfig, serviceConfigTemplateFile.toPath());
                } else {
                    cfg.writeEntity(serviceConfig, new Path[0]);
                }
                cfg.writeEntity(providerConfig, new Path[0]);
                for (ImmutableCodelistData icd : codelists) {
                    cfg.writeEntity(icd, new Path[0]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (serviceConfigTemplateFile.exists()) {
                    FileUtils.deleteQuietly((File)serviceConfigTemplateFile);
                }
            }
        }
    }

    private LinkedHashMap<String, FeatureSchema> propertyDefinitions(ClassInfo currentCi, List<PropertyInfo> alreadyVisitedPiList) {
        LinkedHashMap<String, FeatureSchema> propertyDefs = new LinkedHashMap<String, FeatureSchema>();
        PropertyInfo identifierPi = null;
        boolean multipleIdentifierPisEncountered = false;
        PropertyInfo defaultGeometryPi = null;
        boolean multipleDefaultGeometriesEncountered = false;
        PropertyInfo defaultInstantPi = null;
        boolean multipleDefaultInstantsEncountered = false;
        PropertyInfo defaultIntervalStartPi = null;
        boolean multipleDefaultIntervalStartsEncountered = false;
        PropertyInfo defaultIntervalEndPi = null;
        boolean multipleDefaultIntervalEndsEncountered = false;
        if (alreadyVisitedPiList.isEmpty()) {
            for (PropertyInfo pi : currentCi.properties().values()) {
                ShapeChangeResult.MessageContext mc;
                if (!Ldproxy2Target.isEncoded(pi)) continue;
                if (!this.valueTypeIsMapped(pi)) {
                    if (pi.typeClass() == null || !Ldproxy2Target.isEncoded(pi.typeClass())) {
                        ShapeChangeResult.MessageContext mc2 = this.result.addError(this, 124, pi.typeInfo().name, pi.name(), pi.inClass().name());
                        if (mc2 == null) continue;
                        mc2.addDetail(this, 1, pi.fullNameInSchema());
                        continue;
                    }
                    if (this.unsupportedCategoryOfValue(pi)) {
                        ShapeChangeResult.MessageContext mc3 = this.result.addError(this, 120, pi.typeInfo().name, pi.name(), pi.inClass().name());
                        if (mc3 == null) continue;
                        mc3.addDetail(this, 1, pi.fullNameInSchema());
                        continue;
                    }
                }
                if (pi.stereotype("identifier") && currentCi.matches("rule-ldp2-cls-identifierStereotype")) {
                    if (!multipleIdentifierPisEncountered) {
                        ShapeChangeResult.MessageContext mc4;
                        identifierPi = pi;
                        if (pi.cardinality().maxOccurs > 1 && (mc4 = this.result.addWarning(this, 104, currentCi.name(), pi.name())) != null) {
                            mc4.addDetail(this, 1, pi.fullNameInSchema());
                        }
                    } else {
                        multipleIdentifierPisEncountered = true;
                        ShapeChangeResult.MessageContext mc5 = this.result.addError(this, 107, pi.inClass().name(), pi.name(), identifierPi.name());
                        if (mc5 != null) {
                            mc5.addDetail(this, 1, pi.fullNameInSchema());
                        }
                    }
                }
                if (this.isTrueIgnoringCase(pi.taggedValue("defaultGeometry"))) {
                    if (!multipleDefaultGeometriesEncountered) {
                        defaultGeometryPi = pi;
                    } else {
                        multipleDefaultGeometriesEncountered = true;
                        ShapeChangeResult.MessageContext mc6 = this.result.addError(this, 105, pi.inClass().name(), pi.name(), defaultGeometryPi.name());
                        if (mc6 != null) {
                            mc6.addDetail(this, 1, pi.fullNameInSchema());
                        }
                    }
                }
                boolean isDefaultInstant = this.isTrueIgnoringCase(pi.taggedValue("defaultInstant"));
                boolean isDefaultIntervalStart = this.isTrueIgnoringCase(pi.taggedValue("defaultIntervalStart"));
                boolean isDefaultIntervalEnd = this.isTrueIgnoringCase(pi.taggedValue("defaultIntervalEnd"));
                if (isDefaultInstant && (isDefaultIntervalStart || isDefaultIntervalEnd)) {
                    mc = this.result.addError(this, 106, pi.inClass().name(), pi.name());
                    if (mc == null) continue;
                    mc.addDetail(this, 1, pi.fullNameInSchema());
                    continue;
                }
                if (isDefaultInstant) {
                    if (!multipleDefaultInstantsEncountered) {
                        defaultInstantPi = pi;
                        continue;
                    }
                    multipleDefaultInstantsEncountered = true;
                    mc = this.result.addError(this, 108, pi.inClass().name(), pi.name(), defaultInstantPi.name());
                    if (mc == null) continue;
                    mc.addDetail(this, 1, pi.fullNameInSchema());
                    continue;
                }
                if (isDefaultIntervalStart && isDefaultIntervalEnd) {
                    mc = this.result.addError(this, 109, pi.inClass().name(), pi.name());
                    if (mc == null) continue;
                    mc.addDetail(this, 1, pi.fullNameInSchema());
                    continue;
                }
                if (isDefaultIntervalStart) {
                    if (!multipleDefaultIntervalStartsEncountered) {
                        defaultIntervalStartPi = pi;
                        continue;
                    }
                    multipleDefaultIntervalStartsEncountered = true;
                    mc = this.result.addError(this, 110, pi.inClass().name(), pi.name(), defaultIntervalStartPi.name());
                    if (mc == null) continue;
                    mc.addDetail(this, 1, pi.fullNameInSchema());
                    continue;
                }
                if (!isDefaultIntervalEnd) continue;
                if (!multipleDefaultIntervalEndsEncountered) {
                    defaultIntervalEndPi = pi;
                    continue;
                }
                multipleDefaultIntervalEndsEncountered = true;
                mc = this.result.addError(this, 111, pi.inClass().name(), pi.name(), defaultIntervalEndPi.name());
                if (mc == null) continue;
                mc.addDetail(this, 1, pi.fullNameInSchema());
            }
            if (identifierPi == null || multipleIdentifierPisEncountered) {
                ImmutableFeatureSchema identifierMemberDef = new ImmutableFeatureSchema.Builder().name(objectIdentifierName).sourcePath(primaryKeyColumn).type(SchemaBase.Type.INTEGER).role(SchemaBase.Role.ID).build();
                propertyDefs.put(identifierMemberDef.getName(), identifierMemberDef);
            }
        }
        for (PropertyInfo pi : currentCi.properties().values()) {
            ImmutablePropertyTransformation trf;
            ImmutablePropertyTransformation trf2;
            ShapeChangeResult.MessageContext mc;
            if (!Ldproxy2Target.isEncoded(pi)) continue;
            if (!this.valueTypeIsMapped(pi)) {
                ShapeChangeResult.MessageContext mc7;
                if (pi.typeClass() == null || !Ldproxy2Target.isEncoded(pi.typeClass())) {
                    mc7 = this.result.addError(this, 124, pi.typeInfo().name, pi.name(), pi.inClass().name());
                    if (mc7 == null) continue;
                    mc7.addDetail(this, 1, pi.fullNameInSchema());
                    continue;
                }
                if (this.unsupportedCategoryOfValue(pi)) {
                    mc7 = this.result.addError(this, 120, pi.typeInfo().name, pi.name(), pi.inClass().name());
                    if (mc7 == null) continue;
                    mc7.addDetail(this, 1, pi.fullNameInSchema());
                    continue;
                }
            }
            ArrayList<PropertyInfo> nowVisitedList = new ArrayList<PropertyInfo>(alreadyVisitedPiList);
            nowVisitedList.add(pi);
            ImmutableFeatureSchema.Builder propMemberDefBuilder = new ImmutableFeatureSchema.Builder();
            SchemaBase.Type ldpType = this.ldproxyType(pi);
            if (pi.cardinality().maxOccurs > 1) {
                if (ldpType == SchemaBase.Type.OBJECT) {
                    propMemberDefBuilder.type(SchemaBase.Type.OBJECT_ARRAY);
                } else if (ldpType == SchemaBase.Type.GEOMETRY || pi == identifierPi) {
                    propMemberDefBuilder.type(ldpType);
                } else {
                    propMemberDefBuilder.type(SchemaBase.Type.VALUE_ARRAY);
                    propMemberDefBuilder.valueType(ldpType);
                }
            } else {
                propMemberDefBuilder.type(ldpType);
            }
            if (ldpType == SchemaBase.Type.GEOMETRY) {
                propMemberDefBuilder.geometryType(this.geometryType(pi));
            }
            Optional<SchemaBase.Role> propRole = identifierPi != null && !multipleIdentifierPisEncountered && pi == identifierPi ? Optional.of(SchemaBase.Role.ID) : (defaultGeometryPi != null && !multipleDefaultGeometriesEncountered && pi == defaultGeometryPi ? Optional.of(SchemaBase.Role.PRIMARY_GEOMETRY) : (defaultInstantPi != null && !multipleDefaultInstantsEncountered && pi == defaultInstantPi ? Optional.of(SchemaBase.Role.PRIMARY_INSTANT) : (defaultIntervalStartPi != null && !multipleDefaultIntervalStartsEncountered && pi == defaultIntervalStartPi ? Optional.of(SchemaBase.Role.PRIMARY_INTERVAL_START) : (defaultIntervalEndPi != null && !multipleDefaultIntervalEndsEncountered && pi == defaultIntervalEndPi ? Optional.of(SchemaBase.Role.PRIMARY_INTERVAL_END) : Optional.empty()))));
            propMemberDefBuilder.role(propRole);
            Optional<String> sourcePathProperty = this.sourcePathPropertyLevel(pi);
            boolean ignoreSourcePathOnPropertyLevel = false;
            if (this.isMappedToOrImplementedAsLink(pi)) {
                propMemberDefBuilder.objectType("Link");
                ignoreSourcePathOnPropertyLevel = pi.cardinality().maxOccurs == 1;
                LinkedHashMap<String, FeatureSchema> linkPropertyDefs = new LinkedHashMap<String, FeatureSchema>();
                String sourcePathInLinkProps = this.sourcePathLinkLevel(pi);
                linkPropertyDefs.put("title", new ImmutableFeatureSchema.Builder().name("title").label(pi.typeInfo().name + "-ID").type(SchemaBase.Type.STRING).sourcePath(sourcePathInLinkProps).build());
                ImmutableFeatureSchema.Builder linkPropHrefBuilder = new ImmutableFeatureSchema.Builder();
                linkPropHrefBuilder.name("href").label(pi.typeInfo().name + "-ID").type(SchemaBase.Type.STRING).sourcePath(sourcePathInLinkProps);
                linkPropHrefBuilder.addAllTransformationsBuilders(new ImmutablePropertyTransformation.Builder().stringFormat(this.urlTemplateForValueType(pi)));
                linkPropertyDefs.put("href", linkPropHrefBuilder.build());
                propMemberDefBuilder.propertyMap(linkPropertyDefs);
            } else if (pi.categoryOfValue() == 5) {
                ClassInfo typeCi = pi.typeClass();
                if (alreadyVisitedPiList.stream().anyMatch(vPi -> vPi.inClass() == typeCi) || typeCi == currentCi) {
                    ClassInfo topType = alreadyVisitedPiList.get(0).inClass();
                    ShapeChangeResult.MessageContext mc8 = this.result.addError(this, 117, topType.name(), this.propertyPath(nowVisitedList));
                    if (mc8 == null) continue;
                    mc8.addDetail(this, 0, topType.fullNameInSchema());
                    continue;
                }
                LinkedHashMap<String, FeatureSchema> datatypePropertyDefs = this.propertyDefinitions(typeCi, nowVisitedList);
                propMemberDefBuilder.propertyMap(datatypePropertyDefs);
                propMemberDefBuilder.objectType(typeCi.name());
            }
            if (StringUtils.isNotBlank((CharSequence)pi.initialValue()) && pi.isReadOnly() && pi.matches("rule-ldp2-prop-readOnly")) {
                propMemberDefBuilder.constantValue(this.constantValue(pi));
            } else if (!ignoreSourcePathOnPropertyLevel) {
                propMemberDefBuilder.sourcePath(sourcePathProperty);
            }
            Optional<Object> constraints = Optional.empty();
            boolean providerConfigConstraintCreated = false;
            ImmutableSchemaConstraints.Builder constraintsBuilder = new ImmutableSchemaConstraints.Builder();
            if (pi.cardinality().minOccurs != 0 && !pi.voidable()) {
                providerConfigConstraintCreated = true;
                constraintsBuilder.required(true);
            }
            if (pi.cardinality().maxOccurs > 1 && pi != identifierPi && pi != defaultGeometryPi && ldpType != SchemaBase.Type.GEOMETRY) {
                if (pi.voidable()) {
                    providerConfigConstraintCreated = true;
                    constraintsBuilder.minOccurrence(0);
                } else {
                    providerConfigConstraintCreated = true;
                    constraintsBuilder.minOccurrence(pi.cardinality().minOccurs);
                }
                if (pi.cardinality().maxOccurs != Integer.MAX_VALUE) {
                    providerConfigConstraintCreated = true;
                    constraintsBuilder.maxOccurrence(pi.cardinality().maxOccurs);
                }
            }
            if (this.isEnumerationOrCodelistValueType(pi) && !this.valueTypeIsMapped(pi)) {
                ClassInfo typeCi = pi.typeClass();
                providerConfigConstraintCreated = true;
                String codelistId = this.codelistId(typeCi);
                if (!codelistsAndEnumerations.contains(typeCi) && (mc = this.result.addWarning(this, 127, typeCi.name(), codelistId)) != null) {
                    mc.addDetail(this, 0, typeCi.fullNameInSchema());
                }
                constraintsBuilder.codelist(codelistId);
                if (pi.categoryOfValue() == 3 && typeCi.matches("rule-ldp2-cls-enumeration-enum-constraint")) {
                    constraintsBuilder.enumValues(this.enumValues(typeCi));
                }
                trf2 = new ImmutablePropertyTransformation.Builder().codelist(codelistId).build();
                this.addServiceConfigPropertyTransformation(((PropertyInfo)nowVisitedList.get(0)).inClass(), this.propertyPath(nowVisitedList), trf2);
            }
            if (providerConfigConstraintCreated) {
                constraints = Optional.of(constraintsBuilder.build());
            }
            propMemberDefBuilder.constraints(constraints);
            ImmutableFeatureSchema propMemberDef = propMemberDefBuilder.name(pi.name()).label(this.label(pi)).description(this.description(pi)).build();
            propertyDefs.put(pi.name(), propMemberDef);
            if (StringUtils.isNotBlank((CharSequence)pi.taggedValue("ldpRemove"))) {
                String tv = pi.taggedValue("ldpRemove").trim().toUpperCase(Locale.ENGLISH);
                if (tv.equals("IN_COLLECTION") || tv.equals("ALWAYS") || tv.equals("NEVER")) {
                    trf2 = new ImmutablePropertyTransformation.Builder().remove(tv).build();
                    this.addServiceConfigPropertyTransformation(((PropertyInfo)nowVisitedList.get(0)).inClass(), this.propertyPath(nowVisitedList), trf2);
                } else {
                    mc = this.result.addError(this, 122, pi.name(), pi.taggedValue("ldpRemove"));
                    if (mc != null) {
                        mc.addDetail(this, 1, pi.fullNameInSchema());
                    }
                }
            }
            if (ldpType == SchemaBase.Type.DATE && StringUtils.isNotBlank((CharSequence)dateFormat)) {
                trf = new ImmutablePropertyTransformation.Builder().dateFormat(dateFormat).build();
                this.addServiceConfigPropertyTransformation(((PropertyInfo)nowVisitedList.get(0)).inClass(), this.propertyPath(nowVisitedList), trf);
            }
            if (ldpType != SchemaBase.Type.DATETIME || !StringUtils.isNotBlank((CharSequence)dateTimeFormat)) continue;
            trf = new ImmutablePropertyTransformation.Builder().dateFormat(dateTimeFormat).build();
            this.addServiceConfigPropertyTransformation(((PropertyInfo)nowVisitedList.get(0)).inClass(), this.propertyPath(nowVisitedList), trf);
        }
        return propertyDefs;
    }

    private String sourcePathLinkLevel(PropertyInfo pi) {
        if (pi.cardinality().maxOccurs == 1) {
            return this.databaseColumnName(pi);
        }
        return primaryKeyColumn;
    }

    private void addServiceConfigPropertyTransformation(ClassInfo topLevelClass, String propertyPath, ImmutablePropertyTransformation trf) {
        SortedMap<Object, Object> serviceConfigTrfsByPropPath;
        if (this.serviceConfigPropertyTransformationsByTopLevelClass.containsKey(topLevelClass)) {
            serviceConfigTrfsByPropPath = this.serviceConfigPropertyTransformationsByTopLevelClass.get(topLevelClass);
        } else {
            serviceConfigTrfsByPropPath = new TreeMap();
            this.serviceConfigPropertyTransformationsByTopLevelClass.put(topLevelClass, serviceConfigTrfsByPropPath);
        }
        if (serviceConfigTrfsByPropPath.containsKey(propertyPath)) {
            ((List)serviceConfigTrfsByPropPath.get(propertyPath)).add(trf);
        } else {
            ArrayList<ImmutablePropertyTransformation> propTransforms = new ArrayList<ImmutablePropertyTransformation>();
            propTransforms.add(trf);
            serviceConfigTrfsByPropPath.put(propertyPath, propTransforms);
        }
    }

    private Iterable<String> enumValues(ClassInfo enumeration) {
        ArrayList<String> res = new ArrayList<String>();
        for (PropertyInfo pi : enumeration.properties().values()) {
            if (StringUtils.isNotBlank((CharSequence)pi.initialValue())) {
                res.add(pi.initialValue().trim());
                continue;
            }
            res.add(pi.name());
        }
        return res;
    }

    private boolean unsupportedCategoryOfValue(PropertyInfo pi) {
        return pi.categoryOfValue() == 8 || pi.categoryOfValue() == 7 || pi.categoryOfValue() == 4 || pi.categoryOfValue() == -1;
    }

    private boolean isMappedToOrImplementedAsLink(PropertyInfo pi) {
        if (this.valueTypeIsMapped(pi)) {
            return this.isMappedToLink(pi);
        }
        return this.isTypeWithIdentityValueType(pi);
    }

    private Optional<String> sourcePathPropertyLevel(PropertyInfo pi) {
        String typeName = pi.typeInfo().name;
        String typeId = pi.typeInfo().id;
        String encodingRule = pi.encodingRule("ldp2");
        ProcessMapEntry pme = mapEntryParamInfos.getMapEntry(typeName, encodingRule);
        if (pme != null && !this.ignoreMapEntryForTypeFromSchemaSelectedForProcessing(pme, typeId)) {
            if (pme.hasTargetType()) {
                if ("GEOMETRY".equalsIgnoreCase(pme.getTargetType())) {
                    return Optional.of(this.databaseColumnName(pi));
                }
                if ("LINK".equalsIgnoreCase(pme.getTargetType())) {
                    if (pi.cardinality().maxOccurs == 1) {
                        return Optional.empty();
                    }
                    return Optional.of("[" + this.primaryKeyColumn(pi.inClass()) + "=" + this.databaseTableName(pi.inClass(), true) + "]" + this.associativeTableName(pi));
                }
                if (pi.cardinality().maxOccurs == 1) {
                    return Optional.of(this.databaseColumnName(pi));
                }
                return Optional.of("[" + this.primaryKeyColumn(pi.inClass()) + "=" + this.databaseTableName(pi.inClass(), true) + "]" + this.associativeTableName(pi) + "{sortKey=" + this.databaseTableName(pi.inClass(), true) + "}/" + this.databaseColumnName(pi));
            }
            this.result.addError(this, 118, typeName);
            return Optional.of("FIXME");
        }
        ClassInfo typeCi = pi.typeClass();
        if (typeCi == null) {
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 118, typeName);
            if (mc != null) {
                mc.addDetail(this, 1, pi.fullNameInSchema());
            }
            return Optional.of("FIXME");
        }
        if (typeCi.category() == 3 || typeCi.category() == 2) {
            if (pi.cardinality().maxOccurs == 1) {
                return Optional.of(this.databaseColumnName(pi));
            }
            return Optional.of("[" + this.primaryKeyColumn(pi.inClass()) + "=" + this.databaseTableName(pi.inClass(), true) + "]" + this.associativeTableName(pi) + "{sortKey=" + this.databaseTableName(pi.inClass(), true) + "}/" + this.databaseColumnName(pi));
        }
        if (typeCi.category() == 5) {
            if (typeCi.matches("rule-ldp2-cls-data-types-oneToMany-severalTables")) {
                if (pi.cardinality().maxOccurs == 1) {
                    return Optional.of("[" + this.databaseColumnName(pi) + "=" + this.primaryKeyColumn(typeCi) + "]" + this.databaseTableName(typeCi, false));
                }
                return Optional.of("[" + this.primaryKeyColumn(pi.inClass()) + "=" + this.databaseTableName(pi.inClass(), true) + "]" + this.associativeTableName(pi));
            }
            if (pi.cardinality().maxOccurs == 1) {
                return Optional.of("[" + this.databaseColumnName(pi) + "=" + this.primaryKeyColumn(typeCi) + "]" + this.databaseTableName(typeCi, false));
            }
            return Optional.of("[" + this.primaryKeyColumn(pi.inClass()) + "=" + this.databaseTableName(pi.inClass(), true) + "]" + this.associativeTableName(pi) + "/[" + this.databaseTableName(typeCi, true) + "=" + this.primaryKeyColumn(typeCi) + "]" + this.databaseTableName(typeCi, false));
        }
        if (pi.reverseProperty() != null && pi.reverseProperty().isNavigable()) {
            if (pi.cardinality().maxOccurs > 1 && pi.reverseProperty().cardinality().maxOccurs > 1) {
                return Optional.of("[" + this.primaryKeyColumn(pi.inClass()) + "=" + this.databaseTableName(pi.inClass(), true) + "]" + this.associativeTableName(pi) + "/[" + this.databaseTableName(typeCi, true) + "=" + this.primaryKeyColumn(typeCi) + "]" + this.databaseTableName(typeCi, false));
            }
            if (pi.cardinality().maxOccurs > 1) {
                return Optional.of("[" + this.primaryKeyColumn(pi.inClass()) + "=" + this.databaseColumnName(pi.reverseProperty()) + "]" + this.databaseTableName(typeCi, false));
            }
            if (pi.reverseProperty().cardinality().maxOccurs > 1) {
                return Optional.of("[" + this.databaseColumnName(pi) + "=" + this.primaryKeyColumn(typeCi) + "]" + this.databaseTableName(typeCi, false));
            }
            return Optional.of("[" + this.databaseColumnName(pi) + "=" + this.primaryKeyColumn(typeCi) + "]" + this.databaseTableName(typeCi, false));
        }
        if (pi.cardinality().maxOccurs == 1) {
            return Optional.of("[" + this.databaseColumnName(pi) + "=" + this.primaryKeyColumn(typeCi) + "]" + this.databaseTableName(typeCi, false));
        }
        return Optional.of("[" + this.primaryKeyColumn(pi.inClass()) + "=" + this.databaseTableName(pi.inClass(), true) + "]" + this.associativeTableName(pi) + "/[" + this.databaseTableName(typeCi, true) + "=" + this.primaryKeyColumn(typeCi) + "]" + this.databaseTableName(typeCi, false));
    }

    private String primaryKeyColumn(ClassInfo ci) {
        if (ci.matches("rule-ldp2-cls-identifierStereotype")) {
            for (PropertyInfo pi : ci.properties().values()) {
                if (!pi.stereotype("identifier")) continue;
                return this.databaseColumnName(pi);
            }
        }
        return primaryKeyColumn;
    }

    private String associativeTableName(PropertyInfo pi) {
        if (StringUtils.isNotBlank((CharSequence)pi.taggedValue("associativeTable"))) {
            return pi.taggedValue("associativeTable");
        }
        if (pi.association() != null && StringUtils.isNotBlank((CharSequence)pi.association().taggedValue("associativeTable"))) {
            return pi.association().taggedValue("associativeTable");
        }
        String tableName = pi.inClass().name();
        String propertyName = pi.name();
        if (pi.association() != null && pi.reverseProperty().isNavigable() && pi.inClass().name().compareTo(pi.reverseProperty().inClass().name()) > 0) {
            tableName = pi.reverseProperty().inClass().name();
            propertyName = pi.reverseProperty().name();
        }
        String res = tableName + "_" + propertyName;
        return res;
    }

    private String constantValue(PropertyInfo pi) {
        String valueTypeName = pi.typeInfo().name;
        ProcessMapEntry pme = mapEntryParamInfos.getMapEntry(valueTypeName, pi.encodingRule("ldp2"));
        if (pme != null && !this.ignoreMapEntryForTypeFromSchemaSelectedForProcessing(pme, pi.typeInfo().id) && valueTypeName.equalsIgnoreCase("Boolean")) {
            if ("true".equalsIgnoreCase(pi.initialValue().trim())) {
                return (String)StringUtils.defaultIfBlank((CharSequence)mapEntryParamInfos.getCharacteristic(valueTypeName, pi.encodingRule("ldp2"), "initialValueEncoding", "false"), (CharSequence)"true");
            }
            if ("false".equalsIgnoreCase(pi.initialValue().trim())) {
                return (String)StringUtils.defaultIfBlank((CharSequence)mapEntryParamInfos.getCharacteristic(valueTypeName, pi.encodingRule("ldp2"), "initialValueEncoding", "false"), (CharSequence)"false");
            }
        }
        return pi.initialValue();
    }

    private String urlTemplateForValueType(PropertyInfo pi) {
        Object urlTemplate = null;
        String valueTypeName = pi.typeInfo().name;
        ProcessMapEntry pme = mapEntryParamInfos.getMapEntry(valueTypeName, pi.encodingRule("ldp2"));
        if (pme != null && !this.ignoreMapEntryForTypeFromSchemaSelectedForProcessing(pme, pi.typeInfo().id) && "LINK".equalsIgnoreCase(pme.getTargetType())) {
            urlTemplate = mapEntryParamInfos.getCharacteristic(valueTypeName, pi.encodingRule("ldp2"), "linkInfos", "urlTemplate");
            urlTemplate = ((String)urlTemplate).replaceAll("\\(value\\)", "{{value}}").replaceAll("\\(serviceUrl\\)", "{{serviceUrl}}");
        }
        if (StringUtils.isBlank(urlTemplate)) {
            urlTemplate = "{{serviceUrl}}/collections/" + valueTypeName.toLowerCase(Locale.ENGLISH) + "/items/{{value}}";
        }
        return urlTemplate;
    }

    private String propertyPath(List<PropertyInfo> propertyList) {
        return propertyList.stream().map(pi -> pi.name()).collect(Collectors.joining("."));
    }

    private boolean isMappedToLink(PropertyInfo pi) {
        return this.isMappedToLink(pi.typeInfo().name, pi.typeInfo().id, pi.encodingRule("ldp2"));
    }

    private boolean isMappedToLink(String typeName, String typeId, String encodingRule) {
        ProcessMapEntry pme = mapEntryParamInfos.getMapEntry(typeName, encodingRule);
        return pme != null && !this.ignoreMapEntryForTypeFromSchemaSelectedForProcessing(pme, typeId) && pme.hasTargetType() && "LINK".equalsIgnoreCase(pme.getTargetType());
    }

    private boolean valueTypeIsMapped(PropertyInfo pi) {
        return this.valueTypeIsMapped(pi.typeInfo().name, pi.typeInfo().id, pi.encodingRule("ldp2"));
    }

    private boolean valueTypeIsMapped(String typeName, String typeId, String encodingRule) {
        ProcessMapEntry pme = mapEntryParamInfos.getMapEntry(typeName, encodingRule);
        return pme != null && !this.ignoreMapEntryForTypeFromSchemaSelectedForProcessing(pme, typeId);
    }

    private boolean isLdproxyGeometryType(SchemaBase.Type t) {
        return t == SchemaBase.Type.GEOMETRY;
    }

    private boolean isLdproxySimpleType(SchemaBase.Type t) {
        switch (t) {
            case STRING: 
            case BOOLEAN: 
            case DATE: 
            case DATETIME: 
            case INTEGER: 
            case FLOAT: {
                return true;
            }
        }
        return false;
    }

    private boolean isEnumerationOrCodelistValueType(PropertyInfo pi) {
        return pi.categoryOfValue() == 3 || pi.categoryOfValue() == 2;
    }

    private boolean isTypeWithIdentityValueType(PropertyInfo pi) {
        return pi.categoryOfValue() == 1 || pi.categoryOfValue() == 6;
    }

    private SchemaBase.Type ldproxyType(PropertyInfo pi) {
        return this.ldproxyType(pi.typeInfo().name, pi.typeInfo().id, pi.encodingRule("ldp2"));
    }

    private SchemaBase.Type ldproxyType(String typeName, String typeId, String encodingRule) {
        SchemaBase.Type resType = SchemaBase.Type.STRING;
        ProcessMapEntry pme = mapEntryParamInfos.getMapEntry(typeName, encodingRule);
        if (pme != null && !this.ignoreMapEntryForTypeFromSchemaSelectedForProcessing(pme, typeId)) {
            if (pme.hasTargetType()) {
                resType = "GEOMETRY".equalsIgnoreCase(pme.getTargetType()) ? SchemaBase.Type.GEOMETRY : ("LINK".equalsIgnoreCase(pme.getTargetType()) ? SchemaBase.Type.OBJECT : SchemaBase.Type.valueOf(pme.getTargetType().trim().toUpperCase(Locale.ENGLISH)));
            } else {
                this.result.addError(this, 112, typeName);
            }
        } else {
            ClassInfo valueType = null;
            if (StringUtils.isNotBlank((CharSequence)typeId)) {
                valueType = model.classById(typeId);
            }
            if (valueType == null && StringUtils.isNotBlank((CharSequence)typeName)) {
                valueType = model.classByName(typeName);
            }
            if (valueType == null) {
                this.result.addError(this, 113, typeName);
            } else if (!Ldproxy2Target.isEncoded(valueType)) {
                this.result.addError(this, 114, typeName);
            } else {
                resType = valueType.category() == 3 || valueType.category() == 2 ? (!valueType.matches("rule-ldp2-cls-codelist-targetbytaggedvalue") && StringUtils.isNotBlank((CharSequence)valueType.taggedValue("numericType")) ? this.ldproxyType(valueType.taggedValue("numericType"), null, valueType.encodingRule("ldp2")) : SchemaBase.Type.STRING) : SchemaBase.Type.OBJECT;
            }
        }
        return resType;
    }

    private Optional<SimpleFeatureGeometry> geometryType(PropertyInfo pi) {
        String typeName = pi.typeInfo().name;
        String typeId = pi.typeInfo().id;
        String encodingRule = pi.encodingRule("ldp2");
        SimpleFeatureGeometry res = SimpleFeatureGeometry.ANY;
        ProcessMapEntry pme = mapEntryParamInfos.getMapEntry(typeName, encodingRule);
        if (pme != null && !this.ignoreMapEntryForTypeFromSchemaSelectedForProcessing(pme, typeId) && pme.hasTargetType() && "GEOMETRY".equalsIgnoreCase(pme.getTargetType()) && mapEntryParamInfos.hasCharacteristic(typeName, encodingRule, "geometryInfos", "geometryType")) {
            String t = mapEntryParamInfos.getCharacteristic(typeName, encodingRule, "geometryInfos", "geometryType");
            res = SimpleFeatureGeometry.valueOf(t.toUpperCase(Locale.ENGLISH));
        } else {
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 121, pi.name(), pi.typeInfo().name);
            if (mc != null) {
                mc.addDetail(this, 1, pi.fullNameInSchema());
            }
        }
        return Optional.of(res);
    }

    private boolean isTrueIgnoringCase(String s) {
        return StringUtils.isNotBlank((CharSequence)s) && "true".equalsIgnoreCase(s.trim());
    }

    private Optional<String> featureTitleTemplate(ClassInfo ci) {
        String tv = ci.taggedValue("ldpFeatureTitleTemplate");
        if (StringUtils.isBlank((CharSequence)tv)) {
            return Optional.empty();
        }
        return Optional.of(tv.trim());
    }

    private ImmutableCodelistData createCodelistEntity(ClassInfo ci) {
        String label;
        String id = this.codelistId(ci);
        Optional<String> labelOpt = this.label(ci);
        if (labelOpt.isEmpty()) {
            ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 102, ci.name());
            if (mc != null) {
                mc.addDetail(this, 1, ci.fullNameInSchema());
            }
            label = ci.name();
        } else {
            label = labelOpt.get();
        }
        ImmutableCodelistData icd = cfg.builder().entity().codelist().id(id).label(label).sourceType(CodelistData.IMPORT_TYPE.TEMPLATES).build();
        if (!ci.properties().isEmpty()) {
            TreeMap<String, String> entries = new TreeMap<String, String>();
            for (PropertyInfo pi : ci.properties().values()) {
                ShapeChangeResult.MessageContext mc;
                String code = null;
                String targetValue = null;
                if (ci.matches("rule-ldp2-cls-codelist-direct")) {
                    targetValue = pi.name();
                    if (StringUtils.isBlank((CharSequence)pi.initialValue())) {
                        mc = this.result.addWarning(this, 100, ci.name(), pi.name());
                        if (mc != null) {
                            mc.addDetail(this, 1, pi.fullNameInSchema());
                        }
                        code = pi.name();
                    } else {
                        code = pi.initialValue();
                    }
                } else if (ci.matches("rule-ldp2-cls-codelist-targetbytaggedvalue")) {
                    code = StringUtils.isBlank((CharSequence)pi.initialValue()) ? pi.name() : pi.initialValue();
                    if (StringUtils.isBlank((CharSequence)pi.taggedValue("ldpCodeTargetValue"))) {
                        mc = this.result.addWarning(this, 101, ci.name(), pi.name());
                        if (mc != null) {
                            mc.addDetail(this, 1, pi.fullNameInSchema());
                        }
                        targetValue = pi.name();
                    } else {
                        targetValue = pi.taggedValue("ldpCodeTargetValue").trim();
                    }
                } else {
                    code = pi.name();
                    targetValue = pi.name();
                }
                entries.put(code, targetValue);
            }
            icd = icd.withEntries(entries);
        }
        if (StringUtils.isNotBlank((CharSequence)ci.taggedValue("ldpFallbackValue"))) {
            icd = icd.withFallback(ci.taggedValue("ldpFallbackValue").trim());
        }
        if (isUnitTest) {
            icd = icd.withCreatedAt(1000000000000L).withLastModified(1000000000000L);
        }
        return icd;
    }

    private String databaseTableName(ClassInfo ci, boolean isAssociativeTableContext) {
        Object result = ci.name();
        if (isAssociativeTableContext) {
            result = (String)result + associativeTableColumnSuffix;
        }
        result = ((String)result).toLowerCase(Locale.ENGLISH);
        result = StringUtils.substring((String)result, (int)0, (int)maxNameLength);
        return result;
    }

    private String databaseColumnName(PropertyInfo pi) {
        Object result = pi.name();
        SchemaBase.Type t = this.ldproxyType(pi);
        if (!this.isLdproxySimpleType(t) && !this.isLdproxyGeometryType(t)) {
            if (this.valueTypeIsTypeWithIdentity(pi)) {
                result = (String)result + foreignKeyColumnSuffix;
            } else if (pi.categoryOfValue() == 5) {
                result = (String)result + foreignKeyColumnSuffixDatatype;
            }
        }
        result = ((String)result).toLowerCase(Locale.ENGLISH);
        result = StringUtils.substring((String)result, (int)0, (int)maxNameLength);
        return result;
    }

    private boolean valueTypeIsTypeWithIdentity(PropertyInfo pi) {
        return pi.categoryOfValue() == 1 || pi.categoryOfValue() == 6;
    }

    private String codelistId(ClassInfo ci) {
        return ci.name().replaceAll("\\W", "_");
    }

    private Optional<String> label(Info i) {
        if (i != null && StringUtils.isNotBlank((CharSequence)labelTemplate) && i.matches("rule-ldp2-all-documentation")) {
            String label = i.derivedDocumentation(labelTemplate, descriptorNoValue);
            return StringUtils.isBlank((CharSequence)label) ? Optional.empty() : Optional.of(label);
        }
        return Optional.empty();
    }

    private Optional<String> description(Info i) {
        if (i != null && StringUtils.isNotBlank((CharSequence)descriptionTemplate) && i.matches("rule-ldp2-all-documentation")) {
            String description = i.derivedDocumentation(descriptionTemplate, descriptorNoValue);
            return StringUtils.isBlank((CharSequence)description) ? Optional.empty() : Optional.of(description);
        }
        return Optional.empty();
    }

    @Override
    public void reset() {
        model = null;
        initialised = false;
        diagnosticsOnly = false;
        numberOfEncodedSchemas = 0;
        isUnitTest = false;
        dbSchemaNames = new TreeSet<String>();
        associativeTableColumnSuffix = null;
        cfgTemplatePath = "https://shapechange.net/resources/templates/ldproxy2/cfgTemplate.yml";
        dateFormat = null;
        dateTimeFormat = null;
        descriptionTemplate = "[[definition]]";
        descriptorNoValue = "";
        forceAxisOrder = EpsgCrs.Force.NONE;
        foreignKeyColumnSuffix = "";
        foreignKeyColumnSuffixDatatype = "";
        labelTemplate = "[[alias]]";
        maxNameLength = 63;
        nativeTimeZone = ZoneId.systemDefault();
        objectIdentifierName = "oid";
        primaryKeyColumn = "id";
        serviceDescription = "FIXME";
        serviceLabel = "FIXME";
        srid = 4326;
        serviceConfigTemplatePathString = null;
        outputDirectory = null;
        dataDirectoryFile = null;
        mainId = null;
        mapEntryParamInfos = null;
        typesWithIdentity = new ArrayList<ClassInfo>();
        codelistsAndEnumerations = new TreeSet<ClassInfo>();
        cfg = null;
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
        r.addRule("rule-ldp2-all-documentation");
        r.addRule("rule-ldp2-all-notEncoded");
        r.addRule("rule-ldp2-all-schemas");
        r.addRule("rule-ldp2-cls-codelist-direct");
        r.addRule("rule-ldp2-cls-codelist-targetbytaggedvalue");
        r.addRule("rule-ldp2-cls-data-types-oneToMany-severalTables");
        r.addRule("rule-ldp2-cls-enumeration-enum-constraint");
        r.addRule("rule-ldp2-cls-identifierStereotype");
        r.addRule("rule-ldp2-prop-readOnly");
    }

    @Override
    public String getDefaultEncodingRule() {
        return "*";
    }

    @Override
    public String getTargetName() {
        return "Ldproxy (v2)";
    }

    @Override
    public String getTargetIdentifier() {
        return "ldp2";
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class '$1$'";
            }
            case 1: {
                return "Context: property '$1$'";
            }
            case 3: {
                return "Context: class Ldproxy2Target";
            }
            case 4: {
                return "Processing class '$1$'.";
            }
            case 5: {
                return "Directory named '$1$' does not exist or is not accessible.";
            }
            case 6: {
                return "System error: Exception encountered. Message is: '$1$'";
            }
            case 7: {
                return "Schema '$1$' is not encoded.";
            }
            case 8: {
                return "Class '$1$' is not encoded.";
            }
            case 15: {
                return "No map entries provided via the configuration.";
            }
            case 16: {
                return "Value '$1$' of configuration parameter $2$ does not match the regular expression: $3$. The parameter will be ignored.";
            }
            case 17: {
                return "Type '$1$' is of a category not enabled for conversion, meaning that no ldproxy configuration items will be created to represent it.";
            }
            case 18: {
                return "Schema '$1$' is not encoded. Thus class '$2$' (which belongs to that schema) is not encoded either.";
            }
            case 19: {
                return "";
            }
            case 20: {
                return "Type '$1$' is abstract. Conversion of abstract types is not supported by this target. The type will be ignored. Apply inheritance flattening (a model transformation) in order to handle abstract supertypes.";
            }
            case 21: {
                return "Value '$1$' of configuration parameter '$2$' does not result in a valid path. Exception message is: $3$";
            }
            case 22: {
                return "Type '$1$' has been mapped to '$2$', as defined by the configuration.";
            }
            case 23: {
                return "";
            }
            case 100: {
                return "rule-ldp2-cls-codelist-direct applies to codelist/enumeration '$1$'. However, code/enum '$2$' has no initial value. The code/enum cannot be encoded as defined by the conversion rule. Using the property name as fallback for the {code} in the enum/code mapping.";
            }
            case 101: {
                return "rule-ldp2-cls-codelist-targetbytaggedvalue applies to codelist/enumeration '$1$'. However, code/enum '$2$' does not have a non-blank value for tag 'ldpCodeTargetValue'. The code/enum cannot be encoded as defined by the conversion rule. Using the property name as fallback for the {target_value} in the enum/code mapping";
            }
            case 102: {
                return "Could not compute a label for codelist/enumeration '$1$'. A label is required for the ldproxy encoding as a codelist. Check the label template in the target configuration as well as the codelist/enumeration model, to ensure that a label can be created. Using the type name as label.";
            }
            case 103: {
                return "Type '$1$' has one or more supertypes. Conversion of inheritance relationships is not supported by this target. The relationship will be ignored. Apply inheritance flattening (a model transformation) in order to handle inheritance relationships.";
            }
            case 104: {
                return "Type '$1$' has <<identifier>> property '$2$', with max multiplicity greater 1. Encoding will assume a max multiplicity of exactly 1.";
            }
            case 105: {
                return "Property '$3$' of type '$1$' is marked (via tagged value 'defaultGeometry') as default geometry property. So is property '$2$'. Multiple default geometry properties per type are not allowed. None will be marked as default geometry.";
            }
            case 106: {
                return "Property '$2$' of type '$1$' is marked as default instant as well as as default interval (start and/or end) via according tagged values. That is an invalid combination. The property is not recognized as defining a primary temporal property.";
            }
            case 107: {
                return "Property '$3$' of type '$1$' is marked (via stereotype 'identifier') as identifier property. So is property '$2$'. Multiple identifier properties per type are not allowed. None will be used as identifier (because no informed decision can be made).";
            }
            case 108: {
                return "Property '$3$' of type '$1$' is marked (via tagged value 'defaultInstant') as default (temporal) instant property. So is property '$2$'. Multiple default instant properties per type are not allowed. None will be marked as default instant.";
            }
            case 109: {
                return "Property '$2$' of type '$1$' is marked as default interval start as well as default interval end via according tagged values. That is an invalid combination. The property is not recognized as defining a primary temporal property.";
            }
            case 110: {
                return "Property '$3$' of type '$1$' is marked (via tagged value 'defaultIntervalStart') as default (temporal) interval start property. So is property '$2$'. Multiple default interval start properties per type are not allowed. None will be marked as default interval start.";
            }
            case 111: {
                return "Property '$3$' of type '$1$' is marked (via tagged value 'defaultIntervalEnd') as default (temporal) interval end property. So is property '$2$'. Multiple default interval end properties per type are not allowed. None will be marked as default interval end.";
            }
            case 112: {
                return "??No target type is defined in map entry for type '$1$'. Assuming ldproxy type 'STRING'.";
            }
            case 113: {
                return "??Ldproxy type definition for type '$1$' could not be identified. No map entry is defined for the type, and the type was not found in the model. Assuming ldproxy type 'STRING'.";
            }
            case 114: {
                return "??Type '$1$' is marked to not be encoded. Could not identify an ldproxy type for it. Assuming ldproxy type 'STRING'.";
            }
            case 115: {
                return "??Type '$1$' is not part of the schemas selected for processing. Could not identify an ldproxy type for it. Assuming ldproxy type 'STRING'.";
            }
            case 116: {
                return "??Expected simple ldproxy type implementation of value type '$1$' of property '$2$' in class '$3$'. Found '$4$'. Assuming ldproxy type 'STRING'.";
            }
            case 117: {
                return "??Circular dependency detected when encoding type '$1$'. The property path '$2$' would create a circle. The last property in that path will not be encoded.";
            }
            case 118: {
                return "??No target type is defined in map entry for type '$1$'. Setting source path for properties with this type as value type to 'FIXME'.";
            }
            case 119: {
                return "??Value type '$1$' of property '$2$' is neither mapped nor found in the model. Is there a typo in value type name? Has the type not been loaded (e.g. by excluding some package during model loading) or removed (e.g. through a transformation)? Setting source path for the property to 'FIXME'.";
            }
            case 120: {
                return "??The value type '$1$' of property '$2$' (of class '$3$') is not mapped and of a category not supported by this target. The property will not be encoded. Either define a mapping for the value type or apply a model transform (e.g. flattening inheritance or flattening complex types [including unions]) to cope with this situation.";
            }
            case 121: {
                return "??No geometry type defined via map entry for value type '$2$' of property '$1$'. Ensure that map entries are configured correctly. Proceeding with geometry type ANY.";
            }
            case 122: {
                return "??Value of tag 'ldpRemove' on property '$1$' is invalid. Allowed values are: IN_COLLECTION, ALWAYS, NEVER (case is ignored when parsing the value). Found value '$2$'.";
            }
            case 123: {
                return "Exception occurred while copying the template defined by target parameter '$1$' from '$2$' to '$3$'. Exception message is: '$3$'.";
            }
            case 124: {
                return "??The value type '$1$' of property '$2$' (of class '$3$') is not mapped and either not present in the model, not correctly linked, or not encoded. The property will therefore not be encoded. Either define a mapping for the value type, or ensure that the value type is correctly linked to and that it actually is defined to be encoded by this target.";
            }
            case 125: {
                return "Type '$1$' will be ignored, because a type with equal name (ignoring case) has already been encountered and marked for encoding by the target. The target does not support encoding of multiple types with equal name (ignoring case).";
            }
            case 126: {
                return "";
            }
            case 127: {
                return "??Enumeration or code list '$1$', which is used as value type of at least one property that is encoded by the target, is either not encoded, not mapped, or not part of the schemas selected for processing. This is an issue UNLESS an ldproxy codelist with id '$2$' has already been or will be established for the desired deployment by other means (e.g. manually created).";
            }
            case 10001: {
                return "Generating ldproxy configuration items for application schema $1$.";
            }
            case 10002: {
                return "Diagnostics-only mode. All output to files is suppressed.";
            }
        }
        return "(" + Ldproxy2Target.class.getName() + ") Unknown message with number: " + mnr;
    }
}

