/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Ldproxy;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Ldproxy.Config;
import java.io.File;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ConfigConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("template1toNTable", "taggedValueForCodeListUrl", "featureTypes", "filterableFields", "foreignKeySuffix", "geometryFieldName", "geometryTableName", "htmlLabels", "fieldNameMaxLength", "templateNtoMTable", "outputDirectory", "prettyPrint", "primaryKeyField", "enablePropertiesReportable", "rootCollectionField", "rootFeatureTable", "secured", "serviceDescription", "serviceId", "serviceLabel", "serviceVersion", "trigger_onDelete", "_unitTestOverride").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;

    @Override
    public boolean isValid(ProcessConfiguration pConfig, Options options, ShapeChangeResult result) {
        String sid;
        File outputDirectoryFile;
        boolean exi;
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTargetParameters());
        isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, pConfig.getParameters().keySet(), result) && isValid;
        String outputDirectory = pConfig.getParameterValue("outputDirectory");
        if (outputDirectory == null) {
            outputDirectory = options.parameter("outputDirectory");
        }
        if (outputDirectory == null) {
            outputDirectory = ".";
        }
        if (!(exi = (outputDirectoryFile = new File(outputDirectory)).exists())) {
            outputDirectoryFile.mkdirs();
            exi = outputDirectoryFile.exists();
        }
        boolean dir = outputDirectoryFile.isDirectory();
        boolean wrt = outputDirectoryFile.canWrite();
        boolean rea = outputDirectoryFile.canRead();
        if (!(exi && dir && wrt && rea)) {
            isValid = false;
            result.addError(this, 2, outputDirectory);
        }
        if (pConfig.hasParameter("serviceId") && !(sid = options.parameter(Config.class.getName(), "serviceId")).matches("^[a-zA-Z_][a-zA-Z0-9_]+$")) {
            result.addError(this, 1, sid);
            isValid = false;
        }
        if (pConfig.hasParameter("fieldNameMaxLength")) {
            String s = options.parameter(Config.class.getName(), "fieldNameMaxLength");
            try {
                Integer.valueOf(s);
            }
            catch (Exception e) {
                result.addError(this, 3, "fieldNameMaxLength", s);
                isValid = false;
            }
        }
        return isValid;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "The id of a service must be alphanumeric (underscore is allowed). The first character must be a letter or an underscore. Found: '$1$'.";
            }
            case 2: {
                return "Output directory '$1$' does not exist or is not accessible.";
            }
            case 3: {
                return "The parameter '$1$' must be an integer. Found: '$2$'.";
            }
        }
        return "(ModelExport.java) Unknown message with number: " + mnr;
    }
}

