/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Ldproxy;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeErrorHandler;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SingleTarget;
import de.interactive_instruments.ShapeChange.Type;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Config
implements SingleTarget,
MessageSource {
    private static boolean initialised = false;
    private static String outputDirectory = null;
    private static String directoryCL = null;
    private static String srvid = null;
    private static String srvlabel = null;
    private static String srvdesc = null;
    private static String srvversion = null;
    private static Boolean secured = false;
    private static String primaryKeyField = null;
    private static String foreignKeySuffix = null;
    private static Integer maxLength = null;
    private static String geometryTable = null;
    private static String geometryField = null;
    private static String templateNtoM = null;
    private static String template1toN = null;
    private static String rootFeatureTable = null;
    private static String rootCollectionField = null;
    private static Set<String> filterableFields = null;
    private static Set<String> htmlLabelFields = null;
    private static Set<String> featureTypes = null;
    private static String clUrlTV = null;
    private static Set<String> reportables = null;
    private static Set<String> trigger_onDelete = null;
    private static TreeMap<String, Object> cfgobj = null;
    private static TreeMap<String, Object> cfgobjGeojson = null;
    private static TreeMap<String, Object> cfgobjGml = null;
    private static TreeMap<String, Object> collections = null;
    private static TreeMap<String, Object> mappings = null;
    private static OutputStreamWriter writer = null;
    private static OutputStreamWriter writerGeojson = null;
    private static OutputStreamWriter writerGml = null;
    private static Map<String, TreeMap<String, Object>> mapCL = null;
    private static Model model = null;
    private Options options = null;
    private ShapeChangeResult result = null;
    private int priority = 0;

    @Override
    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        this.options = o;
        this.result = r;
        try {
            if (!initialised) {
                String[] sarr;
                String s;
                File outputDirectoryFile;
                boolean exi;
                initialised = true;
                model = m;
                outputDirectory = this.options.parameter(Config.class.getName(), "outputDirectory");
                if (outputDirectory == null) {
                    outputDirectory = this.options.parameter("outputDirectory");
                }
                if (outputDirectory == null) {
                    outputDirectory = ".";
                }
                if (!(exi = (outputDirectoryFile = new File(outputDirectory)).exists())) {
                    outputDirectoryFile.mkdirs();
                    exi = outputDirectoryFile.exists();
                }
                boolean dir = outputDirectoryFile.isDirectory();
                boolean wrt = outputDirectoryFile.canWrite();
                boolean rea = outputDirectoryFile.canRead();
                if (!(exi && dir && wrt && rea)) {
                    this.result.addFatalError(this, 6, outputDirectory);
                    throw new ShapeChangeAbortException();
                }
                String directoryMain = outputDirectory + "/config-store/entities/services";
                File outputDirectoryFileMain = new File(directoryMain);
                exi = outputDirectoryFileMain.exists();
                if (!exi) {
                    outputDirectoryFileMain.mkdirs();
                    exi = outputDirectoryFileMain.exists();
                }
                dir = outputDirectoryFileMain.isDirectory();
                wrt = outputDirectoryFileMain.canWrite();
                rea = outputDirectoryFileMain.canRead();
                if (!(exi && dir && wrt && rea)) {
                    this.result.addFatalError(this, 6, directoryMain);
                    throw new ShapeChangeAbortException();
                }
                directoryCL = outputDirectory + "/config-store/entities/codelists";
                File outputDirectoryFileCL = new File((String)directoryCL);
                exi = outputDirectoryFileCL.exists();
                if (!exi) {
                    outputDirectoryFileCL.mkdirs();
                    exi = outputDirectoryFileCL.exists();
                }
                dir = outputDirectoryFileCL.isDirectory();
                wrt = outputDirectoryFileCL.canWrite();
                rea = outputDirectoryFileCL.canRead();
                if (!(exi && dir && wrt && rea)) {
                    this.result.addFatalError(this, 6, directoryCL);
                    throw new ShapeChangeAbortException();
                }
                String directoryGeojson = outputDirectory + "/config-store/settings/ldproxy-target-geojson/#overrides#";
                File outputDirectoryFileGeojson = new File(directoryGeojson);
                exi = outputDirectoryFileGeojson.exists();
                if (!exi) {
                    outputDirectoryFileGeojson.mkdirs();
                    exi = outputDirectoryFileGeojson.exists();
                }
                dir = outputDirectoryFileGeojson.isDirectory();
                wrt = outputDirectoryFileGeojson.canWrite();
                rea = outputDirectoryFileGeojson.canRead();
                if (!(exi && dir && wrt && rea)) {
                    this.result.addFatalError(this, 6, directoryGeojson);
                    throw new ShapeChangeAbortException();
                }
                String directoryGml = outputDirectory + "/config-store/settings/ldproxy-target-gml/#overrides#";
                File outputDirectoryFileGml = new File(directoryGml);
                exi = outputDirectoryFileGml.exists();
                if (!exi) {
                    outputDirectoryFileGml.mkdirs();
                    exi = outputDirectoryFileGml.exists();
                }
                dir = outputDirectoryFileGml.isDirectory();
                wrt = outputDirectoryFileGml.canWrite();
                rea = outputDirectoryFileGml.canRead();
                if (!(exi && dir && wrt && rea)) {
                    this.result.addFatalError(this, 6, directoryGml);
                    throw new ShapeChangeAbortException();
                }
                PackageInfo first = model.allPackagesFromSelectedSchemas().isEmpty() ? null : model.allPackagesFromSelectedSchemas().first();
                srvid = this.options.parameter(Config.class.getName(), "serviceId");
                if (srvid == null) {
                    String string = srvid = first != null ? first.xmlns() : null;
                }
                if (srvid == null) {
                    srvid = "fixme";
                }
                if ((srvlabel = this.options.parameter(Config.class.getName(), "serviceLabel")) == null) {
                    String string = first != null ? (first.aliasName() != null && first.aliasName().length() > 0 ? first.aliasName() : first.name()) : (srvlabel = "Some Dataset");
                }
                if ((srvdesc = this.options.parameter(Config.class.getName(), "serviceDescription")) == null) {
                    String string = first != null ? (first.documentation() != null ? first.documentation() : first.definition()) : (srvdesc = "");
                }
                if ((srvversion = this.options.parameter(Config.class.getName(), "serviceVersion")) == null) {
                    srvversion = "1.0.0";
                }
                if ((s = this.options.parameter(Config.class.getName(), "secured")) != null && s.equalsIgnoreCase("true")) {
                    secured = true;
                }
                if ((primaryKeyField = this.options.parameter(Config.class.getName(), "primaryKeyField")) == null) {
                    primaryKeyField = "id";
                }
                if ((foreignKeySuffix = this.options.parameter(Config.class.getName(), "foreignKeySuffix")) == null) {
                    foreignKeySuffix = "_id";
                }
                if ((geometryTable = this.options.parameter(Config.class.getName(), "geometryTableName")) == null) {
                    geometryTable = "geom";
                }
                if ((geometryField = this.options.parameter(Config.class.getName(), "geometryFieldName")) == null) {
                    geometryField = "geom";
                }
                if ((templateNtoM = this.options.parameter(Config.class.getName(), "templateNtoMTable")) == null) {
                    templateNtoM = "{{class}}_2_{{property}}";
                }
                if ((template1toN = this.options.parameter(Config.class.getName(), "template1toNTable")) == null) {
                    template1toN = "{{class}}_{{property}}";
                }
                if ((rootFeatureTable = this.options.parameter(Config.class.getName(), "rootFeatureTable")) == null) {
                    rootFeatureTable = "root";
                }
                if ((rootCollectionField = this.options.parameter(Config.class.getName(), "rootCollectionField")) == null) {
                    rootCollectionField = "collection";
                }
                filterableFields = new TreeSet<String>();
                s = this.options.parameter(Config.class.getName(), "filterableFields");
                if (s != null) {
                    for (String s2 : sarr = s.split(",")) {
                        filterableFields.add(s2.trim());
                    }
                }
                htmlLabelFields = new TreeSet<String>();
                s = this.options.parameter(Config.class.getName(), "htmlLabels");
                if (s != null) {
                    for (String s2 : sarr = s.split(",")) {
                        htmlLabelFields.add(s2.trim());
                    }
                }
                featureTypes = new TreeSet<String>();
                s = this.options.parameter(Config.class.getName(), "featureTypes");
                if (s != null) {
                    for (String s2 : sarr = s.split(",")) {
                        featureTypes.add(s2.trim().toLowerCase());
                    }
                }
                if ((s = this.options.parameter(Config.class.getName(), "fieldNameMaxLength")) != null) {
                    maxLength = Integer.valueOf(s);
                }
                if (maxLength == null) {
                    maxLength = 60;
                }
                if ((s = this.options.parameter(Config.class.getName(), "taggedValueForCodeListUrl")) != null) {
                    clUrlTV = s.trim();
                }
                if (clUrlTV == null) {
                    clUrlTV = "codeList";
                }
                reportables = new TreeSet<String>();
                s = this.options.parameter(Config.class.getName(), "enablePropertiesReportable");
                if (s != null) {
                    for (String s2 : sarr = s.split(",")) {
                        reportables.add(s2.trim().toLowerCase());
                    }
                }
                trigger_onDelete = new TreeSet<String>();
                s = this.options.parameter(Config.class.getName(), "trigger_onDelete");
                if (s != null) {
                    for (String s2 : sarr = s.split(";")) {
                        trigger_onDelete.add(s2.trim());
                    }
                }
                if (!diagOnly) {
                    writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(directoryMain + "/" + srvid + ".json")), StandardCharsets.UTF_8);
                    writerGeojson = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(directoryGeojson + "/GeoJsonConfig.json")), StandardCharsets.UTF_8);
                    writerGml = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(directoryGml + "/GmlConfig.json")), StandardCharsets.UTF_8);
                }
                cfgobj = new TreeMap();
                cfgobj.put("id", srvid);
                cfgobj.put("label", srvlabel);
                cfgobj.put("description", srvdesc);
                cfgobj.put("serviceType", "WFS3");
                cfgobj.put("shouldStart", true);
                cfgobj.put("secured", secured);
                long now = System.currentTimeMillis();
                if (this.options.parameter(Config.class.getName(), "_unitTestOverride") != null) {
                    now = 1531327916566L;
                }
                cfgobj.put("createdAt", now);
                cfgobj.put("lastModified", now);
                collections = new TreeMap();
                cfgobj.put("featureTypes", collections);
                TreeMap<String, Object> featureProvider = new TreeMap<String, Object>();
                cfgobj.put("featureProvider", featureProvider);
                featureProvider.put("providerType", "PGIS");
                TreeMap<String, String> connectionInfo = new TreeMap<String, String>();
                featureProvider.put("connectionInfo", connectionInfo);
                connectionInfo.put("host", "FIXME");
                connectionInfo.put("database", "FIXME");
                connectionInfo.put("user", "FIXME");
                connectionInfo.put("password", "FIXME-base64encoded");
                if (!trigger_onDelete.isEmpty()) {
                    TreeMap trigger = new TreeMap();
                    featureProvider.put("trigger", trigger);
                    ArrayList<String> onDelete = new ArrayList<String>();
                    for (String trg : trigger_onDelete) {
                        onDelete.add(trg);
                    }
                    trigger.put("onDelete", onDelete);
                }
                mappings = new TreeMap();
                featureProvider.put("mappings", mappings);
                cfgobjGeojson = new TreeMap();
                cfgobjGeojson.put("nestedObjects", "NEST");
                cfgobjGeojson.put("multiplicity", "ARRAY");
                cfgobjGml = new TreeMap();
                cfgobjGml.put("enabled", false);
                mapCL = new HashMap<String, TreeMap<String, Object>>();
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null) {
                this.result.addError(msg);
            }
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void reset() {
        initialised = false;
        model = null;
        srvid = null;
        srvlabel = null;
        srvdesc = null;
        srvversion = null;
        secured = false;
        foreignKeySuffix = null;
        primaryKeyField = null;
        maxLength = null;
        templateNtoM = null;
        template1toN = null;
        rootFeatureTable = null;
        rootCollectionField = null;
        filterableFields = null;
        htmlLabelFields = null;
        featureTypes = null;
        clUrlTV = null;
        reportables = null;
        trigger_onDelete = null;
        outputDirectory = null;
        writer = null;
        writerGeojson = null;
        writerGml = null;
        mapCL = null;
        cfgobj = null;
        collections = null;
        mappings = null;
    }

    @Override
    public void process(ClassInfo ci) {
        TreeMap<String, Object> featuretype;
        String label;
        String tabname;
        if (ci.category() != 1) {
            return;
        }
        if (!featureTypes.isEmpty() && !featureTypes.contains(ci.name().toLowerCase())) {
            return;
        }
        this.priority = 0;
        String colname = tabname = this.deriveName(ci);
        String alias = ci.aliasName();
        String string = label = alias != null && alias.length() > 0 ? alias : ci.name();
        if (ci.matches("rule-ldp-cls-non-abstract-feature-types-as-collection") && !ci.isAbstract()) {
            featuretype = new TreeMap<String, Object>();
            collections.put(colname, featuretype);
            featuretype.put("id", colname);
            featuretype.put("label", label);
            featuretype.put("description", ci.documentation());
            TreeMap extent = new TreeMap();
            featuretype.put("extent", extent);
            TreeMap<String, Integer> spatial = new TreeMap<String, Integer>();
            extent.put("spatial", spatial);
            spatial.put("xmin", -180);
            spatial.put("xmax", 180);
            spatial.put("ymin", -90);
            spatial.put("ymax", 90);
            TreeMap<String, Object> temporal = new TreeMap<String, Object>();
            extent.put("temporal", temporal);
            temporal.put("start", null);
            temporal.put("end", null);
        }
        if (ci.isAssocClass() != null) {
            this.result.addWarning(this, 101, ci.name());
        }
        if (!ci.isAbstract()) {
            featuretype = new TreeMap();
            mappings.put(colname, featuretype);
            TreeMap path = new TreeMap();
            String basepath = "/" + tabname;
            featuretype.put(basepath, path);
            TreeMap<String, Object> general = new TreeMap<String, Object>();
            path.put("general", general);
            general.put("mappingType", "GENERIC_PROPERTY");
            general.put("enabled", true);
            TreeMap<String, Object> html = new TreeMap<String, Object>();
            path.put("text/html", html);
            String name = primaryKeyField;
            for (String f : htmlLabelFields) {
                if (!f.startsWith(tabname + ".") && !f.startsWith("*.")) continue;
                name = f.substring(f.indexOf(".") + 1);
                break;
            }
            html.put("name", "{{" + name + "}}");
            html.put("mappingType", "MICRODATA_PROPERTY");
            html.put("itemType", "http://schema.org/Place");
            if (ci.matches("rule-ldp-cls-id-field")) {
                this.createIdProperty(ci, featuretype, basepath);
            }
            if (!ci.supertypes().isEmpty()) {
                for (String sid : ci.supertypes()) {
                    this.processSupertypeProperties(ci, model.classById(sid), featuretype, basepath);
                }
            }
            if (!ci.properties().isEmpty()) {
                for (PropertyInfo pi : ci.properties().values()) {
                    this.processProperty(pi, featuretype, basepath, null, null, tabname);
                }
            }
            if (ci.matches("rule-ldp-cls-oneo-metadata")) {
                featuretype.put(basepath + "/erstelltvon", this.additionalProperty("erstelltVon", "Erstellt von", "STRING", "STRING", "VALUE"));
                featuretype.put(basepath + "/erstelltam", this.additionalProperty("erstelltAm", "Erstellt am", "STRING", "DATE", "TEMPORAL"));
                featuretype.put(basepath + "/geaendertvon", this.additionalProperty("geaendertVon", "Ge\u00e4ndert von", "STRING", "STRING", "VALUE"));
                featuretype.put(basepath + "/geaendertam", this.additionalProperty("geaendertAm", "Ge\u00e4ndert am", "STRING", "DATE", "TEMPORAL"));
            }
        }
    }

    private TreeMap<String, Object> additionalProperty(String fieldname, String label, String type, String htmltype, String category) {
        TreeMap<String, Object> path = new TreeMap<String, Object>();
        TreeMap<String, Object> general = new TreeMap<String, Object>();
        path.put("general", general);
        general.put("mappingType", "GENERIC_PROPERTY");
        general.put("name", fieldname);
        boolean enable = false;
        for (String rep : reportables) {
            if (!rep.equalsIgnoreCase("internal")) continue;
            enable = true;
            break;
        }
        general.put("enabled", enable);
        general.put("sortPriority", this.priority++);
        general.put("filterable", false);
        general.put("type", category);
        TreeMap<String, Object> html = new TreeMap<String, Object>();
        path.put("text/html", html);
        html.put("mappingType", "MICRODATA_PROPERTY");
        html.put("name", label);
        html.put("type", htmltype);
        html.put("showInCollection", false);
        if (htmltype.equalsIgnoreCase("DATE")) {
            html.put("format", "dd.MM.yyyy[', 'HH:mm:ss[' 'z]]");
        }
        TreeMap<String, String> json = new TreeMap<String, String>();
        path.put("application/geo+json", json);
        json.put("mappingType", "GEO_JSON_PROPERTY");
        json.put("type", type);
        return path;
    }

    @Override
    public void write() {
    }

    @Override
    public String getTargetName() {
        return "ldproxy Configuration";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAll(ShapeChangeResult r) {
        String m;
        this.result = r;
        this.options = r.options();
        OutputStreamWriter writerCL = null;
        try {
            String s = this.options.parameter(this.getClass().getName(), "prettyPrint");
            GsonBuilder gsonBuilder = new GsonBuilder().serializeNulls();
            if ("false".equalsIgnoreCase(s)) {
                gsonBuilder.setPrettyPrinting();
            }
            Gson gson = gsonBuilder.create();
            if (writer != null) {
                writer.write(gson.toJson(cfgobj));
                writer.flush();
                writer.close();
            }
            if (writerGeojson != null) {
                writerGeojson.write(gson.toJson(cfgobjGeojson));
                writerGeojson.flush();
                writerGeojson.close();
            }
            if (writerGml != null) {
                writerGml.write(gson.toJson(cfgobjGml));
                writerGml.flush();
                writerGml.close();
            }
            if (mapCL != null) {
                for (Map.Entry<String, TreeMap<String, Object>> entry : mapCL.entrySet()) {
                    writerCL = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(directoryCL + "/" + entry.getKey())), StandardCharsets.UTF_8);
                    writerCL.write(gson.toJson(entry.getValue()));
                    writerCL.flush();
                    writerCL.close();
                    writerCL = null;
                }
            }
        }
        catch (Exception e) {
            m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    m = e.getMessage();
                    if (m != null) {
                        this.result.addError(m);
                    }
                    e.printStackTrace(System.err);
                }
            }
            if (writerGeojson != null) {
                try {
                    writerGeojson.close();
                }
                catch (IOException e) {
                    m = e.getMessage();
                    if (m != null) {
                        this.result.addError(m);
                    }
                    e.printStackTrace(System.err);
                }
            }
            if (writerGml != null) {
                try {
                    writerGml.close();
                }
                catch (IOException e) {
                    m = e.getMessage();
                    if (m != null) {
                        this.result.addError(m);
                    }
                    e.printStackTrace(System.err);
                }
            }
            if (writerCL != null) {
                try {
                    writerCL.close();
                }
                catch (IOException e) {
                    m = e.getMessage();
                    if (m != null) {
                        this.result.addError(m);
                    }
                    e.printStackTrace(System.err);
                }
            }
            model = null;
        }
    }

    private String deriveName(Info i) {
        String result = i.name();
        if (i.matches("rule-ldp-all-names-in-lowercase")) {
            result = result.toLowerCase();
        }
        if (i.matches("rule-ldp-all-names-max-length") && result.length() > maxLength) {
            result = result.substring(0, maxLength);
        }
        return result;
    }

    private String deriveNameNtoM(String tabname, String fieldname) {
        String result = templateNtoM.replace("{{class}}", tabname).replace("{{property}}", fieldname);
        return result;
    }

    private String deriveName1toN(String tabname, String fieldname) {
        String result = template1toN.replace("{{class}}", tabname).replace("{{property}}", fieldname);
        return result;
    }

    private void processSupertypeProperties(ClassInfo ci, ClassInfo superci, TreeMap<String, Object> featuretype, String basepath) {
        Object path;
        String tabname;
        if (superci == null) {
            return;
        }
        if (ci.matches("rule-ldp-cls-table-per-feature-type")) {
            tabname = this.deriveName(superci);
            path = basepath + "/[" + primaryKeyField + "=" + primaryKeyField + "]" + tabname;
        } else {
            tabname = this.deriveName(ci);
            path = basepath;
        }
        if (superci.matches("rule-ldp-cls-table-per-feature-type") && !superci.supertypes().isEmpty()) {
            for (String sid : superci.supertypes()) {
                this.processSupertypeProperties(ci, model.classById(sid), featuretype, basepath);
            }
        }
        if (!superci.properties().isEmpty()) {
            for (PropertyInfo pi : superci.properties().values()) {
                this.processProperty(pi, featuretype, (String)path, null, null, tabname);
            }
        }
    }

    private void createIdProperty(ClassInfo ci, TreeMap<String, Object> featuretype, String basepath) {
        String fieldname = primaryKeyField;
        TreeMap path = new TreeMap();
        String proppath = ci.matches("rule-ldp-cls-table-per-feature-type") ? basepath + "/[" + primaryKeyField + "=" + primaryKeyField + "]" + rootFeatureTable + "/" + fieldname : basepath + "/" + fieldname;
        featuretype.put(proppath, path);
        TreeMap<String, Object> general = new TreeMap<String, Object>();
        path.put("general", general);
        general.put("mappingType", "GENERIC_PROPERTY");
        general.put("name", fieldname);
        general.put("enabled", true);
        general.put("sortPriority", this.priority++);
        general.put("filterable", false);
        general.put("type", "ID");
        TreeMap<String, Object> html = new TreeMap<String, Object>();
        path.put("text/html", html);
        html.put("mappingType", "MICRODATA_PROPERTY");
        html.put("name", "id");
        html.put("type", "ID");
        html.put("showInCollection", true);
        TreeMap<String, String> json = new TreeMap<String, String>();
        path.put("application/geo+json", json);
        json.put("mappingType", "GEO_JSON_PROPERTY");
        json.put("type", "ID");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processProperty(PropertyInfo pi, TreeMap<String, Object> featuretype, String basepath, String basename, String baselabel, String tabname) {
        Object fieldname;
        String codelist;
        String pattern;
        String targettabname;
        String jsongeometrytype;
        String jsontype;
        String htmlgeometrytype;
        String htmlformat;
        String htmltype;
        String category;
        String label;
        String field;
        block44: {
            int dtbasepath2;
            String[] makeUnique2;
            ClassInfo cix;
            block51: {
                Iterator<PropertyInfo> iterator;
                String dtbasepath2;
                String dttabname;
                block47: {
                    block49: {
                        block50: {
                            String[] sa;
                            block48: {
                                block46: {
                                    Type ti;
                                    block45: {
                                        String[] paramarr;
                                        field = this.deriveName(pi);
                                        String alias = pi.aliasName();
                                        label = alias != null && alias.length() > 0 ? alias : pi.name();
                                        category = "VALUE";
                                        htmltype = "STRING";
                                        htmlformat = null;
                                        htmlgeometrytype = null;
                                        jsontype = "STRING";
                                        jsongeometrytype = null;
                                        targettabname = null;
                                        pattern = null;
                                        codelist = null;
                                        ti = pi.typeInfo();
                                        if (ti == null) break block44;
                                        ProcessMapEntry me = this.options.targetMapEntry(ti.name, pi.encodingRule("ldp"));
                                        if (me == null) break block45;
                                        if (!me.hasTargetType()) break block44;
                                        htmltype = me.getTargetType();
                                        String string = jsontype = htmltype.equalsIgnoreCase("DATE") ? "STRING" : htmltype;
                                        if (!me.hasParam() || me.getParam().length() <= 0) break block44;
                                        HashMap<String, String> params = new HashMap<String, String>();
                                        for (String param : paramarr = me.getParam().split(";")) {
                                            String[] stringArray = param.split(":", 2);
                                            if (stringArray.length != 2) continue;
                                            params.put(stringArray[0].trim(), stringArray[1].trim());
                                        }
                                        if (params.containsKey("category")) {
                                            category = (String)params.get("category");
                                        }
                                        if (params.containsKey("htmlformat")) {
                                            htmlformat = (String)params.get("htmlformat");
                                        }
                                        if (params.containsKey("htmlgeometry")) {
                                            htmlgeometrytype = (String)params.get("htmlgeometry");
                                        }
                                        if (!params.containsKey("jsongeometry")) break block44;
                                        jsongeometrytype = (String)params.get("jsongeometry");
                                        break block44;
                                    }
                                    cix = model.classById(ti.id);
                                    if (cix == null) break block44;
                                    if (cix.category() != 5 && cix.category() != 6) break block46;
                                    if (pi.matches("rule-ldp-prop-all-datatype-relations-as-n-to-m-relations")) {
                                        dttabname = this.deriveName(cix);
                                        String makeUnique2 = tabname.equals(field) ? "_" : "";
                                        dtbasepath2 = (String)basepath + "/[" + primaryKeyField + "=" + tabname + foreignKeySuffix + "]" + this.deriveNameNtoM(tabname, field) + "/[" + field + makeUnique2 + foreignKeySuffix + "=" + primaryKeyField + "]" + dttabname;
                                        if (cix.properties().isEmpty()) return;
                                        iterator = cix.properties().values().iterator();
                                        break block47;
                                    } else {
                                        ShapeChangeResult.MessageContext m = this.result.addError(this, 2);
                                        m.addDetail(this, 99, pi.name(), pi.inClass().name(), cix.name());
                                        return;
                                    }
                                }
                                if (cix.category() != 1) break block48;
                                if (!pi.matches("rule-ldp-prop-all-featuretype-relations-as-n-to-m-relations")) {
                                    ShapeChangeResult.MessageContext m = this.result.addError(this, 3);
                                    m.addDetail(this, 99, pi.name(), pi.inClass().name(), cix.name());
                                    return;
                                }
                                category = "REFERENCE";
                                if (!cix.matches("rule-ldp-cls-table-per-feature-type") && cix.isAbstract()) {
                                    ShapeChangeResult.MessageContext m = this.result.addError(this, 4);
                                    m.addDetail(this, 99, pi.name(), pi.inClass().name(), cix.name());
                                    return;
                                }
                                targettabname = this.deriveNameNtoM(tabname, field);
                                basepath = (String)basepath + "/[" + primaryKeyField + "=" + tabname + foreignKeySuffix + "]" + targettabname;
                                break block44;
                            }
                            if (cix.category() != 2 && cix.category() != 3 || !pi.matches("rule-ldp-prop-all-codelist-values-as-strings")) break block49;
                            if (!cix.matches("rule-ldp-cls-generate-codelist")) break block44;
                            if (mapCL.containsKey(cix.name())) break block50;
                            makeUnique2 = sa = cix.taggedValuesForTag(clUrlTV);
                            dtbasepath2 = makeUnique2.length;
                            break block51;
                        }
                        codelist = cix.name();
                        break block44;
                    }
                    if (cix.category() == 8) {
                        ShapeChangeResult.MessageContext m = this.result.addError(this, 5);
                        m.addDetail(this, 99, pi.name(), pi.inClass().name(), cix.name());
                        return;
                    }
                    ShapeChangeResult.MessageContext m = this.result.addWarning(this, 102, cix.name());
                    m.addDetail(this, 99, pi.name(), pi.inClass().name(), cix.name());
                    break block44;
                }
                while (iterator.hasNext()) {
                    PropertyInfo pix = iterator.next();
                    this.processProperty(pix, featuretype, dtbasepath2, (String)(basename != null ? basename + "." : "") + pi.name() + "[" + dttabname + "]", (String)(baselabel != null ? baselabel + " - " : "") + label, dttabname);
                }
                return;
            }
            for (int i = 0; i < dtbasepath2; ++i) {
                ShapeChangeResult.MessageContext m;
                ShapeChangeResult.MessageContext m2;
                InputStream inputStream;
                String surl = makeUnique2[i];
                if (!surl.startsWith("http://") && !surl.startsWith("https://")) continue;
                surl = surl.replace("/referenzlisten/", "/repository/");
                Object var27_40 = null;
                try {
                    URL url = new URL(surl);
                    inputStream = url.openStream();
                }
                catch (MalformedURLException e) {
                    m2 = this.result.addError(this, 7, surl);
                    m2.addDetail(this, 99, pi.name(), pi.inClass().name(), cix.name());
                    continue;
                }
                catch (IOException e) {
                    m2 = this.result.addError(this, 8, surl);
                    m2.addDetail(this, 99, pi.name(), pi.inClass().name(), cix.name());
                    continue;
                }
                DocumentBuilder builder = null;
                ShapeChangeErrorHandler handler = null;
                try {
                    System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setNamespaceAware(false);
                    factory.setValidating(false);
                    factory.setFeature("http://apache.org/xml/features/validation/schema", false);
                    factory.setIgnoringElementContentWhitespace(true);
                    factory.setIgnoringComments(true);
                    factory.setXIncludeAware(true);
                    factory.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
                    builder = factory.newDocumentBuilder();
                    handler = new ShapeChangeErrorHandler();
                    builder.setErrorHandler(handler);
                }
                catch (FactoryConfigurationError e) {
                    m = this.result.addError(this, 9, surl);
                    m.addDetail(this, 99, pi.name(), pi.inClass().name(), cix.name());
                    continue;
                }
                catch (ParserConfigurationException e) {
                    m = this.result.addError(this, 10, surl);
                    m.addDetail(this, 99, pi.name(), pi.inClass().name(), cix.name());
                    continue;
                }
                try {
                    Document document = builder.parse(inputStream);
                    if (handler.errorsFound()) {
                        m = this.result.addError(this, 11, surl);
                        m.addDetail(this, 99, pi.name(), pi.inClass().name(), cix.name());
                        continue;
                    }
                    TreeMap<String, Object> cl = new TreeMap<String, Object>();
                    cl.put("id", cix.name());
                    cl.put("label", cix.definition());
                    cl.put("sourceUrl", surl);
                    cl.put("sourceType", "ONEO_SCHLUESSELLISTE");
                    TreeMap<String, CallSite> entries = new TreeMap<String, CallSite>();
                    cl.put("entries", entries);
                    NodeList nl = document.getElementsByTagName("item");
                    for (int j = 0; j < nl.getLength(); ++j) {
                        String label2;
                        Element e = (Element)nl.item(j);
                        Node n = e.getElementsByTagName("atomid").item(0);
                        String code = n != null ? ((Element)n).getTextContent().trim() : null;
                        n = e.getElementsByTagName("shortname").item(0);
                        String label1 = n != null ? ((Element)n).getTextContent().trim() : "";
                        n = e.getElementsByTagName("longname").item(0);
                        String string = label2 = n != null ? ((Element)n).getTextContent().trim() : "";
                        if (code != null) {
                            if (label1.isEmpty() && label2.isEmpty()) {
                                entries.put(code, (CallSite)((Object)("(" + code + ")")));
                                continue;
                            }
                            entries.put(code, (CallSite)((Object)((String)(label1.isEmpty() ? "" : "(" + label1 + ")" + (label2.isEmpty() ? "" : " - ")) + label2)));
                            continue;
                        }
                        ShapeChangeResult.MessageContext m3 = this.result.addError(this, 13, surl, "atomid");
                        m3.addDetail(this, 99, pi.name(), pi.inClass().name(), cix.name());
                    }
                    mapCL.put(cix.name(), cl);
                    codelist = cix.name();
                    break;
                }
                catch (Exception e) {
                    String msg = e.getMessage();
                    if (msg == null) {
                        msg = "Unknown error.";
                    }
                    ShapeChangeResult.MessageContext m4 = this.result.addError(this, 12, surl, msg);
                    m4.addDetail(this, 99, pi.name(), pi.inClass().name(), cix.name());
                }
            }
        }
        TreeMap path = new TreeMap();
        String proppath = (String)basepath + "/" + field;
        Object object = fieldname = basename != null ? basename + "." + pi.name() : pi.name();
        if (category.equalsIgnoreCase("REFERENCE")) {
            fieldname = (String)fieldname + "[" + targettabname + "]";
            proppath = (String)basepath + "/" + rootCollectionField + ":" + field + foreignKeySuffix;
            pattern = "{{serviceUrl}}/collections/{{" + rootCollectionField + "}}/items/{{" + field + foreignKeySuffix + "}}";
        } else if (category.equalsIgnoreCase("SPATIAL")) {
            if (pi.cardinality().maxOccurs > 1) {
                ShapeChangeResult.MessageContext m = this.result.addError(this, 1);
                m.addDetail(this, 99, pi.name(), pi.inClass().name(), pi.typeInfo().name);
            }
            if (pi.matches("rule-ldp-prop-separate-geometry-table")) {
                proppath = (String)basepath + "/[" + geometryField + "=" + primaryKeyField + "]" + geometryTable + "/" + geometryField;
            }
        } else if (pi.cardinality().maxOccurs > 1) {
            proppath = (String)basepath + "/[" + primaryKeyField + "=" + tabname + foreignKeySuffix + "]" + this.deriveName1toN(tabname, field) + "/" + field;
            fieldname = (String)fieldname + "[" + this.deriveName1toN(tabname, field) + "]";
        }
        featuretype.put(proppath, path);
        TreeMap<String, Object> general = new TreeMap<String, Object>();
        path.put("general", general);
        String mappingType = "GENERIC_PROPERTY";
        general.put("mappingType", mappingType);
        general.put("name", fieldname);
        boolean enable = true;
        if (!reportables.isEmpty()) {
            String[] sa;
            enable = false;
            for (String srep : sa = pi.taggedValuesForTag("reportable")) {
                for (String rep : reportables) {
                    if (!srep.equalsIgnoreCase(rep)) continue;
                    enable = true;
                    break;
                }
                if (enable) break;
            }
        }
        general.put("enabled", enable);
        general.put("sortPriority", this.priority++);
        boolean filterable = false;
        if (category.equalsIgnoreCase("SPATIAL")) {
            filterable = true;
        } else if (filterableFields.contains(tabname + "." + field)) {
            filterable = true;
        }
        general.put("filterable", filterable);
        general.put("type", category);
        if (pattern != null) {
            general.put("pattern", pattern);
        }
        if (codelist != null) {
            general.put("codelist", codelist);
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        path.put("text/html", treeMap);
        mappingType = "MICRODATA_PROPERTY";
        if (category.equalsIgnoreCase("SPATIAL")) {
            mappingType = "MICRODATA_GEOMETRY";
        }
        treeMap.put("mappingType", mappingType);
        treeMap.put("name", (String)(baselabel != null ? baselabel + " - " : "") + label);
        treeMap.put("type", htmltype);
        if (htmlformat != null) {
            treeMap.put("format", htmlformat);
        }
        if (htmlgeometrytype != null) {
            treeMap.put("geometryType", htmlgeometrytype);
        }
        treeMap.put("showInCollection", !htmltype.equalsIgnoreCase("GEOMETRY"));
        TreeMap<String, String> json = new TreeMap<String, String>();
        path.put("application/geo+json", json);
        mappingType = "GEO_JSON_PROPERTY";
        if (category.equalsIgnoreCase("SPATIAL")) {
            mappingType = "GEO_JSON_GEOMETRY";
        }
        json.put("mappingType", mappingType);
        json.put("type", jsontype);
        if (jsongeometrytype == null) return;
        json.put("geometryType", jsongeometrytype);
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
        r.addRule("rule-ldp-cls-non-abstract-feature-types-as-collection");
        r.addRule("rule-ldp-cls-table-per-feature-type");
        r.addRule("rule-ldp-cls-id-field");
        r.addRule("rule-ldp-cls-generate-codelist");
        r.addRule("rule-ldp-all-names-in-lowercase");
        r.addRule("rule-ldp-all-names-max-length");
        r.addRule("rule-ldp-prop-all-datatype-relations-as-n-to-m-relations");
        r.addRule("rule-ldp-prop-all-featuretype-relations-as-n-to-m-relations");
        r.addRule("rule-ldp-prop-multiple-single-values-as-1-to-n-relations");
        r.addRule("rule-ldp-prop-separate-geometry-table");
        r.addRule("rule-ldp-prop-all-codelist-values-as-strings");
        r.addRule("rule-ldp-cls-oneo-metadata");
    }

    @Override
    public String getTargetIdentifier() {
        return "ldp";
    }

    @Override
    public String getDefaultEncodingRule() {
        return "*";
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "A geometry property has a maximum multiplicity greater than '1'. This is not supported by this target. A maxmimum multiplicity of '1' is used.";
            }
            case 2: {
                return "No rule is specified how to handle properties with a value that is a data type. The property is ignored.";
            }
            case 3: {
                return "No rule is specified how to handle properties with a value that is a feature type. The property is ignored.";
            }
            case 4: {
                return "No rule is specified how to handle feature associations that involve non-abstract features, i.e. the link targets are spread across multiple tables. The property is ignored.";
            }
            case 5: {
                return "No rule is specified how to handle properties with a value that is a union data type. The property is ignored.";
            }
            case 6: {
                return "Directory named '$1$' is required, but does not exist or is not accessible.";
            }
            case 7: {
                return "The code list at URL '$1$' is a malformed URL.";
            }
            case 8: {
                return "The code list at URL '$1$' is not accessible.";
            }
            case 9: {
                return "The XML document of code list at URL '$1$' could not be processed. Unable to get a document builder factory.";
            }
            case 10: {
                return "The XML document of code list at URL '$1$' could not be processed. The XML Parser was unable to be configured.";
            }
            case 11: {
                return "The XML document of code list at URL '$1$' could not be processed. The file is not well-formed.";
            }
            case 12: {
                return "The XML document of code list at URL '$1$' could not be processed. $2$";
            }
            case 13: {
                return "An item in the XML document of code list at URL '$1$' could not be processed. The element '$2$' is missing.";
            }
            case 99: {
                return "Context: class InfoImpl (subtype: PropertyInfo). Name: '$1$'. In class: '$2$'. Value type: '$3$'.";
            }
            case 101: {
                return "Association classes are currently not supported. Association characteristics of '$1$' are not considered.";
            }
            case 102: {
                return "No mapping has been specified for the value type '$1$' of a property. We assume the type is implemented as a string field in the database.";
            }
        }
        return "(Config.java) Unknown message with number: " + mnr;
    }
}

