/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.JSON.jsonschema;

import java.util.Optional;

public enum JsonSchemaVersion {
    DRAFT_2019_09("2019-09", "https://json-schema.org/draft/2019-09/schema"),
    DRAFT_07("draft-07", "http://json-schema.org/draft-07/schema#"),
    OPENAPI_30("OpenApi30", null);

    private String name;
    private String schemaUri;

    private JsonSchemaVersion(String name, String schemaUri) {
        this.name = name;
        this.schemaUri = schemaUri;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getSchemaUri() {
        return Optional.ofNullable(this.schemaUri);
    }

    public static Optional<JsonSchemaVersion> fromString(String name) {
        for (JsonSchemaVersion v : JsonSchemaVersion.values()) {
            if (!v.getName().equalsIgnoreCase(name)) continue;
            return Optional.of(v);
        }
        return Optional.empty();
    }
}

