/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.JSON;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.MapEntryParamInfos;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.JSON.jsonschema.JsonSchemaType;
import de.interactive_instruments.ShapeChange.TargetConfiguration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class JsonSchemaTargetConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("baseJsonSchemaDefinitionForDataTypes", "baseJsonSchemaDefinitionForFeatureTypes", "baseJsonSchemaDefinitionForObjectTypes", "byReferenceJsonSchemaDefinition", "documentationNoValue", "documentationTemplate", "entityTypeName", "inlineOrByReferenceDefault", "jsonBaseUri", "jsonSchemaVersion", "linkObjectUri", "objectIdentifierName", "objectIdentifierRequired", "objectIdentifierType", "prettyPrint", "writeMapEntries").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;
    private TargetConfiguration targetConfig = null;
    private String targetConfigInputs = "";
    private Options options = null;
    private ShapeChangeResult result = null;

    @Override
    public boolean isValid(ProcessConfiguration config, Options options, ShapeChangeResult result) {
        this.targetConfig = (TargetConfiguration)config;
        SortedSet<String> inputIds = this.targetConfig.getInputIds();
        if (inputIds != null && !inputIds.isEmpty()) {
            this.targetConfigInputs = String.join((CharSequence)" ", inputIds);
        }
        this.options = options;
        this.result = result;
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTargetParameters());
        isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, config.getParameters().keySet(), result) && isValid;
        TreeMap<String, ProcessMapEntry> mapEntryByType = new TreeMap<String, ProcessMapEntry>();
        for (ProcessMapEntry pme : config.getMapEntries()) {
            mapEntryByType.put(pme.getType(), pme);
        }
        MapEntryParamInfos mepis = new MapEntryParamInfos(result, mapEntryByType.values());
        isValid = isValid && mepis.isValid();
        isValid = isValid && this.checkMapEntryParameters(mepis);
        String inlineOrByRefDefault = options.parameterAsString(this.getClass().getName(), "inlineOrByReferenceDefault", "byreference", false, true);
        if (!("inline".equalsIgnoreCase(inlineOrByRefDefault) || "byreference".equalsIgnoreCase(inlineOrByRefDefault) || "inlineorbyreference".equalsIgnoreCase(inlineOrByRefDefault))) {
            isValid = false;
            result.addError(this, 100, "inlineOrByReferenceDefault", inlineOrByRefDefault);
        }
        return isValid;
    }

    private boolean checkMapEntryParameters(MapEntryParamInfos mepp) {
        boolean isValid = true;
        for (Map.Entry<String, Map<String, Map<String, String>>> entry : mepp.getParameterCache().entrySet()) {
            String typeRuleKey = entry.getKey();
            String[] keyParts = typeRuleKey.split("#");
            String typeName = keyParts[0];
            String ruleName = keyParts[1];
            ProcessMapEntry pme = mepp.getMapEntry(typeName, ruleName);
            String targetType = pme.getTargetType();
            Map<String, Map<String, String>> characteristicsByParameter = entry.getValue();
            if (!characteristicsByParameter.containsKey("keywords")) continue;
            Map<String, String> characteristics = characteristicsByParameter.get("keywords");
            Optional<JsonSchemaType> simpleType = JsonSchemaType.fromString(targetType);
            if (simpleType.isPresent()) {
                JsonSchemaType jsType = simpleType.get();
                for (String characteristic : characteristics.keySet()) {
                    ShapeChangeResult.MessageContext mc;
                    String value = characteristics.get(characteristic);
                    if (StringUtils.isBlank((CharSequence)value)) {
                        isValid = false;
                        ShapeChangeResult.MessageContext mc2 = this.result.addError(this, 102, "keywords", characteristic);
                        if (mc2 == null) continue;
                        mc2.addDetail(this, 1, this.targetConfigInputs, typeRuleKey, targetType);
                        continue;
                    }
                    if (characteristic.equalsIgnoreCase("format")) continue;
                    if (jsType == JsonSchemaType.INTEGER || jsType == JsonSchemaType.NUMBER) {
                        if (characteristic.equalsIgnoreCase("enum")) {
                            String[] values = value.split("\\s*,\\s*");
                            double[] doubleValues = new double[values.length];
                            try {
                                for (int i = 0; i < values.length; ++i) {
                                    double d;
                                    doubleValues[i] = d = Double.parseDouble(values[i]);
                                }
                                continue;
                            }
                            catch (NumberFormatException e) {
                                isValid = false;
                                ShapeChangeResult.MessageContext mc3 = this.result.addError(this, 103, "keywords", characteristic, value, targetType);
                                if (mc3 == null) continue;
                                mc3.addDetail(this, 1, this.targetConfigInputs, typeRuleKey, targetType);
                                continue;
                            }
                        }
                        try {
                            double d = Double.parseDouble(value);
                            if (characteristic.equalsIgnoreCase("multipleOf")) {
                                if (!(d <= 0.0)) continue;
                                isValid = false;
                                ShapeChangeResult.MessageContext mc4 = this.result.addError(this, 104, "keywords", characteristic, value);
                                if (mc4 == null) continue;
                                mc4.addDetail(this, 1, this.targetConfigInputs, typeRuleKey, targetType);
                                continue;
                            }
                            if (characteristic.equalsIgnoreCase("maximum") || characteristic.equalsIgnoreCase("minimum") || characteristic.equalsIgnoreCase("exclusiveMinimum") || characteristic.equalsIgnoreCase("exclusiveMaximum") || characteristic.equalsIgnoreCase("const")) continue;
                            isValid = false;
                            ShapeChangeResult.MessageContext mc5 = this.result.addError(this, 106, "keywords", characteristic, targetType);
                            if (mc5 == null) continue;
                            mc5.addDetail(this, 1, this.targetConfigInputs, typeRuleKey, targetType);
                        }
                        catch (NumberFormatException e) {
                            isValid = false;
                            mc = this.result.addError(this, 107, "keywords", characteristic, value, targetType);
                            if (mc == null) continue;
                            mc.addDetail(this, 1, this.targetConfigInputs, typeRuleKey, targetType);
                        }
                        continue;
                    }
                    if (jsType == JsonSchemaType.STRING) {
                        if (characteristic.equalsIgnoreCase("enum") || characteristic.equalsIgnoreCase("const") || characteristic.equalsIgnoreCase("pattern") || characteristic.equalsIgnoreCase("patternBase64")) continue;
                        if (characteristic.equalsIgnoreCase("maxLength") || characteristic.equalsIgnoreCase("minLength")) {
                            try {
                                int i = Integer.parseInt(value);
                                if (i > 0) continue;
                                isValid = false;
                                mc = this.result.addError(this, 104, "keywords", characteristic, value);
                                if (mc == null) continue;
                                mc.addDetail(this, 1, this.targetConfigInputs, typeRuleKey, targetType);
                            }
                            catch (NumberFormatException e) {
                                isValid = false;
                                mc = this.result.addError(this, 108, "keywords", characteristic, value, targetType);
                                if (mc == null) continue;
                                mc.addDetail(this, 1, this.targetConfigInputs, typeRuleKey, targetType);
                            }
                            continue;
                        }
                        isValid = false;
                        ShapeChangeResult.MessageContext mc6 = this.result.addError(this, 106, "keywords", characteristic, targetType);
                        if (mc6 == null) continue;
                        mc6.addDetail(this, 1, this.targetConfigInputs, typeRuleKey, targetType);
                        continue;
                    }
                    isValid = false;
                    ShapeChangeResult.MessageContext mc7 = this.result.addError(this, 106, "keywords", characteristic, targetType);
                    if (mc7 == null) continue;
                    mc7.addDetail(this, 1, this.targetConfigInputs, typeRuleKey, targetType);
                }
                continue;
            }
            if (characteristics.isEmpty()) continue;
            isValid = false;
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 101);
            if (mc == null) continue;
            mc.addDetail(this, 1, this.targetConfigInputs, typeRuleKey, targetType);
        }
        return isValid;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: JsonSchemaTarget configuration element with 'inputs'='$1$'.";
            }
            case 1: {
                return "Context: JsonSchemaTarget configuration element with 'inputs'='$1$', map entry with type#rule '$2$' and target type '$3$'.";
            }
            case 100: {
                return "Parameter '$1$' is set to '$2$'. This is not a valid value.";
            }
            case 101: {
                return "Invalid map entry: target type is not a simple JSON Schema type but parameter 'keywords' is set. Setting keywords for a schema reference is not supported.";
            }
            case 102: {
                return "Invalid map entry: parameter '$1$' is set, but its characteristic '$2$' has no value (which is required for the parameter).";
            }
            case 103: {
                return "Invalid map entry: parameter '$1$' is set, but its characteristic '$2$' has one or more values ('$3$'), at least one of which cannot be parsed as double (which is required for that characteristic and/or the target type of the map entry, which is '$4$').";
            }
            case 104: {
                return "Invalid map entry: parameter '$1$' with characteristic '$2$' is set, but the value of the characteristic is not a non-negative number (found: '$3$') (which is required for that characteristic).";
            }
            case 105: {
                return "";
            }
            case 106: {
                return "Invalid map entry: parameter '$1$' has characteristic '$2$', which is not supported for the target type of the map entry (which is '$3$').";
            }
            case 107: {
                return "Invalid map entry: parameter '$1$' is set, but its characteristic '$2$' has value '$3$', which cannot be parsed as double (which is required for that characteristic and/or the target type of the map entry, which is '$4$').";
            }
            case 108: {
                return "Invalid map entry: parameter '$1$' is set, but its characteristic '$2$' has value '$3$', which cannot be parsed as integer (which is required for that characteristic and/or the target type of the map entry, which is '$4$').";
            }
        }
        return "(" + JsonSchemaTargetConfigurationValidator.class.getName() + ") Unknown message with number: " + mnr;
    }
}

