/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.JSON;

import de.interactive_instruments.ShapeChange.MapEntryParamInfos;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.JSON.JsonSchemaDocument;
import de.interactive_instruments.ShapeChange.Target.JSON.JsonSchemaTypeInfo;
import de.interactive_instruments.ShapeChange.Target.JSON.json.JsonNumber;
import de.interactive_instruments.ShapeChange.Target.JSON.json.JsonString;
import de.interactive_instruments.ShapeChange.Target.JSON.json.JsonValue;
import de.interactive_instruments.ShapeChange.Target.JSON.jsonschema.ConstKeyword;
import de.interactive_instruments.ShapeChange.Target.JSON.jsonschema.EnumKeyword;
import de.interactive_instruments.ShapeChange.Target.JSON.jsonschema.ExclusiveMaximumKeyword;
import de.interactive_instruments.ShapeChange.Target.JSON.jsonschema.ExclusiveMinimumKeyword;
import de.interactive_instruments.ShapeChange.Target.JSON.jsonschema.FormatKeyword;
import de.interactive_instruments.ShapeChange.Target.JSON.jsonschema.JsonSchemaType;
import de.interactive_instruments.ShapeChange.Target.JSON.jsonschema.JsonSchemaVersion;
import de.interactive_instruments.ShapeChange.Target.JSON.jsonschema.MaxLengthKeyword;
import de.interactive_instruments.ShapeChange.Target.JSON.jsonschema.MaximumKeyword;
import de.interactive_instruments.ShapeChange.Target.JSON.jsonschema.MinLengthKeyword;
import de.interactive_instruments.ShapeChange.Target.JSON.jsonschema.MinimumKeyword;
import de.interactive_instruments.ShapeChange.Target.JSON.jsonschema.MultipleOfKeyword;
import de.interactive_instruments.ShapeChange.Target.JSON.jsonschema.PatternKeyword;
import de.interactive_instruments.ShapeChange.Target.MapEntries;
import de.interactive_instruments.ShapeChange.Target.SingleTarget;
import java.io.File;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class JsonSchemaTarget
implements SingleTarget,
MessageSource {
    protected static Model model = null;
    private static boolean initialised = false;
    protected static boolean diagnosticsOnly = false;
    protected static int numberOfEncodedSchemas = 0;
    protected static String documentationTemplate = null;
    protected static String documentationNoValue = null;
    protected static Boolean prettyPrint = null;
    protected static String outputDirectory = null;
    protected static JsonSchemaVersion jsonSchemaVersion = null;
    protected static String entityTypeName = null;
    protected static String inlineOrByRefDefault = null;
    protected static String linkObjectUri = null;
    protected static String byReferenceJsonSchemaDefinition = null;
    protected static String baseJsonSchemaDefinitionForFeatureTypes = null;
    protected static String baseJsonSchemaDefinitionForObjectTypes = null;
    protected static String baseJsonSchemaDefinitionForDataTypes = null;
    protected static String objectIdentifierName = "id";
    protected static JsonSchemaType[] objectIdentifierType = new JsonSchemaType[]{JsonSchemaType.STRING};
    protected static boolean objectIdentifierRequired = false;
    protected static MapEntryParamInfos mapEntryParamInfos = null;
    protected static SortedMap<PackageInfo, List<ProcessMapEntry>> mapEntriesForEncodedTypesBySchemaPackage = new TreeMap<PackageInfo, List<ProcessMapEntry>>();
    protected static Map<ClassInfo, String> entityTypeMemberPathByCi = new HashMap<ClassInfo, String>();
    protected static SortedMap<PackageInfo, JsonSchemaDocument> jsDocsByPkg = new TreeMap<PackageInfo, JsonSchemaDocument>();
    protected static Map<ClassInfo, JsonSchemaDocument> jsDocsByCi = new HashMap<ClassInfo, JsonSchemaDocument>();
    protected ShapeChangeResult result = null;
    protected Options options = null;
    private PackageInfo schema = null;
    private boolean schemaNotEncoded = false;

    @Override
    public void initialise(PackageInfo pi, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        this.schema = pi;
        model = m;
        this.options = o;
        this.result = r;
        diagnosticsOnly = diagOnly;
        if (!JsonSchemaTarget.isEncoded(this.schema)) {
            this.schemaNotEncoded = true;
            this.result.addInfo(this, 7, this.schema.name());
            return;
        }
        ++numberOfEncodedSchemas;
        if (!initialised) {
            initialised = true;
            outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
            if (outputDirectory == null) {
                outputDirectory = this.options.parameter("outputDirectory");
            }
            if (outputDirectory == null) {
                outputDirectory = this.options.parameter(".");
            }
            documentationTemplate = this.options.parameter(this.getClass().getName(), "documentationTemplate");
            documentationNoValue = this.options.parameter(this.getClass().getName(), "documentationNoValue");
            prettyPrint = this.options.parameterAsBoolean(this.getClass().getName(), "prettyPrint", true);
            entityTypeName = this.options.parameterAsString(this.getClass().getName(), "entityTypeName", "entityType", false, true);
            inlineOrByRefDefault = this.options.parameterAsString(this.getClass().getName(), "inlineOrByReferenceDefault", "byreference", false, true);
            linkObjectUri = this.options.parameterAsString(this.getClass().getName(), "linkObjectUri", "", false, true);
            byReferenceJsonSchemaDefinition = this.options.parameterAsString(this.getClass().getName(), "byReferenceJsonSchemaDefinition", null, false, true);
            baseJsonSchemaDefinitionForFeatureTypes = this.options.parameterAsString(this.getClass().getName(), "baseJsonSchemaDefinitionForFeatureTypes", null, false, true);
            baseJsonSchemaDefinitionForObjectTypes = this.options.parameterAsString(this.getClass().getName(), "baseJsonSchemaDefinitionForObjectTypes", null, false, true);
            baseJsonSchemaDefinitionForDataTypes = this.options.parameterAsString(this.getClass().getName(), "baseJsonSchemaDefinitionForDataTypes", null, false, true);
            objectIdentifierName = this.options.parameterAsString(this.getClass().getName(), "objectIdentifierName", "id", false, true);
            String objectIdentifierTypeString = this.options.parameterAsString(this.getClass().getName(), "objectIdentifierType", "string", false, true);
            switch (objectIdentifierTypeString.toLowerCase(Locale.ENGLISH)) {
                case "number": {
                    objectIdentifierType = new JsonSchemaType[]{JsonSchemaType.NUMBER};
                    break;
                }
                case "number,string": 
                case "number, string": 
                case "string,number": 
                case "string, number": {
                    objectIdentifierType = new JsonSchemaType[]{JsonSchemaType.STRING, JsonSchemaType.NUMBER};
                    break;
                }
                default: {
                    objectIdentifierType = new JsonSchemaType[]{JsonSchemaType.STRING};
                }
            }
            objectIdentifierRequired = this.options.parameterAsBoolean(this.getClass().getName(), "objectIdentifierRequired", false);
            String jsVersionParamValue = this.options.parameterAsString(this.getClass().getName(), "jsonSchemaVersion", "2019-09", false, true);
            Optional<JsonSchemaVersion> jsVersion = JsonSchemaVersion.fromString(jsVersionParamValue);
            if (jsVersion.isPresent()) {
                jsonSchemaVersion = jsVersion.get();
            } else {
                this.result.addWarning(this, 10, "jsonSchemaVersion", jsVersionParamValue, "2019-09");
                jsonSchemaVersion = JsonSchemaVersion.DRAFT_2019_09;
            }
            List<ProcessMapEntry> mapEntries = this.options.getCurrentProcessConfig().getMapEntries();
            if (mapEntries.isEmpty()) {
                this.result.addWarning(this, 15);
                mapEntryParamInfos = new MapEntryParamInfos(this.result, null);
            } else {
                mapEntryParamInfos = new MapEntryParamInfos(this.result, mapEntries);
            }
            File outputDirectoryFile = new File(outputDirectory);
            if (!diagnosticsOnly) {
                boolean exi = outputDirectoryFile.exists();
                if (!exi) {
                    outputDirectoryFile.mkdirs();
                    exi = outputDirectoryFile.exists();
                }
                boolean dir = outputDirectoryFile.isDirectory();
                boolean wrt = outputDirectoryFile.canWrite();
                boolean rea = outputDirectoryFile.canRead();
                if (!(exi && dir && wrt && rea)) {
                    this.result.addFatalError(this, 5, outputDirectory);
                    throw new ShapeChangeAbortException();
                }
            } else {
                this.result.addInfo(this, 10002);
            }
        }
        this.result.addDebug(this, 10001, pi.name());
        String jsonBaseUri = this.schema.taggedValue("jsonBaseUri");
        jsonBaseUri = StringUtils.isBlank((CharSequence)jsonBaseUri) ? this.options.parameterAsString(this.getClass().getName(), "jsonBaseUri", "http://example.org/FIXME", false, true) : jsonBaseUri.trim();
        String jsonSubdirectory = JsonSchemaTarget.identifyJsonDirectory(this.schema);
        File outputDirectoryFile = new File(outputDirectory);
        File subDirectoryFile = new File(outputDirectoryFile, jsonSubdirectory);
        this.createJsonSchemaDocuments(pi, null, jsonBaseUri, jsonSubdirectory, subDirectoryFile);
        if (!diagnosticsOnly) {
            try {
                if (!subDirectoryFile.exists()) {
                    subDirectoryFile.mkdirs();
                }
                boolean dir = subDirectoryFile.isDirectory();
                boolean wrt = subDirectoryFile.canWrite();
                boolean rea = subDirectoryFile.canRead();
                if (!(dir && wrt && rea)) {
                    this.result.addFatalError(this, 5, subDirectoryFile.getName());
                    throw new ShapeChangeAbortException();
                }
            }
            catch (Exception e) {
                this.result.addFatalError(this, 5, subDirectoryFile.getName());
                this.result.addFatalError(this, 6, e.getMessage());
                throw new ShapeChangeAbortException();
            }
        }
    }

    private String jsonDocumentName(PackageInfo pi) {
        String s = pi.taggedValue("jsonDocument");
        if (StringUtils.isBlank((CharSequence)s)) {
            if (pi.isAppSchema()) {
                String appSchemaName = pi.name();
                s = JsonSchemaTarget.normalizedJsonDocumentName(pi);
                this.result.addWarning(this, 101, appSchemaName, s);
            } else {
                s = null;
            }
        } else {
            s = s.trim();
        }
        return s;
    }

    private boolean createJsonSchemaDocuments(PackageInfo pi, JsonSchemaDocument jsdcurr, String jsonBaseUri, String jsonSubdirectory, File subDirectoryFile) {
        JsonSchemaDocument jsd;
        boolean res = false;
        String jsDoc = this.jsonDocumentName(pi);
        if (StringUtils.isNotBlank((CharSequence)jsDoc)) {
            this.result.addDebug(this, 102, jsDoc, pi.name());
            jsd = new JsonSchemaDocument(pi, model, this.options, this.result, jsDoc, this, jsonBaseUri, jsonSubdirectory, new File(subDirectoryFile, jsDoc), mapEntryParamInfos);
            res = true;
        } else {
            jsd = jsdcurr;
            if (jsd == null) {
                jsDoc = JsonSchemaTarget.normalizedJsonDocumentName(pi);
                this.result.addWarning(this, 103, pi.name(), jsDoc);
                this.result.addDebug(this, 102, jsDoc, pi.name());
                jsd = new JsonSchemaDocument(pi, model, this.options, this.result, jsDoc, this, jsonBaseUri, jsonSubdirectory, new File(subDirectoryFile, jsDoc), mapEntryParamInfos);
                res = true;
            }
        }
        jsDocsByPkg.put(pi, jsd);
        for (PackageInfo pix : pi.containedPackages()) {
            if (pix.isSchema()) continue;
            this.createJsonSchemaDocuments(pix, jsd, jsonBaseUri, jsonSubdirectory, subDirectoryFile);
        }
        return res;
    }

    public static boolean isEncoded(Info i) {
        return !i.matches("rule-json-all-notEncoded") || !i.encodingRule("json").equalsIgnoreCase("notencoded");
    }

    public boolean prettyPrinting() {
        return prettyPrint;
    }

    public Optional<JsonSchemaDocument> jsonSchemaDocument(ClassInfo ci) {
        return Optional.ofNullable(jsDocsByCi.get(ci));
    }

    public Optional<String> byReferenceJsonSchemaDefinition() {
        return Optional.ofNullable(byReferenceJsonSchemaDefinition);
    }

    public String baseJsonSchemaDefinitionForFeatureTypes() {
        return baseJsonSchemaDefinitionForFeatureTypes;
    }

    public String baseJsonSchemaDefinitionForObjectTypes() {
        return baseJsonSchemaDefinitionForObjectTypes;
    }

    public String baseJsonSchemaDefinitionForDataTypes() {
        return baseJsonSchemaDefinitionForDataTypes;
    }

    public String getEntityTypeName() {
        return entityTypeName;
    }

    public String getInlineOrByRefDefault() {
        return inlineOrByRefDefault;
    }

    public String getLinkObjectUri() {
        return linkObjectUri;
    }

    public boolean objectIdentifierRequired() {
        return objectIdentifierRequired;
    }

    public String objectIdentifierName() {
        return objectIdentifierName;
    }

    public JsonSchemaType[] objectIdentifierType() {
        return objectIdentifierType;
    }

    @Override
    public void process(ClassInfo ci) {
        if (ci == null || ci.pkg() == null) {
            return;
        }
        if (!JsonSchemaTarget.isEncoded(ci)) {
            this.result.addInfo(this, 8, ci.name());
            return;
        }
        this.result.addDebug(this, 4, ci.name());
        Optional<ProcessMapEntry> pme = this.mapEntry(ci);
        if (pme.isPresent() && !this.ignoreMapEntryForTypeFromSchemaSelectedForProcessing(pme.get(), ci.id())) {
            if (mapEntryParamInfos.hasParameter(ci.name(), ci.encodingRule("json"), "keywords")) {
                this.result.addInfo(this, 23, ci.name(), pme.get().getTargetType());
            } else {
                this.result.addInfo(this, 22, ci.name(), pme.get().getTargetType());
            }
            return;
        }
        if (this.schemaNotEncoded) {
            this.result.addInfo(this, 18, this.schema.name(), ci.name());
            return;
        }
        JsonSchemaTypeInfo simpleJsTypeInfo = this.determineIfImplementedBySimpleJsonSchemaType(ci);
        if (simpleJsTypeInfo != null) {
            if (ci.matches("rule-json-cls-basictype")) {
                if (simpleJsTypeInfo.getSimpleType() == JsonSchemaType.BOOLEAN || simpleJsTypeInfo.getSimpleType() == JsonSchemaType.STRING || simpleJsTypeInfo.getSimpleType() == JsonSchemaType.NUMBER || simpleJsTypeInfo.getSimpleType() == JsonSchemaType.INTEGER) {
                    this.registerClass(ci, simpleJsTypeInfo);
                } else {
                    this.result.addError(this, 21, ci.name(), simpleJsTypeInfo.getSimpleType().getName());
                }
            } else {
                this.result.addError(this, 20, ci.name(), simpleJsTypeInfo.getSimpleType().getName());
            }
        } else if (ci.category() == 4 || ci.category() == 6 || ci.category() == 1 || ci.category() == 5 || ci.category() == 3 || ci.category() == 2) {
            this.registerClass(ci, null);
        } else if (ci.category() == 8) {
            if (ci.matches("rule-json-cls-union-propertyCount") || ci.matches("rule-json-cls-union-typeDiscriminator")) {
                this.registerClass(ci, null);
            } else {
                this.result.addInfo(this, 19, ci.name());
            }
        } else {
            this.result.addInfo(this, 17, ci.name());
        }
    }

    public boolean ignoreMapEntryForTypeFromSchemaSelectedForProcessing(ProcessMapEntry pme, String typeId) {
        if (StringUtils.isBlank((CharSequence)typeId)) {
            return false;
        }
        ClassInfo type = model.classById(typeId);
        if (type == null || !JsonSchemaTarget.isEncoded(type) || !model.isInSelectedSchemas(type)) {
            return false;
        }
        return mapEntryParamInfos.hasParameter(pme, "ignoreForTypeFromSchemaSelectedForProcessing");
    }

    private JsonSchemaTypeInfo determineIfImplementedBySimpleJsonSchemaType(ClassInfo ci) {
        JsonSchemaTypeInfo jsTypeInfo;
        String encodingRule;
        String typeName = ci.name();
        ProcessMapEntry pme = mapEntryParamInfos.getMapEntry(typeName, encodingRule = ci.encodingRule("json"));
        if (pme != null && !this.ignoreMapEntryForTypeFromSchemaSelectedForProcessing(pme, ci.id()) && (jsTypeInfo = this.identifyJsonSchemaType(pme, typeName, encodingRule)).isSimpleType()) {
            return jsTypeInfo;
        }
        if (ci.supertypes() != null) {
            for (String supertypeId : ci.supertypes()) {
                JsonSchemaTypeInfo cixJsTypeInfo;
                ClassInfo cix = model.classById(supertypeId);
                if (cix == null || (cixJsTypeInfo = this.determineIfImplementedBySimpleJsonSchemaType(cix)) == null || !cixJsTypeInfo.isSimpleType()) continue;
                return cixJsTypeInfo;
            }
        }
        return null;
    }

    public JsonSchemaTypeInfo identifyJsonSchemaType(ProcessMapEntry pme, String typeName, String encodingRule) {
        JsonSchemaTypeInfo jsTypeInfo = new JsonSchemaTypeInfo();
        Optional<JsonSchemaType> simpleType = JsonSchemaType.fromString(pme.getTargetType());
        if (simpleType.isPresent()) {
            JsonSchemaType jsType = simpleType.get();
            jsTypeInfo.setSimpleType(jsType);
            if (mapEntryParamInfos.hasParameter(typeName, encodingRule, "keywords")) {
                Map<String, String> characteristics = mapEntryParamInfos.getCharacteristics(typeName, encodingRule, "keywords");
                for (String characteristic : characteristics.keySet()) {
                    String value = characteristics.get(characteristic);
                    if (StringUtils.isBlank((CharSequence)value)) continue;
                    if (characteristic.equalsIgnoreCase("format")) {
                        jsTypeInfo.setKeyword(new FormatKeyword(value));
                        continue;
                    }
                    if (jsType == JsonSchemaType.INTEGER || jsType == JsonSchemaType.NUMBER) {
                        if (characteristic.equalsIgnoreCase("enum")) {
                            String[] values = value.split("\\s*,\\s*");
                            double[] doubleValues = new double[values.length];
                            for (int i = 0; i < values.length; ++i) {
                                try {
                                    double d;
                                    doubleValues[i] = d = Double.parseDouble(values[i]);
                                    continue;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            ArrayList<JsonValue> enums = new ArrayList<JsonValue>();
                            double[] dArray = doubleValues;
                            int n = dArray.length;
                            for (int i = 0; i < n; ++i) {
                                double d = dArray[i];
                                enums.add(new JsonNumber(d));
                            }
                            jsTypeInfo.setKeyword(new EnumKeyword((List<JsonValue>)enums));
                            continue;
                        }
                        try {
                            double d = Double.parseDouble(value);
                            if (characteristic.equalsIgnoreCase("multipleOf")) {
                                jsTypeInfo.setKeyword(new MultipleOfKeyword(d));
                                continue;
                            }
                            if (characteristic.equalsIgnoreCase("maximum")) {
                                jsTypeInfo.setKeyword(new MaximumKeyword(d));
                                continue;
                            }
                            if (characteristic.equalsIgnoreCase("minimum")) {
                                jsTypeInfo.setKeyword(new MinimumKeyword(d));
                                continue;
                            }
                            if (characteristic.equalsIgnoreCase("exclusiveMinimum")) {
                                jsTypeInfo.setKeyword(new ExclusiveMinimumKeyword(d));
                                continue;
                            }
                            if (characteristic.equalsIgnoreCase("exclusiveMaximum")) {
                                jsTypeInfo.setKeyword(new ExclusiveMaximumKeyword(d));
                                continue;
                            }
                            if (!characteristic.equalsIgnoreCase("const")) continue;
                            jsTypeInfo.setKeyword(new ConstKeyword(new JsonNumber(d)));
                        }
                        catch (NumberFormatException d) {}
                        continue;
                    }
                    if (jsType != JsonSchemaType.STRING) continue;
                    if (characteristic.equalsIgnoreCase("enum")) {
                        String[] values = value.split("\\s*,\\s*");
                        ArrayList<JsonValue> enums = new ArrayList<JsonValue>();
                        for (String v : values) {
                            enums.add(new JsonString(v));
                        }
                        jsTypeInfo.setKeyword(new EnumKeyword((List<JsonValue>)enums));
                        continue;
                    }
                    if (characteristic.equalsIgnoreCase("const")) {
                        jsTypeInfo.setKeyword(new ConstKeyword(new JsonString(value)));
                        continue;
                    }
                    if (characteristic.equalsIgnoreCase("pattern")) {
                        jsTypeInfo.setKeyword(new PatternKeyword(value));
                        continue;
                    }
                    if (characteristic.equalsIgnoreCase("patternBase64")) {
                        Base64.Decoder decoder = Base64.getDecoder();
                        String decodedValue = new String(decoder.decode(value));
                        jsTypeInfo.setKeyword(new PatternKeyword(decodedValue));
                        continue;
                    }
                    if (!characteristic.equalsIgnoreCase("maxLength") && !characteristic.equalsIgnoreCase("minLength")) continue;
                    try {
                        int i = Integer.parseInt(value);
                        if (characteristic.equalsIgnoreCase("maxLength")) {
                            jsTypeInfo.setKeyword(new MaxLengthKeyword(i));
                            continue;
                        }
                        jsTypeInfo.setKeyword(new MinLengthKeyword(i));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        } else {
            jsTypeInfo.setRef(pme.getTargetType());
        }
        if (mapEntryParamInfos.hasParameter(pme, "geometry")) {
            jsTypeInfo.setGeometry(true);
        }
        return jsTypeInfo;
    }

    public Optional<ProcessMapEntry> mapEntry(ClassInfo ci) {
        return Optional.ofNullable(this.options.targetMapEntry(ci.name(), ci.encodingRule("json")));
    }

    private void registerClass(ClassInfo ci, JsonSchemaTypeInfo simpleJsTypeInfo) {
        JsonSchemaDocument jsd = (JsonSchemaDocument)jsDocsByPkg.get(ci.pkg());
        if (simpleJsTypeInfo == null) {
            jsd.addClass(ci);
        } else {
            jsd.addBasicType(ci, simpleJsTypeInfo);
        }
        jsDocsByCi.put(ci, jsd);
    }

    @Override
    public void write() {
    }

    @Override
    public void writeAll(ShapeChangeResult r) {
        this.result = r;
        this.options = r.options();
        if (numberOfEncodedSchemas == 0) {
            return;
        }
        Set jsdocs = jsDocsByPkg.values().stream().filter(jsd -> jsd.hasClasses()).collect(Collectors.toCollection(HashSet::new));
        for (JsonSchemaDocument jsdoc : jsdocs) {
            jsdoc.createDefinitions();
        }
        if (!diagnosticsOnly) {
            for (JsonSchemaDocument jsdoc : jsdocs) {
                jsdoc.write();
            }
            if (this.options.parameterAsBoolean(this.getClass().getName(), "writeMapEntries", false)) {
                File outputDirectoryFile = new File(outputDirectory);
                for (Map.Entry<PackageInfo, List<ProcessMapEntry>> e : mapEntriesForEncodedTypesBySchemaPackage.entrySet()) {
                    PackageInfo schemaPi = e.getKey();
                    List<ProcessMapEntry> mapEntriesList = e.getValue();
                    String mapEntriesFileName = schemaPi.name().trim().replaceAll("\\W", "_") + "_mapEntries.xml";
                    File mapEntriesFile = new File(outputDirectoryFile, mapEntriesFileName);
                    MapEntries mapEntries = new MapEntries();
                    mapEntries.add(mapEntriesList);
                    mapEntries.toXml(mapEntriesFile, this.result);
                }
            }
        }
    }

    public static String normalizedJsonDocumentName(PackageInfo pi) {
        return pi.name().replace("/", "_").replace(" ", "_") + ".json";
    }

    public static String identifyJsonDirectory(PackageInfo pi) {
        String jsonDirectory = pi.taggedValue("jsonDirectory");
        if (StringUtils.isBlank((CharSequence)jsonDirectory)) {
            jsonDirectory = pi.xmlns();
        }
        jsonDirectory = StringUtils.isBlank((CharSequence)jsonDirectory) ? "default" : jsonDirectory.trim();
        return jsonDirectory;
    }

    public void addMapEntry(PackageInfo schemaPackage, ProcessMapEntry me) {
        List<ProcessMapEntry> mapEntries;
        if (mapEntriesForEncodedTypesBySchemaPackage.containsKey(schemaPackage)) {
            mapEntries = (List)mapEntriesForEncodedTypesBySchemaPackage.get(schemaPackage);
        } else {
            mapEntries = new ArrayList();
            mapEntriesForEncodedTypesBySchemaPackage.put(schemaPackage, mapEntries);
        }
        mapEntries.add(me);
    }

    @Override
    public void reset() {
        model = null;
        initialised = false;
        diagnosticsOnly = false;
        numberOfEncodedSchemas = 0;
        documentationTemplate = null;
        documentationNoValue = null;
        outputDirectory = null;
        jsonSchemaVersion = null;
        entityTypeName = null;
        inlineOrByRefDefault = null;
        linkObjectUri = null;
        byReferenceJsonSchemaDefinition = null;
        baseJsonSchemaDefinitionForFeatureTypes = null;
        baseJsonSchemaDefinitionForObjectTypes = null;
        baseJsonSchemaDefinitionForDataTypes = null;
        objectIdentifierName = "id";
        objectIdentifierType = new JsonSchemaType[]{JsonSchemaType.STRING};
        objectIdentifierRequired = false;
        mapEntryParamInfos = null;
        mapEntriesForEncodedTypesBySchemaPackage = new TreeMap<PackageInfo, List<ProcessMapEntry>>();
        entityTypeMemberPathByCi = new HashMap<ClassInfo, String>();
        jsDocsByPkg = new TreeMap<PackageInfo, JsonSchemaDocument>();
        jsDocsByCi = new HashMap<ClassInfo, JsonSchemaDocument>();
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
        r.addRule("rule-json-all-documentation");
        r.addRule("rule-json-all-notEncoded");
        r.addRule("rule-json-cls-basictype");
        r.addRule("rule-json-cls-codelist-link");
        r.addRule("rule-json-cls-codelist-uri-format");
        r.addRule("rule-json-cls-defaultGeometry-singleGeometryProperty");
        r.addRule("rule-json-cls-defaultGeometry-multipleGeometryProperties");
        r.addRule("rule-json-cls-identifierForTypeWithIdentity");
        r.addRule("rule-json-cls-identifierStereotype");
        r.addRule("rule-json-cls-ignoreIdentifier");
        r.addRule("rule-json-cls-name-as-anchor");
        r.addRule("rule-json-cls-name-as-entityType");
        r.addRule("rule-json-cls-name-as-entityType-union");
        r.addRule("rule-json-cls-nestedProperties");
        r.addRule("rule-json-cls-union-propertyCount");
        r.addRule("rule-json-cls-union-typeDiscriminator");
        r.addRule("rule-json-cls-valueTypeOptions");
        r.addRule("rule-json-cls-virtualGeneralization");
        r.addRule("rule-json-prop-derivedAsReadOnly");
        r.addRule("rule-json-prop-initialValueAsDefault");
        r.addRule("rule-json-prop-readOnly");
        r.addRule("rule-json-prop-voidable");
        ProcessRuleSet defaultGeoJsonPrs = new ProcessRuleSet("defaultGeoJson", "*", new TreeSet<String>(Stream.of("rule-json-cls-defaultGeometry-singleGeometryProperty", "rule-json-cls-ignoreIdentifier", "rule-json-cls-name-as-anchor", "rule-json-cls-nestedProperties", "rule-json-cls-virtualGeneralization", "rule-json-prop-derivedAsReadOnly", "rule-json-prop-initialValueAsDefault", "rule-json-prop-readOnly", "rule-json-prop-voidable").collect(Collectors.toSet())));
        r.addRuleSet(defaultGeoJsonPrs);
        ProcessRuleSet defaultPlainJsonPrs = new ProcessRuleSet("defaultPlainJson", "*", new TreeSet<String>(Stream.of("rule-json-cls-name-as-anchor", "rule-json-prop-derivedAsReadOnly", "rule-json-prop-initialValueAsDefault", "rule-json-prop-readOnly", "rule-json-prop-voidable").collect(Collectors.toSet())));
        r.addRuleSet(defaultPlainJsonPrs);
    }

    @Override
    public String getDefaultEncodingRule() {
        return "*";
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class '$1$'";
            }
            case 1: {
                return "Context: property '$1$'";
            }
            case 3: {
                return "Context: class JsonSchemaTarget";
            }
            case 4: {
                return "Processing class '$1$'.";
            }
            case 5: {
                return "Directory named '$1$' does not exist or is not accessible.";
            }
            case 6: {
                return "System error: Exception encountered. Message is: '$1$'";
            }
            case 7: {
                return "Schema '$1$' is not encoded.";
            }
            case 8: {
                return "Class '$1$' is not encoded.";
            }
            case 10: {
                return "Configuration parameter '$1$' has invalid value '$2$'. Using value '$3$' instead.";
            }
            case 15: {
                return "No map entries provided via the configuration.";
            }
            case 17: {
                return "Type '$1$' is of a category not enabled for conversion, meaning that no JSON Schema definition will be created to represent it.";
            }
            case 18: {
                return "Schema '$1$' is not encoded. Thus class '$2$' (which belongs to that schema) is not encoded either.";
            }
            case 19: {
                return "Type '$1$' is a union. By default, unions are not converted. The encoding rule that applies to '$1$' does not contain a conversion rule that would enable the encoding of the union. No JSON Schema definition will be created to represent '$1$'.";
            }
            case 20: {
                return "Type '$1$' directly or indirectly has a supertype that is implemented as simple JSON Schema type '$2$'. However, rule-json-cls-basictype does not apply to '$1$'. The type will be ignored.";
            }
            case 21: {
                return "Type '$1$' directly or indirectly has a supertype that is implemented as simple JSON Schema type. However, that JSON Schema type is not one of 'string', 'number', or 'boolean'. The JSON Schema type is '$2$' - which does not make sense for a basic type. Type '$1$' will be ignored.";
            }
            case 22: {
                return "Type '$1$' has been mapped to '$2$', as defined by the configuration.";
            }
            case 23: {
                return "Type '$1$' has been mapped to '$2$' with keywords, as defined by the configuration.";
            }
            case 101: {
                return "??Application schema '$1$' is not associated with a JSON Schema document. A default name is used for the JSON Schema document: '$2$'.";
            }
            case 102: {
                return "Creating JSON Schema document '$1$' for package '$2$'.";
            }
            case 103: {
                return "Package '$1$' not associated with any JSON Schema document. Set tagged value 'jsonDocument' on the according schema package. Package '$1$' will be associated with JSON Schema document '$2$'.";
            }
            case 503: {
                return "Output file '$1$' already exists in output directory ('$2$'). It will be deleted prior to processing.";
            }
            case 504: {
                return "File has been deleted.";
            }
            case 10001: {
                return "Generating JSON schemas for application schema $1$.";
            }
            case 10002: {
                return "Diagnostics-only mode. All output to files is suppressed.";
            }
        }
        return "(" + JsonSchemaTarget.class.getName() + ") Unknown message with number: " + mnr;
    }

    @Override
    public String getTargetName() {
        return "JSON Schema";
    }

    @Override
    public String getTargetIdentifier() {
        return "json";
    }

    public JsonSchemaVersion getJsonSchemaVersion() {
        return jsonSchemaVersion;
    }
}

