/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.JSON;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import de.interactive_instruments.ShapeChange.MapEntryParamInfos;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.JSON.JsonSchemaTarget;
import de.interactive_instruments.ShapeChange.Target.JSON.JsonSchemaTypeInfo;
import de.interactive_instruments.ShapeChange.Target.JSON.json.JsonBoolean;
import de.interactive_instruments.ShapeChange.Target.JSON.json.JsonInteger;
import de.interactive_instruments.ShapeChange.Target.JSON.json.JsonNumber;
import de.interactive_instruments.ShapeChange.Target.JSON.json.JsonString;
import de.interactive_instruments.ShapeChange.Target.JSON.json.JsonValue;
import de.interactive_instruments.ShapeChange.Target.JSON.jsonschema.FormatKeyword;
import de.interactive_instruments.ShapeChange.Target.JSON.jsonschema.JsonSchema;
import de.interactive_instruments.ShapeChange.Target.JSON.jsonschema.JsonSchemaType;
import de.interactive_instruments.ShapeChange.Target.JSON.jsonschema.JsonSchemaVersion;
import de.interactive_instruments.ShapeChange.Target.JSON.jsonschema.JsonSerializationContext;
import de.interactive_instruments.ShapeChange.Type;
import de.interactive_instruments.ShapeChange.Util.ValueTypeOptions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class JsonSchemaDocument
implements MessageSource {
    protected Options options;
    protected ShapeChangeResult result;
    protected Model model;
    protected JsonSchemaTarget jsonSchemaTarget;
    protected String docName;
    protected PackageInfo representedPackage;
    protected String jsonBaseUri;
    protected String jsonSubdirectory;
    protected String rootSchemaId;
    protected File jsonSchemaOutputFile;
    protected MapEntryParamInfos mapEntryParamInfos;
    protected JsonSchemaVersion jsonSchemaVersion;
    protected SortedMap<String, ClassInfo> classesByName = new TreeMap<String, ClassInfo>();
    protected Map<ClassInfo, JsonSchemaTypeInfo> basicTypeInfoByClass = new HashMap<ClassInfo, JsonSchemaTypeInfo>();
    protected JsonSchema rootSchema = new JsonSchema();

    public JsonSchemaDocument(PackageInfo representedPackage, Model model, Options options, ShapeChangeResult result, String docName, JsonSchemaTarget jsonSchemaTarget, String jsonBaseUri, String jsonSubdirectory, File jsonSchemaOutputFile, MapEntryParamInfos mapEntryParamInfos) {
        this.representedPackage = representedPackage;
        this.options = options;
        this.result = result;
        this.model = model;
        this.jsonSchemaTarget = jsonSchemaTarget;
        this.docName = docName;
        this.jsonBaseUri = jsonBaseUri;
        this.jsonSubdirectory = jsonSubdirectory;
        this.jsonSchemaOutputFile = jsonSchemaOutputFile;
        this.mapEntryParamInfos = mapEntryParamInfos;
        this.rootSchemaId = StringUtils.join((Object[])new String[]{StringUtils.removeEnd((String)jsonBaseUri, (String)"/"), StringUtils.removeEnd((String)jsonSubdirectory, (String)"/"), docName}, (String)"/");
        this.jsonSchemaVersion = jsonSchemaTarget.getJsonSchemaVersion();
        if (this.jsonSchemaVersion.getSchemaUri().isPresent()) {
            this.rootSchema.schema(this.jsonSchemaVersion.getSchemaUri().get());
        }
        this.rootSchema.id(this.rootSchemaId);
    }

    public void addClass(ClassInfo ci) {
        this.classesByName.put(ci.name(), ci);
    }

    public void addBasicType(ClassInfo ci, JsonSchemaTypeInfo simpleJsTypeInfo) {
        this.classesByName.put(ci.name(), ci);
        this.basicTypeInfoByClass.put(ci, simpleJsTypeInfo);
    }

    public boolean isBasicType(ClassInfo ci) {
        return this.basicTypeInfoByClass.containsKey(ci);
    }

    public boolean hasClasses() {
        return !this.classesByName.isEmpty();
    }

    public String getSchemaId() {
        return this.rootSchemaId;
    }

    public JsonSchemaVersion getSchemaVersion() {
        return this.jsonSchemaVersion;
    }

    public void createDefinitions() {
        for (ClassInfo ci : this.classesByName.values()) {
            ProcessMapEntry pme;
            String jsDefinitionReference;
            JsonSchema js = this.basicTypeInfoByClass.containsKey(ci) ? this.jsonSchemaForBasicType(ci) : (ci.category() == 8 && ci.matches("rule-json-cls-union-typeDiscriminator") ? this.jsonSchemaForTypeDiscriminatorUnion(ci) : (ci.category() == 3 ? this.jsonSchemaForEnumeration(ci) : (ci.category() == 2 ? this.jsonSchemaForCodelist(ci) : this.jsonSchema(ci))));
            if (this.jsonSchemaVersion == JsonSchemaVersion.DRAFT_2019_09) {
                this.rootSchema.def(ci.name(), js);
                jsDefinitionReference = this.rootSchemaId + "#/$defs/" + ci.name();
            } else {
                this.rootSchema.definition(ci.name(), js);
                jsDefinitionReference = this.rootSchemaId + "#/definitions/" + ci.name();
            }
            PackageInfo schemaPi = ci.pkg().rootPackage();
            String rule = "*";
            if (JsonSchemaTarget.entityTypeMemberPathByCi.containsKey(ci)) {
                String entityTypeMemberPath = JsonSchemaTarget.entityTypeMemberPathByCi.get(ci);
                String paramValue = "encodingInfos{entityTypeMemberPath=" + entityTypeMemberPath + "}";
                pme = new ProcessMapEntry(ci.name(), rule, jsDefinitionReference, paramValue);
            } else {
                pme = new ProcessMapEntry(ci.name(), rule, jsDefinitionReference);
            }
            this.jsonSchemaTarget.addMapEntry(schemaPi, pme);
        }
    }

    private String jsonSchemaDefinitionReference(JsonSchemaDocument jsd, ClassInfo ci) {
        String schemaId = jsd.getSchemaId();
        if (jsd.getSchemaVersion() != JsonSchemaVersion.OPENAPI_30 && ci.matches("rule-json-cls-name-as-anchor")) {
            return schemaId + "#" + ci.name();
        }
        if (jsd.getSchemaVersion() == JsonSchemaVersion.DRAFT_2019_09) {
            return schemaId + "#/$defs/" + ci.name();
        }
        return schemaId + "#/definitions/" + ci.name();
    }

    private JsonSchema jsonSchemaForBasicType(ClassInfo ci) {
        String format;
        JsonSchema jsClass = new JsonSchema();
        this.addCommonSchemaMembers(jsClass, ci);
        ArrayList<JsonSchema> allOfMembers = new ArrayList<JsonSchema>();
        ClassInfo supertype = ci.supertypeClasses().first();
        Optional<JsonSchemaTypeInfo> supertypeTypeInfo = this.identifyJsonSchemaTypeForSupertype(supertype, ci.encodingRule("json"));
        if (supertypeTypeInfo.isPresent()) {
            JsonSchema parentForSupertypeTypeDefSchema = new JsonSchema();
            this.createTypeDefinition(supertypeTypeInfo.get(), parentForSupertypeTypeDefSchema);
            allOfMembers.add(parentForSupertypeTypeDefSchema);
        }
        JsonSchemaTypeInfo jsImplementationTypeInfo = this.basicTypeInfoByClass.get(ci);
        JsonSchema restrictingFacetSchema = new JsonSchema();
        if (jsImplementationTypeInfo.getSimpleType() == JsonSchemaType.STRING) {
            String pattern;
            block18: {
                String length = ci.taggedValue("length");
                if (StringUtils.isBlank((CharSequence)length)) {
                    length = ci.taggedValue("maxLength");
                }
                if (StringUtils.isBlank((CharSequence)length)) {
                    length = ci.taggedValue("size");
                }
                if (StringUtils.isNotBlank((CharSequence)length)) {
                    try {
                        int lengthValue = Integer.parseInt(length.trim());
                        if (lengthValue < 0) {
                            ShapeChangeResult.MessageContext mc = this.result.addError(this, 102, ci.name(), length);
                            if (mc != null) {
                                mc.addDetail(this, 0, ci.fullName());
                            }
                        } else {
                            restrictingFacetSchema.maxLength(lengthValue);
                        }
                    }
                    catch (NumberFormatException e) {
                        ShapeChangeResult.MessageContext mc = this.result.addError(this, 101, ci.name(), length);
                        if (mc == null) break block18;
                        mc.addDetail(this, 0, ci.fullName());
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(pattern = ci.taggedValue("jsonPattern")))) {
                restrictingFacetSchema.pattern(pattern);
            }
        } else if (jsImplementationTypeInfo.getSimpleType() == JsonSchemaType.NUMBER || jsImplementationTypeInfo.getSimpleType() == JsonSchemaType.INTEGER) {
            Double maxDouble;
            String max;
            Double minDouble;
            String min = ci.taggedValue("rangeMinimum");
            if (StringUtils.isNotBlank((CharSequence)min) && (minDouble = this.parseRestrictingFacetAsDouble(ci, min, "rangeMinimum", "minimum")) != null) {
                restrictingFacetSchema.minimum(minDouble);
            }
            if (StringUtils.isNotBlank((CharSequence)(max = ci.taggedValue("rangeMaximum"))) && (maxDouble = this.parseRestrictingFacetAsDouble(ci, max, "rangeMaximum", "maximum")) != null) {
                restrictingFacetSchema.maximum(maxDouble);
            }
        }
        if (jsImplementationTypeInfo.getSimpleType() != JsonSchemaType.BOOLEAN && StringUtils.isNotBlank((CharSequence)(format = ci.taggedValue("jsonFormat")))) {
            restrictingFacetSchema.format(format);
        }
        if (restrictingFacetSchema.isEmpty()) {
            jsClass.addAll((Collection)allOfMembers.get(0));
        } else {
            allOfMembers.add(restrictingFacetSchema);
            jsClass.allOf(allOfMembers.toArray(new JsonSchema[allOfMembers.size()]));
        }
        return jsClass;
    }

    private Double parseRestrictingFacetAsDouble(ClassInfo ci, String stringValue, String tvName, String jsKeywordName) {
        try {
            double doubleValue = Double.parseDouble(stringValue.trim());
            return doubleValue;
        }
        catch (NumberFormatException e) {
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 103, ci.name(), stringValue, tvName, jsKeywordName);
            if (mc != null) {
                mc.addDetail(this, 0, ci.fullName());
            }
            return null;
        }
    }

    private JsonSchema jsonSchemaForCodelist(ClassInfo ci) {
        JsonSchema jsClass = new JsonSchema();
        this.addCommonSchemaMembers(jsClass, ci);
        if (ci.matches("rule-json-cls-codelist-uri-format")) {
            jsClass.type(JsonSchemaType.STRING);
            jsClass.format("uri");
        } else if (ci.matches("rule-json-cls-codelist-link")) {
            jsClass.ref(this.jsonSchemaTarget.getLinkObjectUri());
        } else {
            JsonSchemaTypeInfo jsti = this.identifyLiteralEncodingType(ci);
            this.createTypeDefinition(jsti, jsClass);
        }
        return jsClass;
    }

    private JsonSchemaTypeInfo identifyLiteralEncodingType(ClassInfo ci) {
        String jsonEncodingRuleForCi;
        Optional<JsonSchemaTypeInfo> jstiOpt;
        String literalEncodingType = "CharacterString";
        if (StringUtils.isNotBlank((CharSequence)ci.taggedValue("literalEncodingType"))) {
            literalEncodingType = ci.taggedValue("literalEncodingType").trim();
        }
        if ((jstiOpt = this.identifyJsonSchemaType(literalEncodingType, null, jsonEncodingRuleForCi = ci.encodingRule("json"))).isPresent()) {
            return jstiOpt.get();
        }
        ShapeChangeResult.MessageContext mc = this.result.addError(this, 119, ci.name(), literalEncodingType);
        if (mc != null) {
            this.result.addInfo(this, 0, ci.fullNameInSchema());
        }
        JsonSchemaTypeInfo jsti = new JsonSchemaTypeInfo();
        jsti.setSimpleType(JsonSchemaType.STRING);
        return jsti;
    }

    private JsonSchema jsonSchemaForEnumeration(ClassInfo ci) {
        JsonSchema jsClass = new JsonSchema();
        this.addCommonSchemaMembers(jsClass, ci);
        JsonSchemaTypeInfo jsti = this.identifyLiteralEncodingType(ci);
        this.createTypeDefinition(jsti, jsClass);
        JsonSchemaType enumerationJsType = jsti.getSimpleType();
        if (enumerationJsType == null) {
            ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 120, ci.name(), jsti.getRef());
            if (mc != null) {
                mc.addDetail(this, 0, ci.fullNameInSchema());
            }
            enumerationJsType = JsonSchemaType.STRING;
        }
        for (PropertyInfo pi : ci.properties().values()) {
            ShapeChangeResult.MessageContext mc;
            String stringValue;
            if (!JsonSchemaTarget.isEncoded(pi)) {
                this.result.addInfo(this, 9, pi.name(), pi.inClass().name());
                continue;
            }
            if (enumerationJsType == JsonSchemaType.INTEGER) {
                stringValue = StringUtils.isNotBlank((CharSequence)pi.initialValue()) ? pi.initialValue() : pi.name();
                try {
                    int intValue = Integer.parseInt(stringValue);
                    jsClass.enum_(new JsonInteger(intValue));
                }
                catch (NumberFormatException e) {
                    mc = this.result.addError(this, 109, stringValue, pi.name(), ci.name());
                    if (mc == null) continue;
                    mc.addDetail(this, 1, pi.fullName());
                }
                continue;
            }
            if (enumerationJsType == JsonSchemaType.NUMBER) {
                stringValue = StringUtils.isNotBlank((CharSequence)pi.initialValue()) ? pi.initialValue() : pi.name();
                try {
                    double doubleValue = Double.parseDouble(stringValue);
                    jsClass.enum_(new JsonNumber(doubleValue));
                }
                catch (NumberFormatException e) {
                    mc = this.result.addError(this, 110, stringValue, pi.name(), ci.name());
                    if (mc == null) continue;
                    mc.addDetail(this, 1, pi.fullName());
                }
                continue;
            }
            if (enumerationJsType == JsonSchemaType.BOOLEAN) {
                String string = stringValue = StringUtils.isNotBlank((CharSequence)pi.initialValue()) ? pi.initialValue() : pi.name();
                if ("true".equalsIgnoreCase(stringValue.trim()) || "1".equals(stringValue.trim())) {
                    jsClass.enum_(new JsonBoolean(true));
                    continue;
                }
                jsClass.enum_(new JsonBoolean(false));
                continue;
            }
            String value = StringUtils.isNotBlank((CharSequence)pi.initialValue()) ? pi.initialValue() : pi.name();
            jsClass.enum_(new JsonString(value));
        }
        return jsClass;
    }

    private JsonSchema jsonSchemaForTypeDiscriminatorUnion(ClassInfo ci) {
        JsonSchema jsClass = new JsonSchema();
        this.addCommonSchemaMembers(jsClass, ci);
        ArrayList<JsonSchemaTypeInfo> typeInfos = new ArrayList<JsonSchemaTypeInfo>();
        HashSet<CallSite> encounteredTypes = new HashSet<CallSite>();
        for (PropertyInfo pi : ci.properties().values()) {
            if (!JsonSchemaTarget.isEncoded(pi)) {
                this.result.addInfo(this, 9, pi.name(), pi.inClass().name());
                continue;
            }
            Type t = pi.typeInfo();
            String typeKey = StringUtils.stripToEmpty((String)t.name) + "#" + StringUtils.stripToEmpty((String)t.id);
            if (encounteredTypes.contains(typeKey)) continue;
            encounteredTypes.add((CallSite)((Object)typeKey));
            Optional<JsonSchemaTypeInfo> jstiOpt = this.identifyJsonSchemaType(pi);
            if (!jstiOpt.isPresent()) continue;
            typeInfos.add(jstiOpt.get());
        }
        this.createTypeDefinition(typeInfos, null, jsClass);
        return jsClass;
    }

    private void addCommonSchemaMembers(JsonSchema jsClass, ClassInfo ci) {
        if (this.jsonSchemaVersion != JsonSchemaVersion.OPENAPI_30 && ci.matches("rule-json-cls-name-as-anchor")) {
            if (this.jsonSchemaVersion == JsonSchemaVersion.DRAFT_2019_09) {
                jsClass.anchor(ci.name());
            } else {
                jsClass.id("#" + ci.name());
            }
        }
    }

    private JsonSchema jsonSchema(ClassInfo ci) {
        LinkedHashMap<String, JsonSchema> classProperties;
        Optional<LinkedHashMap<String, JsonSchema>> optional;
        String valueTypeOptionsTV;
        JsonSchema jsClass = new JsonSchema();
        this.addCommonSchemaMembers(jsClass, ci);
        JsonSchema jsClassContents = jsClass;
        ArrayList<JsonSchema> allOfMembers = new ArrayList<JsonSchema>();
        SortedSet<ClassInfo> supertypes = ci.supertypeClasses();
        this.handleVirtualGeneralization(ci, supertypes, allOfMembers);
        if (!(ci.category() != 1 && ci.category() != 6 && ci.category() != 5 && ci.category() != 4 || supertypes.isEmpty())) {
            for (ClassInfo supertype : supertypes) {
                Optional<JsonSchemaTypeInfo> typeInfo = this.identifyJsonSchemaTypeForSupertype(supertype, ci.encodingRule("json"));
                if (!typeInfo.isPresent()) continue;
                if (typeInfo.get().isSimpleType()) {
                    ShapeChangeResult.MessageContext mc = this.result.addError(this, 108, supertype.name(), ci.name(), typeInfo.get().getSimpleType().getName());
                    if (mc == null) continue;
                    mc.addDetail(this, 0, ci.fullName());
                    continue;
                }
                allOfMembers.add(new JsonSchema().ref(typeInfo.get().getRef()));
            }
        }
        if (!allOfMembers.isEmpty()) {
            jsClassContents = new JsonSchema();
            allOfMembers.add(jsClassContents);
            jsClass.allOf(allOfMembers.toArray(new JsonSchema[allOfMembers.size()]));
        }
        jsClassContents.type(JsonSchemaType.OBJECT);
        PropertyInfo defaultGeometryPi = null;
        if (ci.category() != 8 && !ci.properties().isEmpty() && (ci.matches("rule-json-cls-defaultGeometry-singleGeometryProperty") || ci.matches("rule-json-cls-defaultGeometry-multipleGeometryProperties"))) {
            HashMap<PropertyInfo, JsonSchemaTypeInfo> typeInfoByGeometryPi = new HashMap<PropertyInfo, JsonSchemaTypeInfo>();
            PropertyInfo directGeometryPi = null;
            HashSet<PropertyInfo> directProperties = new HashSet<PropertyInfo>(ci.properties().values());
            for (PropertyInfo pi2 : ci.propertiesAll()) {
                JsonSchemaTypeInfo typeInfo;
                if (!JsonSchemaTarget.isEncoded(pi2)) {
                    this.result.addInfo(this, 9, pi2.name(), pi2.inClass().name());
                    continue;
                }
                Optional<JsonSchemaTypeInfo> optional2 = this.identifyJsonSchemaType(pi2);
                if (!optional2.isPresent() || !(typeInfo = optional2.get()).isGeometry() || !ci.matches("rule-json-cls-defaultGeometry-singleGeometryProperty") && !"true".equalsIgnoreCase(pi2.taggedValue("defaultGeometry"))) continue;
                if (directProperties.contains(pi2)) {
                    directGeometryPi = pi2;
                }
                typeInfoByGeometryPi.put(pi2, typeInfo);
            }
            if (directGeometryPi != null) {
                if (typeInfoByGeometryPi.size() == 1) {
                    ShapeChangeResult.MessageContext mc;
                    jsClassContents.property("geometry", new JsonSchema().ref(((JsonSchemaTypeInfo)typeInfoByGeometryPi.get(directGeometryPi)).getRef()));
                    if (directGeometryPi.cardinality().maxOccurs > 1 && (mc = this.result.addWarning(this, 117, directGeometryPi.name(), ci.name())) != null) {
                        mc.addDetail(this, 1, directGeometryPi.fullName());
                    }
                    defaultGeometryPi = directGeometryPi;
                } else if (typeInfoByGeometryPi.size() > 1) {
                    String geometryPiNames = typeInfoByGeometryPi.keySet().stream().map(pi -> pi.name()).sorted().collect(Collectors.joining(", "));
                    ShapeChangeResult.MessageContext mc = this.result.addError(this, 112, ci.name(), geometryPiNames);
                    if (mc != null) {
                        mc.addDetail(this, 0, ci.fullName());
                    }
                }
            }
        }
        JsonSchema jsProperties = jsClassContents;
        if (ci.category() != 5 && ci.category() != 8 && ci.matches("rule-json-cls-nestedProperties")) {
            jsProperties = new JsonSchema();
            jsProperties.type(JsonSchemaType.OBJECT);
            jsClassContents.property("properties", jsProperties).required("properties");
        }
        String entityTypeMemberPathFromSupertypes = this.identifyEntityTypeMemberPathFromSupertypes(ci);
        Object entityTypeMemberPath = null;
        if (entityTypeMemberPathFromSupertypes == null) {
            if (ci.matches("rule-json-cls-name-as-entityType") && (ci.category() != 8 || ci.matches("rule-json-cls-name-as-entityType-union"))) {
                String entityTypeMemberName = this.jsonSchemaTarget.getEntityTypeName();
                jsProperties.property(entityTypeMemberName, new JsonSchema().type(JsonSchemaType.STRING)).required(entityTypeMemberName);
                entityTypeMemberPath = (ci.matches("rule-json-cls-nestedProperties") ? "properties/" : "") + entityTypeMemberName;
            }
        } else {
            entityTypeMemberPath = entityTypeMemberPathFromSupertypes;
        }
        if (entityTypeMemberPath != null) {
            JsonSchemaTarget.entityTypeMemberPathByCi.put(ci, (String)entityTypeMemberPath);
        }
        if (!(ci.category() != 1 && ci.category() != 6 || !ci.matches("rule-json-cls-identifierForTypeWithIdentity") || ci.matches("rule-json-cls-ignoreIdentifier") || ci.matches("rule-json-cls-identifierStereotype"))) {
            boolean supertypeMatch = false;
            for (ClassInfo classInfo : ci.supertypeClasses()) {
                if (classInfo.category() != 1 && classInfo.category() != 6 || !classInfo.matches("rule-json-cls-identifierForTypeWithIdentity") || classInfo.matches("rule-json-cls-ignoreIdentifier") || classInfo.matches("rule-json-cls-identifierStereotype")) continue;
                supertypeMatch = true;
                break;
            }
            if (!supertypeMatch) {
                JsonSchema objectIdentifierTypeSchema = new JsonSchema();
                this.createTypeDefinition(this.jsonSchemaTarget.objectIdentifierType(), objectIdentifierTypeSchema);
                jsProperties.property(this.jsonSchemaTarget.objectIdentifierName(), objectIdentifierTypeSchema);
                if (this.jsonSchemaTarget.objectIdentifierRequired()) {
                    jsProperties.required(this.jsonSchemaTarget.objectIdentifierName());
                }
            }
        }
        ValueTypeOptions vto = StringUtils.isNotBlank((CharSequence)(valueTypeOptionsTV = ci.taggedValue("valueTypeOptions"))) && ci.matches("rule-json-cls-valueTypeOptions") ? new ValueTypeOptions(valueTypeOptionsTV) : new ValueTypeOptions();
        for (PropertyInfo pi3 : ci.properties().values()) {
            if (!JsonSchemaTarget.isEncoded(pi3)) {
                this.result.addInfo(this, 9, pi3.name(), pi3.inClass().name());
                continue;
            }
            if (pi3 == defaultGeometryPi) continue;
            if (pi3.stereotype("identifier") && ci.matches("rule-json-cls-identifierStereotype")) {
                ShapeChangeResult.MessageContext mc;
                if (ci.matches("rule-json-cls-ignoreIdentifier")) continue;
                if (pi3.cardinality().maxOccurs > 1 && (mc = this.result.addError(this, 113, pi3.name(), ci.name())) != null) {
                    mc.addDetail(this, 1, pi3.fullName());
                }
            }
            jsProperties.property(pi3.name(), this.jsonSchema(pi3, vto));
            vto.remove(pi3.name());
            if (ci.category() == 8 || pi3.cardinality().minOccurs <= 0) continue;
            jsProperties.required(pi3.name());
        }
        for (String supertypePropertyName : vto.getPropertiesWithValueTypeOptions()) {
            PropertyInfo supertypePi = ci.property(supertypePropertyName);
            if (supertypePi == null || (supertypePi.categoryOfValue() == 1 || supertypePi.categoryOfValue() == 6) && "byReference".equalsIgnoreCase(this.inlineOrByReference(supertypePi))) continue;
            SortedSet<String> supertypePropertyTypeOptions = vto.getValueTypeOptions(supertypePropertyName);
            ArrayList<JsonSchemaTypeInfo> supertypePropertyTypeInfos = new ArrayList<JsonSchemaTypeInfo>();
            JsonSchema supertypePropertyTypeRestrictionSchema = new JsonSchema();
            boolean isAssociationClassRole = vto.isAssociationClassRole(supertypePropertyName);
            TreeMap<String, JsonSchemaTypeInfo> valueTypeOptionsByTypeName = new TreeMap<String, JsonSchemaTypeInfo>();
            for (String supertypePropertyTypeOption : supertypePropertyTypeOptions) {
                Optional<JsonSchemaTypeInfo> jstdOpt = this.identifyJsonSchemaType(supertypePropertyTypeOption, null, ci.encodingRule("json"));
                if (!jstdOpt.isPresent()) continue;
                valueTypeOptionsByTypeName.put(supertypePropertyTypeOption, jstdOpt.get());
            }
            boolean byReferenceAllowedForSupertypeProperty = false;
            if (!(supertypePi.categoryOfValue() != 1 && supertypePi.categoryOfValue() != 6 || "inline".equalsIgnoreCase(this.inlineOrByReference(supertypePi)))) {
                byReferenceAllowedForSupertypeProperty = true;
                supertypePropertyTypeInfos.add(this.createJsonSchemaTypeInfoForReference());
            }
            JsonSchema parentForTypeSchema = supertypePropertyTypeRestrictionSchema;
            if (supertypePi.voidable() && supertypePi.matches("rule-json-prop-voidable")) {
                if (supertypePi.cardinality().maxOccurs == 1) {
                    JsonSchemaTypeInfo nullTypeInfo = new JsonSchemaTypeInfo();
                    nullTypeInfo.setSimpleType(JsonSchemaType.NULL);
                    supertypePropertyTypeInfos.add(nullTypeInfo);
                } else if (this.jsonSchemaVersion == JsonSchemaVersion.OPENAPI_30) {
                    parentForTypeSchema.nullable(true);
                } else {
                    JsonSchema nullTypeSchemaDef = new JsonSchema();
                    nullTypeSchemaDef.type(JsonSchemaType.NULL);
                    JsonSchema nonNullTypeSchemaDef = new JsonSchema();
                    parentForTypeSchema.oneOf(nullTypeSchemaDef, nonNullTypeSchemaDef);
                    parentForTypeSchema = nonNullTypeSchemaDef;
                }
            }
            if (supertypePi.cardinality().maxOccurs > 1) {
                parentForTypeSchema.type(JsonSchemaType.ARRAY);
                JsonSchema itemsSchema = new JsonSchema();
                parentForTypeSchema.items(itemsSchema);
                parentForTypeSchema = itemsSchema;
            }
            if (valueTypeOptionsByTypeName.isEmpty()) {
                this.createTypeDefinition(supertypePropertyTypeInfos, null, parentForTypeSchema);
            } else if (isAssociationClassRole) {
                this.createTypeDefinitionWithValueTypeOptionsForAssociationClassRole(valueTypeOptionsByTypeName, supertypePropertyTypeInfos, this.identifyJsonSchemaType(supertypePi), supertypePi.name(), byReferenceAllowedForSupertypeProperty, parentForTypeSchema);
            } else {
                this.createTypeDefinition(valueTypeOptionsByTypeName, supertypePropertyTypeInfos, parentForTypeSchema);
            }
            jsProperties.property(supertypePropertyName, supertypePropertyTypeRestrictionSchema);
        }
        if (ci.category() == 8 && ci.matches("rule-json-cls-union-propertyCount")) {
            int n;
            jsClassContents.additionalProperties(JsonSchema.FALSE);
            boolean bl = true;
            if (ci.matches("rule-json-cls-name-as-entityType") && ci.matches("rule-json-cls-name-as-entityType-union")) {
                n = 2;
            }
            jsClassContents.minProperties(n);
            jsClassContents.maxProperties(n);
        }
        if (ci.category() != 5 && ci.category() != 8 && ci.matches("rule-json-cls-nestedProperties") && (optional = jsClassContents.properties()).isPresent() && (classProperties = optional.get()).containsKey("properties")) {
            JsonSchema propertiesMemberSchema = classProperties.get("properties");
            Optional<LinkedHashMap<String, JsonSchema>> propertiesMemberPropertiesOpt = propertiesMemberSchema.properties();
            if (propertiesMemberPropertiesOpt.isEmpty()) {
                jsClassContents.removeProperty("properties").removeRequired("properties");
            } else {
                Optional<SortedSet<String>> propertiesMemberRequiredOpt = propertiesMemberSchema.required();
                if (propertiesMemberRequiredOpt.isEmpty() || propertiesMemberRequiredOpt.get().isEmpty()) {
                    jsClassContents.removeRequired("properties");
                }
            }
        }
        return jsClass;
    }

    private String identifyEntityTypeMemberPath(ClassInfo ci) {
        if (JsonSchemaTarget.entityTypeMemberPathByCi.containsKey(ci)) {
            return JsonSchemaTarget.entityTypeMemberPathByCi.get(ci);
        }
        String entityTypeMemberPathFromSupertypes = this.identifyEntityTypeMemberPathFromSupertypes(ci);
        if (entityTypeMemberPathFromSupertypes != null) {
            return entityTypeMemberPathFromSupertypes;
        }
        if (ci.matches("rule-json-cls-name-as-entityType") && (ci.category() != 8 || ci.matches("rule-json-cls-name-as-entityType-union"))) {
            return (ci.matches("rule-json-cls-nestedProperties") ? "properties/" : "") + this.jsonSchemaTarget.getEntityTypeName();
        }
        return null;
    }

    private String identifyEntityTypeMemberPathFromSupertypes(ClassInfo ci) {
        String resultFromMapEntries = null;
        String resultFromSuperSupertypes = null;
        String resultFromSupertypes = null;
        for (ClassInfo supertype : ci.supertypeClasses()) {
            Optional<ProcessMapEntry> supertypePmeOpt = this.jsonSchemaTarget.mapEntry(supertype);
            if (supertypePmeOpt.isPresent()) {
                if (!this.mapEntryParamInfos.hasCharacteristic(supertype.name(), supertype.encodingRule("json"), "encodingInfos", "entityTypeMemberPath")) continue;
                resultFromMapEntries = this.mapEntryParamInfos.getCharacteristic(supertype.name(), supertype.encodingRule("json"), "encodingInfos", "entityTypeMemberPath");
                break;
            }
            String entityMemberPathFromSupertypesOfSupertype = this.identifyEntityTypeMemberPathFromSupertypes(supertype);
            if (entityMemberPathFromSupertypesOfSupertype != null) {
                resultFromSuperSupertypes = entityMemberPathFromSupertypesOfSupertype;
                continue;
            }
            if (!supertype.matches("rule-json-cls-name-as-entityType") || supertype.category() == 8 && !supertype.matches("rule-json-cls-name-as-entityType-union")) continue;
            resultFromSupertypes = (supertype.matches("rule-json-cls-nestedProperties") ? "properties/" : "") + this.jsonSchemaTarget.getEntityTypeName();
        }
        if (resultFromMapEntries != null) {
            return resultFromMapEntries;
        }
        if (resultFromSuperSupertypes != null) {
            return resultFromSuperSupertypes;
        }
        if (resultFromSupertypes != null) {
            return resultFromSupertypes;
        }
        return null;
    }

    private void handleVirtualGeneralization(ClassInfo ci, SortedSet<ClassInfo> supertypes, List<JsonSchema> allOfMembers) {
        if (ci.matches("rule-json-cls-virtualGeneralization")) {
            String baseJsonSchemaDef = null;
            if (ci.category() == 1) {
                baseJsonSchemaDef = this.jsonSchemaTarget.baseJsonSchemaDefinitionForFeatureTypes();
            } else if (ci.category() == 6) {
                baseJsonSchemaDef = this.jsonSchemaTarget.baseJsonSchemaDefinitionForObjectTypes();
            } else if (ci.category() == 5) {
                baseJsonSchemaDef = this.jsonSchemaTarget.baseJsonSchemaDefinitionForDataTypes();
            }
            if (baseJsonSchemaDef != null) {
                boolean applyVirtualGeneralization = true;
                if (!supertypes.isEmpty()) {
                    for (ClassInfo supertype : supertypes) {
                        if (!supertype.matches("rule-json-cls-virtualGeneralization")) continue;
                        applyVirtualGeneralization = false;
                        break;
                    }
                }
                if (applyVirtualGeneralization) {
                    allOfMembers.add(new JsonSchema().ref(baseJsonSchemaDef));
                }
            }
        }
    }

    private String inlineOrByReference(PropertyInfo pi) {
        String s = pi.taggedValue("inlineOrByReference");
        if (StringUtils.isBlank((CharSequence)s)) {
            return this.jsonSchemaTarget.getInlineOrByRefDefault();
        }
        return s;
    }

    private JsonSchemaTypeInfo createJsonSchemaTypeInfoForReference() {
        JsonSchemaTypeInfo byRefInfo = new JsonSchemaTypeInfo();
        if (this.jsonSchemaTarget.byReferenceJsonSchemaDefinition().isPresent()) {
            byRefInfo.setRef(this.jsonSchemaTarget.byReferenceJsonSchemaDefinition().get());
        } else {
            byRefInfo.setSimpleType(JsonSchemaType.STRING);
            byRefInfo.setKeyword(new FormatKeyword("uri"));
        }
        return byRefInfo;
    }

    private JsonSchema jsonSchema(PropertyInfo pi, ValueTypeOptions valueTypeOptions) {
        JsonSchema jsProp;
        ArrayList<JsonSchemaTypeInfo> typeOptions = new ArrayList<JsonSchemaTypeInfo>();
        Object associationClassRoleWithTypeValueOptionsSchema = null;
        Optional<JsonSchemaTypeInfo> typeInfoOpt = this.identifyJsonSchemaType(pi);
        boolean isAssociationClassRole = valueTypeOptions.isAssociationClassRole(pi.name());
        TreeMap<String, JsonSchemaTypeInfo> valueTypeOptionsByTypeName = new TreeMap<String, JsonSchemaTypeInfo>();
        boolean byReferenceAllowed = false;
        if (typeInfoOpt.isPresent()) {
            JsonSchemaTypeInfo typeInfo = typeInfoOpt.get();
            boolean byReferenceOnly = false;
            if ((pi.categoryOfValue() == 1 || pi.categoryOfValue() == 6 && !this.valueTypeIsBasicType(pi)) && !typeInfo.isSimpleType()) {
                boolean addByReferenceOption = false;
                if ("byReference".equalsIgnoreCase(this.inlineOrByReference(pi))) {
                    byReferenceOnly = true;
                    addByReferenceOption = true;
                } else if (!"inline".equalsIgnoreCase(this.inlineOrByReference(pi))) {
                    addByReferenceOption = true;
                    byReferenceAllowed = true;
                }
                if (addByReferenceOption) {
                    typeOptions.add(this.createJsonSchemaTypeInfoForReference());
                }
            }
            if (!byReferenceOnly) {
                if (valueTypeOptions != null && valueTypeOptions.hasValueTypeOptions(pi.name())) {
                    SortedSet<String> options = valueTypeOptions.getValueTypeOptions(pi.name());
                    for (String piValueTypeOption : options) {
                        Optional<JsonSchemaTypeInfo> jstdOpt = this.identifyJsonSchemaType(piValueTypeOption, null, pi.encodingRule("json"));
                        if (!jstdOpt.isPresent()) continue;
                        valueTypeOptionsByTypeName.put(piValueTypeOption, jstdOpt.get());
                    }
                } else {
                    typeOptions.add(typeInfo);
                }
            }
        }
        JsonSchema parentForTypeSchema = jsProp = new JsonSchema();
        if (pi.voidable() && pi.matches("rule-json-prop-voidable")) {
            if (pi.cardinality().maxOccurs == 1) {
                JsonSchemaTypeInfo nullTypeInfo = new JsonSchemaTypeInfo();
                nullTypeInfo.setSimpleType(JsonSchemaType.NULL);
                typeOptions.add(nullTypeInfo);
            } else if (this.jsonSchemaVersion == JsonSchemaVersion.OPENAPI_30) {
                parentForTypeSchema.nullable(true);
            } else {
                JsonSchema nullTypeSchemaDef = new JsonSchema();
                nullTypeSchemaDef.type(JsonSchemaType.NULL);
                JsonSchema nonNullTypeSchemaDef = new JsonSchema();
                jsProp.oneOf(nullTypeSchemaDef, nonNullTypeSchemaDef);
                parentForTypeSchema = nonNullTypeSchemaDef;
            }
        }
        if (pi.cardinality().maxOccurs > 1) {
            parentForTypeSchema.type(JsonSchemaType.ARRAY);
            if (pi.cardinality().minOccurs > 0) {
                parentForTypeSchema.minItems(pi.cardinality().minOccurs);
            }
            if (pi.cardinality().maxOccurs < Integer.MAX_VALUE) {
                parentForTypeSchema.maxItems(pi.cardinality().maxOccurs);
            }
            JsonSchema itemsSchema = null;
            if (!typeOptions.isEmpty() || associationClassRoleWithTypeValueOptionsSchema != null) {
                itemsSchema = new JsonSchema();
                parentForTypeSchema.items(itemsSchema);
            }
            if (pi.isUnique()) {
                parentForTypeSchema.uniqueItems(true);
            }
            if (itemsSchema != null) {
                parentForTypeSchema = itemsSchema;
            }
        }
        if (valueTypeOptionsByTypeName.isEmpty()) {
            this.createTypeDefinition(typeOptions, null, parentForTypeSchema);
        } else if (isAssociationClassRole) {
            this.createTypeDefinitionWithValueTypeOptionsForAssociationClassRole(valueTypeOptionsByTypeName, typeOptions, typeInfoOpt, pi.name(), byReferenceAllowed, parentForTypeSchema);
        } else {
            this.createTypeDefinition(valueTypeOptionsByTypeName, typeOptions, parentForTypeSchema);
        }
        if (typeInfoOpt.isPresent()) {
            JsonSchemaTypeInfo typeInfo = typeInfoOpt.get();
            if (pi.isAttribute() && StringUtils.isNotBlank((CharSequence)pi.initialValue()) && pi.matches("rule-json-prop-initialValueAsDefault")) {
                JsonSchemaTypeInfo actualTypeInfo = typeInfo;
                if (this.valueTypeIsBasicType(pi)) {
                    actualTypeInfo = this.getBasicValueTypeDefinition(pi).get();
                }
                if (typeInfo.isSimpleType() || this.valueTypeIsBasicType(pi)) {
                    ShapeChangeResult.MessageContext mc;
                    if (typeInfo.getSimpleType() == JsonSchemaType.BOOLEAN) {
                        jsProp.default_(new JsonBoolean(pi.initialValue().trim()));
                    } else if (typeInfo.getSimpleType() == JsonSchemaType.INTEGER) {
                        try {
                            int intValue = Integer.parseInt(pi.initialValue().trim());
                            jsProp.default_(new JsonInteger(intValue));
                        }
                        catch (NumberFormatException e) {
                            mc = this.result.addError(this, 106, pi.initialValue(), pi.name());
                            if (mc != null) {
                                mc.addDetail(this, 1, pi.fullName());
                            }
                        }
                    } else if (typeInfo.getSimpleType() == JsonSchemaType.NUMBER) {
                        try {
                            double doubleValue = Double.parseDouble(pi.initialValue().trim());
                            jsProp.default_(new JsonNumber(doubleValue));
                        }
                        catch (NumberFormatException e) {
                            mc = this.result.addError(this, 107, pi.initialValue(), pi.name());
                            if (mc != null) {
                                mc.addDetail(this, 1, pi.fullName());
                            }
                        }
                    } else {
                        jsProp.default_(new JsonString(pi.initialValue()));
                    }
                }
            }
        }
        if (pi.isReadOnly() && pi.matches("rule-json-prop-readOnly") || pi.isDerived() && pi.matches("rule-json-prop-derivedAsReadOnly")) {
            jsProp.readOnly(true);
        }
        return jsProp;
    }

    private boolean valueTypeIsBasicType(PropertyInfo pi) {
        ClassInfo tci = this.model.classByIdOrName(pi.typeInfo());
        if (tci == null) {
            return false;
        }
        Optional<JsonSchemaDocument> jsdOpt = this.jsonSchemaTarget.jsonSchemaDocument(tci);
        if (jsdOpt.isEmpty()) {
            return false;
        }
        return jsdOpt.get().hasBasicTypeDefinition(tci);
    }

    private Optional<JsonSchemaTypeInfo> getBasicValueTypeDefinition(PropertyInfo pi) {
        Optional<JsonSchemaDocument> jsdOpt;
        ClassInfo tci = this.model.classByIdOrName(pi.typeInfo());
        JsonSchemaTypeInfo result = tci == null ? null : ((jsdOpt = this.jsonSchemaTarget.jsonSchemaDocument(tci)).isEmpty() ? null : jsdOpt.get().getBasicTypeDefinition(tci));
        return Optional.of(result);
    }

    public boolean hasBasicTypeDefinition(ClassInfo ci) {
        return this.basicTypeInfoByClass.containsKey(ci);
    }

    public JsonSchemaTypeInfo getBasicTypeDefinition(ClassInfo ci) {
        return this.basicTypeInfoByClass.get(ci);
    }

    private void createTypeDefinition(JsonSchemaTypeInfo typeInfo, JsonSchema parentForTypeSchema) {
        ArrayList<JsonSchemaTypeInfo> list = new ArrayList<JsonSchemaTypeInfo>();
        list.add(typeInfo);
        this.createTypeDefinition(list, null, parentForTypeSchema);
    }

    private void createTypeDefinition(JsonSchemaType[] types, JsonSchema parentForTypeSchema) {
        ArrayList<JsonSchemaTypeInfo> list = new ArrayList<JsonSchemaTypeInfo>();
        for (JsonSchemaType jst : types) {
            JsonSchemaTypeInfo jsti = new JsonSchemaTypeInfo();
            jsti.setSimpleType(jst);
            list.add(jsti);
        }
        this.createTypeDefinition(list, null, parentForTypeSchema);
    }

    private void createTypeDefinition(List<JsonSchemaTypeInfo> typeInfos, JsonSchema specificTypeSchema, JsonSchema parentForTypeSchema) {
        List simpleTypeOptions = typeInfos.stream().filter(opt -> opt.isSimpleType() && !opt.hasKeywords()).sorted((o1, o2) -> o1.getSimpleType().getName().compareTo(o2.getSimpleType().getName())).collect(Collectors.toList());
        JsonSchema simpleTypeSchema = new JsonSchema();
        List otherTypeOptions = typeInfos.stream().filter(opt -> !opt.isSimpleType() || opt.hasKeywords()).collect(Collectors.toList());
        if (!simpleTypeOptions.isEmpty()) {
            if (this.jsonSchemaVersion == JsonSchemaVersion.OPENAPI_30) {
                Optional<JsonSchemaTypeInfo> nullTypeInfoOpt = simpleTypeOptions.stream().filter(opt -> opt.getSimpleType() == JsonSchemaType.NULL).findFirst();
                if (nullTypeInfoOpt.isPresent()) {
                    simpleTypeOptions.remove(nullTypeInfoOpt.get());
                    if (otherTypeOptions.stream().anyMatch(opt -> opt.getRef() != null)) {
                        this.result.addWarning(this, 118);
                    } else {
                        parentForTypeSchema.nullable(true);
                    }
                }
                if (simpleTypeOptions.size() > 1) {
                    otherTypeOptions.addAll(simpleTypeOptions);
                    simpleTypeOptions = new ArrayList();
                } else if (!simpleTypeOptions.isEmpty()) {
                    simpleTypeSchema.type((JsonSchemaType[])simpleTypeOptions.stream().map(sto -> sto.getSimpleType()).toArray(JsonSchemaType[]::new));
                }
            } else {
                simpleTypeSchema.type((JsonSchemaType[])simpleTypeOptions.stream().map(sto -> sto.getSimpleType()).toArray(JsonSchemaType[]::new));
            }
        }
        ArrayList<JsonSchema> otherTypeSchemas = new ArrayList<JsonSchema>();
        for (JsonSchemaTypeInfo otherTypeOption : otherTypeOptions) {
            JsonSchema otherTypeSchema = new JsonSchema();
            if (otherTypeOption.isReference()) {
                otherTypeSchema.ref(otherTypeOption.getRef());
            } else {
                otherTypeSchema.type(otherTypeOption.getSimpleType());
                if (otherTypeOption.hasKeywords()) {
                    otherTypeSchema.addAll(otherTypeOption.getKeywords());
                }
            }
            otherTypeSchemas.add(otherTypeSchema);
        }
        if (specificTypeSchema != null && !specificTypeSchema.isEmpty()) {
            otherTypeSchemas.add(specificTypeSchema);
        }
        if (!simpleTypeSchema.isEmpty() && !otherTypeSchemas.isEmpty()) {
            parentForTypeSchema.oneOf(simpleTypeSchema);
            parentForTypeSchema.oneOf(otherTypeSchemas.toArray(new JsonSchema[otherTypeSchemas.size()]));
        } else if (simpleTypeSchema.isEmpty() && !otherTypeSchemas.isEmpty()) {
            if (otherTypeSchemas.size() > 1) {
                parentForTypeSchema.oneOf(otherTypeSchemas.toArray(new JsonSchema[otherTypeSchemas.size()]));
            } else {
                parentForTypeSchema.addAll((Collection)otherTypeSchemas.get(0));
            }
        } else if (!simpleTypeSchema.isEmpty() && otherTypeSchemas.isEmpty()) {
            parentForTypeSchema.addAll(simpleTypeSchema);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createTypeDefinition(SortedMap<String, JsonSchemaTypeInfo> typeSpecificJsonTypeInfos, List<JsonSchemaTypeInfo> additionalJsonTypes, JsonSchema parentForTypeSchema) {
        List<Object> simpleTypeOptions = new ArrayList();
        List simpleTypeOptionsFromAdditionalSimpleJsonTypes = additionalJsonTypes.stream().filter(opt -> opt.isSimpleType() && !opt.hasKeywords()).sorted((o1, o2) -> o1.getSimpleType().getName().compareTo(o2.getSimpleType().getName())).collect(Collectors.toList());
        simpleTypeOptions.addAll(simpleTypeOptionsFromAdditionalSimpleJsonTypes);
        List simpleTypeOptionsFromTypeSpecificJsonTypeInfos = typeSpecificJsonTypeInfos.values().stream().filter(opt -> opt.isSimpleType() && !opt.hasKeywords()).sorted((o1, o2) -> o1.getSimpleType().getName().compareTo(o2.getSimpleType().getName())).collect(Collectors.toList());
        simpleTypeOptions.addAll(simpleTypeOptionsFromTypeSpecificJsonTypeInfos);
        simpleTypeOptions = simpleTypeOptions.stream().sorted((o1, o2) -> o1.getSimpleType().getName().compareTo(o2.getSimpleType().getName())).collect(Collectors.toList());
        JsonSchema simpleTypeSchema = new JsonSchema();
        ArrayList<Object> otherTypeOptions = new ArrayList<Object>();
        List otherTypeOptionsFromAdditionalSimpleJsonTypes = additionalJsonTypes.stream().filter(opt -> !opt.isSimpleType() || opt.hasKeywords()).collect(Collectors.toList());
        otherTypeOptions.addAll(otherTypeOptionsFromAdditionalSimpleJsonTypes);
        List otherTypeOptionsFromTypeSpecificJsonTypeInfos = typeSpecificJsonTypeInfos.values().stream().filter(opt -> opt.isSimpleType() && opt.hasKeywords()).collect(Collectors.toList());
        otherTypeOptions.addAll(otherTypeOptionsFromTypeSpecificJsonTypeInfos);
        TreeMap<String, String> remainingSpecificTypeOptions = new TreeMap<String, String>();
        for (String string : typeSpecificJsonTypeInfos.keySet()) {
            JsonSchemaTypeInfo jsonSchemaTypeInfo = (JsonSchemaTypeInfo)typeSpecificJsonTypeInfos.get(string);
            if (!jsonSchemaTypeInfo.hasRef()) continue;
            remainingSpecificTypeOptions.put(string, jsonSchemaTypeInfo.getRef());
        }
        if (!simpleTypeOptions.isEmpty()) {
            if (this.jsonSchemaVersion == JsonSchemaVersion.OPENAPI_30) {
                Optional<JsonSchemaTypeInfo> nullTypeInfoOpt = simpleTypeOptions.stream().filter(opt -> opt.getSimpleType() == JsonSchemaType.NULL).findFirst();
                if (nullTypeInfoOpt.isPresent()) {
                    simpleTypeOptions.remove(nullTypeInfoOpt.get());
                    if (otherTypeOptions.stream().anyMatch(opt -> opt.getRef() != null)) {
                        this.result.addWarning(this, 118);
                    } else {
                        parentForTypeSchema.nullable(true);
                    }
                }
                if (simpleTypeOptions.size() > 1) {
                    otherTypeOptions.addAll(simpleTypeOptions);
                    simpleTypeOptions = new ArrayList();
                } else if (!simpleTypeOptions.isEmpty()) {
                    simpleTypeSchema.type((JsonSchemaType[])simpleTypeOptions.stream().map(sto -> sto.getSimpleType()).toArray(JsonSchemaType[]::new));
                }
            } else {
                simpleTypeSchema.type((JsonSchemaType[])simpleTypeOptions.stream().map(sto -> sto.getSimpleType()).toArray(JsonSchemaType[]::new));
            }
        }
        ArrayList<JsonSchema> otherTypeSchemas = new ArrayList<JsonSchema>();
        for (JsonSchemaTypeInfo jsonSchemaTypeInfo : otherTypeOptions) {
            JsonSchema otherTypeSchema = new JsonSchema();
            if (jsonSchemaTypeInfo.isReference()) {
                otherTypeSchema.ref(jsonSchemaTypeInfo.getRef());
            } else {
                otherTypeSchema.type(jsonSchemaTypeInfo.getSimpleType());
                if (jsonSchemaTypeInfo.hasKeywords()) {
                    otherTypeSchema.addAll(jsonSchemaTypeInfo.getKeywords());
                }
            }
            otherTypeSchemas.add(otherTypeSchema);
        }
        JsonSchema jsonSchema = new JsonSchema();
        if (!remainingSpecificTypeOptions.isEmpty()) {
            JsonSchema jsonSchema2 = jsonSchema;
            for (String typeName : remainingSpecificTypeOptions.keySet()) {
                JsonSchema elseSchema;
                void var14_20;
                String ref = (String)remainingSpecificTypeOptions.get(typeName);
                JsonSchema ifSchema = new JsonSchema();
                String entityTypeMemberPath = null;
                ClassInfo typeCi = this.model.classByName(typeName);
                if (typeCi != null) {
                    entityTypeMemberPath = this.identifyEntityTypeMemberPath(typeCi);
                }
                if (StringUtils.isBlank(entityTypeMemberPath)) {
                    entityTypeMemberPath = this.jsonSchemaTarget.getEntityTypeName();
                    this.result.addError(this, 122, typeName, entityTypeMemberPath);
                }
                String[] entityTypeMemberPathComponents = entityTypeMemberPath.split("/");
                JsonSchema entityTypeMemberPropertySchema = ifSchema;
                for (int i = 0; i < entityTypeMemberPathComponents.length - 1; ++i) {
                    JsonSchema newEntityTypeMemberPropertySchema = new JsonSchema();
                    entityTypeMemberPropertySchema.property(entityTypeMemberPathComponents[i], newEntityTypeMemberPropertySchema);
                    entityTypeMemberPropertySchema = newEntityTypeMemberPropertySchema;
                }
                entityTypeMemberPropertySchema.property(entityTypeMemberPathComponents[entityTypeMemberPathComponents.length - 1], new JsonSchema().const_(new JsonString(typeName)));
                var14_20.if_(ifSchema);
                JsonSchema thenSchema = new JsonSchema();
                thenSchema.ref(ref);
                var14_20.then(thenSchema);
                if (((String)remainingSpecificTypeOptions.lastKey()).equals(typeName)) {
                    elseSchema = JsonSchema.FALSE;
                    var14_20.else_(elseSchema);
                    continue;
                }
                elseSchema = new JsonSchema();
                var14_20.else_(elseSchema);
                JsonSchema jsonSchema3 = elseSchema;
            }
        }
        if (!jsonSchema.isEmpty()) {
            otherTypeSchemas.add(jsonSchema);
        }
        if (!simpleTypeSchema.isEmpty() && !otherTypeSchemas.isEmpty()) {
            parentForTypeSchema.oneOf(simpleTypeSchema);
            parentForTypeSchema.oneOf(otherTypeSchemas.toArray(new JsonSchema[otherTypeSchemas.size()]));
        } else if (simpleTypeSchema.isEmpty() && !otherTypeSchemas.isEmpty()) {
            if (otherTypeSchemas.size() > 1) {
                parentForTypeSchema.oneOf(otherTypeSchemas.toArray(new JsonSchema[otherTypeSchemas.size()]));
            } else {
                parentForTypeSchema.addAll((Collection)otherTypeSchemas.get(0));
            }
        } else if (!simpleTypeSchema.isEmpty() && otherTypeSchemas.isEmpty()) {
            parentForTypeSchema.addAll(simpleTypeSchema);
        }
    }

    private void createTypeDefinitionWithValueTypeOptionsForAssociationClassRole(SortedMap<String, JsonSchemaTypeInfo> valueTypeOptionsByTypeName, List<JsonSchemaTypeInfo> additionalJsonTypeInfosForAssociationRole, Optional<JsonSchemaTypeInfo> jsonTypeInfoForAssociationRoleValueType, String associationRoleName, boolean byReferenceAllowedForAssociationRole, JsonSchema parentForTypeSchema) {
        JsonSchema associationClassRoleCopyRestrictionSchema = new JsonSchema();
        associationClassRoleCopyRestrictionSchema.type(JsonSchemaType.OBJECT);
        JsonSchema roleCopyRestrictionSchema = new JsonSchema();
        roleCopyRestrictionSchema.type(JsonSchemaType.OBJECT);
        JsonSchema roleCopyTypeRestrictionSchema = new JsonSchema();
        ArrayList<JsonSchemaTypeInfo> additionalJsonTypes = new ArrayList<JsonSchemaTypeInfo>();
        if (byReferenceAllowedForAssociationRole) {
            additionalJsonTypes.add(this.createJsonSchemaTypeInfoForReference());
        }
        this.createTypeDefinition(valueTypeOptionsByTypeName, additionalJsonTypes, roleCopyTypeRestrictionSchema);
        associationClassRoleCopyRestrictionSchema.property(associationRoleName, roleCopyTypeRestrictionSchema);
        if (jsonTypeInfoForAssociationRoleValueType.isPresent()) {
            JsonSchema result = new JsonSchema();
            JsonSchema typeSchema = new JsonSchema();
            typeSchema.ref(jsonTypeInfoForAssociationRoleValueType.get().getRef());
            result.allOf(typeSchema);
            result.allOf(associationClassRoleCopyRestrictionSchema);
            associationClassRoleCopyRestrictionSchema = result;
        }
        this.createTypeDefinition(additionalJsonTypeInfosForAssociationRole, associationClassRoleCopyRestrictionSchema, parentForTypeSchema);
    }

    private Optional<JsonSchemaTypeInfo> identifyJsonSchemaTypeForSupertype(ClassInfo ci, String encodingRule) {
        JsonSchemaTypeInfo jsTypeInfo = new JsonSchemaTypeInfo();
        String typeName = ci.name();
        ProcessMapEntry pme = this.mapEntryParamInfos.getMapEntry(typeName, encodingRule);
        if (pme != null && !this.jsonSchemaTarget.ignoreMapEntryForTypeFromSchemaSelectedForProcessing(pme, ci.id())) {
            jsTypeInfo = this.jsonSchemaTarget.identifyJsonSchemaType(pme, typeName, encodingRule);
        } else if (!this.model.isInSelectedSchemas(ci)) {
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 104, typeName, encodingRule);
            if (mc != null) {
                mc.addDetail(this, 0, ci.fullName());
            }
            jsTypeInfo = null;
        } else {
            Optional<JsonSchemaDocument> jsdopt = this.jsonSchemaTarget.jsonSchemaDocument(ci);
            if (jsdopt.isEmpty()) {
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 105, typeName, encodingRule);
                if (mc != null) {
                    mc.addDetail(this, 0, ci.fullName());
                }
                jsTypeInfo = null;
            } else {
                JsonSchemaDocument jsd = jsdopt.get();
                jsTypeInfo.setRef(this.jsonSchemaDefinitionReference(jsd, ci));
            }
        }
        return Optional.ofNullable(jsTypeInfo);
    }

    private Optional<JsonSchemaTypeInfo> identifyJsonSchemaType(PropertyInfo pi) {
        return this.identifyJsonSchemaType(pi.typeInfo().name, pi.typeInfo().id, pi.encodingRule("json"));
    }

    private Optional<JsonSchemaTypeInfo> identifyJsonSchemaType(String typeName, String typeId, String encodingRule) {
        JsonSchemaTypeInfo jsTypeInfo = new JsonSchemaTypeInfo();
        ProcessMapEntry pme = this.mapEntryParamInfos.getMapEntry(typeName, encodingRule);
        if (pme != null && !this.jsonSchemaTarget.ignoreMapEntryForTypeFromSchemaSelectedForProcessing(pme, typeId)) {
            if (pme.hasTargetType()) {
                jsTypeInfo = this.jsonSchemaTarget.identifyJsonSchemaType(pme, typeName, encodingRule);
            } else {
                this.result.addInfo(this, 121, typeName);
                jsTypeInfo = null;
            }
        } else {
            ClassInfo valueType = null;
            if (StringUtils.isNotBlank((CharSequence)typeId)) {
                valueType = this.model.classById(typeId);
            }
            if (valueType == null && StringUtils.isNotBlank((CharSequence)typeName)) {
                valueType = this.model.classByName(typeName);
            }
            if (valueType == null) {
                this.result.addWarning(this, 114, typeName);
                jsTypeInfo = null;
            } else if (!JsonSchemaTarget.isEncoded(valueType)) {
                jsTypeInfo = null;
            } else if (!this.model.isInSelectedSchemas(valueType)) {
                this.result.addWarning(this, 115, typeName);
                jsTypeInfo = null;
            } else {
                Optional<JsonSchemaDocument> jsdopt = this.jsonSchemaTarget.jsonSchemaDocument(valueType);
                if (jsdopt.isEmpty()) {
                    this.result.addWarning(this, 116, typeName);
                    jsTypeInfo = null;
                } else {
                    JsonSchemaDocument jsd = jsdopt.get();
                    String schemaId = jsd.getSchemaId();
                    if (this.jsonSchemaVersion != JsonSchemaVersion.OPENAPI_30 && valueType.matches("rule-json-cls-name-as-anchor")) {
                        jsTypeInfo.setRef(schemaId + "#" + typeName);
                    } else if (jsd.getSchemaVersion() == JsonSchemaVersion.DRAFT_2019_09) {
                        jsTypeInfo.setRef(schemaId + "#/$defs/" + typeName);
                    } else {
                        jsTypeInfo.setRef(schemaId + "#/definitions/" + typeName);
                    }
                }
            }
        }
        return Optional.ofNullable(jsTypeInfo);
    }

    public void write() {
        JsonSerializationContext context = new JsonSerializationContext();
        JsonValue jValue = this.rootSchema.toJson(context);
        JsonElement gValue = jValue.toGson();
        GsonBuilder gsonBuilder = new GsonBuilder().serializeNulls();
        if (this.jsonSchemaTarget.prettyPrinting()) {
            gsonBuilder.setPrettyPrinting();
        }
        Gson gson = gsonBuilder.create();
        String jsonstring = gson.toJson(gValue);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.jsonSchemaOutputFile), "UTF-8"));){
            writer.write(jsonstring);
            this.result.addResult(this.jsonSchemaTarget.getTargetName(), this.jsonSchemaOutputFile.getParent(), this.jsonSchemaOutputFile.getName(), null);
        }
        catch (Exception e) {
            this.result.addError(this, 100, this.jsonSchemaOutputFile.getAbsolutePath(), e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class '$1$'";
            }
            case 1: {
                return "Context: property '$1$'";
            }
            case 9: {
                return "??Property '$1$' of class '$2$' is not encoded.";
            }
            case 100: {
                return "Exception occurred while writing JSON Schema to file: $1$. Exception message is: $2$.";
            }
            case 101: {
                return "Restricting facet 'maxLength' of basic type '$1$' defined by tagged value 'length' (or 'maxLength' or 'size') could not be parsed as an integer. Found value: $2$. The facet will be ignored.";
            }
            case 102: {
                return "Restricting facet 'maxLength' of basic type '$1$' defined by tagged value 'length' (or 'maxLength' or 'size') has a negative integer value ($2$), which is not allowed for the facet. The facet will be ignored.";
            }
            case 103: {
                return "Restricting facet '$4$' of basic type '$1$' defined by tagged value '$3$' could not be parsed as a double. Found value: $2$. The facet will be ignored.";
            }
            case 104: {
                return "??JSON Schema type for supertype '$1$' could not be identified for encoding rule '$2$'. No map entry is defined for the type, and the type is not contained in the schemas selected for processing. Generalization relationships to this type will be ignored.";
            }
            case 105: {
                return "??JSON Schema type for supertype '$1$' could not be identified for encoding rule '$2$'. No map entry is defined for the type, and the type is not encoded. Generalization relationships to this type will be ignored.";
            }
            case 106: {
                return "Initial value '$1$' of property '$2$' is not an integer, but the JSON Schema type identified for the value type of the property is 'integer'. The initial value will not be encoded as \"default\".";
            }
            case 107: {
                return "Initial value '$1$' of property '$2$' is not a number (to be exact: not a double), but the JSON Schema type identified for the value type of the property is 'number'. The initial value will not be encoded as \"default\".";
            }
            case 108: {
                return "Supertype '$1$' of type '$2$' has JSON Schema type '$3$', which is a simple type. That is not allowed. The generalization relationship from '$2$' to '$1$' will be ignored.";
            }
            case 109: {
                return "(Initial) value '$1$' of enum '$2$' is not an integer, but the JSON Schema type identified for enumeration '$3$' is 'integer'. The enum will not be encoded.";
            }
            case 110: {
                return "(Initial) value '$1$' of enum '$2$' is not a number (to be exact: not a double), but the JSON Schema type identified for enumeration '$3$' is 'number'. The enum will not be encoded.";
            }
            case 111: {
                return "";
            }
            case 112: {
                return "Class '$1$' has multiple default geometry properties ($2$). None of them will be encoded as 'geometry' member. They will be encoded as usual properties.";
            }
            case 113: {
                return "Property '$1$' of class '$2$' is an <<identifier>> property with max multiplicity greater than 1. Such a property should have a max multiplicity of exactly 1.";
            }
            case 114: {
                return "??JSON Schema definition for type '$1$' could not be identified. No map entry is defined for the type, and the type was not found in the model. No type restriction is created for properties with this type as value type.";
            }
            case 115: {
                return "??JSON Schema definition for type '$1$' could not be identified. No map entry is defined for the type, and the type is not contained in the schemas selected for processing. No type restriction is created for properties with this type as value type.";
            }
            case 116: {
                return "??JSON Schema definition for type '$1$' could not be identified. No map entry is defined for the type, and the type is not encoded. No type restriction is created for properties with this type as value type.";
            }
            case 117: {
                return "Property '$1$' of type '$2$' has been identified as default geometry of the type. However, the maximum multiplicity of that property is greater than 1. The property is mapped to the \"geometry\" member, which can only have a single value. The multiplicity of the property will therefore be ignored.";
            }
            case 118: {
                return "??The schema contains or restricts voidable properties whose value type is defined using the '$ref' keyword. At the same time, the json schema version is set to OpenAPI30, which does not support nullable in combination with $ref. Voidable will therefore be ignored for these cases.";
            }
            case 119: {
                return "Literal encoding type for class '$1$' determined to be '$2$'. No JSON Schema type could be identified for that encoding type. Using JSON Schema type 'string'.";
            }
            case 120: {
                return "Literal encoding type for enumeration '$1$' must be a simple JSON Schema type. A schema reference was found: '$2$'. Assuming that the referenced JSON Schema contains a type definition for JSON Schema simple type 'string'. This will affect how the enums are encoded.";
            }
            case 121: {
                return "??No target type is defined in map entry for type '$1$'. This is valid if, in the JSON encoding, the type does not require a specific type restriction.";
            }
            case 122: {
                return "??No entity type member path found for specific type option '$1$'. Using '$2$' instead.";
            }
        }
        return "(" + JsonSchemaDocument.class.getName() + ") Unknown message with number: " + mnr;
    }
}

