/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.GeoPackage;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.GeoPackage.GeoPackageTemplate;
import de.interactive_instruments.ShapeChange.TargetConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class GeoPackageTemplateConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("documentationNoValue", "documentationTemplate", "gpkgM", "gpkgZ", "idColumnName", "organizationCoordSysId", "srsOrganization", "createSpatialIndexes").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;
    private TargetConfiguration config = null;
    private Options options = null;
    private ShapeChangeResult result = null;
    private String inputs = null;

    @Override
    public boolean isValid(ProcessConfiguration pConfig, Options options, ShapeChangeResult result) {
        String srsOrg;
        ShapeChangeResult.MessageContext mc;
        List<Object> srsDefs;
        File outputDirectoryFile;
        boolean exi;
        this.config = (TargetConfiguration)pConfig;
        this.options = options;
        this.result = result;
        this.inputs = StringUtils.join(this.config.getInputIds(), (String)", ");
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTargetParameters());
        isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, this.config.getParameters().keySet(), result) && isValid;
        String outputDirectory = pConfig.getParameterValue("outputDirectory");
        if (outputDirectory == null) {
            outputDirectory = options.parameter("outputDirectory");
        }
        if (outputDirectory == null) {
            outputDirectory = ".";
        }
        if (!(exi = (outputDirectoryFile = new File(outputDirectory)).exists())) {
            outputDirectoryFile.mkdirs();
            exi = outputDirectoryFile.exists();
        }
        boolean dir = outputDirectoryFile.isDirectory();
        boolean wrt = outputDirectoryFile.canWrite();
        boolean rea = outputDirectoryFile.canRead();
        if (!(exi && dir && wrt && rea)) {
            isValid = false;
            result.addError(this, 2, outputDirectory);
        }
        if (pConfig.hasParameter("gpkgM")) {
            isValid &= this.checkEnumeration("gpkgM", pConfig.getParameterValue("gpkgM"), "0", "1", "2");
        }
        if (pConfig.hasParameter("gpkgZ")) {
            isValid &= this.checkEnumeration("gpkgZ", pConfig.getParameterValue("gpkgZ"), "0", "1", "2");
        }
        List<Object> list = srsDefs = pConfig.getAdvancedProcessConfigurations() == null ? new ArrayList() : GeoPackageTemplate.parseGeoPackageSrsDefinitions(pConfig.getAdvancedProcessConfigurations());
        if (pConfig.hasParameter("organizationCoordSysId")) {
            try {
                int orgCoordSysId = Integer.parseInt(pConfig.getParameterValue("organizationCoordSysId"));
                if (orgCoordSysId != -1 && orgCoordSysId != 0 && orgCoordSysId != 4326 && !srsDefs.stream().anyMatch(srs -> srs.getSrsId() == (long)orgCoordSysId)) {
                    mc = result.addError(this, 3, "" + orgCoordSysId);
                    mc.addDetail(this, 0, this.inputs);
                    isValid = false;
                }
            }
            catch (NumberFormatException e) {
                mc = result.addError(this, 4, "organizationCoordSysId", e.getMessage());
                mc.addDetail(this, 0, this.inputs);
                isValid = false;
            }
        }
        if (pConfig.hasParameter("srsOrganization") && !"epsg".equalsIgnoreCase(srsOrg = pConfig.getParameterValue("srsOrganization")) && !"none".equalsIgnoreCase(srsOrg) && !srsDefs.stream().anyMatch(srs -> srs.getOrganization().equalsIgnoreCase(srsOrg))) {
            mc = result.addError(this, 5, srsOrg);
            mc.addDetail(this, 0, this.inputs);
            isValid = false;
        }
        return isValid;
    }

    private boolean checkEnumeration(String parameterName, String parameterValue, String ... enums) {
        String v = parameterValue.trim();
        for (String e : enums) {
            if (!v.equals(e)) continue;
            return true;
        }
        ShapeChangeResult.MessageContext mc = this.result.addError(this, 6, parameterName, parameterValue.trim(), StringUtils.join((Object[])enums, (String)", "));
        mc.addDetail(this, 0, this.inputs);
        return false;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: GeoPackageTemplate target configuration element with 'inputs'='$1$'.";
            }
            case 1: {
                return "Syntax exception while compiling the regular expression defined by target parameter '$1$': '$2$'.";
            }
            case 2: {
                return "Output directory '$1$' does not exist or is not accessible.";
            }
            case 3: {
                return "Value of target parameter 'organizationCoordSysId' is '$1$', which does not match any ID of the minimal SRSs defined for every GeoPackage (-1, 0, 4326) or of the SRSs defined via the advanced process configuration.";
            }
            case 4: {
                return "Number format exception while converting the value of configuration parameter '$1$' to an integer. Exception message: $2$.";
            }
            case 5: {
                return "Value of target parameter 'srsOrganization' is '$1$', which does not match (ignoring case) any organization of the minimal SRSs defined for every GeoPackage ('NONE', 'EPSG') or of the SRSs defined via the advanced process configuration.";
            }
            case 6: {
                return "Value of target parameter '$1$' is '$2$', which does not match any of the allowed values: $3$";
            }
        }
        return "(GeoPackageTemplateConfigurationValidator.java) Unknown message with number: " + mnr;
    }
}

