/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.GeoPackage;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SingleTarget;
import de.interactive_instruments.ShapeChange.Target.TargetUtil;
import de.interactive_instruments.ShapeChange.Util.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.attributes.AttributesColumn;
import mil.nga.geopackage.attributes.AttributesTable;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.contents.ContentsDao;
import mil.nga.geopackage.core.contents.ContentsDataType;
import mil.nga.geopackage.core.srs.SpatialReferenceSystem;
import mil.nga.geopackage.core.srs.SpatialReferenceSystemDao;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.extension.CrsWktExtension;
import mil.nga.geopackage.extension.RTreeIndexExtension;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.features.columns.GeometryColumnsDao;
import mil.nga.geopackage.features.user.FeatureColumn;
import mil.nga.geopackage.features.user.FeatureTable;
import mil.nga.geopackage.manager.GeoPackageManager;
import mil.nga.geopackage.schema.columns.DataColumns;
import mil.nga.geopackage.schema.columns.DataColumnsDao;
import mil.nga.geopackage.schema.constraints.DataColumnConstraintType;
import mil.nga.geopackage.schema.constraints.DataColumnConstraints;
import mil.nga.geopackage.schema.constraints.DataColumnConstraintsDao;
import mil.nga.sf.GeometryType;
import org.apache.commons.io.FileUtils;
import org.junit.platform.commons.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GeoPackageTemplate
implements SingleTarget,
MessageSource {
    protected static Model model = null;
    protected static boolean initialised = false;
    protected static boolean diagnosticsOnly = false;
    protected static int numberOfEncodedSchemas = 0;
    protected static String documentationTemplate = null;
    protected static String documentationNoValue = null;
    protected static String outputDirectory = null;
    protected static String outputFilename = null;
    protected static List<ClassInfo> cisToProcess = new ArrayList<ClassInfo>();
    protected static List<SpatialReferenceSystem> srsDefs = new ArrayList<SpatialReferenceSystem>();
    protected static int organizationCoordSysId = 4326;
    protected static String srsOrganization = "EPSG";
    protected static String idColumnName;
    protected static byte gpkgM;
    protected static byte gpkgZ;
    protected ShapeChangeResult result = null;
    protected Options options = null;
    protected PackageInfo schema = null;
    protected boolean schemaNotEncoded = false;

    @Override
    public void initialise(PackageInfo pi, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        this.schema = pi;
        model = m;
        this.options = o;
        this.result = r;
        diagnosticsOnly = diagOnly;
        if (!GeoPackageTemplate.isEncoded(this.schema)) {
            this.schemaNotEncoded = true;
            this.result.addInfo(this, 7, this.schema.name());
            return;
        }
        ++numberOfEncodedSchemas;
        if (!initialised) {
            initialised = true;
            outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
            if (outputDirectory == null) {
                outputDirectory = this.options.parameter("outputDirectory");
            }
            if (outputDirectory == null) {
                outputDirectory = this.options.parameter(".");
            }
            if (!diagnosticsOnly) {
                File outputFile;
                File outputDirectoryFile = new File(outputDirectory);
                boolean exi = outputDirectoryFile.exists();
                if (!exi) {
                    outputDirectoryFile.mkdirs();
                    exi = outputDirectoryFile.exists();
                }
                boolean dir = outputDirectoryFile.isDirectory();
                boolean wrt = outputDirectoryFile.canWrite();
                boolean rea = outputDirectoryFile.canRead();
                if (!(exi && dir && wrt && rea)) {
                    this.result.addFatalError(this, 4, outputDirectory);
                    return;
                }
                outputFilename = this.options.parameter(this.getClass().getName(), "outputFilename");
                if (outputFilename == null) {
                    PackageInfo mainAppSchema = TargetUtil.findMainSchemaForSingleTargets(model.selectedSchemas(), o, r);
                    outputFilename = mainAppSchema == null ? this.schema.name() : mainAppSchema.name();
                }
                if (!(outputFilename = outputFilename.replace("/", "_").replace(" ", "_")).endsWith(".gpkg")) {
                    outputFilename = outputFilename + ".gpkg";
                }
                if ((outputFile = new File(outputDirectory, outputFilename)).exists()) {
                    this.result.addInfo(this, 503, outputFilename, outputDirectory);
                    try {
                        FileUtils.forceDelete((File)outputFile);
                        this.result.addInfo(this, 504);
                    }
                    catch (IOException e) {
                        this.result.addInfo(null, 600, e.getMessage());
                        e.printStackTrace(System.err);
                    }
                }
                idColumnName = this.options.parameterAsString(this.getClass().getName(), "idColumnName", "id", false, true);
                gpkgM = this.options.parameterAsByte(this.getClass().getName(), "gpkgM", (byte)0);
                gpkgZ = this.options.parameterAsByte(this.getClass().getName(), "gpkgZ", (byte)0);
                organizationCoordSysId = this.options.parameterAsInteger(this.getClass().getName(), "organizationCoordSysId", 4326);
                srsOrganization = this.options.parameterAsString(this.getClass().getName(), "srsOrganization", "EPSG", false, true);
                documentationTemplate = this.options.parameter(this.getClass().getName(), "documentationTemplate");
                documentationNoValue = this.options.parameter(this.getClass().getName(), "documentationNoValue");
                if (this.options.getCurrentProcessConfig().getAdvancedProcessConfigurations() != null) {
                    srsDefs = GeoPackageTemplate.parseGeoPackageSrsDefinitions(this.options.getCurrentProcessConfig().getAdvancedProcessConfigurations());
                }
            }
        }
    }

    public static List<SpatialReferenceSystem> parseGeoPackageSrsDefinitions(Element apcs) {
        ArrayList<SpatialReferenceSystem> results = new ArrayList<SpatialReferenceSystem>();
        ArrayList<Element> gpkgSrsDefEs = new ArrayList<Element>();
        NodeList sdNl = apcs.getElementsByTagName("GeoPackageSrsDefinition");
        if (sdNl != null && sdNl.getLength() != 0) {
            for (int k = 0; k < sdNl.getLength(); ++k) {
                Node n = sdNl.item(k);
                if (n.getNodeType() != 1) continue;
                gpkgSrsDefEs.add((Element)n);
            }
        }
        for (int i = 0; i < gpkgSrsDefEs.size(); ++i) {
            Element gpkgSrsDefE = (Element)gpkgSrsDefEs.get(i);
            SpatialReferenceSystem srs = new SpatialReferenceSystem();
            srs.setSrsName(XMLUtil.getTrimmedTextContentOfFirstElement(gpkgSrsDefE, "srsName"));
            srs.setSrsId((long)Integer.parseInt(XMLUtil.getTrimmedTextContentOfFirstElement(gpkgSrsDefE, "srsId")));
            srs.setOrganization(XMLUtil.getTrimmedTextContentOfFirstElement(gpkgSrsDefE, "organization"));
            srs.setOrganizationCoordsysId((long)Integer.parseInt(XMLUtil.getTrimmedTextContentOfFirstElement(gpkgSrsDefE, "organizationCoordSysId")));
            srs.setDefinition(XMLUtil.getTrimmedTextContentOfFirstElement(gpkgSrsDefE, "definition"));
            srs.setDescription(XMLUtil.getTrimmedTextContentOfFirstElement(gpkgSrsDefE, "description"));
            srs.setDefinition_12_063(XMLUtil.getTrimmedTextContentOfFirstElement(gpkgSrsDefE, "definition_12_063"));
            results.add(srs);
        }
        return results;
    }

    @Override
    public void process(ClassInfo ci) {
        if (ci == null || ci.pkg() == null) {
            return;
        }
        if (!GeoPackageTemplate.isEncoded(ci)) {
            this.result.addInfo(this, 8, ci.name());
            return;
        }
        this.result.addDebug(this, 3, ci.name());
        if (this.schemaNotEncoded) {
            this.result.addInfo(this, 18, this.schema.name(), ci.name());
            return;
        }
        if (ci.category() == 6 && ci.matches("rule-gpkg-cls-objecttype") || ci.category() == 1 || ci.category() == 3 || ci.category() == 2) {
            boolean propExists = false;
            for (PropertyInfo pi : ci.propertiesAll()) {
                if (GeoPackageTemplate.isEncoded(pi)) {
                    propExists = true;
                    continue;
                }
                ShapeChangeResult.MessageContext mc = this.result.addInfo(this, 19, pi.name());
                if (mc == null) continue;
                mc.addDetail(this, 1, pi.fullNameInSchema());
            }
            if (!propExists) {
                this.result.addInfo(this, 104, ci.name());
            } else {
                cisToProcess.add(ci);
            }
        } else {
            this.result.addInfo(this, 17, ci.name());
        }
    }

    @Override
    public void write() {
    }

    @Override
    public String getTargetName() {
        return "GeoPackage";
    }

    @Override
    public String getTargetIdentifier() {
        return "gpkg";
    }

    @Override
    public String getDefaultEncodingRule() {
        return "geopackage";
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
        r.addRule("rule-gpkg-all-notEncoded");
        r.addRule("rule-gpkg-cls-identifierStereotype");
        r.addRule("rule-gpkg-cls-objecttype");
        ProcessRuleSet geopackagePrs = new ProcessRuleSet("geopackage", "*", new TreeSet<String>(Stream.of("rule-gpkg-cls-objecttype").collect(Collectors.toSet())));
        r.addRuleSet(geopackagePrs);
    }

    public static boolean isEncoded(Info i) {
        return !i.matches("rule-gpkg-all-notEncoded") || !i.encodingRule("gpkg").equalsIgnoreCase("notencoded");
    }

    @Override
    public void writeAll(ShapeChangeResult r) {
        this.result = r;
        this.options = r.options();
        if (diagnosticsOnly || numberOfEncodedSchemas == 0) {
            return;
        }
        File geopackageFile = new File(outputDirectory, outputFilename);
        GeoPackageManager.create((File)geopackageFile);
        try (GeoPackage geoPackage = GeoPackageManager.open((File)geopackageFile, (boolean)true);){
            SpatialReferenceSystemDao srsDao = geoPackage.getSpatialReferenceSystemDao();
            if (srsDefs.stream().anyMatch(srs -> StringUtils.isNotBlank((String)srs.getDefinition_12_063()))) {
                CrsWktExtension wktExt = new CrsWktExtension((GeoPackageCore)geoPackage);
                wktExt.getOrCreate();
            }
            for (SpatialReferenceSystem srs2 : srsDefs) {
                srsDao.create(srs2);
            }
            SpatialReferenceSystem srs3 = srsDao.getOrCreateCode(srsOrganization, (long)organizationCoordSysId);
            ContentsDao contentsDao = geoPackage.getContentsDao();
            RTreeIndexExtension rTreeIndexExtension = new RTreeIndexExtension(geoPackage);
            boolean createSpatialIndexes = this.options.parameterAsBoolean(this.getClass().getName(), "createSpatialIndexes", false);
            for (ClassInfo ci : cisToProcess) {
                if (ci.category() != 3) continue;
                this.createEnumColumnConstraints(geoPackage, ci);
            }
            boolean geometryColumnsTableCreated = false;
            geoPackage.createDataColumnsTable();
            for (ClassInfo ci : cisToProcess) {
                AttributesTable table;
                ShapeChangeResult.MessageContext mc;
                GeoPackageDataType gpkgType;
                String columnName;
                ArrayList<Object> columns;
                ShapeChangeResult.MessageContext mc2;
                String identifierColumnName;
                if (ci.category() == 3) continue;
                if (ci.category() == 2) {
                    this.result.addWarning(this, 113, ci.name());
                    continue;
                }
                int numberOfGeometryProperties = 0;
                PropertyInfo geometryPi = null;
                byte m = 0;
                byte z = 0;
                Info identifierPi = null;
                for (PropertyInfo pi : ci.propertiesAll()) {
                    ShapeChangeResult.MessageContext mc3;
                    ShapeChangeResult.MessageContext mc4;
                    if (!GeoPackageTemplate.isEncoded(pi)) continue;
                    if (this.isGeometryTypedProperty(pi)) {
                        ++numberOfGeometryProperties;
                        geometryPi = pi;
                        m = this.getMValue(pi);
                        z = this.getZValue(pi);
                        if (!geometryColumnsTableCreated) {
                            geoPackage.createGeometryColumnsTable();
                            geometryColumnsTableCreated = true;
                        }
                    }
                    if (pi.cardinality().maxOccurs > 1 && (mc4 = this.result.addWarning(this, 103, pi.name())) != null) {
                        mc4.addDetail(this, 1, pi.fullNameInSchema());
                    }
                    if (!pi.isAttribute() || !pi.stereotype("identifier") || !ci.matches("rule-gpkg-cls-identifierStereotype")) continue;
                    identifierPi = pi;
                    GeoPackageDataType gpkgType2 = this.mapGeoPackageDataType(pi);
                    if (gpkgType2 == GeoPackageDataType.INTEGER || (mc3 = this.result.addInfo(this, 110, pi.name(), ci.name(), pi.typeInfo().name)) == null) continue;
                    mc3.addDetail(this, 1, pi.fullNameInSchema());
                }
                String string = identifierColumnName = identifierPi == null ? this.normalize(idColumnName) : this.normalize(identifierPi.name());
                if (numberOfGeometryProperties > 1 && (mc2 = this.result.addWarning(this, 100, ci.name(), geometryPi.name())) != null) {
                    mc2.addDetail(this, 2, ci.fullNameInSchema());
                }
                String tableName = this.normalize(ci.name());
                Contents contents = new Contents();
                contents.setTableName(tableName);
                contents.setDescription(ci.derivedDocumentation(documentationTemplate, documentationNoValue));
                if (geometryPi != null) {
                    contents.setSrs(srs3);
                    contents.setDataType(ContentsDataType.FEATURES);
                    columns = new ArrayList();
                    columns.add(FeatureColumn.createPrimaryKeyColumn((String)identifierColumnName));
                    for (PropertyInfo pi : ci.propertiesAll()) {
                        if (!GeoPackageTemplate.isEncoded(pi) || identifierPi == pi) continue;
                        columnName = this.normalize(pi.name());
                        if (this.isGeometryTypedProperty(pi)) {
                            if (pi != geometryPi) {
                                ShapeChangeResult.MessageContext mc5 = this.result.addWarning(this, 109, ci.name(), geometryPi.name(), pi.name());
                                if (mc5 != null) {
                                    mc5.addDetail(this, 1, pi.fullNameInSchema());
                                }
                            } else {
                                gpkgType = this.mapGeometryTypedProperty(pi);
                                if (gpkgType == null) {
                                    mc = this.result.addWarning(this, 101, pi.name(), pi.typeInfo().name);
                                    if (mc != null) {
                                        mc.addDetail(this, 1, pi.fullNameInSchema());
                                    }
                                    gpkgType = GeometryType.GEOMETRY;
                                }
                                columns.add(FeatureColumn.createGeometryColumn((String)columnName, (GeometryType)gpkgType, (pi.cardinality().minOccurs != 0 ? 1 : 0) != 0, null));
                                GeometryColumns gc = new GeometryColumns();
                                gc.setColumnName(columnName);
                                gc.setSrs(srs3);
                                gc.setGeometryType((GeometryType)gpkgType);
                                gc.setContents(contents);
                                gc.setM(m);
                                gc.setZ(z);
                                GeometryColumnsDao geometryColumnsDao = geoPackage.getGeometryColumnsDao();
                                geometryColumnsDao.create((Object)gc);
                            }
                        } else if (pi.categoryOfValue() == 2 || pi.categoryOfValue() == 3) {
                            columns.add(FeatureColumn.createColumn((String)columnName, (GeoPackageDataType)GeoPackageDataType.TEXT, (pi.cardinality().minOccurs != 0 ? 1 : 0) != 0, (Object)pi.initialValue()));
                        } else {
                            gpkgType = this.mapGeoPackageDataType(pi);
                            if (gpkgType == null) {
                                mc = this.result.addWarning(this, 102, pi.name(), pi.typeInfo().name);
                                if (mc != null) {
                                    mc.addDetail(this, 1, pi.fullNameInSchema());
                                }
                                gpkgType = GeoPackageDataType.TEXT;
                            }
                            columns.add(FeatureColumn.createColumn((String)columnName, (GeoPackageDataType)gpkgType, (pi.cardinality().minOccurs != 0 ? 1 : 0) != 0, (Object)pi.initialValue()));
                        }
                        this.createDataColumnsEntry(pi, contents, geoPackage);
                    }
                    table = new FeatureTable(tableName, columns);
                    geoPackage.createFeatureTable((FeatureTable)table);
                    if (createSpatialIndexes) {
                        rTreeIndexExtension.create((FeatureTable)table);
                    }
                } else {
                    contents.setDataType(ContentsDataType.ATTRIBUTES);
                    columns = new ArrayList<Object>();
                    columns.add(AttributesColumn.createPrimaryKeyColumn((String)identifierColumnName));
                    for (PropertyInfo pi : ci.propertiesAll()) {
                        if (!GeoPackageTemplate.isEncoded(pi) || identifierPi == pi) continue;
                        columnName = this.normalize(pi.name());
                        if (pi.categoryOfValue() == 2 || pi.categoryOfValue() == 3) {
                            columns.add(AttributesColumn.createColumn((String)columnName, (GeoPackageDataType)GeoPackageDataType.TEXT, (pi.cardinality().minOccurs != 0 ? 1 : 0) != 0, (Object)pi.initialValue()));
                        } else {
                            gpkgType = this.mapGeoPackageDataType(pi);
                            if (gpkgType == null) {
                                mc = this.result.addWarning(this, 102, pi.name(), pi.typeInfo().name);
                                if (mc != null) {
                                    mc.addDetail(this, 1, pi.fullNameInSchema());
                                }
                                gpkgType = GeoPackageDataType.TEXT;
                            }
                            columns.add(AttributesColumn.createColumn((String)columnName, (GeoPackageDataType)gpkgType, (pi.cardinality().minOccurs != 0 ? 1 : 0) != 0, (Object)pi.initialValue()));
                        }
                        this.createDataColumnsEntry(pi, contents, geoPackage);
                    }
                    table = new AttributesTable(tableName, columns);
                    geoPackage.createAttributesTable(table);
                }
                contentsDao.create(contents);
            }
            this.result.addResult(this.getTargetName(), outputDirectory, outputFilename, null);
        }
        catch (SQLException e) {
            this.result.addError(this, 108, e.getMessage());
        }
    }

    private byte getZValue(PropertyInfo pi) {
        String tv = pi.taggedValue("gpkgZ");
        if (StringUtils.isBlank((String)tv)) {
            return gpkgZ;
        }
        switch (tv.trim()) {
            case "0": {
                return 0;
            }
            case "1": {
                return 1;
            }
            case "2": {
                return 2;
            }
        }
        ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 111, pi.name(), pi.inClass().name(), tv.trim(), "" + gpkgZ);
        if (mc != null) {
            mc.addDetail(this, 1, pi.fullNameInSchema());
        }
        return gpkgZ;
    }

    private byte getMValue(PropertyInfo pi) {
        String tv = pi.taggedValue("gpkgM");
        if (StringUtils.isBlank((String)tv)) {
            return gpkgM;
        }
        switch (tv.trim()) {
            case "0": {
                return 0;
            }
            case "1": {
                return 1;
            }
            case "2": {
                return 2;
            }
        }
        ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 112, pi.name(), pi.inClass().name(), tv.trim(), "" + gpkgM);
        if (mc != null) {
            mc.addDetail(this, 1, pi.fullNameInSchema());
        }
        return gpkgM;
    }

    private void createDataColumnsEntry(PropertyInfo pi, Contents contents, GeoPackage geoPackage) {
        block4: {
            DataColumns dc = new DataColumns();
            dc.setContents(contents);
            dc.setColumnName(this.normalize(pi.name()));
            dc.setDescription(pi.derivedDocumentation(documentationTemplate, documentationNoValue));
            if (pi.aliasName() != null) {
                dc.setTitle(pi.aliasName().trim());
            }
            if (pi.categoryOfValue() == 3) {
                dc.setConstraintName(this.normalize(pi.typeInfo().name));
            }
            DataColumnsDao dataColumnsDao = geoPackage.getDataColumnsDao();
            try {
                dataColumnsDao.create((Object)dc);
            }
            catch (SQLException e) {
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 107, pi.name(), e.getMessage());
                if (mc == null) break block4;
                mc.addDetail(this, 1, pi.fullNameInSchema());
            }
        }
    }

    private boolean valueTypeHasEnums(PropertyInfo pi) {
        ClassInfo typeCi = pi.typeClass();
        if (typeCi != null && typeCi.category() == 3) {
            for (PropertyInfo tpi : typeCi.propertiesAll()) {
                if (!GeoPackageTemplate.isEncoded(tpi)) continue;
                return true;
            }
        }
        return false;
    }

    protected void createEnumColumnConstraints(GeoPackage geoPackage, ClassInfo ci) {
        geoPackage.createDataColumnConstraintsTable();
        DataColumnConstraintsDao dataColumnConstraintsDao = geoPackage.getDataColumnConstraintsDao();
        String constraintName = this.normalize(ci.name());
        try {
            for (PropertyInfo pi : ci.propertiesAll()) {
                DataColumnConstraints dcc = new DataColumnConstraints();
                dcc.setConstraintName(constraintName);
                dcc.setConstraintType(DataColumnConstraintType.ENUM);
                dcc.setValue(pi.name());
                dcc.setDescription(pi.derivedDocumentation(documentationTemplate, documentationNoValue));
                dataColumnConstraintsDao.create((Object)dcc);
            }
        }
        catch (SQLException e) {
            this.result.addError(this, 105, ci.name(), e.getMessage());
        }
    }

    private GeoPackageDataType mapGeoPackageDataType(PropertyInfo pi) {
        ProcessMapEntry me = pi.options().targetMapEntry(pi.typeInfo().name, pi.encodingRule("gpkg"));
        if (me == null) {
            return null;
        }
        switch (me.getTargetType().toUpperCase(Locale.ENGLISH)) {
            case "BLOB": {
                return GeoPackageDataType.BLOB;
            }
            case "BOOLEAN": {
                return GeoPackageDataType.BOOLEAN;
            }
            case "DATE": {
                return GeoPackageDataType.DATE;
            }
            case "DATETIME": {
                return GeoPackageDataType.DATETIME;
            }
            case "DOUBLE": {
                return GeoPackageDataType.DOUBLE;
            }
            case "FLOAT": {
                return GeoPackageDataType.FLOAT;
            }
            case "INT": {
                return GeoPackageDataType.INT;
            }
            case "INTEGER": {
                return GeoPackageDataType.INTEGER;
            }
            case "MEDIUMINT": {
                return GeoPackageDataType.MEDIUMINT;
            }
            case "REAL": {
                return GeoPackageDataType.REAL;
            }
            case "SMALLINT": {
                return GeoPackageDataType.SMALLINT;
            }
            case "TEXT": {
                return GeoPackageDataType.TEXT;
            }
            case "TINYINT": {
                return GeoPackageDataType.TINYINT;
            }
        }
        return null;
    }

    private GeometryType mapGeometryTypedProperty(PropertyInfo pi) {
        ProcessMapEntry me = pi.options().targetMapEntry(pi.typeInfo().name, pi.encodingRule("gpkg"));
        if (me == null) {
            return null;
        }
        switch (me.getTargetType().toUpperCase(Locale.ENGLISH)) {
            case "CIRCULARSTRING": {
                return GeometryType.CIRCULARSTRING;
            }
            case "COMPOUNDCURVE": {
                return GeometryType.COMPOUNDCURVE;
            }
            case "CURVE": {
                return GeometryType.CURVE;
            }
            case "CURVEPOLYGON": {
                return GeometryType.CURVEPOLYGON;
            }
            case "GEOMETRY": {
                return GeometryType.GEOMETRY;
            }
            case "GEOMETRYCOLLECTION": {
                return GeometryType.GEOMETRYCOLLECTION;
            }
            case "LINESTRING": {
                return GeometryType.LINESTRING;
            }
            case "MULTICURVE": {
                return GeometryType.MULTICURVE;
            }
            case "MULTILINESTRING": {
                return GeometryType.MULTILINESTRING;
            }
            case "MULTIPOINT": {
                return GeometryType.MULTIPOINT;
            }
            case "MULTIPOLYGON": {
                return GeometryType.MULTIPOLYGON;
            }
            case "MULTISURFACE": {
                return GeometryType.MULTISURFACE;
            }
            case "POINT": {
                return GeometryType.POINT;
            }
            case "POLYGON": {
                return GeometryType.POLYGON;
            }
            case "POLYHEDRALSURFACE": {
                return GeometryType.POLYHEDRALSURFACE;
            }
            case "SURFACE": {
                return GeometryType.SURFACE;
            }
            case "TIN": {
                return GeometryType.TIN;
            }
            case "TRIANGLE": {
                return GeometryType.TRIANGLE;
            }
        }
        return null;
    }

    private String normalize(String name) {
        return name.trim().toLowerCase().replaceAll("\\s", "_");
    }

    private boolean isGeometryTypedProperty(PropertyInfo pi) {
        String typeName = pi.typeInfo().name;
        return typeName.startsWith("GM_") || typeName.equalsIgnoreCase("DirectPosition");
    }

    @Override
    public void reset() {
        model = null;
        initialised = false;
        diagnosticsOnly = false;
        documentationTemplate = null;
        documentationNoValue = null;
        outputDirectory = null;
        outputFilename = null;
        numberOfEncodedSchemas = 0;
        idColumnName = null;
        gpkgM = 0;
        gpkgZ = 0;
        cisToProcess = new ArrayList<ClassInfo>();
        srsDefs = new ArrayList<SpatialReferenceSystem>();
        organizationCoordSysId = 0;
        srsOrganization = "EPSG";
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class GeoPackageTemplate";
            }
            case 1: {
                return "Property '$1$'";
            }
            case 2: {
                return "Class '$1$'";
            }
            case 3: {
                return "Processing class '$1$'.";
            }
            case 4: {
                return "Directory named '$1$' does not exist or is not accessible.";
            }
            case 5: {
                return "Number format exception while converting the tagged value '$1$' to an integer. Exception message: $2$. Using $3$ as default value.";
            }
            case 6: {
                return "";
            }
            case 7: {
                return "Schema '$1$' is not encoded.";
            }
            case 8: {
                return "Class '$1$' is not encoded.";
            }
            case 16: {
                return "Value '$1$' of configuration parameter $2$ does not match the regular expression: $3$. The parameter will be ignored.";
            }
            case 17: {
                return "Type '$1$' is of a category not enabled for conversion, meaning that it will not be represented in the GeoPackage template.";
            }
            case 18: {
                return "Schema '$1$' is not encoded. Thus class '$2$' (which belongs to that schema) is not encoded either.";
            }
            case 19: {
                return "Property '$1$' is not encoded.";
            }
            case 25: {
                return "Value of configuration parameter '$1$' is '$2$'. The file does not exist, is a directory, or cannot be read.";
            }
            case 100: {
                return "Class '$1$' has more than one geometry properties. All geometric properties except '$2$' will be ignored.";
            }
            case 101: {
                return "Property '$1$' has geometry value type '$2$', for which no map entry is configured that maps that type to one of the geometry types recognized by GeoPackage. The property will be encoded with type GEOMETRY.";
            }
            case 102: {
                return "Property '$1$' has value type '$2$', for which no map entry is configured that maps that type to one of the data types recognized by GeoPackage. The property will be encoded with type TEXT.";
            }
            case 103: {
                return "Property '$1$' has max multiplicity greater than 1. This is currently not supported by the target. The property will be encoded as if it had max multiplicity = 1.";
            }
            case 104: {
                return "Class '$1$' has no relevant properties. It will be ignored.";
            }
            case 105: {
                return "SQL Exception occurred while creating data column constraints for enumeration '$1$'. Exception message is: $2$";
            }
            case 106: {
                return "";
            }
            case 107: {
                return "SQL Exception occurred while creating a data columns table entry for property '$1$'. Exception message is: $2$";
            }
            case 108: {
                return "SQL Exception occurred while creating the GeoPackage template. Exception message is: $1$";
            }
            case 109: {
                return "Class '$1$' has multiple geometric properties. Only property '$2$' will be encoded. Property '$3$' is ignored.";
            }
            case 110: {
                return "Property '$1$' of class '$2$' is an identifier property with type '$3$'. It will be encoded with GeoPackage data type INTEGER.";
            }
            case 111: {
                return "Property '$1$' of class '$2$' has tagged value gpkgZ with unrecognized value '$3$'. Using value defined by target parameter gpkgZ (which is '$4$').";
            }
            case 112: {
                return "Property '$1$' of class '$2$' has tagged value gpkgM with unrecognized value '$3$'. Using value defined by target parameter gpkgM (which is '$4$').";
            }
            case 113: {
                return "Ignoring values in code list '$1$'. Encoding of code list values is currently not supported by the target.";
            }
            case 503: {
                return "Output file '$1$' already exists in output directory ('$2$'). It will be deleted prior to processing.";
            }
            case 504: {
                return "File has been deleted.";
            }
        }
        return "(" + GeoPackageTemplate.class.getName() + ") Unknown message with number: " + mnr;
    }

    static {
        gpkgM = 0;
        gpkgZ = 0;
    }
}

