/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.FeatureCatalogue;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.FeatureCatalogue.FeatureCatalogue;
import de.interactive_instruments.ShapeChange.Target.FeatureCatalogue.StreamGobbler;
import de.interactive_instruments.ShapeChange.TargetConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.lang3.StringUtils;

public class FeatureCatalogueConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("cssPath", "deleteXmlfile", "docxStyle", "docxTemplateFilePath", "dontTransform", "featureTerm", "includeAlias", "includeCodelistURI", "includeCodelistsAndEnumerations", "includeDiagrams", "includeTitle", "includeVoidable", "inheritedConstraints", "inheritedProperties", "pathToJavaExecutable", "javaOptions", "lang", "localizationMessagesUri", "logoFilePath", "name", "noAlphabeticSortingForProperties", "outputFormat", "package", "producer", "referenceModelFileNameOrConnectionString", "referenceModelType", "scope", "versionDate", "versionNumber", "xsldocxFile", "xslfoFile", "xslframeHtmlFileName", "xslhtmlFile", "xslLocalizationUri", "xslrtfFile", "xslTransformerFactory", "xslxmlFile", "xsltPath", "xsltPfad").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;
    private TargetConfiguration tgtConfig = null;
    private Options options = null;
    private ShapeChangeResult result = null;
    private String inputs = null;

    @Override
    public boolean isValid(ProcessConfiguration pConfig, Options options, ShapeChangeResult result) {
        boolean isValid;
        block27: {
            String outputFormat;
            ShapeChangeResult.MessageContext mc;
            String xslTransformerFactory;
            block26: {
                this.tgtConfig = (TargetConfiguration)pConfig;
                this.options = options;
                this.result = result;
                this.inputs = StringUtils.join(this.tgtConfig.getInputIds(), (String)", ");
                isValid = true;
                this.allowedParametersWithStaticNames.addAll(this.getCommonTargetParameters());
                isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, pConfig.getParameters().keySet(), result) && isValid;
                isValid &= this.checkIsBooleanValueIfSet("dontTransform");
                isValid &= this.checkIsBooleanValueIfSet("deleteXmlfile");
                isValid &= this.checkIsBooleanValueIfSet("includeAlias");
                isValid &= this.checkIsBooleanValueIfSet("includeCodelistURI");
                isValid &= this.checkIsBooleanValueIfSet("includeDiagrams");
                isValid &= this.checkIsBooleanValueIfSet("includeTitle");
                isValid &= this.checkIsBooleanValueIfSet("includeVoidable");
                isValid &= this.checkIsBooleanValueIfSet("inheritedConstraints");
                isValid &= this.checkIsBooleanValueIfSet("inheritedProperties");
                isValid &= this.checkIsBooleanValueIfSet("noAlphabeticSortingForProperties");
                String docxStyle = this.tgtConfig.getParameterValue("docxStyle");
                if (docxStyle != null && !"default".equals(docxStyle) && !"custom1".equals(docxStyle)) {
                    ShapeChangeResult.MessageContext mc2 = result.addError(this, 5, "docxStyle", docxStyle);
                    if (mc2 != null) {
                        mc2.addDetail(this, 0, this.inputs);
                    }
                    isValid = false;
                }
                if ((xslTransformerFactory = this.tgtConfig.getParameterValue("xslTransformerFactory")) != null) {
                    try {
                        System.setProperty("javax.xml.transform.TransformerFactory", xslTransformerFactory);
                        TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    }
                    catch (TransformerFactoryConfigurationError e) {
                        isValid = false;
                        mc = result.addError(this, 100, xslTransformerFactory);
                        if (mc == null) break block26;
                        mc.addDetail(this, 0, this.inputs);
                        mc.addDetail(this, 1, "xslTransformerFactory");
                    }
                }
            }
            if ((outputFormat = this.tgtConfig.getParameterValue("outputFormat")) == null) {
                isValid = false;
                mc = result.addError(this, 101);
                if (mc != null) {
                    mc.addDetail(this, 0, this.inputs);
                    mc.addDetail(this, 1, "outputFormat");
                }
            } else if ((outputFormat.toLowerCase().contains("docx") || outputFormat.toLowerCase().contains("framehtml")) && xslTransformerFactory == null) {
                ShapeChangeResult.MessageContext mc3;
                try {
                    TransformerFactory factory = TransformerFactory.newInstance();
                    if (!factory.getClass().getName().equalsIgnoreCase("net.sf.saxon.TransformerFactoryImpl")) {
                        isValid = false;
                        mc3 = result.addError(this, 102);
                        if (mc3 != null) {
                            mc3.addDetail(this, 0, this.inputs);
                            mc3.addDetail(this, 1, "xslTransformerFactory");
                        }
                    }
                }
                catch (TransformerFactoryConfigurationError e) {
                    isValid = false;
                    mc3 = result.addError(this, 100, xslTransformerFactory);
                    if (mc3 == null) break block27;
                    mc3.addDetail(this, 0, this.inputs);
                    mc3.addDetail(this, 1, "xslTransformerFactory");
                }
            }
        }
        String pathToJavaExe_ = pConfig.getParameterValue("pathToJavaExecutable");
        if (pathToJavaExe_ != null && pathToJavaExe_.trim().length() > 0) {
            String jo_tmp;
            Object pathToJavaExe = pathToJavaExe_.trim();
            String javaOptions = null;
            if (!((String)pathToJavaExe).startsWith("\"")) {
                pathToJavaExe = "\"" + (String)pathToJavaExe;
            }
            if (!((String)pathToJavaExe).endsWith("\"")) {
                pathToJavaExe = (String)pathToJavaExe + "\"";
            }
            if ((jo_tmp = pConfig.getParameterValue("javaOptions")) != null && jo_tmp.trim().length() > 0) {
                javaOptions = jo_tmp.trim();
            }
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add((String)pathToJavaExe);
            if (javaOptions != null) {
                cmds.add(javaOptions);
            }
            cmds.add("-version");
            ProcessBuilder pb = new ProcessBuilder(cmds);
            try {
                Process proc = pb.start();
                StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream());
                StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream());
                errorGobbler.start();
                outputGobbler.start();
                errorGobbler.join();
                outputGobbler.join();
                int exitVal = proc.waitFor();
                if (exitVal != 0) {
                    if (errorGobbler.hasResult()) {
                        ShapeChangeResult.MessageContext mc = result.addFatalError(this, 102, StringUtils.join(cmds, (String)" "), "" + exitVal);
                        mc.addDetail(this, 4, errorGobbler.getResult());
                    } else {
                        result.addFatalError(this, 102, StringUtils.join(cmds, (String)" "), "" + exitVal);
                    }
                    isValid = false;
                }
            }
            catch (InterruptedException e) {
                ShapeChangeResult.MessageContext mc = result.addFatalError(this, 104);
                if (mc != null) {
                    mc.addDetail(this, 2, (String)pathToJavaExe);
                    mc.addDetail(this, 3, javaOptions != null ? javaOptions : "<none>");
                }
                isValid = false;
            }
            catch (IOException e) {
                ShapeChangeResult.MessageContext mc = result.addFatalError(this, 105);
                if (mc != null) {
                    mc.addDetail(this, 2, (String)pathToJavaExe);
                    mc.addDetail(this, 3, javaOptions != null ? javaOptions : "<none>");
                }
                isValid = false;
            }
        }
        return isValid;
    }

    private boolean checkIsBooleanValueIfSet(String parameterName) {
        String paramValue = this.tgtConfig.getParameterValue(parameterName);
        if (paramValue == null || paramValue.equalsIgnoreCase("true") || paramValue.equalsIgnoreCase("false")) {
            return true;
        }
        ShapeChangeResult.MessageContext mc = this.result.addError(this, 106, parameterName, paramValue);
        if (mc != null) {
            mc.addDetail(this, 0, this.inputs);
        }
        return false;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: FeatureCatalogue target configuration element with 'inputs'='$1$'.";
            }
            case 1: {
                return "For further details, see the documentation of parameter '$1$' on http://shapechange.net/targets/feature-catalogue/";
            }
            case 2: {
                return "pathToJavaExecutable is: $1$";
            }
            case 3: {
                return "javaOptions is: $1$";
            }
            case 4: {
                return "Message from external java executable: $1$";
            }
            case 5: {
                return "Value of parameter '$1$' is invalid. Found: $2$";
            }
            case 100: {
                return "Parameter 'xslTransformerFactory' is set to '$1$'. A Transformer with this factory could not be instantiated. Make the implementation of the transformer factory available on the classpath.";
            }
            case 101: {
                return "The required parameter 'outputFormat' was not found in the configuration.";
            }
            case 102: {
                return "Parameter 'outputFormat' contains 'DOCX' and/or 'FRAMEHTML'. These formats require an XSLT 2.0 processor, which should be set via the configuration parameter 'xslTransformerFactory'. That parameter was not found, and the default TransformerFactory implementation is not 'net.sf.saxon.TransformerFactoryImpl' (which is known to be an XSLT 2.0 processor); ensure that the parameter is configured correctly.";
            }
            case 103: {
                return "Invalid command for invocation of external java executable. Return code was: $2$. Command was: $1$";
            }
            case 104: {
                return "InterruptionException while testing alternative java executable to perform the XSL transformation. Message is: $1$";
            }
            case 105: {
                return "IOException while testing alternative java executable to perform the XSL transformation. Message is: $1$";
            }
            case 106: {
                return "Value of parameter '$1$' is not a recognized boolean value. The value must either be equal to (ignoring case) 'true' or to 'false'. Given value is: $2$.";
            }
        }
        return "(" + FeatureCatalogue.class.getName() + ") Unknown message with number: " + mnr;
    }
}

