/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.FeatureCatalogue;

import de.interactive_instruments.ShapeChange.DefaultModelProvider;
import de.interactive_instruments.ShapeChange.Fop.FopErrorListener;
import de.interactive_instruments.ShapeChange.Fop.FopMsgHandler;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.ImageMetadata;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Model.TextConstraint;
import de.interactive_instruments.ShapeChange.ModelDiff.DiffElement;
import de.interactive_instruments.ShapeChange.ModelDiff.Differ;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.DeferrableOutputWriter;
import de.interactive_instruments.ShapeChange.Target.FeatureCatalogue.ImageMetadataContentHandler;
import de.interactive_instruments.ShapeChange.Target.FeatureCatalogue.StreamGobbler;
import de.interactive_instruments.ShapeChange.Target.SingleTarget;
import de.interactive_instruments.ShapeChange.UI.StatusBoard;
import de.interactive_instruments.ShapeChange.Util.XMLWriter;
import de.interactive_instruments.ShapeChange.Util.XsltWriter;
import de.interactive_instruments.ShapeChange.Util.ZipHandler;
import io.github.classgraph.ClassGraph;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import name.fraser.neil.plaintext.diff_match_patch;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class FeatureCatalogue
implements SingleTarget,
MessageSource,
DeferrableOutputWriter {
    public static final int STATUS_WRITE_PDF = 22;
    public static final int STATUS_WRITE_HTML = 23;
    public static final int STATUS_WRITE_XML = 24;
    public static final int STATUS_WRITE_RTF = 25;
    public static final int STATUS_WRITE_FRAMEHTML = 26;
    public static final int STATUS_WRITE_DOCX = 27;
    public static final String localizationMessagesDefaultUri = "localizationMessages.xml";
    public static final String localizationXslDefaultUri = "localization.xsl";
    public static final String DOCX_PLACEHOLDER = "ShapeChangeFeatureCatalogue";
    public static final String DOCX_TEMPLATE_URL = "http://shapechange.net/resources/templates/template.docx";
    public static final String PARAM_DONT_TRANSFORM = "dontTransform";
    public static final String PARAM_INCLUDE_CODELIST_URI = "includeCodelistURI";
    public static final String PARAM_XSL_TRANSFORMER_FACTORY = "xslTransformerFactory";
    public static final String PARAM_OUTPUT_FORMAT = "outputFormat";
    public static final String PARAM_DOCX_STYLE = "docxStyle";
    public static final String PARAM_JAVA_EXE_PATH = "pathToJavaExecutable";
    public static final String PARAM_JAVA_OPTIONS = "javaOptions";
    public static final String PARAM_REFERENCE_MODEL_TYPE = "referenceModelType";
    public static final String PARAM_REFERENCE_MODEL_FILENAME_OR_CONSTRING = "referenceModelFileNameOrConnectionString";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_SCOPE = "scope";
    public static final String PARAM_VERSION_NUMBER = "versionNumber";
    public static final String PARAM_VERSION_DATE = "versionDate";
    public static final String PARAM_PRODUCER = "producer";
    public static final String PARAM_XSL_HTML_FILE = "xslhtmlFile";
    public static final String PARAM_LOGO_FILE_PATH = "logoFilePath";
    public static final String PARAM_INHERITED_CONSTRAINTS = "inheritedConstraints";
    public static final String PARAM_INHERITED_PROPERTIES = "inheritedProperties";
    public static final String PARAM_DELETE_XML_FILE = "deleteXmlfile";
    public static final String PARAM_DOCX_TEMPLATE_FILE_PATH = "docxTemplateFilePath";
    public static final String PARAM_PACKAGE = "package";
    public static final String PARAM_FEATURE_TERM = "featureTerm";
    public static final String PARAM_INCLUDE_DIAGRAMS = "includeDiagrams";
    public static final String PARAM_INCLUDE_VOIDABLE = "includeVoidable";
    public static final String PARAM_INCLUDE_ALIAS = "includeAlias";
    public static final String PARAM_INCLUDE_TITLE = "includeTitle";
    public static final String PARAM_XSL_FRAME_HTML_FILENAME = "xslframeHtmlFileName";
    public static final String PARAM_XSL_FO_FILE = "xslfoFile";
    public static final String PARAM_XSL_RTF_FILE = "xslrtfFile";
    public static final String PARAM_XSL_DOCX_FILE = "xsldocxFile";
    public static final String PARAM_XSL_XML_FILE = "xslxmlFile";
    public static final String PARAM_XSLT_PFAD = "xsltPfad";
    public static final String PARAM_XSLT_PATH = "xsltPath";
    public static final String PARAM_CSS_PATH = "cssPath";
    public static final String PARAM_LANG = "lang";
    public static final String PARAM_NO_ALPHABETIC_SORT_OF_PROPS = "noAlphabeticSortingForProperties";
    public static final String PARAM_INCLUDE_CODELISTS_AND_ENUMERATIONS = "includeCodelistsAndEnumerations";
    public static final String PARAM_XSL_LOCALIZATION_URI = "xslLocalizationUri";
    public static final String PARAM_LOCALIZATION_MESSAGES_URI = "localizationMessagesUri";
    private static final String VALUE_ID_SUFFIX = "_VALUE";
    private static boolean initialised = false;
    private static XMLWriter writer = null;
    private static String Package = "";
    private static TreeSet<ClassInfo> additionalClasses = new TreeSet();
    private static TreeSet<ClassInfo> enumerations = new TreeSet();
    private static GenericModel refModel = null;
    private static PackageInfo refPackage = null;
    private static SortedMap<Info, SortedSet<DiffElement>> diffs = new TreeMap<Info, SortedSet<DiffElement>>();
    private static Differ differ = null;
    private static Map<String, ClassInfo> inputSchemaClassesByFullNameInSchema = null;
    private static boolean inheritedConstraints = true;
    private static boolean inheritedProperties = false;
    private static TreeSet<PropertyInfo> exportedRoles = new TreeSet();
    private static TreeSet<PropertyInfo> exportedProperties = new TreeSet();
    private static String OutputFormat = "";
    private static String outputDirectory = null;
    private static String outputFilename = null;
    private static String docxTemplateFilePath = "http://shapechange.net/resources/templates/template.docx";
    private static String docxStyle = "default";
    private static String logoFilePath = null;
    private static boolean error = false;
    private static boolean printed = false;
    private static String encoding = null;
    private static String xslfofileName = "pdf.xsl";
    private static String xslTransformerFactory = null;
    private static String xslhtmlfileName = "html.xsl";
    private static final String DEFAULT_XSL_HTML_DIFF_FILE_NAME = "html_diff.xsl";
    private static String xslframeHtmlFileName = "frameHtml.xsl";
    private static String cssFileName = "stylesheet.css";
    private static String xslrtffileName = "rtf.xsl";
    private static String xsldocxfileName = "docx.xsl";
    private static String xsldocxrelsfileName = "docx_rels.xsl";
    private static String xsldocxContentTypesFileName = "docx_contentTypes.xsl";
    private static String xslxmlfileName = "xml.xsl";
    private static String xsltPath;
    private static String cssPath;
    private static String lang;
    private static String featureTerm;
    private static String noAlphabeticSortingForProperties;
    private static String includeCodelistsAndEnumerations;
    private static boolean includeVoidable;
    private static boolean includeTitle;
    private static boolean includeCodelistURI;
    private static boolean deleteXmlFile;
    private static String representTaggedValues;
    private static boolean includeDiagrams;
    private static int imgIntegerIdCounter;
    private static int imgIntegerIdStepwidth;
    private static List<ImageMetadata> imageList;
    private static boolean dontTransform;
    private static String pathToJavaExe;
    private static String javaOptions;
    private static Map<String, Integer> encounteredAppSchemasByName;
    private TreeMap<String, String> transformationParameters = new TreeMap();
    private PackageInfo pi = null;
    private Model model = null;
    private Options options = null;
    private ShapeChangeResult result = null;
    private int streamBufferSize = 8336;
    private TreeMap<String, URI> hrefMappings = new TreeMap();

    @Override
    public String getTargetName() {
        return "Feature Catalogue";
    }

    @Override
    public void reset() {
        additionalClasses = new TreeSet();
        cssFileName = "stylesheet.css";
        cssPath = xsltPath;
        deleteXmlFile = false;
        differ = null;
        diffs = new TreeMap<Info, SortedSet<DiffElement>>();
        docxStyle = "default";
        docxTemplateFilePath = DOCX_TEMPLATE_URL;
        dontTransform = false;
        encoding = null;
        encounteredAppSchemasByName = null;
        enumerations = new TreeSet();
        error = false;
        exportedProperties = new TreeSet();
        exportedRoles = new TreeSet();
        featureTerm = "Feature";
        imageList = new ArrayList<ImageMetadata>();
        imgIntegerIdCounter = 0;
        imgIntegerIdStepwidth = 2;
        includeCodelistsAndEnumerations = "false";
        includeCodelistURI = true;
        includeDiagrams = false;
        includeTitle = true;
        includeVoidable = true;
        inheritedConstraints = true;
        inheritedProperties = false;
        initialised = false;
        inputSchemaClassesByFullNameInSchema = null;
        javaOptions = null;
        lang = "en";
        logoFilePath = null;
        noAlphabeticSortingForProperties = "false";
        outputDirectory = null;
        outputFilename = null;
        OutputFormat = "";
        Package = "";
        pathToJavaExe = null;
        printed = false;
        refModel = null;
        refPackage = null;
        representTaggedValues = null;
        writer = null;
        xsldocxContentTypesFileName = "docx_contentTypes.xsl";
        xsldocxfileName = "docx.xsl";
        xsldocxrelsfileName = "docx_rels.xsl";
        xslfofileName = "pdf.xsl";
        xslframeHtmlFileName = "frameHtml.xsl";
        xslhtmlfileName = "html.xsl";
        xslrtffileName = "rtf.xsl";
        xsltPath = "http://shapechange.net/resources/xslt";
        xslTransformerFactory = null;
        xslxmlfileName = "xml.xsl";
        System.clearProperty("javax.xml.transform.TransformerFactory");
    }

    @Override
    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        try {
            if (!initialised) {
                initialised = true;
                encounteredAppSchemasByName = new TreeMap<String, Integer>();
                this.initialiseFromOptions();
                String s = null;
                Object refModel_tmp = null;
                String string = this.options.parameter(this.getClass().getName(), PARAM_REFERENCE_MODEL_TYPE);
                String string2 = this.options.parameter(this.getClass().getName(), PARAM_REFERENCE_MODEL_FILENAME_OR_CONSTRING);
                if (StringUtils.isNotBlank((CharSequence)string) && StringUtils.isNotBlank((CharSequence)string2)) {
                    DefaultModelProvider mp = new DefaultModelProvider(this.result, this.options);
                    refModel_tmp = mp.getModel(string, string2, null, null, false, null);
                }
                if (refModel_tmp != null) {
                    refModel = new GenericModel((Model)refModel_tmp);
                    refModel_tmp.shutdown();
                    refModel.addPrefixToModelElementIDs("refmodel_");
                }
                String xmlName = outputFilename + ".tmp.xml";
                File outputDirectoryFile = new File(outputDirectory);
                boolean exi = outputDirectoryFile.exists();
                if (!exi) {
                    outputDirectoryFile.mkdirs();
                    exi = outputDirectoryFile.exists();
                }
                boolean dir = outputDirectoryFile.isDirectory();
                boolean wrt = outputDirectoryFile.canWrite();
                boolean rea = outputDirectoryFile.canRead();
                if (!(exi && dir && wrt && rea)) {
                    this.result.addFatalError(this, 12, outputDirectory);
                    throw new ShapeChangeAbortException();
                }
                String encoding_ = encoding == null ? "UTF-8" : this.model.characterEncoding();
                FileOutputStream fout = new FileOutputStream(outputDirectory + "/" + xmlName);
                BufferedOutputStream bout = new BufferedOutputStream(fout, this.streamBufferSize);
                OutputStreamWriter outputXML = new OutputStreamWriter((OutputStream)bout, encoding_);
                writer = new XMLWriter(outputXML, encoding_);
                writer.forceNSDecl("http://www.w3.org/2001/XMLSchema-instance", "xsi");
                writer.startDocument();
                writer.processingInstruction("xml-stylesheet", "type='text/xsl' href='./html.xsl'");
                writer.comment("Feature catalogue created using ShapeChange");
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation", "xsi:noNamespaceSchemaLocation", "CDATA", "FC.xsd");
                writer.startElement("", "FeatureCatalogue", "", atts);
                s = this.options.parameter(this.getClass().getName(), PARAM_NAME);
                if (s != null && s.length() > 0) {
                    writer.dataElement(PARAM_NAME, s);
                } else {
                    writer.dataElement(PARAM_NAME, "unknown");
                }
                s = this.options.parameter(this.getClass().getName(), PARAM_SCOPE);
                if (s != null && s.length() > 0) {
                    this.PrintLineByLine(s, PARAM_SCOPE, null);
                } else {
                    writer.dataElement(PARAM_SCOPE, "unknown");
                }
                s = this.options.parameter(this.getClass().getName(), PARAM_VERSION_NUMBER);
                if (s != null && s.length() > 0) {
                    writer.dataElement(PARAM_VERSION_NUMBER, s);
                } else {
                    writer.dataElement(PARAM_VERSION_NUMBER, "unknown");
                }
                s = this.options.parameter(this.getClass().getName(), PARAM_VERSION_DATE);
                if (StringUtils.isNotBlank((CharSequence)s)) {
                    if (s.trim().equalsIgnoreCase("now")) {
                        s = ZonedDateTime.now(ZoneOffset.systemDefault()).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                    }
                    writer.dataElement(PARAM_VERSION_DATE, s);
                } else {
                    writer.dataElement(PARAM_VERSION_DATE, "unknown");
                }
                s = this.options.parameter(this.getClass().getName(), PARAM_PRODUCER);
                if (s != null && s.length() > 0) {
                    writer.dataElement(PARAM_PRODUCER, s);
                } else {
                    writer.dataElement(PARAM_PRODUCER, "unknown");
                }
            }
            if (refModel != null) {
                SortedSet<PackageInfo> set = refModel.schemas(p.name());
                if (set.size() == 1) {
                    inputSchemaClassesByFullNameInSchema = new HashMap<String, ClassInfo>();
                    for (ClassInfo classInfo : this.model.classes(this.pi)) {
                        inputSchemaClassesByFullNameInSchema.put(classInfo.fullNameInSchema().toLowerCase(Locale.ENGLISH), classInfo);
                    }
                    differ = new Differ();
                    refPackage = (PackageInfo)set.iterator().next();
                    SortedMap<Info, SortedSet<DiffElement>> pi_diffs = differ.diff(p, refPackage);
                    differ.merge(diffs, pi_diffs);
                    for (Map.Entry<Info, SortedSet<DiffElement>> entry : pi_diffs.entrySet()) {
                        ShapeChangeResult.MessageContext mc = this.result.addInfo("Model difference - " + entry.getKey().fullName().replace(p.fullName(), p.name()));
                        for (DiffElement diff : entry.getValue()) {
                            String s = diff.change + " " + diff.subElementType;
                            if (diff.subElementType == DiffElement.ElementType.TAG) {
                                s = s + "(" + diff.tag + ")";
                            }
                            s = diff.subElement != null ? s + " " + diff.subElement.name() : (diff.diff != null ? s + " " + new diff_match_patch().diff_prettyHtml(diff.diff) : s + " ???");
                            mc.addDetail(s);
                        }
                    }
                    if (this.options.parameter(this.getClass().getName(), PARAM_XSL_HTML_FILE) == null) {
                        xslhtmlfileName = DEFAULT_XSL_HTML_DIFF_FILE_NAME;
                    }
                } else {
                    this.result.addWarning(this, 308, p.name());
                    refModel = null;
                }
            }
            writer.startElement("ApplicationSchema", "id", this.packageId(this.pi));
            Object nameForAppSchema = null;
            if (encounteredAppSchemasByName.containsKey(this.pi.name())) {
                int count = encounteredAppSchemasByName.get(this.pi.name());
                nameForAppSchema = this.pi.name() + " (" + ++count + ")";
                encounteredAppSchemasByName.put(this.pi.name(), count);
            } else {
                nameForAppSchema = this.pi.name();
                encounteredAppSchemasByName.put(this.pi.name(), 1);
            }
            writer.dataElement(PARAM_NAME, (String)nameForAppSchema);
            String s = this.pi.definition();
            if (s != null && s.length() > 0) {
                this.PrintLineByLine(s, "definition", null);
            }
            if ((s = this.pi.description()) != null && s.length() > 0) {
                this.PrintLineByLine(s, "description", null);
            }
            if ((s = this.pi.version()) != null && s.length() > 0) {
                writer.dataElement(PARAM_VERSION_NUMBER, s);
            }
            writer.startElement("taggedValues");
            s = this.pi.taggedValue("generationDateTime");
            if (StringUtils.isNotBlank((CharSequence)s)) {
                writer.dataElement("generationDateTime", this.PrepareToPrint(s));
            }
            writer.endElement("taggedValues");
            if (this.pi.getDiagrams() != null) {
                this.appendImageInfo(this.pi.getDiagrams());
            }
            writer.endElement("ApplicationSchema");
            if (this.hasDiff(this.pi, DiffElement.ElementType.SUBPACKAGE, DiffElement.Operation.DELETE)) {
                SortedSet<DiffElement> sortedSet = this.getDiffs(this.pi, DiffElement.ElementType.SUBPACKAGE, DiffElement.Operation.DELETE);
                for (DiffElement diff : sortedSet) {
                    this.PrintPackage((PackageInfo)diff.subElement, DiffElement.Operation.DELETE);
                }
            }
            this.printContainedPackages(this.pi);
            this.printDeletedClasses(this.pi);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null) {
                this.result.addError(msg);
            }
            e.printStackTrace(System.err);
        }
    }

    private String packageId(PackageInfo pkg) {
        return pkg.id().startsWith("P") ? "_" + pkg.id() : "_P" + pkg.id();
    }

    private String packageId(String pkgId) {
        return pkgId.startsWith("P") ? "_" + pkgId : "_P" + pkgId;
    }

    private void printDeletedClasses(PackageInfo pix) {
        if (this.hasDiff(pix, DiffElement.ElementType.CLASS, DiffElement.Operation.DELETE)) {
            SortedSet<DiffElement> classdiffs = this.getDiffs(pix, DiffElement.ElementType.CLASS, DiffElement.Operation.DELETE);
            for (DiffElement diff : classdiffs) {
                ClassInfo deletedCi = (ClassInfo)diff.subElement;
                if (deletedCi.category() == 2 || deletedCi.category() == 3) continue;
                this.PrintClass(deletedCi, true, DiffElement.Operation.DELETE, pix);
            }
        }
    }

    private void appendImageInfo(List<ImageMetadata> images) throws SAXException {
        if (!includeDiagrams) {
            return;
        }
        writer.startElement("images");
        for (ImageMetadata img : images) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "id", "", "CDATA", img.getId());
            atts.addAttribute("", "idAsInt", "", "CDATA", "" + imgIntegerIdCounter);
            imgIntegerIdCounter += imgIntegerIdStepwidth;
            atts.addAttribute("", PARAM_NAME, "", "CDATA", img.getName());
            atts.addAttribute("", "height", "", "CDATA", "" + img.getHeight());
            atts.addAttribute("", "width", "", "CDATA", "" + img.getWidth());
            atts.addAttribute("", "relPath", "", "CDATA", img.getRelPathToFile());
            writer.emptyElement("image", atts);
            imageList.add(img);
        }
        writer.endElement("images");
    }

    private void PrintDescriptors(Info i, boolean isClass, DiffElement.Operation op) throws SAXException {
        Object[] sa;
        String s = i.name();
        s = this.checkDiff(s, i, DiffElement.ElementType.NAME);
        writer.dataElement(PARAM_NAME, this.PrepareToPrint(s), op);
        s = i.aliasName();
        if (this.hasDiff(i, DiffElement.ElementType.ALIAS)) {
            SortedSet<DiffElement> diffs = this.getDiffs(i, DiffElement.ElementType.ALIAS);
            s = differ.diff_toString(((DiffElement)diffs.iterator().next()).diff);
            writer.dataElement("title", this.PrepareToPrint(s), op);
        } else if (includeTitle && i.aliasName() != null && i.aliasName().length() > 0) {
            writer.dataElement("title", s, op);
        }
        s = i.definition();
        s = this.checkDiff(s, i, DiffElement.ElementType.DEFINITION);
        if (s != null && s.length() > 0) {
            this.PrintLineByLine(s, "definition", op);
        }
        s = i.description();
        if ((s = this.checkDiff(s, i, DiffElement.ElementType.DESCRIPTION)) != null && s.length() > 0) {
            this.PrintLineByLine(s, "description", op);
        }
        if ((sa = i.examples()) != null) {
            Arrays.sort(sa);
            for (Object s2 : sa) {
                if (s2 == null) continue;
                this.PrintLineByLine((String)s2, "example", null);
            }
        }
        s = i.legalBasis();
        if ((s = this.checkDiff(s, i, DiffElement.ElementType.LEGALBASIS)) != null && s.length() > 0) {
            this.PrintLineByLine(s, "legalBasis", op);
        }
        if ((sa = i.dataCaptureStatements()) != null) {
            Arrays.sort(sa);
            for (Object s2 : sa) {
                if (s2 == null) continue;
                this.PrintLineByLine((String)s2, "dataCaptureStatement", null);
            }
        }
        s = i.primaryCode();
        if ((s = this.checkDiff(s, i, DiffElement.ElementType.PRIMARYCODE)) != null && s.length() > 0) {
            writer.dataElement("code", this.PrepareToPrint(s), op);
        }
        s = i.globalIdentifier();
        if ((s = this.checkDiff(s, i, DiffElement.ElementType.GLOBALIDENTIFIER)) != null && s.length() > 0) {
            writer.dataElement("globalIdentifier", this.PrepareToPrint(s), op);
        }
    }

    private SortedSet<DiffElement> getDiffs(Info i, DiffElement.ElementType type) {
        TreeSet<DiffElement> result = new TreeSet<DiffElement>();
        if (diffs != null && diffs.get(i) != null) {
            for (DiffElement diff : (SortedSet)diffs.get(i)) {
                if (diff.subElementType != type) continue;
                result.add(diff);
            }
        }
        return result;
    }

    private SortedSet<DiffElement> getDiffs(Info i, DiffElement.ElementType type, DiffElement.Operation op) {
        TreeSet<DiffElement> result = new TreeSet<DiffElement>();
        if (diffs != null && diffs.get(i) != null) {
            for (DiffElement diff : (SortedSet)diffs.get(i)) {
                if (diff.subElementType != type || diff.change != op) continue;
                result.add(diff);
            }
        }
        return result;
    }

    private boolean hasDiff(Info i, DiffElement.ElementType type) {
        if (diffs != null && diffs.get(i) != null) {
            for (DiffElement diff : (SortedSet)diffs.get(i)) {
                if (diff.subElementType != type) continue;
                return true;
            }
        }
        return false;
    }

    private String checkDiff(String s, Info i, DiffElement.ElementType type) {
        if (diffs != null && diffs.get(i) != null) {
            for (DiffElement diff : (SortedSet)diffs.get(i)) {
                if (diff.subElementType != type) continue;
                return differ.diff_toString(diff.diff);
            }
        }
        return s;
    }

    private void PrintPackage(PackageInfo pix, DiffElement.Operation op) throws Exception {
        if (this.packageInPackage(pix)) {
            writer.startElement("Package", "id", this.packageId(pix), op);
            this.PrintDescriptors(pix, false, op);
            Object pixOwnerId = pix.owner().id();
            Info ownerOfInputModel = this.getInfoWithDiff(DiffElement.ElementType.SUBPACKAGE, DiffElement.Operation.DELETE, pix);
            if (ownerOfInputModel != null) {
                pixOwnerId = ownerOfInputModel.id();
            }
            writer.emptyElement("parent", "idref", this.packageId((String)pixOwnerId));
            if (pix.getDiagrams() != null) {
                this.appendImageInfo(pix.getDiagrams());
            }
            writer.endElement("Package");
        }
        if (op != null && op == DiffElement.Operation.DELETE) {
            for (PackageInfo delpi : pix.containedPackages()) {
                if (delpi.isSchema()) continue;
                this.PrintPackage(delpi, DiffElement.Operation.DELETE);
            }
            for (ClassInfo delci : pix.containedClasses()) {
                this.PrintClass(delci, true, DiffElement.Operation.DELETE, pix);
            }
        } else {
            if (this.hasDiff(pix, DiffElement.ElementType.SUBPACKAGE, DiffElement.Operation.DELETE)) {
                SortedSet<DiffElement> pkgdiffs = this.getDiffs(pix, DiffElement.ElementType.SUBPACKAGE, DiffElement.Operation.DELETE);
                for (DiffElement diff : pkgdiffs) {
                    this.PrintPackage((PackageInfo)diff.subElement, DiffElement.Operation.DELETE);
                }
            }
            this.printContainedPackages(pix);
            this.printDeletedClasses(pix);
        }
    }

    private void printContainedPackages(PackageInfo pix) throws Exception {
        for (PackageInfo pix2 : pix.containedPackages()) {
            if (pix2.isSchema()) continue;
            if (this.hasDiff(pix, DiffElement.ElementType.SUBPACKAGE, DiffElement.Operation.INSERT, pix2)) {
                this.PrintPackage(pix2, DiffElement.Operation.INSERT);
                continue;
            }
            this.PrintPackage(pix2, null);
        }
    }

    private void PrintLineByLine(String s, String ename, DiffElement.Operation op) throws SAXException {
        String[] lines;
        boolean ins = false;
        boolean del = false;
        for (String line : lines = s.replace("[NEWLINE]", "\n").replace("\r\n", "\n").replace("\r", "\n").split("\n")) {
            Object text = this.PrepareToPrint(line);
            if (ins) {
                text = "[[ins]]" + line;
                ins = false;
            } else if (del) {
                text = "[[del]]" + line;
                del = false;
            }
            if (this.countSubstringInString((String)text, "[[ins]]") > this.countSubstringInString((String)text, "[[/ins]]")) {
                ins = true;
                text = (String)text + "[[/ins]]";
            } else if (this.countSubstringInString((String)text, "[[del]]") > this.countSubstringInString((String)text, "[[/del]]")) {
                del = true;
                text = (String)text + "[[/del]]";
            }
            text = this.options.internalize((String)text);
            writer.dataElement(ename, (String)text, op);
        }
    }

    private int countSubstringInString(String str, String substr) {
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(substr, idx)) != -1) {
            ++idx;
            ++count;
        }
        return count;
    }

    private String PrepareToPrint(String s) {
        return s == null ? "" : s.trim();
    }

    protected void addAttribute(Document document, Element e, String name, String value) {
        Attr att = document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    protected Document createDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(null, 2);
            String m = e.getMessage();
            if (m != null) {
                this.result.addFatalError(m);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            this.result.addFatalError(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        return document;
    }

    private boolean packageInPackage(PackageInfo pi) {
        if (Package.length() == 0) {
            return true;
        }
        if (pi.name().equals(Package)) {
            return true;
        }
        if (pi.isSchema()) {
            return false;
        }
        return this.packageInPackage(pi.owner());
    }

    @Override
    public void process(ClassInfo ci) {
        if (error) {
            return;
        }
        if (!this.packageInPackage(ci.pkg())) {
            return;
        }
        DiffElement.Operation op = null;
        if (diffs != null && diffs.get(ci.pkg()) != null) {
            for (DiffElement diff : (SortedSet)diffs.get(ci.pkg())) {
                if (diff.subElementType != DiffElement.ElementType.CLASS || (ClassInfo)diff.subElement != ci || diff.change != DiffElement.Operation.INSERT) continue;
                op = DiffElement.Operation.INSERT;
                break;
            }
        }
        if (op == null) {
            PackageInfo pix = ci.pkg();
            while (pix != null) {
                if (diffs != null && pix.owner() != null && diffs.get(pix.owner()) != null) {
                    for (DiffElement diff : (SortedSet)diffs.get(pix.owner())) {
                        if (diff.subElementType != DiffElement.ElementType.SUBPACKAGE || (PackageInfo)diff.subElement != pix || diff.change != DiffElement.Operation.INSERT) continue;
                        op = DiffElement.Operation.INSERT;
                        pix = null;
                        break;
                    }
                }
                if (pix == null) continue;
                pix = pix.owner();
            }
        }
        int cat = ci.category();
        switch (cat) {
            case 1: 
            case 6: 
            case 12: {
                this.PrintClass(ci, true, op, ci.pkg());
                break;
            }
            case 4: {
                if (inheritedProperties) break;
                this.PrintClass(ci, true, op, ci.pkg());
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                this.PrintClass(ci, true, op, ci.pkg());
                for (String t : ci.supertypes()) {
                    ClassInfo cix = this.model.classById(t);
                    if (cix == null) continue;
                    additionalClasses.add(cix);
                }
                break;
            }
        }
    }

    private void PrintValue(PropertyInfo propi, DiffElement.Operation op) throws SAXException {
        Object propiid = "_A" + propi.id() + VALUE_ID_SUFFIX;
        propiid = this.options.internalize((String)propiid);
        writer.startElement("Value", "id", (String)propiid, op);
        String s = propi.aliasName();
        s = this.checkDiff(s, propi, DiffElement.ElementType.ALIAS);
        if (s == null || s.length() == 0) {
            s = propi.name();
            s = this.checkDiff(s, propi, DiffElement.ElementType.NAME);
        }
        writer.dataElement("label", s, op);
        s = propi.initialValue();
        if (s == null || s.length() == 0) {
            s = propi.name();
        }
        s = this.options.internalize(s);
        writer.dataElement("code", this.PrepareToPrint(s), op);
        s = propi.definition();
        s = this.checkDiff(s, propi, DiffElement.ElementType.DEFINITION);
        if (s != null && s.length() > 0) {
            this.PrintLineByLine(s, "definition", op);
        }
        s = propi.description();
        if ((s = this.checkDiff(s, propi, DiffElement.ElementType.DESCRIPTION)) != null && s.length() > 0) {
            this.PrintLineByLine(s, "description", op);
        }
        if (representTaggedValues != null) {
            this.PrintTaggedValues(propi, representTaggedValues, null, true);
        }
        writer.endElement("Value");
    }

    private void PrintValues(ClassInfo ci, DiffElement.Operation op) throws SAXException {
        for (PropertyInfo propi : ci.properties().values()) {
            if (propi == null || !this.ExportValue(propi)) continue;
            DiffElement.Operation top = op;
            if (this.hasDiff(ci, DiffElement.ElementType.ENUM, DiffElement.Operation.INSERT, propi)) {
                top = DiffElement.Operation.INSERT;
            }
            this.PrintValue(propi, top);
        }
        if (diffs != null && diffs.get(ci) != null) {
            for (DiffElement diff : (SortedSet)diffs.get(ci)) {
                if (diff.subElementType != DiffElement.ElementType.ENUM || diff.change != DiffElement.Operation.DELETE) continue;
                this.PrintValue((PropertyInfo)diff.subElement, DiffElement.Operation.DELETE);
            }
        }
    }

    private boolean ExportItem(Info i) {
        return true;
    }

    private boolean ExportValue(PropertyInfo propi) {
        return this.ExportItem(propi);
    }

    private boolean ExportProperty(PropertyInfo propi) {
        if (propi.name().length() == 0) {
            return false;
        }
        return this.ExportItem(propi);
    }

    private boolean ExportClass(ClassInfo ci, Boolean onlyProperties, DiffElement.Operation op) {
        if (!ci.inSchema(this.pi) && !onlyProperties.booleanValue() && op != DiffElement.Operation.DELETE) {
            return false;
        }
        if (!this.packageInPackage(ci.pkg()) && !onlyProperties.booleanValue() && op != DiffElement.Operation.DELETE) {
            return false;
        }
        return this.ExportItem(ci);
    }

    private void PrintClass(ClassInfo ci, boolean onlyProperties, DiffElement.Operation op, PackageInfo pix) {
        if (!this.ExportClass(ci, onlyProperties, op)) {
            return;
        }
        try {
            if (onlyProperties) {
                String s;
                Object ciid = "_C" + ci.id();
                ciid = this.options.internalize((String)ciid);
                writer.startElement("FeatureType", "id", (String)ciid, op);
                this.PrintDescriptors(ci, true, op);
                if (ci.isAbstract()) {
                    writer.dataElement("isAbstract", "1");
                }
                for (String t : ci.supertypes()) {
                    ClassInfo cix = this.lookupClassById(t);
                    if (cix == null) continue;
                    Object name = cix.name();
                    Object cixid = "_C" + cix.id();
                    cixid = this.options.internalize((String)cixid);
                    boolean inserted = false;
                    DiffElement.Operation opForGeneralization = op;
                    if (this.hasDiff(ci, DiffElement.ElementType.SUPERTYPE, DiffElement.Operation.INSERT, cix)) {
                        name = "[[ins]]" + (String)name + "[[/ins]]";
                        inserted = true;
                        opForGeneralization = DiffElement.Operation.INSERT;
                    }
                    if (!inserted && inheritedProperties && cix.category() == 4) continue;
                    name = this.options.internalize((String)name);
                    writer.dataElement("subtypeOf", cix.name(), "idref", (String)cixid, opForGeneralization);
                }
                if (this.hasDiff(ci, DiffElement.ElementType.SUPERTYPE, DiffElement.Operation.DELETE)) {
                    for (DiffElement diff : this.getDiffs(ci, DiffElement.ElementType.SUPERTYPE, DiffElement.Operation.DELETE)) {
                        String nameOfDeletedSupertype = "[[del]]" + diff.subElement.name() + "[[/del]]";
                        String supertypeId = diff.subElement.id();
                        ClassInfo supertype = this.lookupClassById(supertypeId);
                        Object cixid = "_C" + supertype.id();
                        cixid = this.options.internalize((String)cixid);
                        writer.dataElement("subtypeOf", nameOfDeletedSupertype, "idref", (String)cixid, DiffElement.Operation.DELETE);
                    }
                }
                this.PrintProperties(ci, true, op);
                writer.emptyElement(PARAM_PACKAGE, "idref", this.packageId(pix));
                switch (ci.category()) {
                    case 1: 
                    case 12: {
                        Object text = featureTerm + " Type";
                        text = this.options.internalize((String)text);
                        writer.dataElement("type", (String)text, op);
                        break;
                    }
                    case 6: {
                        writer.dataElement("type", "Object Type", op);
                        break;
                    }
                    case 5: 
                    case 11: {
                        writer.dataElement("type", "Data Type", op);
                        break;
                    }
                    case 8: {
                        writer.dataElement("type", "Union Data Type", op);
                        break;
                    }
                    case 2: {
                        writer.dataElement("type", "Code List Type", op);
                        break;
                    }
                    case 3: {
                        writer.dataElement("type", "Enumeration Type", op);
                    }
                }
                for (Constraint constraint : ci.constraints()) {
                    if (!inheritedConstraints && this.isInheritedConstraint(constraint, ci)) continue;
                    writer.startElement("constraint");
                    writer.dataElement(PARAM_NAME, constraint.name());
                    s = constraint.text();
                    String description = null;
                    String expression = null;
                    if (constraint instanceof TextConstraint) {
                        expression = s;
                    } else if (s != null && s.contains("/*") && s.contains("*/")) {
                        String[] sa = s.split("\\*/");
                        description = sa[0].replaceFirst("/\\*", "").trim();
                        if (sa.length > 1) {
                            expression = sa[1].trim();
                        }
                    } else {
                        expression = s;
                    }
                    if (description != null && description.length() > 0) {
                        writer.dataElement("description", description);
                    }
                    if (expression != null && expression.length() > 0) {
                        writer.dataElement("expression", expression);
                    }
                    writer.endElement("constraint");
                }
                s = ci.taggedValue("alwaysVoid");
                if (StringUtils.isNotBlank((CharSequence)s)) {
                    writer.startElement("constraint");
                    writer.dataElement("description", "Properties that are always void: " + s);
                    writer.endElement("constraint");
                }
                if (StringUtils.isNotBlank((CharSequence)(s = ci.taggedValue("neverVoid")))) {
                    writer.startElement("constraint");
                    writer.dataElement("description", "Properties that are never void: " + s);
                    writer.endElement("constraint");
                }
                if (StringUtils.isNotBlank((CharSequence)(s = ci.taggedValue("appliesTo")))) {
                    writer.startElement("constraint");
                    writer.dataElement("description", "Applies to the following network elements: " + s);
                    writer.endElement("constraint");
                }
                writer.startElement("taggedValues");
                s = ci.taggedValue(PARAM_NAME);
                if (StringUtils.isNotBlank((CharSequence)s)) {
                    writer.dataElement(PARAM_NAME, this.PrepareToPrint(s), op);
                }
                if (representTaggedValues != null) {
                    this.PrintTaggedValues(ci, representTaggedValues, null, false);
                }
                writer.endElement("taggedValues");
                if (ci.getDiagrams() != null) {
                    this.appendImageInfo(ci.getDiagrams());
                }
                writer.endElement("FeatureType");
            }
            this.PrintProperties(ci, false, op);
        }
        catch (SAXException e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
    }

    private boolean isInheritedConstraint(Constraint constraint, ClassInfo ci) {
        for (ClassInfo supertype : ci.supertypesInCompleteHierarchy()) {
            for (Constraint stCon : supertype.constraints()) {
                if (!stCon.name().equals(constraint.name()) || !stCon.text().equals(constraint.text())) continue;
                return true;
            }
        }
        return false;
    }

    private void PrintTaggedValues(Info i, String taglist, DiffElement.Operation op, boolean printTaggedValuesElement) throws SAXException {
        TaggedValues taggedValues = i.taggedValuesForTagList(taglist);
        if (!taggedValues.isEmpty()) {
            if (printTaggedValuesElement) {
                writer.startElement("taggedValues");
            }
            TreeSet<String> tags = new TreeSet<String>(taggedValues.keySet());
            for (String tag : tags) {
                String[] values = taggedValues.get(tag);
                List<String> valueList = Arrays.asList(values);
                Collections.sort(valueList);
                for (String v : values) {
                    if (v.trim().length() <= 0) continue;
                    writer.dataElement("taggedValue", v, "tag", tag, op);
                }
            }
            if (printTaggedValuesElement) {
                writer.endElement("taggedValues");
            }
        }
    }

    private boolean hasDiff(Info i, DiffElement.ElementType subElementType, DiffElement.Operation diffChange, Info diffSubelement) {
        if (diffs != null && diffs.get(i) != null) {
            for (DiffElement diff : (SortedSet)diffs.get(i)) {
                if (diff.subElementType != subElementType || diff.change != diffChange || diff.subElement != diffSubelement) continue;
                return true;
            }
        }
        return false;
    }

    private Info getInfoWithDiff(DiffElement.ElementType subElementType, DiffElement.Operation diffChange, Info diffSubelement) {
        if (diffs != null) {
            for (Info i : diffs.keySet()) {
                for (DiffElement diff : (SortedSet)diffs.get(i)) {
                    if (diff.subElementType != subElementType || diff.change != diffChange || diff.subElement != diffSubelement) continue;
                    return i;
                }
            }
        }
        return null;
    }

    private boolean hasDiff(Info i, DiffElement.ElementType subElementType, DiffElement.Operation diffChange) {
        if (diffs != null && diffs.get(i) != null) {
            for (DiffElement diff : (SortedSet)diffs.get(i)) {
                if (diff.subElementType != subElementType || diff.change != diffChange) continue;
                return true;
            }
        }
        return false;
    }

    private void PrintProperties(ClassInfo ci, boolean listOnly, DiffElement.Operation op) throws SAXException {
        if (inheritedProperties) {
            for (String cid : ci.supertypes()) {
                ClassInfo cix = this.model.classById(cid);
                if (cix == null) continue;
                this.PrintProperties(cix, listOnly, op);
            }
        }
        for (PropertyInfo propi : ci.properties().values()) {
            DiffElement.Operation top = op;
            if (this.hasDiff(ci, DiffElement.ElementType.PROPERTY, DiffElement.Operation.INSERT, propi)) {
                top = DiffElement.Operation.INSERT;
            }
            if (listOnly) {
                this.PrintPropertyRef(propi, top);
                continue;
            }
            this.PrintProperty(propi, top);
        }
        if (diffs != null && diffs.get(ci) != null) {
            for (DiffElement diff : (SortedSet)diffs.get(ci)) {
                if (diff.subElementType != DiffElement.ElementType.PROPERTY || diff.change != DiffElement.Operation.DELETE) continue;
                if (listOnly) {
                    this.PrintPropertyRef((PropertyInfo)diff.subElement, DiffElement.Operation.DELETE);
                    continue;
                }
                this.PrintProperty((PropertyInfo)diff.subElement, DiffElement.Operation.DELETE);
            }
        }
    }

    private void PrintPropertyRef(PropertyInfo propi, DiffElement.Operation op) throws SAXException {
        if (this.ExportProperty(propi)) {
            Object propiid = "_A" + propi.id();
            propiid = this.options.internalize((String)propiid);
            writer.emptyElement("characterizedBy", "idref", (String)propiid, op);
        }
    }

    private void PrintProperty(PropertyInfo propi, DiffElement.Operation op) throws SAXException {
        if (!this.ExportProperty(propi)) {
            return;
        }
        if (exportedProperties.contains(propi)) {
            return;
        }
        Object assocId = "__FIXME";
        if (!propi.isAttribute()) {
            if (!exportedRoles.contains(propi)) {
                ClassInfo aci;
                assocId = "__" + propi.id();
                writer.startElement("FeatureRelationship", "id", (String)assocId, op);
                writer.dataElement(PARAM_NAME, this.PrepareToPrint("(unbestimmt)"));
                AssociationInfo ai = propi.association();
                if (ai != null && (aci = ai.assocClass()) != null) {
                    Object aciid = "_C" + aci.id();
                    aciid = this.options.internalize((String)aciid);
                    writer.dataElement("associationClass", this.PrepareToPrint(aci.name()), "idref", (String)aciid, op);
                }
                Object propiid = "_A" + propi.id();
                propiid = this.options.internalize((String)propiid);
                writer.emptyElement("roles", "idref", (String)propiid, op);
                PropertyInfo propi2 = propi.reverseProperty();
                if (propi2 != null && this.ExportProperty(propi2)) {
                    Object propi2id = "_A" + propi2.id();
                    propi2id = this.options.internalize((String)propi2id);
                    writer.emptyElement("roles", "idref", (String)propi2id, op);
                }
                writer.endElement("FeatureRelationship");
                this.PrintPropertyDetail(propi, (String)assocId, op);
                exportedRoles.add(propi);
                if (propi2 != null) {
                    if (this.ExportProperty(propi2)) {
                        this.PrintPropertyDetail(propi2, (String)assocId, op);
                    }
                    exportedRoles.add(propi2);
                }
            } else {
                PropertyInfo propi2 = propi.reverseProperty();
                if (propi2 != null) {
                    assocId = "__" + propi2.id();
                }
            }
        } else {
            this.PrintPropertyDetail(propi, (String)assocId, op);
        }
        exportedProperties.add(propi);
    }

    /*
     * Unable to fully structure code
     */
    private void PrintPropertyDetail(PropertyInfo propi, String assocId, DiffElement.Operation op) throws SAXException {
        block44: {
            block45: {
                block46: {
                    block43: {
                        propiid = "_A" + propi.id();
                        propiid = this.options.internalize((String)propiid);
                        if (propi.isAttribute()) {
                            FeatureCatalogue.writer.startElement("FeatureAttribute", "id", (String)propiid, op);
                        } else {
                            FeatureCatalogue.writer.startElement("RelationshipRole", "id", (String)propiid, op);
                        }
                        this.PrintDescriptors(propi, false, op);
                        s = propi.cardinality().toString();
                        s = this.checkDiff(s, propi, DiffElement.ElementType.MULTIPLICITY);
                        cardinalityText = this.PrepareToPrint(s);
                        cardinalityText = this.options.internalize(cardinalityText);
                        FeatureCatalogue.writer.dataElement("cardinality", cardinalityText, op);
                        if (!propi.isAttribute() && !propi.isNavigable()) {
                            this.PrintLineByLine("false", "isNavigable", op);
                        }
                        if (propi.isDerived()) {
                            this.PrintLineByLine("true", "isDerived", op);
                        }
                        s = propi.initialValue();
                        if (propi.isAttribute() && s != null && s.length() > 0) {
                            this.PrintLineByLine(this.PrepareToPrint(s), "initialValue", op);
                        }
                        FeatureCatalogue.writer.startElement("taggedValues");
                        s = propi.taggedValue("name");
                        if (StringUtils.isNotBlank((CharSequence)s)) {
                            FeatureCatalogue.writer.dataElement("name", this.PrepareToPrint(s), op);
                        }
                        for (String tag : tags = propi.taggedValuesForTag("length")) {
                            FeatureCatalogue.writer.dataElement("length", this.PrepareToPrint(tag), op);
                        }
                        if (FeatureCatalogue.representTaggedValues != null) {
                            this.PrintTaggedValues(propi, FeatureCatalogue.representTaggedValues, null, false);
                        }
                        FeatureCatalogue.writer.endElement("taggedValues");
                        if (FeatureCatalogue.includeVoidable) {
                            if (propi.voidable()) {
                                FeatureCatalogue.writer.dataElement("voidable", "true", op);
                            } else {
                                FeatureCatalogue.writer.dataElement("voidable", "false", op);
                            }
                        }
                        if (propi.isOrdered()) {
                            FeatureCatalogue.writer.dataElement("orderIndicator", "1", op);
                        } else {
                            FeatureCatalogue.writer.dataElement("orderIndicator", "0", op);
                        }
                        if (propi.isUnique()) {
                            FeatureCatalogue.writer.dataElement("uniquenessIndicator", "1", op);
                        } else {
                            FeatureCatalogue.writer.dataElement("uniquenessIndicator", "0", op);
                        }
                        ti = propi.typeInfo();
                        if (propi.isAttribute() || propi.isComposition()) break block43;
                        if (ti != null) {
                            atts = new AttributesImpl();
                            cix = this.lookupClassById(ti.id);
                            if (cix != null) {
                                tiid = "_C" + cix.id();
                                tiid = this.options.internalize((String)tiid);
                                atts.addAttribute("", "idref", "", "CDATA", (String)tiid);
                            }
                            atts.addAttribute("", "category", "", "CDATA", FeatureCatalogue.featureTerm.toLowerCase() + " type");
                            this.addOperationToAttributes(op, atts);
                            FeatureCatalogue.writer.dataElement("", "FeatureTypeIncluded", "", atts, this.checkDiff(ti.name, propi, DiffElement.ElementType.VALUETYPE));
                        }
                        FeatureCatalogue.writer.emptyElement("relation", "idref", assocId);
                        propi2 = propi.reverseProperty();
                        if (propi2 != null && this.ExportProperty(propi2) && propi2.isNavigable()) {
                            propi2id = "_A" + propi2.id();
                            propi2id = this.options.internalize((String)propi2id);
                            FeatureCatalogue.writer.emptyElement("InverseRole", "idref", (String)propi2id, op);
                        }
                        break block44;
                    }
                    if (ti == null) break block45;
                    cix = op != DiffElement.Operation.DELETE ? this.model.classById(ti.id) : FeatureCatalogue.refModel.classById(ti.id);
                    if (cix == null) break block46;
                    cat = cix.category();
                    cixname = cix.name();
                    cixname = this.checkDiff(cixname, propi, DiffElement.ElementType.VALUETYPE);
                    cixname = this.options.internalize(cixname);
                    switch (cat) {
                        case 2: 
                        case 3: {
                            atts = new AttributesImpl();
                            if (cat == 2) {
                                atts.addAttribute("", "category", "", "CDATA", "code list");
                                if (FeatureCatalogue.includeCodelistURI) {
                                    cl = cix.taggedValue("codeList");
                                    if (StringUtils.isBlank((CharSequence)cl)) {
                                        cl = cix.taggedValue("vocabulary");
                                    }
                                    if (StringUtils.isNotBlank((CharSequence)cl)) {
                                        atts.addAttribute("", "codeList", "", "CDATA", this.options.internalize((String)cl));
                                    }
                                }
                            } else if (cat == 3 && !cixname.equals("Boolean")) {
                                atts.addAttribute("", "category", "", "CDATA", "enumeration");
                            }
                            this.addOperationToAttributes(op, atts);
                            FeatureCatalogue.writer.dataElement("", "ValueDataType", "", atts, this.PrepareToPrint(cixname));
                            if (cixname.equals("Boolean")) ** GOTO lbl110
                            FeatureCatalogue.writer.dataElement("ValueDomainType", "1", op);
                            for (PropertyInfo ei : cix.properties().values()) {
                                if (ei == null || !this.ExportValue(ei)) continue;
                                eiid = "_A" + ei.id() + "_VALUE";
                                eiid = this.options.internalize((String)eiid);
                                FeatureCatalogue.writer.emptyElement("enumeratedBy", "idref", (String)eiid);
                            }
                            if (FeatureCatalogue.diffs != null && FeatureCatalogue.diffs.get(cix) != null) {
                                for (DiffElement diff : (SortedSet)FeatureCatalogue.diffs.get(cix)) {
                                    if (diff.subElementType != DiffElement.ElementType.ENUM || diff.change != DiffElement.Operation.DELETE) continue;
                                    FeatureCatalogue.writer.emptyElement("enumeratedBy", "idref", "_A" + ((PropertyInfo)diff.subElement).id() + "_VALUE");
                                }
                            }
                            if (op != DiffElement.Operation.DELETE) {
                                if (cix.inSchema(propi.inClass().pkg())) {
                                    FeatureCatalogue.enumerations.add(cix);
                                    break;
                                }
                            } else if (cix.inSchema(FeatureCatalogue.refPackage)) {
                                FeatureCatalogue.enumerations.add(cix);
                                break;
                            }
                            break block44;
lbl110:
                            // 1 sources

                            FeatureCatalogue.writer.dataElement("ValueDomainType", "0", op);
                            break;
                        }
                        default: {
                            cixid = "_C" + cix.id();
                            cixid = this.options.internalize((String)cixid);
                            atts2 = new AttributesImpl();
                            atts2.addAttribute("", "idref", "", "CDATA", (String)cixid);
                            if (cat == 1 || cat == 12) {
                                fttext = FeatureCatalogue.featureTerm.toLowerCase() + " type";
                                fttext = this.options.internalize((String)fttext);
                                atts2.addAttribute("", "category", "", "CDATA", (String)fttext);
                            } else if (cat == 5 || cat == 11) {
                                atts2.addAttribute("", "category", "", "CDATA", "data type");
                            } else if (cat == 8) {
                                atts2.addAttribute("", "category", "", "CDATA", "union data type");
                            } else if (cat == 7) {
                                atts2.addAttribute("", "category", "", "CDATA", "basic type");
                            }
                            this.addOperationToAttributes(op, atts2);
                            FeatureCatalogue.writer.dataElement("", "ValueDataType", "", atts2, this.PrepareToPrint(cixname));
                            FeatureCatalogue.writer.dataElement("ValueDomainType", "0", op);
                            break;
                        }
                    }
                    break block44;
                }
                tiname = ti.name;
                tiname = this.checkDiff(tiname, propi, DiffElement.ElementType.VALUETYPE);
                tiname = this.options.internalize(tiname);
                FeatureCatalogue.writer.dataElement("ValueDataType", this.PrepareToPrint(tiname), op);
                break block44;
            }
            FeatureCatalogue.writer.dataElement("ValueDataType", "(unknown)", op);
        }
        if (propi.isAttribute()) {
            FeatureCatalogue.writer.endElement("FeatureAttribute");
        } else {
            FeatureCatalogue.writer.endElement("RelationshipRole");
        }
    }

    private ClassInfo lookupClassById(String id) {
        String fullNameInSchema;
        String fullnamelowercase;
        ClassInfo ci = null;
        if (id != null && (ci = this.model.classById(id)) == null && refModel != null && (ci = refModel.classById(id)) != null && inputSchemaClassesByFullNameInSchema.containsKey(fullnamelowercase = (fullNameInSchema = ci.fullNameInSchema()).toLowerCase(Locale.ENGLISH))) {
            ci = inputSchemaClassesByFullNameInSchema.get(fullnamelowercase);
        }
        return ci;
    }

    private void addOperationToAttributes(DiffElement.Operation op, AttributesImpl atts) {
        if (atts != null && op != null) {
            atts.addAttribute("", "mode", "", "CDATA", op.toString());
        }
    }

    @Override
    public void write() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAll(ShapeChangeResult r) {
        String m;
        this.result = r;
        this.options = r.options();
        if (error || printed) {
            return;
        }
        try {
            DiffElement.Operation top;
            for (ClassInfo cix : additionalClasses) {
                top = this.getDiffChange(cix.pkg(), DiffElement.ElementType.CLASS, cix);
                this.PrintClass(cix, false, top, cix.pkg());
            }
            for (ClassInfo cix : enumerations) {
                top = this.getDiffChange(cix.pkg(), DiffElement.ElementType.CLASS, cix);
                this.PrintValues(cix, top);
            }
            writer.endElement("FeatureCatalogue");
            writer.endDocument();
            writer.close();
        }
        catch (Exception e) {
            m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    m = e.getMessage();
                    if (m != null) {
                        this.result.addError(m);
                    }
                    e.printStackTrace(System.err);
                }
            }
            if (refModel != null) {
                refModel.shutdown();
                refModel = null;
            }
        }
        printed = true;
    }

    private DiffElement.Operation getDiffChange(Info i, DiffElement.ElementType diffSubElementType, Info diffSubElement) {
        if (diffs != null && diffs.get(i) != null) {
            for (DiffElement diff : (SortedSet)diffs.get(i)) {
                if (diff.subElementType != diffSubElementType || diff.subElement != diffSubElement) continue;
                return diff.change;
            }
        }
        return null;
    }

    private void writePDF(String xmlName, String outfileBasename) {
        if (!OutputFormat.toLowerCase().contains("pdf")) {
            return;
        }
        StatusBoard.getStatusBoard().statusChanged(22);
        String pdffileName = outfileBasename + ".pdf";
        String mime = "application/pdf";
        if (xmlName != null && xmlName.length() > 0 && xslfofileName != null && xslfofileName.length() > 0 && pdffileName != null && pdffileName.length() > 0) {
            this.fopWrite(xmlName, xslfofileName, pdffileName, mime);
        }
    }

    private void writeHTML(String xmlName, String outfileBasename) {
        if (!OutputFormat.toLowerCase().contains("html")) {
            return;
        }
        String htmlfileName = outfileBasename + ".html";
        if (OutputFormat.toLowerCase().contains("framehtml")) {
            File outputDir;
            block17: {
                String logoFileName;
                StatusBoard.getStatusBoard().statusChanged(26);
                this.transformationParameters.put("outputdir", outfileBasename);
                File outDir = new File(outputDirectory);
                File xmlFile = new File(outDir, xmlName);
                this.transformationParameters.put("catalogXmlPath", xmlFile.toURI().toString());
                outputDir = new File(outDir, outfileBasename);
                if (!outputDir.exists()) {
                    try {
                        FileUtils.forceMkdir((File)outputDir);
                    }
                    catch (IOException ioex) {
                        this.result.addError(this, 31, outputDir.getAbsolutePath());
                    }
                }
                if (logoFilePath != null && (logoFileName = this.readAndStoreLogo(outputDir, outfileBasename)) != null) {
                    this.transformationParameters.put("logoFileName", logoFileName);
                }
                if (xmlName != null && xmlName.length() > 0 && xslframeHtmlFileName != null && xslframeHtmlFileName.length() > 0) {
                    this.xsltWrite(xmlName, xslframeHtmlFileName, htmlfileName);
                }
                File cssDestination = new File(outputDir, cssFileName);
                try {
                    Serializable css;
                    if (cssPath.toLowerCase().startsWith("http")) {
                        css = new URL(cssPath + "/" + cssFileName);
                        FileUtils.copyURLToFile((URL)css, (File)cssDestination);
                        break block17;
                    }
                    css = new File(cssPath + "/" + cssFileName);
                    if (((File)css).exists()) {
                        FileUtils.copyFile((File)css, (File)cssDestination);
                        break block17;
                    }
                    this.result.addError(this, 18, ((File)css).getAbsolutePath());
                    return;
                }
                catch (Exception e) {
                    this.result.addWarning(this, 16, cssFileName, cssPath, outputDir.getAbsolutePath());
                }
            }
            if (includeDiagrams) {
                File tmpImgDir = this.options.imageTmpDir();
                try {
                    FileUtils.copyDirectoryToDirectory((File)tmpImgDir, (File)outputDir);
                }
                catch (IOException e) {
                    this.result.addError(this, 28, tmpImgDir.getAbsolutePath(), outputDir.getAbsolutePath(), e.getMessage());
                }
            }
        } else {
            String logoFileName;
            StatusBoard.getStatusBoard().statusChanged(23);
            File outDir = new File(outputDirectory);
            if (logoFilePath != null && (logoFileName = this.readAndStoreLogo(outDir, outfileBasename)) != null) {
                this.transformationParameters.put("logoFileName", logoFileName);
            }
            if (xmlName != null && xmlName.length() > 0 && xslhtmlfileName != null && xslhtmlfileName.length() > 0 && htmlfileName != null && htmlfileName.length() > 0) {
                this.xsltWrite(xmlName, xslhtmlfileName, htmlfileName);
            }
        }
    }

    private String readAndStoreLogo(File outputDir, String outfileBasename) {
        String logoFileName = outfileBasename + "_logo.png";
        File logoFile = new File(outputDir, logoFileName);
        try {
            BufferedImage img = null;
            if (logoFilePath.toLowerCase().startsWith("http")) {
                URL logoUrl = new URL(logoFilePath);
                img = ImageIO.read(logoUrl);
            } else {
                File localLogoFile = new File(logoFilePath);
                img = ImageIO.read(localLogoFile);
            }
            ImageIO.write((RenderedImage)img, "png", logoFile);
            return logoFileName;
        }
        catch (Exception e) {
            this.result.addError(this, 30, logoFilePath, e.getMessage());
            return null;
        }
    }

    private void writeDOCX(String xmlName, String outfileBasename) {
        if (!OutputFormat.toLowerCase().contains("docx")) {
            return;
        }
        StatusBoard.getStatusBoard().statusChanged(27);
        ZipHandler zipHandler = new ZipHandler();
        String docxfileName = outfileBasename + ".docx";
        try {
            File outDir = new File(outputDirectory);
            File tmpDir = new File(outDir, "tmpdocx");
            File tmpinputDir = new File(tmpDir, "input");
            File tmpoutputDir = new File(tmpDir, "output");
            File docxtemplate_copy = new File(tmpDir, "docxtemplatecopy.tmp");
            if (docxTemplateFilePath.toLowerCase().startsWith("http")) {
                URL templateUrl = new URL(docxTemplateFilePath);
                FileUtils.copyURLToFile((URL)templateUrl, (File)docxtemplate_copy);
            } else {
                File docxtemplate = new File(docxTemplateFilePath);
                if (docxtemplate.exists()) {
                    FileUtils.copyFile((File)docxtemplate, (File)docxtemplate_copy);
                } else {
                    this.result.addError(this, 19, docxtemplate.getAbsolutePath());
                    return;
                }
            }
            zipHandler.unzip(docxtemplate_copy, tmpinputDir);
            zipHandler.unzip(docxtemplate_copy, tmpoutputDir);
            File styleXmlFile = new File(tmpinputDir, "word/styles.xml");
            if (!styleXmlFile.canRead()) {
                this.result.addError(null, 301, styleXmlFile.getName(), "styles.xml");
                return;
            }
            File xmlFile = new File(outDir, xmlName);
            if (!xmlFile.canRead()) {
                this.result.addError(null, 301, xmlFile.getName(), xmlName);
                return;
            }
            File indocumentxmlFile = new File(tmpinputDir, "word/document.xml");
            if (!indocumentxmlFile.canRead()) {
                this.result.addError(null, 301, indocumentxmlFile.getName(), "document.xml");
                return;
            }
            File outdocumentxmlFile = new File(tmpoutputDir, "word/document.xml");
            if (!outdocumentxmlFile.canWrite()) {
                this.result.addError(null, 307, outdocumentxmlFile.getName(), "document.xml");
                return;
            }
            this.transformationParameters.put("styleXmlPath", styleXmlFile.toURI().toString());
            this.transformationParameters.put("catalogXmlPath", xmlFile.toURI().toString());
            this.transformationParameters.put("DOCX_PLACEHOLDER", DOCX_PLACEHOLDER);
            this.transformationParameters.put(PARAM_DOCX_STYLE, docxStyle);
            this.xsltWrite(indocumentxmlFile, xsldocxfileName, outdocumentxmlFile);
            if (includeDiagrams && !imageList.isEmpty()) {
                File mediaDir = new File(tmpoutputDir, "word/media");
                FileUtils.copyDirectoryToDirectory((File)this.options.imageTmpDir(), (File)mediaDir);
                Document imgInfoDoc = this.createDocument();
                imgInfoDoc.appendChild(imgInfoDoc.createComment("Temporary file containing image metadata"));
                Element imgInfoRoot = imgInfoDoc.createElement("images");
                imgInfoDoc.appendChild(imgInfoRoot);
                this.addAttribute(imgInfoDoc, imgInfoRoot, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                for (ImageMetadata im : imageList) {
                    Element e1 = imgInfoDoc.createElement("image");
                    this.addAttribute(imgInfoDoc, e1, "id", im.getId());
                    this.addAttribute(imgInfoDoc, e1, "relPath", im.getRelPathToFile());
                    imgInfoRoot.appendChild(e1);
                }
                Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
                outputFormat.setProperty("indent", "yes");
                outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
                if (encoding != null) {
                    outputFormat.setProperty("encoding", encoding);
                }
                File relsFile = new File(tmpDir, "docx_relationships.tmp.xml");
                try {
                    FileOutputStream fout = new FileOutputStream(relsFile);
                    BufferedOutputStream bout = new BufferedOutputStream(fout);
                    OutputStreamWriter outputXML = new OutputStreamWriter((OutputStream)bout, outputFormat.getProperty("encoding"));
                    Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
                    serializer.setWriter((Writer)outputXML);
                    serializer.asDOMSerializer().serialize((Node)imgInfoDoc);
                    outputXML.close();
                }
                catch (Exception e) {
                    String m = e.getMessage();
                    if (m != null) {
                        this.result.addError(m);
                    }
                    e.printStackTrace(System.err);
                }
                File inRelsXmlFile = new File(tmpinputDir, "word/_rels/document.xml.rels");
                if (!inRelsXmlFile.canRead()) {
                    this.result.addError(null, 301, inRelsXmlFile.getName(), "document.xml.rels");
                    return;
                }
                File outRelsXmlFile = new File(tmpoutputDir, "word/_rels/document.xml.rels");
                if (!outRelsXmlFile.canWrite()) {
                    this.result.addError(null, 307, outRelsXmlFile.getName(), "document.xml.rels");
                    return;
                }
                this.transformationParameters.put("imageInfoXmlPath", relsFile.toURI().toString());
                this.xsltWrite(inRelsXmlFile, xsldocxrelsfileName, outRelsXmlFile);
                File inContentTypesXmlFile = new File(tmpinputDir, "[Content_Types].xml");
                if (!inContentTypesXmlFile.canRead()) {
                    this.result.addError(null, 301, inContentTypesXmlFile.getName(), "[Content_Types].xml");
                    return;
                }
                File outContentTypesXmlFile = new File(tmpoutputDir, "[Content_Types].xml");
                if (!outContentTypesXmlFile.canWrite()) {
                    this.result.addError(null, 307, outContentTypesXmlFile.getName(), "[Content_Types].xml");
                    return;
                }
                this.xsltWrite(inContentTypesXmlFile, xsldocxContentTypesFileName, outContentTypesXmlFile);
            }
            File outFile = new File(outDir, docxfileName);
            zipHandler.zip(tmpoutputDir, outFile);
            try {
                FileUtils.deleteDirectory((File)tmpDir);
            }
            catch (IOException e) {
                this.result.addWarning(this, 20, e.getMessage());
            }
            this.result.addResult(this.getTargetName(), outputDirectory, docxfileName, null);
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
    }

    private void writeRTF(String xmlName, String outfileBasename) {
        if (!OutputFormat.toLowerCase().contains("rtf")) {
            return;
        }
        StatusBoard.getStatusBoard().statusChanged(25);
        String rtffileName = outfileBasename + ".rtf";
        if (xmlName != null && xmlName.length() > 0 && xslrtffileName != null && xslrtffileName.length() > 0 && rtffileName != null && rtffileName.length() > 0) {
            this.xsltWrite(xmlName, xslrtffileName, rtffileName);
        }
    }

    private void writeXML(String xmlName, String outfileBasename) {
        if (!OutputFormat.toLowerCase().contains("xml")) {
            return;
        }
        StatusBoard.getStatusBoard().statusChanged(24);
        String xmloutFileName = outfileBasename + ".xml";
        if (xmlName != null && xmlName.length() > 0 && xslxmlfileName != null && xslxmlfileName.length() > 0 && xmloutFileName != null && xmloutFileName.length() > 0) {
            this.xsltWrite(xmlName, xslxmlfileName, xmloutFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fopWrite(String xmlName, String xslfofileName, String outfileName, String outputMimetype) {
        block14: {
            Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
            outputFormat.setProperty("indent", "yes");
            outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            outputFormat.setProperty("encoding", encoding);
            Logger fl = Logger.getLogger("org.apache.fop");
            fl.setLevel(Level.WARNING);
            FopMsgHandler fmh = new FopMsgHandler(this.result, this);
            fl.addHandler(fmh);
            try {
                FopFactory fopFactory = FopFactory.newInstance((URI)new File(".").toURI());
                FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
                boolean skip = false;
                File outDir = new File(outputDirectory);
                File xmlFile = new File(outDir, xmlName);
                File xsltFile = new File(xsltPath, xslfofileName);
                File outFile = new File(outDir, outfileName);
                if (!xmlFile.canRead()) {
                    this.result.addError(null, 301, xmlFile.getName(), outfileName);
                    skip = true;
                }
                if (!xsltFile.canRead()) {
                    this.result.addError(null, 301, xsltFile.getName(), outfileName);
                    skip = true;
                }
                if (skip) break block14;
                OutputStream out = null;
                try {
                    out = new FileOutputStream(outFile);
                    out = new BufferedOutputStream(out);
                }
                catch (Exception e) {
                    this.result.addError(null, 304, outFile.getName(), e.getMessage());
                    skip = true;
                }
                if (skip) break block14;
                try {
                    Fop fop = fopFactory.newFop("application/pdf", foUserAgent, out);
                    if (xslTransformerFactory != null) {
                        System.setProperty("javax.xml.transform.TransformerFactory", xslTransformerFactory);
                    }
                    TransformerFactory factory = TransformerFactory.newInstance();
                    Transformer transformer = factory.newTransformer(new StreamSource(xsltFile));
                    FopErrorListener el = new FopErrorListener(xmlFile.getName(), this.result, this);
                    transformer.setErrorListener(el);
                    transformer.setParameter("versionParam", "2.0");
                    StreamSource src = new StreamSource(xmlFile);
                    SAXResult res = new SAXResult(fop.getDefaultHandler());
                    transformer.transform(src, res);
                }
                catch (Exception e) {
                    this.result.addError(null, 304, outfileName, e.getMessage());
                    skip = true;
                }
                finally {
                    out.close();
                    this.result.addResult(this.getTargetName(), outputDirectory, outfileName, null);
                    if (deleteXmlFile) {
                        xmlFile.delete();
                    }
                }
            }
            catch (Exception e) {
                String m = e.getMessage();
                if (m != null) {
                    this.result.addError(m);
                }
                e.printStackTrace(System.err);
            }
        }
    }

    public void xsltWrite(String xmlName, String xsltfileName, String outfileName) {
        File outDir = new File(outputDirectory);
        File transformationTargetFile = new File(outDir, outfileName);
        File transformationSourceFile = new File(outDir, xmlName);
        if (!transformationSourceFile.canRead()) {
            this.result.addError(null, 301, transformationSourceFile.getAbsolutePath(), transformationTargetFile.getAbsolutePath());
            return;
        }
        this.xsltWrite(transformationSourceFile, xsltfileName, transformationTargetFile);
        if (transformationTargetFile.exists() && transformationTargetFile.length() == 0L) {
            FileUtils.deleteQuietly((File)transformationTargetFile);
            this.result.addDebug(this, 32, transformationTargetFile.getAbsolutePath());
        }
    }

    public void xsltWrite(File transformationSource, String xsltfileName, File transformationTarget) {
        try {
            URI xsltMainFileUri = null;
            if (xsltPath.toLowerCase().startsWith("http")) {
                URL url = new URL(xsltPath + "/" + xsltfileName);
                xsltMainFileUri = url.toURI();
            } else {
                File xsl = new File(xsltPath + "/" + xsltfileName);
                if (xsl.exists()) {
                    xsltMainFileUri = xsl.toURI();
                } else {
                    this.result.addError(this, 18, xsl.getAbsolutePath());
                    return;
                }
            }
            if (pathToJavaExe == null) {
                XsltWriter writer = new XsltWriter(xslTransformerFactory, this.hrefMappings, this.transformationParameters, this.result);
                writer.xsltWrite(transformationSource, xsltMainFileUri, transformationTarget);
            } else {
                ArrayList<String> cmds = new ArrayList<String>();
                cmds.add(pathToJavaExe);
                if (javaOptions != null) {
                    cmds.add(javaOptions);
                }
                cmds.add("-cp");
                ArrayList<String> cpEntries = new ArrayList<String>();
                ClassGraph cg = new ClassGraph();
                List cpUrls = cg.getClasspathURLs();
                for (URL u : cpUrls) {
                    String path = FileUtils.toFile((URL)u).getAbsolutePath();
                    cpEntries.add(path);
                }
                String cpValue = StringUtils.join(cpEntries, (String)System.getProperty("path.separator"));
                cmds.add("\"" + cpValue + "\"");
                cmds.add(XsltWriter.class.getName());
                if (!this.hrefMappings.isEmpty()) {
                    ArrayList<BasicNameValuePair> hrefMappingsList = new ArrayList<BasicNameValuePair>();
                    for (Map.Entry entry : this.hrefMappings.entrySet()) {
                        hrefMappingsList.add(new BasicNameValuePair((String)entry.getKey(), ((URI)entry.getValue()).toString()));
                    }
                    String hrefMappingsString = URLEncodedUtils.format(hrefMappingsList, (Charset)XsltWriter.ENCODING_CHARSET);
                    cmds.add("-hrefMappings");
                    cmds.add("\"" + (String)hrefMappingsString + "\"");
                }
                if (!this.transformationParameters.isEmpty()) {
                    ArrayList<BasicNameValuePair> transformationParametersList = new ArrayList<BasicNameValuePair>();
                    for (Map.Entry entry : this.transformationParameters.entrySet()) {
                        transformationParametersList.add(new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
                    }
                    String transformationParametersString = URLEncodedUtils.format(transformationParametersList, (Charset)XsltWriter.ENCODING_CHARSET);
                    cmds.add("-transformationParameters");
                    cmds.add("\"" + transformationParametersString + "\"");
                }
                if (xslTransformerFactory != null) {
                    cmds.add("-xslTransformerFactory");
                    cmds.add(xslTransformerFactory);
                }
                String transformationSourcePath = transformationSource.getPath();
                String xsltMainFileUriString = xsltMainFileUri.toString();
                String string = transformationTarget.getPath();
                cmds.add("-transformationSourcePath");
                cmds.add("\"" + transformationSourcePath + "\"");
                cmds.add("-transformationTargetPath");
                cmds.add("\"" + string + "\"");
                cmds.add("-xsltMainFileUri");
                cmds.add("\"" + xsltMainFileUriString + "\"");
                this.result.addInfo(this, 26, StringUtils.join(cmds, (String)" "));
                ProcessBuilder pb = new ProcessBuilder(cmds);
                try {
                    Process proc = pb.start();
                    StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream());
                    StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream());
                    errorGobbler.start();
                    outputGobbler.start();
                    errorGobbler.join();
                    outputGobbler.join();
                    int exitVal = proc.waitFor();
                    if (outputGobbler.hasResult()) {
                        this.result.addInfo(this, 25, outputGobbler.getResult());
                    }
                    if (exitVal != 0 || errorGobbler.hasResult()) {
                        if (errorGobbler.hasResult()) {
                            this.result.addError(this, 23, errorGobbler.getResult(), "" + exitVal);
                        } else {
                            this.result.addError(this, 24, "" + exitVal);
                        }
                    }
                }
                catch (InterruptedException e) {
                    this.result.addFatalError(this, 22);
                    throw new ShapeChangeAbortException();
                }
            }
            if (!OutputFormat.toLowerCase().contains("docx")) {
                if (OutputFormat.toLowerCase().contains("framehtml")) {
                    String outputDir = outputDirectory + "/" + outputFilename;
                    this.result.addResult(this.getTargetName(), outputDir, "index.html", null);
                } else {
                    this.result.addResult(this.getTargetName(), outputDirectory, transformationTarget.getName(), null);
                }
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
    }

    @Override
    public String message(int mnr) {
        String mess = this.messageText(mnr);
        if (mess == null) {
            return null;
        }
        String prefix = "";
        if (mess.startsWith("??")) {
            prefix = "??";
            mess = mess.substring(2);
        }
        return prefix + "Feature Catalogue Target: " + mess;
    }

    @Override
    public void writeOutput() {
        if (dontTransform) {
            return;
        }
        String xmlName = outputFilename + ".tmp.xml";
        this.writePDF(xmlName, outputFilename);
        this.writeHTML(xmlName, outputFilename);
        this.writeXML(xmlName, outputFilename);
        this.writeRTF(xmlName, outputFilename);
        this.writeDOCX(xmlName, outputFilename);
    }

    @Override
    public void initialise(Options o, ShapeChangeResult r) throws ShapeChangeAbortException {
        this.options = o;
        this.result = r;
        this.initialiseFromOptions();
        this.initialiseTransformationParameters();
        File outDir = new File(outputDirectory);
        String xmlName = outputFilename + ".tmp.xml";
        File tmpXmlFile = new File(outDir, xmlName);
        try {
            InputSource tmpXmlSource = new InputSource(new FileInputStream(tmpXmlFile));
            SAXParserFactory pfactory = SAXParserFactory.newInstance();
            pfactory.setNamespaceAware(true);
            pfactory.setValidating(false);
            SAXParser parser = pfactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            ImageMetadataContentHandler imgContentHandler = new ImageMetadataContentHandler();
            reader.setContentHandler(imgContentHandler);
            reader.parse(tmpXmlSource);
            imageList = imgContentHandler.getImages();
        }
        catch (Exception e) {
            this.result.addFatalError(this, 14, tmpXmlFile.getAbsolutePath(), e.getMessage());
            throw new ShapeChangeAbortException();
        }
    }

    private void initialiseTransformationParameters() {
        this.transformationParameters.put("featureTypeSynonym", featureTerm + " Type");
        this.transformationParameters.put(PARAM_LANG, lang);
        this.transformationParameters.put(PARAM_NO_ALPHABETIC_SORT_OF_PROPS, noAlphabeticSortingForProperties);
        this.transformationParameters.put(PARAM_INCLUDE_CODELISTS_AND_ENUMERATIONS, includeCodelistsAndEnumerations);
    }

    private void initialiseFromOptions() {
        String pathToJavaExe_;
        File f;
        String docxStyleParamValue;
        outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
        if (outputDirectory == null) {
            outputDirectory = this.options.parameter("outputDirectory");
        }
        if (outputDirectory == null) {
            outputDirectory = ".";
        }
        if ((outputFilename = this.options.parameter(this.getClass().getName(), "outputFilename")) == null) {
            outputFilename = "FeatureCatalogue";
        }
        if ((docxTemplateFilePath = this.options.parameter(this.getClass().getName(), PARAM_DOCX_TEMPLATE_FILE_PATH)) == null) {
            docxTemplateFilePath = this.options.parameter(PARAM_DOCX_TEMPLATE_FILE_PATH);
        }
        if (docxTemplateFilePath == null) {
            docxTemplateFilePath = DOCX_TEMPLATE_URL;
            this.result.addDebug(this, 17, PARAM_DOCX_TEMPLATE_FILE_PATH, DOCX_TEMPLATE_URL);
        }
        if ((docxStyleParamValue = this.options.parameter(this.getClass().getName(), PARAM_DOCX_STYLE)) != null) {
            docxStyle = docxStyleParamValue;
        }
        logoFilePath = this.options.parameter(this.getClass().getName(), PARAM_LOGO_FILE_PATH);
        String s = this.options.parameter(this.getClass().getName(), PARAM_INHERITED_CONSTRAINTS);
        if (s != null && s.equalsIgnoreCase("false")) {
            inheritedConstraints = false;
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_INHERITED_PROPERTIES)) != null && s.equalsIgnoreCase("true")) {
            inheritedProperties = true;
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_DELETE_XML_FILE)) != null && s.equalsIgnoreCase("true")) {
            deleteXmlFile = true;
        }
        Package = (s = this.options.parameter(this.getClass().getName(), PARAM_PACKAGE)) != null && s.length() > 0 ? s : "";
        s = this.options.parameter(this.getClass().getName(), PARAM_OUTPUT_FORMAT);
        OutputFormat = s != null && s.length() > 0 ? s : "";
        s = this.options.parameter(this.getClass().getName(), PARAM_FEATURE_TERM);
        if (s != null && s.length() > 0) {
            featureTerm = s;
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_INCLUDE_DIAGRAMS)) != null && s.equalsIgnoreCase("true")) {
            includeDiagrams = true;
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_DONT_TRANSFORM)) != null && s.equalsIgnoreCase("true")) {
            dontTransform = true;
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_INCLUDE_CODELIST_URI)) != null && s.equalsIgnoreCase("false")) {
            includeCodelistURI = false;
        }
        representTaggedValues = this.options.parameter("representTaggedValues");
        s = this.options.parameter(this.getClass().getName(), PARAM_INCLUDE_VOIDABLE);
        if (s != null && s.equalsIgnoreCase("false")) {
            includeVoidable = false;
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_INCLUDE_ALIAS)) != null) {
            if (s.equalsIgnoreCase("false")) {
                includeTitle = false;
            }
        } else {
            s = this.options.parameter(this.getClass().getName(), PARAM_INCLUDE_TITLE);
            if (s != null && s.equalsIgnoreCase("false")) {
                includeTitle = false;
            }
        }
        if (this.model != null) {
            encoding = this.model.characterEncoding();
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_XSL_TRANSFORMER_FACTORY)) != null && s.length() > 0) {
            xslTransformerFactory = s;
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_XSL_HTML_FILE)) != null && s.length() > 0) {
            xslhtmlfileName = s;
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_XSL_FRAME_HTML_FILENAME)) != null && s.length() > 0) {
            xslframeHtmlFileName = s;
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_XSL_FO_FILE)) != null && s.length() > 0) {
            xslfofileName = s;
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_XSL_RTF_FILE)) != null && s.length() > 0) {
            xslrtffileName = s;
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_XSL_DOCX_FILE)) != null && s.length() > 0) {
            xsldocxfileName = s;
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_XSL_XML_FILE)) != null && s.length() > 0) {
            xslxmlfileName = s;
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_XSLT_PFAD)) != null && s.length() > 0) {
            xsltPath = s;
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_XSLT_PATH)) != null && s.length() > 0) {
            xsltPath = s;
        }
        cssPath = (s = this.options.parameter(this.getClass().getName(), PARAM_CSS_PATH)) != null && s.length() > 0 ? s : xsltPath;
        s = this.options.parameter(this.getClass().getName(), PARAM_LANG);
        if (s != null && s.length() > 0) {
            lang = s;
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_NO_ALPHABETIC_SORT_OF_PROPS)) != null && s.equalsIgnoreCase("true")) {
            noAlphabeticSortingForProperties = "true";
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_INCLUDE_CODELISTS_AND_ENUMERATIONS)) != null && s.equalsIgnoreCase("true")) {
            includeCodelistsAndEnumerations = "true";
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_XSL_LOCALIZATION_URI)) != null && s.length() > 0) {
            try {
                URI locXslUri;
                if (s.startsWith("http")) {
                    locXslUri = new URI(s);
                } else {
                    locXslUri = new URI(s);
                    if (!locXslUri.isAbsolute()) {
                        f = new File(s);
                        locXslUri = f.toURI();
                    }
                }
                this.hrefMappings.put(localizationXslDefaultUri, locXslUri);
            }
            catch (URISyntaxException e) {
                this.result.addError(this, 15, PARAM_XSL_LOCALIZATION_URI, s, e.toString());
            }
        }
        if ((s = this.options.parameter(this.getClass().getName(), PARAM_LOCALIZATION_MESSAGES_URI)) != null && s.length() > 0) {
            try {
                URI locMsgUri;
                if (s.startsWith("http")) {
                    locMsgUri = new URI(s);
                } else {
                    locMsgUri = new URI(s);
                    if (!locMsgUri.isAbsolute()) {
                        f = new File(s);
                        locMsgUri = f.toURI();
                    }
                }
                this.hrefMappings.put(localizationMessagesDefaultUri, locMsgUri);
            }
            catch (URISyntaxException e) {
                this.result.addError(this, 15, PARAM_LOCALIZATION_MESSAGES_URI, s, e.toString());
            }
        }
        if ((pathToJavaExe_ = this.options.parameter(this.getClass().getName(), PARAM_JAVA_EXE_PATH)) != null && pathToJavaExe_.trim().length() > 0) {
            String jo_tmp;
            pathToJavaExe = pathToJavaExe_.trim();
            if (!pathToJavaExe.startsWith("\"")) {
                pathToJavaExe = "\"" + pathToJavaExe;
            }
            if (!pathToJavaExe.endsWith("\"")) {
                pathToJavaExe = pathToJavaExe + "\"";
            }
            if ((jo_tmp = this.options.parameter(this.getClass().getName(), PARAM_JAVA_OPTIONS)) != null && jo_tmp.trim().length() > 0) {
                javaOptions = jo_tmp.trim();
            }
        }
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
    }

    @Override
    public String getTargetIdentifier() {
        return "fc";
    }

    @Override
    public String getDefaultEncodingRule() {
        return "*";
    }

    protected String messageText(int mnr) {
        switch (mnr) {
            case 12: {
                return "Directory named '$1$' does not exist or is not accessible.";
            }
            case 13: {
                return "File '$1$' does not exist or is not accessible.";
            }
            case 14: {
                return "Could not parse image metadata from temporary XML file at '$1$'. Aborting now. Exception message was: $2$";
            }
            case 15: {
                return "URI syntax exception for configuration parameter '$1$'. Value was: '$2$'. Using default URI stated in XSLT. Exception message: $3$";
            }
            case 16: {
                return "Could not copy stylesheet '$1$' from '$2$' to '$3$'.";
            }
            case 17: {
                return "No value provided for configuration parameter '$1$', defaulting to: '$2$'.";
            }
            case 18: {
                return "XSLT stylesheet $1$ not found.";
            }
            case 19: {
                return "DOCX template $1$ not found.";
            }
            case 20: {
                return "Could not delete temporary directory created for docx transformation; IOException message is: $1$";
            }
            case 21: {
                return "Invalid command for invocation of external java executable. Return code was: $2$. Command was: $1$";
            }
            case 22: {
                return "Interruption exception during execution of external java executable.";
            }
            case 23: {
                return "Execution of XSLT write with external java executable did not succeed (return code was '$2$'). Error message is: $1$.";
            }
            case 24: {
                return "Execution of XSLT write with external java executable did not succeed (return code was '$2$'). No error message was provided.";
            }
            case 25: {
                return "Execution of XSLT write with external java executable produced the following log message(s): $1$";
            }
            case 26: {
                return "Invoking external JRE with command: $1$";
            }
            case 27: {
                return "Message from external java executable: $1$";
            }
            case 28: {
                return "Exception occurred when copying content from temporary image directory at '$1$' to directory '$2$'. Message is: $3$.";
            }
            case 30: {
                return "Exception occurred while trying to read and store logo file from '$1$'. Exception message is: $2$";
            }
            case 31: {
                return "Directory '$1$' could not be created.";
            }
            case 32: {
                return "Removed empty XSLT transformation target file at $1$.";
            }
            case 308: {
                return "No schema with name '$1$' found in the reference model. Consequently, no diff was performed.";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }

    static {
        cssPath = xsltPath = "http://shapechange.net/resources/xslt";
        lang = "en";
        featureTerm = "Feature";
        noAlphabeticSortingForProperties = "false";
        includeCodelistsAndEnumerations = "false";
        includeVoidable = true;
        includeTitle = true;
        includeCodelistURI = true;
        deleteXmlFile = false;
        representTaggedValues = null;
        includeDiagrams = false;
        imgIntegerIdCounter = 0;
        imgIntegerIdStepwidth = 2;
        imageList = new ArrayList<ImageMetadata>();
        dontTransform = false;
        pathToJavaExe = null;
        javaOptions = null;
        encounteredAppSchemasByName = null;
    }
}

