/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.FOL2Schematron;

import de.interactive_instruments.ShapeChange.AIXMSchemaInfos;
import de.interactive_instruments.ShapeChange.FOL.Literal;
import de.interactive_instruments.ShapeChange.FOL.PropertyCall;
import de.interactive_instruments.ShapeChange.FOL.Quantification;
import de.interactive_instruments.ShapeChange.FOL.Quantifier;
import de.interactive_instruments.ShapeChange.FOL.RealLiteral;
import de.interactive_instruments.ShapeChange.FOL.StringLiteral;
import de.interactive_instruments.ShapeChange.FOL.StringLiteralList;
import de.interactive_instruments.ShapeChange.FOL.Variable;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Target.FOL2Schematron.FOL2Schematron;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema;
import de.interactive_instruments.ShapeChange.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public abstract class FolSchematronNode {
    public static final int SIMPLE_TYPE = 0;
    public static final int INLINE = 1;
    public static final int BY_REFERENCE = 2;
    public static final int INLINE_OR_BY_REFERENCE = 3;
    private static final String COUNTING_VARIABLE_NAME = "$c";
    protected ArrayList<FolSchematronNode> children = new ArrayList();
    protected FolSchematronNode parent = null;
    protected FOL2Schematron schemaObject = null;

    public void addChild(FolSchematronNode child) {
        this.children.add(child);
        child.parent = this;
    }

    public boolean isAndOrLogic(boolean isAnd) {
        return false;
    }

    public boolean isDependentOn(Variable vardecl) {
        for (FolSchematronNode scn : this.children) {
            if (!scn.isDependentOn(vardecl)) continue;
            return true;
        }
        return false;
    }

    public FolSchematronNode nodeVariableIsBoundTo(Variable vardecl) {
        return null;
    }

    public XpathFragment objValueFromVariable(Variable var) {
        String alpha = this.schemaObject.alpha;
        String beta = this.schemaObject.beta;
        boolean alphaEx = alpha != null && alpha.length() > 0;
        boolean betaEx = beta != null && beta.length() > 0;
        XpathFragment obj = null;
        if (var.isSelf()) {
            obj = new XpathFragment(0, "current()");
        } else {
            PropertyInfo piFromLastPC;
            obj = new XpathFragment(0, "$" + var.getName());
            PropertyCall lastPC = var.lastPropertyCallInEffectiveValue();
            if (lastPC != null && !this.hasSimpleType(piFromLastPC = lastPC.getSchemaElement())) {
                String ref = piFromLastPC.inlineOrByReference();
                int conCode = ref.equalsIgnoreCase("byreference") ? 2 : (ref.equalsIgnoreCase("inline") ? 1 : 3);
                Object frag_inl = null;
                Object frag_ref = null;
                if (conCode == 1 || conCode == 3) {
                    frag_inl = obj.fragment;
                    frag_inl = (String)frag_inl + "/*";
                }
                if (conCode == 2 || conCode == 3) {
                    Object attxlink = obj.fragment;
                    attxlink = (String)attxlink + "/@xlink:href";
                    frag_ref = "//*[";
                    if (alphaEx || betaEx) {
                        frag_ref = (String)frag_ref + "concat(";
                        if (alphaEx) {
                            frag_ref = (String)frag_ref + "'" + alpha + "',";
                        }
                        frag_ref = (String)frag_ref + "@gml:id";
                        if (betaEx) {
                            frag_ref = (String)frag_ref + ",'" + beta + "'";
                        }
                        frag_ref = (String)frag_ref + ")";
                    } else {
                        frag_ref = (String)frag_ref + "@gml:id";
                    }
                    frag_ref = (String)frag_ref + "=" + (String)attxlink + "]";
                    this.schemaObject.registerNamespace("xlink");
                    this.schemaObject.registerNamespace("gml");
                    if (obj.atEnd != null) {
                        obj.atEnd.setState(BindingContext.CtxState.OTHER);
                    }
                }
                if (conCode == 3) {
                    obj.fragment = (String)frag_inl + " | " + (String)frag_ref;
                    obj.priority = 8;
                } else if (conCode == 1) {
                    obj.fragment = frag_inl;
                    obj.priority = 9;
                } else {
                    obj.fragment = frag_ref;
                    obj.priority = 10;
                }
            }
        }
        return obj;
    }

    public boolean isVarOrAttribBased(Variable vardecl) {
        return false;
    }

    public AttributeNode generatingAttribute() {
        return null;
    }

    public boolean isMultiple() {
        return false;
    }

    public boolean hasSimpleType() {
        return true;
    }

    public boolean hasSimpleType(PropertyInfo pi) {
        boolean result = true;
        ClassInfo ci = FolSchematronNode.getTypeClassInfo(pi);
        if (ci != null) {
            Boolean indicatorSimpleType = XmlSchema.indicatorForObjectElementWithSimpleContent(ci);
            result = !XmlSchema.classHasObjectElement(ci) || indicatorSimpleType != null && indicatorSimpleType != false;
        }
        return result;
    }

    public boolean hasIdentity() {
        return false;
    }

    public boolean isAIXMExtension(Info i) {
        AIXMSchemaInfos.AIXMSchemaInfo si;
        if (this.schemaObject.options.getAIXMSchemaInfos() != null && (si = this.schemaObject.options.getAIXMSchemaInfos().get(i.id())) != null) {
            return si.isExtension();
        }
        return false;
    }

    public boolean containsError() {
        if (this instanceof Error) {
            return true;
        }
        for (FolSchematronNode node : this.children) {
            if (!node.containsError()) continue;
            return true;
        }
        return false;
    }

    public abstract XpathFragment translate(BindingContext var1);

    private static ClassInfo getTypeClassInfo(PropertyInfo pi) {
        if (pi == null) {
            return null;
        }
        Model m = pi.model();
        return m.classById(pi.typeInfo().id);
    }

    public static class MessageComment
    extends FolSchematronNode {
        protected String name = null;

        public MessageComment(FOL2Schematron schemaObject, String name) {
            this.schemaObject = schemaObject;
            this.name = name;
        }

        public String getErrorNumber() {
            return this.name.substring(6);
        }

        public String[] compileAsMessageArgumentList() {
            String[] arglist = new String[this.children.size()];
            int i = 0;
            for (FolSchematronNode arg : this.children) {
                XpathFragment sql = arg.translate(null);
                arglist[i++] = sql.fragment == null ? "*ERROR*" : sql.fragment;
            }
            return arglist;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            return null;
        }
    }

    public static class Error
    extends FolSchematronNode {
        public Error(FOL2Schematron schemaObject) {
            this.schemaObject = schemaObject;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            return null;
        }
    }

    public static class QuantificationNode
    extends FolSchematronNode {
        Quantification q;
        private VariableNode variableNode;
        private FolSchematronNode condition;

        public QuantificationNode(FOL2Schematron schemaObject, Quantification q) {
            this.schemaObject = schemaObject;
            this.q = q;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathFragment xptvarvalue = this.variableNode.value().translate(ctx);
            XpathFragment prd = this.condition().translate(ctx);
            Quantifier quan = this.q.getQuantifier();
            XpathFragment xpt = new XpathFragment(0, "", XpathType.BOOLEAN);
            if (quan.isUniversal()) {
                xpt.fragment = xpt.fragment + "every $" + this.q.getVar().getName() + " in " + xptvarvalue.fragment + " satisfies (" + prd.fragment + ")";
            } else {
                int cvIndex = this.schemaObject.getNextVarIndex();
                xpt.fragment = xpt.fragment + "for $c" + cvIndex + " in count(for $" + this.q.getVar().getName() + " in " + xptvarvalue.fragment + " return if (" + prd.fragment + ") then 1 else ()) return (";
                xpt.fragment = quan.getLowerBoundary() != null && quan.getUpperBoundary() != null ? (quan.getLowerBoundary().intValue() == quan.getUpperBoundary().intValue() ? xpt.fragment + FolSchematronNode.COUNTING_VARIABLE_NAME + cvIndex + " = " + quan.getLowerBoundary() : xpt.fragment + FolSchematronNode.COUNTING_VARIABLE_NAME + cvIndex + " >= " + quan.getLowerBoundary() + " and $c" + cvIndex + " <= " + quan.getUpperBoundary()) : (quan.getLowerBoundary() != null ? xpt.fragment + FolSchematronNode.COUNTING_VARIABLE_NAME + cvIndex + " >= " + quan.getLowerBoundary() : xpt.fragment + FolSchematronNode.COUNTING_VARIABLE_NAME + cvIndex + " <= " + quan.getUpperBoundary());
                xpt.fragment = xpt.fragment + ")";
            }
            return xpt;
        }

        public void setVariableNode(VariableNode vn) {
            this.variableNode = vn;
        }

        public VariableNode variableNode() {
            return this.variableNode;
        }

        public void setCondition(FolSchematronNode fsn) {
            this.condition = fsn;
        }

        public FolSchematronNode condition() {
            return this.condition;
        }
    }

    public static class LiteralNode
    extends FolSchematronNode {
        Literal literal;

        public LiteralNode(FOL2Schematron schemaObject, Literal lit) {
            this.schemaObject = schemaObject;
            this.literal = lit;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            Object value = this.literal.toString();
            XpathType type = XpathType.STRING;
            if (this.literal instanceof StringLiteral) {
                value = "'" + ((StringLiteral)this.literal).getValue() + "'";
            } else if (this.literal instanceof StringLiteralList) {
                StringLiteralList sll = (StringLiteralList)this.literal;
                List<String> values = sll.getValues();
                value = values == null || values.isEmpty() ? "()" : "('" + StringUtils.join(values, (String)"','") + "')";
            } else if (this.literal instanceof RealLiteral) {
                type = XpathType.NUMBER;
            }
            XpathFragment xpt = new XpathFragment(11, (String)value, type);
            return xpt;
        }
    }

    public static class AttributeNode
    extends FolSchematronNode {
        protected AttrComp[] attributes;
        protected VariableNode var;

        public AttributeNode(FOL2Schematron schemaObject, PropertyCall pc) {
            this.schemaObject = schemaObject;
            this.attributes = new AttrComp[]{new AttrComp(pc)};
        }

        public AttributeNode(FOL2Schematron schemaObject) {
            this.schemaObject = schemaObject;
            this.attributes = new AttrComp[0];
        }

        public AttributeNode(FOL2Schematron schemaObject, AttrComp atc) {
            this.schemaObject = schemaObject;
            this.attributes = new AttrComp[]{new AttrComp(atc)};
        }

        public void appendAttribute(PropertyCall pc) {
            AttrComp[] attribs = new AttrComp[this.attributes.length + 1];
            for (int i = 0; i < this.attributes.length; ++i) {
                attribs[i] = this.attributes[i];
            }
            attribs[this.attributes.length] = new AttrComp(pc);
            this.attributes = attribs;
        }

        public void appendAttribute(AttrComp atc) {
            AttrComp[] attribs = new AttrComp[this.attributes.length + 1];
            for (int i = 0; i < this.attributes.length; ++i) {
                attribs[i] = this.attributes[i];
            }
            attribs[this.attributes.length] = new AttrComp(atc);
            this.attributes = attribs;
        }

        public void appendAbsorbedAttribute(int absorptionType, PropertyCall pc) {
            int last = this.attributes.length - 1;
            this.attributes[last].absAttr = pc;
            this.attributes[last].absType = absorptionType;
        }

        public AttributeNode splitBefore(int at) {
            if (at < 0 || at >= this.attributes.length) {
                return null;
            }
            AttributeNode atrite = new AttributeNode(this.schemaObject, this.attributes[at]);
            for (int i = at + 1; i < this.attributes.length; ++i) {
                this.appendAttribute(this.attributes[i]);
            }
            if (at == 0) {
                atrite.addChild((FolSchematronNode)this.children.get(0));
            } else {
                AttributeNode atleft = new AttributeNode(this.schemaObject, this.attributes[0]);
                for (int i = 1; i < at; ++i) {
                    this.appendAttribute(this.attributes[i]);
                }
                atleft.addChild((FolSchematronNode)this.children.get(0));
                atrite.addChild(atleft);
            }
            return atrite;
        }

        public boolean isPropertyAbsorbing() {
            if (this.attributes.length == 0) {
                AttributeNode atnFromVar;
                if (this.var != null && (atnFromVar = this.var.generatingAttribute()) != null) {
                    return atnFromVar.isPropertyAbsorbing();
                }
            } else {
                AttrComp ac = this.attributes[this.attributes.length - 1];
                PropertyCall pc = ac.absType == 0 ? ac.main : ac.absAttr;
                PropertyInfo pi = pc.getSchemaElement();
                Type t = pi.typeInfo();
                ClassInfo ci = this.schemaObject.model.classById(t.id);
                if (ci != null && ci.isUnionDirect()) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isVarOrAttribBased(Variable vardecl) {
            return this.var.isVarOrAttribBased(vardecl);
        }

        @Override
        public AttributeNode generatingAttribute() {
            return this;
        }

        @Override
        public boolean isMultiple() {
            for (AttrComp at : this.attributes) {
                if (at.main.getSchemaElement().cardinality().maxOccurs <= 1 && (at.absType != 1 || at.absAttr.getSchemaElement().cardinality().maxOccurs <= 1)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasSimpleType() {
            int last = this.attributes.length - 1;
            return this.hasSimpleType(last);
        }

        public boolean implementedAsXmlAttribute() {
            int last = this.attributes.length - 1;
            return this.implementedAsXmlAttribute(last);
        }

        public boolean implementedAsXmlAttribute(int idx) {
            boolean result = false;
            switch (this.attributes[idx].absType) {
                case 0: {
                    result = this.implementedAsXmlAttribute(this.attributes[idx].main.getSchemaElement());
                    break;
                }
                case 1: {
                    result = this.implementedAsXmlAttribute(this.attributes[idx].absAttr.getSchemaElement());
                    break;
                }
            }
            return result;
        }

        public boolean implementedAsXmlAttribute(PropertyInfo pi) {
            boolean result = XmlSchema.implementedAsXmlAttribute(pi);
            return result;
        }

        public boolean hasSimpleType(int idx) {
            boolean result = true;
            switch (this.attributes[idx].absType) {
                case 0: {
                    result = this.hasSimpleType(this.attributes[idx].main.getSchemaElement());
                    break;
                }
                case 1: {
                    result = this.hasSimpleType(this.attributes[idx].absAttr.getSchemaElement());
                    break;
                }
            }
            return result;
        }

        @Override
        public boolean hasIdentity() {
            int last = this.attributes.length - 1;
            return this.hasIdentity(last);
        }

        public boolean hasIdentity(int idx) {
            boolean result = false;
            switch (this.attributes[idx].absType) {
                case 0: {
                    ClassInfo ci = FolSchematronNode.getTypeClassInfo(this.attributes[idx].main.getSchemaElement());
                    if (ci == null) break;
                    result = XmlSchema.classCanBeReferenced(ci);
                    break;
                }
                case 1: {
                    ClassInfo ci = FolSchematronNode.getTypeClassInfo(this.attributes[idx].absAttr.getSchemaElement());
                    if (ci == null) break;
                    result = XmlSchema.classCanBeReferenced(ci);
                    break;
                }
            }
            return result;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathFragment obj = this.objValueFromVariable(this.var.vardecl);
            String alpha = this.schemaObject.alpha;
            String beta = this.schemaObject.beta;
            boolean alphaEx = alpha != null && alpha.length() > 0;
            boolean betaEx = beta != null && beta.length() > 0;
            PropertyInfo[] props = new PropertyInfo[this.attributes.length];
            for (int i = 0; i < this.attributes.length; ++i) {
                props[i] = this.attributes[i].main.getSchemaElement();
            }
            boolean lastWasSimple = false;
            for (int idx = 0; idx < props.length; ++idx) {
                PropertyInfo pi = props[idx];
                if (XmlSchema.implementedAsXmlAttribute(pi)) {
                    if (obj.fragment.length() > 0) {
                        obj.fragment = obj.fragment + "/";
                        obj.priority = 9;
                    }
                    obj.fragment = obj.fragment + "@" + pi.name();
                    break;
                }
                if (lastWasSimple) {
                    if (!XmlSchema.implementedAsXmlAttribute(pi)) break;
                    if (obj.fragment.length() > 0) {
                        obj.fragment = obj.fragment + "/";
                        obj.priority = 9;
                    }
                    obj.fragment = obj.fragment + "@" + pi.name();
                    break;
                }
                int conCode = 0;
                String typeId = pi.typeInfo().id;
                ClassInfo ci = null;
                ClassInfo cip = null;
                if (typeId != null) {
                    cip = ci = pi.model().classById(typeId);
                }
                if (this.attributes[idx].absType == 1) {
                    ci = FolSchematronNode.getTypeClassInfo(this.attributes[idx].absAttr.getSchemaElement());
                }
                if (!this.hasSimpleType(idx)) {
                    conCode = 1;
                    if (ci != null && XmlSchema.classCanBeReferenced(ci)) {
                        String ref = pi.inlineOrByReference();
                        if (ref == null) {
                            ref = "";
                        }
                        if (ref.equalsIgnoreCase("byreference")) {
                            conCode = 2;
                        } else if (!ref.equalsIgnoreCase("inline")) {
                            conCode = 3;
                        }
                    }
                }
                if (this.isAIXMExtension(pi)) {
                    if (obj.fragment.length() > 0) {
                        obj.fragment = obj.fragment + "/";
                        obj.priority = 9;
                    }
                    obj.fragment = obj.fragment + this.schemaObject.getAndRegisterXmlns(pi.inClass()) + ":extension/*";
                }
                String proper = this.schemaObject.getAndRegisterXmlName(pi);
                if (conCode == 0) {
                    if (obj.fragment.length() > 0) {
                        obj.fragment = obj.fragment + "/";
                        obj.priority = 9;
                    }
                    obj.fragment = obj.fragment + proper;
                    boolean is19139 = pi.matches("rule-xsd-all-naming-19139") || ci != null && ci.matches("rule-xsd-cls-standard-19139-property-types");
                    boolean iscodelist = ci != null && ci.category() == 2 && (ci.matches("rule-xsd-cls-codelist-asDictionaryGml33") && ci.asDictionaryGml33() || ci.matches("rule-xsd-cls-codelist-asDictionary") && ci.asDictionary());
                    Object clvpat = "{value}";
                    if (ci != null && iscodelist && !pi.inClass().matches("rule-xsd-cls-codelist-asDictionaryGml33") && !is19139) {
                        String vp;
                        String uri = ci.taggedValue("codeList");
                        if (StringUtils.isNotBlank((CharSequence)uri)) {
                            clvpat = "{codeList}/{value}";
                        }
                        if (StringUtils.isNotBlank((CharSequence)(vp = ci.taggedValue("codeListValuePattern")))) {
                            clvpat = vp;
                        }
                        clvpat = ((String)clvpat).replace("{codeList}", "',{codeList},'");
                        if (((String)(clvpat = ((String)clvpat).replace("{value}", "',{value},'"))).startsWith("',")) {
                            clvpat = ((String)clvpat).substring(2);
                        }
                        if (((String)clvpat).endsWith(",'")) {
                            clvpat = ((String)clvpat).substring(0, ((String)clvpat).length() - 2);
                        }
                        if (!((String)clvpat).startsWith("{")) {
                            clvpat = "'" + (String)clvpat;
                        }
                        if (!((String)clvpat).endsWith("}")) {
                            clvpat = (String)clvpat + "'";
                        }
                        if (!((String)clvpat).equals("{value}")) {
                            clvpat = "concat(" + (String)clvpat + ")";
                        }
                    }
                    if (this.attributes[idx].absType == 2) {
                        if (is19139) {
                            obj.fragment = obj.fragment + "[not(*)]/@gco:nilReason";
                            this.schemaObject.registerNamespace("gco");
                        } else {
                            obj.fragment = obj.fragment + "[@xsi:nil='true']/@nilReason";
                            this.schemaObject.registerNamespace("xsi");
                        }
                        obj.priority = 9;
                    }
                    if (this.attributes[idx].absType == 1 && cip.isUnionDirect()) {
                        obj.fragment = obj.fragment + "[not(@xsi:nil='true')]";
                        this.schemaObject.registerNamespace("xsi");
                    }
                    if (this.attributes[idx].absType == 0) {
                        String clvp;
                        if (is19139) {
                            obj.fragment = obj.fragment + "/*";
                            if (iscodelist) {
                                clvp = ((String)clvpat).replace("{codeList}", obj.fragment + "/@codeList");
                                obj.fragment = clvp.replace("{value}", obj.fragment + "/@codeListValue");
                            }
                        } else if (iscodelist) {
                            if (!ci.matches("rule-xsd-cls-codelist-asDictionaryGml33")) {
                                clvp = ((String)clvpat).replace("{codeList}", obj.fragment + "/@codeSpace");
                                obj.fragment = clvp.replace("{value}", obj.fragment);
                            } else {
                                obj.fragment = obj.fragment + "/@xlink:href";
                                this.schemaObject.registerNamespace("xlink");
                            }
                        }
                    }
                    lastWasSimple = true;
                    continue;
                }
                if (idx == props.length - 1) {
                    Object frag_propAccess = null;
                    frag_propAccess = obj.fragment;
                    frag_propAccess = (String)frag_propAccess + "/";
                    obj.fragment = frag_propAccess = (String)frag_propAccess + proper;
                    obj.priority = 9;
                    continue;
                }
                Object frag_inl = null;
                Object frag_ref = null;
                if (conCode == 1 || conCode == 3) {
                    frag_inl = obj.fragment;
                    frag_inl = (String)frag_inl + "/";
                    frag_inl = (String)frag_inl + proper;
                    frag_inl = (String)frag_inl + "/*";
                }
                if (conCode == 2 || conCode == 3) {
                    Object attxlink = obj.fragment;
                    if (((String)attxlink).length() > 0) {
                        attxlink = (String)attxlink + "/";
                    }
                    attxlink = (String)attxlink + proper;
                    attxlink = (String)attxlink + "/@xlink:href";
                    frag_ref = "//*[";
                    if (alphaEx || betaEx) {
                        frag_ref = (String)frag_ref + "concat(";
                        if (alphaEx) {
                            frag_ref = (String)frag_ref + "'" + alpha + "',";
                        }
                        frag_ref = (String)frag_ref + "@gml:id";
                        if (betaEx) {
                            frag_ref = (String)frag_ref + ",'" + beta + "'";
                        }
                        frag_ref = (String)frag_ref + ")";
                    } else {
                        frag_ref = (String)frag_ref + "@gml:id";
                    }
                    frag_ref = (String)frag_ref + "=" + (String)attxlink + "]";
                    this.schemaObject.registerNamespace("xlink");
                    this.schemaObject.registerNamespace("gml");
                    if (obj.atEnd != null) {
                        obj.atEnd.setState(BindingContext.CtxState.OTHER);
                    }
                }
                if (conCode == 3) {
                    obj.fragment = (String)frag_inl + " | " + frag_ref;
                    obj.priority = 8;
                    continue;
                }
                if (conCode == 1) {
                    obj.fragment = frag_inl;
                    obj.priority = 9;
                    continue;
                }
                obj.fragment = frag_ref;
                obj.priority = 10;
            }
            return obj;
        }

        public void setVariable(VariableNode varnode) {
            this.var = varnode;
        }

        protected static class AttrComp {
            protected PropertyCall main = null;
            protected PropertyCall absAttr = null;
            protected int absType = 0;

            protected AttrComp(PropertyCall pc) {
                this.main = pc;
            }

            protected AttrComp(AttrComp atc) {
                this.main = atc.main;
                this.absAttr = atc.absAttr;
                this.absType = atc.absType;
            }
        }
    }

    public static class VariableNode
    extends FolSchematronNode {
        protected Variable vardecl;
        private FolSchematronNode value;

        public VariableNode(FOL2Schematron schemaObject, Variable var) {
            this.schemaObject = schemaObject;
            this.vardecl = var;
        }

        public String getName() {
            return this.vardecl.getName();
        }

        @Override
        public boolean isDependentOn(Variable vardecl) {
            return this.vardecl == vardecl;
        }

        @Override
        public boolean isVarOrAttribBased(Variable vardecl) {
            return this.isDependentOn(vardecl);
        }

        @Override
        public AttributeNode generatingAttribute() {
            if (this.value != null) {
                return this.value.generatingAttribute();
            }
            if (this.vardecl.getNextOuterScope() != null) {
                return this.schemaObject.varNodesByVarName.get(this.vardecl.getNextOuterScope().getName()).generatingAttribute();
            }
            return null;
        }

        @Override
        public boolean hasSimpleType() {
            if (this.value != null) {
                if (this.value instanceof AttributeNode) {
                    AttributeNode an = (AttributeNode)this.value;
                    return an.hasSimpleType();
                }
                return super.hasSimpleType();
            }
            if (this.vardecl.getNextOuterScope() != null) {
                return this.schemaObject.varNodesByVarName.get(this.vardecl.getNextOuterScope().getName()).hasSimpleType();
            }
            return false;
        }

        @Override
        public boolean hasIdentity() {
            if (this.value != null) {
                if (this.value instanceof AttributeNode) {
                    AttributeNode an = (AttributeNode)this.value;
                    return an.hasIdentity();
                }
                return super.hasIdentity();
            }
            if (this.vardecl.getNextOuterScope() != null) {
                return this.schemaObject.varNodesByVarName.get(this.vardecl.getNextOuterScope().getName()).hasIdentity();
            }
            return true;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathFragment xpt = new XpathFragment(11, "");
            Object varContext = "current()";
            if (!this.vardecl.getName().equals("self")) {
                varContext = "$" + this.vardecl.getName();
            }
            xpt.fragment = xpt.fragment + (String)varContext;
            return xpt;
        }

        public void setValue(FolSchematronNode varValue) {
            this.value = varValue;
        }

        public FolSchematronNode value() {
            return this.value;
        }
    }

    public static class Arithmetic
    extends FolSchematronNode {
        String operation;

        public Arithmetic(FOL2Schematron schemaObject, String oper) {
            this.schemaObject = schemaObject;
            this.operation = oper;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathFragment xpt1 = ((FolSchematronNode)this.children.get(0)).translate(ctx);
            if (this.children.size() == 1) {
                if (xpt1.priority <= 7) {
                    xpt1.bracket();
                }
                xpt1.priority = 7;
            } else {
                XpathFragment xpt2 = ((FolSchematronNode)this.children.get(1)).translate(ctx);
                int prio = 5;
                if (this.operation.equals("*") || this.operation.equals("/")) {
                    prio = 6;
                }
                if (xpt1.priority < prio) {
                    xpt1.bracket();
                }
                if (this.operation.equals("/") || this.operation.equals("-")) {
                    if (xpt2.priority <= prio) {
                        xpt2.bracket();
                    }
                } else if (xpt2.priority < prio) {
                    xpt2.bracket();
                }
                xpt2.atEnd = null;
                String op2 = xpt1.merge(xpt2);
                xpt1.fragment = xpt1.fragment + " " + (this.operation.equals("/") ? "div" : this.operation) + " " + op2;
                xpt1.priority = prio;
            }
            xpt1.type = XpathType.NUMBER;
            xpt1.atEnd = new BindingContext(BindingContext.CtxState.NONE);
            return xpt1;
        }
    }

    public static class Matches
    extends FolSchematronNode {
        public Matches(FOL2Schematron schemaObject) {
            this.schemaObject = schemaObject;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathFragment xptobj = ((FolSchematronNode)this.children.get(0)).translate(ctx);
            if (xptobj.fragment.length() == 0) {
                xptobj.fragment = ".";
            }
            XpathFragment xptpat = ((FolSchematronNode)this.children.get(1)).translate(ctx);
            if (xptpat.fragment.length() == 0) {
                xptpat.fragment = ".";
            }
            String patstring = xptobj.merge(xptpat);
            FOL2Schematron.ExtensionFunctionTemplate eft = this.schemaObject.extensionFunctions.get("matches");
            if (eft == null) {
                return new XpathFragment(11, "***ERROR[123]***");
            }
            String fcall = eft.function.replace("$object$", xptobj.fragment).replace("$pattern$", patstring);
            xptobj.fragment = eft.nsPrefix + ":" + fcall;
            xptobj.type = XpathType.STRING;
            xptobj.priority = 11;
            xptobj.atEnd.setState(BindingContext.CtxState.NONE);
            this.schemaObject.registerNamespace(eft.nsPrefix, eft.namespace);
            return xptobj;
        }
    }

    public static class IsTypeOfNode
    extends FolSchematronNode {
        protected ClassInfo argumentClass = null;
        protected Variable var = null;

        public IsTypeOfNode(FOL2Schematron schemaObject) {
            this.schemaObject = schemaObject;
        }

        public void setClass(ClassInfo ci) {
            this.argumentClass = ci;
        }

        public void setVariable(Variable var) {
            this.var = var;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathFragment xptobj = this.objValueFromVariable(this.var);
            boolean emptyobject = xptobj.fragment.length() == 0;
            TreeSet<String> classnames = new TreeSet<String>();
            SortedSet<ClassInfo> subtypes = this.argumentClass.subtypesInCompleteHierarchy();
            for (ClassInfo subtype : subtypes) {
                if (subtype.isAbstract()) continue;
                classnames.add(this.schemaObject.getAndRegisterXmlName(subtype));
            }
            if (!this.argumentClass.isAbstract()) {
                classnames.add(this.schemaObject.getAndRegisterXmlName(this.argumentClass));
            }
            if (classnames.size() == 0) {
                xptobj.fragment = "false()";
                xptobj.priority = 11;
                xptobj.type = XpathType.BOOLEAN;
                xptobj.atEnd.setState(BindingContext.CtxState.NONE);
            } else {
                boolean first = true;
                if (xptobj.priority < 9) {
                    xptobj.bracket();
                    xptobj.priority = 11;
                }
                if (!emptyobject) {
                    xptobj.fragment = xptobj.fragment + "[";
                }
                for (String name : classnames) {
                    if (!first) {
                        xptobj.fragment = xptobj.fragment + " or ";
                    }
                    first = false;
                    xptobj.fragment = xptobj.fragment + "name()='" + name + "'";
                }
                xptobj.priority = 3;
                if (classnames.size() > 1) {
                    xptobj.priority = 1;
                }
                if (!emptyobject) {
                    xptobj.fragment = xptobj.fragment + "]";
                    xptobj.priority = 10;
                }
            }
            return xptobj;
        }
    }

    public static class IsNullNode
    extends FolSchematronNode {
        protected FolSchematronNode generatorBody = null;

        public IsNullNode(FOL2Schematron schemaObject) {
            this.schemaObject = schemaObject;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            AttributeNode atn;
            FolSchematronNode obj = (FolSchematronNode)this.children.get(0);
            XpathFragment xptobj = obj.translate(ctx);
            if ((obj instanceof AttributeNode || obj instanceof VariableNode) && (atn = obj.generatingAttribute()) != null && atn.implementedAsXmlAttribute()) {
                XpathFragment result = new XpathFragment(0, "");
                result.fragment = result.fragment + "not(string-length(normalize-space(";
                result.fragment = result.fragment + xptobj.fragment;
                result.fragment = result.fragment + ")))";
                return result;
            }
            xptobj.fragment = xptobj.fragment + "[@xsi:nil='true']";
            this.schemaObject.registerNamespace("xsi");
            return xptobj;
        }
    }

    public static class NotNode
    extends FolSchematronNode {
        public NotNode(FOL2Schematron schemaObject) {
            this.schemaObject = schemaObject;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            FolSchematronNode obj = (FolSchematronNode)this.children.get(0);
            XpathFragment xpt = obj.translate(ctx);
            xpt.fragment = "not(" + xpt.fragment + ")";
            xpt.type = XpathType.BOOLEAN;
            xpt.priority = 11;
            xpt.atEnd.setState(BindingContext.CtxState.NONE);
            return xpt;
        }
    }

    public static class Empty
    extends FolSchematronNode {
        public Empty(FOL2Schematron schemaObject) {
            this.schemaObject = schemaObject;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            FolSchematronNode obj = (FolSchematronNode)this.children.get(0);
            XpathFragment xpt = obj.translate(ctx);
            if (xpt.fragment.length() == 0) {
                xpt.fragment = ".";
            }
            xpt.fragment = "not(" + xpt.fragment + ")";
            xpt.type = XpathType.BOOLEAN;
            xpt.priority = 11;
            xpt.atEnd.setState(BindingContext.CtxState.NONE);
            return xpt;
        }
    }

    public static class ComparisonNode
    extends FolSchematronNode {
        String opname;

        public ComparisonNode(FOL2Schematron schemaObject, String name) {
            this.schemaObject = schemaObject;
            this.opname = name.equals("<>") ? "!=" : name;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            int refprio = 4;
            if (this.opname.equals("=") || this.opname.equals("!=")) {
                refprio = 3;
            }
            XpathFragment[] child_xpt = new XpathFragment[2];
            for (int i = 0; i < 2; ++i) {
                FolSchematronNode child = (FolSchematronNode)this.children.get(i);
                if (!child.hasSimpleType() && !child.hasIdentity()) {
                    return new XpathFragment(11, "***ERROR[126]***");
                }
                child_xpt[i] = child.translate(ctx);
                if (child.hasIdentity()) {
                    child_xpt[i].fragment = "generate-id(" + child_xpt[i].fragment + ")";
                    child_xpt[i].priority = 11;
                }
                if (child_xpt[i].fragment.length() == 0) {
                    child_xpt[i].fragment = ".";
                }
                if (child_xpt[i].priority <= refprio) {
                    child_xpt[i].bracket();
                }
                child_xpt[i].atEnd.setState(BindingContext.CtxState.NONE);
            }
            String op2 = child_xpt[0].merge(child_xpt[1]);
            child_xpt[0].fragment = child_xpt[0].fragment + " " + this.opname + " " + op2;
            child_xpt[0].type = XpathType.BOOLEAN;
            child_xpt[0].priority = refprio;
            return child_xpt[0];
        }
    }

    public static class Logic
    extends FolSchematronNode {
        protected LogicType logic;

        public Logic(FOL2Schematron schemaObject, LogicType logic) {
            this.schemaObject = schemaObject;
            this.logic = logic;
        }

        @Override
        public boolean isAndOrLogic(boolean isAnd) {
            if (this.logic == LogicType.XOR || this.logic == LogicType.EQV) {
                return false;
            }
            return this.logic == LogicType.AND == isAnd;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            if (this.children.size() == 1) {
                return ((FolSchematronNode)this.children.get(0)).translate(ctx);
            }
            String particle = null;
            int refprio = -1;
            if (this.logic == LogicType.AND) {
                particle = "and";
                refprio = 2;
            } else if (this.logic == LogicType.OR) {
                particle = "or";
                refprio = 1;
            } else if (this.logic == LogicType.XOR) {
                particle = "!=";
                refprio = 3;
            } else {
                particle = "=";
                refprio = 3;
            }
            XpathFragment result = null;
            result = new XpathFragment(0, "(");
            boolean first = true;
            for (FolSchematronNode ocn : this.children) {
                XpathFragment child_xpt = ocn.translate(ctx);
                if ((this.logic == LogicType.XOR || this.logic == LogicType.EQV) && child_xpt.type != XpathType.BOOLEAN) {
                    child_xpt.fragment = "boolean(" + child_xpt.fragment + ")";
                    child_xpt.type = XpathType.BOOLEAN;
                    child_xpt.priority = 11;
                } else if (child_xpt.priority < refprio) {
                    child_xpt.bracket();
                }
                child_xpt.atEnd.setState(BindingContext.CtxState.NONE);
                if (first) {
                    result.fragment = result.fragment + child_xpt.fragment;
                    first = false;
                    continue;
                }
                String mrge = result.merge(child_xpt);
                result.fragment = result.fragment + " " + particle + " ";
                result.fragment = result.fragment + mrge;
            }
            result.fragment = result.fragment + ")";
            result.priority = refprio;
            result.type = XpathType.BOOLEAN;
            return result;
        }

        protected static enum LogicType {
            AND,
            OR,
            XOR,
            EQV;

        }
    }

    protected static class XpathFragment {
        public int priority;
        public String fragment;
        public XpathType type;
        public BindingContext atEnd = new BindingContext(BindingContext.CtxState.NONE);

        public XpathFragment(int p, String f, XpathType t) {
            this.priority = p;
            this.fragment = f;
            this.type = t;
        }

        public XpathFragment(int p, String f) {
            this.priority = p;
            this.fragment = f;
            this.type = XpathType.NODESET;
        }

        public void bracket() {
            this.fragment = "(" + this.fragment + ")";
            this.priority = 11;
        }

        public String merge(XpathFragment xf) {
            if (this.atEnd != null) {
                this.atEnd.merge(xf.atEnd);
            }
            return xf.fragment;
        }
    }

    public static class BindingContext {
        public CtxState state;

        BindingContext(CtxState state) {
            this.state = state;
        }

        public BindingContext clone() {
            BindingContext copy = new BindingContext(this.state);
            return copy;
        }

        public void setState(CtxState state) {
            this.state = state;
        }

        public void merge(BindingContext ctx) {
            if (ctx == null) {
                return;
            }
            if (this.state == CtxState.NONE) {
                return;
            }
            if (ctx.state == CtxState.NONE) {
                this.setState(CtxState.NONE);
                return;
            }
            if (ctx.state == CtxState.ATCURRENT && this.state == CtxState.ATCURRENT) {
                return;
            }
            if (ctx.state != CtxState.OTHER || this.state != CtxState.OTHER) {
                this.state = CtxState.OTHER;
            }
        }

        public static enum CtxState {
            NONE,
            ATCURRENT,
            OTHER;

        }
    }

    protected static enum XpathType {
        BOOLEAN,
        NUMBER,
        STRING,
        NODESET;

    }
}

