/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.FOL2Schematron;

import de.interactive_instruments.ShapeChange.AIXMSchemaInfos;
import de.interactive_instruments.ShapeChange.FOL.AndOr;
import de.interactive_instruments.ShapeChange.FOL.AndOrType;
import de.interactive_instruments.ShapeChange.FOL.BinaryComparisonPredicate;
import de.interactive_instruments.ShapeChange.FOL.ClassLiteral;
import de.interactive_instruments.ShapeChange.FOL.EqualTo;
import de.interactive_instruments.ShapeChange.FOL.FolExpression;
import de.interactive_instruments.ShapeChange.FOL.HigherOrEqualTo;
import de.interactive_instruments.ShapeChange.FOL.HigherThan;
import de.interactive_instruments.ShapeChange.FOL.IsNull;
import de.interactive_instruments.ShapeChange.FOL.IsTypeOf;
import de.interactive_instruments.ShapeChange.FOL.Literal;
import de.interactive_instruments.ShapeChange.FOL.LowerOrEqualTo;
import de.interactive_instruments.ShapeChange.FOL.LowerThan;
import de.interactive_instruments.ShapeChange.FOL.Not;
import de.interactive_instruments.ShapeChange.FOL.Predicate;
import de.interactive_instruments.ShapeChange.FOL.PropertyCall;
import de.interactive_instruments.ShapeChange.FOL.Quantification;
import de.interactive_instruments.ShapeChange.FOL.SchemaCall;
import de.interactive_instruments.ShapeChange.FOL.Variable;
import de.interactive_instruments.ShapeChange.MapEntry;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.FolConstraint;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.FOL2Schematron.FolSchematronNode;
import de.interactive_instruments.ShapeChange.Target.Target;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FOL2Schematron
implements Target,
MessageSource {
    public static final String PARAM_SCH_XLINK_HREF_PREFIX = "schematronXlinkHrefPrefix";
    public static final String PARAM_SCH_XLINK_HREF_POSTFIX = "schematronXlinkHrefPostfix";
    protected ShapeChangeResult result;
    protected PackageInfo schema = null;
    protected Options options;
    protected Model model;
    protected boolean diagnosticsOnly = false;
    private String outputDirectory;
    private boolean printed = false;
    private boolean atLeastOneSchematronRuleExists = false;
    private Document document;
    private Element pattern;
    private Element root;
    protected String currentConstraintName = null;
    protected ClassInfo currentConstraintClass = null;
    private String classname = this.getClass().getSimpleName();
    private int varIndex = 0;
    HashMap<String, RuleCreationStatus> ruleCreationStatusMap = new HashMap();
    HashMap<String, ExtensionFunctionTemplate> extensionFunctions = new HashMap();
    private HashSet<String> namespaces = new HashSet();
    protected String alpha = "#";
    protected String beta = "";
    protected Map<String, FolSchematronNode.VariableNode> varNodesByVarName = new HashMap<String, FolSchematronNode.VariableNode>();
    protected String xmlns;

    @Override
    public void initialise(PackageInfo schemaPi, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        String s;
        this.schema = schemaPi;
        this.options = o;
        this.model = m;
        this.result = r;
        this.diagnosticsOnly = diagOnly;
        this.result.addDebug(this, 1, schemaPi.name());
        this.outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter("outputDirectory");
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter(".");
        }
        if (!this.diagnosticsOnly) {
            File outputDirectoryFile = new File(this.outputDirectory);
            boolean exi = outputDirectoryFile.exists();
            if (!exi) {
                outputDirectoryFile.mkdirs();
                exi = outputDirectoryFile.exists();
            }
            boolean dir = outputDirectoryFile.isDirectory();
            boolean wrt = outputDirectoryFile.canWrite();
            boolean rea = outputDirectoryFile.canRead();
            if (!(exi && dir && wrt && rea)) {
                this.result.addFatalError(this, 3, this.outputDirectory);
                return;
            }
        }
        if ((s = this.options.parameter(this.classname, PARAM_SCH_XLINK_HREF_PREFIX)) != null) {
            this.alpha = s;
        }
        if ((s = this.options.parameter(this.classname, PARAM_SCH_XLINK_HREF_POSTFIX)) != null) {
            this.beta = s;
        }
        this.xmlns = schemaPi.xmlns();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.document = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(null, 2);
            String msg = e.getMessage();
            if (msg != null) {
                this.result.addFatalError(msg);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            this.result.addFatalError(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        this.root = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "schema");
        this.document.appendChild(this.root);
        this.addAttribute(this.document, this.root, "xmlns:sch", "http://purl.oclc.org/dsdl/schematron");
        this.addAttribute(this.document, this.root, "queryBinding", "xslt2");
        Element e1 = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "title");
        this.root.appendChild(e1);
        e1.appendChild(this.document.createTextNode("Schematron constraints for schema '" + this.schema.name() + "'"));
        e1 = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "ns");
        this.root.appendChild(e1);
        this.namespaces.add("sch");
        this.addAttribute(this.document, e1, "prefix", "sch");
        this.addAttribute(this.document, e1, "uri", "http://purl.oclc.org/dsdl/schematron");
        e1 = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "ns");
        this.root.appendChild(e1);
        this.namespaces.add(this.schema.xmlns());
        this.addAttribute(this.document, e1, "prefix", this.schema.xmlns());
        this.addAttribute(this.document, e1, "uri", this.schema.targetNamespace());
        this.pattern = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "pattern");
        this.root.appendChild(this.pattern);
    }

    @Override
    public void process(ClassInfo ci) {
        this.result.addDebug(this, 2, ci.name());
        List<Constraint> cons = ci.constraints();
        if (!cons.isEmpty()) {
            if (ci.category() == 16) {
                this.result.addDebug(this, 4, ci.name());
                return;
            }
            Collections.sort(cons, new Comparator<Constraint>(){

                @Override
                public int compare(Constraint o1, Constraint o2) {
                    return o1.name().compareTo(o2.name());
                }
            });
            for (Constraint con : cons) {
                if (!(con instanceof FolConstraint)) continue;
                FolConstraint folCon = (FolConstraint)con;
                this.result.addInfo("Class '" + ci.name() + "' has FOL constraint '" + con.name() + "' with FOL expression: " + (folCon.folExpression() == null ? "<null>" : folCon.folExpression()));
                if (folCon.folExpression() == null) continue;
                this.reset();
                this.addAssertion(ci, folCon);
            }
        }
    }

    protected void addAssertion(ClassInfo ci, FolConstraint c) {
        if (c == null) {
            return;
        }
        if (ci.isAbstract()) {
            return;
        }
        FolExpression folExpr = c.folExpression();
        if (folExpr == null) {
            return;
        }
        this.currentConstraintName = c.name();
        this.currentConstraintClass = ci;
        FolSchematronNode scn = this.translateConstraint(folExpr, null);
        if (scn == null) {
            return;
        }
        FolSchematronNode.BindingContext ctx = new FolSchematronNode.BindingContext(FolSchematronNode.BindingContext.CtxState.ATCURRENT);
        FolSchematronNode.XpathFragment xpath = scn.translate(ctx);
        if (this.checkErrorsInXpathFragment(xpath)) {
            return;
        }
        Object text = "";
        String[] comments = c.comments();
        if (comments != null && comments.length > 0) {
            for (String cl : comments) {
                if (cl.startsWith("/*")) {
                    cl = cl.substring(2);
                }
                if (cl.endsWith("*/")) {
                    cl = cl.substring(0, cl.length() - 2);
                }
                text = (String)text + " " + cl;
            }
        }
        text = ((String)text).trim();
        this.addAssertion(ci, xpath, (String)text, this.currentConstraintName);
    }

    protected void addAssertion(ClassInfo ci, FolSchematronNode.XpathFragment xpath, String text, String id) {
        String asserttext;
        if (ci.isAbstract()) {
            return;
        }
        String ftn = this.getAndRegisterXmlName(ci);
        RuleCreationStatus rulecs = this.ruleCreationStatusMap.get(ftn);
        if (rulecs == null) {
            Element rule = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "rule");
            this.pattern.appendChild(rule);
            this.addAttribute(this.document, rule, "context", ftn);
            rulecs = new RuleCreationStatus();
            rulecs.ruleElement = rule;
            rulecs.lastPathStatus = xpath;
            asserttext = xpath.fragment;
            this.ruleCreationStatusMap.put(ftn, rulecs);
        } else {
            asserttext = rulecs.lastPathStatus.merge(xpath);
        }
        Element ass = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "assert");
        rulecs.ruleElement.appendChild(ass);
        if (rulecs.firstAssertElement == null) {
            rulecs.firstAssertElement = ass;
        }
        this.addAttribute(this.document, ass, "id", id);
        this.addAttribute(this.document, ass, "test", asserttext);
        ass.appendChild(this.document.createTextNode(text));
        this.atLeastOneSchematronRuleExists = true;
    }

    private boolean checkErrorsInXpathFragment(FolSchematronNode.XpathFragment xpath) {
        Object allofit = "";
        allofit = (String)allofit + xpath.fragment;
        Pattern p = Pattern.compile("\\*\\*\\*ERROR\\[(.*?)\\]\\*\\*\\*");
        Matcher m = p.matcher((CharSequence)allofit);
        int count = 0;
        while (m.find()) {
            ++count;
            String argsl = m.group(1);
            String[] args = argsl.split(",");
            int mnr = Integer.parseInt(args[0]);
            if (args.length == 1) {
                this.result.addError(this, mnr, this.currentConstraintName, this.currentConstraintClass.name());
                continue;
            }
            if (args.length < 2) continue;
            this.result.addError(this, mnr, this.currentConstraintName, this.currentConstraintClass.name(), args[1]);
        }
        return count > 0;
    }

    public String getAndRegisterXmlName(PropertyInfo pi) {
        String nspref = null;
        AIXMSchemaInfos.AIXMSchemaInfo aixmSchemaInfo = null;
        if (this.options.isAIXM()) {
            if (this.options.getAIXMSchemaInfos() != null) {
                aixmSchemaInfo = this.options.getAIXMSchemaInfos().get(pi.id());
                if (aixmSchemaInfo == null) {
                    this.result.addWarning(this, 6, pi.fullNameInSchema());
                }
            } else {
                this.result.addWarning(this, 5);
            }
        }
        if (aixmSchemaInfo == null) {
            nspref = pi.inClass().pkg().xmlns();
            this.registerNamespace(nspref, pi.inClass());
        } else {
            nspref = aixmSchemaInfo.xmlns();
            this.registerNamespace(nspref, aixmSchemaInfo.targetNamespace());
        }
        String proper = nspref + ":" + pi.name();
        return proper;
    }

    public String getAndRegisterXmlName(ClassInfo ci) {
        String nspref = null;
        Object fulnam = null;
        MapEntry me = ci.options().elementMapEntry(ci.name(), ci.encodingRule("xsd"));
        if (me != null) {
            if (me.p1 == null || me.p1.length() == 0) {
                return null;
            }
            fulnam = me.p1;
            String[] parts = ((String)fulnam).split(":");
            if (parts.length > 1) {
                nspref = parts[0];
            }
            this.registerNamespace(nspref);
        } else {
            AIXMSchemaInfos.AIXMSchemaInfo aixmSchemaInfo = null;
            if (this.options.isAIXM()) {
                if (this.options.getAIXMSchemaInfos() != null) {
                    aixmSchemaInfo = this.options.getAIXMSchemaInfos().get(ci.id());
                    if (aixmSchemaInfo == null) {
                        this.result.addWarning(this, 6, ci.fullNameInSchema());
                    }
                } else {
                    this.result.addWarning(this, 5);
                }
            }
            if (aixmSchemaInfo == null) {
                nspref = ci.pkg().xmlns();
                this.registerNamespace(nspref, ci);
            } else {
                nspref = aixmSchemaInfo.xmlns();
                this.registerNamespace(nspref, aixmSchemaInfo.targetNamespace());
            }
            fulnam = nspref + ":" + ci.name();
        }
        return fulnam;
    }

    public String getAndRegisterXmlns(ClassInfo ci) {
        String xmlns;
        AIXMSchemaInfos.AIXMSchemaInfo aixmSchemaInfo = null;
        if (this.options.isAIXM()) {
            if (this.options.getAIXMSchemaInfos() != null) {
                aixmSchemaInfo = this.options.getAIXMSchemaInfos().get(ci.id());
                if (aixmSchemaInfo == null) {
                    this.result.addWarning(this, 6, ci.fullNameInSchema());
                }
            } else {
                this.result.addWarning(this, 5);
            }
        }
        if (aixmSchemaInfo == null) {
            xmlns = ci.pkg().xmlns();
            this.registerNamespace(xmlns);
        } else {
            xmlns = aixmSchemaInfo.xmlns();
            this.registerNamespace(xmlns, aixmSchemaInfo.targetNamespace());
        }
        return xmlns;
    }

    public void registerNamespace(String xmlns, String ns) {
        if (!this.namespaces.contains(xmlns)) {
            Element e = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "ns");
            this.addAttribute(this.document, e, "prefix", xmlns);
            if (ns == null) {
                ns = "FIXME";
            }
            this.addAttribute(this.document, e, "uri", ns);
            this.root.insertBefore(e, this.pattern);
            this.namespaces.add(xmlns);
        }
    }

    public void registerNamespace(String xmlns) {
        if (!this.namespaces.contains(xmlns)) {
            String ns = this.options.fullNamespace(xmlns);
            this.registerNamespace(xmlns, ns);
        }
    }

    public void registerNamespace(String xmlns, ClassInfo ci) {
        if (!this.namespaces.contains(xmlns)) {
            String ns = ci.pkg().targetNamespace();
            if (ns == null || ns.length() == 0) {
                this.registerNamespace(xmlns);
            } else {
                this.registerNamespace(xmlns, ns);
            }
        }
    }

    protected FolSchematronNode translateConstraint(FolExpression folExpr, FolSchematronNode enclosing) {
        FolSchematronNode scn = null;
        if (folExpr instanceof Quantification) {
            Quantification q = (Quantification)folExpr;
            scn = this.translateQuantification(q, enclosing);
        } else if (folExpr instanceof SchemaCall) {
            SchemaCall sc = (SchemaCall)folExpr;
            scn = this.translateSchemaCall(sc, enclosing, false);
        } else if (folExpr instanceof Literal) {
            Literal lit = (Literal)folExpr;
            scn = this.translateLiteral(lit, enclosing);
        } else if (folExpr instanceof Variable) {
            scn = this.translateVariable((Variable)folExpr, enclosing);
        } else if (folExpr instanceof Not) {
            scn = this.translateNot((Not)folExpr, enclosing);
        } else if (folExpr instanceof EqualTo) {
            scn = this.translateComparisonOperation((BinaryComparisonPredicate)folExpr, "=", enclosing);
        } else if (folExpr instanceof HigherOrEqualTo) {
            scn = this.translateComparisonOperation((BinaryComparisonPredicate)folExpr, ">=", enclosing);
        } else if (folExpr instanceof HigherThan) {
            scn = this.translateComparisonOperation((BinaryComparisonPredicate)folExpr, ">", enclosing);
        } else if (folExpr instanceof LowerOrEqualTo) {
            scn = this.translateComparisonOperation((BinaryComparisonPredicate)folExpr, "<=", enclosing);
        } else if (folExpr instanceof LowerThan) {
            scn = this.translateComparisonOperation((BinaryComparisonPredicate)folExpr, "<", enclosing);
        } else if (folExpr instanceof AndOr) {
            scn = this.translateAndOr((AndOr)folExpr, enclosing);
        } else if (folExpr instanceof IsNull) {
            scn = this.translateIsNull((IsNull)folExpr, enclosing);
        } else if (folExpr instanceof IsTypeOf) {
            scn = this.translateIsTypeOf((IsTypeOf)folExpr, enclosing);
        } else {
            if (folExpr == null) {
                this.result.addError(this, 101, "<NULL>", this.currentConstraintName, this.currentConstraintClass.name());
            } else {
                String clname = folExpr.getClass().getSimpleName();
                this.result.addError(this, 101, clname, this.currentConstraintName, this.currentConstraintClass.name());
            }
            scn = new FolSchematronNode.Error(this);
        }
        return scn;
    }

    private FolSchematronNode translateIsTypeOf(IsTypeOf folExpr, FolSchematronNode enclosing) {
        FolSchematronNode.IsTypeOfNode typeOf = new FolSchematronNode.IsTypeOfNode(this);
        if (!(folExpr.getExprLeft() instanceof Variable)) {
            this.result.addError(this, 7);
            FolSchematronNode.Error err = new FolSchematronNode.Error(this);
            if (enclosing != null) {
                enclosing.addChild(err);
            }
            return err;
        }
        Variable var = (Variable)folExpr.getExprLeft();
        typeOf.setVariable(var);
        FolSchematronNode clex = this.translateConstraint(folExpr.getExprRight(), null);
        boolean assumeError = true;
        if (clex instanceof FolSchematronNode.LiteralNode) {
            FolSchematronNode.LiteralNode cllit = (FolSchematronNode.LiteralNode)clex;
            Literal l = cllit.literal;
            if (l instanceof ClassLiteral) {
                ClassLiteral lcl = (ClassLiteral)l;
                ClassInfo ci = lcl.getSchemaElement();
                typeOf.setClass(ci);
                assumeError = false;
            }
        }
        if (assumeError) {
            this.result.addError(this, 104, this.currentConstraintName, this.currentConstraintClass.name(), "IsTypeOf");
            FolSchematronNode.Error err = new FolSchematronNode.Error(this);
            if (enclosing != null) {
                enclosing.addChild(err);
            }
            return err;
        }
        if (enclosing != null) {
            enclosing.addChild(typeOf);
        }
        return typeOf;
    }

    private FolSchematronNode translateIsNull(IsNull fol, FolSchematronNode enclosing) {
        FolSchematronNode.IsNullNode inn = new FolSchematronNode.IsNullNode(this);
        inn.addChild(this.translateConstraint(fol.getExpr(), null));
        if (enclosing != null) {
            enclosing.addChild(inn);
        }
        return inn;
    }

    private FolSchematronNode.VariableNode translateVariable(Variable var, FolSchematronNode enclosing) {
        FolSchematronNode varValue;
        if (this.varNodesByVarName.containsKey(var.getName())) {
            return this.varNodesByVarName.get(var.getName());
        }
        FolSchematronNode.VariableNode vn = new FolSchematronNode.VariableNode(this, var);
        this.varNodesByVarName.put(var.getName(), vn);
        if (var.getNextOuterScope() != null && !this.varNodesByVarName.containsKey(var.getNextOuterScope().getName())) {
            this.translateVariable(var.getNextOuterScope(), enclosing);
        }
        if (var.getValue() != null && (varValue = this.translateSchemaCall(var.getValue(), null, true)) != null) {
            vn.setValue(varValue);
        }
        if (enclosing != null) {
            enclosing.addChild(vn);
        }
        return vn;
    }

    private FolSchematronNode translateAndOr(AndOr fol, FolSchematronNode enclosing) {
        boolean passencl;
        List<Predicate> predicates = fol.getPredicateList();
        boolean and = fol.getType().equals((Object)AndOrType.and);
        boolean bl = passencl = enclosing != null && enclosing.isAndOrLogic(and);
        FolSchematronNode scn = passencl ? enclosing : new FolSchematronNode.Logic(this, and ? FolSchematronNode.Logic.LogicType.AND : FolSchematronNode.Logic.LogicType.OR);
        for (int i = 0; i < predicates.size(); ++i) {
            this.translateConstraint(predicates.get(i), scn);
        }
        if (!passencl && enclosing != null) {
            enclosing.addChild(scn);
        }
        return scn;
    }

    private FolSchematronNode translateComparisonOperation(BinaryComparisonPredicate fol, String operatorSymbol, FolSchematronNode enclosing) {
        FolSchematronNode.ComparisonNode scn = new FolSchematronNode.ComparisonNode(this, operatorSymbol);
        scn.addChild(this.translateConstraint(fol.getExprLeft(), null));
        scn.addChild(this.translateConstraint(fol.getExprRight(), null));
        if (enclosing != null) {
            enclosing.addChild(scn);
        }
        return scn;
    }

    private FolSchematronNode translateNot(Not fol, FolSchematronNode enclosing) {
        FolSchematronNode.NotNode not = new FolSchematronNode.NotNode(this);
        not.addChild(this.translateConstraint(fol.getPredicate(), null));
        if (enclosing != null) {
            enclosing.addChild(not);
        }
        return not;
    }

    private FolSchematronNode translateQuantification(Quantification q, FolSchematronNode enclosing) {
        FolSchematronNode.QuantificationNode qn = new FolSchematronNode.QuantificationNode(this, q);
        qn.setVariableNode(this.translateVariable(q.getVar(), null));
        qn.setCondition(this.translateConstraint(q.getCondition(), null));
        if (enclosing != null) {
            enclosing.addChild(qn);
        }
        return qn;
    }

    private FolSchematronNode translateLiteral(Literal lit, FolSchematronNode enclosing) {
        FolSchematronNode.LiteralNode litn = new FolSchematronNode.LiteralNode(this, lit);
        if (enclosing != null) {
            enclosing.addChild(litn);
        }
        return litn;
    }

    private FolSchematronNode translateSchemaCall(SchemaCall sc, FolSchematronNode enclosing, boolean isVariableValue) {
        FolSchematronNode.AttributeNode atn = new FolSchematronNode.AttributeNode(this);
        if (sc.hasVariableContext()) {
            FolSchematronNode.VariableNode varnode = this.varNodesByVarName.get(sc.getVariableContext().getName());
            atn.setVariable(varnode);
        }
        if (sc instanceof PropertyCall) {
            PropertyCall pc = (PropertyCall)sc;
            int absorptionType = 0;
            PropertyInfo pi = pc.getSchemaElement();
            boolean nilreason = pi.implementedByNilReason();
            if (nilreason) {
                absorptionType = 2;
            }
            if (pc.hasVariableContext()) {
                FolSchematronNode.VariableNode varnode = this.varNodesByVarName.get(pc.getVariableContext().getName());
                FolSchematronNode.AttributeNode varatn = varnode.generatingAttribute();
                if (varatn != null && varatn.isPropertyAbsorbing()) {
                    if (absorptionType == 0) {
                        absorptionType = 1;
                    }
                    varatn.appendAbsorbedAttribute(absorptionType, pc);
                } else {
                    atn.appendAttribute(pc);
                }
            } else {
                atn = (FolSchematronNode.AttributeNode)enclosing;
                if (atn.isPropertyAbsorbing()) {
                    if (absorptionType == 0) {
                        absorptionType = 1;
                    }
                    atn.appendAbsorbedAttribute(absorptionType, pc);
                } else {
                    atn.appendAttribute(pc);
                }
            }
        } else {
            if (!sc.hasVariableContext() && !sc.hasNextElement()) {
                return null;
            }
            if (enclosing != null && enclosing instanceof FolSchematronNode.AttributeNode) {
                atn = (FolSchematronNode.AttributeNode)enclosing;
            }
        }
        if (sc.hasNextElement()) {
            this.translateSchemaCall(sc.getNextElement(), atn, false);
        }
        return atn;
    }

    @Override
    public void write() {
        if (this.printed || !this.atLeastOneSchematronRuleExists) {
            return;
        }
        Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        outputFormat.setProperty("indent", "yes");
        outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        outputFormat.setProperty("encoding", "UTF-8");
        try {
            String fileName = this.schema.name().replace("/", "_").replace(" ", "_") + "_SchematronSchema.xml";
            FileOutputStream fout = new FileOutputStream(this.outputDirectory + "/" + fileName);
            OutputStreamWriter outputXML = new OutputStreamWriter((OutputStream)fout, outputFormat.getProperty("encoding"));
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            serializer.setWriter((Writer)outputXML);
            serializer.asDOMSerializer().serialize((Node)this.document);
            outputXML.close();
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
        this.printed = true;
    }

    private void addAttribute(Document document, Element e, String name, String value) {
        Attr att = document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    @Override
    public String getTargetName() {
        return "First Order Logic to Schematron";
    }

    @Override
    public String getTargetIdentifier() {
        return "fol2sch";
    }

    @Override
    public String getDefaultEncodingRule() {
        return "*";
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Generating Schematron from First Order Logic constraints for application schema '$1$'.";
            }
            case 2: {
                return "Processing class '$1$'.";
            }
            case 3: {
                return "Directory named '$1$' does not exist or is not accessible.";
            }
            case 4: {
                return "Class '$1$' is an AIXM <<extension>> for which constraints are being ignored (only constraints in actual AIXM <<feature>> and <<object>> types are relevant).";
            }
            case 5: {
                return "??Processing a AIXM schemas but Options does not contain AIXMSchemaInfos. Ensure that the selected AIXM schema have been merged before executing this target.";
            }
            case 6: {
                return "??No AIXMSchemaInfo found for Info object '$1$'.";
            }
            case 7: {
                return "Expected variable in left hand side of is-type-of expression.";
            }
            case 101: {
                return "Failure to compile FOL constraint named \"$2$\" in class \"$3$\". Node class \"$1$\" not implemented.";
            }
            case 104: {
                return "Implementation restriction - in FOL constraint \"$1$\" in class \"$2$\" argument to operator \"$3$\" must be class constant.";
            }
            case 106: {
                return "Failure to compile FOL constraint named \"$2$\" in class \"$3$\". Property call construct named \"$1$\" not implemented.";
            }
            case 126: {
                return "Implementation restriction - in FOL constraint \"$1$\" in class \"$2$\" comparison between structured non-object types not supported.";
            }
        }
        return "(Unknown message: " + mnr + ")";
    }

    public int getNextVarIndex() {
        ++this.varIndex;
        return this.varIndex;
    }

    public void reset() {
        this.varIndex = 0;
        this.varNodesByVarName = new HashMap<String, FolSchematronNode.VariableNode>();
    }

    public String schemaQname(String elementName) {
        if (elementName == null) {
            return null;
        }
        return this.xmlns + ":" + elementName;
    }

    public static class ExtensionFunctionTemplate {
        public String nsPrefix;
        public String namespace;
        public String function;

        public ExtensionFunctionTemplate(String nsp, String ns, String fct) {
            this.nsPrefix = nsp;
            this.namespace = ns;
            this.function = fct;
        }
    }

    public static class RuleCreationStatus {
        public FolSchematronNode.XpathFragment lastPathStatus;
        public Element ruleElement;
        public Element firstAssertElement = null;
        HashSet<String> letVarsAlreadyOutput = new HashSet();
    }
}

