/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.EA;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.TargetConfiguration;
import de.interactive_instruments.ShapeChange.Util.ea.EARepositoryUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.sparx.CreateModelType;
import org.sparx.Repository;
import shadow.org.apache.commons.lang3.StringUtils;

public class UmlModelConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("eaAuthor", "eaStatus", "eapTemplate", "ignoreTaggedValuesRegex", "includeAssociationEndOwnership", "mergeConstraintCommentsIntoText", "modelFilename", "omitOutputPackage", "omitOutputPackageDateTime", "outputDirectory", "outputPackageName", "preservePackageHierarchy", "synchronizeStereotypes").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;

    @Override
    public boolean isValid(ProcessConfiguration configIn, Options options, ShapeChangeResult result) {
        TargetConfiguration config = (TargetConfiguration)configIn;
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTargetParameters());
        isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, config.getParameters().keySet(), result) && isValid;
        String outputDirectoryBase = config.getParameterValue("outputDirectory");
        if (outputDirectoryBase == null) {
            outputDirectoryBase = options.parameter("outputDirectory");
        }
        if (outputDirectoryBase == null) {
            outputDirectoryBase = ".";
        }
        SortedSet<String> modelProviderIds = config.getInputIds();
        for (String modelProviderId : modelProviderIds) {
            String outputDirectory = outputDirectoryBase.trim() + File.separator + modelProviderId;
            Object outputFilename = config.parameterAsString("modelFilename", "ShapeChangeExport.eap", false, true);
            File repfile = null;
            File outDir = new File(outputDirectory);
            if (!outDir.exists()) {
                try {
                    FileUtils.forceMkdir((File)outDir);
                }
                catch (IOException e) {
                    String errormsg = e.getMessage();
                    result.addError(this, 32, errormsg, outputDirectory);
                    isValid = false;
                    continue;
                }
            }
            repfile = new File(outDir, (String)outputFilename);
            boolean ex = true;
            boolean created = false;
            Repository rep = new Repository();
            if (!repfile.exists()) {
                ex = false;
                if (!((String)outputFilename).toLowerCase().endsWith(".eap")) {
                    outputFilename = (String)outputFilename + ".eap";
                    repfile = new File((String)outputFilename);
                    ex = repfile.exists();
                }
            }
            String absname = repfile.getAbsolutePath();
            if (!ex) {
                String eapTemplateFilePath = config.getParameterValue("eapTemplate");
                if (eapTemplateFilePath != null) {
                    if (eapTemplateFilePath.toLowerCase().startsWith("http")) {
                        try {
                            URL templateUrl = new URL(eapTemplateFilePath);
                            FileUtils.copyURLToFile((URL)templateUrl, (File)repfile);
                            created = true;
                        }
                        catch (MalformedURLException e1) {
                            result.addError(this, 51, eapTemplateFilePath, e1.getMessage());
                            isValid = false;
                        }
                        catch (IOException e2) {
                            result.addError(this, 53, e2.getMessage());
                            isValid = false;
                        }
                    } else {
                        File eaptemplate = new File(eapTemplateFilePath);
                        if (eaptemplate.exists()) {
                            try {
                                FileUtils.copyFile((File)eaptemplate, (File)repfile);
                                created = true;
                            }
                            catch (IOException e) {
                                result.addError(this, 53, e.getMessage());
                                isValid = false;
                            }
                        } else {
                            result.addError(this, 52, eaptemplate.getAbsolutePath());
                            isValid = false;
                        }
                    }
                } else if (!rep.CreateModel(CreateModelType.cmEAPFromBase, absname, 0)) {
                    result.addError(null, 31, absname);
                    rep = null;
                    isValid = false;
                } else {
                    created = true;
                }
            }
            if (ex || created) {
                if (!rep.OpenFile(absname)) {
                    String errormsg = rep.GetLastError();
                    result.addError(null, 30, errormsg, (String)outputFilename);
                    rep = null;
                    isValid = false;
                } else {
                    isValid &= this.validateMdg(rep, config, options, result);
                }
            }
            EARepositoryUtil.closeRepository(rep);
        }
        return isValid;
    }

    private boolean validateMdg(Repository rep, ProcessConfiguration config, Options options, ShapeChangeResult result) {
        List profiles = config.getMapEntries().stream().filter(me -> me.hasTargetType()).map(me -> me.getTargetType()).filter(tt -> tt.indexOf("::") >= 0).map(tt -> tt.split("::")[0]).distinct().sorted().collect(Collectors.toList());
        if (!profiles.isEmpty()) {
            ArrayList<String> unavailableMdes = new ArrayList<String>();
            for (String profile : profiles) {
                if (rep.IsTechnologyLoaded(profile)) continue;
                unavailableMdes.add(profile);
            }
            if (!unavailableMdes.isEmpty()) {
                result.addWarning(this, 100, StringUtils.join(unavailableMdes, ", "));
            }
        }
        return true;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 32: {
                return "Could not create output directory at $1$. Tests with an actual output repository will thus not be performed.";
            }
            case 51: {
                return "URL '$1$' provided for configuration parameter eapTemplate is malformed. Exception message is: '$2$'.";
            }
            case 52: {
                return "EAP template at '$1$' does not exist or cannot be read. Check the value of the configuration parameter 'eapTemplate' and ensure that: a) it contains the path to the template file and b) the file can be read by ShapeChange.";
            }
            case 53: {
                return "Exception encountered when copying EAP template file to output destination. Message is: $1$.";
            }
            case 100: {
                return "The target configuration contains map entries with qualified stereotypes as target types. The following profiles from these map entries are not loaded: $1$. That is only an issue if the actual encoding attempts to use map entries with these profiles.";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

