/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.EA;

import com.google.common.collect.HashMultimap;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.OclConstraint;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Stereotypes;
import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Model.TextConstraint;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SingleTarget;
import de.interactive_instruments.ShapeChange.Util.ea.EAAggregation;
import de.interactive_instruments.ShapeChange.Util.ea.EAAttributeUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAConnectorEndUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAConnectorUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EADirection;
import de.interactive_instruments.ShapeChange.Util.ea.EAElementUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAException;
import de.interactive_instruments.ShapeChange.Util.ea.EANavigable;
import de.interactive_instruments.ShapeChange.Util.ea.EARepositoryUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EATaggedValue;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.sparx.Attribute;
import org.sparx.Collection;
import org.sparx.Connector;
import org.sparx.ConnectorEnd;
import org.sparx.CreateModelType;
import org.sparx.Element;
import org.sparx.Package;
import org.sparx.Repository;

public class UmlModel
implements SingleTarget,
MessageSource {
    private static boolean initialised = false;
    private static String outputFilename = null;
    private static String documentationTemplate = null;
    private static String documentationNoValue = null;
    private static String author = null;
    private static String status = null;
    private static String outputPackageName = null;
    private static boolean includeAssociationEndOwnership = false;
    private static boolean mergeConstraintCommentsIntoText = false;
    private static Pattern ignoreTaggedValuesPattern = null;
    private static boolean synchronizeStereotypes = true;
    private static boolean preservePackageHierarchy = false;
    private static Repository rep = null;
    private static Integer pOut_EaPkgId = null;
    private static String pOut_EaPkgName = null;
    private static Set<AssociationInfo> associations = new HashSet<AssociationInfo>();
    private static Map<ClassInfo, Integer> elementIdByClassInfo = new HashMap<ClassInfo, Integer>();
    private static HashMultimap<ClassInfo, ClassInfo> generalisations = HashMultimap.create();
    private static List<ClassInfo> classesToProcess = new ArrayList<ClassInfo>();
    private static Map<PackageInfo, Integer> eaPkgIdByPackageInfo = new HashMap<PackageInfo, Integer>();
    private static Map<String, String> stereotypeMappings = new HashMap<String, String>();
    private static Set<String> profilesWhoseLoadingStatusWasChecked = new HashSet<String>();
    private static Set<String> profilesNotLoaded = new HashSet<String>();
    private Model model = null;
    private Options options = null;
    private ShapeChangeResult result = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        PackageInfo pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        if (!initialised) {
            String outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
            if (outputDirectory == null) {
                outputDirectory = this.options.parameter("outputDirectory");
            }
            if (outputDirectory == null) {
                outputDirectory = ".";
            }
            outputFilename = this.options.parameterAsString(this.getClass().getName(), "modelFilename", "ShapeChangeExport.eap", false, true);
            outputPackageName = this.options.parameterAsString(this.getClass().getName(), "outputPackageName", "ShapeChangeOutput", false, true);
            documentationTemplate = this.options.parameter(this.getClass().getName(), "documentationTemplate");
            documentationNoValue = this.options.parameter(this.getClass().getName(), "documentationNoValue");
            author = this.options.parameterAsString(this.getClass().getName(), "eaAuthor", null, false, true);
            status = this.options.parameterAsString(this.getClass().getName(), "eaStatus", null, false, true);
            includeAssociationEndOwnership = this.options.parameterAsBoolean(this.getClass().getName(), "includeAssociationEndOwnership", false);
            mergeConstraintCommentsIntoText = this.options.parameterAsBoolean(this.getClass().getName(), "mergeConstraintCommentsIntoText", false);
            synchronizeStereotypes = this.options.parameterAsBoolean(this.getClass().getName(), "synchronizeStereotypes", true);
            preservePackageHierarchy = this.options.parameterAsBoolean(this.getClass().getName(), "preservePackageHierarchy", false);
            try {
                String itvpParam = this.options.parameterAsString(UmlModel.class.getName(), "ignoreTaggedValuesRegex", null, true, false);
                ignoreTaggedValuesPattern = itvpParam == null ? null : Pattern.compile(itvpParam);
            }
            catch (PatternSyntaxException e) {
                this.result.addError(this, 54, "ignoreTaggedValuesRegex", e.getMessage());
                ignoreTaggedValuesPattern = null;
            }
            File repfile = null;
            File outDir = new File(outputDirectory);
            if (!outDir.exists()) {
                try {
                    FileUtils.forceMkdir((File)outDir);
                }
                catch (IOException e) {
                    String errormsg = e.getMessage();
                    r.addError(null, 32, errormsg, outputDirectory);
                    return;
                }
            }
            repfile = new File(outDir, outputFilename);
            boolean ex = true;
            rep = new Repository();
            if (!repfile.exists()) {
                ex = false;
                if (!outputFilename.toLowerCase().endsWith(".eap")) {
                    outputFilename = outputFilename + ".eap";
                    repfile = new File(outputFilename);
                    ex = repfile.exists();
                }
            }
            String absname = repfile.getAbsolutePath();
            if (!ex) {
                String eapTemplateFilePath = this.options.parameter(this.getClass().getName(), "eapTemplate");
                if (eapTemplateFilePath != null) {
                    if (eapTemplateFilePath.toLowerCase().startsWith("http")) {
                        try {
                            URL templateUrl = new URL(eapTemplateFilePath);
                            FileUtils.copyURLToFile((URL)templateUrl, (File)repfile);
                        }
                        catch (MalformedURLException e1) {
                            this.result.addFatalError(this, 51, eapTemplateFilePath, e1.getMessage());
                            throw new ShapeChangeAbortException();
                        }
                        catch (IOException e2) {
                            this.result.addFatalError(this, 53, e2.getMessage());
                            throw new ShapeChangeAbortException();
                        }
                    } else {
                        File eaptemplate = new File(eapTemplateFilePath);
                        if (!eaptemplate.exists()) {
                            this.result.addFatalError(this, 52, eaptemplate.getAbsolutePath());
                            throw new ShapeChangeAbortException();
                        }
                        try {
                            FileUtils.copyFile((File)eaptemplate, (File)repfile);
                        }
                        catch (IOException e) {
                            this.result.addFatalError(this, 53, e.getMessage());
                            throw new ShapeChangeAbortException();
                        }
                    }
                } else if (!rep.CreateModel(CreateModelType.cmEAPFromBase, absname, 0)) {
                    r.addError(null, 31, absname);
                    rep = null;
                    return;
                }
            }
            if (!rep.OpenFile(absname)) {
                String errormsg = rep.GetLastError();
                r.addError(null, 30, errormsg, outputFilename);
                rep = null;
                return;
            }
            EARepositoryUtil.setEABatchAppend(rep, true);
            EARepositoryUtil.setEAEnableUIUpdates(rep, false);
            rep.RefreshModelView(0);
            Collection c = rep.GetModels();
            Package root = (Package)c.GetAt((short)0);
            boolean omitOutputPackage = this.options.parameterAsBoolean(this.getClass().getName(), "omitOutputPackage", false);
            if (!omitOutputPackage) {
                Package pOut;
                boolean omitOutputPackageDateTime = this.options.parameterAsBoolean(this.getClass().getName(), "omitOutputPackageDateTime", false);
                if (!omitOutputPackageDateTime) {
                    TimeZone tz = TimeZone.getTimeZone("UTC");
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
                    df.setTimeZone(tz);
                    outputPackageName = outputPackageName + "-" + df.format(new Date());
                }
                if (!(pOut = (Package)root.GetPackages().AddNew(outputPackageName, "Class View")).Update()) {
                    this.result.addError("EA-Fehler: " + pOut.GetLastError());
                }
                if (author != null) {
                    try {
                        EAElementUtil.setEAAuthor(pOut.GetElement(), author);
                    }
                    catch (EAException e) {
                        this.result.addError(this, 10011);
                    }
                }
                if (status != null) {
                    try {
                        EAElementUtil.setEAStatus(pOut.GetElement(), status);
                    }
                    catch (EAException e) {
                        this.result.addError(this, 10012);
                    }
                }
                pOut_EaPkgId = pOut.GetPackageID();
                pOut_EaPkgName = outputPackageName;
            } else {
                pOut_EaPkgId = root.GetPackageID();
                pOut_EaPkgName = root.GetName();
            }
            List<ProcessMapEntry> mapEntries = this.options.getCurrentProcessConfig().getMapEntries();
            for (ProcessMapEntry me : mapEntries) {
                if (!"stereotype".equalsIgnoreCase(me.getParam())) continue;
                stereotypeMappings.put(me.getType().toLowerCase(Locale.ENGLISH), me.getTargetType());
            }
            initialised = true;
        }
        if (rep == null) return;
        if (pOut_EaPkgId == null) return;
        if (!initialised) {
            return;
        }
        try {
            if (preservePackageHierarchy) {
                int ownerPkgEaPkgId = this.createPackageHierarchy(pi);
                if (eaPkgIdByPackageInfo.containsKey(pi)) return;
                this.clonePackage(pi, ownerPkgEaPkgId);
                return;
            }
            this.clonePackage(pi, pOut_EaPkgId);
            return;
        }
        catch (EAException e) {
            this.result.addError(this, 100007, pi.name(), e.getMessage());
        }
    }

    private int createPackageHierarchy(PackageInfo pi) throws EAException {
        int result = pOut_EaPkgId;
        Queue<PackageInfo> hierarchy = Collections.asLifoQueue(new LinkedList());
        PackageInfo currentPackage = pi;
        while (currentPackage.owner() != null) {
            hierarchy.add(currentPackage.owner());
            currentPackage = currentPackage.owner();
        }
        while (!hierarchy.isEmpty()) {
            int newPkgId;
            PackageInfo pkg = (PackageInfo)hierarchy.poll();
            if (eaPkgIdByPackageInfo.containsKey(pkg)) {
                result = eaPkgIdByPackageInfo.get(pkg);
                continue;
            }
            if (pkg.name().equals(pOut_EaPkgName)) {
                eaPkgIdByPackageInfo.put(pkg, pOut_EaPkgId);
                result = pOut_EaPkgId;
                continue;
            }
            result = newPkgId = EARepositoryUtil.createEAPackage(rep, pkg, result);
            Package eaPkg = rep.GetPackageByID(newPkgId);
            this.cloneStandarddItems(eaPkg.GetElement(), pkg);
            eaPkgIdByPackageInfo.put(pkg, newPkgId);
        }
        return result;
    }

    private void clonePackage(PackageInfo pSource, Integer containerEaPkgId) throws EAException {
        int newPkgId = EARepositoryUtil.createEAPackage(rep, pSource, containerEaPkgId);
        Package pkg = rep.GetPackageByID(newPkgId);
        this.cloneStandarddItems(pkg.GetElement(), pSource);
        eaPkgIdByPackageInfo.put(pSource, newPkgId);
        for (PackageInfo cpi : pSource.containedPackages()) {
            this.clonePackage(cpi, pkg.GetPackageID());
        }
    }

    @Override
    public void process(ClassInfo ci) {
        classesToProcess.add(ci);
    }

    private void cloneClass(ClassInfo ci) throws EAException {
        ClassInfo cix;
        Integer pkgID = eaPkgIdByPackageInfo.get(ci.pkg());
        if (pkgID == null) {
            this.result.addError("Missing package information for class " + ci.fullName());
            return;
        }
        Package pkg = rep.GetPackageByID(pkgID.intValue());
        if (pkg == null) {
            this.result.addError("Missing package information for class " + ci.fullName());
            return;
        }
        Element e = EARepositoryUtil.createEAClass(rep, ci.name(), pkgID);
        elementIdByClassInfo.put(ci, e.GetElementID());
        this.cloneStandarddItems(e, ci);
        if (ci.getLinkedDocument() != null) {
            EAElementUtil.loadLinkedDocument(e, ci.getLinkedDocument().getAbsolutePath());
        }
        if (ci.isAbstract()) {
            EAElementUtil.setEAAbstract(e, true);
        }
        for (Constraint constr : ci.directConstraints()) {
            String type = this.determineConstraintType(constr);
            String text = this.determineConstraintText(constr);
            EAElementUtil.addConstraint(e, constr.name(), type, text);
        }
        for (PropertyInfo propi : ci.properties().values()) {
            if (propi.isAttribute()) {
                this.cloneAttribute(e, propi);
                continue;
            }
            associations.add(propi.association());
        }
        for (String tid : ci.supertypes()) {
            cix = this.model.classById(tid);
            if (cix == null) {
                this.result.addError(this, 101, tid, ci.name());
                continue;
            }
            if (!this.model.isInSelectedSchemas(cix)) {
                this.result.addError(this, 102, cix.name(), ci.name());
                continue;
            }
            generalisations.put((Object)ci, (Object)cix);
        }
        for (String tid : ci.subtypes()) {
            cix = this.model.classById(tid);
            if (cix == null) {
                this.result.addError(this, 103, tid, ci.name());
                continue;
            }
            if (!this.model.isInSelectedSchemas(cix)) {
                this.result.addError(this, 104, cix.name(), ci.name());
                continue;
            }
            generalisations.put((Object)cix, (Object)ci);
        }
        if (ci.isAssocClass() != null) {
            // empty if block
        }
    }

    private String determineConstraintText(Constraint constr) {
        OclConstraint oclCon;
        Object text = constr.text();
        if (mergeConstraintCommentsIntoText && constr instanceof OclConstraint && (oclCon = (OclConstraint)constr).hasComments()) {
            String[] comments = oclCon.comments();
            ArrayList<CallSite> commentsToMerge = new ArrayList<CallSite>();
            for (String comment : comments) {
                if (((String)text).contains(comment)) continue;
                commentsToMerge.add((CallSite)((Object)("/* " + comment + " */")));
            }
            String merged = String.join((CharSequence)" ", commentsToMerge);
            if (StringUtils.isNotBlank((CharSequence)merged)) {
                text = merged + " " + (String)text;
            }
        }
        return text;
    }

    private String determineConstraintType(Constraint constr) {
        String type = "OCL";
        if (constr instanceof TextConstraint && StringUtils.isBlank((CharSequence)(type = ((TextConstraint)constr).type()))) {
            type = "Text";
        }
        return type;
    }

    private void cloneAttribute(Element e, PropertyInfo propi) {
        try {
            List<EATaggedValue> taggedValues = EATaggedValue.fromTaggedValues(this.filterTaggedValues(propi.taggedValuesAll()));
            Attribute att = EAElementUtil.createEAAttribute(e, propi.name(), propi.aliasName(), propi.derivedDocumentation(documentationTemplate, documentationNoValue), this.mapStereotypes(propi.stereotypes()).asSet(), taggedValues, propi.isDerived(), propi.isOrdered(), !propi.isUnique(), propi.initialValue(), propi.isReadOnly(), propi.cardinality(), propi.typeInfo().name, null);
            for (Constraint constr : propi.constraints()) {
                String type = this.determineConstraintType(constr);
                String text = this.determineConstraintText(constr);
                EAAttributeUtil.addConstraint(att, constr.name(), type, text);
            }
        }
        catch (EAException exc) {
            this.result.addError(this, 10002, propi.name(), propi.inClass().name(), exc.getMessage());
        }
    }

    private TaggedValues filterTaggedValues(TaggedValues taggedValues) {
        if (ignoreTaggedValuesPattern == null) {
            return taggedValues;
        }
        TaggedValues tvsToWrite = this.options.taggedValueFactory();
        for (String tagName : taggedValues.keySet()) {
            if (ignoreTaggedValuesPattern.matcher(tagName).matches()) continue;
            tvsToWrite.put(tagName, taggedValues.get(tagName));
        }
        return tvsToWrite;
    }

    private Stereotypes mapStereotypes(Stereotypes stereotypes) {
        if (stereotypeMappings.isEmpty()) {
            return stereotypes;
        }
        Stereotypes res = this.options.stereotypesFactory();
        for (String stereotype : stereotypes.asSet()) {
            if (stereotypeMappings.containsKey(stereotype)) {
                String mappingTarget = stereotypeMappings.get(stereotype);
                if (mappingTarget.contains("::")) {
                    String profile = mappingTarget.split("::")[0];
                    if (!profilesWhoseLoadingStatusWasChecked.contains(profile)) {
                        if (!rep.IsTechnologyLoaded(profile)) {
                            profilesNotLoaded.add(profile);
                        }
                        profilesWhoseLoadingStatusWasChecked.add(profile);
                    }
                    if (profilesNotLoaded.contains(profile)) {
                        this.result.addError(this, 106, profile, stereotype);
                    }
                }
                res.add(mappingTarget);
                continue;
            }
            res.add(stereotype);
        }
        return res;
    }

    private void cloneStandarddItems(Element e, Info i) {
        try {
            if (author != null) {
                EAElementUtil.setEAAuthor(e, author);
            }
            if (status != null) {
                EAElementUtil.setEAStatus(e, status);
            }
            EAElementUtil.setEAAlias(e, i.aliasName());
            EAElementUtil.setEANotes(e, i.derivedDocumentation(documentationTemplate, documentationNoValue));
            EAElementUtil.setEAStereotypeEx(e, this.mapStereotypes(i.stereotypes()).toString());
            EAElementUtil.setTaggedValues(e, this.filterTaggedValues(i.taggedValuesAll()));
            e.Refresh();
        }
        catch (EAException exc) {
            this.result.addError(this, 10003, i.name(), exc.getMessage());
        }
    }

    private void cloneStandardItems(Connector con, Info i) {
        try {
            EAConnectorUtil.setEAAlias(con, i.aliasName());
            EAConnectorUtil.setEANotes(con, i.derivedDocumentation(documentationTemplate, documentationNoValue));
            EAConnectorUtil.setEAStereotypeEx(con, this.mapStereotypes(i.stereotypes()).toString());
            EAConnectorUtil.setTaggedValues(con, this.filterTaggedValues(i.taggedValuesAll()));
        }
        catch (EAException exc) {
            this.result.addError(this, 10004, i.name() == null || i.name().trim().length() == 0 ? "<without_name>" : i.name(), exc.getMessage());
        }
    }

    private void cloneStandardItems(ConnectorEnd ce, PropertyInfo i) {
        try {
            EAConnectorEndUtil.setEARole(ce, i.name());
            EAConnectorEndUtil.setEAAlias(ce, i.aliasName());
            Multiplicity m = i.cardinality();
            if (m.minOccurs == 1 && m.maxOccurs == 1) {
                EAConnectorEndUtil.setEACardinality(ce, "");
            } else if (m.maxOccurs == Integer.MAX_VALUE) {
                EAConnectorEndUtil.setEACardinality(ce, m.minOccurs + "..*");
            } else {
                EAConnectorEndUtil.setEACardinality(ce, m.minOccurs + ".." + m.maxOccurs);
            }
            EAConnectorEndUtil.setEARole(ce, i.name());
            if (i.isNavigable() && i.reverseProperty().isNavigable()) {
                EAConnectorEndUtil.setEANavigable(ce, EANavigable.UNSPECIFIED);
            } else if (i.isNavigable()) {
                EAConnectorEndUtil.setEANavigable(ce, EANavigable.NAVIGABLE);
            } else {
                EAConnectorEndUtil.setEANavigable(ce, EANavigable.NONNAVIGABLE);
            }
            EAConnectorEndUtil.setEARoleNote(ce, i.derivedDocumentation(documentationTemplate, documentationNoValue));
            EAConnectorEndUtil.setEAStereotypeEx(ce, this.mapStereotypes(i.stereotypes()).toString());
            EAConnectorEndUtil.setEAOrdering(ce, i.isOrdered());
            EAConnectorEndUtil.setEAAllowDuplicates(ce, !i.isUnique());
            if (includeAssociationEndOwnership && i.isOwned()) {
                EAConnectorEndUtil.setEAOwnedByClassifier(ce, true);
            }
            EAConnectorEndUtil.setEADerived(ce, i.isDerived());
            if (i.reverseProperty() != null) {
                if (i.reverseProperty().isAggregation()) {
                    EAConnectorEndUtil.setEAAggregation(ce, EAAggregation.SHARED);
                } else if (i.reverseProperty().isComposition()) {
                    EAConnectorEndUtil.setEAAggregation(ce, EAAggregation.COMPOSITE);
                }
            }
            EAConnectorEndUtil.setTaggedValues(ce, this.filterTaggedValues(i.taggedValuesAll()));
        }
        catch (EAException exc) {
            this.result.addError(this, 10004, i.name() == null || i.name().trim().length() == 0 ? "<without_name>" : i.name(), exc.getMessage());
        }
    }

    @Override
    public void write() {
    }

    @Override
    public String getTargetName() {
        return "UML Model";
    }

    @Override
    public void writeAll(ShapeChangeResult r) {
        this.result = r;
        this.options = r.options();
        if (rep == null || !initialised) {
            this.result.addError(this, 50);
            return;
        }
        for (ClassInfo ci : classesToProcess) {
            this.model = ci.model();
            try {
                this.cloneClass(ci);
            }
            catch (EAException e) {
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 10008, ci.name(), e.getMessage());
                if (mc == null) continue;
                mc.addDetail(this, 1, ci.fullNameInSchema());
            }
        }
        for (AssociationInfo ai : associations) {
            PropertyInfo propi1 = ai.end1();
            PropertyInfo propi2 = ai.end2();
            ClassInfo ci1 = propi1.inClass();
            ClassInfo ci2 = propi2.inClass();
            if (elementIdByClassInfo.get(ci1) == null) {
                this.result.addWarning("Association between " + ci1.name() + " - " + ci2.name() + " not set as the first class is not part of target model.");
                continue;
            }
            if (elementIdByClassInfo.get(ci2) == null) {
                this.result.addWarning("Association between " + ci1.name() + " - " + ci2.name() + " not set as the second class is not part of target model.");
                continue;
            }
            int c1ElementId = elementIdByClassInfo.get(ci1);
            int c2ElementId = elementIdByClassInfo.get(ci2);
            Element c1 = rep.GetElementByID(c1ElementId);
            Element c2 = rep.GetElementByID(c2ElementId);
            if (c1 == null) {
                this.result.addWarning("Association between " + ci1.name() + " - " + ci2.name() + " not set as the first class is not part of target model.");
                continue;
            }
            if (c2 == null) {
                this.result.addWarning("Association between " + ci1.name() + " - " + ci2.name() + " not set as the second class is not part of target model.");
                continue;
            }
            c1.Refresh();
            Collection c1Conns = c1.GetConnectors();
            c1Conns.Refresh();
            Connector con = (Connector)c1Conns.AddNew(StringUtils.isBlank((CharSequence)ai.name()) ? "" : ai.name(), "Association");
            try {
                EAConnectorUtil.setEASupplierID(con, c2.GetElementID());
                EAConnectorUtil.setEADirection(con, EADirection.BIDIRECTIONAL);
            }
            catch (EAException e1) {
                this.result.addError(this, 10009, StringUtils.isBlank((CharSequence)ai.name()) ? "<unnamed>" : ai.name(), ci1.name(), ci2.name(), e1.getMessage());
            }
            c1.GetConnectors().Refresh();
            this.cloneStandardItems(con, ai);
            this.cloneStandardItems(con.GetClientEnd(), propi2);
            this.cloneStandardItems(con.GetSupplierEnd(), propi1);
            ClassInfo assocClassCi = ai.assocClass();
            if (assocClassCi == null) continue;
            int assocClassElementId = elementIdByClassInfo.get(assocClassCi);
            Element assocClass = rep.GetElementByID(assocClassElementId);
            if (assocClass == null) {
                this.result.addError(this, 10006, assocClassCi.name(), ci1.name(), ci2.name());
                continue;
            }
            try {
                EAConnectorUtil.setEAAssociationClass(con, assocClass);
            }
            catch (EAException e) {
                this.result.addError(this, 10005, assocClassCi.name(), ci1.name(), ci2.name(), e.getMessage());
            }
        }
        for (ClassInfo subtype : generalisations.keySet()) {
            for (ClassInfo supertype : generalisations.get((Object)subtype)) {
                Integer c1ElementId = elementIdByClassInfo.get(subtype);
                Integer c2ElementId = elementIdByClassInfo.get(supertype);
                if (c1ElementId == null) {
                    this.result.addWarning(this, 105, subtype.name(), supertype.name(), subtype.name());
                    continue;
                }
                if (c2ElementId == null) {
                    this.result.addWarning(this, 105, subtype.name(), supertype.name(), supertype.name());
                    continue;
                }
                Element c1 = rep.GetElementByID(c1ElementId.intValue());
                Element c2 = rep.GetElementByID(c2ElementId.intValue());
                if (c1 == null) {
                    this.result.addWarning(this, 105, subtype.name(), supertype.name(), subtype.name());
                    continue;
                }
                if (c2 == null) {
                    this.result.addWarning(this, 105, subtype.name(), supertype.name(), supertype.name());
                    continue;
                }
                c1.Refresh();
                Collection c1Conns = c1.GetConnectors();
                c1Conns.Refresh();
                Connector con = (Connector)c1Conns.AddNew("", "Generalization");
                try {
                    EAConnectorUtil.setEASupplierID(con, c2.GetElementID());
                }
                catch (EAException e) {
                    this.result.addError(this, 10010, subtype.name(), supertype.name(), e.getMessage());
                }
                c1.GetConnectors().Refresh();
            }
        }
        if (synchronizeStereotypes) {
            for (String stType : stereotypeMappings.keySet()) {
                String stTargetType = stereotypeMappings.get(stType);
                if (!stTargetType.contains("::")) continue;
                String[] components = stTargetType.split("::");
                rep.SynchProfile(components[0], components[1]);
            }
        }
        EARepositoryUtil.closeRepository(rep);
        rep = null;
    }

    @Override
    public void reset() {
        initialised = false;
        outputFilename = null;
        rep = null;
        pOut_EaPkgId = null;
        pOut_EaPkgName = null;
        associations = new HashSet<AssociationInfo>();
        elementIdByClassInfo = new HashMap<ClassInfo, Integer>();
        eaPkgIdByPackageInfo = new HashMap<PackageInfo, Integer>();
        classesToProcess = new ArrayList<ClassInfo>();
        generalisations = HashMultimap.create();
        stereotypeMappings = new HashMap<String, String>();
        profilesWhoseLoadingStatusWasChecked = new HashSet<String>();
        profilesNotLoaded = new HashSet<String>();
        includeAssociationEndOwnership = false;
        mergeConstraintCommentsIntoText = false;
        ignoreTaggedValuesPattern = null;
        synchronizeStereotypes = true;
        preservePackageHierarchy = false;
        author = null;
        status = null;
        outputPackageName = null;
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
    }

    @Override
    public String getTargetIdentifier() {
        return "uml";
    }

    @Override
    public String getDefaultEncodingRule() {
        return "*";
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class UmlModel";
            }
            case 1: {
                return "Context: class $1$";
            }
            case 50: {
                return "Could not write the model, because the target has not been initialized properly.";
            }
            case 51: {
                return "URL '$1$' provided for configuration parameter eapTemplate is malformed. Execution will be aborted. Exception message is: '$2$'.";
            }
            case 52: {
                return "EAP template at '$1$' does not exist or cannot be read. Check the value of the configuration parameter 'eapTemplate' and ensure that: a) it contains the path to the template file and b) the file can be read by ShapeChange.";
            }
            case 53: {
                return "Exception encountered when copying EAP template file to output destination. Message is: $1$.";
            }
            case 54: {
                return "Syntax exception while compiling the regular expression defined by target parameter '$1$': '$2$'.";
            }
            case 101: {
                return "Supertype with id '$1$' of class '$2$' was not found in the model.";
            }
            case 102: {
                return "Supertype '$1$' of class '$2$' is not part of the schemas selected for processing. The generalization relationship will not be created.";
            }
            case 103: {
                return "Subtype with id '$1$' of class '$2$' was not found in the model.";
            }
            case 104: {
                return "Subtype '$1$' of class '$2$' is not part of the schemas selected for processing. The generalization relationship will not be created.";
            }
            case 105: {
                return "Generalisation relationship between subtype '$1$' and supertype '$2$' cannot be created because '$3$' is not part of the target model.";
            }
            case 106: {
                return "??Profile '$1$', configured to be used in the mapping of stereotype '$2$', is not loaded in the EA repository. The stereotype will not be assigned correctly in the EA repository. Make sure to load the profile into the EA repository that will be used as output file (typically the template file, configured via target parameter 'eapTemplate').";
            }
            case 10001: {
                return "EA exception encountered: $1$";
            }
            case 10002: {
                return "EA exception encountered while cloning attribute '$1$' of class '$2$'. Error message: $3$";
            }
            case 10003: {
                return "EA exception encountered while cloning standard items for model element (class or package) '$1$'. Error message: $2$";
            }
            case 10004: {
                return "EA exception encountered while cloning standard items for association '$1$'. Error message: $2$";
            }
            case 10005: {
                return "EA exception encountered while establishing the association class relationship between class '$1$' and the association between classes '$2$' and '$3$'. Error message: $4$";
            }
            case 10006: {
                return "Relationship between association class '$1$' and the association between classes '$2$' and '$3$' could not be established because the association class '$1$' is not part of the target model.";
            }
            case 10007: {
                return "EA exception encountered while cloning package '$1$'. Error message: $2$";
            }
            case 10008: {
                return "EA exception encountered while cloning class '$1$'. Error message: $2$";
            }
            case 10009: {
                return "EA exception encountered while updating association '$1$' between classes '$2$' and '$3$'. Exception message is: $4$";
            }
            case 10010: {
                return "EA exception encountered while updating generalisation relationship between classes '$1$' (subtype) and '$2$' (supertype). Exception message is: $4$";
            }
            case 10011: {
                return "EA exception encountered while updating the author of the 'ShapeChangeOutput' package).";
            }
            case 10012: {
                return "EA exception encountered while updating the status of the 'ShapeChangeOutput' package).";
            }
        }
        return "(" + UmlModel.class.getName() + ") Unknown message with number: " + mnr;
    }
}

