/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Definitions;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Target;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.SortedSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class Definitions
implements Target {
    public static final String DEF_NS = "http://www.interactive-instruments.de/ShapeChange/Definitions/0.5";
    public static final String PARAM_STYLE = "style";
    public static final String PARAM_INSTANCE_VIEW = "instanceView";
    public static final String PARAM_NAMING_AUTHORITY = "namingAuthority";
    private PackageInfo pi = null;
    private Model model = null;
    private Options options = null;
    private ShapeChangeResult result = null;
    private boolean printed = false;
    private Document document = null;
    private final HashMap<String, Document> documentMap = new HashMap();
    private Element root = null;
    private String outputDirectory = null;
    private boolean schema = true;
    private boolean instanceView = false;
    private String namingAuthority = null;
    private boolean diagnosticsOnly = false;
    private boolean aborted = false;
    private String documentationTemplate = null;
    private String documentationNoValue = null;

    @Override
    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        Element e1;
        String s;
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        this.diagnosticsOnly = diagOnly;
        this.outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter("outputDirectory");
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter(".");
        }
        if (this.options.parameter(this.getClass().getName(), PARAM_STYLE).equals("TYPE")) {
            this.schema = false;
        }
        if (this.options.parameter(this.getClass().getName(), PARAM_INSTANCE_VIEW).equals("true")) {
            this.instanceView = true;
        }
        this.namingAuthority = this.options.parameter(this.getClass().getName(), PARAM_NAMING_AUTHORITY);
        if (this.namingAuthority == null) {
            this.namingAuthority = "UNKNOWN";
        }
        if (!this.options.gmlVersion.equals("3.2")) {
            this.result.addError(null, 110, this.pi.name());
            this.aborted = true;
            return;
        }
        this.documentationTemplate = this.options.parameter(this.getClass().getName(), "documentationTemplate");
        this.documentationNoValue = this.options.parameter(this.getClass().getName(), "documentationNoValue");
        this.result.addDebug(null, 10005, this.pi.name());
        this.document = this.createDocument();
        ProcessingInstruction proci = this.document.createProcessingInstruction("xml-stylesheet", "type='text/xsl' href='./ShapeChangeDefinitions.xsl'");
        this.document.appendChild(proci);
        this.root = this.document.createElementNS(DEF_NS, "ApplicationSchemaDefinition");
        this.document.appendChild(this.root);
        this.addAttribute(this.document, this.root, "gml:id", "_");
        this.addAttribute(this.document, this.root, "xmlns:gml", this.options.GML_NS);
        this.addAttribute(this.document, this.root, "xmlns:def", DEF_NS);
        this.addAttribute(this.document, this.root, "xmlns:xlink", "http://www.w3.org/1999/xlink");
        this.addAttribute(this.document, this.root, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.addAttribute(this.document, this.root, "xsi:schemaLocation", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.5 ShapeChangeDefinitions.xsd");
        if (this.instanceView) {
            this.addAttribute(this.document, this.root, PARAM_INSTANCE_VIEW, "true");
        }
        if ((s = this.pi.derivedDocumentation(this.documentationTemplate, this.documentationNoValue)) != null && !s.isEmpty()) {
            e1 = this.document.createElementNS(this.options.GML_NS, "description");
            e1.appendChild(this.document.createTextNode(s));
            this.root.appendChild(e1);
        }
        e1 = this.document.createElementNS(this.options.GML_NS, "identifier");
        e1.appendChild(this.document.createTextNode("urn:x-shapechange:def:applicationSchema:" + this.namingAuthority + "::" + this.pi.xmlns() + ":" + this.pi.version()));
        this.addAttribute(this.document, e1, "codeSpace", "http://www.interactive-instruments.de/ShapeChange");
        this.root.appendChild(e1);
        e1 = this.document.createElementNS(this.options.GML_NS, "name");
        e1.appendChild(this.document.createTextNode(this.pi.name()));
        this.root.appendChild(e1);
    }

    protected void addAttribute(Document document, Element e, String name, String value) {
        Attr att = document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    protected Document createDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(null, 2);
            String m = e.getMessage();
            if (m != null) {
                this.result.addFatalError(m);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            this.result.addFatalError(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        return document;
    }

    @Override
    public void process(ClassInfo ci) {
        if (this.aborted) {
            return;
        }
        int cat = ci.category();
        if (cat != 1 && cat != 6 && cat != 4 && cat != 5 && cat != 7 && cat != 8) {
            return;
        }
        if (this.instanceView && ci.isAbstract()) {
            return;
        }
        String t = "featureType";
        if (cat == 6) {
            t = "objectType";
        } else if (cat == 5) {
            t = "dataType";
        } else if (cat == 4) {
            t = "mixinType";
        } else if (cat == 7) {
            t = "basicType";
        } else if (cat == 8) {
            t = "unionType";
        }
        if (this.schema) {
            Element e1 = this.document.createElementNS(this.options.GML_NS, "dictionaryEntry");
            this.root.appendChild(e1);
            Element e2 = this.createTypeDefinition(this.pi, this.document, ci, t);
            e1.appendChild(e2);
        } else {
            Document cDocument = this.createDocument();
            ProcessingInstruction proci = cDocument.createProcessingInstruction("xml-stylesheet", "type='text/xsl' href='./ShapeChangeDefinitionsType.xsl'");
            cDocument.appendChild(proci);
            Element ec = this.createTypeDefinition(this.pi, cDocument, ci, t);
            cDocument.appendChild(ec);
            this.addAttribute(cDocument, ec, "xmlns:gml", this.options.GML_NS);
            this.addAttribute(cDocument, ec, "xmlns:def", DEF_NS);
            this.addAttribute(cDocument, ec, "xmlns:xlink", "http://www.w3.org/1999/xlink");
            this.addAttribute(cDocument, ec, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.addAttribute(cDocument, ec, "xsi:schemaLocation", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.5 ShapeChangeDefinitions.xsd");
            this.documentMap.put(ci.id(), cDocument);
            Element e1 = this.document.createElementNS(this.options.GML_NS, "dictionaryEntry");
            this.addAttribute(this.document, e1, "xlink:href", "urn:x-shapechange:def:" + t + ":" + this.namingAuthority + "::" + this.pi.xmlns() + ":" + this.pi.version() + ":" + ci.name());
            this.root.appendChild(e1);
        }
    }

    private Element createTypeDefinition(PackageInfo asi, Document lDocument, ClassInfo ci, String t) {
        Element e2;
        Element e1 = lDocument.createElementNS(DEF_NS, "TypeDefinition");
        this.addAttribute(lDocument, e1, "gml:id", ci.id());
        String s = ci.derivedDocumentation(this.documentationTemplate, this.documentationNoValue);
        if (s != null && !s.isEmpty()) {
            e2 = lDocument.createElementNS(this.options.GML_NS, "description");
            e2.appendChild(lDocument.createTextNode(s));
            e1.appendChild(e2);
        }
        e2 = lDocument.createElementNS(this.options.GML_NS, "identifier");
        e2.appendChild(lDocument.createTextNode("urn:x-shapechange:def:" + t + ":" + this.namingAuthority + "::" + ci.pkg().xmlns() + ":" + ci.pkg().version() + ":" + ci.name()));
        this.addAttribute(lDocument, e2, "codeSpace", DEF_NS);
        e1.appendChild(e2);
        s = ci.taggedValue("Title");
        if (StringUtils.isNotBlank((CharSequence)s)) {
            e2 = lDocument.createElementNS(this.options.GML_NS, "name");
            this.addAttribute(lDocument, e2, "codeSpace", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.5/title");
            e2.appendChild(lDocument.createTextNode(s));
            e1.appendChild(e2);
        }
        if (StringUtils.isNotBlank((CharSequence)(s = ci.taggedValue("primaryCode")))) {
            e2 = lDocument.createElementNS(this.options.GML_NS, "name");
            this.addAttribute(lDocument, e2, "codeSpace", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.5/primaryCode");
            e2.appendChild(lDocument.createTextNode(s));
            e1.appendChild(e2);
        }
        if (StringUtils.isNotBlank((CharSequence)(s = ci.taggedValue("secondaryCode")))) {
            e2 = lDocument.createElementNS(this.options.GML_NS, "name");
            this.addAttribute(lDocument, e2, "codeSpace", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.5/secondaryCode");
            e2.appendChild(lDocument.createTextNode(s));
            e1.appendChild(e2);
        }
        e2 = lDocument.createElementNS(this.options.GML_NS, "name");
        this.addAttribute(lDocument, e2, "codeSpace", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.5/name");
        e2.appendChild(lDocument.createTextNode(ci.name()));
        e1.appendChild(e2);
        if (this.instanceView) {
            this.createAllPropertyDefinitions(asi, lDocument, ci, e1, true);
        } else {
            for (PropertyInfo propi : ci.properties().values()) {
                e2 = this.createPropertyDefinition(asi, lDocument, ci, propi, true);
                if (e2 == null) continue;
                e1.appendChild(e2);
            }
        }
        e2 = lDocument.createElementNS(DEF_NS, "classification");
        e2.appendChild(lDocument.createTextNode(t));
        e1.appendChild(e2);
        if (!this.instanceView && ci.supertypes() != null) {
            Iterator k = ci.supertypes().iterator();
            while (k.hasNext()) {
                ClassInfo ei = this.model.classById((String)k.next());
                if (ei == null) continue;
                int cate = ei.category();
                if (ei.pkg() != null && ei.inSchema(asi) && (cate == 1 || cate == 6 || cate == 4 || cate == 5 || cate == 7)) {
                    e2 = lDocument.createElementNS(DEF_NS, "supertypeRef");
                    String t0 = "featureType";
                    if (cate == 6) {
                        t0 = "objectType";
                    } else if (cate == 4) {
                        t0 = "mixinType";
                    } else if (cate == 5) {
                        t0 = "dataType";
                    } else if (cate == 7) {
                        t0 = "basicType";
                    }
                    this.addAttribute(lDocument, e2, "xlink:href", "urn:x-shapechange:def:" + t0 + ":" + this.namingAuthority + "::" + ei.pkg().xmlns() + ":" + ei.pkg().version() + ":" + ei.name());
                } else {
                    e2 = lDocument.createElementNS(DEF_NS, "supertypeName");
                    e2.appendChild(lDocument.createTextNode(ei.name()));
                }
                e1.appendChild(e2);
            }
        }
        String[] tags = this.options.parameter("representTaggedValues").split("\\,");
        for (int i = 0; i < tags.length; ++i) {
            s = ci.taggedValue(tags[i].trim());
            if (!StringUtils.isNotBlank((CharSequence)s) || tags[i].trim().equals("primaryCode") || tags[i].trim().equals("secondaryCode")) continue;
            e2 = lDocument.createElementNS(DEF_NS, "taggedValue");
            this.addAttribute(lDocument, e2, "tag", tags[i].trim());
            e2.appendChild(lDocument.createTextNode(s));
            e1.appendChild(e2);
        }
        return e1;
    }

    private Element createPropertyDefinition(PackageInfo asi, Document lDocument, ClassInfo ci, PropertyInfo propi, boolean local) {
        Element e2;
        if (!propi.isNavigable()) {
            return null;
        }
        if (propi.isRestriction()) {
            return null;
        }
        Element e = lDocument.createElementNS(this.options.GML_NS, "dictionaryEntry");
        Element e3 = lDocument.createElementNS(DEF_NS, "PropertyDefinition");
        this.addAttribute(lDocument, e3, "gml:id", propi.id());
        e.appendChild(e3);
        String s = propi.derivedDocumentation(this.documentationTemplate, this.documentationNoValue);
        if (s != null && !s.isEmpty()) {
            e2 = lDocument.createElementNS(this.options.GML_NS, "description");
            e2.appendChild(lDocument.createTextNode(s));
            e3.appendChild(e2);
        }
        e2 = lDocument.createElementNS(this.options.GML_NS, "identifier");
        e2.appendChild(lDocument.createTextNode("urn:x-shapechange:def:propertyType:" + this.namingAuthority + "::" + ci.pkg().xmlns() + ":" + ci.pkg().version() + ":" + ci.name() + ":" + propi.name()));
        this.addAttribute(lDocument, e2, "codeSpace", DEF_NS);
        e3.appendChild(e2);
        s = propi.taggedValue("Title");
        if (StringUtils.isNotBlank((CharSequence)s)) {
            e2 = lDocument.createElementNS(this.options.GML_NS, "name");
            this.addAttribute(lDocument, e2, "codeSpace", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.5/title");
            e2.appendChild(lDocument.createTextNode(s));
            e3.appendChild(e2);
        }
        if (StringUtils.isNotBlank((CharSequence)(s = propi.taggedValue("primaryCode")))) {
            e2 = lDocument.createElementNS(this.options.GML_NS, "name");
            this.addAttribute(lDocument, e2, "codeSpace", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.5/primaryCode");
            e2.appendChild(lDocument.createTextNode(s));
            e3.appendChild(e2);
        }
        if (StringUtils.isNotBlank((CharSequence)(s = propi.taggedValue("secondaryCode")))) {
            e2 = lDocument.createElementNS(this.options.GML_NS, "name");
            this.addAttribute(lDocument, e2, "codeSpace", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.5/secondaryCode");
            e2.appendChild(lDocument.createTextNode(s));
            e3.appendChild(e2);
        }
        e2 = lDocument.createElementNS(this.options.GML_NS, "name");
        this.addAttribute(lDocument, e2, "codeSpace", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.5/name");
        e2.appendChild(lDocument.createTextNode(propi.name()));
        e3.appendChild(e2);
        ClassInfo ei = this.model.classById(propi.typeInfo().id);
        int cate = -1;
        if (ei != null) {
            cate = ei.category();
        }
        if (ei != null && ei.pkg() != null && (cate == 3 || cate == 2)) {
            for (PropertyInfo vi : ei.properties().values()) {
                e2 = lDocument.createElementNS(this.options.GML_NS, "dictionaryEntry");
                e3.appendChild(e2);
                Element e4 = lDocument.createElementNS(DEF_NS, "ListedValueDefinition");
                this.addAttribute(lDocument, e4, "gml:id", propi.id() + "_" + vi.id());
                e2.appendChild(e4);
                s = vi.derivedDocumentation(this.documentationTemplate, this.documentationNoValue);
                if (s != null && !s.isEmpty()) {
                    e2 = lDocument.createElementNS(this.options.GML_NS, "description");
                    e2.appendChild(lDocument.createTextNode(s));
                    e4.appendChild(e2);
                }
                e2 = lDocument.createElementNS(this.options.GML_NS, "identifier");
                if (vi.initialValue() != null) {
                    e2.appendChild(lDocument.createTextNode("urn:x-shapechange:def:propertyType:" + this.namingAuthority + "::" + ci.pkg().xmlns() + ":" + ci.pkg().version() + ":" + ci.name() + ":" + propi.name() + ":" + vi.initialValue()));
                } else {
                    e2.appendChild(lDocument.createTextNode("urn:x-shapechange:def:propertyType:" + this.namingAuthority + "::" + ci.pkg().xmlns() + ":" + ci.pkg().version() + ":" + ci.name() + ":" + propi.name() + ":" + vi.name()));
                }
                this.addAttribute(lDocument, e2, "codeSpace", "http://www.interactive-instruments.de/ShapeChange");
                e4.appendChild(e2);
                e2 = lDocument.createElementNS(this.options.GML_NS, "name");
                e2.appendChild(lDocument.createTextNode(vi.name()));
                e4.appendChild(e2);
            }
        }
        Multiplicity m = propi.cardinality();
        e2 = lDocument.createElementNS(DEF_NS, "cardinality");
        if (m.minOccurs == m.maxOccurs) {
            e2.appendChild(lDocument.createTextNode("" + m.minOccurs));
        } else if (m.maxOccurs == Integer.MAX_VALUE || m.maxOccurs == -1) {
            e2.appendChild(lDocument.createTextNode(m.minOccurs + "..*"));
        } else {
            e2.appendChild(lDocument.createTextNode(m.minOccurs + ".." + m.maxOccurs));
        }
        e3.appendChild(e2);
        if (ei != null && ei.pkg() != null && ei.inSchema(asi) && (cate == 1 || cate == 6 || cate == 4 || cate == 5 || cate == 7 || cate == 8)) {
            e2 = lDocument.createElementNS(DEF_NS, "valueTypeRef");
            String t0 = "featureType";
            if (cate == 6) {
                t0 = "objectType";
            } else if (cate == 4) {
                t0 = "mixinType";
            } else if (cate == 7) {
                t0 = "basicType";
            } else if (cate == 5) {
                t0 = "dataType";
            } else if (cate == 8) {
                t0 = "unionType";
            }
            this.addAttribute(lDocument, e2, "xlink:href", "urn:x-shapechange:def:" + t0 + ":" + this.namingAuthority + "::" + ei.pkg().xmlns() + ":" + ei.pkg().version() + ":" + ei.name());
        } else {
            e2 = lDocument.createElementNS(DEF_NS, "valueTypeName");
            e2.appendChild(lDocument.createTextNode(propi.typeInfo().name));
        }
        e3.appendChild(e2);
        e2 = lDocument.createElementNS(DEF_NS, "type");
        if (propi.isAttribute()) {
            e2.appendChild(lDocument.createTextNode("attribute"));
        } else {
            e2.appendChild(lDocument.createTextNode("associationRole"));
        }
        e3.appendChild(e2);
        return e;
    }

    private void createAllPropertyDefinitions(PackageInfo asi, Document lDocument, ClassInfo ci, Element e1, boolean local) {
        SortedSet<String> st;
        if (ci == null) {
            return;
        }
        if (ci.pkg() == null) {
            this.result.addError(null, 139, ci.name());
        }
        if ((st = ci.supertypes()) != null) {
            Iterator i = st.iterator();
            while (i.hasNext()) {
                this.createAllPropertyDefinitions(asi, lDocument, this.model.classById((String)i.next()), e1, false);
            }
        }
        for (PropertyInfo propi : ci.properties().values()) {
            Element e2 = this.createPropertyDefinition(asi, lDocument, ci, propi, local);
            if (e2 == null) continue;
            e1.appendChild(e2);
        }
    }

    @Override
    public void write() {
        if (this.printed) {
            return;
        }
        if (this.diagnosticsOnly) {
            return;
        }
        if (this.aborted) {
            return;
        }
        Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        outputFormat.setProperty("indent", "yes");
        outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        outputFormat.setProperty("encoding", "UTF-8");
        try {
            File file = new File(this.outputDirectory + "/index." + this.pi.xmlns() + ".definitions.xml");
            FileWriter outputXML = new FileWriter(file);
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            serializer.setWriter((Writer)outputXML);
            serializer.asDOMSerializer().serialize((Node)this.document);
            outputXML.close();
            this.result.addResult(this.getTargetName(), this.outputDirectory, "index." + this.pi.xmlns() + ".definitions.xml", this.pi.targetNamespace());
            if (!this.schema) {
                for (ClassInfo ci : this.model.classes(this.pi)) {
                    Document cDocument = this.documentMap.get(ci.id());
                    if (cDocument == null) continue;
                    outputXML = new FileWriter(this.outputDirectory + "/" + ci.name() + ".definitions.xml");
                    serializer.setWriter((Writer)outputXML);
                    serializer.asDOMSerializer().serialize((Node)cDocument);
                    outputXML.close();
                    this.result.addResult(this.getTargetName(), this.outputDirectory, ci.name() + ".definitions.xml", ci.qname());
                }
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
        this.printed = true;
    }

    @Override
    public String getTargetName() {
        return "Definitions";
    }

    @Override
    public String getTargetIdentifier() {
        return "def";
    }

    @Override
    public String getDefaultEncodingRule() {
        return "*";
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
    }
}

