/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Codelists;

import de.interactive_instruments.ShapeChange.DefaultModelProvider;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.ModelDiff.DiffElement;
import de.interactive_instruments.ShapeChange.ModelDiff.Differ;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SingleTarget;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CodelistRegister
implements SingleTarget {
    public static final String PARAM_ENUMERATIONS = "enumerations";
    public static final String PARAM_BASEURI = "baseURI";
    public static final String PARAM_CONFIG = "config";
    public static final String PARAM_IDENTIFIER = "identifier";
    public static final String PARAM_LABEL = "label";
    public static final String PARAM_DOCUMENTATION = "documentation";
    public static final String PARAM_TITLE = "title";
    public static final String PARAM_DESCRIPTION = "description";
    public static final String PARAM_DATE_TIME_PUBLISHED = "datetimePublished";
    public static final String PARAM_DATE_TIME_UPDATED = "datetimeUpdated";
    public static final String PARAM_AUTHOR = "author";
    public static final String PARAM_XSLT_PATH = "xsltPath";
    public static final String PARAM_XSL_HTML_FILE = "xslhtmlFile";
    public static final String PARAM_XSL_GML_FILE = "xslgmlFile";
    public static final String PARAM_XSL_SKOS_FILE = "xslskosFile";
    public static final String PARAM_XSL_TRANFORMER_FACTORY = "xslTransformerFactory";
    public static final String PARAM_REFERENCE_MODEL_TYPE = "referenceModelType";
    public static final String PARAM_REFERENCE_MODEL_FILE = "referenceModelFile";
    private Model model = null;
    private Options options = null;
    private ShapeChangeResult result = null;
    private boolean diagnosticsOnly = false;
    private static boolean printed = false;
    private static boolean enums = true;
    private static boolean initialised = false;
    private static String baseURI = "http://example.com/fixme/";
    private static String identifier = "initialValue,name";
    private static String label = "name";
    private static String documentation = "notes";
    private static String profiles = null;
    private static String minprofiles = null;
    private static String version = null;
    private static String language = "en";
    private static String regTitle = "FIXME";
    private static String author = "ShapeChange";
    private static String regDescription = "FIXME";
    private static Document rootDocument = null;
    private static Element root = null;
    private static String datetimePub = null;
    private static String datetimeUpd = null;
    private static String xsltPath = "src/main/resources/xslt";
    private static String xslTransformerFactory = null;
    private static String outputDirectory = ".";
    private static TreeMap<String, Document> documentMap = new TreeMap();
    private static SortedMap<Info, SortedSet<DiffElement>> diffs = null;
    private static Differ differ = null;
    private static Model refModel = null;
    private static PackageInfo refPackage = null;
    private static String refVersion = null;
    private static String xslhtmlfileName = "clr-html.xsl";
    private static String xslskosfileName = "clr-skos.xsl";
    private static String xslgmlfileName = "clr-gml.xsl";
    private static final String ATOM_NS = "http://www.w3.org/2005/Atom";
    private static final boolean html = true;
    private static final boolean gml = true;
    private static final boolean skos = true;

    @Override
    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        this.model = m;
        this.options = o;
        this.result = r;
        this.diagnosticsOnly = diagOnly;
        if (!initialised) {
            initialised = true;
            String s = this.options.parameter(this.getClass().getName(), PARAM_ENUMERATIONS);
            if (s != null && s.equalsIgnoreCase("false")) {
                enums = false;
            }
            if ((s = this.options.parameter(this.getClass().getName(), PARAM_BASEURI)) != null && !s.isEmpty()) {
                baseURI = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), PARAM_CONFIG)) != null && !s.isEmpty()) {
                if (s.equalsIgnoreCase("geoinfodok")) {
                    identifier = "initialValue,name";
                    label = "name";
                    documentation = "notes";
                    profiles = "@AAA:Modellart";
                    minprofiles = "@AAA:Grunddatenbestand";
                    language = "de";
                } else if (s.equalsIgnoreCase("geoinfohok")) {
                    identifier = "alias,name";
                    label = "name";
                    documentation = "@name,definition,description";
                    profiles = "@profiles";
                    minprofiles = null;
                    language = "en";
                }
            }
            if ((s = this.options.parameter(this.getClass().getName(), PARAM_IDENTIFIER)) != null && !s.isEmpty()) {
                identifier = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), PARAM_LABEL)) != null && !s.isEmpty()) {
                label = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), PARAM_DOCUMENTATION)) != null && !s.isEmpty()) {
                documentation = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), PARAM_TITLE)) != null && !s.isEmpty()) {
                regTitle = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), PARAM_DESCRIPTION)) != null && !s.isEmpty()) {
                regDescription = s;
            }
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
            df.setTimeZone(tz);
            datetimeUpd = datetimePub = df.format(new Date());
            s = this.options.parameter(this.getClass().getName(), PARAM_DATE_TIME_PUBLISHED);
            if (s != null && !s.isEmpty()) {
                datetimePub = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), PARAM_DATE_TIME_UPDATED)) != null && !s.isEmpty()) {
                datetimeUpd = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), PARAM_AUTHOR)) != null && !s.isEmpty()) {
                author = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), PARAM_XSLT_PATH)) != null && s.length() > 0) {
                xsltPath = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), PARAM_XSL_TRANFORMER_FACTORY)) != null && s.length() > 0) {
                xslTransformerFactory = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), PARAM_XSL_HTML_FILE)) != null && s.length() > 0) {
                xslhtmlfileName = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), PARAM_XSL_GML_FILE)) != null && s.length() > 0) {
                xslgmlfileName = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), PARAM_XSL_SKOS_FILE)) != null && s.length() > 0) {
                xslskosfileName = s;
            }
            if ((s = this.options.parameter(this.getClass().getName(), "outputDirectory")) == null) {
                s = this.options.parameter("outputDirectory");
            }
            if (s != null && s.length() > 0) {
                outputDirectory = s;
            }
            String imt = this.options.parameter(this.getClass().getName(), PARAM_REFERENCE_MODEL_TYPE);
            String mdl = this.options.parameter(this.getClass().getName(), PARAM_REFERENCE_MODEL_FILE);
            if (StringUtils.isNotBlank((CharSequence)imt) && StringUtils.isNotBlank((CharSequence)mdl)) {
                DefaultModelProvider mp = new DefaultModelProvider(this.result, this.options);
                refModel = mp.getModel(imt, mdl, null, null, false, null);
            }
            rootDocument = this.createDocument();
            documentMap.put(baseURI, rootDocument);
            root = rootDocument.createElementNS(ATOM_NS, "feed");
            rootDocument.appendChild(root);
            Element e1 = rootDocument.createElementNS(ATOM_NS, PARAM_TITLE);
            root.appendChild(e1);
            e1.appendChild(rootDocument.createTextNode(regTitle));
            if (regDescription != null) {
                e1 = rootDocument.createElementNS(ATOM_NS, "subtitle");
                e1.appendChild(rootDocument.createTextNode(regDescription));
                root.appendChild(e1);
            }
            e1 = rootDocument.createElementNS(ATOM_NS, "link");
            root.appendChild(e1);
            this.addAttribute(rootDocument, e1, "href", baseURI + "/index.atom");
            this.addAttribute(rootDocument, e1, "rel", "self");
            this.addAttribute(rootDocument, e1, "type", "application/atom+xml");
            e1 = rootDocument.createElementNS(ATOM_NS, "link");
            root.appendChild(e1);
            this.addAttribute(rootDocument, e1, "href", baseURI + "/index.html");
            this.addAttribute(rootDocument, e1, "rel", "alternate");
            this.addAttribute(rootDocument, e1, "type", "text/html");
            e1 = rootDocument.createElementNS(ATOM_NS, "link");
            root.appendChild(e1);
            this.addAttribute(rootDocument, e1, "href", baseURI + "/index.gml");
            this.addAttribute(rootDocument, e1, "rel", "alternate");
            this.addAttribute(rootDocument, e1, "type", "application/gml+xml;version=3.2");
            e1 = rootDocument.createElementNS(ATOM_NS, "published");
            root.appendChild(e1);
            e1.appendChild(rootDocument.createTextNode(datetimePub));
            e1 = rootDocument.createElementNS(ATOM_NS, "updated");
            root.appendChild(e1);
            e1.appendChild(rootDocument.createTextNode(datetimeUpd));
            e1 = rootDocument.createElementNS(ATOM_NS, PARAM_AUTHOR);
            root.appendChild(e1);
            Element e2 = rootDocument.createElementNS(ATOM_NS, "name");
            e1.appendChild(e2);
            e2.appendChild(rootDocument.createTextNode(author));
            e1 = rootDocument.createElementNS(ATOM_NS, "id");
            root.appendChild(e1);
            e1.appendChild(rootDocument.createTextNode(baseURI));
        }
        version = p.version();
        if (refModel != null) {
            SortedSet<PackageInfo> set = refModel.schemas(p.name());
            if (set.size() == 0) {
                differ = new Differ(true, new String[0]);
                refPackage = null;
                refVersion = null;
                diffs = differ.diff(p, refPackage);
            } else if (set.size() == 1) {
                differ = new Differ(true, new String[0]);
                refPackage = (PackageInfo)set.iterator().next();
                refVersion = refPackage.version();
                diffs = differ.diff(p, refPackage);
                for (Map.Entry<Info, SortedSet<DiffElement>> me : diffs.entrySet()) {
                    ShapeChangeResult.MessageContext mc = this.result.addInfo("Model difference - " + me.getKey().fullName().replace(p.fullName(), p.name()));
                    if (mc == null) continue;
                    for (DiffElement diff : me.getValue()) {
                        String s = diff.change + " " + diff.subElementType;
                        if (diff.subElementType == DiffElement.ElementType.TAG) {
                            s = s + "(" + diff.tag + ")";
                        }
                        if (diff.subElement != null) {
                            String s2;
                            s = s + " " + diff.subElement.name();
                            if (diff.subElementType == DiffElement.ElementType.CLASS || diff.subElementType == DiffElement.ElementType.SUBPACKAGE || diff.subElementType == DiffElement.ElementType.PROPERTY) {
                                s2 = diff.subElement.taggedValue("AAA:Kennung");
                                if (StringUtils.isNotBlank((CharSequence)s2)) {
                                    s = s + " (" + s2 + ")";
                                }
                            } else if (diff.subElementType == DiffElement.ElementType.ENUM && (s2 = ((PropertyInfo)diff.subElement).initialValue()) != null && !s2.isEmpty()) {
                                s = s + " (" + s2 + ")";
                            }
                        } else {
                            s = diff.diff != null ? s + " " + differ.diff_toString(diff.diff).replace("[[/ins]][[ins]]", "").replace("[[/del]][[del]]", "").replace("[[ins]][[/ins]]", "").replace("[[del]][[/del]]", "") : s + " ???";
                        }
                        mc.addDetail(s);
                    }
                }
            }
        }
    }

    protected void addAttribute(Document document, Element e, String name, String value) {
        Attr att = document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    protected Document createDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(null, 2);
            String m = e.getMessage();
            if (m != null) {
                this.result.addFatalError(m);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            this.result.addFatalError(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        return document;
    }

    @Override
    public void process(ClassInfo ci) {
        String[] sa;
        int cat = ci.category();
        if (!(cat == 2 || enums && cat == 3)) {
            return;
        }
        DiffElement.Operation op = null;
        if (diffs != null && diffs.get(ci.pkg()) != null) {
            for (Object diff : (SortedSet)diffs.get(ci.pkg())) {
                if (((DiffElement)diff).subElementType == DiffElement.ElementType.CLASS && (ClassInfo)((DiffElement)diff).subElement == ci && ((DiffElement)diff).change == DiffElement.Operation.INSERT) {
                    op = DiffElement.Operation.INSERT;
                    break;
                }
                if (((DiffElement)diff).subElementType != DiffElement.ElementType.CLASS || (ClassInfo)((DiffElement)diff).subElement != ci || ((DiffElement)diff).change != DiffElement.Operation.DELETE) continue;
                op = DiffElement.Operation.DELETE;
                break;
            }
        }
        if (refModel != null && op == null) {
            PackageInfo pix = ci.pkg();
            while (pix != null) {
                if (diffs != null && pix.owner() != null && diffs.get(pix.owner()) != null) {
                    for (DiffElement diff : (SortedSet)diffs.get(pix.owner())) {
                        if (diff.subElementType == DiffElement.ElementType.SUBPACKAGE && (PackageInfo)diff.subElement == pix && diff.change == DiffElement.Operation.INSERT) {
                            op = DiffElement.Operation.INSERT;
                            pix = null;
                            break;
                        }
                        if (diff.subElementType != DiffElement.ElementType.SUBPACKAGE || (PackageInfo)diff.subElement != pix || diff.change != DiffElement.Operation.DELETE) continue;
                        op = DiffElement.Operation.DELETE;
                        pix = null;
                        break;
                    }
                }
                if (pix == null) continue;
                pix = pix.owner();
            }
        }
        Document cDocument = this.createDocument();
        String id = ci.id();
        for (String s0 : sa = identifier.split(",")) {
            String s = this.getValue(ci, s0);
            if (s == null || s.isEmpty()) continue;
            id = s;
            break;
        }
        String uri = baseURI + "/" + id.replace("/", "-");
        documentMap.put(uri, cDocument);
        String theLabel = this.getValue(ci, label);
        Object doc = "";
        sa = documentation.split(",");
        for (String s0 : sa) {
            String s = this.getValue(ci, s0);
            if (s == null || s.isEmpty()) continue;
            doc = (String)doc + "\n\n" + s;
        }
        doc = ((String)doc).trim();
        if (op == null && diffs != null && diffs.get(ci) != null) {
            for (DiffElement diff : (SortedSet)diffs.get(ci)) {
                if (diff.subElementType != DiffElement.ElementType.DOCUMENTATION && diff.subElementType != DiffElement.ElementType.NAME && diff.subElementType != DiffElement.ElementType.TAG && diff.subElementType != DiffElement.ElementType.ALIAS) continue;
                op = DiffElement.Operation.CHANGE;
                break;
            }
        }
        this.processClass(rootDocument, root, ci, false, uri, theLabel, (String)doc, op);
        Element cRoot = this.processClass(cDocument, null, ci, true, uri, theLabel, (String)doc, op);
        this.processProperties(cDocument, cRoot, ci, uri, op == DiffElement.Operation.CHANGE ? null : op);
    }

    private Element processClass(Document theDocument, Element baseRoot, ClassInfo ci, boolean feed, String uri, String label, String doc, DiffElement.Operation op) {
        Element theRoot = theDocument.createElementNS(ATOM_NS, feed ? "feed" : "entry");
        if (baseRoot == null) {
            theDocument.appendChild(theRoot);
        } else {
            baseRoot.appendChild(theRoot);
        }
        Element e1 = theDocument.createElementNS(ATOM_NS, PARAM_TITLE);
        theRoot.appendChild(e1);
        e1.appendChild(theDocument.createTextNode(label));
        if (!doc.isEmpty()) {
            e1 = feed ? theDocument.createElementNS(ATOM_NS, "subtitle") : theDocument.createElementNS(ATOM_NS, "summary");
            e1.appendChild(theDocument.createTextNode(doc.trim()));
            theRoot.appendChild(e1);
        }
        e1 = theDocument.createElementNS(ATOM_NS, "link");
        theRoot.appendChild(e1);
        this.addAttribute(theDocument, e1, "href", uri + "/index.atom");
        this.addAttribute(theDocument, e1, "rel", feed ? "self" : "alternate");
        this.addAttribute(theDocument, e1, "type", "application/atom+xml");
        e1 = theDocument.createElementNS(ATOM_NS, "link");
        theRoot.appendChild(e1);
        this.addAttribute(theDocument, e1, "href", uri + "/index.html");
        this.addAttribute(theDocument, e1, "rel", "alternate");
        this.addAttribute(theDocument, e1, "type", "text/html");
        e1 = theDocument.createElementNS(ATOM_NS, "link");
        theRoot.appendChild(e1);
        this.addAttribute(theDocument, e1, "href", uri + "/index.gml");
        this.addAttribute(theDocument, e1, "rel", "alternate");
        this.addAttribute(theDocument, e1, "type", "application/gml+xml;version=3.2");
        e1 = theDocument.createElementNS(ATOM_NS, "link");
        theRoot.appendChild(e1);
        this.addAttribute(theDocument, e1, "href", uri + "/index.rdf");
        this.addAttribute(theDocument, e1, "rel", "alternate");
        this.addAttribute(theDocument, e1, "type", "application/rdf+xml");
        e1 = theDocument.createElementNS(ATOM_NS, "published");
        theRoot.appendChild(e1);
        if (op == null || op == DiffElement.Operation.DELETE || op == DiffElement.Operation.CHANGE) {
            e1.appendChild(theDocument.createTextNode(datetimePub));
        } else {
            e1.appendChild(theDocument.createTextNode(datetimeUpd));
        }
        e1 = theDocument.createElementNS(ATOM_NS, "updated");
        theRoot.appendChild(e1);
        if (refModel != null && op == null) {
            e1.appendChild(theDocument.createTextNode(datetimePub));
        } else {
            e1.appendChild(theDocument.createTextNode(datetimeUpd));
        }
        e1 = theDocument.createElementNS(ATOM_NS, PARAM_AUTHOR);
        theRoot.appendChild(e1);
        Element e2 = theDocument.createElementNS(ATOM_NS, "name");
        e1.appendChild(e2);
        e2.appendChild(theDocument.createTextNode(author));
        e1 = theDocument.createElementNS(ATOM_NS, "id");
        theRoot.appendChild(e1);
        e1.appendChild(theDocument.createTextNode(uri));
        if (refVersion != null && (op == null || op == DiffElement.Operation.DELETE || op == DiffElement.Operation.CHANGE)) {
            e1 = theDocument.createElementNS(ATOM_NS, "category");
            theRoot.appendChild(e1);
            this.addAttribute(theDocument, e1, "term", refVersion);
            this.addAttribute(theDocument, e1, "scheme", baseURI + "/version");
            this.addAttribute(theDocument, e1, PARAM_LABEL, refVersion);
        }
        if (version != null && (op == null || op == DiffElement.Operation.INSERT || op == DiffElement.Operation.CHANGE)) {
            e1 = theDocument.createElementNS(ATOM_NS, "category");
            theRoot.appendChild(e1);
            this.addAttribute(theDocument, e1, "term", version);
            this.addAttribute(theDocument, e1, "scheme", baseURI + "/version");
            this.addAttribute(theDocument, e1, PARAM_LABEL, version);
        }
        if (op == DiffElement.Operation.DELETE) {
            e1 = theDocument.createElementNS(ATOM_NS, "category");
            theRoot.appendChild(e1);
            this.addAttribute(theDocument, e1, "term", "retired");
            this.addAttribute(theDocument, e1, "scheme", baseURI + "/status");
            this.addAttribute(theDocument, e1, PARAM_LABEL, "Zur\u00fcckgezogen");
        } else if (op == DiffElement.Operation.INSERT) {
            e1 = theDocument.createElementNS(ATOM_NS, "category");
            theRoot.appendChild(e1);
            this.addAttribute(theDocument, e1, "term", "valid");
            this.addAttribute(theDocument, e1, "scheme", baseURI + "/status");
            this.addAttribute(theDocument, e1, PARAM_LABEL, "G\u00fcltig");
        } else if (op == DiffElement.Operation.CHANGE) {
            e1 = theDocument.createElementNS(ATOM_NS, "category");
            theRoot.appendChild(e1);
            this.addAttribute(theDocument, e1, "term", "valid");
            this.addAttribute(theDocument, e1, "scheme", baseURI + "/status");
            this.addAttribute(theDocument, e1, PARAM_LABEL, "G\u00fcltig");
        } else if (op == null) {
            e1 = theDocument.createElementNS(ATOM_NS, "category");
            theRoot.appendChild(e1);
            this.addAttribute(theDocument, e1, "term", "valid");
            this.addAttribute(theDocument, e1, "scheme", baseURI + "/status");
            this.addAttribute(theDocument, e1, PARAM_LABEL, "G\u00fcltig");
        }
        int cat = ci.category();
        if (cat == 2) {
            e1 = theDocument.createElementNS(ATOM_NS, "category");
            theRoot.appendChild(e1);
            this.addAttribute(theDocument, e1, "term", "codelist");
            this.addAttribute(theDocument, e1, "scheme", baseURI + "/type");
            this.addAttribute(theDocument, e1, PARAM_LABEL, "Codeliste");
        } else if (cat == 3) {
            e1 = theDocument.createElementNS(ATOM_NS, "category");
            theRoot.appendChild(e1);
            this.addAttribute(theDocument, e1, "term", "enumeration");
            this.addAttribute(theDocument, e1, "scheme", baseURI + "/type");
            this.addAttribute(theDocument, e1, PARAM_LABEL, "Enumeration");
        }
        if (profiles != null) {
            String malist = this.getValue(ci, profiles);
            if (malist != null) {
                if ((malist = malist.trim()).length() > 0) {
                    for (String ma : malist.split(",")) {
                        ma = ma.trim();
                        e1 = theDocument.createElementNS(ATOM_NS, "category");
                        theRoot.appendChild(e1);
                        this.addAttribute(theDocument, e1, "term", ma);
                        this.addAttribute(theDocument, e1, "scheme", baseURI + "/profile");
                        this.addAttribute(theDocument, e1, PARAM_LABEL, ma);
                    }
                }
            } else {
                e1 = theDocument.createElementNS(ATOM_NS, "category");
                theRoot.appendChild(e1);
                this.addAttribute(theDocument, e1, "term", "alle");
                this.addAttribute(theDocument, e1, "scheme", baseURI + "/profile");
                this.addAttribute(theDocument, e1, PARAM_LABEL, "alle");
            }
            if (minprofiles != null && (malist = this.getValue(ci, minprofiles)) != null && (malist = malist.trim()).length() > 0) {
                for (String ma : malist.split(",")) {
                    ma = ma.trim();
                    e1 = theDocument.createElementNS(ATOM_NS, "category");
                    theRoot.appendChild(e1);
                    this.addAttribute(theDocument, e1, "term", ma);
                    this.addAttribute(theDocument, e1, "scheme", baseURI + "/mandatoryToCapture");
                    this.addAttribute(theDocument, e1, PARAM_LABEL, ma);
                }
            }
        }
        return theRoot;
    }

    private void processProperties(Document cDocument, Element cRoot, ClassInfo ci, String uri, DiffElement.Operation op) {
        for (PropertyInfo propi : ci.properties().values()) {
            Object top = op;
            if (diffs != null && diffs.get(ci) != null) {
                for (DiffElement diff : (SortedSet)diffs.get(ci)) {
                    if (diff.subElementType != DiffElement.ElementType.ENUM || (PropertyInfo)diff.subElement != propi || diff.change != DiffElement.Operation.INSERT) continue;
                    top = DiffElement.Operation.INSERT;
                    break;
                }
            }
            if (top == null && diffs != null && diffs.get(propi) != null) {
                for (DiffElement diff : (SortedSet)diffs.get(propi)) {
                    if (diff.subElementType != DiffElement.ElementType.DOCUMENTATION && diff.subElementType != DiffElement.ElementType.NAME && diff.subElementType != DiffElement.ElementType.TAG && diff.subElementType != DiffElement.ElementType.ALIAS) continue;
                    top = DiffElement.Operation.CHANGE;
                    break;
                }
            }
            this.processProperty(cDocument, cRoot, ci, propi, uri, (DiffElement.Operation)((Object)top));
        }
        if (diffs != null && diffs.get(ci) != null) {
            for (DiffElement diff : (SortedSet)diffs.get(ci)) {
                if (diff.subElementType != DiffElement.ElementType.ENUM || diff.change != DiffElement.Operation.DELETE) continue;
                this.processProperty(cDocument, cRoot, ci, (PropertyInfo)diff.subElement, uri, DiffElement.Operation.DELETE);
                for (PropertyInfo propi : ci.properties().values()) {
                    if ((PropertyInfo)diff.subElement != propi) continue;
                }
            }
        }
        SortedSet<String> ts = ci.supertypes();
        Iterator i = ts.iterator();
        while (i.hasNext()) {
            ClassInfo cix = this.model.classById((String)i.next());
            if (cix == null) continue;
            this.processProperties(cDocument, cRoot, cix, uri, op);
        }
    }

    private void processProperty(Document cDocument, Element cRoot, ClassInfo ci, PropertyInfo propi, String uri, DiffElement.Operation op) {
        String[] sa;
        String id = propi.id();
        for (String string : sa = identifier.split(",")) {
            String s = this.getValue(propi, string);
            if (s == null || s.isEmpty()) continue;
            id = s;
            break;
        }
        String valuri = uri + "/" + id.replace("/", "-");
        String theLabel = this.getValue(ci, label) + "/" + this.getValue(propi, label);
        Object doc = "";
        for (String s0 : sa = documentation.split(",")) {
            String s = this.getValue(propi, s0);
            if (s == null || s.isEmpty()) continue;
            doc = (String)doc + "\n\n" + s;
        }
        doc = ((String)doc).trim();
        if (op == DiffElement.Operation.CHANGE) {
            Element element;
            Element element2 = this.createEntry(cDocument, ci, propi, valuri, this.oldText(theLabel), this.oldText((String)doc), false, op, null, valuri + "-1");
            if (element2 != null) {
                cRoot.appendChild(element2);
                Document vDocument = this.createDocument();
                Element element3 = this.createEntry(vDocument, ci, propi, valuri, this.oldText(theLabel), this.oldText((String)doc), true, op, null, valuri + "-1");
                vDocument.appendChild(element3);
                documentMap.put(valuri, vDocument);
            }
            if ((element = this.createEntry(cDocument, ci, propi, valuri + "-1", this.newText(theLabel), this.newText((String)doc), false, op, valuri, null)) != null) {
                cRoot.appendChild(element);
                Document vDocument = this.createDocument();
                Element element4 = this.createEntry(vDocument, ci, propi, valuri + "-1", this.newText(theLabel), this.newText((String)doc), true, op, valuri, null);
                vDocument.appendChild(element4);
                documentMap.put(valuri + "-1", vDocument);
            }
        } else {
            Element element = this.createEntry(cDocument, ci, propi, valuri, theLabel, (String)doc, false, op, null, null);
            if (element != null) {
                cRoot.appendChild(element);
                Document vDocument = this.createDocument();
                Element element5 = this.createEntry(vDocument, ci, propi, valuri, theLabel, (String)doc, true, op, null, null);
                vDocument.appendChild(element5);
                documentMap.put(valuri, vDocument);
            }
        }
    }

    private Element createEntry(Document cDocument, ClassInfo ci, PropertyInfo propi, String uri, String thelabel, String doc, boolean self, DiffElement.Operation op, String predecessor, String successor) {
        Element cRoot = cDocument.createElementNS(ATOM_NS, "entry");
        Element e1 = cDocument.createElementNS(ATOM_NS, PARAM_TITLE);
        cRoot.appendChild(e1);
        e1.appendChild(cDocument.createTextNode(thelabel));
        if (!doc.isEmpty()) {
            e1 = cDocument.createElementNS(ATOM_NS, "summary");
            e1.appendChild(cDocument.createTextNode(doc.trim()));
            cRoot.appendChild(e1);
        }
        e1 = cDocument.createElementNS(ATOM_NS, "link");
        cRoot.appendChild(e1);
        this.addAttribute(cDocument, e1, "href", uri + ".atom");
        this.addAttribute(cDocument, e1, "rel", self ? "self" : "alternate");
        this.addAttribute(cDocument, e1, "type", "application/atom+xml");
        e1 = cDocument.createElementNS(ATOM_NS, "link");
        cRoot.appendChild(e1);
        this.addAttribute(cDocument, e1, "href", uri + ".html");
        this.addAttribute(cDocument, e1, "rel", "alternate");
        this.addAttribute(cDocument, e1, "type", "text/html");
        e1 = cDocument.createElementNS(ATOM_NS, "link");
        cRoot.appendChild(e1);
        this.addAttribute(cDocument, e1, "href", uri + ".gml");
        this.addAttribute(cDocument, e1, "rel", "alternate");
        this.addAttribute(cDocument, e1, "type", "application/gml+xml;version=3.2");
        e1 = cDocument.createElementNS(ATOM_NS, "link");
        cRoot.appendChild(e1);
        this.addAttribute(cDocument, e1, "href", uri + ".rdf");
        this.addAttribute(cDocument, e1, "rel", "alternate");
        this.addAttribute(cDocument, e1, "type", "application/rdf+xml");
        if (predecessor != null) {
            e1 = cDocument.createElementNS(ATOM_NS, "link");
            cRoot.appendChild(e1);
            this.addAttribute(cDocument, e1, "href", predecessor);
            this.addAttribute(cDocument, e1, "rel", "predecessor");
        }
        if (successor != null) {
            e1 = cDocument.createElementNS(ATOM_NS, "link");
            cRoot.appendChild(e1);
            this.addAttribute(cDocument, e1, "href", successor);
            this.addAttribute(cDocument, e1, "rel", "successor");
        }
        e1 = cDocument.createElementNS(ATOM_NS, "published");
        cRoot.appendChild(e1);
        if (op == null || op == DiffElement.Operation.DELETE || op == DiffElement.Operation.CHANGE && successor != null) {
            e1.appendChild(cDocument.createTextNode(datetimePub));
        } else {
            e1.appendChild(cDocument.createTextNode(datetimeUpd));
        }
        e1 = cDocument.createElementNS(ATOM_NS, "updated");
        cRoot.appendChild(e1);
        if (refModel != null && op == null) {
            e1.appendChild(cDocument.createTextNode(datetimePub));
        } else {
            e1.appendChild(cDocument.createTextNode(datetimeUpd));
        }
        e1 = cDocument.createElementNS(ATOM_NS, PARAM_AUTHOR);
        cRoot.appendChild(e1);
        Element e2 = cDocument.createElementNS(ATOM_NS, "name");
        e1.appendChild(e2);
        e2.appendChild(cDocument.createTextNode(author));
        e1 = cDocument.createElementNS(ATOM_NS, "id");
        cRoot.appendChild(e1);
        e1.appendChild(cDocument.createTextNode(uri));
        if (refVersion != null && (op == null || op == DiffElement.Operation.DELETE || op == DiffElement.Operation.CHANGE && successor != null)) {
            e1 = cDocument.createElementNS(ATOM_NS, "category");
            cRoot.appendChild(e1);
            this.addAttribute(cDocument, e1, "term", refVersion);
            this.addAttribute(cDocument, e1, "scheme", baseURI + "/version");
            this.addAttribute(cDocument, e1, PARAM_LABEL, refVersion);
        }
        if (version != null && (op == null || op == DiffElement.Operation.INSERT || op == DiffElement.Operation.CHANGE && predecessor != null)) {
            e1 = cDocument.createElementNS(ATOM_NS, "category");
            cRoot.appendChild(e1);
            this.addAttribute(cDocument, e1, "term", version);
            this.addAttribute(cDocument, e1, "scheme", baseURI + "/version");
            this.addAttribute(cDocument, e1, PARAM_LABEL, version);
        }
        if (op == DiffElement.Operation.DELETE) {
            e1 = cDocument.createElementNS(ATOM_NS, "category");
            cRoot.appendChild(e1);
            this.addAttribute(cDocument, e1, "term", "retired");
            this.addAttribute(cDocument, e1, "scheme", baseURI + "/status");
            this.addAttribute(cDocument, e1, PARAM_LABEL, "Zur\u00fcckgezogen");
        } else if (op == DiffElement.Operation.INSERT) {
            e1 = cDocument.createElementNS(ATOM_NS, "category");
            cRoot.appendChild(e1);
            this.addAttribute(cDocument, e1, "term", "valid");
            this.addAttribute(cDocument, e1, "scheme", baseURI + "/status");
            this.addAttribute(cDocument, e1, PARAM_LABEL, "G\u00fcltig");
        } else if (op == DiffElement.Operation.CHANGE && successor != null) {
            e1 = cDocument.createElementNS(ATOM_NS, "category");
            cRoot.appendChild(e1);
            this.addAttribute(cDocument, e1, "term", "superseded");
            this.addAttribute(cDocument, e1, "scheme", baseURI + "/status");
            this.addAttribute(cDocument, e1, PARAM_LABEL, "Veraltet");
        } else if (op == DiffElement.Operation.CHANGE && predecessor != null) {
            e1 = cDocument.createElementNS(ATOM_NS, "category");
            cRoot.appendChild(e1);
            this.addAttribute(cDocument, e1, "term", "valid");
            this.addAttribute(cDocument, e1, "scheme", baseURI + "/status");
            this.addAttribute(cDocument, e1, PARAM_LABEL, "G\u00fcltig");
        } else if (op == null) {
            e1 = cDocument.createElementNS(ATOM_NS, "category");
            cRoot.appendChild(e1);
            this.addAttribute(cDocument, e1, "term", "valid");
            this.addAttribute(cDocument, e1, "scheme", baseURI + "/status");
            this.addAttribute(cDocument, e1, PARAM_LABEL, "G\u00fcltig");
        }
        if (profiles != null) {
            String malist = this.getValue(propi, profiles);
            if (malist != null) {
                if ((malist = malist.trim()).length() > 0) {
                    for (String ma : malist.split(",")) {
                        ma = ma.trim();
                        e1 = cDocument.createElementNS(ATOM_NS, "category");
                        cRoot.appendChild(e1);
                        this.addAttribute(cDocument, e1, "term", ma);
                        this.addAttribute(cDocument, e1, "scheme", baseURI + "/profile");
                        this.addAttribute(cDocument, e1, PARAM_LABEL, ma);
                    }
                }
            } else {
                e1 = cDocument.createElementNS(ATOM_NS, "category");
                cRoot.appendChild(e1);
                this.addAttribute(cDocument, e1, "term", "alle");
                this.addAttribute(cDocument, e1, "scheme", baseURI + "/profile");
                this.addAttribute(cDocument, e1, PARAM_LABEL, "alle");
            }
            if (minprofiles != null && (malist = this.getValue(propi, minprofiles)) != null && (malist = malist.trim()).length() > 0) {
                for (String ma : malist.split(",")) {
                    ma = ma.trim();
                    e1 = cDocument.createElementNS(ATOM_NS, "category");
                    cRoot.appendChild(e1);
                    this.addAttribute(cDocument, e1, "term", ma);
                    this.addAttribute(cDocument, e1, "scheme", baseURI + "/mandatoryToCapture");
                    this.addAttribute(cDocument, e1, PARAM_LABEL, ma);
                }
            }
        }
        return cRoot;
    }

    private String oldText(String s) {
        s = s.replaceAll("\\[\\[ins\\]\\].+?(?=\\[\\[/ins\\]\\])\\[\\[/ins\\]\\]", "");
        s = s.replaceAll("\\[\\[del\\]\\]", "");
        s = s.replaceAll("\\[\\[/del\\]\\]", "");
        return s;
    }

    private String newText(String s) {
        s = s.replaceAll("\\[\\[del\\]\\].+?(?=\\[\\[/del\\]\\])\\[\\[/del\\]\\]", "");
        s = s.replaceAll("\\[\\[ins\\]\\]", "");
        s = s.replaceAll("\\[\\[/ins\\]\\]", "");
        return s;
    }

    private String getValue(Info i, String source) {
        String s = null;
        if (source.equalsIgnoreCase("name")) {
            s = i.name();
            if (diffs != null && diffs.get(i) != null) {
                for (DiffElement diff : (SortedSet)diffs.get(i)) {
                    if (diff.subElementType != DiffElement.ElementType.NAME) continue;
                    s = differ.diff_toString(diff.diff);
                    break;
                }
            }
        } else if (source.equalsIgnoreCase("alias")) {
            s = i.aliasName();
            if (diffs != null && diffs.get(i) != null) {
                for (DiffElement diff : (SortedSet)diffs.get(i)) {
                    if (diff.subElementType != DiffElement.ElementType.ALIAS) continue;
                    s = differ.diff_toString(diff.diff);
                    break;
                }
            }
        } else if (source.equalsIgnoreCase("id")) {
            s = i.id();
        } else if (source.equalsIgnoreCase("notes")) {
            s = i.documentation();
            if (diffs != null && diffs.get(i) != null) {
                for (DiffElement diff : (SortedSet)diffs.get(i)) {
                    if (diff.subElementType != DiffElement.ElementType.DOCUMENTATION) continue;
                    s = differ.diff_toString(diff.diff);
                    break;
                }
            }
        } else if (source.equalsIgnoreCase(PARAM_DESCRIPTION)) {
            s = i.description();
            if (diffs != null && diffs.get(i) != null) {
                for (DiffElement diff : (SortedSet)diffs.get(i)) {
                    if (diff.subElementType != DiffElement.ElementType.DESCRIPTION) continue;
                    s = differ.diff_toString(diff.diff);
                    break;
                }
            }
        } else if (source.equalsIgnoreCase("definition")) {
            s = i.definition();
            if (diffs != null && diffs.get(i) != null) {
                for (DiffElement diff : (SortedSet)diffs.get(i)) {
                    if (diff.subElementType != DiffElement.ElementType.DEFINITION) continue;
                    s = differ.diff_toString(diff.diff);
                    break;
                }
            }
        } else if (source.equalsIgnoreCase("initialValue") && i instanceof PropertyInfo) {
            s = ((PropertyInfo)i).initialValue();
            if (diffs != null && diffs.get(i) != null) {
                for (DiffElement diff : (SortedSet)diffs.get(i)) {
                    if (diff.subElementType != DiffElement.ElementType.ENUM) continue;
                    s = differ.diff_toString(diff.diff);
                    break;
                }
            }
        } else if (source.startsWith("@")) {
            s = i.taggedValue(source.substring(1));
            if (diffs != null && diffs.get(i) != null) {
                for (DiffElement diff : (SortedSet)diffs.get(i)) {
                    if (diff.subElementType != DiffElement.ElementType.TAG || !diff.tag.equalsIgnoreCase(source.substring(1))) continue;
                    s = differ.diff_toString(diff.diff);
                    break;
                }
            }
        }
        if (s != null && s.isEmpty()) {
            s = null;
        }
        return s;
    }

    @Override
    public void write() {
    }

    @Override
    public void writeAll(ShapeChangeResult r) {
        this.result = r;
        if (printed) {
            return;
        }
        if (this.diagnosticsOnly) {
            return;
        }
        try {
            Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
            outputFormat.setProperty("indent", "yes");
            outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            outputFormat.setProperty("encoding", "UTF-8");
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            for (Map.Entry<String, Document> mapentry : documentMap.entrySet()) {
                Document cDocument = mapentry.getValue();
                if (cDocument == null) continue;
                Object dir = outputDirectory;
                File outDir = new File((String)dir);
                if (!outDir.exists()) {
                    outDir.mkdirs();
                }
                String path = mapentry.getKey().replace(baseURI, "");
                int i = 0;
                String fname = "index";
                for (String step : path.split("/")) {
                    if (step.trim().isEmpty()) continue;
                    if (i == 0) {
                        outDir = new File((String)(dir = (String)dir + "/" + step));
                        if (!outDir.exists()) {
                            outDir.mkdirs();
                        }
                    } else if (i == 1) {
                        fname = step;
                    }
                    ++i;
                }
                FileOutputStream fout = new FileOutputStream((String)dir + "/" + fname + ".atom");
                OutputStreamWriter outputXML = new OutputStreamWriter((OutputStream)fout, outputFormat.getProperty("encoding"));
                serializer.setWriter((Writer)outputXML);
                serializer.asDOMSerializer().serialize((Node)cDocument);
                outputXML.close();
                this.result.addResult(this.getTargetName(), (String)dir, fname + ".atom", path);
                if (xslhtmlfileName != null) {
                    this.xsltWrite((String)dir, fname + ".atom", "/" + xslhtmlfileName, fname + ".html", i);
                }
                if (i > 0 && xslskosfileName != null) {
                    this.xsltWrite((String)dir, fname + ".atom", "/" + xslskosfileName, fname + ".rdf", i);
                }
                if (xslgmlfileName != null) {
                    this.xsltWrite((String)dir, fname + ".atom", "/" + xslgmlfileName, fname + ".gml", i);
                }
                fout = new FileOutputStream((String)dir + "/" + fname + ".var");
                OutputStreamWriter outputVAR = new OutputStreamWriter(fout);
                outputVAR.write("URI: " + fname + "\n\n");
                outputVAR.write("URI: " + fname + ".atom\n");
                outputVAR.write("Content-type: application/atom+xml\n\n");
                outputVAR.write("URI: " + fname + ".gml\n");
                outputVAR.write("Content-type: application/gml+xml\n\n");
                outputVAR.write("URI: " + fname + ".html\n");
                outputVAR.write("Content-type: text/html\n\n");
                if (i > 0) {
                    outputVAR.write("URI: " + fname + ".rdf\n");
                    outputVAR.write("Content-type: application/rdf+xml\n\n");
                }
                outputVAR.close();
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
        printed = true;
    }

    @Override
    public String getTargetName() {
        return "Codelist register";
    }

    @Override
    public String getTargetIdentifier() {
        return "clreg";
    }

    @Override
    public void reset() {
        printed = false;
        enums = true;
        initialised = false;
        baseURI = "http://example.com/fixme/";
        identifier = "initialValue,name";
        label = "name";
        documentation = "notes";
        profiles = null;
        minprofiles = null;
        language = "en";
        regTitle = "FIXME";
        author = "ShapeChange";
        regDescription = null;
        documentMap = new TreeMap();
        rootDocument = null;
        root = null;
        datetimePub = null;
        datetimeUpd = null;
        outputDirectory = ".";
        xslhtmlfileName = "clr-html.xsl";
        xslskosfileName = "clr-skos.xsl";
        xslgmlfileName = "clr-gml.xsl";
    }

    public void xsltWrite(String outputDirectory, String xmlName, String xsltfileName, String outfileName, int level) {
        try {
            File outDir = new File(outputDirectory);
            File xmlFile = new File(outDir, xmlName);
            if (!xmlFile.canRead()) {
                this.result.addError(null, 301, xmlFile.getName(), outfileName);
                return;
            }
            File outFile = new File(outDir, outfileName);
            InputStream stream = null;
            if (xsltPath.toLowerCase().startsWith("http")) {
                URL url = new URL(xsltPath + "/" + xsltfileName);
                URLConnection urlConnection = url.openConnection();
                stream = urlConnection.getInputStream();
            } else {
                File xsl = new File(xsltPath + "/" + xsltfileName);
                if (xsl.exists()) {
                    stream = new FileInputStream(xsl);
                } else {
                    this.result.addError("XSLT stylesheet " + xsl.getAbsolutePath() + " not found.");
                    return;
                }
            }
            StreamSource xsltSource = new StreamSource(stream);
            StreamSource xmlSource = new StreamSource(xmlFile);
            StreamResult res = new StreamResult(outFile);
            if (xslTransformerFactory != null) {
                System.setProperty("javax.xml.transform.TransformerFactory", xslTransformerFactory);
            }
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.setParameter("baseuri", baseURI);
            trans.setParameter("level", "" + level);
            trans.setParameter("language", language);
            trans.transform(xmlSource, res);
            this.result.addResult(this.getTargetName(), outputDirectory, outfileName, null);
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
    }

    @Override
    public String getDefaultEncodingRule() {
        return "*";
    }
}

