/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Codelists;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class CodelistDictionariesMLConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("defaultLang", "languages", "noNewlineOmit", "clPackageName", "infoURL").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = Stream.of(Pattern.compile("localeRef_.*")).collect(Collectors.toList());

    @Override
    public boolean isValid(ProcessConfiguration config, Options options, ShapeChangeResult result) {
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTargetParameters());
        isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, config.getParameters().keySet(), result) && isValid;
        String defaultLang = config.parameterAsString("defaultLang", "de", false, true);
        String sLangs = config.parameterAsString("languages", null, false, true);
        String[] langs = sLangs != null ? sLangs.split(" ") : new String[]{defaultLang};
        for (String lang : langs) {
            String localeVal;
            if (lang.equalsIgnoreCase(defaultLang) || !StringUtils.isBlank((CharSequence)(localeVal = config.parameterAsString("localeRef_" + lang, null, false, true)))) continue;
            isValid = false;
            result.addError(this, 100, lang);
        }
        return isValid;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 100: {
                return "Configuration parameter for locale reference is missing for language '$1$'. A locale reference must be provided for each language other than the default language.";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

