/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Codelists;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Model.Descriptors;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Target;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CodelistDictionariesML
implements Target,
MessageSource {
    public static final String PARAM_DEFAULT_LANG = "defaultLang";
    public static final String PARAM_LANGUAGES = "languages";
    public static final String PARAM_NO_NEWLINE_OMIT = "noNewlineOmit";
    public static final String PARAM_CLPACKAGENAME = "clPackageName";
    public static final String PARAM_INFOURL = "infoURL";
    public static final String RULE_PROP_CODELIST_AND_CODE_NAME_AS_GML_ID = "rule-cldml-prop-codeListAndCodeNameAsGmlId";
    protected final String dlma = "[";
    protected final String dlme = "]";
    protected String defaultLang = "de";
    protected final String GML_NSABBR = "gml";
    protected final String GMX_NSABBR = "gmx";
    protected final String GMD_NSABBR = "gmd";
    protected final String GCO_NSABBR = "gco";
    protected final String XLINK_NSABBR = "xlink";
    protected String sLangs = null;
    protected String[] langs = null;
    protected ShapeChangeResult result = null;
    private PackageInfo pi = null;
    private Model model = null;
    protected Options options = null;
    private boolean diagnosticsOnly = false;
    private boolean printed = false;
    private final HashMap<String, Document> documentMap = new HashMap();
    private boolean newlineOmit = true;
    private boolean isMLDictionary = false;

    @Override
    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        this.diagnosticsOnly = diagOnly;
        String pm = this.options.parameter(this.getClass().getName(), PARAM_NO_NEWLINE_OMIT);
        this.newlineOmit = pm == null || !pm.equalsIgnoreCase("true");
        this.defaultLang = this.options.parameterAsString(this.getClass().getName(), PARAM_DEFAULT_LANG, "de", false, true);
        this.sLangs = this.options.parameterAsString(this.getClass().getName(), PARAM_LANGUAGES, null, false, true);
        this.langs = this.sLangs != null ? this.sLangs.split(" ") : new String[]{this.defaultLang};
    }

    protected void addAttribute(Document document, Element e, String name, String value) {
        Attr att = document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    @Override
    public void process(ClassInfo ci) {
        int cat = ci.category();
        if (cat != 2) {
            return;
        }
        if (!ci.asDictionary()) {
            this.result.addInfo(this, 101, ci.name());
            return;
        }
        if (ci.properties().isEmpty()) {
            this.result.addInfo(this, 100, ci.name());
            return;
        }
        String tvn = this.options.parameter(this.getClass().getName(), PARAM_CLPACKAGENAME);
        if (tvn != null && tvn.length() > 0 && !tvn.equalsIgnoreCase(ci.pkg().name())) {
            return;
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document cDocument = db.newDocument();
            this.createDictionary(ci, cDocument);
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(null, 2);
            String m = e.getMessage();
            if (m != null) {
                this.result.addFatalError(m);
            }
            e.printStackTrace(System.err);
        }
        catch (Exception e) {
            this.result.addFatalError(e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    private void createDictionary(ClassInfo ci, Document cDocument) {
        Element et = null;
        boolean altLangFound = false;
        HashSet<Element> altExprs = new HashSet<Element>();
        for (String lang : this.langs) {
            Element et3;
            Element et2;
            if (lang.equalsIgnoreCase(this.defaultLang)) continue;
            Element eai = cDocument.createElement("gmx:ClAlternativeExpression");
            Element ea = cDocument.createElement("gmx:alternativeExpression");
            this.addAttribute(cDocument, eai, "gml:id", ci.name() + "_" + lang);
            this.addAttribute(cDocument, eai, "codeSpace", this.createClCodeSpaceContent(ci));
            Element et1 = this.createCodelistDescription(lang, ci, cDocument);
            if (et1 != null) {
                eai.appendChild(et1);
            }
            if ((et2 = this.createCodelistIdentifier(lang, ci, cDocument)) != null) {
                eai.appendChild(et2);
            }
            if ((et3 = this.createCodelistName(lang, ci, cDocument)) != null) {
                eai.appendChild(et3);
            }
            if (et1 == null && et3 == null || et2 == null) continue;
            et = cDocument.createElement("gmx:locale");
            String localeVal = this.options.parameter(this.getClass().getName(), "localeRef_" + lang);
            if (StringUtils.isBlank((CharSequence)localeVal)) {
                localeVal = "FIXME_MISSING_LOCALE_REF";
                this.result.addError(this, 102, lang);
            }
            this.addAttribute(cDocument, et, "xlink:href", localeVal);
            eai.appendChild(et);
            ea.appendChild(eai);
            altExprs.add(ea);
            altLangFound = true;
        }
        Element ec = null;
        if (altLangFound) {
            ec = this.createMlDocumentNamespace(ci.name(), cDocument);
            this.isMLDictionary = true;
        } else {
            ec = this.createDocumentNamespace(ci.name(), cDocument);
            this.isMLDictionary = false;
        }
        this.documentMap.put(ci.id(), cDocument);
        et = this.createCodelistDescription(this.defaultLang, ci, cDocument);
        if (et != null) {
            ec.appendChild(et);
        }
        if ((et = this.createCodelistIdentifier(this.defaultLang, ci, cDocument)) != null) {
            ec.appendChild(et);
        }
        if ((et = this.createCodelistName(this.defaultLang, ci, cDocument)) != null) {
            ec.appendChild(et);
        }
        this.createDictionaryProperties(ec, ci, cDocument);
        for (Element ea : altExprs) {
            ec.appendChild(ea);
        }
    }

    protected void createDictionaryProperties(Element ec, ClassInfo ci, Document cDocument) {
        TreeMap<String, Element> entryElmtsByGmlId = new TreeMap<String, Element>();
        for (PropertyInfo propi : ci.propertiesAll()) {
            Element entryElmt = this.createEntry(cDocument, ci, propi, true);
            if (entryElmt == null) continue;
            Element defElmt = this.isMLDictionary ? (Element)entryElmt.getElementsByTagName("gmx:ML_CodeDefinition").item(0) : (Element)entryElmt.getElementsByTagName("gmx:CodeDefinition").item(0);
            String gmlid = defElmt.getAttribute("gml:id");
            entryElmtsByGmlId.put(gmlid, entryElmt);
        }
        for (Element defElmt : entryElmtsByGmlId.values()) {
            ec.appendChild(defElmt);
        }
    }

    protected Element createDocumentNamespace(String gmlid, Document cDocument) {
        Element ec = cDocument.createElementNS(this.options.fullNamespace("gmx"), "gmx:CodeListDictionary");
        cDocument.appendChild(ec);
        this.addDocumentNamespaceAttributes(ec, cDocument);
        this.addAttribute(cDocument, ec, "gml:id", gmlid);
        this.addDocumentSchemaLocAttribute(ec, cDocument);
        return ec;
    }

    protected Element createMlDocumentNamespace(String gmlid, Document cDocument) {
        Element ec = cDocument.createElementNS(this.options.fullNamespace("gmx"), "gmx:ML_CodeListDictionary");
        cDocument.appendChild(ec);
        this.addDocumentNamespaceAttributes(ec, cDocument);
        this.addAttribute(cDocument, ec, "gml:id", gmlid);
        this.addDocumentSchemaLocAttribute(ec, cDocument);
        return ec;
    }

    protected void addDocumentNamespaceAttributes(Element ec, Document cDocument) {
        this.addAttribute(cDocument, ec, "xmlns:gml", this.options.GML_NS);
        this.addAttribute(cDocument, ec, "xmlns:gmx", this.options.fullNamespace("gmx"));
        this.addAttribute(cDocument, ec, "xmlns:gmd", this.options.fullNamespace("gmd"));
        this.addAttribute(cDocument, ec, "xmlns:gco", this.options.fullNamespace("gco"));
        this.addAttribute(cDocument, ec, "xmlns:xlink", this.options.fullNamespace("xlink"));
        this.addAttribute(cDocument, ec, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }

    protected void addDocumentSchemaLocAttribute(Element ec, Document cDocument) {
        this.addAttribute(cDocument, ec, "xsi:schemaLocation", this.options.fullNamespace("gmx") + " " + this.options.schemaLocationOfNamespace(this.options.fullNamespace("gmx")));
    }

    protected Element createCodelistDescription(String lang, ClassInfo ci, Document cDocument) {
        Element e = null;
        String s = this.getDocumentation(ci, lang);
        if (s != null && !s.isEmpty()) {
            e = cDocument.createElement("gml:description");
            e.appendChild(cDocument.createTextNode(this.omitNewlineChar(s)));
        }
        return e;
    }

    protected String getDocumentation(Info i, String lang) {
        String result = null;
        Descriptors ds = i.descriptors();
        if (ds.has(Descriptor.DOCUMENTATION)) {
            List<String> dsList = i.descriptors().values(Descriptor.DOCUMENTATION, lang);
            if (dsList.isEmpty() && lang.equalsIgnoreCase(this.defaultLang)) {
                dsList = i.descriptors().values(Descriptor.DOCUMENTATION, null);
            }
            if (!dsList.isEmpty()) {
                result = dsList.get(0);
            }
        }
        return result;
    }

    protected Element createCodelistIdentifier(String lang, ClassInfo ci, Document cDocument) {
        Element e = null;
        if (this.options.gmlVersion.equals("3.2")) {
            e = cDocument.createElement("gml:identifier");
            this.addAttribute(cDocument, e, "codeSpace", this.createClCodeSpaceContent(ci));
            e.appendChild(cDocument.createTextNode(ci.name()));
        } else if (this.options.gmlVersion.equals("3.1")) {
            e = cDocument.createElement("gml:name");
            e.appendChild(cDocument.createTextNode(ci.name()));
        }
        return e;
    }

    protected Element createCodelistName(String lang, ClassInfo ci, Document cDocument) {
        Element e = null;
        e = cDocument.createElement("gml:name");
        e.appendChild(cDocument.createTextNode(ci.name()));
        return e;
    }

    protected Element createEntry(Document lDocument, ClassInfo ci, PropertyInfo propi, boolean local) {
        HashSet<Element> eas = this.createEntryAlternLangCode(lDocument, ci, propi);
        Element e = lDocument.createElement("gmx:codeEntry");
        Element eDef = this.createEntryDefinitionContent(lDocument, ci, propi, eas);
        if (eDef != null) {
            e.appendChild(eDef);
        }
        return e;
    }

    protected HashSet<Element> createEntryAlternLangCode(Document lDocument, ClassInfo ci, PropertyInfo propi) {
        HashSet<Element> eas = null;
        for (String lang : this.langs) {
            Element et3;
            Element et2;
            if (lang.equalsIgnoreCase(this.defaultLang)) continue;
            Element ea = lDocument.createElement("gmx:alternativeExpression");
            Element eai = lDocument.createElement("gmx:CodeAlternativeExpression");
            this.addAttribute(lDocument, eai, "gml:id", this.createEntryIdentifier(lang, ci, propi));
            this.addAttribute(lDocument, eai, "codeSpace", this.createCodesCodeSpaceContent(ci, propi));
            ea.appendChild(eai);
            Element et1 = this.createEntryDescription(lang, lDocument, ci, propi);
            if (et1 != null) {
                eai.appendChild(et1);
            }
            if ((et2 = this.createEntryIdentifier(lang, lDocument, ci, propi)) != null) {
                eai.appendChild(et2);
            }
            if ((et3 = this.createEntryName(lang, lDocument, ci, propi)) != null) {
                eai.appendChild(et3);
            }
            if (et1 == null && et3 == null || et2 == null) continue;
            Element et = lDocument.createElement("gmx:locale");
            String localeVal = this.options.parameter(this.getClass().getName(), "localeRef_" + lang);
            if (StringUtils.isBlank((CharSequence)localeVal)) {
                localeVal = "FIXME_MISSING_LOCALE_REF";
                this.result.addError(this, 102, lang);
            }
            this.addAttribute(lDocument, et, "xlink:href", localeVal);
            eai.appendChild(et);
            if (eas == null) {
                eas = new HashSet<Element>();
            }
            eas.add(ea);
        }
        return eas;
    }

    protected Element createEntryDefinitionContent(Document lDocument, ClassInfo ci, PropertyInfo propi, HashSet<Element> eas) {
        Element eDef = this.createEntryDefinition(this.defaultLang, lDocument, ci, propi, eas != null);
        if (eDef != null) {
            Element et = this.createEntryDescription(this.defaultLang, lDocument, ci, propi);
            if (et != null) {
                eDef.appendChild(et);
            }
            if ((et = this.createEntryIdentifier(this.defaultLang, lDocument, ci, propi)) != null) {
                eDef.appendChild(et);
            }
            if ((et = this.createEntryName(this.defaultLang, lDocument, ci, propi)) != null) {
                eDef.appendChild(et);
            }
            if (eas != null) {
                for (Element ea : eas) {
                    eDef.appendChild(ea);
                }
            }
        }
        return eDef;
    }

    protected Element createEntryDefinition(String lang, Document lDocument, ClassInfo ci, PropertyInfo propi, boolean altEntryLangsExist) {
        Element e = altEntryLangsExist ? lDocument.createElement("gmx:ML_CodeDefinition") : lDocument.createElement("gmx:CodeDefinition");
        this.addAttribute(lDocument, e, "gml:id", this.createEntryIdentifier(lang, ci, propi));
        return e;
    }

    protected Element createEntryDescription(String lang, Document lDocument, ClassInfo ci, PropertyInfo propi) {
        Element e = null;
        String s = this.getDocumentation(propi, lang);
        if (s != null && !s.isEmpty()) {
            e = lDocument.createElement("gml:description");
            e.appendChild(lDocument.createTextNode(this.omitNewlineChar(s)));
        }
        return e;
    }

    protected Element createEntryIdentifier(String lang, Document lDocument, ClassInfo ci, PropertyInfo propi) {
        Element e = null;
        e = this.options.gmlVersion.equals("3.2") ? lDocument.createElement("gml:identifier") : lDocument.createElement("gml:name");
        this.addAttribute(lDocument, e, "codeSpace", this.createClCodeSpaceContent(ci));
        if (propi.initialValue() != null) {
            e.appendChild(lDocument.createTextNode(propi.initialValue()));
        } else {
            e.appendChild(lDocument.createTextNode(propi.name()));
        }
        return e;
    }

    protected Element createEntryName(String lang, Document lDocument, ClassInfo ci, PropertyInfo propi) {
        Element e = null;
        e = lDocument.createElement("gml:name");
        e.appendChild(lDocument.createTextNode(propi.name()));
        return e;
    }

    protected String createClCodeSpaceContent(ClassInfo ci) {
        Object codeSpace = ci.taggedValue(PARAM_INFOURL);
        if (StringUtils.isBlank((CharSequence)codeSpace)) {
            codeSpace = this.options.parameter(this.getClass().getName(), PARAM_INFOURL);
            if (StringUtils.isBlank((CharSequence)codeSpace)) {
                codeSpace = ci.pkg().targetNamespace();
            }
            codeSpace = (String)codeSpace + "/" + ci.name();
        }
        return codeSpace;
    }

    protected String createCodesCodeSpaceContent(ClassInfo ci, PropertyInfo propi) {
        Object codeSpace = ci.taggedValue(PARAM_INFOURL);
        if (StringUtils.isBlank((CharSequence)codeSpace)) {
            codeSpace = this.options.parameter(this.getClass().getName(), PARAM_INFOURL);
            if (StringUtils.isBlank((CharSequence)codeSpace)) {
                codeSpace = ci.pkg().targetNamespace();
            }
            codeSpace = (String)codeSpace + "/" + ci.name();
        }
        return codeSpace;
    }

    protected String createEntryIdentifier(String lang, ClassInfo ci, PropertyInfo propi) {
        String id;
        if (propi.matches(RULE_PROP_CODELIST_AND_CODE_NAME_AS_GML_ID)) {
            String propiName = propi.name().replaceAll("[^a-zA-Z0-9_]", "");
            id = ci.name() + "_" + propiName;
        } else {
            id = "_" + propi.id();
        }
        if (!lang.equalsIgnoreCase(this.defaultLang)) {
            id = id + "_" + lang;
        }
        return id;
    }

    protected String omitNewlineChar(String in) {
        if (this.newlineOmit && in != null) {
            return in.replaceAll("\r\n", " ");
        }
        return in;
    }

    @Override
    public void write() {
        if (this.printed) {
            return;
        }
        if (this.diagnosticsOnly) {
            return;
        }
        try {
            Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
            outputFormat.setProperty("indent", "yes");
            outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            outputFormat.setProperty("encoding", "UTF-8");
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            for (ClassInfo ci : this.model.classes(this.pi)) {
                File outDir;
                Document cDocument = this.documentMap.get(ci.id());
                if (cDocument == null) continue;
                String dir = this.options.parameter(this.getClass().getName(), "outputDirectory");
                if (dir == null) {
                    dir = this.options.parameter("outputDirectory");
                }
                if (dir == null) {
                    dir = this.options.parameter(".");
                }
                if (!(outDir = new File(dir)).exists()) {
                    outDir.mkdirs();
                }
                FileOutputStream fout = new FileOutputStream(dir + "/" + ci.name() + ".xml");
                OutputStreamWriter outputXML = new OutputStreamWriter((OutputStream)fout, outputFormat.getProperty("encoding"));
                serializer.setWriter((Writer)outputXML);
                serializer.asDOMSerializer().serialize((Node)cDocument);
                outputXML.close();
                this.result.addResult(this.getTargetName(), dir, ci.name() + ".xml", ci.qname());
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
        r.addRule(RULE_PROP_CODELIST_AND_CODE_NAME_AS_GML_ID);
    }

    @Override
    public String getTargetIdentifier() {
        return "cldml";
    }

    @Override
    public String getDefaultEncodingRule() {
        return "*";
    }

    @Override
    public String getTargetName() {
        return "Code List Dictionary";
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 100: {
                return "Code list '$1$' does not specify any code. It will be ignored.";
            }
            case 101: {
                return "Code list '$1$' is not configured to be encoded as a dictionary. It will be ignored.";
            }
            case 102: {
                return "??Configuration entry for locale reference is missing for language '$1$'";
            }
        }
        return "(" + CodelistDictionariesML.class.getName() + ") Unknown message with number: " + mnr;
    }
}

