/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Codelists;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Target;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class CodelistDictionaries
implements Target,
MessageSource {
    public static final String PARAM_IDENTIFIER = "identifier";
    public static final String PARAM_NAMES = "names";
    public static final String PARAM_GMLID = "gmlid";
    public static final String PARAM_ENUMERATIONS = "enumerations";
    private PackageInfo pi = null;
    private Model model = null;
    private Options options = null;
    private ShapeChangeResult result = null;
    private boolean diagnosticsOnly = false;
    private boolean printed = false;
    private boolean enums = false;
    private String gmlid = "id";
    private List<String> identifiers = null;
    private List<String> names = null;
    private final HashMap<String, Document> documentMap = new HashMap();
    private String documentationTemplate = null;
    private String documentationNoValue = null;

    @Override
    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        this.diagnosticsOnly = diagOnly;
        this.enums = this.options.parameterAsBoolean(this.getClass().getName(), PARAM_ENUMERATIONS, false);
        this.identifiers = this.options.parameterAsStringList(this.getClass().getName(), PARAM_IDENTIFIER, new String[]{"name"}, true, true);
        this.names = this.options.parameterAsStringList(this.getClass().getName(), PARAM_NAMES, new String[]{"alias", "initialValue"}, true, true);
        this.gmlid = this.options.parameterAsString(this.getClass().getName(), PARAM_GMLID, "id", false, false);
        this.documentationTemplate = this.options.parameter(this.getClass().getName(), "documentationTemplate");
        this.documentationNoValue = this.options.parameter(this.getClass().getName(), "documentationNoValue");
    }

    protected void addAttribute(Document document, Element e, String name, String value) {
        Attr att = document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    @Override
    public void process(ClassInfo ci) {
        int cat = ci.category();
        if (!(cat == 2 || this.enums && cat == 3)) {
            return;
        }
        if (cat == 2 && !ci.asDictionary()) {
            this.result.addInfo(this, 101, ci.name());
            return;
        }
        try {
            Element e1;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document cDocument = db.newDocument();
            ProcessingInstruction proci = null;
            if (this.options.gmlVersion.equals("3.2")) {
                proci = cDocument.createProcessingInstruction("xml-stylesheet", "type='text/xsl' href='./CodelistDictionary-v32.xsl'");
            } else if (this.options.gmlVersion.equals("3.1")) {
                proci = cDocument.createProcessingInstruction("xml-stylesheet", "type='text/xsl' href='./CodelistDictionary-v31.xsl'");
            }
            if (proci != null) {
                cDocument.appendChild(proci);
            }
            Element ec = cDocument.createElementNS(this.options.GML_NS, "gml:Dictionary");
            cDocument.appendChild(ec);
            this.addAttribute(cDocument, ec, "xmlns:gml", this.options.GML_NS);
            this.addAttribute(cDocument, ec, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.addAttribute(cDocument, ec, "xsi:schemaLocation", this.options.GML_NS + " " + this.options.schemaLocationOfNamespace(this.options.GML_NS));
            this.addAttribute(cDocument, ec, "gml:id", ci.name());
            this.documentMap.put(ci.id(), cDocument);
            String documentation = ci.derivedDocumentation(this.documentationTemplate, this.documentationNoValue);
            if (StringUtils.isNotBlank((CharSequence)documentation)) {
                Iterator<String> e12 = cDocument.createElementNS(this.options.GML_NS, "gml:description");
                e12.appendChild(cDocument.createTextNode(documentation));
                ec.appendChild((Node)((Object)e12));
            }
            for (String identifierSource : this.identifiers) {
                String identifierValue = this.getValue(ci, identifierSource);
                if (!StringUtils.isNotBlank((CharSequence)identifierValue)) continue;
                if (this.options.gmlVersion.equals("3.2")) {
                    e1 = cDocument.createElementNS(this.options.GML_NS, "gml:identifier");
                    this.addAttribute(cDocument, e1, "codeSpace", ci.pkg().targetNamespace());
                    e1.appendChild(cDocument.createTextNode(identifierValue));
                    ec.appendChild(e1);
                    break;
                }
                if (!this.options.gmlVersion.equals("3.1")) break;
                e1 = cDocument.createElementNS(this.options.GML_NS, "gml:name");
                e1.appendChild(cDocument.createTextNode(identifierValue));
                ec.appendChild(e1);
                break;
            }
            for (String nameSource : this.names) {
                String nameValue = this.getValue(ci, nameSource);
                if (!StringUtils.isNotBlank((CharSequence)nameValue)) continue;
                e1 = cDocument.createElementNS(this.options.GML_NS, "gml:name");
                e1.appendChild(cDocument.createTextNode(nameValue));
                ec.appendChild(e1);
            }
            TreeMap<String, Element> entryElmtsByGmlId = new TreeMap<String, Element>();
            for (PropertyInfo propi : ci.propertiesAll()) {
                Element entryElmt = this.createEntry(cDocument, ci, propi, true);
                if (entryElmt == null) continue;
                String gmlid = ((Element)entryElmt.getElementsByTagName("gml:Definition").item(0)).getAttribute("gml:id");
                entryElmtsByGmlId.put(gmlid, entryElmt);
            }
            for (Element defElmt : entryElmtsByGmlId.values()) {
                ec.appendChild(defElmt);
            }
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(null, 2);
            String m = e.getMessage();
            if (m != null) {
                this.result.addFatalError(m);
            }
            e.printStackTrace(System.err);
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addFatalError(m);
            }
            e.printStackTrace(System.err);
        }
    }

    private Element createEntry(Document lDocument, ClassInfo ci, PropertyInfo propi, boolean local) {
        Element e2;
        Element e = lDocument.createElementNS(this.options.GML_NS, "gml:dictionaryEntry");
        Element e3 = lDocument.createElementNS(this.options.GML_NS, "gml:Definition");
        Object gmlIdValue = this.getValue(propi, this.gmlid);
        if (StringUtils.isNotBlank((CharSequence)gmlIdValue)) {
            if (!((String)gmlIdValue).matches("^[a-zA-Z_].*")) {
                gmlIdValue = "_" + (String)gmlIdValue;
            }
        } else {
            gmlIdValue = "_" + propi.id();
        }
        this.addAttribute(lDocument, e3, "gml:id", (String)gmlIdValue);
        e.appendChild(e3);
        String defDescription = propi.derivedDocumentation(this.documentationTemplate, this.documentationNoValue);
        if (StringUtils.isNotBlank((CharSequence)defDescription)) {
            e2 = lDocument.createElementNS(this.options.GML_NS, "gml:description");
            e2.appendChild(lDocument.createTextNode(defDescription));
            e3.appendChild(e2);
        }
        e2 = this.options.gmlVersion.equals("3.2") ? lDocument.createElementNS(this.options.GML_NS, "gml:identifier") : lDocument.createElementNS(this.options.GML_NS, "gml:name");
        Object codeSpace = ci.taggedValue("codeList");
        if (StringUtils.isBlank((CharSequence)codeSpace)) {
            codeSpace = ci.taggedValue("infoURL");
        }
        if (StringUtils.isBlank((CharSequence)codeSpace)) {
            codeSpace = ci.pkg().targetNamespace() + "/" + ci.name();
        }
        this.addAttribute(lDocument, e2, "codeSpace", (String)codeSpace);
        for (String identifierSource : this.identifiers) {
            String identifierValue = this.getValue(propi, identifierSource);
            if (!StringUtils.isNotBlank((CharSequence)identifierValue)) continue;
            e2.appendChild(lDocument.createTextNode(identifierValue));
            e3.appendChild(e2);
            break;
        }
        for (String nameSource : this.names) {
            String nameValue = this.getValue(propi, nameSource);
            if (!StringUtils.isNotBlank((CharSequence)nameValue)) continue;
            Element e1 = lDocument.createElementNS(this.options.GML_NS, "gml:name");
            e1.appendChild(lDocument.createTextNode(nameValue));
            e3.appendChild(e1);
        }
        return e;
    }

    private String getValue(Info i, String source) {
        String s = null;
        if (source.equalsIgnoreCase("name")) {
            s = i.name();
        } else if (source.equalsIgnoreCase("alias")) {
            s = i.aliasName();
        } else if (source.equalsIgnoreCase("id")) {
            s = i.id();
        } else if (source.equalsIgnoreCase("initialValue") && i instanceof PropertyInfo) {
            s = ((PropertyInfo)i).initialValue();
        } else if (source.startsWith("@")) {
            s = i.taggedValue(source.substring(1));
        }
        return s;
    }

    @Override
    public void write() {
        if (this.printed) {
            return;
        }
        if (this.diagnosticsOnly) {
            return;
        }
        try {
            Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
            outputFormat.setProperty("indent", "yes");
            outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            outputFormat.setProperty("encoding", "UTF-8");
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            for (ClassInfo ci : this.model.classes(this.pi)) {
                File outDir;
                Document cDocument = this.documentMap.get(ci.id());
                if (cDocument == null) continue;
                String dir = this.options.parameter(this.getClass().getName(), "outputDirectory");
                if (dir == null) {
                    dir = this.options.parameter("outputDirectory");
                }
                if (dir == null) {
                    dir = this.options.parameter(".");
                }
                if (!(outDir = new File(dir)).exists()) {
                    outDir.mkdirs();
                }
                FileOutputStream fout = new FileOutputStream(dir + "/" + ci.name() + ".xml");
                OutputStreamWriter outputXML = new OutputStreamWriter((OutputStream)fout, outputFormat.getProperty("encoding"));
                serializer.setWriter((Writer)outputXML);
                serializer.asDOMSerializer().serialize((Node)cDocument);
                outputXML.close();
                this.result.addResult(this.getTargetName(), dir, ci.name() + ".xml", ci.qname());
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
        this.printed = true;
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
    }

    @Override
    public String getTargetName() {
        return "Code List Dictionary";
    }

    @Override
    public String getTargetIdentifier() {
        return "cld";
    }

    @Override
    public String getDefaultEncodingRule() {
        return "*";
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 101: {
                return "Code list '$1$' is not configured to be encoded as a dictionary. It will be ignored.";
            }
        }
        return "(" + CodelistDictionaries.class.getName() + ") Unknown message with number: " + mnr;
    }
}

