/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.CDB;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import org.apache.commons.lang3.StringUtils;

public class CDBFeature {
    protected String code = null;
    protected String label = null;
    protected String conceptDefinition = null;
    protected String origin = "";
    protected ClassInfo classInfo = null;

    public CDBFeature(ClassInfo ci) {
        PackageInfo schema;
        this.classInfo = ci;
        this.code = ci.name();
        this.label = StringUtils.isNotBlank((CharSequence)ci.aliasName()) ? ci.aliasName().trim() : ci.name();
        this.conceptDefinition = ci.definition();
        if (StringUtils.isNotBlank((CharSequence)ci.description())) {
            this.conceptDefinition = this.conceptDefinition + " [descr] " + ci.description().trim();
        }
        if ((schema = ci.pkg().rootPackage()) != null) {
            this.origin = schema.name();
            if (schema.version() != null) {
                this.origin = this.origin + " " + schema.version();
            }
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getLabel() {
        return this.label;
    }

    public String getConceptDefinition() {
        return this.conceptDefinition;
    }

    public String getOrigin() {
        return this.origin;
    }

    public ClassInfo classInfo() {
        return this.classInfo;
    }
}

