/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.CDB;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.MapEntryParamInfos;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CDBConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("unitsToIgnore", "version").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;

    @Override
    public boolean isValid(ProcessConfiguration config, Options options, ShapeChangeResult result) {
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTargetParameters());
        isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, config.getParameters().keySet(), result) && isValid;
        TreeMap<String, ProcessMapEntry> mapEntryByType = new TreeMap<String, ProcessMapEntry>();
        for (ProcessMapEntry pme : config.getMapEntries()) {
            mapEntryByType.put(pme.getType(), pme);
        }
        MapEntryParamInfos mepis = new MapEntryParamInfos(result, mapEntryByType.values());
        isValid = isValid && mepis.isValid();
        for (ProcessMapEntry pme : mapEntryByType.values()) {
            if (pme.hasTargetType() || pme.getTargetType().equalsIgnoreCase("Text") || pme.getTargetType().equalsIgnoreCase("Numeric") || pme.getTargetType().equalsIgnoreCase("Boolean")) continue;
            result.addError(this, 100, pme.getType(), pme.getRule());
            isValid = false;
        }
        return isValid;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 100: {
                return "The target type of map entry with type '$1$' and rule '$2$' is invalid. It must be one of (ignoring case): Text, Numeric, Boolean.";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

