/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.CDB;

import de.interactive_instruments.ShapeChange.Target.CDB.CDBSubcategory;
import java.util.SortedMap;
import java.util.TreeMap;

public class CDBCategory {
    protected String code = null;
    protected String label = null;
    protected SortedMap<String, CDBSubcategory> subcategoriesByCode = new TreeMap<String, CDBSubcategory>();
    protected CDBSubcategory defaultSubcategory = null;

    public CDBCategory() {
    }

    public CDBCategory(String code, String label) {
        this.code = code;
        this.label = label;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public CDBSubcategory getDefaultSubcategory() {
        if (this.defaultSubcategory == null) {
            this.defaultSubcategory = new CDBSubcategory("Default", "Default");
            this.subcategoriesByCode.put(this.defaultSubcategory.getCode(), this.defaultSubcategory);
        }
        return this.defaultSubcategory;
    }

    public boolean hasSubcategory(String subcatcode) {
        return this.subcategoriesByCode.containsKey(subcatcode);
    }

    public CDBSubcategory getSubcategory(String subcatcode) {
        return (CDBSubcategory)this.subcategoriesByCode.get(subcatcode);
    }

    public void add(CDBSubcategory subcat) {
        this.subcategoriesByCode.put(subcat.getCode(), subcat);
    }

    public SortedMap<String, CDBSubcategory> getSubcategoriesByCode() {
        return this.subcategoriesByCode;
    }
}

