/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.CDB;

import de.interactive_instruments.ShapeChange.MapEntryParamInfos;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.Target.CDB.CDBRange;
import de.interactive_instruments.ShapeChange.Target.CDB.CDBUnit;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CDBAttribute {
    protected int code;
    protected String symbol;
    protected String name;
    protected String description;
    protected Type type;
    protected Format format = null;
    protected CDBRange range = null;
    protected String length = null;
    protected CDBUnit unit = null;
    protected PropertyInfo propertyInfo;

    public CDBAttribute(PropertyInfo pi, MapEntryParamInfos mapEntryParamInfos) {
        this.propertyInfo = pi;
        String piEncodingRule = pi.encodingRule("cdb");
        Options options = pi.options();
        this.symbol = pi.name();
        this.name = ((String)StringUtils.defaultIfBlank((CharSequence)pi.aliasName(), (CharSequence)pi.name())).trim();
        this.description = pi.definition();
        if (StringUtils.isNotBlank((CharSequence)pi.description())) {
            this.description = this.description + " [descr] " + pi.description().trim();
        }
        this.type = Type.TEXT;
        ProcessMapEntry pme = options.targetMapEntry(pi.typeInfo().name, piEncodingRule);
        if (pme != null) {
            Map<String, String> characteristics;
            this.type = Type.valueOf(pme.getTargetType().toUpperCase(Locale.ENGLISH));
            if (mapEntryParamInfos.hasParameter(pi.typeInfo().name, piEncodingRule, "numericFormat") && (characteristics = mapEntryParamInfos.getCharacteristics(pi.typeInfo().name, piEncodingRule, "numericFormat")) != null) {
                for (String characteristic : characteristics.keySet()) {
                    if (characteristic.equalsIgnoreCase("Floating-Point") || characteristic.equalsIgnoreCase("FloatingPoint")) {
                        this.format = Format.FLOATINGPOINT;
                        break;
                    }
                    if (!characteristic.equalsIgnoreCase("Integer")) continue;
                    this.format = Format.INTEGER;
                    break;
                }
            }
        }
        String rangeMin = StringUtils.stripToNull((String)pi.taggedValue("rangeMinimum"));
        String rangeMax = StringUtils.stripToNull((String)pi.taggedValue("rangeMaximum"));
        if (rangeMin != null || rangeMax != null) {
            this.range = new CDBRange(null, rangeMin, rangeMax);
        }
        this.length = StringUtils.stripToNull((String)pi.taggedValue("length"));
    }

    public int getCode() {
        return this.code;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public CDBUnit getUnit() {
        return this.unit;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setUnit(CDBUnit unit) {
        this.unit = unit;
    }

    public Type getType() {
        return this.type;
    }

    public Format getFormat() {
        return this.format;
    }

    public CDBRange getRange() {
        return this.range;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public PropertyInfo propertyInfo() {
        return this.propertyInfo;
    }

    public boolean hasFormat() {
        return this.format != null;
    }

    public boolean hasRange() {
        return this.range != null;
    }

    public String getLength() {
        return this.length;
    }

    public boolean hasLength() {
        return this.length != null;
    }

    public boolean hasUnit() {
        return this.unit != null;
    }

    public static enum Format {
        FLOATINGPOINT,
        INTEGER;

    }

    public static enum Type {
        TEXT,
        NUMERIC,
        BOOLEAN;

    }
}

