/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.CDB;

import com.google.common.base.Joiner;
import de.interactive_instruments.ShapeChange.MapEntryParamInfos;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.CDB.CDBAttribute;
import de.interactive_instruments.ShapeChange.Target.CDB.CDBCategory;
import de.interactive_instruments.ShapeChange.Target.CDB.CDBFeature;
import de.interactive_instruments.ShapeChange.Target.CDB.CDBSubcategory;
import de.interactive_instruments.ShapeChange.Target.CDB.CDBUnit;
import de.interactive_instruments.ShapeChange.Target.SingleTarget;
import de.interactive_instruments.ShapeChange.Util.XMLUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CDB
implements SingleTarget,
MessageSource {
    public static final String NS_FDD = "http://www.opengis.net/cdb/1.0/Feature_Data_Dictionary";
    public static final String NS_AD = "http://www.opengis.net/cdb/1.0/Vector_Attributes";
    public static final String NSABR = "cdb";
    public static final String MAPENTRY_PARAM_NUMERIC_FORMAT = "numericFormat";
    public static final String MAPENTRY_PARAM_NUMERIC_FORMAT_FLOATINGPOINT = "Floating-Point";
    public static final String MAPENTRY_PARAM_NUMERIC_FORMAT_INTEGER = "Integer";
    private static final String FEATURE_DICTIONARY_FILENAME_SUFFIX = "_Feature_Data_Dictionary.xml";
    private static final String ATTRIBUTES_DICTIONARY_FILENAME_SUFFIX = "_Attributes.xml";
    public static final String PARAM_VERSION = "version";
    public static final String PARAM_UNITS_TO_IGNORE = "unitsToIgnore";
    public static final String RULE_TGT_CDB_ALL_NOTENCODED = "rule-cdb-all-notEncoded";
    public static final String RULE_TGT_CDB_ALL_VALUETYPETEXT_FOR_UNION_REPRESENTING_FEATURESET = "rule-cdb-all-valueTypeTextForUnionRepresentingFeatureSet";
    protected static boolean initialised = false;
    protected static boolean atLeastOneSchemaIsEncoded = false;
    protected static MapEntryParamInfos mapEntryParamInfos = null;
    protected static SortedSet<ClassInfo> featureTypes = new TreeSet<ClassInfo>();
    protected static Map<String, CDBUnit> unitDefsFromConfigByName = new HashMap<String, CDBUnit>();
    protected static Set<String> unitsToIgnore = new HashSet<String>();
    protected static SortedSet<String> schemaVersions = new TreeSet<String>();
    private static File outputDirectoryFile;
    private static String outputDirectory;
    private static String outputFilename;
    private static boolean diagnosticsOnly;
    private boolean schemaNotEncoded = false;
    private ShapeChangeResult result = null;
    private PackageInfo schema = null;
    private Options options = null;

    @Override
    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        this.schema = p;
        this.options = o;
        this.result = r;
        diagnosticsOnly = diagOnly;
        if (!CDB.isEncoded(this.schema)) {
            this.schemaNotEncoded = true;
            this.result.addInfo(this, 7, this.schema.name());
            return;
        }
        atLeastOneSchemaIsEncoded = true;
        this.result.addDebug(this, 1, this.schema.name());
        if (!initialised) {
            initialised = true;
            outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
            if (outputDirectory == null) {
                outputDirectory = this.options.parameter("outputDirectory");
            }
            if (outputDirectory == null) {
                outputDirectory = this.options.parameter(".");
            }
            outputFilename = this.options.getCurrentProcessConfig().parameterAsString("outputFilename", "ApplicationSchema", false, true);
            outputDirectoryFile = new File(outputDirectory);
            boolean exi = outputDirectoryFile.exists();
            if (!exi) {
                try {
                    FileUtils.forceMkdir((File)outputDirectoryFile);
                }
                catch (IOException e) {
                    this.result.addError(null, 600, e.getMessage());
                    e.printStackTrace(System.err);
                }
                exi = outputDirectoryFile.exists();
            }
            boolean dir = outputDirectoryFile.isDirectory();
            boolean wrt = outputDirectoryFile.canWrite();
            boolean rea = outputDirectoryFile.canRead();
            if (!(exi && dir && wrt && rea)) {
                this.result.addFatalError(null, 601, outputDirectory);
                throw new ShapeChangeAbortException();
            }
            this.deleteFileIfExists(outputDirectoryFile, outputFilename + FEATURE_DICTIONARY_FILENAME_SUFFIX);
            this.deleteFileIfExists(outputDirectoryFile, outputFilename + ATTRIBUTES_DICTIONARY_FILENAME_SUFFIX);
            List<ProcessMapEntry> mapEntries = this.options.getCurrentProcessConfig().getMapEntries();
            if (mapEntries.isEmpty()) {
                this.result.addWarning(this, 15);
            } else {
                mapEntryParamInfos = new MapEntryParamInfos(this.result, mapEntries);
            }
            unitsToIgnore.addAll(this.options.getCurrentProcessConfig().parameterAsStringList(PARAM_UNITS_TO_IGNORE, null, true, true));
            if (this.options.getCurrentProcessConfig().getAdvancedProcessConfigurations() == null) {
                this.result.addInfo(this, 12);
            } else {
                Element advancedProcessConfigElmt = this.options.getCurrentProcessConfig().getAdvancedProcessConfigurations();
                ArrayList<Element> unitDefEs = new ArrayList<Element>();
                NodeList udNl = advancedProcessConfigElmt.getElementsByTagName("CDBUnitDefinition");
                if (udNl != null && udNl.getLength() != 0) {
                    for (int k = 0; k < udNl.getLength(); ++k) {
                        Node n = udNl.item(k);
                        if (n.getNodeType() != 1) continue;
                        unitDefEs.add((Element)n);
                    }
                }
                for (int i = 0; i < unitDefEs.size(); ++i) {
                    Element nameE;
                    String name;
                    String indexForMsg = "" + (i + 1);
                    Element unitDefE = (Element)unitDefEs.get(i);
                    Integer code = null;
                    if (unitDefE.hasAttribute("code")) {
                        String codeS = unitDefE.getAttribute("code");
                        try {
                            int tmp = Integer.parseInt(codeS);
                            code = tmp;
                        }
                        catch (NumberFormatException e) {
                            this.result.addError(this, 16, indexForMsg, codeS);
                            continue;
                        }
                    }
                    if ((name = StringUtils.stripToEmpty((String)(nameE = XMLUtil.getFirstElement(unitDefE, "name")).getTextContent())).isEmpty()) {
                        this.result.addError(this, 13, "name", indexForMsg);
                        continue;
                    }
                    HashSet<String> aliasNames = new HashSet<String>();
                    ArrayList<Element> aliasNameElmts = new ArrayList<Element>();
                    NodeList anNl = unitDefE.getElementsByTagName("alias");
                    if (anNl != null && anNl.getLength() != 0) {
                        for (int k = 0; k < anNl.getLength(); ++k) {
                            Node n = anNl.item(k);
                            if (n.getNodeType() != 1) continue;
                            aliasNameElmts.add((Element)n);
                        }
                    }
                    for (int anIndex = 0; anIndex < aliasNameElmts.size(); ++anIndex) {
                        String aliasName = StringUtils.stripToEmpty((String)((Element)aliasNameElmts.get(anIndex)).getTextContent());
                        if (aliasName.isEmpty()) {
                            this.result.addError(this, 13, "alias", indexForMsg);
                            continue;
                        }
                        aliasNames.add(aliasName);
                    }
                    String symbol = StringUtils.stripToEmpty((String)unitDefE.getAttribute("symbol"));
                    if (symbol.isEmpty()) {
                        this.result.addError(this, 17, indexForMsg);
                        continue;
                    }
                    Element descrE = XMLUtil.getFirstElement(unitDefE, "description");
                    String description = null;
                    if (descrE != null) {
                        description = StringUtils.stripToEmpty((String)descrE.getTextContent());
                    }
                    CDBUnit unit = new CDBUnit(code, symbol, name, aliasNames, description);
                    unitDefsFromConfigByName.put(name, unit);
                    for (String aliasName : aliasNames) {
                        unitDefsFromConfigByName.put(aliasName, unit);
                    }
                }
            }
        }
    }

    private void deleteFileIfExists(File directoryFile, String filename) {
        File file = new File(directoryFile, filename);
        boolean exi = file.exists();
        if (exi) {
            this.result.addInfo(this, 3, file.getAbsolutePath());
            try {
                FileUtils.forceDelete((File)file);
                this.result.addInfo(this, 4);
            }
            catch (IOException e) {
                this.result.addInfo(null, 600, e.getMessage());
            }
        }
    }

    @Override
    public String getTargetName() {
        return "CDB";
    }

    @Override
    public void process(ClassInfo ci) {
        if (ci == null || ci.pkg() == null) {
            return;
        }
        if (!CDB.isEncoded(ci)) {
            this.result.addInfo(this, 8, ci.name());
            return;
        }
        this.result.addDebug(this, 6, ci.name());
        if (this.schemaNotEncoded) {
            this.result.addInfo(this, 9, this.schema.name(), ci.name());
            return;
        }
        if (ci.category() == 1) {
            featureTypes.add(ci);
            schemaVersions.add(this.schema.version());
        } else if (ci.category() != 8 || !ci.matches(RULE_TGT_CDB_ALL_VALUETYPETEXT_FOR_UNION_REPRESENTING_FEATURESET) || !"true".equalsIgnoreCase(ci.taggedValue("representsFeatureTypeSet"))) {
            this.result.addDebug(this, 10, ci.name());
        }
    }

    protected void addAttribute(Element e, String name, String value) {
        Document document = e.getOwnerDocument();
        if (document == null) {
            e.setAttribute(name, value);
        } else {
            Attr att = document.createAttribute(name);
            att.setValue(value);
            e.setAttributeNode(att);
        }
    }

    public static boolean isEncoded(Info i) {
        return !i.matches(RULE_TGT_CDB_ALL_NOTENCODED) || !i.encodingRule(NSABR).equalsIgnoreCase("notencoded");
    }

    @Override
    public void write() {
    }

    @Override
    public void writeAll(ShapeChangeResult result) {
        this.result = result;
        this.options = result.options();
        if (diagnosticsOnly || !atLeastOneSchemaIsEncoded) {
            return;
        }
        if (featureTypes.isEmpty()) {
            result.addInfo(this, 11);
        }
        String defaultVersion = Joiner.on((String)",").skipNulls().join(schemaVersions);
        String version = this.options.parameterAsString(this.getClass().getName(), PARAM_VERSION, defaultVersion, false, true);
        this.createFeatureDataDictionary(version);
        this.createAttributesDictionary(version);
    }

    /*
     * WARNING - void declaration
     */
    private void createAttributesDictionary(String version) {
        TreeMap<String, CDBAttribute> attributesBySymbol = new TreeMap<String, CDBAttribute>();
        TreeMap<String, CDBUnit> usedUnitsByName = new TreeMap<String, CDBUnit>();
        for (ClassInfo classInfo : featureTypes) {
            for (PropertyInfo pi : classInfo.properties().values()) {
                CDBAttribute attribute;
                String piEncodingRule = pi.encodingRule(NSABR);
                ProcessMapEntry pme = this.options.targetMapEntry(pi.typeInfo().name, piEncodingRule);
                if (pme == null) {
                    ClassInfo typeCi = pi.model().classById(pi.typeInfo().id);
                    if (typeCi == null) {
                        typeCi = pi.model().classByName(pi.typeInfo().name);
                    }
                    if (typeCi == null || typeCi.category() != 1 && typeCi.category() != 3 && typeCi.category() != 2 && (typeCi.category() != 8 || !typeCi.matches(RULE_TGT_CDB_ALL_VALUETYPETEXT_FOR_UNION_REPRESENTING_FEATURESET) || !"true".equalsIgnoreCase(typeCi.taggedValue("representsFeatureTypeSet")))) {
                        this.result.addError(this, 14, pi.typeInfo().name);
                        continue;
                    }
                }
                if (attributesBySymbol.containsKey((attribute = new CDBAttribute(pi, mapEntryParamInfos)).getSymbol())) {
                    ShapeChangeResult.MessageContext mc;
                    String attMax;
                    CDBAttribute exAtt = (CDBAttribute)attributesBySymbol.get(attribute.getSymbol());
                    String exAttMin = exAtt.hasRange() ? StringUtils.stripToEmpty((String)exAtt.getRange().getMin()) : "";
                    String exAttMax = exAtt.hasRange() ? StringUtils.stripToEmpty((String)exAtt.getRange().getMax()) : "";
                    String attMin = attribute.hasRange() ? StringUtils.stripToEmpty((String)attribute.getRange().getMin()) : "";
                    String string = attMax = attribute.hasRange() ? StringUtils.stripToEmpty((String)attribute.getRange().getMax()) : "";
                    if (attribute.getDescription().equalsIgnoreCase(exAtt.getDescription()) && attribute.getType() == exAtt.getType() && attribute.getFormat() == exAtt.getFormat() && StringUtils.equals((CharSequence)attribute.getLength(), (CharSequence)exAtt.getLength()) && exAttMin.equals(attMin) && exAttMax.equals(attMax) || (mc = this.result.addWarning(this, 157)) == null) continue;
                    mc.addDetail(this, 150, exAtt.propertyInfo().fullNameInSchema());
                    mc.addDetail(this, 151, attribute.propertyInfo().fullNameInSchema());
                    if (!attribute.getDescription().equalsIgnoreCase(exAtt.getDescription())) {
                        mc.addDetail(this, 152, exAtt.getDescription(), attribute.getDescription());
                    }
                    if (attribute.getType() != exAtt.getType()) {
                        mc.addDetail(this, 153, "" + exAtt.getType(), "" + attribute.getType());
                    }
                    if (attribute.getFormat() != exAtt.getFormat()) {
                        String exAttFormat = exAtt.hasFormat() ? "" + exAtt.getFormat() : "<none>";
                        String attFormat = attribute.hasFormat() ? "" + attribute.getFormat() : "<none>";
                        mc.addDetail(this, 154, exAttFormat, attFormat);
                    }
                    if (!StringUtils.equals((CharSequence)attribute.getLength(), (CharSequence)exAtt.getLength())) {
                        String exAttLength = (String)StringUtils.defaultIfBlank((CharSequence)exAtt.getLength(), (CharSequence)"<none>");
                        String attLength = (String)StringUtils.defaultIfBlank((CharSequence)attribute.getLength(), (CharSequence)"<none>");
                        mc.addDetail(this, 155, exAttLength, attLength);
                    }
                    if (exAttMin.equals(attMin) && exAttMax.equals(attMax)) continue;
                    mc.addDetail(this, 156, exAttMin, exAttMax, attMin, attMax);
                    continue;
                }
                attributesBySymbol.put(attribute.getSymbol(), attribute);
                String uom = StringUtils.stripToNull((String)pi.taggedValue("recommendedMeasure"));
                if (uom == null || unitsToIgnore.contains(uom)) continue;
                if (unitDefsFromConfigByName.containsKey(uom)) {
                    CDBUnit unit = unitDefsFromConfigByName.get(uom);
                    attribute.setUnit(unit);
                    usedUnitsByName.put(uom, unit);
                    continue;
                }
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 200, uom, pi.name());
                if (mc == null) continue;
                mc.addDetail(this, 1, pi.fullNameInSchema());
            }
        }
        int attCounter = 0;
        for (Iterator att : attributesBySymbol.values()) {
            ((CDBAttribute)((Object)att)).setCode(++attCounter);
        }
        boolean bl = false;
        for (CDBUnit unit : usedUnitsByName.values()) {
            int n;
            if (!unit.hasCode() || unit.getCode() <= n) continue;
            n = unit.getCode();
        }
        for (CDBUnit unit : usedUnitsByName.values()) {
            void var5_10;
            if (unit.hasCode()) continue;
            unit.setCode((int)(++var5_10));
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.newDocument();
            Element root = document.createElementNS(NS_AD, "Vector_Attributes");
            document.appendChild(root);
            this.addAttribute(root, "xmlns", NS_AD);
            this.addAttribute(root, PARAM_VERSION, version);
            Element attsElmt = this.addElement(NS_AD, "Attributes", root);
            for (CDBAttribute att : attributesBySymbol.values()) {
                Element attElmt = this.addElement(NS_AD, "Attribute", attsElmt);
                this.addAttribute(attElmt, "code", "" + att.getCode());
                this.addAttribute(attElmt, "symbol", att.getSymbol());
                this.addElement(NS_AD, "Name", attElmt, att.getName());
                this.addElement(NS_AD, "Description", attElmt, att.getDescription());
                Element levelElmt = this.addElement(NS_AD, "Level", attElmt);
                this.addElement(NS_AD, "Instance", levelElmt, "Preferred");
                this.addElement(NS_AD, "Class", levelElmt, "Not Supported");
                this.addElement(NS_AD, "Extended", levelElmt, "Not Supported");
                Element valueElmt = this.addElement(NS_AD, "Value", attElmt);
                Element valueTypeElmt = this.addElement(NS_AD, "Type", valueElmt);
                if (att.getType() == CDBAttribute.Type.NUMERIC) {
                    valueTypeElmt.setTextContent("Numeric");
                } else if (att.getType() == CDBAttribute.Type.BOOLEAN) {
                    valueTypeElmt.setTextContent("Boolean");
                } else {
                    valueTypeElmt.setTextContent("Text");
                }
                if (att.hasFormat()) {
                    Element valueFormatElmt = this.addElement(NS_AD, "Format", valueElmt);
                    if (att.getFormat() == CDBAttribute.Format.INTEGER) {
                        valueFormatElmt.setTextContent(MAPENTRY_PARAM_NUMERIC_FORMAT_INTEGER);
                    } else {
                        valueFormatElmt.setTextContent(MAPENTRY_PARAM_NUMERIC_FORMAT_FLOATINGPOINT);
                    }
                }
                if (att.hasRange()) {
                    Element valueRangeElmt = this.addElement(NS_AD, "Range", valueElmt);
                    if (att.getRange().getMin() != null) {
                        this.addElement(NS_AD, "Min", valueRangeElmt, att.getRange().getMin());
                    }
                    if (att.getRange().getMax() != null) {
                        this.addElement(NS_AD, "Max", valueRangeElmt, att.getRange().getMax());
                    }
                }
                if (att.hasLength()) {
                    this.addElement(NS_AD, "length", valueElmt, att.getLength());
                }
                if (!att.hasUnit()) continue;
                this.addElement(NS_AD, "Unit", valueElmt, "" + att.getUnit().getCode());
            }
            if (!usedUnitsByName.isEmpty()) {
                Element unitsElmt = this.addElement(NS_AD, "Units", root);
                for (CDBUnit unit : usedUnitsByName.values()) {
                    Element unitElmt = this.addElement(NS_AD, "Unit", unitsElmt);
                    this.addAttribute(unitElmt, "code", "" + unit.getCode());
                    this.addAttribute(unitElmt, "symbol", unit.getSymbol());
                    this.addElement(NS_AD, "Name", unitElmt, unit.getName());
                    this.addElement(NS_AD, "Description", unitElmt, unit.getDescription());
                }
            }
            this.print(document, ATTRIBUTES_DICTIONARY_FILENAME_SUFFIX);
        }
        catch (ParserConfigurationException e) {
            this.result.addError(null, 2);
        }
    }

    private void createFeatureDataDictionary(String version) {
        TreeMap<String, CDBCategory> categoriesByCode = new TreeMap<String, CDBCategory>();
        CDBCategory defaultCategory = null;
        for (ClassInfo ci : featureTypes) {
            String catlabel;
            String catcode;
            CDBSubcategory subcat;
            CDBCategory cat;
            PackageInfo pkg = ci.pkg();
            PackageInfo parentPkg = pkg.owner();
            if (pkg.isSchema()) {
                if (defaultCategory == null) {
                    defaultCategory = new CDBCategory("Default", "Default");
                    categoriesByCode.put(defaultCategory.getCode(), defaultCategory);
                }
                cat = defaultCategory;
                subcat = defaultCategory.getDefaultSubcategory();
            } else if (parentPkg.isSchema()) {
                catcode = this.getCode(pkg);
                if (categoriesByCode.containsKey(catcode)) {
                    cat = (CDBCategory)categoriesByCode.get(catcode);
                } else {
                    catlabel = this.getLabel(pkg);
                    cat = new CDBCategory(catcode, catlabel);
                    categoriesByCode.put(cat.getCode(), cat);
                }
                subcat = cat.getDefaultSubcategory();
            } else {
                catcode = this.getCode(parentPkg);
                if (categoriesByCode.containsKey(catcode)) {
                    cat = (CDBCategory)categoriesByCode.get(catcode);
                } else {
                    catlabel = this.getLabel(parentPkg);
                    cat = new CDBCategory(catcode, catlabel);
                    categoriesByCode.put(cat.getCode(), cat);
                }
                String subcatcode = this.getCode(pkg);
                if (cat.hasSubcategory(subcatcode)) {
                    subcat = cat.getSubcategory(subcatcode);
                } else {
                    String subcatlabel = this.getLabel(pkg);
                    subcat = new CDBSubcategory(subcatcode, subcatlabel);
                    cat.add(subcat);
                }
            }
            CDBFeature feature = new CDBFeature(ci);
            if (subcat.hasFeature(feature.getCode())) {
                ShapeChangeResult.MessageContext mc;
                CDBFeature existingFeature = subcat.getFeature(feature.getCode());
                if (!feature.getLabel().equalsIgnoreCase(existingFeature.getLabel()) && (mc = this.result.addWarning(this, 100, existingFeature.getLabel(), feature.getLabel())) != null) {
                    mc.addDetail(this, 102, existingFeature.classInfo().fullNameInSchema());
                    mc.addDetail(this, 103, feature.classInfo().fullNameInSchema());
                }
                if (feature.getConceptDefinition().equalsIgnoreCase(existingFeature.getConceptDefinition()) || (mc = this.result.addWarning(this, 101, existingFeature.getConceptDefinition(), feature.getConceptDefinition())) == null) continue;
                mc.addDetail(this, 102, existingFeature.classInfo().fullNameInSchema());
                mc.addDetail(this, 103, feature.classInfo().fullNameInSchema());
                continue;
            }
            subcat.add(feature);
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.newDocument();
            Element root = document.createElementNS(NS_FDD, "Feature_Data_Dictionary");
            document.appendChild(root);
            this.addAttribute(root, "xmlns", NS_FDD);
            this.addAttribute(root, PARAM_VERSION, version);
            for (CDBCategory cat : categoriesByCode.values()) {
                Element catElmt = this.addElement(NS_FDD, "Category", root);
                this.addAttribute(catElmt, "code", cat.getCode());
                this.addElement(NS_FDD, "Label", catElmt, cat.getLabel());
                for (CDBSubcategory subcat : cat.getSubcategoriesByCode().values()) {
                    Element subcatElmt = this.addElement(NS_FDD, "Subcategory", catElmt);
                    this.addAttribute(subcatElmt, "code", subcat.getCode());
                    this.addElement(NS_FDD, "Label", subcatElmt, subcat.getLabel());
                    for (CDBFeature feature : subcat.getFeatures().values()) {
                        Element featureElmt = this.addElement(NS_FDD, "Feature_Type", subcatElmt);
                        this.addAttribute(featureElmt, "code", feature.getCode());
                        this.addElement(NS_FDD, "Label", featureElmt, feature.getLabel());
                        Element subCodeElmt = this.addElement(NS_FDD, "Subcode", featureElmt);
                        this.addAttribute(subCodeElmt, "code", "000");
                        this.addElement(NS_FDD, "Label", subCodeElmt, feature.getLabel());
                        this.addElement(NS_FDD, "Concept_Definition", subCodeElmt, feature.getConceptDefinition());
                        this.addElement(NS_FDD, "Recommended_Dataset_Component", subCodeElmt);
                        this.addElement(NS_FDD, "Origin", subCodeElmt, feature.getOrigin());
                    }
                }
            }
            this.print(document, FEATURE_DICTIONARY_FILENAME_SUFFIX);
        }
        catch (ParserConfigurationException e) {
            this.result.addError(null, 2);
        }
    }

    protected Element addElement(String namespace, String elementName, Element parent) {
        Document document = parent.getOwnerDocument();
        Element el = document.createElementNS(namespace, elementName);
        parent.appendChild(el);
        return el;
    }

    protected Element addElement(String namespace, String elementName, Element parent, String textValue) {
        Element el = this.addElement(namespace, elementName, parent);
        el.setTextContent(textValue);
        return el;
    }

    private String getCode(Info i) {
        if (StringUtils.isNotBlank((CharSequence)i.primaryCode())) {
            return i.primaryCode().trim();
        }
        return i.name();
    }

    private String getLabel(Info i) {
        if (StringUtils.isNotBlank((CharSequence)i.aliasName())) {
            return i.aliasName().trim();
        }
        return i.name();
    }

    private void print(Document document, String filenameSuffix) {
        String outFileName = outputFilename + filenameSuffix;
        Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        outputFormat.setProperty("indent", "yes");
        outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        outputFormat.setProperty("encoding", "UTF-8");
        File res = new File(outputDirectoryFile, outFileName);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(res), "UTF-8"));){
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            serializer.setWriter((Writer)writer);
            serializer.asDOMSerializer().serialize((Node)document);
            this.result.addResult(this.getTargetName(), outputDirectory, outFileName, null);
        }
        catch (IOException ioe) {
            this.result.addError(this, 3, outFileName, ioe.getMessage());
        }
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
        r.addRule(RULE_TGT_CDB_ALL_NOTENCODED);
        r.addRule(RULE_TGT_CDB_ALL_VALUETYPETEXT_FOR_UNION_REPRESENTING_FEATURESET);
    }

    @Override
    public String getTargetIdentifier() {
        return NSABR;
    }

    @Override
    public String getDefaultEncodingRule() {
        return "*";
    }

    @Override
    public void reset() {
        initialised = false;
        outputDirectoryFile = null;
        outputDirectory = null;
        outputFilename = null;
        diagnosticsOnly = false;
        atLeastOneSchemaIsEncoded = false;
        mapEntryParamInfos = null;
        featureTypes = new TreeSet<ClassInfo>();
        schemaVersions = new TreeSet<String>();
        unitDefsFromConfigByName = new HashMap<String, CDBUnit>();
        unitsToIgnore = new HashSet<String>();
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class '$1$'";
            }
            case 1: {
                return "Context: property '$1$'";
            }
            case 2: {
                return "XML document with name '$1$' could not be created, invalid filename.";
            }
            case 3: {
                return "File '$1$' already exists. Attempting to delete it...";
            }
            case 4: {
                return "File has been deleted.";
            }
            case 6: {
                return "Processing class '$1$'.";
            }
            case 7: {
                return "Schema '$1$' is not encoded.";
            }
            case 8: {
                return "Class '$1$' is not encoded.";
            }
            case 9: {
                return "Schema '$1$' is not encoded. Thus class '$2$' (which belongs to that schema) is not encoded either.";
            }
            case 10: {
                return "Type '$1$' is ignored.";
            }
            case 11: {
                return "No relevant feature type found. Consequently, no dictionaries are created.";
            }
            case 12: {
                return "The target configuration does not contain an advanced process configuration element with CDB unit definitions. This is fine, unless relevant properties define units of measure.";
            }
            case 13: {
                return "'$1$' element of $2$ CDBUnitDefinition element is empty which is not allowed. CDBUnitDefinition will be ignored.";
            }
            case 14: {
                return "??No map entry exists for type '$1$'. Furthermore, the type could either not be found in the model or is not one of the types that are automatically mapped to 'Text'. Properties with this type will be ignored.";
            }
            case 15: {
                return "No map entries provided via the configuration.";
            }
            case 16: {
                return "'code' attribute of $1$ CDBUnitDefinition element cannot be parsed to an integer. Code value is '$2$'. CDBUnitDefinition will be ignored.";
            }
            case 17: {
                return "'symbol' attribute of $1$ CDBUnitDefinition element is empty which is not allowed. CDBUnitDefinition will be ignored.";
            }
            case 100: {
                return "Feature mapping with potentially inconsistent labels. Label of existing feature is '$1$', while that of the other feature (which will be ignored) is '$2$'.";
            }
            case 101: {
                return "Feature mapping with potentially inconsistent concept definition. Definition of existing feature is '$1$', while that of the other feature (which will be ignored) is '$2$'.";
            }
            case 102: {
                return "Context: existing feature '$1$'";
            }
            case 103: {
                return "Context: other feature '$1$'";
            }
            case 150: {
                return "Context: existing property '$1$'";
            }
            case 151: {
                return "Context: other property '$1$'";
            }
            case 152: {
                return "Property mapping with potentially inconsistent description. Description of existing property representation is '$1$', while that of the other property representation (which will be ignored) is '$2$'.";
            }
            case 153: {
                return "Property mapping with potentially inconsistent value type. Type of existing property representation is '$1$', while that of the other property representation (which will be ignored) is '$2$'.";
            }
            case 154: {
                return "Property mapping with potentially inconsistent value format. Format of existing property representation is '$1$', while that of the other property representation (which will be ignored) is '$2$'.";
            }
            case 155: {
                return "Property mapping with potentially inconsistent value length. Length of existing property representation is '$1$', while that of the other property representation (which will be ignored) is '$2$'.";
            }
            case 156: {
                return "Property mapping with potentially inconsistent value range. Range of existing property representation is [$1$-$2$], while that of the other property representation (which will be ignored) is [$3$-$4$].";
            }
            case 157: {
                return "Property mapping with potential inconsistency.";
            }
            case 200: {
                return "No CDBUnitDefinition found for recommended measure '$1$' of property '$2$'.";
            }
        }
        return "(" + CDB.class.getName() + ") Unknown message with number: " + mnr;
    }

    static {
        diagnosticsOnly = false;
    }
}

