/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.ArcGISWorkspace;

import de.interactive_instruments.ShapeChange.Target.ArcGISWorkspace.DatabaseException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class EAAccessConnection
implements Closeable {
    private String dbJdbcDriver;
    private String dbDriver;
    private String dbURL;
    private String dbServiceName;
    private String dbuser;
    private String dbpassw;
    public Boolean isValid;
    protected Connection conn;

    public EAAccessConnection(String dbJdbcDriver, String dbDriver, String dbServiceName, String dbuser, String dbpassw) throws DatabaseException {
        this.dbJdbcDriver = dbJdbcDriver;
        this.dbDriver = dbDriver;
        this.dbServiceName = dbServiceName;
        this.dbuser = dbuser;
        this.dbpassw = dbpassw;
        this.isValid = true;
        this.initialise();
    }

    public void initialise() throws DatabaseException {
        this.conn = null;
        this.connect();
        this.close();
    }

    protected void connect() throws DatabaseException {
        if (this.conn == null) {
            try {
                File f = new File(this.dbServiceName);
                if (!f.exists()) {
                    throw new IOException("Access-File " + this.dbServiceName + " is not available.");
                }
                this.dbURL = this.dbDriver + ";DBQ=" + this.dbServiceName + ";";
                Class.forName(this.dbJdbcDriver);
                this.conn = DriverManager.getConnection(this.dbURL, this.dbuser, this.dbpassw);
            }
            catch (SQLException e) {
                throw new DatabaseException(e);
            }
            catch (IOException e) {
                throw new DatabaseException(e);
            }
            catch (ClassNotFoundException e) {
                throw new DatabaseException(e);
            }
        }
    }

    @Override
    public void close() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
        }
        finally {
            this.conn = null;
        }
    }

    public void establishAssociationClass(int connectorID, int elementID) throws DatabaseException {
        this.connect();
        try {
            String sql1 = "UPDATE t_connector SET SubType='Class' WHERE Connector_ID=" + connectorID;
            Statement s1 = this.conn.createStatement();
            s1.executeUpdate(sql1);
            String sql2 = "UPDATE t_connector SET PDATA1=" + elementID + " WHERE Connector_ID=" + connectorID;
            Statement s2 = this.conn.createStatement();
            s2.executeUpdate(sql2);
            String sql3 = "UPDATE t_object SET PDATA4=" + connectorID + " WHERE Object_ID=" + elementID;
            Statement s3 = this.conn.createStatement();
            s3.executeUpdate(sql3);
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
    }
}

