/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.ArcGISWorkspace;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Util.ea.EARepositoryUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.sparx.Repository;

public class ArcGISWorkspaceConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("documentationNoValue", "documentationTemplate", "eaAuthor", "eaStatus", "foreignKeySuffix", "keepCaseOfRoleName", "defaultLength", "maxNameLength", "nameOfTaggedValueToDetermineFieldLength", "outputDirectory", "outputFilename", "reflexiveRelationshipFieldSuffix", "shortNameByTaggedValue", "valueRangeExcludedBoundaryDelta", "workspaceTemplate").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;

    @Override
    public boolean isValid(ProcessConfiguration config, Options options, ShapeChangeResult result) {
        File outputFile;
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTargetParameters());
        isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, config.getParameters().keySet(), result) && isValid;
        String outputDirectory = config.parameterAsString("outputDirectory", ".", false, true);
        Object outputFilename = config.parameterAsString("outputFilename", "ArcGISWorkspaceConfigurationValidator", false, true);
        outputFilename = ((String)outputFilename).replace("/", "_").replace(" ", "_") + ".eap";
        File outputDirectoryFile = new File(outputDirectory);
        boolean exi = outputDirectoryFile.exists();
        if (!exi) {
            try {
                FileUtils.forceMkdir((File)outputDirectoryFile);
            }
            catch (IOException e) {
                isValid = false;
                result.addError(this, 5, e.getMessage());
                e.printStackTrace(System.err);
            }
            exi = outputDirectoryFile.exists();
        }
        boolean dir = outputDirectoryFile.isDirectory();
        boolean wrt = outputDirectoryFile.canWrite();
        boolean rea = outputDirectoryFile.canRead();
        if (!(exi && dir && wrt && rea)) {
            isValid = false;
            result.addError(this, 1, outputDirectory);
        }
        if (exi = (outputFile = new File(outputDirectoryFile, (String)outputFilename)).exists()) {
            try {
                FileUtils.forceDelete((File)outputFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (isValid) {
            String workspaceTemplateFilePath = config.parameterAsString("workspaceTemplate", null, false, true);
            if (workspaceTemplateFilePath == null) {
                workspaceTemplateFilePath = "http://shapechange.net/resources/templates/ArcGISWorkspace_template.eap";
            }
            if (workspaceTemplateFilePath.toLowerCase().startsWith("http")) {
                try {
                    URL templateUrl = new URL(workspaceTemplateFilePath);
                    FileUtils.copyURLToFile((URL)templateUrl, (File)outputFile);
                }
                catch (MalformedURLException e1) {
                    isValid = false;
                    result.addError(this, 6, workspaceTemplateFilePath, e1.getMessage());
                }
                catch (IOException e2) {
                    isValid = false;
                    result.addError(this, 8, e2.getMessage());
                }
            } else {
                File workspacetemplate = new File(workspaceTemplateFilePath);
                if (workspacetemplate.exists()) {
                    try {
                        FileUtils.copyFile((File)workspacetemplate, (File)outputFile);
                    }
                    catch (IOException e) {
                        isValid = false;
                        result.addError(this, 8, e.getMessage());
                    }
                } else {
                    isValid = false;
                    result.addError(this, 7, workspacetemplate.getAbsolutePath());
                }
            }
        }
        if (isValid) {
            Repository rep = new Repository();
            String absolutePathOfOutputEAPFile = outputFile.getAbsolutePath();
            if (!rep.OpenFile(absolutePathOfOutputEAPFile)) {
                String errormsg = rep.GetLastError();
                result.addError(null, 30, errormsg, (String)outputFilename);
                rep = null;
                isValid = false;
            } else {
                if (!rep.IsTechnologyEnabled("ArcGIS")) {
                    isValid = false;
                    result.addError(this, 100);
                }
                EARepositoryUtil.closeRepository(rep);
                rep = null;
            }
        }
        if (outputFile.exists()) {
            outputFile.delete();
        }
        return isValid;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Directory named '$1$' does not exist or is not accessible.";
            }
            case 5: {
                return "Could not create output directory. Exception message: '$1$'.";
            }
            case 6: {
                return "URL '$1$' provided for configuration parameter workspaceTemplate is malformed. Exception message is: '$2$'.";
            }
            case 7: {
                return "EAP with ArcGIS workspace template at '$1$' does not exist or cannot be read. Check the value of the configuration parameter 'workspaceTemplate' and ensure that: a) it contains the path to the template file and b) the file can be read by ShapeChange.";
            }
            case 8: {
                return "Exception encountered when copying ArcGIS workspace template EAP file to output destination. Message is: $1$.";
            }
            case 100: {
                return "The MDG Technology 'ArcGIS' is not enabled in your EA environment. Writing an ArcGIS workspace requires that this technology is enabled. Enable this technology in your EA environment before executing ShapeChange.";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

