/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.ArcGISWorkspace;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.ArcGISWorkspace.ArcGISWorkspaceConstants;
import de.interactive_instruments.ShapeChange.Target.ArcGISWorkspace.NumericRangeConstraintMetadata;
import de.interactive_instruments.ShapeChange.Target.SingleTarget;
import de.interactive_instruments.ShapeChange.Type;
import de.interactive_instruments.ShapeChange.Util.ArcGISUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAAttributeUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAConnectorEndUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAConnectorUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAElementUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAException;
import de.interactive_instruments.ShapeChange.Util.ea.EAPackageUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EARepositoryUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EATaggedValue;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.sparx.Attribute;
import org.sparx.Collection;
import org.sparx.Connector;
import org.sparx.ConnectorEnd;
import org.sparx.Element;
import org.sparx.Package;
import org.sparx.Repository;

public class ArcGISWorkspace
implements SingleTarget,
MessageSource {
    private static String REGEX_TO_SPLIT_BY_COMMA_WITH_ESCAPING = "(?<!(?:^|[^\\\\])(?:\\\\\\\\){0,5}\\\\),";
    private static String REGEX_TO_SPLIT_BY_COLON_WITH_ESCAPING = "(?<!(?:^|[^\\\\])(?:\\\\\\\\){0,5}\\\\):";
    private static final Pattern lengthConstraintPattern = Pattern.compile("(?:self\\.)?(\\w+)[\\.\\w+]*\\.size\\(\\)\\D*(\\d+)");
    private static final Pattern numRangeConstraintLowerBoundaryPattern = Pattern.compile("\\.value\\s*(?=>)(.*?)\\s*([\\+-]?[\\.|\\d]+)");
    private static final Pattern numRangeConstraintUpperBoundaryPattern = Pattern.compile("\\.value\\s*(?=<)(.*?)\\s*([\\+-]?[\\.|\\d]+)");
    private static final Pattern numRangeConstraintPropertyNamePattern = Pattern.compile("(?:self\\.|\\s)?(\\w+)\\.[\\w\\.]*?value(?:[,\\s])");
    private static boolean initialised = false;
    private static String workspaceTemplateFilePath = "http://shapechange.net/resources/templates/ArcGISWorkspace_template.eap";
    private static int maxNameLength = 30;
    private static int lengthTaggedValueDefault = 255;
    private static double numRangeDelta = 0.01;
    private static Set<String> esriTypesSuitedForRangeConstraint = new TreeSet<String>();
    private static String outputDirectory = null;
    private static File outputDirectoryFile = null;
    private static String documentationTemplate = null;
    private static String documentationNoValue = null;
    protected static String author = null;
    protected static String status = null;
    private static Repository rep = null;
    private static SortedSet<ClassInfo> ignoredCis = new TreeSet<ClassInfo>();
    private static SortedMap<ClassInfo, ArcGISGeometryType> geometryTypeCache = new TreeMap<ClassInfo, ArcGISGeometryType>();
    private static SortedMap<ClassInfo, Integer> elementIdByClassInfo = new TreeMap<ClassInfo, Integer>();
    private static SortedMap<ClassInfo, String> elementNameByClassInfo = new TreeMap<ClassInfo, String>();
    private static SortedSet<Integer> elementIdsOfUnusedCodedValueDomain = new TreeSet<Integer>();
    private static SortedMap<ClassInfo, String> objectIdAttributeGUIDByClass = new TreeMap<ClassInfo, String>();
    private static SortedMap<ClassInfo, String> identifierAttributeGUIDByClass = new TreeMap<ClassInfo, String>();
    private static SortedMap<ClassInfo, ClassInfo> generalisations = new TreeMap<ClassInfo, ClassInfo>();
    private static SortedSet<AssociationInfo> associations = new TreeSet<AssociationInfo>();
    private static Set<ClassInfo> arcgisSubtypes = new HashSet<ClassInfo>();
    private static Map<ClassInfo, Map<String, Integer>> subtypeElementIdBySubtypeNameByParent = new TreeMap<ClassInfo, Map<String, Integer>>();
    private static MultiKeyMap subtypeCodedValueDomainEAIDByMultiKey = new MultiKeyMap();
    private static SortedMap<String, Integer> counterByRelationshipClassName = new TreeMap<String, Integer>();
    private static SortedMap<ClassInfo, SortedMap<String, Integer>> counterByPropertyNameByClass = new TreeMap<ClassInfo, SortedMap<String, Integer>>();
    private static Model model = null;
    private Options options = null;
    private ShapeChangeResult result = null;
    protected static int numberOfSchemasSelectedForProcessing = 0;
    protected static Integer workspacePkgId;
    protected static Integer featuresPkgId;
    protected static Integer tablesPkgId;
    protected static Integer assocClassesPkgId;
    protected static Integer domainsPkgId;
    protected static SortedMap<Integer, SortedMap<PackageInfo, Integer>> eaPkgIdByModelPkg_byWorkspaceSubPkgId;
    protected static SortedMap<String, ProcessMapEntry> processMapEntries;
    protected static SortedMap<String, Integer> lengthMappingByTypeName;
    protected static SortedMap<String, Integer> precisionMappingByTypeName;
    protected static SortedMap<String, Integer> scaleMappingByTypeName;
    protected static SortedMap<String, Integer> lengthByClassPropName;
    protected static SortedMap<ClassInfo, SortedMap<String, NumericRangeConstraintMetadata>> numericRangeConstraintByPropNameByClassName;
    protected static String nameOfTVToDetermineFieldLength;
    private static String absolutePathOfOutputEAPFile;
    private static String shortNameByTaggedValue;
    private static boolean keepCaseOfRolename;
    private static String foreignKeySuffix;
    private static String reflexiveRelationshipAttributeSuffix;
    protected static boolean representTaggedValues;
    protected static SortedSet<String> taggedValuesToRepresent;
    private static SortedMap<String, Integer> numericRangeElementIdsByClassName;

    @Override
    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        this.options = o;
        this.result = r;
        if (!initialised) {
            boolean exi;
            String nameOfTVToDetermineFieldLengthParamValue;
            String maxNameLengthParamValue;
            Object outputFilename;
            initialised = true;
            model = m;
            numberOfSchemasSelectedForProcessing = m.selectedSchemas().size();
            lengthMappingByTypeName.put("esriFieldTypeInteger", 0);
            lengthMappingByTypeName.put("esriFieldTypeDouble", 0);
            lengthMappingByTypeName.put("esriFieldTypeDate", 0);
            precisionMappingByTypeName.put("esriFieldTypeString", 0);
            precisionMappingByTypeName.put("esriFieldTypeInteger", 9);
            precisionMappingByTypeName.put("esriFieldTypeDouble", 10);
            precisionMappingByTypeName.put("esriFieldTypeDate", 0);
            scaleMappingByTypeName.put("esriFieldTypeString", 0);
            scaleMappingByTypeName.put("esriFieldTypeInteger", 0);
            scaleMappingByTypeName.put("esriFieldTypeDouble", 6);
            scaleMappingByTypeName.put("esriFieldTypeDate", 0);
            outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
            if (outputDirectory == null) {
                outputDirectory = this.options.parameter("outputDirectory");
            }
            if (outputDirectory == null) {
                outputDirectory = this.options.parameter(".");
            }
            if ((outputFilename = this.options.parameter(this.getClass().getName(), "outputFilename")) == null) {
                outputFilename = p.name();
            }
            outputFilename = ((String)outputFilename).replace("/", "_").replace(" ", "_") + ".eap";
            author = this.options.parameterAsString(this.getClass().getName(), "eaAuthor", null, false, true);
            status = this.options.parameterAsString(this.getClass().getName(), "eaStatus", null, false, true);
            String defaultLengthParamValue = this.options.parameter(this.getClass().getName(), "defaultLength");
            if (defaultLengthParamValue != null) {
                try {
                    int length;
                    lengthTaggedValueDefault = length = Integer.parseInt(defaultLengthParamValue);
                }
                catch (NumberFormatException e) {
                    this.result.addError(this, 13, "defaultLength", "255");
                }
            }
            if ((maxNameLengthParamValue = this.options.parameter(this.getClass().getName(), "maxNameLength")) != null) {
                try {
                    int maxNameLengthTmp;
                    maxNameLength = maxNameLengthTmp = Integer.parseInt(maxNameLengthParamValue);
                }
                catch (NumberFormatException e) {
                    this.result.addError(this, 13, "maxNameLength", "30");
                }
            }
            if ((nameOfTVToDetermineFieldLengthParamValue = this.options.parameter(this.getClass().getName(), "nameOfTaggedValueToDetermineFieldLength")) != null && nameOfTVToDetermineFieldLengthParamValue.trim().length() > 0) {
                nameOfTVToDetermineFieldLength = nameOfTVToDetermineFieldLengthParamValue.trim();
            }
            if (!(exi = (outputDirectoryFile = new File(outputDirectory)).exists())) {
                try {
                    FileUtils.forceMkdir((File)outputDirectoryFile);
                }
                catch (IOException e) {
                    this.result.addError(this, 5, e.getMessage());
                    e.printStackTrace(System.err);
                }
                exi = outputDirectoryFile.exists();
            }
            boolean dir = outputDirectoryFile.isDirectory();
            boolean wrt = outputDirectoryFile.canWrite();
            boolean rea = outputDirectoryFile.canRead();
            if (!(exi && dir && wrt && rea)) {
                this.result.addFatalError(this, 1, outputDirectory);
                throw new ShapeChangeAbortException();
            }
            File outputFile = new File(outputDirectoryFile, (String)outputFilename);
            exi = outputFile.exists();
            if (exi) {
                this.result.addInfo(this, 2, (String)outputFilename, outputDirectory);
                try {
                    FileUtils.forceDelete((File)outputFile);
                    this.result.addInfo(this, 3);
                }
                catch (IOException e) {
                    this.result.addInfo(this, 4, e.getMessage());
                    e.printStackTrace(System.err);
                }
            }
            if ((workspaceTemplateFilePath = this.options.parameter(this.getClass().getName(), "workspaceTemplate")) == null) {
                workspaceTemplateFilePath = this.options.parameter("workspaceTemplate");
            }
            if (workspaceTemplateFilePath == null) {
                workspaceTemplateFilePath = "http://shapechange.net/resources/templates/ArcGISWorkspace_template.eap";
                this.result.addInfo(this, 9, "workspaceTemplate", "http://shapechange.net/resources/templates/ArcGISWorkspace_template.eap");
            }
            if (workspaceTemplateFilePath.toLowerCase().startsWith("http")) {
                try {
                    URL templateUrl = new URL(workspaceTemplateFilePath);
                    FileUtils.copyURLToFile((URL)templateUrl, (File)outputFile);
                }
                catch (MalformedURLException e1) {
                    this.result.addFatalError(this, 6, workspaceTemplateFilePath, e1.getMessage());
                    throw new ShapeChangeAbortException();
                }
                catch (IOException e2) {
                    this.result.addFatalError(this, 8, e2.getMessage());
                    throw new ShapeChangeAbortException();
                }
            } else {
                File workspacetemplate = new File(workspaceTemplateFilePath);
                if (workspacetemplate.exists()) {
                    try {
                        FileUtils.copyFile((File)workspacetemplate, (File)outputFile);
                    }
                    catch (IOException e) {
                        this.result.addFatalError(this, 8, e.getMessage());
                        throw new ShapeChangeAbortException();
                    }
                } else {
                    this.result.addFatalError(this, 7, workspacetemplate.getAbsolutePath());
                    throw new ShapeChangeAbortException();
                }
            }
            absolutePathOfOutputEAPFile = outputFile.getAbsolutePath();
            rep = new Repository();
            if (!rep.OpenFile(absolutePathOfOutputEAPFile)) {
                String errormsg = rep.GetLastError();
                r.addError(null, 30, errormsg, (String)outputFilename);
                rep = null;
                throw new ShapeChangeAbortException();
            }
            EARepositoryUtil.setEABatchAppend(rep, true);
            EARepositoryUtil.setEAEnableUIUpdates(rep, false);
            rep.RefreshModelView(0);
            Collection c = rep.GetModels();
            Package root = (Package)c.GetAt((short)0);
            Collection modelPkgs = root.GetPackages();
            if (modelPkgs.GetCount() == 0 || !((Package)modelPkgs.GetAt((short)0)).GetStereotypeEx().equalsIgnoreCase("ArcGIS")) {
                this.result.addError(this, 9);
                throw new ShapeChangeAbortException();
            }
            Package workspacePkg = (Package)modelPkgs.GetAt((short)0);
            workspacePkgId = workspacePkg.GetPackageID();
            Integer features = EARepositoryUtil.getEAChildPackageByName(rep, workspacePkgId, "Features");
            if (features == null) {
                this.result.addError(this, 102, "Features");
                throw new ShapeChangeAbortException();
            }
            featuresPkgId = features;
            eaPkgIdByModelPkg_byWorkspaceSubPkgId.put(featuresPkgId, new TreeMap());
            Integer domains = EARepositoryUtil.getEAChildPackageByName(rep, workspacePkgId, "Domains");
            if (domains == null) {
                this.result.addError(this, 102, "Domains");
                throw new ShapeChangeAbortException();
            }
            domainsPkgId = domains;
            eaPkgIdByModelPkg_byWorkspaceSubPkgId.put(domainsPkgId, new TreeMap());
            Integer tables = EARepositoryUtil.getEAChildPackageByName(rep, workspacePkgId, "Tables");
            if (tables == null) {
                this.result.addError(this, 102, "Tables");
                throw new ShapeChangeAbortException();
            }
            tablesPkgId = tables;
            eaPkgIdByModelPkg_byWorkspaceSubPkgId.put(tablesPkgId, new TreeMap());
            Integer assocClasses = EARepositoryUtil.getEAChildPackageByName(rep, workspacePkgId, "Association Classes");
            if (assocClasses == null) {
                this.result.addError(this, 102, "Association Classes");
                throw new ShapeChangeAbortException();
            }
            assocClassesPkgId = assocClasses;
            eaPkgIdByModelPkg_byWorkspaceSubPkgId.put(assocClassesPkgId, new TreeMap());
            ProcessConfiguration pc = o.getCurrentProcessConfig();
            List<ProcessMapEntry> mapEntries = pc.getMapEntries();
            TreeMap<String, ProcessMapEntry> mes = new TreeMap<String, ProcessMapEntry>();
            for (ProcessMapEntry pme : mapEntries) {
                if (pme.hasTargetType()) {
                    mes.put(pme.getType(), pme);
                    continue;
                }
                this.result.addError(this, 11, pme.getType());
            }
            processMapEntries = mes;
            esriTypesSuitedForRangeConstraint.add("esriFieldTypeInteger");
            esriTypesSuitedForRangeConstraint.add("esriFieldTypeDouble");
            String numRangeDeltaParamValue = this.options.parameter(this.getClass().getName(), "valueRangeExcludedBoundaryDelta");
            if (numRangeDeltaParamValue != null) {
                try {
                    double delta;
                    numRangeDelta = delta = Double.parseDouble(numRangeDeltaParamValue);
                }
                catch (NumberFormatException e) {
                    this.result.addError(this, 12);
                }
            }
            documentationTemplate = this.options.parameter(this.getClass().getName(), "documentationTemplate");
            documentationNoValue = this.options.parameter(this.getClass().getName(), "documentationNoValue");
            shortNameByTaggedValue = this.options.parameterAsString(this.getClass().getName(), "shortNameByTaggedValue", "shortName", false, true);
            keepCaseOfRolename = this.options.parameterAsBoolean(this.getClass().getName(), "keepCaseOfRoleName", false);
            foreignKeySuffix = this.options.parameterAsString(this.getClass().getName(), "foreignKeySuffix", "ID", false, true);
            reflexiveRelationshipAttributeSuffix = this.options.parameterAsString(this.getClass().getName(), "reflexiveRelationshipFieldSuffix", "", false, true);
            List<String> tvsToRepresent = this.options.parameterAsStringList(null, "representTaggedValues", null, true, true);
            taggedValuesToRepresent = new TreeSet<String>(tvsToRepresent);
            representTaggedValues = p.matches("rule-arcgis-all-representTaggedValues");
        }
    }

    @Override
    public void process(ClassInfo ci) {
        if (processMapEntries.containsKey(ci.name())) {
            ProcessMapEntry pme = (ProcessMapEntry)processMapEntries.get(ci.name());
            this.result.addInfo(this, 240, ci.name(), pme.getTargetType());
            ignoredCis.add(ci);
            return;
        }
        this.parseLengthInfoFromOCLConstraints(ci);
        try {
            int cat = ci.category();
            if (this.isExplicitlyModeledArcGISSubtype(ci)) {
                this.createExplicitlyModeledArcGISSubtype(ci);
            } else if (cat == 6 || cat == 1 && this.determineArcGISGeometryType(ci).equals((Object)ArcGISGeometryType.NONE)) {
                this.parseNumericRangeConstraints(ci);
                this.createObjectClass(ci);
            } else if (cat == 1) {
                ArcGISGeometryType geomType = this.determineArcGISGeometryType(ci);
                if (geomType.equals((Object)ArcGISGeometryType.UNKNOWN)) {
                    this.result.addWarning(this, 210, ci.name());
                    ignoredCis.add(ci);
                } else {
                    if (this.hasMultipleGeometryProperties(ci)) {
                        this.result.addWarning(this, 211, ci.name());
                    }
                    this.parseNumericRangeConstraints(ci);
                    this.createFeatureClass(ci);
                }
            } else if (cat == 3) {
                if (this.isSubtypeSetDefinition(ci)) {
                    this.result.addInfo(this, 254, ci.name());
                } else {
                    this.createCodedValueDomain(ci);
                }
            } else if (cat == 2) {
                if (this.isSubtypeSetDefinition(ci)) {
                    this.result.addInfo(this, 255, ci.name());
                } else {
                    this.createCodedValueDomain(ci);
                }
            } else if (cat == 8) {
                this.result.addWarning(this, 209, cat + " (union)", ci.name());
                ignoredCis.add(ci);
            } else if (cat == 5) {
                this.result.addWarning(this, 209, cat + " (dataType)", ci.name());
                ignoredCis.add(ci);
            } else if (cat == 4) {
                this.result.addWarning(this, 209, cat + " (mixin)", ci.name());
                ignoredCis.add(ci);
            } else {
                this.result.addWarning(this, 209, "" + cat, ci.name());
                ignoredCis.add(ci);
            }
        }
        catch (EAException e) {
            this.result.addError(this, 201, e.getMessage());
            ignoredCis.add(ci);
        }
    }

    private boolean isSubtypeSetDefinition(ClassInfo ci) {
        if (!ci.matches("rule-arcgis-all-subtypes")) {
            return false;
        }
        SortedSet<? extends PropertyInfo> pis = ci.model().selectedSchemaProperties();
        for (PropertyInfo propertyInfo : pis) {
            if (!propertyInfo.typeInfo().id.equals(ci.id()) && !propertyInfo.typeInfo().name.equals(ci.name()) || !StringUtils.isNotBlank((CharSequence)propertyInfo.taggedValue("arcgisDefaultSubtype"))) continue;
            return true;
        }
        return false;
    }

    private void createExplicitlyModeledArcGISSubtype(ClassInfo ci) throws EAException {
        int subtypeCode;
        Element eaElement;
        block5: {
            ClassInfo parent = ci.baseClass();
            int eaPkgId = parent.category() == 1 ? EARepositoryUtil.establishEAPackageHierarchy(parent, featuresPkgId, eaPkgIdByModelPkg_byWorkspaceSubPkgId, rep, numberOfSchemasSelectedForProcessing, author, status) : EARepositoryUtil.establishEAPackageHierarchy(ci, tablesPkgId, eaPkgIdByModelPkg_byWorkspaceSubPkgId, rep, numberOfSchemasSelectedForProcessing, author, status);
            eaElement = EARepositoryUtil.createEAClass(rep, ci.name(), eaPkgId);
            elementIdByClassInfo.put(ci, eaElement.GetElementID());
            elementNameByClassInfo.put(ci, ci.name());
            this.setAuthorAndStatus(eaElement);
            this.setCommonItems(ci, eaElement);
            EAElementUtil.setEAStereotypeEx(eaElement, "ArcGIS::Subtype");
            String arcgisSubtypeCode = ci.taggedValue("arcgisSubtypeCode");
            subtypeCode = -1;
            if (StringUtils.isBlank((CharSequence)arcgisSubtypeCode)) {
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 252, ci.name());
                if (mc != null) {
                    mc.addDetail(this, -1, ci.fullNameInSchema());
                }
            } else {
                try {
                    subtypeCode = Integer.parseInt(arcgisSubtypeCode);
                }
                catch (Exception e) {
                    ShapeChangeResult.MessageContext mc = this.result.addError(this, 253, ci.name(), arcgisSubtypeCode);
                    if (mc == null) break block5;
                    mc.addDetail(this, -1, ci.fullNameInSchema());
                }
            }
        }
        EAElementUtil.updateTaggedValue(eaElement, "SubtypeCode", "" + subtypeCode, false);
        arcgisSubtypes.add(ci);
        this.identifyGeneralisationRelationships(ci);
    }

    private void setAuthorAndStatus(Element e) throws EAException {
        if (StringUtils.isNotBlank((CharSequence)author)) {
            EAElementUtil.setEAAuthor(e, author);
        }
        if (StringUtils.isNotBlank((CharSequence)status)) {
            EAElementUtil.setEAStatus(e, status);
        }
    }

    private void parseNumericRangeConstraints(ClassInfo ci) {
        for (Constraint cons : ci.constraints()) {
            boolean foundUpperBoundary;
            String ocl = cons.text();
            boolean lowerBoundaryInclusive = true;
            boolean upperBoundaryInclusive = true;
            Double lowerBoundaryValue = ArcGISWorkspaceConstants.DEFAULT_NUM_RANGE_MIN_LOWER_BOUNDARY;
            Double upperBoundaryValue = ArcGISWorkspaceConstants.DEFAULT_NUM_RANGE_MAX_UPPER_BOUNDARY;
            Matcher matcher = numRangeConstraintLowerBoundaryPattern.matcher(ocl);
            boolean foundLowerBoundary = matcher.find();
            if (foundLowerBoundary) {
                String lbOperator = matcher.group(1);
                String lbValue = matcher.group(2);
                if (lbOperator.equals(">")) {
                    lowerBoundaryInclusive = false;
                }
                try {
                    lowerBoundaryValue = Double.parseDouble(lbValue);
                }
                catch (NumberFormatException e) {
                    this.result.addWarning(this, 231, lbValue, ci.name(), cons.name(), ocl);
                }
            }
            if (foundUpperBoundary = (matcher = numRangeConstraintUpperBoundaryPattern.matcher(ocl)).find()) {
                String ubOperator = matcher.group(1);
                String ubValue = matcher.group(2);
                if (ubOperator.equals("<")) {
                    upperBoundaryInclusive = false;
                }
                try {
                    upperBoundaryValue = Double.parseDouble(ubValue);
                }
                catch (NumberFormatException e) {
                    this.result.addWarning(this, 232, ubValue, ci.name(), cons.name(), ocl);
                }
            }
            if (!foundLowerBoundary && !foundUpperBoundary) continue;
            matcher = numRangeConstraintPropertyNamePattern.matcher(ocl);
            boolean foundPropertyName = matcher.find();
            if (foundPropertyName) {
                SortedMap<String, NumericRangeConstraintMetadata> map;
                String propertyName = matcher.group(1);
                boolean propertyFound = false;
                for (PropertyInfo pi : ci.properties().values()) {
                    if (!pi.name().startsWith(propertyName) && (pi.aliasName() == null || !pi.aliasName().startsWith(propertyName))) continue;
                    propertyFound = true;
                    break;
                }
                if (!propertyFound) {
                    this.result.addWarning(this, 229, propertyName, ci.name(), ocl);
                }
                NumericRangeConstraintMetadata nrcm = new NumericRangeConstraintMetadata(lowerBoundaryValue, upperBoundaryValue, lowerBoundaryInclusive, upperBoundaryInclusive);
                if (numericRangeConstraintByPropNameByClassName.containsKey(ci)) {
                    map = (SortedMap)numericRangeConstraintByPropNameByClassName.get(ci);
                } else {
                    map = new TreeMap();
                    numericRangeConstraintByPropNameByClassName.put(ci, map);
                }
                map.put(propertyName, nrcm);
                continue;
            }
            this.result.addWarning(this, 228, ci.name(), ocl);
        }
        if (ci.matches("rule-arcgis-cls-rangeDomainFromTaggedValues")) {
            for (PropertyInfo pi : ci.properties().values()) {
                SortedMap<String, NumericRangeConstraintMetadata> map;
                ShapeChangeResult.MessageContext mc;
                Double lowerBoundaryValue = ArcGISWorkspaceConstants.DEFAULT_NUM_RANGE_MIN_LOWER_BOUNDARY;
                Double upperBoundaryValue = ArcGISWorkspaceConstants.DEFAULT_NUM_RANGE_MAX_UPPER_BOUNDARY;
                boolean foundLowerBoundary = false;
                boolean foundUpperBoundary = false;
                String TV_RANGE_MIN = "rangeMinimum";
                String TV_RANGE_MAX = "rangeMaximum";
                String rMin = pi.taggedValue(TV_RANGE_MIN);
                String rMax = pi.taggedValue(TV_RANGE_MAX);
                if (StringUtils.isNotBlank((CharSequence)rMin)) {
                    try {
                        lowerBoundaryValue = Double.parseDouble(rMin.trim());
                        foundLowerBoundary = true;
                    }
                    catch (NumberFormatException e) {
                        mc = this.result.addWarning(this, 241, rMin.trim(), TV_RANGE_MIN);
                        mc.addDetail(this, 20001, pi.fullNameInSchema());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)rMax)) {
                    try {
                        upperBoundaryValue = Double.parseDouble(rMax.trim());
                        foundUpperBoundary = true;
                    }
                    catch (NumberFormatException e) {
                        mc = this.result.addWarning(this, 242, rMax.trim(), TV_RANGE_MAX);
                        mc.addDetail(this, 20001, pi.fullNameInSchema());
                    }
                }
                if (!foundLowerBoundary && !foundUpperBoundary) continue;
                NumericRangeConstraintMetadata nrcm = new NumericRangeConstraintMetadata(lowerBoundaryValue, upperBoundaryValue, true, true);
                if (numericRangeConstraintByPropNameByClassName.containsKey(ci)) {
                    map = (SortedMap)numericRangeConstraintByPropNameByClassName.get(ci);
                } else {
                    map = new TreeMap();
                    numericRangeConstraintByPropNameByClassName.put(ci, map);
                }
                map.put(pi.name(), nrcm);
            }
        }
    }

    private void parseLengthInfoFromOCLConstraints(ClassInfo ci) {
        if (ci.category() == 1 || ci.category() == 6 || ci.category() == 6) {
            for (Constraint cons : ci.constraints()) {
                String ocl = cons.text();
                Matcher matcher = lengthConstraintPattern.matcher(ocl);
                boolean found = matcher.find();
                if (!found) continue;
                String propertyName = matcher.group(1);
                String length = matcher.group(2);
                Integer i = Integer.valueOf(length);
                lengthByClassPropName.put(ci.name() + "_" + propertyName, i);
            }
        }
    }

    private Element createCodedValueDomain(ClassInfo ci) throws EAException {
        int eaPkgId = EARepositoryUtil.establishEAPackageHierarchy(ci, domainsPkgId, eaPkgIdByModelPkg_byWorkspaceSubPkgId, rep, numberOfSchemasSelectedForProcessing, author, status);
        String name = this.normalizeName(ci.name());
        if (this.exceedsMaxLength(name)) {
            this.result.addWarning(this, 205, name, ci.name(), ci.name(), "" + maxNameLength);
            name = this.clipToMaxLength(name);
        }
        Element e = EARepositoryUtil.createEAClass(rep, name, eaPkgId);
        int elementID = e.GetElementID();
        elementIdByClassInfo.put(ci, elementID);
        elementNameByClassInfo.put(ci, name);
        elementIdsOfUnusedCodedValueDomain.add(elementID);
        this.setAuthorAndStatus(e);
        this.setCommonItems(ci, e);
        EAElementUtil.setEAStereotypeEx(e, "ArcGIS::CodedValueDomain");
        String documentation = ci.derivedDocumentation(documentationTemplate, "<no description available>");
        EAElementUtil.setTaggedValue(e, new EATaggedValue("Description", documentation, true));
        String fieldType = this.determineFieldTypeForCodedValueDomain(ci);
        this.createRequiredFieldsOfCodedValueDomain(e, fieldType);
        if (ci.properties() != null) {
            TreeSet<String> enumStereotype = new TreeSet<String>();
            enumStereotype.add("ArcGIS::DomainCodedValue");
            for (PropertyInfo pi : ci.properties().values()) {
                String initialValue = this.determineInitialValueForDomainCodedValue(pi);
                Attribute eaAtt = EAElementUtil.createEAAttribute(e, pi.name(), null, pi.derivedDocumentation(documentationTemplate, documentationNoValue), enumStereotype, null, false, false, false, initialValue, false, new Multiplicity(1, 1), null, null);
                this.addTaggedValuesToRepresent(eaAtt, (Info)pi);
            }
        }
        return e;
    }

    private Element createSubtypeSpecificCodedValueDomain(String subtypeName, ClassInfo codeListOrEnumeration, SortedSet<PropertyInfo> codes) throws EAException {
        int eaPkgId = EARepositoryUtil.establishEAPackageHierarchy(codeListOrEnumeration, domainsPkgId, eaPkgIdByModelPkg_byWorkspaceSubPkgId, rep, numberOfSchemasSelectedForProcessing, author, status);
        String fullName = codeListOrEnumeration.name() + subtypeName;
        String name = this.normalizeName(fullName);
        if (this.exceedsMaxLength(name)) {
            this.result.addWarning(this, 205, name, fullName, subtypeName, "" + maxNameLength);
            name = this.clipToMaxLength(name);
        }
        Element e = EARepositoryUtil.createEAClass(rep, name, eaPkgId);
        this.setAuthorAndStatus(e);
        EAElementUtil.setEAStereotypeEx(e, "ArcGIS::CodedValueDomain");
        String fieldType = this.determineFieldTypeForCodedValueDomain(codeListOrEnumeration);
        this.createRequiredFieldsOfCodedValueDomain(e, fieldType);
        TreeSet<String> enumStereotype = new TreeSet<String>();
        enumStereotype.add("ArcGIS::DomainCodedValue");
        for (PropertyInfo pi : codes) {
            String initialValue = this.determineInitialValueForDomainCodedValue(pi);
            Attribute eaAtt = EAElementUtil.createEAAttribute(e, pi.name(), null, pi.derivedDocumentation(documentationTemplate, documentationNoValue), enumStereotype, null, false, false, false, initialValue, false, new Multiplicity(1, 1), null, null);
            this.addTaggedValuesToRepresent(eaAtt, (Info)pi);
        }
        return e;
    }

    private String determineInitialValueForDomainCodedValue(PropertyInfo pi) {
        String initialValue = pi.matches("rule-arcgis-prop-initialValueByAlias") ? pi.aliasName() : pi.initialValue();
        if (StringUtils.isBlank((CharSequence)initialValue)) {
            initialValue = pi.name();
        }
        return initialValue;
    }

    private void createRequiredFieldsOfCodedValueDomain(Element eaElement, String fieldType) throws EAException {
        EAElementUtil.createEAAttribute(eaElement, "FieldType", null, null, null, null, false, false, false, fieldType, false, new Multiplicity(1, 1), "esriFieldType", null);
        EAElementUtil.createEAAttribute(eaElement, "MergePolicy", null, null, null, null, false, false, false, "esriMPTDefaultValue", false, new Multiplicity(1, 1), "esriMergePolicyType", null);
        EAElementUtil.createEAAttribute(eaElement, "SplitPolicy", null, null, null, null, false, false, false, "esriSPTDuplicate", false, new Multiplicity(1, 1), "esriSplitPolicyType", null);
    }

    private String determineFieldTypeForCodedValueDomain(ClassInfo codeListOrEnumeration) {
        String fieldTypeTV;
        String fieldType = "esriFieldTypeString";
        if (this.isNumericallyValued(codeListOrEnumeration)) {
            String numericFieldConceptualType = codeListOrEnumeration.taggedValue("numericType").trim();
            if (processMapEntries.containsKey(numericFieldConceptualType)) {
                fieldType = ((ProcessMapEntry)processMapEntries.get(numericFieldConceptualType)).getTargetType();
            } else {
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 245, numericFieldConceptualType);
                if (mc != null) {
                    mc.addDetail(this, -1, codeListOrEnumeration.fullNameInSchema());
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(fieldTypeTV = codeListOrEnumeration.taggedValue("fieldType")))) {
            fieldType = fieldTypeTV.trim();
        }
        return fieldType;
    }

    private Element createRangeDomain(String rangeDomainName, String rangeDomainDocumentation, String esriFieldType, ClassInfo rangeDomainSource) throws EAException {
        int eaPkgId = EARepositoryUtil.establishEAPackageHierarchy(rangeDomainSource, domainsPkgId, eaPkgIdByModelPkg_byWorkspaceSubPkgId, rep, numberOfSchemasSelectedForProcessing, author, status);
        String name = rangeDomainName;
        Element e = EARepositoryUtil.createEAClass(rep, name, eaPkgId);
        numericRangeElementIdsByClassName.put(rangeDomainName, e.GetElementID());
        this.setAuthorAndStatus(e);
        EAElementUtil.setEAStereotypeEx(e, "ArcGIS::RangeDomain");
        EAElementUtil.setTaggedValue(e, new EATaggedValue("Description", rangeDomainDocumentation == null ? "<no description available>" : rangeDomainDocumentation, true));
        EAElementUtil.createEAAttribute(e, "FieldType", null, null, null, null, false, false, false, esriFieldType, false, new Multiplicity(1, 1), "esriFieldType", null);
        EAElementUtil.createEAAttribute(e, "MergePolicy", null, null, null, null, false, false, false, "esriMPTDefaultValue", false, new Multiplicity(1, 1), "esriMergePolicyType", null);
        EAElementUtil.createEAAttribute(e, "SplitPolicy", null, null, null, null, false, false, false, "esriSPTDuplicate", false, new Multiplicity(1, 1), "esriSplitPolicyType", null);
        return e;
    }

    private void createFeatureClass(ClassInfo ci) throws EAException {
        this.checkRequirements(ci);
        int eaPkgId = EARepositoryUtil.establishEAPackageHierarchy(ci, featuresPkgId, eaPkgIdByModelPkg_byWorkspaceSubPkgId, rep, numberOfSchemasSelectedForProcessing, author, status);
        String name = this.normalizeName(ci.name());
        if (this.exceedsMaxLength(name)) {
            this.result.addWarning(this, 205, name, ci.name(), ci.name(), "" + maxNameLength);
            name = this.clipToMaxLength(name);
        }
        Element e = EARepositoryUtil.createEAClass(rep, name, eaPkgId);
        elementIdByClassInfo.put(ci, e.GetElementID());
        elementNameByClassInfo.put(ci, name);
        this.setAuthorAndStatus(e);
        this.setCommonItems(ci, e);
        if (!ci.isAbstract()) {
            String hasZFromTV;
            String hasMFromTV;
            ArcGISGeometryType geomType = this.determineArcGISGeometryType(ci);
            EAElementUtil.setEAStereotypeEx(e, geomType.stereotypeValue());
            Attribute objectIdField = this.createSystemFieldOBJECTID(e);
            objectIdAttributeGUIDByClass.put(ci, objectIdField.GetAttributeGUID());
            Attribute shapeField = this.createSystemFieldShape(e);
            Attribute shapeAreaField = null;
            Attribute shapeLengthField = null;
            if (geomType.equals((Object)ArcGISGeometryType.POLYLINE) || geomType.equals((Object)ArcGISGeometryType.POLYGON)) {
                shapeLengthField = this.createSystemFieldShapeLength(e);
                if (geomType.equals((Object)ArcGISGeometryType.POLYGON)) {
                    shapeAreaField = this.createSystemFieldShapeArea(e);
                }
            }
            this.createSystemFieldOBJECTIDIDX(e);
            this.createSystemFieldShapeIDX(e);
            if (geomType.equals((Object)ArcGISGeometryType.POINT)) {
                EAElementUtil.updateTaggedValue(e, "AncillaryRole", "esriNCARNone", false);
            }
            if (geomType.equals((Object)ArcGISGeometryType.POLYGON)) {
                EAElementUtil.updateTaggedValue(e, "AreaFieldName", shapeAreaField.GetAttributeGUID(), false);
            } else {
                EAElementUtil.updateTaggedValue(e, "AreaFieldName", "", false);
            }
            EAElementUtil.updateTaggedValue(e, "CanVersion", "false", false);
            EAElementUtil.updateTaggedValue(e, "DSID", "", false);
            EAElementUtil.updateTaggedValue(e, "FeatureType", "esriFTSimple", false);
            EAElementUtil.updateTaggedValue(e, "GlobalIDFieldName", "", false);
            String hasM = "false";
            if (ci.matches("rule-arcgis-cls-hasM") && StringUtils.isNotBlank((CharSequence)(hasMFromTV = ci.taggedValue("HasM"))) && hasMFromTV.trim().equalsIgnoreCase("true")) {
                hasM = "true";
            }
            EAElementUtil.updateTaggedValue(e, "HasM", hasM, false);
            EAElementUtil.updateTaggedValue(e, "HasSpatialIndex", "true", false);
            String hasZ = "false";
            if (ci.matches("rule-arcgis-cls-hasZ") && StringUtils.isNotBlank((CharSequence)(hasZFromTV = ci.taggedValue("HasZ"))) && hasZFromTV.trim().equalsIgnoreCase("true")) {
                hasZ = "true";
            }
            EAElementUtil.updateTaggedValue(e, "HasZ", hasZ, false);
            if (geomType.equals((Object)ArcGISGeometryType.POLYGON) || geomType.equals((Object)ArcGISGeometryType.POLYLINE)) {
                EAElementUtil.updateTaggedValue(e, "LengthFieldName", shapeLengthField.GetAttributeGUID(), false);
            } else {
                EAElementUtil.updateTaggedValue(e, "LengthFieldName", "", false);
            }
            EAElementUtil.updateTaggedValue(e, "Metadata", "", true);
            EAElementUtil.updateTaggedValue(e, "ModelName", "", false);
            EAElementUtil.updateTaggedValue(e, "OIDFieldName", objectIdField.GetAttributeGUID(), false);
            EAElementUtil.updateTaggedValue(e, "RasterFieldName", "", false);
            EAElementUtil.updateTaggedValue(e, "ShapeFieldName", shapeField.GetAttributeGUID(), false);
            EAElementUtil.updateTaggedValue(e, "SpatialReference", "", false);
            EAElementUtil.updateTaggedValue(e, "Versioned", "false", false);
        }
        this.identifyGeneralisationRelationships(ci);
        this.handleArcGISSubtypesDefinedByFieldType(ci, eaPkgId, e);
    }

    private boolean isExplicitlyModeledArcGISSubtype(ClassInfo ci) {
        return ci.matches("rule-arcgis-all-subtypes") && ArcGISUtil.isArcGISSubtype(ci);
    }

    private void handleArcGISSubtypesDefinedByFieldType(ClassInfo parent, int eaPkgId, Element parentEAElement) throws EAException {
        int subtypeCode;
        ClassInfo subtypeSetCi;
        block25: {
            if (!parent.matches("rule-arcgis-all-subtypes")) {
                return;
            }
            subtypeSetCi = null;
            String arcgisDefaultSubtypeTV = null;
            for (PropertyInfo pi : parent.propertiesAll()) {
                ClassInfo classInfo;
                arcgisDefaultSubtypeTV = pi.taggedValue("arcgisDefaultSubtype");
                if (!StringUtils.isNotBlank((CharSequence)arcgisDefaultSubtypeTV) || (classInfo = parent.model().classByIdOrName(pi.typeInfo())) == null || classInfo.category() != 3 && classInfo.category() != 2) continue;
                subtypeSetCi = classInfo;
                break;
            }
            if (subtypeSetCi == null) {
                return;
            }
            try {
                Integer.parseInt(arcgisDefaultSubtypeTV.trim());
            }
            catch (Exception e) {
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 256, arcgisDefaultSubtypeTV.trim());
                if (mc == null) break block25;
                mc.addDetail(this, -1, parent.fullNameInSchema());
            }
        }
        TreeMap<String, Integer> subtypeCodeBySubtypeName = new TreeMap<String, Integer>();
        if (subtypeSetCi.properties().isEmpty()) {
            this.result.addError(this, 257, subtypeSetCi.name());
            return;
        }
        for (PropertyInfo propertyInfo : subtypeSetCi.properties().values()) {
            ShapeChangeResult.MessageContext mc;
            String subtypeCodeTV = propertyInfo.taggedValue("arcgisSubtypeCode");
            subtypeCode = -1;
            if (StringUtils.isBlank((CharSequence)subtypeCodeTV)) {
                mc = this.result.addError(this, 258, propertyInfo.name(), subtypeSetCi.name());
                if (mc == null) continue;
                mc.addDetail(this, -2, propertyInfo.fullNameInSchema());
                continue;
            }
            try {
                subtypeCode = Integer.parseInt(subtypeCodeTV);
            }
            catch (Exception e) {
                ShapeChangeResult.MessageContext messageContext = this.result.addError(this, 259, propertyInfo.name(), subtypeSetCi.name(), subtypeCodeTV);
                if (messageContext == null) continue;
                messageContext.addDetail(this, -2, propertyInfo.fullNameInSchema());
                continue;
            }
            if (subtypeCodeBySubtypeName.containsValue(subtypeCode)) {
                mc = this.result.addError(this, 260, "" + subtypeCode, subtypeSetCi.name(), propertyInfo.name());
                if (mc == null) continue;
                mc.addDetail(this, -1, subtypeSetCi.fullNameInSchema());
                continue;
            }
            subtypeCodeBySubtypeName.put(propertyInfo.name(), subtypeCode);
        }
        for (Map.Entry entry : subtypeCodeBySubtypeName.entrySet()) {
            String subtypeName = (String)entry.getKey();
            subtypeCode = (Integer)entry.getValue();
            Element subtypeEAElement = EARepositoryUtil.createEAClass(rep, subtypeName, eaPkgId);
            this.setAuthorAndStatus(subtypeEAElement);
            int n = subtypeEAElement.GetElementID();
            Map<Object, Object> subtypeElementIdBySubtypeName = null;
            if (subtypeElementIdBySubtypeNameByParent.containsKey(parent)) {
                subtypeElementIdBySubtypeName = subtypeElementIdBySubtypeNameByParent.get(parent);
            } else {
                subtypeElementIdBySubtypeName = new TreeMap();
                subtypeElementIdBySubtypeNameByParent.put(parent, subtypeElementIdBySubtypeName);
            }
            subtypeElementIdBySubtypeName.put(subtypeName, n);
            EAElementUtil.setEAStereotypeEx(subtypeEAElement, "ArcGIS::Subtype");
            EAElementUtil.updateTaggedValue(subtypeEAElement, "SubtypeCode", "" + subtypeCode, false);
            String c1Name = subtypeName;
            String string = (String)elementNameByClassInfo.get(parent);
            try {
                Connector con = EARepositoryUtil.createEAGeneralization(rep, n, c1Name, (Integer)elementIdByClassInfo.get(parent), string);
                EAConnectorUtil.setEAStereotypeEx(con, "ArcGIS::Subtype");
            }
            catch (EAException e) {
                this.result.addWarning(this, 10006, c1Name, string, e.getMessage());
            }
        }
        for (PropertyInfo propertyInfo : parent.properties().values()) {
            if (propertyInfo.categoryOfValue() != 2 && propertyInfo.categoryOfValue() != 3) continue;
            ClassInfo clOrEnum = parent.model().classByIdOrName(propertyInfo.typeInfo());
            if (clOrEnum == null) {
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 261, parent.name(), propertyInfo.name(), propertyInfo.typeInfo().name);
                if (mc == null) continue;
                mc.addDetail(this, -2, propertyInfo.fullNameInSchema());
                continue;
            }
            TreeMap codesBySubtypeName = new TreeMap();
            for (PropertyInfo propertyInfo2 : clOrEnum.properties().values()) {
                String[] subtypesThatUseTheCode_escaped;
                String arcgisUsedBySubtypes = propertyInfo2.taggedValue("arcgisUsedBySubtypes");
                if (!StringUtils.isNotBlank((CharSequence)arcgisUsedBySubtypes)) continue;
                for (String s : subtypesThatUseTheCode_escaped = arcgisUsedBySubtypes.split(REGEX_TO_SPLIT_BY_COMMA_WITH_ESCAPING)) {
                    if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                    String unescapedSubtypeName = s.replace("\\,", ",").replace("\\\\", "\\");
                    SortedSet<PropertyInfo> codesOfSubtype = null;
                    if (codesBySubtypeName.containsKey(unescapedSubtypeName)) {
                        codesOfSubtype = (SortedSet)codesBySubtypeName.get(unescapedSubtypeName);
                    } else {
                        codesOfSubtype = new TreeSet();
                        codesBySubtypeName.put(unescapedSubtypeName, codesOfSubtype);
                    }
                    codesOfSubtype.add(propertyInfo2);
                }
            }
            for (Map.Entry entry : codesBySubtypeName.entrySet()) {
                String subtypeName = (String)entry.getKey();
                Element eaElementOfSubtypeSpecificCodedValueDomain = this.createSubtypeSpecificCodedValueDomain(subtypeName, clOrEnum, (SortedSet)entry.getValue());
                String string = clOrEnum.derivedDocumentation(documentationTemplate, "<no description available>");
                EAElementUtil.setTaggedValue(eaElementOfSubtypeSpecificCodedValueDomain, new EATaggedValue("Description", subtypeName + ": " + string, true));
                SortedMap<String, Integer> subtypeSpecificCodedValueDomainEAIDBySubtypeName = null;
                if (subtypeCodedValueDomainEAIDByMultiKey.containsKey((Object)parent, (Object)propertyInfo)) {
                    subtypeSpecificCodedValueDomainEAIDBySubtypeName = (SortedMap)subtypeCodedValueDomainEAIDByMultiKey.get((Object)parent, (Object)propertyInfo);
                } else {
                    subtypeSpecificCodedValueDomainEAIDBySubtypeName = new TreeMap();
                    subtypeCodedValueDomainEAIDByMultiKey.put((Object)parent, (Object)propertyInfo, subtypeSpecificCodedValueDomainEAIDBySubtypeName);
                }
                subtypeSpecificCodedValueDomainEAIDBySubtypeName.put(subtypeName, eaElementOfSubtypeSpecificCodedValueDomain.GetElementID());
            }
        }
    }

    private Attribute createSystemFieldShapeIDX(Element e) throws EAException {
        ArrayList<EATaggedValue> tvs = new ArrayList<EATaggedValue>();
        tvs.add(new EATaggedValue("IsUnique", "true"));
        tvs.add(new EATaggedValue("IsAscending", "true"));
        TreeSet<String> stereotypes = new TreeSet<String>();
        stereotypes.add("SpatialIndex");
        return EAElementUtil.createEAAttribute(e, "Shape_IDX", null, null, stereotypes, tvs, false, false, false, null, false, new Multiplicity(1, 1), "", null);
    }

    private Attribute createSystemFieldOBJECTIDIDX(Element e) throws EAException {
        ArrayList<EATaggedValue> tvs = new ArrayList<EATaggedValue>();
        tvs.add(new EATaggedValue("IsUnique", "true"));
        tvs.add(new EATaggedValue("IsAscending", "true"));
        tvs.add(new EATaggedValue("Fields", ""));
        TreeSet<String> stereotypes = new TreeSet<String>();
        stereotypes.add("AttributeIndex");
        return EAElementUtil.createEAAttribute(e, "OBJECTID_IDX", null, null, stereotypes, tvs, false, false, false, null, false, new Multiplicity(1, 1), "", null);
    }

    private Attribute createSystemFieldShapeArea(Element e) throws EAException {
        ArrayList<EATaggedValue> tvs = new ArrayList<EATaggedValue>();
        tvs.add(new EATaggedValue("DomainFixed", "false"));
        tvs.add(new EATaggedValue("Editable", "false"));
        tvs.add(new EATaggedValue("GeometryDef", "", true));
        tvs.add(new EATaggedValue("IsNullable", "true"));
        tvs.add(new EATaggedValue("Length", "8"));
        tvs.add(new EATaggedValue("ModelName", ""));
        tvs.add(new EATaggedValue("Precision", "0"));
        tvs.add(new EATaggedValue("RasterDef", "", true));
        tvs.add(new EATaggedValue("Required", "true"));
        tvs.add(new EATaggedValue("Scale", "0"));
        TreeSet<String> stereotypes = new TreeSet<String>();
        stereotypes.add("RequiredField");
        return EAElementUtil.createEAAttribute(e, "Shape_Area", null, null, stereotypes, tvs, false, false, false, null, false, new Multiplicity(1, 1), "esriFieldTypeDouble", null);
    }

    private Attribute createSystemFieldShapeLength(Element e) throws EAException {
        ArrayList<EATaggedValue> tvs = new ArrayList<EATaggedValue>();
        tvs.add(new EATaggedValue("DomainFixed", "false"));
        tvs.add(new EATaggedValue("Editable", "false"));
        tvs.add(new EATaggedValue("GeometryDef", "", true));
        tvs.add(new EATaggedValue("IsNullable", "true"));
        tvs.add(new EATaggedValue("Length", "8"));
        tvs.add(new EATaggedValue("ModelName", ""));
        tvs.add(new EATaggedValue("Precision", "0"));
        tvs.add(new EATaggedValue("RasterDef", "", true));
        tvs.add(new EATaggedValue("Required", "true"));
        tvs.add(new EATaggedValue("Scale", "0"));
        TreeSet<String> stereotypes = new TreeSet<String>();
        stereotypes.add("RequiredField");
        return EAElementUtil.createEAAttribute(e, "Shape_Length", null, null, stereotypes, tvs, false, false, false, null, false, new Multiplicity(1, 1), "esriFieldTypeDouble", null);
    }

    private Attribute createSystemFieldShape(Element e) throws EAException {
        ArrayList<EATaggedValue> tvs = new ArrayList<EATaggedValue>();
        tvs.add(new EATaggedValue("DomainFixed", "true"));
        tvs.add(new EATaggedValue("Editable", "true"));
        tvs.add(new EATaggedValue("GeometryDef", "AvgNumPoints=0;" + System.getProperty("line.separator") + "GridSize0=0;", true));
        tvs.add(new EATaggedValue("IsNullable", "true"));
        tvs.add(new EATaggedValue("Length", "0"));
        tvs.add(new EATaggedValue("ModelName", ""));
        tvs.add(new EATaggedValue("Precision", "0"));
        tvs.add(new EATaggedValue("RasterDef", "", true));
        tvs.add(new EATaggedValue("Required", "true"));
        tvs.add(new EATaggedValue("Scale", "0"));
        TreeSet<String> stereotypes = new TreeSet<String>();
        stereotypes.add("RequiredField");
        return EAElementUtil.createEAAttribute(e, "Shape", null, null, stereotypes, tvs, false, false, false, null, false, new Multiplicity(1, 1), "esriFieldTypeGeometry", null);
    }

    private Attribute createSystemFieldOBJECTID(Element e) throws EAException {
        ArrayList<EATaggedValue> tvs = new ArrayList<EATaggedValue>();
        tvs.add(new EATaggedValue("DomainFixed", "true"));
        tvs.add(new EATaggedValue("Editable", "false"));
        tvs.add(new EATaggedValue("GeometryDef", "", true));
        tvs.add(new EATaggedValue("IsNullable", "false"));
        tvs.add(new EATaggedValue("Length", "4"));
        tvs.add(new EATaggedValue("ModelName", "OBJECTID"));
        tvs.add(new EATaggedValue("Precision", ""));
        tvs.add(new EATaggedValue("RasterDef", "", true));
        tvs.add(new EATaggedValue("Required", "true"));
        tvs.add(new EATaggedValue("Scale", "0"));
        TreeSet<String> stereotypes = new TreeSet<String>();
        stereotypes.add("RequiredField");
        return EAElementUtil.createEAAttribute(e, "OBJECTID", null, null, stereotypes, tvs, false, false, false, null, false, new Multiplicity(1, 1), "esriFieldTypeOID", null);
    }

    private void createObjectClass(ClassInfo ci) throws EAException {
        this.checkRequirements(ci);
        int eaPkgId = EARepositoryUtil.establishEAPackageHierarchy(ci, tablesPkgId, eaPkgIdByModelPkg_byWorkspaceSubPkgId, rep, numberOfSchemasSelectedForProcessing, author, status);
        String name = this.normalizeName(ci.name());
        if (this.exceedsMaxLength(name)) {
            this.result.addWarning(this, 205, name, ci.name(), ci.name(), "" + maxNameLength);
            name = this.clipToMaxLength(name);
        }
        Element e = EARepositoryUtil.createEAClass(rep, name, eaPkgId);
        elementIdByClassInfo.put(ci, e.GetElementID());
        elementNameByClassInfo.put(ci, name);
        this.setAuthorAndStatus(e);
        this.setCommonItems(ci, e);
        EAElementUtil.setEAStereotypeEx(e, "ArcGIS::ObjectClass");
        Attribute objectIdField = this.createSystemFieldOBJECTID(e);
        objectIdAttributeGUIDByClass.put(ci, objectIdField.GetAttributeGUID());
        this.createSystemFieldOBJECTIDIDX(e);
        EAElementUtil.updateTaggedValue(e, "CanVersion", "false", false);
        EAElementUtil.updateTaggedValue(e, "DSID", "", false);
        EAElementUtil.updateTaggedValue(e, "GlobalIDFieldName", "", false);
        EAElementUtil.updateTaggedValue(e, "Metadata", "", true);
        EAElementUtil.updateTaggedValue(e, "ModelName", "", false);
        EAElementUtil.updateTaggedValue(e, "OIDFieldName", objectIdField.GetAttributeGUID(), false);
        EAElementUtil.updateTaggedValue(e, "RasterFieldName", "", false);
        EAElementUtil.updateTaggedValue(e, "Versioned", "false", false);
        this.identifyGeneralisationRelationships(ci);
        this.handleArcGISSubtypesDefinedByFieldType(ci, eaPkgId, e);
    }

    private void checkRequirements(ClassInfo ci) {
        if (ci.matches("rule-arcgis-cls-identifierStereotype")) {
            ShapeChangeResult.MessageContext mc;
            int countIdentifierAttributes = 0;
            for (PropertyInfo pi : ci.properties().values()) {
                ShapeChangeResult.MessageContext mc2;
                if (!pi.isAttribute() || !pi.stereotype("identifier")) continue;
                ++countIdentifierAttributes;
                if (pi.cardinality().maxOccurs <= 1 || (mc2 = this.result.addError(this, 247, pi.name())) == null) continue;
                mc2.addDetail(this, -2, pi.fullNameInSchema());
            }
            if (countIdentifierAttributes > 1) {
                mc = this.result.addWarning(this, 246, ci.name());
                if (mc != null) {
                    mc.addDetail(this, -1, ci.fullNameInSchema());
                }
            } else if (countIdentifierAttributes == 0 && (mc = this.result.addWarning(this, 248, ci.name())) != null) {
                mc.addDetail(this, -1, ci.fullNameInSchema());
            }
        }
    }

    private void identifyGeneralisationRelationships(ClassInfo ci) {
        ClassInfo cix;
        ShapeChangeResult.MessageContext mc;
        if (ci.supertypes().size() > 1 && (mc = this.result.addError(this, 268, ci.name())) != null) {
            mc.addDetail(this, -1, ci.fullNameInSchema());
        }
        for (String tid : ci.supertypes()) {
            cix = model.classById(tid);
            if (cix == null) {
                this.result.addError(this, 206, ci.name(), tid);
                continue;
            }
            generalisations.put(ci, cix);
        }
        for (String tid : ci.subtypes()) {
            cix = model.classById(tid);
            if (cix == null) {
                this.result.addError(this, 202, ci.name(), tid);
                continue;
            }
            generalisations.put(cix, ci);
        }
    }

    private String normalizeName(String name) {
        String result = name.replaceAll("\\W", "_");
        return result;
    }

    private String normalizeAlias(String alias, ClassInfo ci) {
        String result = alias;
        return result;
    }

    private boolean exceedsMaxLength(String s) {
        if (s == null) {
            return false;
        }
        return s.length() > maxNameLength;
    }

    private String clipToMaxLength(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() <= maxNameLength) {
            return s;
        }
        return s.substring(0, maxNameLength);
    }

    private void setCommonItems(ClassInfo ci, Element e) {
        String s;
        if (ci.isAbstract()) {
            try {
                EAElementUtil.setEAAbstract(e, true);
            }
            catch (EAException exc) {
                this.result.addError(this, 204, ci.name(), exc.getMessage());
            }
        }
        if (ci.aliasName() != null) {
            try {
                String aliasName = this.normalizeAlias(ci.aliasName(), ci);
                EAElementUtil.setEAAlias(e, aliasName);
            }
            catch (EAException exc) {
                this.result.addError(this, 204, ci.name(), exc.getMessage());
            }
        }
        if ((s = ci.derivedDocumentation(documentationTemplate, documentationNoValue)) != null) {
            try {
                EAElementUtil.setEANotes(e, s);
            }
            catch (EAException exc) {
                this.result.addError(this, 204, ci.name(), exc.getMessage());
            }
        }
        if (ci.getLinkedDocument() != null) {
            e.LoadLinkedDocument(ci.getLinkedDocument().getAbsolutePath());
        }
        try {
            this.addTaggedValuesToRepresent(e, (Info)ci);
        }
        catch (EAException exc) {
            this.result.addError(this, 250, ci.name(), exc.getMessage());
        }
    }

    private ArcGISGeometryType determineArcGISGeometryType(ClassInfo ci) {
        if (geometryTypeCache.containsKey(ci)) {
            return (ArcGISGeometryType)((Object)geometryTypeCache.get(ci));
        }
        SortedSet<PropertyInfo> allPis = ci.propertiesAll();
        ArcGISGeometryType result = ArcGISGeometryType.NONE;
        for (PropertyInfo pi : allPis) {
            Type t = pi.typeInfo();
            if (!t.name.startsWith("GM_")) continue;
            if (t.name.equalsIgnoreCase("GM_Point")) {
                result = ArcGISGeometryType.POINT;
                break;
            }
            if (t.name.equalsIgnoreCase("GM_MultiPoint")) {
                result = ArcGISGeometryType.MULTIPOINT;
                break;
            }
            if (t.name.equalsIgnoreCase("GM_Curve") || t.name.equalsIgnoreCase("GM_MultiCurve")) {
                result = ArcGISGeometryType.POLYLINE;
                break;
            }
            if (t.name.equalsIgnoreCase("GM_Surface") || t.name.equalsIgnoreCase("GM_MultiSurface")) {
                result = ArcGISGeometryType.POLYGON;
                break;
            }
            result = ArcGISGeometryType.UNKNOWN;
            break;
        }
        geometryTypeCache.put(ci, result);
        return result;
    }

    private boolean hasMultipleGeometryProperties(ClassInfo ci) {
        SortedSet<PropertyInfo> allPis = ci.propertiesAll();
        boolean geomPropFound = false;
        for (PropertyInfo pi : allPis) {
            Type t = pi.typeInfo();
            if (!t.name.startsWith("GM_")) continue;
            if (geomPropFound) {
                return true;
            }
            geomPropFound = true;
        }
        return false;
    }

    @Override
    public void write() {
    }

    private void createManyToManyRelationshipClass(PropertyInfo pi) {
        ClassInfo ciSource = pi.inClass();
        Type ti = pi.typeInfo();
        ClassInfo ciTarget = model.classById(ti.id);
        if (ciTarget == null) {
            this.result.addWarning(this, 233, ciSource.name(), pi.name(), ti.name);
        } else {
            this.createManyToManyRelationshipClass(ciSource, ciTarget, this.toLowerCamelCase(ciSource.name()), pi.name(), null, pi);
        }
    }

    private String doubleToString(Double d) {
        if (d == null) {
            return null;
        }
        if (d.isNaN() || d.isInfinite()) {
            return d.toString();
        }
        if (d == 0.0) {
            return "0";
        }
        return new BigDecimal(d.toString()).stripTrailingZeros().toPlainString();
    }

    private void createManyToManyRelationshipClass(PropertyInfo pi1, PropertyInfo pi2) {
        ClassInfo ci1 = pi1.inClass();
        ClassInfo ci2 = pi2.inClass();
        this.createManyToManyRelationshipClass(ci1, ci2, pi2.name(), pi1.name(), pi2, pi1);
    }

    private void createManyToManyRelationshipClass(ClassInfo source, ClassInfo target, String roleNameSource, String roleNameTarget, PropertyInfo sourceRole, PropertyInfo targetRole) {
        SortedSet<ClassInfo> targets;
        SortedSet<ClassInfo> sources;
        int sourceElementId = (Integer)elementIdByClassInfo.get(source);
        Element eaClassSource = rep.GetElementByID(sourceElementId);
        int targetElementId = (Integer)elementIdByClassInfo.get(target);
        Element eaClassTarget = rep.GetElementByID(targetElementId);
        if (eaClassSource == null || eaClassTarget == null) {
            this.result.addError(this, 225, source.name(), target.name());
            return;
        }
        if (source.isAbstract()) {
            sources = this.computeListOfAllNonAbstractSubtypes(source);
        } else {
            sources = new TreeSet<ClassInfo>();
            sources.add(source);
        }
        if (target.isAbstract()) {
            targets = this.computeListOfAllNonAbstractSubtypes(target);
        } else {
            targets = new TreeSet<ClassInfo>();
            targets.add(target);
        }
        for (ClassInfo source_ : sources) {
            int sourceElementId_ = (Integer)elementIdByClassInfo.get(source_);
            Element sourceElmt = rep.GetElementByID(sourceElementId_);
            for (ClassInfo target_ : targets) {
                int targetElementId_ = (Integer)elementIdByClassInfo.get(target_);
                Element targetElmt = rep.GetElementByID(targetElementId_);
                if (sourceElmt == null) {
                    this.result.addError(this, 239, source.name(), target.name(), source_.name(), target_.name());
                    continue;
                }
                if (targetElmt == null) {
                    this.result.addError(this, 239, source.name(), target.name(), target_.name(), source_.name());
                    continue;
                }
                try {
                    String relClassName = this.computeRelationshipClassName(source_, target_);
                    String assocClassName = this.normalizeName(relClassName);
                    if (this.exceedsMaxLength(assocClassName)) {
                        this.result.addWarning(this, 226, assocClassName, "" + maxNameLength);
                        assocClassName = this.clipToMaxLength(assocClassName);
                    }
                    Element assocClass = EARepositoryUtil.createEAClass(rep, assocClassName, assocClassesPkgId);
                    this.setAuthorAndStatus(assocClass);
                    Attribute foreignKeyFieldSrc = null;
                    Attribute foreignKeyFieldTgt = null;
                    Attribute ridField = null;
                    try {
                        ridField = this.createField(assocClass, "RID", "", "", "esriFieldTypeOID", "0", "0", "0", null, null, true);
                    }
                    catch (EAException e) {
                        this.result.addError(this, 10003, "RID", assocClassName, e.getMessage());
                        return;
                    }
                    String srcAlias = "";
                    if (sourceRole != null && StringUtils.isNotBlank((CharSequence)sourceRole.aliasName())) {
                        srcAlias = sourceRole.aliasName();
                    }
                    Object fkSrcName = roleNameSource + foreignKeySuffix;
                    if (this.exceedsMaxLength((String)(fkSrcName = this.normalizeName((String)fkSrcName)))) {
                        this.result.addWarning(this, 227, (String)fkSrcName, "" + maxNameLength);
                        fkSrcName = this.clipToMaxLength((String)fkSrcName);
                    }
                    try {
                        foreignKeyFieldSrc = this.createForeignKeyField(assocClass, (String)fkSrcName, srcAlias, "", source_);
                        if (sourceRole != null) {
                            this.addTaggedValuesToRepresent(foreignKeyFieldSrc, (Info)sourceRole);
                        }
                    }
                    catch (EAException e) {
                        this.result.addError(this, 10003, (String)fkSrcName, assocClassName, e.getMessage());
                        return;
                    }
                    String tgtAlias = "";
                    if (targetRole != null && StringUtils.isNotBlank((CharSequence)targetRole.aliasName())) {
                        tgtAlias = targetRole.aliasName();
                    }
                    Object fkTgtName = roleNameTarget + foreignKeySuffix;
                    if (this.exceedsMaxLength((String)(fkTgtName = this.normalizeName((String)fkTgtName)))) {
                        this.result.addWarning(this, 227, (String)fkTgtName, "" + maxNameLength);
                        fkTgtName = this.clipToMaxLength((String)fkTgtName);
                    }
                    try {
                        foreignKeyFieldTgt = this.createForeignKeyField(assocClass, (String)fkTgtName, tgtAlias, "", target_);
                        if (targetRole != null) {
                            this.addTaggedValuesToRepresent(foreignKeyFieldTgt, (Info)targetRole);
                        }
                    }
                    catch (EAException e) {
                        this.result.addError(this, 10003, (String)fkTgtName, assocClassName, e.getMessage());
                        return;
                    }
                    EAElementUtil.setEAStereotypeEx(assocClass, "ArcGIS::RelationshipClass");
                    EAElementUtil.updateTaggedValue(assocClass, "CanVersion", "false", false);
                    EAElementUtil.updateTaggedValue(assocClass, "CatalogPath", "", false);
                    EAElementUtil.updateTaggedValue(assocClass, "ClassKey", "esriRelClassKeyUndefined", false);
                    EAElementUtil.updateTaggedValue(assocClass, "DSID", "-1", false);
                    EAElementUtil.updateTaggedValue(assocClass, "DatasetType", "esriDTRelationshipClass", false);
                    EAElementUtil.updateTaggedValue(assocClass, "DestinationForeignKey", foreignKeyFieldTgt.GetAttributeGUID(), false);
                    EAElementUtil.updateTaggedValue(assocClass, "DestinationPrimaryKey", this.determinePrimaryKeyGUID(target_), false);
                    EAElementUtil.updateTaggedValue(assocClass, "GlobalIDFieldName", "", false);
                    EAElementUtil.updateTaggedValue(assocClass, "IsAttachmentRelationship", "false", false);
                    EAElementUtil.updateTaggedValue(assocClass, "IsComposite", "false", false);
                    EAElementUtil.updateTaggedValue(assocClass, "IsReflexive", "false", false);
                    EAElementUtil.updateTaggedValue(assocClass, "KeyType", "esriRelKeyTypeSingle", false);
                    EAElementUtil.updateTaggedValue(assocClass, "Metadata", "", true);
                    EAElementUtil.updateTaggedValue(assocClass, "MetadataRetrieved", "false", false);
                    EAElementUtil.updateTaggedValue(assocClass, "ModelName", "", false);
                    EAElementUtil.updateTaggedValue(assocClass, "Notification", "useUMLConnectorDirection", false);
                    EAElementUtil.updateTaggedValue(assocClass, "OIDFieldName", ridField.GetAttributeGUID(), false);
                    EAElementUtil.updateTaggedValue(assocClass, "OriginForeignKey", foreignKeyFieldSrc.GetAttributeGUID(), false);
                    EAElementUtil.updateTaggedValue(assocClass, "OriginPrimaryKey", this.determinePrimaryKeyGUID(source_), false);
                    EAElementUtil.updateTaggedValue(assocClass, "RasterFieldName", "", false);
                    EAElementUtil.updateTaggedValue(assocClass, "Versioned", "false", false);
                    Connector con = EAElementUtil.createEAAssociation(sourceElmt, targetElmt);
                    EAConnectorUtil.setEAName(con, assocClassName);
                    EAConnectorUtil.setEAStereotypeEx(con, "ArcGIS::RelationshipClass");
                    ConnectorEnd clientEnd = con.GetClientEnd();
                    ConnectorEnd supplierEnd = con.GetSupplierEnd();
                    AssociationInfo assocForRepresentingTVs = null;
                    if (sourceRole != null) {
                        this.addTaggedValuesToRepresent(clientEnd, (Info)sourceRole);
                        if (!sourceRole.isAttribute()) {
                            assocForRepresentingTVs = sourceRole.association();
                        }
                    }
                    if (targetRole != null) {
                        this.addTaggedValuesToRepresent(supplierEnd, (Info)targetRole);
                        if (!targetRole.isAttribute()) {
                            assocForRepresentingTVs = targetRole.association();
                        }
                    }
                    if (assocForRepresentingTVs != null) {
                        this.addTaggedValuesToRepresent(con, assocForRepresentingTVs);
                        this.addTaggedValuesToRepresent(assocClass, (Info)assocForRepresentingTVs);
                    }
                    String sourcePropName = this.toLowerCamelCase(roleNameSource);
                    sourcePropName = this.checkPropertyName(target_, sourcePropName);
                    String targetPropName = this.toLowerCamelCase(roleNameTarget);
                    targetPropName = this.checkPropertyName(source_, targetPropName);
                    EAConnectorEndUtil.setEARole(clientEnd, this.toLowerCamelCase(sourcePropName));
                    EAConnectorEndUtil.setEARole(supplierEnd, this.toLowerCamelCase(targetPropName));
                    EAConnectorEndUtil.setEACardinality(clientEnd, "0..*");
                    EAConnectorEndUtil.setEACardinality(supplierEnd, "0..*");
                    EAConnectorUtil.updateTaggedValue(con, "CanVersion", "false", false);
                    EAConnectorUtil.updateTaggedValue(con, "CatalogPath", "", false);
                    EAConnectorUtil.updateTaggedValue(con, "ClassKey", "esriRelClassKeyUndefined", false);
                    EAConnectorUtil.updateTaggedValue(con, "DSID", "-1", false);
                    EAConnectorUtil.updateTaggedValue(con, "DatasetType", "esriDTRelationshipClass", false);
                    EAConnectorUtil.updateTaggedValue(con, "DestinationForeignKey", foreignKeyFieldTgt.GetAttributeGUID(), false);
                    EAConnectorUtil.updateTaggedValue(con, "DestinationPrimaryKey", this.determinePrimaryKeyGUID(target_), false);
                    EAConnectorUtil.updateTaggedValue(con, "GlobalIDFieldName", "", false);
                    EAConnectorUtil.updateTaggedValue(con, "IsAttachmentRelationship", "false", false);
                    EAConnectorUtil.updateTaggedValue(con, "IsComposite", "false", false);
                    EAConnectorUtil.updateTaggedValue(con, "IsReflexive", "false", false);
                    EAConnectorUtil.updateTaggedValue(con, "KeyType", "esriRelKeyTypeSingle", false);
                    EAConnectorUtil.updateTaggedValue(con, "Metadata", "", true);
                    EAConnectorUtil.updateTaggedValue(con, "MetadataRetrieved", "false", false);
                    EAConnectorUtil.updateTaggedValue(con, "ModelName", "", false);
                    EAConnectorUtil.updateTaggedValue(con, "Notification", "useUMLConnectorDirection", false);
                    EAConnectorUtil.updateTaggedValue(con, "OIDFieldName", ridField.GetAttributeGUID(), false);
                    EAConnectorUtil.updateTaggedValue(con, "OriginForeignKey", foreignKeyFieldSrc.GetAttributeGUID(), false);
                    EAConnectorUtil.updateTaggedValue(con, "OriginPrimaryKey", this.determinePrimaryKeyGUID(source_), false);
                    EAConnectorUtil.updateTaggedValue(con, "RasterFieldName", "", false);
                    EAConnectorUtil.updateTaggedValue(con, "Versioned", "false", false);
                    EAConnectorUtil.setEAAssociationClass(con, assocClass);
                }
                catch (EAException e) {
                    this.result.addError(this, 221, source_.name(), target_.name(), e.getMessage());
                }
            }
        }
    }

    private String determinePrimaryKeyGUID(ClassInfo ci) {
        if (identifierAttributeGUIDByClass.containsKey(ci)) {
            return (String)identifierAttributeGUIDByClass.get(ci);
        }
        return (String)objectIdAttributeGUIDByClass.get(ci);
    }

    private String computeRelationshipClassName(ClassInfo source, ClassInfo target) {
        String sourceName = source.name();
        String targetName = target.name();
        if (source.matches("rule-arcgis-all-relationshipClassNameByTaggedValueOfClasses")) {
            if (StringUtils.isNotBlank((CharSequence)source.taggedValue(shortNameByTaggedValue))) {
                sourceName = source.taggedValue(shortNameByTaggedValue);
            }
            if (StringUtils.isNotBlank((CharSequence)target.taggedValue(shortNameByTaggedValue))) {
                targetName = target.taggedValue(shortNameByTaggedValue);
            }
        }
        Object relClassName = sourceName + "_" + targetName;
        relClassName = this.checkRelationshipClassName((String)relClassName);
        return relClassName;
    }

    private void createOneToManyRelationshipClass(PropertyInfo pi) {
        ClassInfo ci = pi.inClass();
        Type typeInfo = pi.typeInfo();
        ClassInfo typeCi = model.classById(typeInfo.id);
        if (typeCi == null || !elementIdByClassInfo.containsKey(typeCi)) {
            this.result.addError(this, 218, pi.name(), pi.inClass().name(), typeInfo.name);
        } else {
            this.createOneToManyRelationshipClass(ci, typeCi, this.toLowerCamelCase(ci.name()), pi.name(), Integer.MAX_VALUE, false, null, pi);
        }
    }

    private void createOneToManyRelationshipClass(AssociationInfo ai) {
        ClassInfo ci1 = ai.end2().inClass();
        ClassInfo ci2 = ai.end1().inClass();
        String roleNameOnCi1 = ai.end1().name();
        String roleNameOnCi2 = ai.end2().name();
        int maxOccursOnCi1 = ai.end1().cardinality().maxOccurs;
        this.createOneToManyRelationshipClass(ci1, ci2, roleNameOnCi1, roleNameOnCi2, maxOccursOnCi1, ai.end1().isNavigable(), ai.end1(), ai.end2());
    }

    private void createOneToManyRelationshipClass(ClassInfo ci1, ClassInfo ci2, String roleNameOnCi1, String roleNameOnCi2, int maxOccursOnCi1, boolean isNavigableOnCi1, PropertyInfo roleOnCi1, PropertyInfo roleOnCi2) {
        SortedSet<ClassInfo> targets;
        SortedSet<ClassInfo> sources;
        Attribute foreignKeyField;
        PropertyInfo roleTarget;
        PropertyInfo roleSource;
        String roleNameTarget;
        String roleNameSource;
        ClassInfo target;
        ClassInfo source;
        if (maxOccursOnCi1 <= 1 && isNavigableOnCi1) {
            source = ci1;
            target = ci2;
            roleNameSource = roleNameOnCi1;
            roleNameTarget = roleNameOnCi2;
            roleSource = roleOnCi1;
            roleTarget = roleOnCi2;
        } else {
            source = ci2;
            target = ci1;
            roleNameSource = roleNameOnCi2;
            roleNameTarget = roleNameOnCi1;
            roleSource = roleOnCi2;
            roleTarget = roleOnCi1;
        }
        int eaElementId = (Integer)elementIdByClassInfo.get(target);
        Element eaClassTarget = rep.GetElementByID(eaElementId);
        if (eaClassTarget == null) {
            this.result.addError(this, 237, source.name(), target.name(), target.name());
            return;
        }
        String name = this.normalizeName(roleNameSource + foreignKeySuffix);
        String alias = "";
        if (roleSource != null && StringUtils.isNotBlank((CharSequence)roleSource.aliasName())) {
            alias = roleSource.aliasName();
        }
        if (this.exceedsMaxLength(name)) {
            this.result.addWarning(this, 205, name, roleNameSource, target.name(), "" + maxNameLength);
            name = this.clipToMaxLength(name);
        }
        try {
            foreignKeyField = this.createForeignKeyField(eaClassTarget, name, alias, "", source);
            if (roleSource != null) {
                this.addTaggedValuesToRepresent(foreignKeyField, (Info)roleSource);
            }
        }
        catch (EAException e) {
            this.result.addError(this, 10003, roleNameTarget, target.name(), e.getMessage());
            return;
        }
        if (source.isAbstract()) {
            sources = this.computeListOfAllNonAbstractSubtypes(source);
        } else {
            sources = new TreeSet<ClassInfo>();
            sources.add(source);
        }
        if (target.isAbstract()) {
            targets = this.computeListOfAllNonAbstractSubtypes(target);
        } else {
            targets = new TreeSet<ClassInfo>();
            targets.add(target);
        }
        for (ClassInfo source_ : sources) {
            int sourceElementId_ = (Integer)elementIdByClassInfo.get(source_);
            Element sourceElmt = rep.GetElementByID(sourceElementId_);
            for (ClassInfo target_ : targets) {
                int targetElementId_ = (Integer)elementIdByClassInfo.get(target_);
                Element targetElmt = rep.GetElementByID(targetElementId_);
                if (sourceElmt == null) {
                    this.result.addError(this, 238, source.name(), target.name(), source_.name(), target_.name());
                    continue;
                }
                if (targetElmt == null) {
                    this.result.addError(this, 238, source.name(), target.name(), target_.name(), source_.name());
                    continue;
                }
                try {
                    Connector con = EAElementUtil.createEAAssociation(sourceElmt, targetElmt);
                    String relClassName = this.computeRelationshipClassName(source_, target_);
                    if (this.exceedsMaxLength(relClassName)) {
                        this.result.addWarning(this, 234, relClassName, "" + maxNameLength);
                        relClassName = this.clipToMaxLength(relClassName);
                    }
                    EAConnectorUtil.setEAName(con, relClassName);
                    EAConnectorUtil.setEAStereotypeEx(con, "ArcGIS::RelationshipClass");
                    ConnectorEnd clientEnd = con.GetClientEnd();
                    ConnectorEnd supplierEnd = con.GetSupplierEnd();
                    AssociationInfo assocForRepresentingTVs = null;
                    if (roleSource != null) {
                        this.addTaggedValuesToRepresent(clientEnd, (Info)roleSource);
                        if (!roleSource.isAttribute()) {
                            assocForRepresentingTVs = roleSource.association();
                        }
                    }
                    if (roleTarget != null) {
                        this.addTaggedValuesToRepresent(supplierEnd, (Info)roleTarget);
                        if (!roleTarget.isAttribute()) {
                            assocForRepresentingTVs = roleTarget.association();
                        }
                    }
                    if (assocForRepresentingTVs != null) {
                        this.addTaggedValuesToRepresent(con, assocForRepresentingTVs);
                    }
                    String sourcePropName = this.toLowerCamelCase(roleNameSource);
                    sourcePropName = this.checkPropertyName(target_, sourcePropName);
                    String targetPropName = this.toLowerCamelCase(roleNameTarget);
                    targetPropName = this.checkPropertyName(source_, targetPropName);
                    EAConnectorEndUtil.setEARole(clientEnd, this.toLowerCamelCase(sourcePropName));
                    EAConnectorEndUtil.setEARole(supplierEnd, this.toLowerCamelCase(targetPropName));
                    EAConnectorEndUtil.setEACardinality(clientEnd, "1");
                    EAConnectorEndUtil.setEACardinality(supplierEnd, "0..*");
                    EAConnectorUtil.updateTaggedValue(con, "KeyType", "esriRelKeyTypeSingle", false);
                    EAConnectorUtil.updateTaggedValue(con, "ClassKey", "esriRelClassKeyUndefined", false);
                    EAConnectorUtil.updateTaggedValue(con, "OriginPrimaryKey", this.determinePrimaryKeyGUID(source_), false);
                    EAConnectorUtil.updateTaggedValue(con, "OriginForeignKey", foreignKeyField.GetAttributeGUID(), false);
                    EAConnectorUtil.updateTaggedValue(con, "DestinationPrimaryKey", "", false);
                    EAConnectorUtil.updateTaggedValue(con, "DestinationForeignKey", "", false);
                    EAConnectorUtil.updateTaggedValue(con, "IsComposite", "false", false);
                    EAConnectorUtil.updateTaggedValue(con, "IsReflexive", "false", false);
                    EAConnectorUtil.updateTaggedValue(con, "DatasetType", "esriDTRelationshipClass", false);
                    EAConnectorUtil.updateTaggedValue(con, "OIDFieldName", "", false);
                    EAConnectorUtil.updateTaggedValue(con, "DSID", "-1", false);
                    EAConnectorUtil.updateTaggedValue(con, "ModelName", "", false);
                    EAConnectorUtil.updateTaggedValue(con, "GlobalIDFieldName", "", false);
                    EAConnectorUtil.updateTaggedValue(con, "CatalogPath", "", false);
                    EAConnectorUtil.updateTaggedValue(con, "RasterFieldName", "", false);
                    EAConnectorUtil.updateTaggedValue(con, "Versioned", "false", false);
                    EAConnectorUtil.updateTaggedValue(con, "CanVersion", "false", false);
                    EAConnectorUtil.updateTaggedValue(con, "MetadataRetrieved", "false", false);
                    EAConnectorUtil.updateTaggedValue(con, "Metadata", "", true);
                    EAConnectorUtil.updateTaggedValue(con, "Notification", "useUMLConnectorDirection", false);
                    EAConnectorUtil.updateTaggedValue(con, "IsAttachmentRelationship", "false", false);
                }
                catch (EAException e) {
                    this.result.addError(this, 221, source_.name(), target_.name(), e.getMessage());
                }
            }
        }
    }

    private String checkRelationshipClassName(String relClassName) {
        if (counterByRelationshipClassName.containsKey(relClassName)) {
            Integer count = (Integer)counterByRelationshipClassName.get(relClassName);
            int newCount = count + 1;
            String updatedName = relClassName + "_" + newCount;
            counterByRelationshipClassName.put(relClassName, newCount);
            return updatedName;
        }
        counterByRelationshipClassName.put(relClassName, 1);
        return relClassName;
    }

    private String checkPropertyName(ClassInfo ci, String propertyName) {
        if (counterByPropertyNameByClass.containsKey(ci)) {
            Map tmp = (Map)counterByPropertyNameByClass.get(ci);
            if (tmp.containsKey(propertyName)) {
                Integer count = (Integer)tmp.get(propertyName);
                int newCount = count + 1;
                String updatedName = propertyName + "_" + newCount;
                tmp.put(propertyName, newCount);
                return updatedName;
            }
            tmp.put(propertyName, 1);
            return propertyName;
        }
        TreeMap<String, Integer> tmp = new TreeMap<String, Integer>();
        tmp.put(propertyName, 1);
        counterByPropertyNameByClass.put(ci, tmp);
        return propertyName;
    }

    private SortedSet<ClassInfo> computeListOfAllNonAbstractSubtypes(ClassInfo ci) {
        TreeSet<ClassInfo> allNonAbstractSubtypes = new TreeSet<ClassInfo>();
        if (ci.subtypes() != null) {
            for (String subtypeId : ci.subtypes()) {
                ClassInfo subtype = model.classById(subtypeId);
                if (subtype == null) {
                    this.result.addWarning(this, 219, subtypeId, ci.name());
                    continue;
                }
                if (this.isExplicitlyModeledArcGISSubtype(subtype)) {
                    // empty if block
                }
                if (model.isInSelectedSchemas(subtype)) {
                    if (!subtype.isAbstract()) {
                        allNonAbstractSubtypes.add(subtype);
                    }
                    allNonAbstractSubtypes.addAll(this.computeListOfAllNonAbstractSubtypes(subtype));
                    continue;
                }
                this.result.addWarning(this, 220, subtype.name(), ci.name());
            }
        }
        return allNonAbstractSubtypes;
    }

    private String toLowerCamelCase(String s) {
        if (keepCaseOfRolename || s == null || s.length() == 0) {
            return s;
        }
        String first = s.substring(0, 1);
        String lower = first.toLowerCase(Locale.ENGLISH);
        return lower + s.substring(1, s.length());
    }

    private boolean isNumericallyValued(ClassInfo ci) {
        return StringUtils.isNotBlank((CharSequence)ci.taggedValue("numericType"));
    }

    private Integer computeScale(Info pi, String valueTypeName) {
        String nameOfScaleTV = "scale";
        String scaleTV = pi.taggedValue(nameOfScaleTV);
        if ((pi.matches("rule-arcgis-all-scale") || pi.matches("rule-arcgis-prop-scale")) && StringUtils.isNotBlank((CharSequence)scaleTV)) {
            try {
                Integer scale = Integer.parseInt(scaleTV.trim());
                return scale;
            }
            catch (NumberFormatException e) {
                ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 243, scaleTV.trim(), nameOfScaleTV);
                mc.addDetail(this, 20001, pi.fullNameInSchema());
            }
        }
        if (scaleMappingByTypeName.containsKey(valueTypeName)) {
            return (Integer)scaleMappingByTypeName.get(valueTypeName);
        }
        return 0;
    }

    private Integer computePrecision(Info pi, String valueTypeName) {
        String nameOfPrecisionTV = "precision";
        String precisionTV = pi.taggedValue(nameOfPrecisionTV);
        if ((pi.matches("rule-arcgis-all-precision") || pi.matches("rule-arcgis-prop-precision")) && StringUtils.isNotBlank((CharSequence)precisionTV)) {
            try {
                Integer prec = Integer.parseInt(precisionTV.trim());
                return prec;
            }
            catch (NumberFormatException e) {
                ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 243, precisionTV.trim(), nameOfPrecisionTV);
                mc.addDetail(this, 20001, pi.fullNameInSchema());
            }
        }
        if (precisionMappingByTypeName.containsKey(valueTypeName)) {
            return (Integer)precisionMappingByTypeName.get(valueTypeName);
        }
        return 0;
    }

    private boolean computeIsNullable(PropertyInfo pi) {
        if (pi.matches("rule-arcgis-prop-isNullable")) {
            return pi.voidable() || pi.cardinality().minOccurs < 1;
        }
        return true;
    }

    private int computeLength(PropertyInfo pi, String valueTypeName) {
        String tv;
        if (lengthMappingByTypeName.containsKey(valueTypeName)) {
            return (Integer)lengthMappingByTypeName.get(valueTypeName);
        }
        if (pi.matches("rule-arcgis-prop-lengthFromTaggedValue") && StringUtils.isNotBlank((CharSequence)(tv = pi.taggedValue(nameOfTVToDetermineFieldLength)))) {
            try {
                Integer value = Integer.parseInt(tv.trim());
                if (value >= 0) {
                    return value;
                }
            }
            catch (NumberFormatException e) {
                ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 243, tv.trim(), nameOfTVToDetermineFieldLength);
                mc.addDetail(this, 20001, pi.fullNameInSchema());
            }
        }
        ClassInfo ci = pi.inClass();
        Integer length = null;
        length = (Integer)lengthByClassPropName.get(ci.name() + "_" + pi.name());
        if (length == null) {
            return lengthTaggedValueDefault;
        }
        return length;
    }

    private int computeLengthForCodelistOrEnumerationValueType(PropertyInfo pi) {
        String tv;
        if (pi.matches("rule-arcgis-prop-lengthFromTaggedValueForCodelistOrEnumerationValueType") && StringUtils.isNotBlank((CharSequence)(tv = pi.taggedValue(nameOfTVToDetermineFieldLength)))) {
            try {
                Integer value = Integer.parseInt(tv.trim());
                if (value >= 0) {
                    return value;
                }
            }
            catch (NumberFormatException e) {
                ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 243, tv.trim(), nameOfTVToDetermineFieldLength);
                mc.addDetail(this, 20001, pi.fullNameInSchema());
            }
        }
        if (pi.matches("rule-arcgis-prop-lengthFromCodesOrEnumsOfValueType")) {
            ClassInfo typeCi = model.classById(pi.typeInfo().id);
            if (typeCi == null) {
                ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 244, pi.typeInfo().name, pi.name());
                mc.addDetail(this, 20001, pi.fullNameInSchema());
            } else if (!typeCi.properties().isEmpty()) {
                int maxLength = 0;
                for (PropertyInfo pix : typeCi.properties().values()) {
                    if (pix.name().length() <= maxLength) continue;
                    maxLength = pix.name().length();
                }
                return maxLength;
            }
        }
        return 0;
    }

    private Attribute createField(Element e, String name, String alias, String documentation, String eaType, String tvLength, String tvPrecision, String tvScale, Integer eaClassifierId, String initialValue, boolean isNullable) throws EAException {
        return this.createField(e, name, alias, documentation, eaType, tvLength, tvPrecision, tvScale, eaClassifierId, initialValue, isNullable, "Field");
    }

    private Attribute createField(Element e, String name, String alias, String documentation, String eaType, String tvLength, String tvPrecision, String tvScale, Integer eaClassifierId, String initialValue, boolean isNullable, String stereotype) throws EAException {
        ArrayList<EATaggedValue> tvs = new ArrayList<EATaggedValue>();
        tvs.add(new EATaggedValue("DomainFixed", "false"));
        tvs.add(new EATaggedValue("Editable", "true"));
        tvs.add(new EATaggedValue("GeometryDef", "", true));
        tvs.add(new EATaggedValue("IsNullable", isNullable ? "true" : "false"));
        tvs.add(new EATaggedValue("Length", tvLength));
        tvs.add(new EATaggedValue("ModelName", ""));
        tvs.add(new EATaggedValue("Precision", tvPrecision));
        tvs.add(new EATaggedValue("RasterDef", "", true));
        tvs.add(new EATaggedValue("Required", "false"));
        tvs.add(new EATaggedValue("Scale", tvScale));
        TreeSet<String> stereotypes = new TreeSet<String>();
        stereotypes.add(stereotype);
        if (eaClassifierId != null) {
            elementIdsOfUnusedCodedValueDomain.remove(eaClassifierId);
        }
        return EAElementUtil.createEAAttribute(e, name, alias, documentation, stereotypes, tvs, false, false, false, initialValue, false, new Multiplicity(1, 1), eaType, eaClassifierId);
    }

    @Override
    public String getTargetName() {
        return "ArcGIS Workspace";
    }

    @Override
    public void reset() {
        initialised = false;
        model = null;
        numberOfSchemasSelectedForProcessing = 0;
        workspaceTemplateFilePath = "http://shapechange.net/resources/templates/ArcGISWorkspace_template.eap";
        maxNameLength = 30;
        lengthTaggedValueDefault = 255;
        numRangeDelta = 0.01;
        esriTypesSuitedForRangeConstraint = new TreeSet<String>();
        outputDirectory = null;
        outputDirectoryFile = null;
        documentationTemplate = null;
        documentationNoValue = null;
        rep = null;
        ignoredCis = new TreeSet<ClassInfo>();
        geometryTypeCache = new TreeMap<ClassInfo, ArcGISGeometryType>();
        elementIdByClassInfo = new TreeMap<ClassInfo, Integer>();
        elementNameByClassInfo = new TreeMap<ClassInfo, String>();
        elementIdsOfUnusedCodedValueDomain = new TreeSet<Integer>();
        objectIdAttributeGUIDByClass = new TreeMap<ClassInfo, String>();
        identifierAttributeGUIDByClass = new TreeMap<ClassInfo, String>();
        generalisations = new TreeMap<ClassInfo, ClassInfo>();
        arcgisSubtypes = new HashSet<ClassInfo>();
        subtypeElementIdBySubtypeNameByParent = new TreeMap<ClassInfo, Map<String, Integer>>();
        subtypeCodedValueDomainEAIDByMultiKey = new MultiKeyMap();
        associations = new TreeSet<AssociationInfo>();
        counterByRelationshipClassName = new TreeMap<String, Integer>();
        counterByPropertyNameByClass = new TreeMap<ClassInfo, SortedMap<String, Integer>>();
        workspacePkgId = null;
        featuresPkgId = null;
        tablesPkgId = null;
        assocClassesPkgId = null;
        domainsPkgId = null;
        eaPkgIdByModelPkg_byWorkspaceSubPkgId = new TreeMap<Integer, SortedMap<PackageInfo, Integer>>();
        processMapEntries = null;
        lengthMappingByTypeName = new TreeMap<String, Integer>();
        precisionMappingByTypeName = new TreeMap<String, Integer>();
        scaleMappingByTypeName = new TreeMap<String, Integer>();
        lengthByClassPropName = new TreeMap<String, Integer>();
        numericRangeConstraintByPropNameByClassName = new TreeMap<ClassInfo, SortedMap<String, NumericRangeConstraintMetadata>>();
        nameOfTVToDetermineFieldLength = "size";
        absolutePathOfOutputEAPFile = null;
        shortNameByTaggedValue = null;
        keepCaseOfRolename = false;
        foreignKeySuffix = "ID";
        reflexiveRelationshipAttributeSuffix = "";
        numericRangeElementIdsByClassName = new TreeMap<String, Integer>();
        taggedValuesToRepresent = null;
        representTaggedValues = false;
        author = null;
        status = null;
    }

    @Override
    public void writeAll(ShapeChangeResult r) {
        if (rep == null) {
            return;
        }
        this.result = r;
        this.options = r.options();
        for (Map.Entry<ClassInfo, ClassInfo> entry : generalisations.entrySet()) {
            ClassInfo ci1 = entry.getKey();
            ClassInfo ci2 = entry.getValue();
            if (!elementIdByClassInfo.containsKey(ci1)) {
                this.result.addWarning(this, 207, ci1.name(), ci2.name());
                continue;
            }
            if (!elementIdByClassInfo.containsKey(ci2)) {
                this.result.addWarning(this, 208, ci1.name(), ci2.name());
                continue;
            }
            String c1Name = (String)elementNameByClassInfo.get(ci1);
            String c2Name = (String)elementNameByClassInfo.get(ci2);
            String generalizationStereotype = "";
            if (arcgisSubtypes.contains(ci1)) {
                generalizationStereotype = "ArcGIS::Subtype";
            }
            try {
                Connector con = EARepositoryUtil.createEAGeneralization(rep, (Integer)elementIdByClassInfo.get(ci1), c1Name, (Integer)elementIdByClassInfo.get(ci2), c2Name);
                if (!StringUtils.isNotBlank((CharSequence)generalizationStereotype)) continue;
                EAConnectorUtil.setEAStereotypeEx(con, generalizationStereotype);
            }
            catch (EAException e) {
                this.result.addWarning(this, 10002, c1Name, c2Name, e.getMessage());
            }
        }
        ArrayList<PropertyInfo> pisToCreateRelationshipClassesWith = new ArrayList<PropertyInfo>();
        for (ClassInfo ci : elementIdByClassInfo.keySet()) {
            if (ci.category() == 3 || ci.category() == 2) continue;
            int eaElementId = (Integer)elementIdByClassInfo.get(ci);
            Element eaClass = rep.GetElementByID(eaElementId);
            for (PropertyInfo pi : ci.properties().values()) {
                String normalizedPiAlias;
                if (this.isExplicitlyModeledArcGISSubtype(ci)) {
                    ShapeChangeResult.MessageContext mc;
                    ClassInfo supertype = ci.baseClass();
                    Type t = pi.typeInfo();
                    if (t.name.startsWith("GM_")) {
                        mc = this.result.addWarning(this, 266, ci.name(), supertype.name(), pi.name(), t.name);
                        if (mc == null) continue;
                        mc.addDetail(this, -2, pi.fullNameInSchema());
                        continue;
                    }
                    if (supertype.property(pi.name()) == null) {
                        mc = this.result.addWarning(this, 265, ci.name(), supertype.name(), pi.name());
                        if (mc == null) continue;
                        mc.addDetail(this, -2, pi.fullNameInSchema());
                        continue;
                    }
                }
                Attribute eaAtt = null;
                if (!pi.isAttribute()) {
                    associations.add(pi.association());
                    continue;
                }
                String initialValue = null;
                if (pi.matches("rule-arcgis-prop-initialValue")) {
                    initialValue = pi.initialValue();
                }
                Type typeInfo = pi.typeInfo();
                String mappedTypeName = typeInfo.name;
                if (typeInfo.id.equals(ci.id())) {
                    if (pi.matches("rule-arcgis-prop-reflexiveRelationshipAsField")) {
                        try {
                            this.createFieldForReflexiveRelationshipProperty(eaClass, pi);
                        }
                        catch (EAException e) {
                            this.result.addError(this, 10005, pi.name(), ci.name(), e.getMessage());
                        }
                        continue;
                    }
                    this.result.addWarning(this, 236, ci.name(), pi.name());
                    continue;
                }
                if (pi.cardinality().maxOccurs > 1 && pi.categoryOfValue() != 1 && pi.categoryOfValue() != 6 && pi.categoryOfValue() != 6) {
                    this.result.addWarning(this, 212, pi.name(), ci.name());
                    continue;
                }
                ClassInfo typeCi = model.classByIdOrName(typeInfo);
                String normalizedPiName = this.normalizeName(pi.name());
                if (this.exceedsMaxLength(normalizedPiName)) {
                    this.result.addWarning(this, 205, normalizedPiName, pi.name(), ci.name(), "" + maxNameLength);
                    normalizedPiName = this.clipToMaxLength(normalizedPiName);
                }
                String string = normalizedPiAlias = pi.aliasName() == null ? null : this.normalizeAlias(pi.aliasName(), ci);
                if (processMapEntries.containsKey(typeInfo.name)) {
                    ProcessMapEntry pme = (ProcessMapEntry)processMapEntries.get(typeInfo.name);
                    Element numericRange = null;
                    if (esriTypesSuitedForRangeConstraint.contains(pme.getTargetType()) && numericRangeConstraintByPropNameByClassName.containsKey(ci)) {
                        numericRange = this.determineNumericRange(ci, pi, pme);
                    }
                    if (numericRange != null) {
                        try {
                            String valueType = numericRange.GetName();
                            eaAtt = this.createField(eaClass, normalizedPiName, normalizedPiAlias, pi.derivedDocumentation(documentationTemplate, documentationNoValue), valueType, "0", "" + this.computePrecision(pi, valueType), "" + this.computeScale(pi, valueType), numericRange.GetElementID(), initialValue, this.computeIsNullable(pi));
                        }
                        catch (EAException e) {
                            this.result.addError(this, 10003, pi.name(), ci.name(), e.getMessage());
                        }
                    } else {
                        String eaTargetType;
                        ClassInfo targetTypeCi = model.classByName(pme.getTargetType());
                        mappedTypeName = pme.getTargetType();
                        Integer eaTargetClassifierId = null;
                        if (targetTypeCi == null || !elementIdByClassInfo.containsKey(targetTypeCi)) {
                            eaTargetType = pme.getTargetType();
                        } else {
                            int eaTargetTypeElementId = (Integer)elementIdByClassInfo.get(targetTypeCi);
                            Element eaTargetTypeClass = rep.GetElementByID(eaTargetTypeElementId);
                            eaTargetType = eaTargetTypeClass.GetName();
                            eaTargetClassifierId = eaTargetTypeClass.GetElementID();
                        }
                        try {
                            if (pi.matches("rule-arcgis-all-subtypes") && StringUtils.isNotBlank((CharSequence)pi.taggedValue("arcgisDefaultSubtype"))) {
                                ShapeChangeResult.MessageContext mc;
                                if (!pi.typeInfo().name.equalsIgnoreCase("Integer") && (mc = this.result.addWarning(this, 267, ci.name(), pi.name(), pi.typeInfo().name)) != null) {
                                    mc.addDetail(this, -2, pi.fullNameInSchema());
                                }
                                eaAtt = this.createField(eaClass, normalizedPiName, normalizedPiAlias, pi.derivedDocumentation(documentationTemplate, documentationNoValue), "esriFieldTypeInteger", "0", "9", "0", null, pi.taggedValue("arcgisDefaultSubtype").trim(), this.computeIsNullable(pi), "ArcGIS::SubtypeField");
                            } else {
                                String derivedDocumentation = pi.derivedDocumentation(documentationTemplate, documentationNoValue);
                                String length = "" + this.computeLength(pi, mappedTypeName);
                                String precision = "" + this.computePrecision(pi, mappedTypeName);
                                String scale = "" + this.computeScale(pi, mappedTypeName);
                                boolean isNullable = this.computeIsNullable(pi);
                                eaAtt = this.createField(eaClass, normalizedPiName, normalizedPiAlias, derivedDocumentation, eaTargetType, length, precision, scale, eaTargetClassifierId, initialValue, isNullable);
                                String arcgisSubtypeInitialValues = pi.taggedValue("arcgisSubtypeInitialValues");
                                if (subtypeElementIdBySubtypeNameByParent.containsKey(ci) && StringUtils.isNotBlank((CharSequence)arcgisSubtypeInitialValues)) {
                                    Map<String, Integer> subtypeEAIDBySubtypeName = subtypeElementIdBySubtypeNameByParent.get(ci);
                                    SortedMap<String, String> initialValueBySubtypeName = this.parseArcGISSubtypeInitialValues(arcgisSubtypeInitialValues, pi);
                                    if (!initialValueBySubtypeName.isEmpty()) {
                                        for (String string2 : initialValueBySubtypeName.keySet()) {
                                            if (!subtypeEAIDBySubtypeName.containsKey(string2)) {
                                                ShapeChangeResult.MessageContext mc = this.result.addError(this, 264, pi.name(), string2, ci.name());
                                                if (mc == null) continue;
                                                mc.addDetail(this, -2, pi.fullNameInSchema());
                                                continue;
                                            }
                                            int subtypeEAElementID = subtypeEAIDBySubtypeName.get(string2);
                                            Element subtypeEAElement = rep.GetElementByID(subtypeEAElementID);
                                            String subtypeInitialValue = (String)initialValueBySubtypeName.get(string2);
                                            Attribute subtypeEAAtt = this.createField(subtypeEAElement, normalizedPiName, normalizedPiAlias, derivedDocumentation, eaTargetType, length, precision, scale, eaTargetClassifierId, subtypeInitialValue, isNullable);
                                            try {
                                                this.addTaggedValuesToRepresent(subtypeEAAtt, (Info)pi);
                                            }
                                            catch (EAException e) {
                                                this.result.addError(this, 251, pi.name(), e.getMessage());
                                            }
                                        }
                                    }
                                }
                            }
                            if (ci.matches("rule-arcgis-cls-identifierStereotype") && pi.stereotype("identifier") && !identifierAttributeGUIDByClass.containsKey(ci)) {
                                identifierAttributeGUIDByClass.put(ci, eaAtt.GetAttributeGUID());
                            }
                        }
                        catch (EAException e) {
                            this.result.addError(this, 10003, pi.name(), ci.name(), e.getMessage());
                        }
                    }
                } else if (typeInfo.name.startsWith("GM_")) {
                    this.result.addDebug(this, 213, pi.name(), ci.name());
                } else if (typeCi != null && !model.isInSelectedSchemas(typeCi)) {
                    this.result.addWarning(this, 222, typeInfo.name, pi.name(), ci.name());
                } else if (pi.categoryOfValue() == 1 || pi.categoryOfValue() == 6 || pi.categoryOfValue() == 6) {
                    pisToCreateRelationshipClassesWith.add(pi);
                } else if (pi.categoryOfValue() == 3 || pi.categoryOfValue() == 2) {
                    if (pi.matches("rule-arcgis-all-subtypes") && StringUtils.isNotBlank((CharSequence)pi.taggedValue("arcgisDefaultSubtype"))) {
                        try {
                            eaAtt = this.createField(eaClass, normalizedPiName, normalizedPiAlias, pi.derivedDocumentation(documentationTemplate, documentationNoValue), "esriFieldTypeInteger", "0", "9", "0", null, pi.taggedValue("arcgisDefaultSubtype").trim(), this.computeIsNullable(pi), "ArcGIS::SubtypeField");
                        }
                        catch (EAException e) {
                            this.result.addError(this, 10003, pi.name(), ci.name(), e.getMessage());
                        }
                    } else {
                        String eaType;
                        Integer eaClassifierId = null;
                        if (typeCi == null || !elementIdByClassInfo.containsKey(typeCi)) {
                            this.result.addWarning(this, 216, typeInfo.name, pi.name(), ci.name());
                            eaType = this.clipToMaxLength(typeInfo.name);
                        } else {
                            int eaTypeElementId = (Integer)elementIdByClassInfo.get(typeCi);
                            Element eaTypeClass = rep.GetElementByID(eaTypeElementId);
                            eaType = eaTypeClass.GetName();
                            eaClassifierId = eaTypeClass.GetElementID();
                        }
                        try {
                            int length = this.computeLengthForCodelistOrEnumerationValueType(pi);
                            Integer precision = this.computePrecision(pi, pi.typeInfo().name);
                            Integer scale = this.computeScale(pi, pi.typeInfo().name);
                            if (typeCi != null && this.isNumericallyValued(typeCi)) {
                                if (precision <= 0 && scale <= 0) {
                                    precision = this.computePrecision(typeCi, typeCi.name());
                                    scale = this.computeScale(typeCi, typeCi.name());
                                }
                                length = 0;
                            }
                            String eaTypeForNonSubtypeField = eaType;
                            Integer eaClassifierIdForNonSubtypeField = eaClassifierId;
                            boolean isNullable = this.computeIsNullable(pi);
                            String derivedDocumentation = pi.derivedDocumentation(documentationTemplate, documentationNoValue);
                            if (subtypeElementIdBySubtypeNameByParent.containsKey(ci)) {
                                String arcgisSubtypeInitialValues = pi.taggedValue("arcgisSubtypeInitialValues");
                                SortedMap subtypeSpecificCodedValueDomainEAIDBySubtypeName = (SortedMap)subtypeCodedValueDomainEAIDByMultiKey.get((Object)ci, (Object)pi);
                                if (StringUtils.isNotBlank((CharSequence)arcgisSubtypeInitialValues) || subtypeSpecificCodedValueDomainEAIDBySubtypeName != null && !subtypeSpecificCodedValueDomainEAIDBySubtypeName.isEmpty()) {
                                    eaTypeForNonSubtypeField = this.determineFieldTypeForCodedValueDomain(typeCi);
                                    eaClassifierIdForNonSubtypeField = null;
                                    SortedMap<String, String> initialValueBySubtypeName = this.parseArcGISSubtypeInitialValues(arcgisSubtypeInitialValues, pi);
                                    Map<String, Integer> subtypeEAIDBySubtypeName = subtypeElementIdBySubtypeNameByParent.get(ci);
                                    for (Map.Entry entry : subtypeEAIDBySubtypeName.entrySet()) {
                                        String subtypeName = (String)entry.getKey();
                                        int subtypeEAElementID = (Integer)entry.getValue();
                                        Element subtypeEAElement = rep.GetElementByID(subtypeEAElementID);
                                        String subtypeInitialValue = (String)initialValueBySubtypeName.get(subtypeName);
                                        String eaTypeForSubtypeField = eaType;
                                        Integer eaClassifierIdForSubtypeField = eaClassifierId;
                                        if (subtypeSpecificCodedValueDomainEAIDBySubtypeName != null && subtypeSpecificCodedValueDomainEAIDBySubtypeName.containsKey(subtypeName)) {
                                            int subtypeSpecificCodedValueDomainEAID = (Integer)subtypeSpecificCodedValueDomainEAIDBySubtypeName.get(subtypeName);
                                            Element subtypeSpecificCodedValueDomain = rep.GetElementByID(subtypeSpecificCodedValueDomainEAID);
                                            eaTypeForSubtypeField = subtypeSpecificCodedValueDomain.GetName();
                                            eaClassifierIdForSubtypeField = subtypeSpecificCodedValueDomainEAID;
                                        }
                                        Attribute subtypeEAAtt = this.createField(subtypeEAElement, normalizedPiName, normalizedPiAlias, derivedDocumentation, eaTypeForSubtypeField, "" + length, "" + precision, "" + scale, eaClassifierIdForSubtypeField, subtypeInitialValue, isNullable);
                                        try {
                                            this.addTaggedValuesToRepresent(subtypeEAAtt, (Info)pi);
                                        }
                                        catch (EAException e) {
                                            this.result.addError(this, 251, pi.name(), e.getMessage());
                                        }
                                    }
                                }
                            }
                            eaAtt = this.createField(eaClass, normalizedPiName, normalizedPiAlias, derivedDocumentation, eaTypeForNonSubtypeField, "" + length, "" + precision, "" + scale, eaClassifierIdForNonSubtypeField, initialValue, isNullable);
                        }
                        catch (EAException e) {
                            this.result.addError(this, 10003, pi.name(), ci.name(), e.getMessage());
                        }
                    }
                } else if (pi.categoryOfValue() == 8) {
                    this.result.addWarning(this, 214, pi.name(), ci.name());
                } else if (pi.categoryOfValue() == 5) {
                    this.result.addWarning(this, 215, pi.name(), ci.name());
                } else {
                    this.result.addError(this, 217, pi.name(), "" + pi.categoryOfValue(), ci.name());
                }
                if (eaAtt == null) continue;
                try {
                    this.addTaggedValuesToRepresent(eaAtt, (Info)pi);
                }
                catch (EAException e) {
                    this.result.addError(this, 251, pi.name(), e.getMessage());
                }
                if (!pi.matches("rule-arcgis-prop-attIndex") || !"true".equalsIgnoreCase(pi.taggedValue("sqlUnique"))) continue;
                this.createAttributeIndex(eaClass, ci, eaAtt, pi);
            }
        }
        for (PropertyInfo pi : pisToCreateRelationshipClassesWith) {
            if (pi.cardinality().maxOccurs > 1) {
                this.createManyToManyRelationshipClass(pi);
                continue;
            }
            this.createOneToManyRelationshipClass(pi);
        }
        for (AssociationInfo ai : associations) {
            PropertyInfo end1 = ai.end1();
            int end1CiCat = end1.inClass().category();
            PropertyInfo end2 = ai.end2();
            int end2CiCat = end2.inClass().category();
            if (end1CiCat != 1 && end1CiCat != 6 && end1CiCat != 6 && end2CiCat != 1 && end2CiCat != 6 && end2CiCat != 6) {
                this.result.addDebug(this, 223, end1.inClass().name(), end2.inClass().name());
                continue;
            }
            if (end1.inClass().id().equals(end2.inClass().id())) {
                if (end1.matches("rule-arcgis-prop-reflexiveRelationshipAsField")) {
                    ClassInfo ci = end1.inClass();
                    int eaElementId = (Integer)elementIdByClassInfo.get(ci);
                    Element eaClass = rep.GetElementByID(eaElementId);
                    if (end1.isNavigable()) {
                        try {
                            this.createFieldForReflexiveRelationshipProperty(eaClass, end1);
                        }
                        catch (EAException e) {
                            this.result.addError(this, 10005, end1.name(), ci.name(), e.getMessage());
                        }
                    }
                    if (!end2.isNavigable()) continue;
                    try {
                        this.createFieldForReflexiveRelationshipProperty(eaClass, end2);
                    }
                    catch (EAException e) {
                        this.result.addError(this, 10005, end2.name(), ci.name(), e.getMessage());
                    }
                    continue;
                }
                this.result.addWarning(this, 235, end1.inClass().name());
                continue;
            }
            if (!model.isInSelectedSchemas(end1.inClass()) || !model.isInSelectedSchemas(end2.inClass())) {
                this.result.addDebug(this, 224, end1.inClass().name(), end2.inClass().name());
                continue;
            }
            if (end1.isNavigable() && end1.cardinality().maxOccurs == 1 || end2.isNavigable() && end2.cardinality().maxOccurs == 1) {
                this.createOneToManyRelationshipClass(ai);
                continue;
            }
            this.createManyToManyRelationshipClass(end1, end2);
        }
        this.postprocess();
        EARepositoryUtil.closeRepository(rep);
    }

    private void postprocess() {
        this.result.addInfo(this, 30000);
        if (!elementIdByClassInfo.isEmpty() && elementIdByClassInfo.keySet().iterator().next().matches("rule-arcgis-all-postprocess-removeUnusedCodedValueDomains")) {
            this.result.addInfo(this, 30001);
            for (Integer elementIDOfUnusedCodedValueDomain : elementIdsOfUnusedCodedValueDomain) {
                Element elmtToRemove = rep.GetElementByID(elementIDOfUnusedCodedValueDomain.intValue());
                int pkgId = elmtToRemove.GetPackageID();
                Package pkg = rep.GetPackageByID(pkgId);
                this.result.addInfo(this, 272, elmtToRemove.GetName());
                EAPackageUtil.deleteElement(pkg, elementIDOfUnusedCodedValueDomain);
            }
        }
        if (!elementIdByClassInfo.isEmpty() && elementIdByClassInfo.keySet().iterator().next().matches("rule-arcgis-all-subtypes")) {
            this.result.addInfo(this, 30002);
            for (ClassInfo ci : elementIdByClassInfo.keySet()) {
                if (!ArcGISUtil.hasArcGISSubtype(ci)) continue;
                Element parentElement = rep.GetElementByID(((Integer)elementIdByClassInfo.get(ci)).intValue());
                TreeMap<String, Element> subtypeElementByName = new TreeMap<String, Element>();
                for (String subtypeId : ci.subtypes()) {
                    ClassInfo subtype = ci.model().classById(subtypeId);
                    Element subtypeElement = rep.GetElementByID(((Integer)elementIdByClassInfo.get(subtype)).intValue());
                    subtypeElementByName.put(subtype.name(), subtypeElement);
                }
                Collection parentAtts = parentElement.GetAttributes();
                for (short i = 0; i < parentAtts.GetCount(); i = (short)(i + 1)) {
                    Attribute parentAtt = (Attribute)parentAtts.GetAt(i);
                    String parentAttName = parentAtt.GetName();
                    if (!parentAtt.GetStereotype().equals("Field")) continue;
                    SortedMap<String, EATaggedValue> parentAttTVs = EAAttributeUtil.getEATaggedValuesWithCombinedKeys(parentAtt);
                    int parentLength = 0;
                    String tvKey = "Length#ArcGIS::Field::Length";
                    if (parentAttTVs.containsKey(tvKey)) {
                        parentLength = Integer.parseInt(((EATaggedValue)parentAttTVs.get(tvKey)).getValues().get(0));
                    }
                    int parentPrecision = 0;
                    tvKey = "Precision#ArcGIS::Field::Precision";
                    if (parentAttTVs.containsKey(tvKey)) {
                        parentPrecision = Integer.parseInt(((EATaggedValue)parentAttTVs.get(tvKey)).getValues().get(0));
                    }
                    int parentScale = 0;
                    tvKey = "Scale#ArcGIS::Field::Scale";
                    if (parentAttTVs.containsKey(tvKey)) {
                        parentScale = Integer.parseInt(((EATaggedValue)parentAttTVs.get(tvKey)).getValues().get(0));
                    }
                    boolean parentIsNullable = false;
                    tvKey = "IsNullable#ArcGIS::Field::IsNullable";
                    if (parentAttTVs.containsKey(tvKey)) {
                        parentIsNullable = Boolean.parseBoolean(((EATaggedValue)parentAttTVs.get(tvKey)).getValues().get(0));
                    }
                    boolean lengthChange = false;
                    boolean scaleChange = false;
                    boolean precisionChange = false;
                    boolean isNullableChange = false;
                    int maxLengthFromSubtypes = 0;
                    int maxPrecisionFromSubtypes = 0;
                    int maxScaleFromSubtypes = 0;
                    boolean isNullableFromSubtypes = false;
                    for (Map.Entry e : subtypeElementByName.entrySet()) {
                        boolean subtypeIsNullable;
                        int subtypeScale;
                        int subtypePrecision;
                        int subtypeLength;
                        Element subtypeElement = (Element)e.getValue();
                        Attribute subtypeAtt = EAElementUtil.getAttributeByName(subtypeElement, parentAttName);
                        if (subtypeAtt == null) continue;
                        SortedMap<String, EATaggedValue> subtypeAttTVs = EAAttributeUtil.getEATaggedValuesWithCombinedKeys(subtypeAtt);
                        if (subtypeAttTVs.containsKey(tvKey = "Length#ArcGIS::Field::Length") && parentLength != (subtypeLength = Integer.parseInt(((EATaggedValue)subtypeAttTVs.get(tvKey)).getValues().get(0)))) {
                            lengthChange = true;
                            if (subtypeLength > maxLengthFromSubtypes) {
                                maxLengthFromSubtypes = subtypeLength;
                            }
                        }
                        if (subtypeAttTVs.containsKey(tvKey = "Precision#ArcGIS::Field::Precision") && parentPrecision != (subtypePrecision = Integer.parseInt(((EATaggedValue)subtypeAttTVs.get(tvKey)).getValues().get(0)))) {
                            precisionChange = true;
                            if (subtypePrecision > maxPrecisionFromSubtypes) {
                                maxPrecisionFromSubtypes = subtypePrecision;
                            }
                        }
                        if (subtypeAttTVs.containsKey(tvKey = "Scale#ArcGIS::Field::Scale") && parentScale != (subtypeScale = Integer.parseInt(((EATaggedValue)subtypeAttTVs.get(tvKey)).getValues().get(0)))) {
                            scaleChange = true;
                            if (subtypeScale > maxScaleFromSubtypes) {
                                maxScaleFromSubtypes = subtypeScale;
                            }
                        }
                        if (!subtypeAttTVs.containsKey(tvKey = "IsNullable#ArcGIS::Field::IsNullable") || parentIsNullable == (subtypeIsNullable = Boolean.parseBoolean(((EATaggedValue)subtypeAttTVs.get(tvKey)).getValues().get(0)))) continue;
                        isNullableChange = true;
                        if (!subtypeIsNullable) continue;
                        isNullableFromSubtypes = true;
                    }
                    String parentName = ci.name();
                    String fieldToUpdate = parentAttName;
                    String tagToUpdate = "";
                    String fqNameOfTag = "";
                    Object newValue = "";
                    try {
                        if (lengthChange) {
                            tagToUpdate = "Length";
                            fqNameOfTag = "ArcGIS::Field::Length";
                            newValue = maxLengthFromSubtypes == 0 && parentLength > 0 && parentLength < 255 ? "" + parentLength : "" + maxLengthFromSubtypes;
                            this.updateFieldInArcGISParentAndSubtypes(fieldToUpdate, tagToUpdate, fqNameOfTag, (String)newValue, parentName, parentAtt, subtypeElementByName);
                        }
                        if (precisionChange) {
                            tagToUpdate = "Precision";
                            fqNameOfTag = "ArcGIS::Field::Precision";
                            newValue = "" + maxPrecisionFromSubtypes;
                            this.updateFieldInArcGISParentAndSubtypes(fieldToUpdate, tagToUpdate, fqNameOfTag, (String)newValue, parentName, parentAtt, subtypeElementByName);
                        }
                        if (scaleChange) {
                            tagToUpdate = "Scale";
                            fqNameOfTag = "ArcGIS::Field::Scale";
                            newValue = "" + maxScaleFromSubtypes;
                            this.updateFieldInArcGISParentAndSubtypes(fieldToUpdate, tagToUpdate, fqNameOfTag, (String)newValue, parentName, parentAtt, subtypeElementByName);
                        }
                        if (!isNullableChange) continue;
                        tagToUpdate = "IsNullable";
                        fqNameOfTag = "ArcGIS::Field::IsNullable";
                        newValue = isNullableFromSubtypes ? "true" : "false";
                        this.updateFieldInArcGISParentAndSubtypes(fieldToUpdate, tagToUpdate, fqNameOfTag, (String)newValue, parentName, parentAtt, subtypeElementByName);
                        continue;
                    }
                    catch (EAException e1) {
                        this.result.addError(this, 10007, tagToUpdate, fieldToUpdate, parentName, e1.getMessage());
                    }
                }
            }
        }
    }

    private void updateFieldInArcGISParentAndSubtypes(String fieldToUpdate, String tagToUpdate, String fqNameOfTag, String newValue, String parentName, Attribute parentAtt, SortedMap<String, Element> subtypeElementByName) throws EAException {
        this.result.addInfo(this, 270, parentName, tagToUpdate, fieldToUpdate);
        String parentAttTagValue = EAAttributeUtil.taggedValue(parentAtt, tagToUpdate);
        if (!newValue.equals(parentAttTagValue)) {
            this.result.addInfo(this, 271, parentName, tagToUpdate, fieldToUpdate, newValue);
            EAAttributeUtil.updateTaggedValue(parentAtt, fqNameOfTag, newValue, false);
        }
        this.updateFieldTaggedValueOfArcGISSubtypes(subtypeElementByName, fieldToUpdate, tagToUpdate, fqNameOfTag, newValue);
    }

    private void updateFieldTaggedValueOfArcGISSubtypes(SortedMap<String, Element> subtypeElementByName, String attName, String tvName, String fqNameOfTag, String tvValue) throws EAException {
        for (Map.Entry<String, Element> e : subtypeElementByName.entrySet()) {
            String subtypeAttTagValue;
            Element subtypeElement = e.getValue();
            Attribute subtypeAtt = EAElementUtil.getAttributeByName(subtypeElement, attName);
            if (subtypeAtt == null || tvValue.equals(subtypeAttTagValue = EAAttributeUtil.taggedValue(subtypeAtt, tvName))) continue;
            String subtypeName = e.getKey();
            this.result.addInfo(this, 269, subtypeName, attName, tvName, tvValue);
            EAAttributeUtil.updateTaggedValue(subtypeAtt, fqNameOfTag, tvValue, false);
        }
    }

    private SortedMap<String, String> parseArcGISSubtypeInitialValues(String arcgisSubtypeInitialValues, PropertyInfo pi) {
        String[] subtypeInitialValueDefinitions_escaped;
        TreeMap<String, String> initialValuesBySubtypeName = new TreeMap<String, String>();
        for (String s : subtypeInitialValueDefinitions_escaped = arcgisSubtypeInitialValues == null ? new String[]{} : arcgisSubtypeInitialValues.split(REGEX_TO_SPLIT_BY_COMMA_WITH_ESCAPING)) {
            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
            String[] subtypeInitialValueDefinitionParts_escaped = s.split(REGEX_TO_SPLIT_BY_COLON_WITH_ESCAPING);
            if (subtypeInitialValueDefinitionParts_escaped.length != 2) {
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 263, pi.name());
                if (mc != null) {
                    mc.addDetail(this, -2, pi.fullNameInSchema());
                }
                return new TreeMap<String, String>();
            }
            String subtypeName_escaped = subtypeInitialValueDefinitionParts_escaped[0];
            String subtypeInitialValue_escaped = subtypeInitialValueDefinitionParts_escaped[1];
            if (StringUtils.isBlank((CharSequence)subtypeName_escaped) || StringUtils.isBlank((CharSequence)subtypeInitialValue_escaped)) {
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 263, pi.name());
                if (mc != null) {
                    mc.addDetail(this, -2, pi.fullNameInSchema());
                }
                return new TreeMap<String, String>();
            }
            String unescapedSubtypeName = subtypeName_escaped.replace("\\,", ",").replace("\\:", ":").replace("\\\\", "\\");
            String unescapedInitialValue = subtypeInitialValue_escaped.replace("\\,", ",").replace("\\:", ":").replace("\\\\", "\\");
            initialValuesBySubtypeName.put(unescapedSubtypeName, unescapedInitialValue);
        }
        return initialValuesBySubtypeName;
    }

    private Element determineNumericRange(ClassInfo ci, PropertyInfo pi, ProcessMapEntry pme) {
        Element numericRange = null;
        Set originalPropertyNames = ((SortedMap)numericRangeConstraintByPropNameByClassName.get(ci)).keySet();
        for (String origPropName : originalPropertyNames) {
            if (!pi.name().startsWith(origPropName) && (pi.aliasName() == null || !pi.aliasName().startsWith(origPropName))) continue;
            String rangeDomainName = ci.name() + "_" + origPropName + "_NumRange";
            if (numericRangeElementIdsByClassName.containsKey(rangeDomainName)) {
                int numRangeElementId = (Integer)numericRangeElementIdsByClassName.get(rangeDomainName);
                numericRange = rep.GetElementByID(numRangeElementId);
                break;
            }
            NumericRangeConstraintMetadata nrcm = (NumericRangeConstraintMetadata)((SortedMap)numericRangeConstraintByPropNameByClassName.get(ci)).get(origPropName);
            double minValue = ArcGISWorkspaceConstants.DEFAULT_NUM_RANGE_MIN_LOWER_BOUNDARY;
            double maxValue = ArcGISWorkspaceConstants.DEFAULT_NUM_RANGE_MAX_UPPER_BOUNDARY;
            if (nrcm.hasLowerBoundaryValue()) {
                minValue = nrcm.isLowerBoundaryInclusive() ? nrcm.getLowerBoundaryValue() : nrcm.getLowerBoundaryValue() + numRangeDelta;
            }
            if (nrcm.hasUpperBoundaryValue()) {
                maxValue = nrcm.isUpperBoundaryInclusive() ? nrcm.getUpperBoundaryValue() : nrcm.getUpperBoundaryValue() - numRangeDelta;
            }
            try {
                Element rd = this.createRangeDomain(rangeDomainName, null, pme.getTargetType(), ci);
                EAElementUtil.createEAAttribute(rd, "MinValue", null, null, null, null, false, false, false, this.doubleToString(minValue), false, new Multiplicity(1, 1), null, null);
                EAElementUtil.createEAAttribute(rd, "MaxValue", null, null, null, null, false, false, false, this.doubleToString(maxValue), false, new Multiplicity(1, 1), null, null);
                numericRange = rd;
            }
            catch (EAException e) {
                this.result.addError(this, 230, rangeDomainName, e.getMessage());
                numericRange = null;
            }
            break;
        }
        return numericRange;
    }

    private void addTaggedValuesToRepresent(Attribute eaAtt, Info i) throws EAException {
        if (representTaggedValues) {
            for (String tvToRepresent : taggedValuesToRepresent) {
                String normalizedTag = this.options.normalizeTag(tvToRepresent);
                String[] values = i.taggedValuesForTag(normalizedTag);
                if (values.length <= 0) continue;
                EAAttributeUtil.setTaggedValue(eaAtt, new EATaggedValue(tvToRepresent, Arrays.asList(values)));
            }
        }
    }

    private void addTaggedValuesToRepresent(ConnectorEnd ce, Info i) throws EAException {
        if (representTaggedValues) {
            for (String tvToRepresent : taggedValuesToRepresent) {
                String normalizedTag = this.options.normalizeTag(tvToRepresent);
                String[] values = i.taggedValuesForTag(normalizedTag);
                if (values.length <= 0) continue;
                EAConnectorEndUtil.setTaggedValue(ce, new EATaggedValue(tvToRepresent, Arrays.asList(values)));
            }
        }
    }

    private void addTaggedValuesToRepresent(Connector con, Info i) throws EAException {
        if (representTaggedValues) {
            for (String tvToRepresent : taggedValuesToRepresent) {
                String normalizedTag = this.options.normalizeTag(tvToRepresent);
                String[] values = i.taggedValuesForTag(normalizedTag);
                if (values.length <= 0) continue;
                EAConnectorUtil.setTaggedValue(con, new EATaggedValue(tvToRepresent, Arrays.asList(values)));
            }
        }
    }

    private void addTaggedValuesToRepresent(Element e, Info i) throws EAException {
        if (representTaggedValues) {
            for (String tvToRepresent : taggedValuesToRepresent) {
                String normalizedTag = this.options.normalizeTag(tvToRepresent);
                String[] values = i.taggedValuesForTag(normalizedTag);
                if (values.length <= 0) continue;
                EAElementUtil.setTaggedValue(e, new EATaggedValue(tvToRepresent, Arrays.asList(values)));
            }
        }
    }

    private Attribute createFieldForReflexiveRelationshipProperty(Element eaClass, PropertyInfo pi) throws EAException {
        String normalizedName;
        ClassInfo ci = pi.inClass();
        if (pi.cardinality().maxOccurs > 1) {
            this.result.addWarning(this, 249, pi.name(), ci.name());
        }
        if (this.exceedsMaxLength(normalizedName = this.normalizeName(pi.name() + reflexiveRelationshipAttributeSuffix))) {
            this.result.addWarning(this, 205, normalizedName, pi.name(), ci.name(), "" + maxNameLength);
            normalizedName = this.clipToMaxLength(normalizedName);
        }
        String normalizedAlias = pi.aliasName() == null ? null : this.normalizeAlias(pi.aliasName(), ci);
        String documentation = pi.derivedDocumentation(documentationTemplate, documentationNoValue);
        return this.createForeignKeyField(eaClass, normalizedName, normalizedAlias, documentation, ci);
    }

    private Attribute createForeignKeyField(Element eaClass, String normalizedName, String normalizedAlias, String documentation, ClassInfo targetType) throws EAException {
        String refType;
        String primaryKeyAttGUID = this.determinePrimaryKeyGUID(targetType);
        Attribute primaryKeyAtt = rep.GetAttributeByGuid(primaryKeyAttGUID);
        String primaryKeyType = primaryKeyAtt.GetType();
        String length = StringUtils.stripToEmpty((String)EAAttributeUtil.taggedValue(primaryKeyAtt, "Length"));
        String precision = StringUtils.stripToEmpty((String)EAAttributeUtil.taggedValue(primaryKeyAtt, "Precision"));
        String scale = StringUtils.stripToEmpty((String)EAAttributeUtil.taggedValue(primaryKeyAtt, "Scale"));
        if (primaryKeyType.equalsIgnoreCase("esriFieldTypeOID")) {
            refType = "esriFieldTypeInteger";
            length = "0";
            precision = "9";
            scale = "0";
        } else {
            refType = primaryKeyType.equalsIgnoreCase("esriFieldTypeGlobalID") ? "esriFieldTypeGUID" : primaryKeyType;
        }
        return this.createField(eaClass, normalizedName, normalizedAlias, documentation, refType, length, precision, scale, null, null, true);
    }

    private void createAttributeIndex(Element eaClass, ClassInfo ci, Attribute eaAtt, PropertyInfo pi) {
        try {
            ArrayList<EATaggedValue> tvs = new ArrayList<EATaggedValue>();
            tvs.add(new EATaggedValue("IsUnique", "ArcGIS::AttributeIndex::IsUnique", "true"));
            tvs.add(new EATaggedValue("IsAscending", "ArcGIS::AttributeIndex::IsAscending", "true"));
            tvs.add(new EATaggedValue("Fields", "ArcGIS::AttributeIndex::Fields", eaAtt.GetAttributeGUID()));
            TreeSet<String> stereotypes = new TreeSet<String>();
            stereotypes.add("ArcGIS::AttributeIndex");
            EAElementUtil.createEAAttribute(eaClass, eaClass.GetName() + "_" + eaAtt.GetName() + "_IDX", null, null, stereotypes, tvs, false, false, false, null, false, new Multiplicity(1, 1), "", null);
        }
        catch (EAException e) {
            this.result.addError(this, 10004, pi.name(), ci.name(), e.getMessage());
        }
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
        r.addRule("rule-arcgis-all-postprocess-removeUnusedCodedValueDomains");
        r.addRule("rule-arcgis-all-precision");
        r.addRule("rule-arcgis-all-relationshipClassNameByTaggedValueOfClasses");
        r.addRule("rule-arcgis-all-representTaggedValues");
        r.addRule("rule-arcgis-all-scale");
        r.addRule("rule-arcgis-all-subtypes");
        r.addRule("rule-arcgis-cls-hasM");
        r.addRule("rule-arcgis-cls-hasZ");
        r.addRule("rule-arcgis-cls-identifierStereotype");
        r.addRule("rule-arcgis-cls-rangeDomainFromTaggedValues");
        r.addRule("rule-arcgis-prop-attIndex");
        r.addRule("rule-arcgis-prop-initialValue");
        r.addRule("rule-arcgis-prop-initialValueByAlias");
        r.addRule("rule-arcgis-prop-isNullable");
        r.addRule("rule-arcgis-prop-lengthFromCodesOrEnumsOfValueType");
        r.addRule("rule-arcgis-prop-lengthFromTaggedValue");
        r.addRule("rule-arcgis-prop-lengthFromTaggedValueForCodelistOrEnumerationValueType");
        r.addRule("rule-arcgis-prop-precision");
        r.addRule("rule-arcgis-prop-reflexiveRelationshipAsField");
        r.addRule("rule-arcgis-prop-scale");
    }

    @Override
    public String getTargetIdentifier() {
        return "arcgis";
    }

    @Override
    public String getDefaultEncodingRule() {
        return "*";
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case -2: {
                return "Context: property '$1$'";
            }
            case -1: {
                return "Context: class '$1$'";
            }
            case 0: {
                return "Context: class ArcGISWorkspace";
            }
            case 1: {
                return "Directory named '$1$' does not exist or is not accessible.";
            }
            case 2: {
                return "Output file '$1$' already exists in output directory ('$2$'). It will be deleted prior to processing.";
            }
            case 3: {
                return "File has been deleted.";
            }
            case 4: {
                return "File could not be deleted. Exception message: '$1$'.";
            }
            case 5: {
                return "Could not create output directory. Exception message: '$1$'.";
            }
            case 6: {
                return "URL '$1$' provided for configuration parameter workspaceTemplate is malformed. Execution will be aborted. Exception message is: '$2$'.";
            }
            case 7: {
                return "EAP with ArcGIS workspace template at '$1$' does not exist or cannot be read. Check the value of the configuration parameter 'workspaceTemplate' and ensure that: a) it contains the path to the template file and b) the file can be read by ShapeChange.";
            }
            case 8: {
                return "Exception encountered when copying ArcGIS workspace template EAP file to output destination. Message is: $1$.";
            }
            case 9: {
                return "No value provided for configuration parameter '$1$', defaulting to: '$2$'.";
            }
            case 10: {
                return "Encountered package '$1$' (child of package '$2$') which is an application schema. The package will be ignored.";
            }
            case 11: {
                return "Target configuration map entry for type '$1$' does not have a target type. The map entry will be ignored.";
            }
            case 12: {
                return "Value of configuration parameter 'valueRangeExcludedBoundaryDelta' could not be parsed as a double value. The default value of 0.01 will be used for processing.";
            }
            case 13: {
                return "Value of configuration parameter '$1$' could not be parsed as an integer value. The default value of '$2$' will be used for processing.";
            }
            case 101: {
                return "Invalid ArcGIS workspace template: expected package with stereotype <<ArcGIS>> as child of root package.";
            }
            case 102: {
                return "Invalid ArcGIS workspace template: could not find required package '$1$'.";
            }
            case 201: {
                return "Class '$1$' will be ignored.";
            }
            case 202: {
                return "Unknown subtype encountered for class '$1$' - ID of subtype is '$2$'.";
            }
            case 203: {
                return "Different ArcGIS geometry types encountered in supertypes of class '$1$'. Geometry type will be determined based upon first occurrence of supertype with geometry type that is not 'unknown' (or 'unknown' will be used if no such supertype exists).";
            }
            case 204: {
                return "Could not set abstract on class '$1$'. Exception message is: '$2$'.";
            }
            case 205: {
                return "Length of normalized name '$1$' (original name is '$2$') of property in class '$3$' or of the class itself exceeds maximum length restriction (which is $4$ characters). The name will be clipped to fit the maximum length.";
            }
            case 206: {
                return "Unknown supertype encountered for class '$1$' - ID of supertype is '$2$'.";
            }
            case 207: {
                return "Generalisation '$1$' - '$2$' not set because the first class is not part of the target model.";
            }
            case 208: {
                return "Generalisation '$1$' - '$2$' not set because the second class is not part of the target model.";
            }
            case 209: {
                return "Processing class with category $1$ is not supported. Class '$2$' will be ignored.";
            }
            case 210: {
                return "Class '$1$' has geometry property of unknown type. The class will be ignored.";
            }
            case 211: {
                return "Class '$1$' has multiple geometry properties. All but one will be ignored.";
            }
            case 212: {
                return "Property '$1$' of class '$2$' has max occurrence > 1. The property will be ignored.";
            }
            case 213: {
                return "Property '$1$' of class '$2$' is of a geometry type. The property will be ignored.";
            }
            case 214: {
                return "Property '$1$' of class '$2$' is of a <<union>> type. The property will be ignored.";
            }
            case 215: {
                return "Property '$1$' of class '$2$' is of a <<dataType>> type. The property will be ignored.";
            }
            case 216: {
                return "Class '$1$' is the type of property '$2$' (from class '$3$') but was not found in the model. A proper link to '$1$' cannot be set.";
            }
            case 217: {
                return "Unrecognized case of property conversion. Context is property '$1$' (category of value is '$2$') in class '$3$'.";
            }
            case 218: {
                return "Cannot establish a <<RelationshipClass>> association for property '$1$' in class '$2$' to class '$3$' (which is the type of the property) because that class is not part of the application schema.";
            }
            case 219: {
                return "Subtype with id '$1$' of type '$2$' not found in the model. Cannot create a <<RelationshipClass>> association for this subtype.";
            }
            case 220: {
                return "Subtype '$1$' of type '$2$' is not part of the application schema. Cannot create a <<RelationshipClass>> association for this subtype.";
            }
            case 221: {
                return "Could not properly establish <<RelationshipClass>> association between classes '$1$' and '$2$' due to an EA exception. Error message is: $3$";
            }
            case 222: {
                return "Type '$1$' of property '$2$' in class '$3$' does not belong to the application schema. The property will be ignored.";
            }
            case 223: {
                return "Association between classes '$1$' and '$2$' will be ignored because at least one of the two classes is not a feature or object type.";
            }
            case 224: {
                return "Association between classes '$1$' and '$2$' will be ignored because at least one of the two classes is not contained in the application schema.";
            }
            case 225: {
                return "Cannot create association between classes '$1$' and '$2$' because at least one of them has not been established in the ArcGIS workspace (the reason could be that the class is not part of the application schema).";
            }
            case 226: {
                return "Length of normalized name '$1$' for new association class (as well as the according relationship class) exceeds maximum length restriction (which is $2$ characters). The name will be clipped to fit the maximum length.";
            }
            case 227: {
                return "Length of normalized name '$1$' for foreign key field in new association class exceeds maximum length restriction (which is $2$ characters). The name will be clipped to fit the maximum length.";
            }
            case 228: {
                return "Detected numeric range constraint in class '$1$' but could not find the property name in it. OCL is: $2$";
            }
            case 229: {
                return "Detected numeric range constraint for property named '$1$' in class '$2$' but could not actually find the property in that class. The property name has been parsed from the OCL text, which is: $3$";
            }
            case 230: {
                return "Could not create <<RangeDomain>> with name '$1$' due to an EA exception: $2$";
            }
            case 231: {
                return "Could not parse lower boundary value '$1$' in numeric range constraint to a double value. Class that contains the constraint is: '$2$'. Constraint name is: '$3$'. OCL is: $4$.";
            }
            case 232: {
                return "Could not parse upper boundary value '$1$' in numeric range constraint to a double value. Class that contains the constraint is: '$2$'. Constraint name is: '$3$'. OCL is: $4$.";
            }
            case 233: {
                return "Association between class '$1$' (which is the inClass for property '$2$') and class '$3$' (which is the type of the property) will be ignored because class '$3$' is not contained in the application schema.";
            }
            case 234: {
                return "Length of normalized name '$1$' for new relationship class exceeds maximum length restriction (which is $2$ characters). The name will be clipped to fit the maximum length.";
            }
            case 235: {
                return "No conversion rule is configured to handle the reflexive association found on class '$1$'. The association will be ignored.";
            }
            case 236: {
                return "No conversion rule is configured to handle the reflexive relationship found on class '$1$', property '$2$'. The property will be ignored.";
            }
            case 237: {
                return "Cannot create one to many relationship between classes '$1$' and '$2$' because class '$3$' has not been established in the ArcGIS workspace (the reason could be that the class is not part of the application schema).";
            }
            case 238: {
                return "One to many relationship between classes '$1$' and '$2$' is incomplete. Could not create relationship between '$3$' and '$4$' because class '$3$' has not been established in the ArcGIS workspace (the reason could be that the class is not part of the application schema).";
            }
            case 239: {
                return "Many to many relationship between classes '$1$' and '$2$' is incomplete. Could not create relationship between '$3$' and '$4$' because class '$3$' has not been established in the ArcGIS workspace (the reason could be that the class is not part of the application schema).";
            }
            case 240: {
                return "Type '$1$' has been mapped to '$2$', as defined by the configuration.";
            }
            case 241: {
                return "Could not parse lower boundary value '$1$' in tagged value '$2$' to a double value. The tagged value will be ignored.";
            }
            case 242: {
                return "Could not parse upper boundary value '$1$' in tagged value '$2$' to a double value. The tagged value will be ignored.";
            }
            case 243: {
                return "Could not parse value '$1$' of tagged value '$2$' to an integer value. The tagged value will be ignored.";
            }
            case 244: {
                return "Could not find the code list or enumeration that is the value type '$1$' of property '$2$' in the model. The length can therefore not be computed from the codes/enums.";
            }
            case 245: {
                return "Tagged value 'numericType' is not blank. It has value '$1$'. No map entry was found with this value as type. The tagged value will be ignored.";
            }
            case 246: {
                return "Multiple attributes with stereotype <<identifier>> found for class '$1$'. The first - arbitrary one - will be used as primary key in relationship classes.";
            }
            case 247: {
                return "Identifier attribute '$1$' has max multiplicity > 1.";
            }
            case 248: {
                return "Class '$1$' does not have an <<identifier>> attribute.";
            }
            case 249: {
                return "Reflexive relationship property '$1$' of class '$2$' has max cardinality > 1. The <<Field>> that is created for the property will only support representation of a single relationship.";
            }
            case 250: {
                return "Could not add tagged values to represent on class '$1$'. Exception message is: '$2$'.";
            }
            case 251: {
                return "Could not add tagged values to represent on property '$1$'. Exception message is: '$2$'.";
            }
            case 252: {
                return "Class '$1$' is an ArcGIS Subtype. Therefore, it must define tagged value 'arcgisSubtypeCode' with an integer that uniquely identifies the subtype amongst the other children of its parent. The tagged value is undefined or empty. Using subtype code -1.";
            }
            case 253: {
                return "Class '$1$' is an ArcGIS Subtype. Value '$2$' of tag 'arcgisSubtypeCode' cannot be parsed to an integer. Using subtype code -1.";
            }
            case 254: {
                return "Enumeration '$1$' defines a set of subtypes. This enumeration will not be encoded as a coded value domain.";
            }
            case 255: {
                return "Code list '$1$' defines a set of subtypes. This code list will not be encoded as a coded value domain.";
            }
            case 256: {
                return "Value '$1$' of tag 'arcgisDefaultSubtype' cannot be parsed to an integer. Using subtype code -1.";
            }
            case 257: {
                return "Class '$1$' is supposed to define a set of subtypes, but actually has no properties.";
            }
            case 258: {
                return "Property '$1$' of class '$2$' defines an ArcGIS Subtype. Therefore, it must have tagged value 'arcgisSubtypeCode' with an integer that uniquely identifies the subtype. The tagged value is undefined or empty. Ignoring this subtype.";
            }
            case 259: {
                return "Property '$1$' of class '$2$' defines an ArcGIS Subtype. Value '$3$' of tag 'arcgisSubtypeCode' cannot be parsed to an integer. Ignoring this subtype.";
            }
            case 260: {
                return "Duplicate subtype code '$1$' detected in properties of class '$2$' which defines a set of ArcGIS Subtypes. Subtype '$3$' will be ignored.";
            }
            case 261: {
                return "Class '$1$' is the parent of ArcGIS subtypes. Its property '$2$' has a codelist or enumeration as type, whose name is '$3$'. That type was not found in the model. Consequently, it is not possible to check if the codes/enums only apply to specific subtypes.";
            }
            case 262: {
                return "Length of normalized name '$1$' (full name would be '$2$') of coded value domain for subtype '$3$' exceeds maximum length restriction (which is $4$ characters). The name will be clipped to fit the maximum length.";
            }
            case 263: {
                return "??Invalid format of tagged value 'arcgisSubtypeInitialValues' of property '$1$'. The tagged value will be ignored. Ensure that the tagged value contains a comma-separated list of key-value pairs (with subtype name as key, initial value as value, and colon as separator).";
            }
            case 264: {
                return "??Tagged value 'arcgisSubtypeInitialValues' of property '$1$' contains subtype '$2$', which was not found in the set of subtypes defined for class '$3$'. The subtype will be ignored.";
            }
            case 265: {
                return "Class '$1$' is an explicitly modelled ArcGIS subtype of class '$2$'. '$1$' defines property '$3$', but '$2$' does not. This is not allowed. An ArcGIS subtype may only restrict the properties of its supertype. The property will be ignored.";
            }
            case 266: {
                return "Class '$1$' is an explicitly modelled ArcGIS subtype of class '$2$'. '$1$' defines property '$3$', which has a geometry type ('$4$'). This is not allowed. An ArcGIS subtype may not redefine the geometry type of its supertype. The property will be ignored.";
            }
            case 267: {
                return "Class '$1$' is the supertype of a set of explicitly modelled ArcGIS subtypes. Its property '$2$' has non-empty tagged value 'arcgisDefaultSubtype'. However, the type of that property is '$3$' instead of 'Integer'. Integer will be used as type.";
            }
            case 268: {
                return "Class '$1$' has more than one supertype. The target only supports one generalization relationship per subtype.";
            }
            case 269: {
                return "--- Subtype '$1$': setting tag '$2$' of field '$3$' to value '$4$'.";
            }
            case 270: {
                return "Change of '$2$' required for field '$3$' of ArcGIS parent '$1$' and/or (one or more of) its subtypes.";
            }
            case 271: {
                return "--- Parent '$1$': setting tag '$2$' of field '$3$' to value '$4$'.";
            }
            case 272: {
                return "Removing coded value domain '$1$'.";
            }
            case 10001: {
                return "EA exception encountered: $1$";
            }
            case 10002: {
                return "EA exception encountered while creating generalization relationship between classes '$1$' and '$2$': $3$";
            }
            case 10003: {
                return "EA exception encountered while creating <<Field>> attribute for property '$1$' in class '$2$'. The property will be ignored. Error message: $3$";
            }
            case 10004: {
                return "EA exception encountered while creating <<AttributeIndex>> attribute for property '$1$' in class '$2$'. Error message: $3$";
            }
            case 10005: {
                return "EA exception encountered while creating <<Field>> attribute for reflexive relationship property '$1$' in class '$2$'. The property will be ignored. Error message: $3$";
            }
            case 10006: {
                return "EA exception encountered while creating generalization relationship between class '$1$' and its subtype '$2$': $3$";
            }
            case 10007: {
                return "EA exception encountered while updating tag '$1$' in field '$2$' of ArcGIS parent '$3$' and its subtypes. Error message: $4$";
            }
            case 20001: {
                return "Property: $1$";
            }
            case 30000: {
                return "=============== Postprocessing ===============";
            }
            case 30001: {
                return "---------- Removing unused coded value domains  ----------";
            }
            case 30002: {
                return "---------- Aligning field length, scale, precision, isNullable of ArcGIS parent and subtypes  ----------";
            }
        }
        return "(" + ArcGISWorkspace.class.getName() + ") Unknown message with number: " + mnr;
    }

    static {
        eaPkgIdByModelPkg_byWorkspaceSubPkgId = new TreeMap<Integer, SortedMap<PackageInfo, Integer>>();
        processMapEntries = null;
        lengthMappingByTypeName = new TreeMap<String, Integer>();
        precisionMappingByTypeName = new TreeMap<String, Integer>();
        scaleMappingByTypeName = new TreeMap<String, Integer>();
        lengthByClassPropName = new TreeMap<String, Integer>();
        numericRangeConstraintByPropNameByClassName = new TreeMap<ClassInfo, SortedMap<String, NumericRangeConstraintMetadata>>();
        nameOfTVToDetermineFieldLength = "size";
        keepCaseOfRolename = false;
        representTaggedValues = false;
        taggedValuesToRepresent = null;
        numericRangeElementIdsByClassName = new TreeMap<String, Integer>();
    }

    public static enum ArcGISGeometryType {
        POINT("ArcGIS::Point"),
        MULTIPOINT("ArcGIS::Multipoint"),
        POLYLINE("ArcGIS::Polyline"),
        POLYGON("ArcGIS::Polygon"),
        UNKNOWN("Unknown"),
        NONE("None");

        private String stereotype;

        private ArcGISGeometryType(String stereotype) {
            this.stereotype = stereotype;
        }

        public String stereotypeValue() {
            return this.stereotype;
        }
    }
}

