/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.AppConfiguration;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Target;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AppConfiguration
implements Target,
MessageSource {
    public static final String TARGET_IDENTIFIER = "appcfg";
    public static final String NS = "http://www.interactive-instruments.de/ShapeChange/AppConfiguration/0.1";
    public static final String PARAM_ID_COLUMN_NAME = "idColumnName";
    public static final String PARAM_SIZE = "size";
    public static final String DEFAULT_ID_COLUMN_NAME = "_id";
    public static final int DEFAULT_SIZE = 1024;
    public static final String REFERENCE_NAME = "reference";
    private ShapeChangeResult result = null;
    private Model model = null;
    private Options options = null;
    private boolean printed = false;
    private boolean diagnosticsOnly = false;
    private String outputDirectory;
    private String idColumnName;
    private int defaultSize;
    private final HashMap<String, Document> documentMap = new HashMap();

    @Override
    public void initialise(PackageInfo pi, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        String defaultSizeByConfig;
        this.model = m;
        this.options = o;
        this.result = r;
        this.diagnosticsOnly = diagOnly;
        this.result.addDebug(this, 1, pi.name());
        this.outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter("outputDirectory");
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter(".");
        }
        if (!this.diagnosticsOnly) {
            File outputDirectoryFile = new File(this.outputDirectory);
            boolean exi = outputDirectoryFile.exists();
            if (!exi) {
                outputDirectoryFile.mkdirs();
                exi = outputDirectoryFile.exists();
            }
            boolean dir = outputDirectoryFile.isDirectory();
            boolean wrt = outputDirectoryFile.canWrite();
            boolean rea = outputDirectoryFile.canRead();
            if (!(exi && dir && wrt && rea)) {
                this.result.addFatalError(this, 3, this.outputDirectory);
                return;
            }
        }
        this.idColumnName = this.options.parameter(this.getClass().getName(), PARAM_ID_COLUMN_NAME);
        if (this.idColumnName == null) {
            this.idColumnName = DEFAULT_ID_COLUMN_NAME;
        }
        if ((defaultSizeByConfig = this.options.parameter(this.getClass().getName(), PARAM_SIZE)) == null) {
            this.defaultSize = 1024;
        } else {
            try {
                this.defaultSize = Integer.parseInt(defaultSizeByConfig);
            }
            catch (NumberFormatException e) {
                ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 4, PARAM_SIZE, e.getMessage(), "1024");
                mc.addDetail(this, 0);
                this.defaultSize = 1024;
            }
        }
    }

    @Override
    public void process(ClassInfo ci) {
        int cat = ci.category();
        if (cat != 1) {
            return;
        }
        Document doc = this.createDocument();
        Element root = this.createTypeElement(doc, ci);
        doc.appendChild(root);
        this.addAttribute(doc, root, "xmlns:def", NS);
        this.addAttribute(doc, root, "xmlns:xlink", "http://www.w3.org/1999/xlink");
        this.addAttribute(doc, root, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.documentMap.put(ci.name(), doc);
    }

    private Element createTypeElement(Document doc, ClassInfo ci) {
        Element root = doc.createElementNS(NS, "Objektart");
        this.addAttribute(doc, root, "name", this.normalizeName(ci.name()));
        String alias = ci.aliasName();
        if (alias == null) {
            alias = "";
        }
        this.addAttribute(doc, root, "alias", alias);
        Element pE = doc.createElementNS(NS, "Attribut");
        this.addAttribute(doc, pE, "name", this.idColumnName);
        this.addAttribute(doc, pE, "alias", "");
        this.addAttribute(doc, pE, "type", "key");
        root.appendChild(pE);
        if (ci.properties() != null && !ci.properties().isEmpty()) {
            for (PropertyInfo pi : ci.properties().values()) {
                if (!pi.isNavigable()) continue;
                pE = doc.createElementNS(NS, "Attribut");
                root.appendChild(pE);
                this.addAttribute(doc, pE, "name", this.normalizeName(pi.name()));
                alias = pi.aliasName();
                if (alias == null) {
                    alias = "";
                }
                this.addAttribute(doc, pE, "alias", alias);
                String type = this.identifyType(pi);
                this.addAttribute(doc, pE, "type", type);
                if (type.equals(REFERENCE_NAME)) {
                    this.addAttribute(doc, pE, "ref", this.normalizeName(pi.typeInfo().name));
                }
                if (type.equals("text")) {
                    this.addAttribute(doc, pE, PARAM_SIZE, "" + this.getSizeForProperty(pi));
                }
                if (pi.isReadOnly()) {
                    this.addAttribute(doc, pE, "readOnly", "true");
                }
                if (pi.initialValue() != null) {
                    this.addAttribute(doc, pE, "default", pi.initialValue());
                }
                if (type.equals("text") || type.equals("boolean") || pi.categoryOfValue() == 3) {
                    String form = "text";
                    if (type.equals("text") && StringUtils.isNotBlank((CharSequence)pi.taggedValue("formrows"))) {
                        form = "textarea";
                    } else if (type.equals("boolean")) {
                        form = "checkbox";
                    } else if (pi.categoryOfValue() == 3) {
                        form = "select";
                        ClassInfo enumeration = this.model.classById(pi.typeInfo().id);
                        if (enumeration.properties() != null && !enumeration.properties().isEmpty()) {
                            for (PropertyInfo piEnum : enumeration.properties().values()) {
                                Element enumE = doc.createElementNS(NS, "Wert");
                                pE.appendChild(enumE);
                                this.addAttribute(doc, enumE, "name", this.normalizeName(piEnum.name()));
                                alias = piEnum.aliasName();
                                if (alias == null) {
                                    alias = "";
                                }
                                this.addAttribute(doc, enumE, "alias", alias);
                            }
                        }
                    }
                    this.addAttribute(doc, pE, "form", form);
                    if ((form.equals("text") || form.equals("textarea")) && StringUtils.isNotBlank((CharSequence)pi.taggedValue("formcols"))) {
                        this.addAttribute(doc, pE, "formcols", pi.taggedValue("formcols").trim());
                    }
                    if (form.equals("textarea") && StringUtils.isNotBlank((CharSequence)pi.taggedValue("formrows"))) {
                        this.addAttribute(doc, pE, "formrows", pi.taggedValue("formrows").trim());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)pi.taggedValue("validate"))) {
                    this.addAttribute(doc, pE, "validate", pi.taggedValue("validate").trim());
                }
                if (!StringUtils.isNotBlank((CharSequence)pi.taggedValue("Reiter"))) continue;
                this.addAttribute(doc, pE, "tab", pi.taggedValue("Reiter").trim());
            }
        }
        return root;
    }

    private int getSizeForProperty(PropertyInfo pi) {
        String tvSize = pi.taggedValue(PARAM_SIZE);
        int size = this.defaultSize;
        if (StringUtils.isNotBlank((CharSequence)tvSize)) {
            try {
                size = Integer.parseInt(tvSize);
            }
            catch (NumberFormatException e) {
                ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 5, PARAM_SIZE, e.getMessage(), "" + this.defaultSize);
                mc.addDetail(this, 0);
                mc.addDetail(this, 100, pi.name(), pi.inClass().name());
                size = this.defaultSize;
            }
        }
        return size;
    }

    private String identifyType(PropertyInfo pi) {
        String piTypeName = pi.typeInfo().name;
        ProcessMapEntry me = this.options.targetMapEntry(piTypeName, pi.encodingRule("sql"));
        if (me != null && me.hasTargetType()) {
            return me.getTargetType();
        }
        int catOfValue = pi.categoryOfValue();
        if (catOfValue == 3 || catOfValue == 2 || catOfValue == 6) {
            return "text";
        }
        if (catOfValue == 1) {
            return REFERENCE_NAME;
        }
        return "unknown";
    }

    protected void addAttribute(Document document, Element e, String name, String value) {
        Attr att = document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    protected Document createDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(null, 2);
            String m = e.getMessage();
            if (m != null) {
                this.result.addFatalError(m);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            this.result.addFatalError(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        return document;
    }

    private String normalizeName(String name) {
        if (name == null) {
            return null;
        }
        return name.replace(".", "_").replace("-", "_");
    }

    @Override
    public void write() {
        if (this.printed) {
            return;
        }
        if (this.diagnosticsOnly) {
            return;
        }
        Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        outputFormat.setProperty("indent", "yes");
        outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        outputFormat.setProperty("encoding", "UTF-8");
        try {
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            for (String className : this.documentMap.keySet()) {
                Document doc = this.documentMap.get(className);
                if (doc == null) continue;
                FileWriter outputXML = new FileWriter(this.outputDirectory + "/" + className + ".xml");
                serializer.setWriter((Writer)outputXML);
                serializer.asDOMSerializer().serialize((Node)doc);
                outputXML.close();
                this.result.addResult(this.getTargetName(), this.outputDirectory, className + ".xml", null);
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
        this.printed = true;
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
    }

    @Override
    public String getTargetName() {
        return "App Configuration";
    }

    @Override
    public String getDefaultEncodingRule() {
        return "*";
    }

    @Override
    public String getTargetIdentifier() {
        return TARGET_IDENTIFIER;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class AppConfiguration";
            }
            case 1: {
                return "Generating app configuration for application schema '$1$'.";
            }
            case 2: {
                return "Processing class '$1$'.";
            }
            case 3: {
                return "Directory named '$1$' does not exist or is not accessible.";
            }
            case 4: {
                return "Number format exception while converting the value of configuration parameter '$1$' to an integer. Exception message: $2$. Using $3$ as default value for '$1$'.";
            }
            case 5: {
                return "Number format exception while converting the tagged value '$1$' to an integer. Exception message: $2$. Using $3$ as default value.";
            }
            case 100: {
                return "Context: property '$1$' in class '$2$'.";
            }
        }
        return "(" + AppConfiguration.class.getName() + ") Unknown message with number: " + mnr;
    }
}

