/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Options;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ShapeChangeResult {
    public static final String SCRS_NS = "http://www.interactive-instruments.de/ShapeChange/Result";
    public Document document = null;
    protected Element root = null;
    protected Element messages = null;
    protected Element resultFiles = null;
    protected Set<Element> resultElements = new HashSet<Element>();
    protected Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
    protected Options options = null;
    protected boolean fatalErrorReceived = false;
    protected HashSet<String> duplicateMessageCheck;
    protected static boolean printDateTime = false;
    protected static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public ShapeChangeResult(Options o) {
        this.init();
        this.options = o;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(true);
            dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.document = db.newDocument();
            this.root = this.document.createElementNS(SCRS_NS, "ShapeChangeResult");
            this.document.appendChild(this.root);
            this.root.setAttribute("resultCode", "0");
            this.root.setAttribute("xmlns:r", SCRS_NS);
            this.root.setAttribute("start", new Date().toString());
            String version = "[dev]";
            InputStream stream = this.getClass().getResourceAsStream("/sc.properties");
            if (stream != null) {
                Properties properties = new Properties();
                properties.load(stream);
                version = properties.getProperty("sc.version");
            }
            this.root.setAttribute("version", version);
            this.messages = this.document.createElementNS(SCRS_NS, "Messages");
            this.root.appendChild(this.messages);
            this.resultFiles = this.document.createElementNS(SCRS_NS, "Results");
            this.root.appendChild(this.resultFiles);
        }
        catch (ParserConfigurationException e) {
            System.err.println("Bootstrap Error: XML parser was unable to be configured.");
            String m = e.getMessage();
            if (m != null) {
                System.err.println(m);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Bootstrap Error: " + e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        this.outputFormat.setProperty("encoding", "UTF-8");
        this.outputFormat.setProperty("indent", "yes");
        this.outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
    }

    public void init() {
        this.duplicateMessageCheck = new HashSet(50);
    }

    public boolean isFatalErrorReceived() {
        return this.fatalErrorReceived;
    }

    private String safe(String s) {
        if (s == null) {
            return "<null>";
        }
        return s;
    }

    public MessageContext addDebug(MessageSource ms, int mnr, String p1, String p2, String p3, String p4) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addDebug(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3).replace("$4$", p4));
    }

    public MessageContext addDebug(MessageSource ms, int mnr, String p1, String p2, String p3) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addDebug(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", this.safe(p3)));
    }

    public MessageContext addDebug(MessageSource ms, int mnr, String p1, String p2) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addDebug(m.replace("$1$", p1).replace("$2$", p2));
    }

    public MessageContext addDebug(MessageSource ms, int mnr, String p1) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addDebug(m.replace("$1$", p1));
    }

    public MessageContext addDebug(MessageSource ms, int mnr) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addDebug(m);
    }

    public MessageContext addDebug(String m) {
        if (this.document == null || !this.options.parameter("reportLevel").equals("DEBUG")) {
            return null;
        }
        if (m.startsWith("??") && !this.duplicateMessageCheck.add("D " + (m = m.substring(2)))) {
            return null;
        }
        return new MessageContext(this, "Debug", m);
    }

    public MessageContext addProcessFlowDebug(MessageSource ms, int mnr, String p1, String p2, String p3, String p4) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowDebug(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3).replace("$4$", p4));
    }

    public MessageContext addProcessFlowDebug(MessageSource ms, int mnr, String p1, String p2, String p3) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowDebug(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", this.safe(p3)));
    }

    public MessageContext addProcessFlowDebug(MessageSource ms, int mnr, String p1, String p2) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowDebug(m.replace("$1$", p1).replace("$2$", p2));
    }

    public MessageContext addProcessFlowDebug(MessageSource ms, int mnr, String p1) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowDebug(m.replace("$1$", p1));
    }

    public MessageContext addProcessFlowDebug(MessageSource ms, int mnr) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowDebug(m);
    }

    public MessageContext addProcessFlowDebug(String m) {
        if (this.document == null || !this.options.parameterAsString(null, "processFlowReportLevel", "INFO", false, true).equals("DEBUG")) {
            return null;
        }
        if (m.startsWith("??") && !this.duplicateMessageCheck.add("PF-D " + (m = m.substring(2)))) {
            return null;
        }
        return new MessageContext(this, "ProcessFlowDebug", m);
    }

    public MessageContext addInfo(MessageSource ms, int mnr, String p1, String p2, String p3, String p4) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addInfo(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3).replace("$4$", p4));
    }

    public MessageContext addInfo(MessageSource ms, int mnr, String p1, String p2, String p3) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addInfo(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3));
    }

    public MessageContext addInfo(MessageSource ms, int mnr, String p1, String p2) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addInfo(m.replace("$1$", p1).replace("$2$", p2));
    }

    public MessageContext addInfo(MessageSource ms, int mnr, String p1) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addInfo(m.replace("$1$", p1));
    }

    public MessageContext addInfo(MessageSource ms, int mnr) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addInfo(m);
    }

    public MessageContext addInfo(String m) {
        String l = this.options.parameter("reportLevel");
        if (this.document == null || !l.equals("DEBUG") && !l.equals("INFO")) {
            return null;
        }
        if (m.startsWith("??") && !this.duplicateMessageCheck.add("I " + (m = m.substring(2)))) {
            return null;
        }
        return new MessageContext(this, "Info", m);
    }

    public MessageContext addProcessFlowInfo(MessageSource ms, int mnr, String p1, String p2, String p3, String p4) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowInfo(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3).replace("$4$", p4));
    }

    public MessageContext addProcessFlowInfo(MessageSource ms, int mnr, String p1, String p2, String p3) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowInfo(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3));
    }

    public MessageContext addProcessFlowInfo(MessageSource ms, int mnr, String p1, String p2) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowInfo(m.replace("$1$", p1).replace("$2$", p2));
    }

    public MessageContext addProcessFlowInfo(MessageSource ms, int mnr, String p1) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowInfo(m.replace("$1$", p1));
    }

    public MessageContext addProcessFlowInfo(MessageSource ms, int mnr) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowInfo(m);
    }

    public MessageContext addProcessFlowInfo(String m) {
        String l = this.options.parameterAsString(null, "processFlowReportLevel", "INFO", false, true);
        if (this.document == null || !l.equals("DEBUG") && !l.equals("INFO")) {
            return null;
        }
        if (m.startsWith("??") && !this.duplicateMessageCheck.add("PF-I " + (m = m.substring(2)))) {
            return null;
        }
        return new MessageContext(this, "ProcessFlowInfo", m);
    }

    public MessageContext addWarning(MessageSource ms, int mnr, String p1, String p2, String p3, String p4) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addWarning(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3).replace("$4$", p4));
    }

    public MessageContext addWarning(MessageSource ms, int mnr, String p1, String p2, String p3) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addWarning(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3));
    }

    public MessageContext addWarning(MessageSource ms, int mnr, String p1, String p2) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addWarning(m.replace("$1$", p1).replace("$2$", p2));
    }

    public MessageContext addWarning(MessageSource ms, int mnr, String p1) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addWarning(m.replace("$1$", p1));
    }

    public MessageContext addWarning(MessageSource ms, int mnr) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addWarning(m);
    }

    public MessageContext addWarning(String m) {
        String l = this.options.parameter("reportLevel");
        if (this.document == null || !l.equals("DEBUG") && !l.equals("INFO") && !l.equals("WARNING")) {
            return null;
        }
        if (m.startsWith("??") && !this.duplicateMessageCheck.add("W " + (m = m.substring(2)))) {
            return null;
        }
        return new MessageContext(this, "Warning", m);
    }

    public MessageContext addProcessFlowWarning(MessageSource ms, int mnr, String p1, String p2, String p3, String p4) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowWarning(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3).replace("$4$", p4));
    }

    public MessageContext addProcessFlowWarning(MessageSource ms, int mnr, String p1, String p2, String p3) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowWarning(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3));
    }

    public MessageContext addProcessFlowWarning(MessageSource ms, int mnr, String p1, String p2) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowWarning(m.replace("$1$", p1).replace("$2$", p2));
    }

    public MessageContext addProcessFlowWarning(MessageSource ms, int mnr, String p1) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowWarning(m.replace("$1$", p1));
    }

    public MessageContext addProcessFlowWarning(MessageSource ms, int mnr) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowWarning(m);
    }

    public MessageContext addProcessFlowWarning(String m) {
        String l = this.options.parameterAsString(null, "processFlowReportLevel", "INFO", false, true);
        if (this.document == null || !l.equals("DEBUG") && !l.equals("INFO") && !l.equals("WARNING")) {
            return null;
        }
        if (m.startsWith("??") && !this.duplicateMessageCheck.add("PF-W " + (m = m.substring(2)))) {
            return null;
        }
        return new MessageContext(this, "ProcessFlowWarning", m);
    }

    public MessageContext addError(MessageSource ms, int mnr, String p1, String p2, String p3, String p4, String p5, String p6, String p7) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addError(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3).replace("$4$", p4).replace("$5$", p5).replace("$6$", p6).replace("$7$", p7));
    }

    public MessageContext addError(MessageSource ms, int mnr, String p1, String p2, String p3, String p4) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addError(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3).replace("$4$", p4));
    }

    public MessageContext addError(MessageSource ms, int mnr, String p1, String p2, String p3) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addError(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3));
    }

    public MessageContext addError(MessageSource ms, int mnr, String p1, String p2) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addError(m.replace("$1$", p1).replace("$2$", p2));
    }

    public MessageContext addError(MessageSource ms, int mnr, String p1) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addError(m.replace("$1$", p1));
    }

    public MessageContext addError(MessageSource ms, int mnr) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addError(m);
    }

    public MessageContext addError(String m) {
        if (this.document == null) {
            return null;
        }
        if (m.startsWith("??") && !this.duplicateMessageCheck.add("E " + (m = m.substring(2)))) {
            return null;
        }
        return new MessageContext(this, "Error", m);
    }

    public MessageContext addProcessFlowError(MessageSource ms, int mnr, String p1, String p2, String p3, String p4, String p5, String p6, String p7) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowError(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3).replace("$4$", p4).replace("$5$", p5).replace("$6$", p6).replace("$7$", p7));
    }

    public MessageContext addProcessFlowError(MessageSource ms, int mnr, String p1, String p2, String p3, String p4) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowError(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3).replace("$4$", p4));
    }

    public MessageContext addProcessFlowError(MessageSource ms, int mnr, String p1, String p2, String p3) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowError(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3));
    }

    public MessageContext addProcessFlowError(MessageSource ms, int mnr, String p1, String p2) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowError(m.replace("$1$", p1).replace("$2$", p2));
    }

    public MessageContext addProcessFlowError(MessageSource ms, int mnr, String p1) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowError(m.replace("$1$", p1));
    }

    public MessageContext addProcessFlowError(MessageSource ms, int mnr) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowError(m);
    }

    public MessageContext addProcessFlowError(String m) {
        if (this.document == null) {
            return null;
        }
        if (m.startsWith("??") && !this.duplicateMessageCheck.add("PF-E " + (m = m.substring(2)))) {
            return null;
        }
        return new MessageContext(this, "ProcessFlowError", m);
    }

    public MessageContext addFatalError(MessageSource ms, int mnr, String p1, String p2, String p3, String p4) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addFatalError(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3).replace("$4$", p4));
    }

    public MessageContext addFatalError(MessageSource ms, int mnr, String p1, String p2, String p3) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addFatalError(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3));
    }

    public MessageContext addFatalError(MessageSource ms, int mnr, String p1, String p2) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addFatalError(m.replace("$1$", p1).replace("$2$", p2));
    }

    public MessageContext addFatalError(MessageSource ms, int mnr, String p1) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addFatalError(m.replace("$1$", p1));
    }

    public MessageContext addFatalError(MessageSource ms, int mnr) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        MessageContext ex = this.addFatalError(m);
        this.setResultCode(1);
        return ex;
    }

    public MessageContext addFatalError(String m) {
        this.fatalErrorReceived = true;
        if (this.document == null) {
            return null;
        }
        if (m.startsWith("??") && !this.duplicateMessageCheck.add("F " + (m = m.substring(2)))) {
            return null;
        }
        return new MessageContext(this, "FatalError", m);
    }

    public MessageContext addProcessFlowFatalError(MessageSource ms, int mnr, String p1, String p2, String p3, String p4) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowFatalError(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3).replace("$4$", p4));
    }

    public MessageContext addProcessFlowFatalError(MessageSource ms, int mnr, String p1, String p2, String p3) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowFatalError(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3));
    }

    public MessageContext addProcessFlowFatalError(MessageSource ms, int mnr, String p1, String p2) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowFatalError(m.replace("$1$", p1).replace("$2$", p2));
    }

    public MessageContext addProcessFlowFatalError(MessageSource ms, int mnr, String p1) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        return this.addProcessFlowFatalError(m.replace("$1$", p1));
    }

    public MessageContext addProcessFlowFatalError(MessageSource ms, int mnr) {
        String m = ms == null ? this.message(mnr) : ms.message(mnr);
        MessageContext ex = this.addProcessFlowFatalError(m);
        this.setResultCode(1);
        return ex;
    }

    public MessageContext addProcessFlowFatalError(String m) {
        this.fatalErrorReceived = true;
        if (this.document == null) {
            return null;
        }
        if (m.startsWith("??") && !this.duplicateMessageCheck.add("PF-F " + (m = m.substring(2)))) {
            return null;
        }
        return new MessageContext(this, "ProcessFlowFatalError", m);
    }

    public void addResult(String targetName, String dname, String fname, String scope) {
        if (this.document == null) {
            return;
        }
        Element resfile = this.document.createElementNS(SCRS_NS, "Result");
        this.resultFiles.appendChild(resfile);
        resfile.setAttribute("target", targetName);
        File file = new File(dname + "/" + fname);
        String path = file.toURI().toASCIIString();
        resfile.setAttribute("href", path);
        if (scope != null) {
            resfile.setAttribute("scope", scope);
        }
        resfile.appendChild(this.document.createTextNode(fname));
        this.resultElements.add(resfile);
    }

    public void updateResult(File originalFile, File newFile) {
        String originalFilePath = originalFile.toURI().toASCIIString();
        String newFilePath = newFile.toURI().toASCIIString();
        for (Element resultE : this.resultElements) {
            if (!resultE.getAttribute("href").equals(originalFilePath)) continue;
            resultE.setAttribute("href", newFilePath);
            resultE.setTextContent(newFile.getName());
        }
    }

    public void copyResultAndUpdateFileReference(File originalFile, File newFile) {
        if (this.document == null) {
            return;
        }
        String originalFilePath = originalFile.toURI().toASCIIString();
        String newFilePath = newFile.toURI().toASCIIString();
        ArrayList<Element> newResultElements = new ArrayList<Element>();
        for (Element resultElementForOriginalFile : this.resultElements) {
            if (!resultElementForOriginalFile.getAttribute("href").equals(originalFilePath)) continue;
            Element resultElementForNewFile = this.document.createElementNS(SCRS_NS, "Result");
            this.resultFiles.insertBefore(resultElementForNewFile, resultElementForOriginalFile.getNextSibling());
            resultElementForNewFile.setAttribute("target", resultElementForOriginalFile.getAttribute("target"));
            resultElementForNewFile.setAttribute("href", newFilePath);
            if (resultElementForOriginalFile.hasAttribute("scope")) {
                resultElementForNewFile.setAttribute("scope", resultElementForOriginalFile.getAttribute("scope"));
            }
            resultElementForNewFile.setTextContent(newFile.getName());
            newResultElements.add(resultElementForNewFile);
        }
        this.resultElements.addAll(newResultElements);
    }

    public void setResultCode(int rc) {
        if (this.document == null) {
            return;
        }
        this.root.setAttribute("resultCode", Integer.toString(rc, 10));
    }

    public Options options() {
        return this.options;
    }

    public void toFile(String filename) {
        if (this.document == null) {
            return;
        }
        try {
            this.root.setAttribute("config", this.options.configFile);
            this.root.setAttribute("end", new Date().toString());
            File f = new File(filename);
            f = f.getParentFile();
            if (f != null && !f.exists()) {
                FileUtils.forceMkdir((File)f);
            }
            BufferedWriter outputXML = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
            Serializer serializer = SerializerFactory.getSerializer((Properties)this.outputFormat);
            serializer.setWriter((Writer)outputXML);
            serializer.asDOMSerializer().serialize((Node)this.document);
            outputXML.close();
            String xsltfileName = this.options.parameter("xsltFile");
            if (xsltfileName != null && !xsltfileName.isEmpty()) {
                StreamSource xsltSource;
                if (xsltfileName.toLowerCase().startsWith("http")) {
                    URL url = new URL(xsltfileName);
                    URLConnection urlConnection = url.openConnection();
                    xsltSource = new StreamSource(urlConnection.getInputStream());
                } else {
                    InputStream stream = this.getClass().getResourceAsStream("/xslt/result.xsl");
                    if (stream == null) {
                        File xsltFile = new File(xsltfileName);
                        if (!xsltFile.canRead()) {
                            throw new Exception("Cannot read " + xsltFile.getName());
                        }
                        xsltSource = new StreamSource(xsltFile);
                    } else {
                        xsltSource = new StreamSource(stream);
                    }
                }
                File outHTML = new File(filename.replace(".xml", ".html"));
                if (outHTML.exists()) {
                    outHTML.delete();
                }
                BufferedWriter outputHTML = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outHTML), "UTF-8"));
                if (xsltSource != null) {
                    DOMSource xmlSource = new DOMSource(this.document);
                    StreamResult res = new StreamResult(outputHTML);
                    TransformerFactory transFact = TransformerFactory.newInstance();
                    Transformer trans = transFact.newTransformer(xsltSource);
                    trans.setOutputProperty("indent", "yes");
                    trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                    trans.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
                    trans.transform(xmlSource, res);
                    xsltSource.getInputStream().close();
                    outputHTML.close();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public Document asDOM() {
        return this.document;
    }

    protected static String dateTime() {
        Date date = new Date();
        return dateFormat.format(date);
    }

    public String message(int mnr) {
        switch (mnr) {
            case 9: {
                return "Class '$1$' is not associated with a package.";
            }
            case 11: {
                return "Could not establish a category for element '$1$', having well-known stereotype <<$2$>> and encoding rule '$3$'; setting category to 'unknown'.";
            }
            case 18: {
                return "Unsupported Java version: '$1$'. Java 11 or higher required.";
            }
            case 19: {
                return "Model object could not be instantiated: '$1$'.";
            }
            case 20: {
                return "Model object could not be accessed: '$1$'.";
            }
            case 21: {
                return "??Rule name '$1$' is not valid. The rule is ignored.";
            }
            case 22: {
                return "??Reference model '$1$' could not be loaded and is ignored.";
            }
            case 30: {
                return "Enterprise Architect repository cannot be opened. File name or connection string is: '$2$', EA message is: '$1$'";
            }
            case 31: {
                return "Enterprise Architect repository file named '$1$' not found";
            }
            case 32: {
                return "Could not create directory $1$";
            }
            case 38: {
                return "Encountered First Order Logic constraint with source type '$1$', parsing of which is not supported yet. A First Order Logic expression cannot be created.";
            }
            case 39: {
                return "Context: constraint '$1$' in class '$2$'.";
            }
            case 50: {
                return "Element '$1$' has the following stereotype(s) in the input model: '$2$'.";
            }
            case 51: {
                return "Stereotype '$2$' of element '$1$' normalized to '$3$'.";
            }
            case 52: {
                return "Well-known stereotype '$2$' added to element '$1$'.";
            }
            case 53: {
                return "No well-known stereotype found for stereotype '$2$' of element '$1$'.";
            }
            case 54: {
                return "Element '$1$' has $2$ (well-known or additional) stereotype(s): '$3$'";
            }
            case 56: {
                return "No well-known stereotype found for stereotype '$2$' of element '$1$', but due to input parameter 'addStereotypes' all stereotypes are allowed. Thus stereotype '$2$' is added to element '$1$'.";
            }
            case 57: {
                return "No well-known stereotype found for stereotype '$2$' of element '$1$', but due to input parameter 'addStereotypes' that stereotype is allowed. Thus stereotype '$2$' is added to element '$1$'.";
            }
            case 100: {
                return "??The '$1$' with ID '$2$' has no name. The ID is used instead.";
            }
            case 101: {
                return "??Application schema '$1$' with ID '$2$' is not associated with an XML Schema document. A default name is used: '$3$'.";
            }
            case 104: {
                return "??The supertypes of class '$1$' are of different categories or the stereotype of the class cannot be determined. This is not supported, the class is ignored.";
            }
            case 105: {
                return "??The restriction of UML attribute '$1$' in class '$2$' is not legal. The lower multiplicity limit is smaller than in the supertype '$3$'.";
            }
            case 106: {
                return "??The restriction of UML attribute '$1$' in class '$2$' is not legal. The upper multiplicity limit is higher than in the supertype '$3$'.";
            }
            case 107: {
                return "??The property '$1$' in class '$2$' has a sequence number that is already in use for another property ($3$) which will be overwritten.";
            }
            case 108: {
                return "??The class '$1$' is modelled as a feature type, object type, data type, mixin, or union, but has a supertype of a different category ('$2$'). The supertype may be ignored by some targets (e.g. the XmlSchema target).";
            }
            case 109: {
                return "??The class '$1$' is modelled as a feature type, object type, data type, mixin, or union, but has more than one supertype of the same kind. Some targets (e.g. the XmlSchema target) ignore all but one (arbitrary) supertype.";
            }
            case 110: {
                return "??A target could not be created for schema '$1$'. This target is supported only for GML versions 3.2 and later.";
            }
            case 111: {
                return "??Missing argument to '$1$' option.";
            }
            case 115: {
                return "??The class '$1$' is modelled as an interface, but has supertypes that are instantiable. The supertype relationships are ignored.";
            }
            case 117: {
                return "??No XML Schema type for type '$1$' is defined. Only object and data types are supported.";
            }
            case 121: {
                return "Base type '$1$' could not be mapped. Missing base type in complex type '$2$'.";
            }
            case 125: {
                return "The class '$1$' is an enumeration. Generalization relationships are not supported for these classes. All such relationships are ignored.";
            }
            case 126: {
                return "Failed to create enumeration type '$1$'.";
            }
            case 127: {
                return "The class '$1$' is a codelist. Generalization relationships are not supported for these classes. All such relationships are ignored.";
            }
            case 131: {
                return "??The type '$2$' of property '$1$' was not found.";
            }
            case 132: {
                return "The class '$1$' is referenced, but is not part of any schema in the model nor is it mapped to a well-known XML Schema type. The class is ignored.";
            }
            case 133: {
                return "One or more errors encountered in OCL constraint in $3$ '$1$' : '$2$' ...";
            }
            case 134: {
                return "Line/column(s) $1$: $2$";
            }
            case 135: {
                return "??The type of property '$1$' was not found by id, only by name (fixed broken type definition).";
            }
            case 136: {
                return "The enumeration element with ID '$1$' in class '$2$' contains an empty string as value.";
            }
            case 139: {
                return "Cannot add properties of type '$1' in schema definitions since the type definition is not part of the model.";
            }
            case 140: {
                return "Unknown value for $1: $2";
            }
            case 142: {
                return "Class '$1$' cannot be suppressed, as no direct or indirect, non-abstract supertype exists that is not suppressed.";
            }
            case 143: {
                return "Class '$1$' cannot be suppressed, as it has a non-suppressed subtype '$2$'.";
            }
            case 144: {
                return "Class '$1$' cannot be suppressed, as it add at least one property.";
            }
            case 146: {
                return "??Schema '$1$' is missing tagged value '$2$'.";
            }
            case 147: {
                return "??Package '$1$' has tagged value '$2$', but is not an application schema.";
            }
            case 148: {
                return "??Property '$2$' of class '$1$' is not a composition, but has a data type as its value: '$3$'.";
            }
            case 149: {
                return "??Name of '$1$' '$2$' includes invalid characters.";
            }
            case 150: {
                return "??Schema '$1$' has dummy tagged value '$2$': '$3$'.";
            }
            case 151: {
                return "??Documentation of schema '$1$' is missing the separator '$2$'.";
            }
            case 152: {
                return "??Documentation of class '$1$' is missing the separator '$2$'.";
            }
            case 153: {
                return "??Documentation of property '$1$' is missing the separator '$2$'.";
            }
            case 159: {
                return "??Package '$1$' has a dependency, but is not an application schema.";
            }
            case 160: {
                return "??Package '$1$' is the supplier of a dependency to package '$2$', but is not an application schema.";
            }
            case 161: {
                return "??$1$ with id '$2$' is referenced, but cannot be found.";
            }
            case 162: {
                return "??XML Schema document name '$1$' is used for more than one schema package.";
            }
            case 163: {
                return "??Class name '$1$' is used more than once in application schema '$2$'.";
            }
            case 164: {
                return "??Rule '$1$' is unknown, but referenced in the ShapeChange source code. This is a system error.";
            }
            case 167: {
                return "XML Schema document name '$1$' does not contain the .xsd file extension.";
            }
            case 168: {
                return "??The property '$1$' in class '$2$' has no sequence number.";
            }
            case 171: {
                return "XML Schema document with name '$1$' could not be created, invalid filename.";
            }
            case 181: {
                return "??Encoding rule $1$ is specified as default encoding rule for platform $2$ but is not configured.";
            }
            case 200: {
                return "??Tagged value '$1$' missing in class '$2$'.";
            }
            case 201: {
                return "??Tagged value '$1$' has incorrect value '$3$' in class '$2$'.";
            }
            case 203: {
                return "??Tagged value '$1$' has incorrect value '$3$' in property '$2$'.";
            }
            case 204: {
                return "??Outdated tagged value '$1$' used in property '$2$'.";
            }
            case 301: {
                return "File '$1$' is not readable, processing of $2$ is skipped.";
            }
            case 304: {
                return "Error while transforming '$1$'. Message: $2$";
            }
            case 307: {
                return "File '$1$' is not writable, processing of $2$ is skipped.";
            }
            case 400: {
                return "Context: $1$ '$2$'";
            }
            case 600: {
                return "File could not be deleted. Exception message: '$1$'.";
            }
            case 601: {
                return "Directory named '$1$' does not exist or is not accessible.";
            }
            case 701: {
                return "A single value was requested for tag '$1$', but in addition to returned value '$2$', an additional value '$3$' exists and is ignored.";
            }
            case 702: {
                return "A single value was requested for tag '$1$' in language '$2$', but in addition to returned value '$3$', an additional value '$4$' exists and is ignored.";
            }
            case 704: {
                return "??Descriptor '$1$' is a single-valued descriptor, but in addition to returned value '$2$' a value '$3$' exists and is ignored.";
            }
            case 790: {
                return "Context: class InfoImpl. Model element: $1$";
            }
            case 791: {
                return "Context: class InfoImpl (subtype: PropertyInfo). Model element: $1$";
            }
            case 1002: {
                return "Restriction of property '$1$' in class '$2$' from supertype '$3$'.";
            }
            case 1003: {
                return "??The multiplicity value of '$1$' is neither a number nor a known string. '*' is used instead.";
            }
            case 1004: {
                return "Class '$1$' has an unknown category, an object is assumed.";
            }
            case 10003: {
                return "Checked class '$1$', category '$2$', result '$3$'";
            }
            case 10004: {
                return "Checking overloading. Class = '$1$'; current class = '$2$'.";
            }
            case 10005: {
                return "Generating GML dictionaries with definitions for application schema '$1$'.";
            }
            case 10006: {
                return "Processing OCL constraint in class '$1$': '$2$'.";
            }
            case 10013: {
                return "The '$1$' with ID '$2$' and name '$3$' was created.";
            }
            case 10023: {
                return "Processing local properties of class '$1$'.";
            }
            case 10024: {
                return "OCL syntax tree: '$1$'";
            }
            case 10025: {
                return "OCL comment: '$1$'";
            }
            case 20103: {
                return "---------- now processing: $1$ ----------";
            }
            case 20216: {
                return "Context: model element: '$1$'";
            }
            case 20217: {
                return "Context: parsing message: '$1$'";
            }
            case 20218: {
                return "Context: profiles string: '$1$'";
            }
            case 30800: {
                return "(Generic model element reader) Unexpected start element found by $1$: '$2$'.";
            }
            case 30801: {
                return "(Generic model element reader) Unexpected end element found by $1$: '$2$'.";
            }
            case 30804: {
                return "(Generic model element reader) SCXML producer: $1$, version: $2$";
            }
            case 1000000: {
                return "Unrecognized parameter found: '$1$'. The parameter may have no effect on processing. Did you mean '$2$'?";
            }
            case 1000001: {
                return "Unrecognized parameter found: '$1$'. The parameter may have no effect on processing.";
            }
        }
        return "(" + ShapeChangeResult.class.getName() + ") Unknown message with number: " + mnr;
    }

    public static class MessageContext {
        protected ShapeChangeResult result;
        protected String level;
        protected Element message;

        public MessageContext(ShapeChangeResult result, String level) {
            this.result = result;
            this.level = level;
            this.message = null;
        }

        public MessageContext(ShapeChangeResult result, String level, String mtext) {
            this.result = result;
            this.level = level;
            Object systemErrMsgPrefix = level.startsWith("ProcessFlow") ? "PF-" + level.substring(11, 12) : level.substring(0, 1);
            System.err.println((String)systemErrMsgPrefix + " " + (String)(printDateTime ? ShapeChangeResult.dateTime() + " " : "") + mtext);
            this.message = result.document.createElementNS(ShapeChangeResult.SCRS_NS, level);
            result.messages.appendChild(this.message);
            this.message.setAttribute("message", (String)(printDateTime ? ShapeChangeResult.dateTime() + " " : "") + mtext);
        }

        public void addDetail(String mtext) {
            System.err.println(this.level.substring(0, 1) + " ... " + mtext);
            if (this.message != null) {
                Element detail = this.result.document.createElement("Detail");
                detail.setAttribute("message", mtext);
                this.message.appendChild(detail);
            }
        }

        public void addDetail(MessageSource ms, int mnr, String p1, String p2, String p3, String p4) {
            String m = ms == null ? this.result.message(mnr) : ms.message(mnr);
            this.addDetail(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3).replace("$4$", p4));
        }

        public void addDetail(MessageSource ms, int mnr, String p1, String p2, String p3) {
            String m = ms == null ? this.result.message(mnr) : ms.message(mnr);
            this.addDetail(m.replace("$1$", p1).replace("$2$", p2).replace("$3$", p3));
        }

        public void addDetail(MessageSource ms, int mnr, String p1, String p2) {
            String m = ms == null ? this.result.message(mnr) : ms.message(mnr);
            this.addDetail(m.replace("$1$", p1).replace("$2$", p2));
        }

        public void addDetail(MessageSource ms, int mnr, String p1) {
            String m = ms == null ? this.result.message(mnr) : ms.message(mnr);
            this.addDetail(m.replace("$1$", p1));
        }

        public void addDetail(MessageSource ms, int mnr) {
            String m = ms == null ? this.result.message(mnr) : ms.message(mnr);
            this.addDetail(m);
        }
    }
}

