/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ShapeChangeErrorHandler
implements ErrorHandler {
    protected boolean errorsFound = false;

    public boolean errorsFound() {
        return this.errorsFound;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        String m = e.getMessage();
        if (m != null) {
            System.err.println(m + this.locator(e));
        } else {
            e.printStackTrace(System.err);
        }
        this.errorsFound = true;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        String m = e.getMessage();
        if (m != null) {
            System.err.println(m + this.locator(e));
        } else {
            e.printStackTrace(System.err);
        }
        this.errorsFound = true;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        String m = e.getMessage();
        if (m != null) {
            System.err.println(m + this.locator(e));
        } else {
            e.printStackTrace(System.err);
        }
    }

    private String locator(SAXParseException e) {
        return " (line " + e.getLineNumber() + ", column " + e.getColumnNumber() + ")";
    }
}

