/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.SBVR;

import de.interactive_instruments.ShapeChange.SBVR.SbvrErrorInfo;
import de.interactive_instruments.antlr.sbvr.SBVRBaseListener;
import de.interactive_instruments.antlr.sbvr.SBVRParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.Token;

public class SbvrValidationErrorListener
extends SBVRBaseListener {
    private Set<String> nouns;
    private Set<String> verbs;
    private List<SbvrErrorInfo> errors = new ArrayList<SbvrErrorInfo>();

    public SbvrValidationErrorListener(Set<String> nouns, Set<String> verbs) {
        this.nouns = nouns;
        this.verbs = verbs;
    }

    public void enterPrefixedPredicate(SBVRParser.PrefixedPredicateContext ctx) {
        if (ctx.noun != null) {
            this.validateNounConcept(ctx.noun);
        }
    }

    public void enterQuantification(SBVRParser.QuantificationContext ctx) {
        this.validateNounConcept(ctx.noun);
    }

    public boolean validateNounConcept(Token t) {
        if (t == null) {
            String msg = "Unknown noun concept encountered.";
            this.addErrorMessage(SbvrErrorInfo.Category.NOT_A_NOUN_CONCEPT, msg);
            return false;
        }
        String concept = t.getText();
        if (!this.isNoun(concept)) {
            String msg = concept + " is not a known noun concept.";
            this.addErrorMessage(SbvrErrorInfo.Category.NOT_A_NOUN_CONCEPT, msg, t);
            return false;
        }
        return true;
    }

    private void addErrorMessage(SbvrErrorInfo.Category category, String msg) {
        SbvrErrorInfo err = new SbvrErrorInfo();
        err.setErrorCategory(category);
        err.setErrorMessage(msg);
        this.errors.add(err);
    }

    public void enterModality(SBVRParser.ModalityContext ctx) {
        Token shouldNotToken;
        Token shouldToken = ctx.should;
        if (shouldToken != null) {
            String msg = "'should' is not an actual requirement and therefore not allowed.";
            this.addErrorMessage(SbvrErrorInfo.Category.ILL_DEFINED_MODALITY, msg, shouldToken);
        }
        if ((shouldNotToken = ctx.shouldNot) != null) {
            String msg = "'should not' is not an actual requirement and therefore not allowed.";
            this.addErrorMessage(SbvrErrorInfo.Category.ILL_DEFINED_MODALITY, msg, shouldNotToken);
        }
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<SbvrErrorInfo> getErrors() {
        return this.errors;
    }

    private void addErrorMessage(SbvrErrorInfo.Category category, String msg, Token t) {
        SbvrErrorInfo err = new SbvrErrorInfo();
        err.setErrorCategory(category);
        err.setErrorMessage(msg);
        err.setMetadataFromToken(t);
        this.errors.add(err);
    }

    public void enterVerbExpr(SBVRParser.VerbExprContext ctx) {
        String concept;
        Token verbToken = ctx.verb;
        if (verbToken != null && !this.isVerb(concept = verbToken.getText())) {
            String msg = concept + " is not a known verb concept.";
            this.addErrorMessage(SbvrErrorInfo.Category.NOT_A_VERB_CONCEPT, msg, verbToken);
        }
    }

    public boolean isNoun(String token) {
        boolean result = true;
        if (token.contains(".")) {
            String[] parts;
            for (String part : parts = token.split("\\.")) {
                if (part.length() <= 0 || this.nouns.contains(part)) continue;
                result = false;
            }
        } else if (!this.nouns.contains(token)) {
            result = false;
        }
        return result;
    }

    public boolean isVerb(String token) {
        return this.verbs.contains(token);
    }
}

