/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.SBVR;

import de.interactive_instruments.ShapeChange.FOL.ClassCall;
import de.interactive_instruments.ShapeChange.FOL.PropertyCall;
import de.interactive_instruments.ShapeChange.FOL.SchemaCall;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.SBVR.SbvrErrorInfo;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.antlr.ShapeChangeAntlr.SbvrParserHelper;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;

public class SbvrUtil {
    public static SchemaCall copy(SchemaCall sc) {
        SchemaCall result;
        if (sc == null) {
            return null;
        }
        if (sc instanceof PropertyCall) {
            PropertyCall pc = new PropertyCall();
            pc.setSchemaElement(((PropertyCall)sc).getSchemaElement());
            result = pc;
        } else {
            ClassCall cc = new ClassCall();
            cc.setSchemaElement(((ClassCall)sc).getSchemaElement());
            result = cc;
        }
        result.setNameInSbvr(sc.getNameInSbvr());
        if (sc.hasVariableContext()) {
            result.setVariableContext(sc.getVariableContext());
        }
        if (sc.hasNextElement()) {
            result.setNextElement(SbvrUtil.copy(sc.getNextElement()));
        }
        return result;
    }

    public static SortedSet<String> identifyNouns(Model m) {
        TreeSet<String> nouns = new TreeSet<String>();
        SortedSet<? extends PackageInfo> schemas = m.selectedSchemas();
        if (schemas != null) {
            for (PackageInfo packageInfo : schemas) {
                SortedSet<ClassInfo> classes = m.classes(packageInfo);
                if (classes == null) continue;
                for (ClassInfo ci : classes) {
                    SortedMap<StructuredNumber, PropertyInfo> pis;
                    nouns.add(ci.name());
                    if (m.options().isAIXM() && ci.category() == 1) {
                        nouns.add(ci.name() + "TimeSlice");
                        nouns.add("timeSlice");
                        nouns.add("interpretation");
                        nouns.add("sequenceNumber");
                        nouns.add("correctionNumber");
                        nouns.add("timeSliceMetadata");
                        nouns.add("featureLifetime");
                        nouns.add("validTime");
                        nouns.add("featureMetadata");
                    }
                    if ((pis = ci.properties()) == null) continue;
                    for (PropertyInfo pi : pis.values()) {
                        nouns.add(pi.name());
                    }
                }
            }
        }
        return nouns;
    }

    public static SortedSet<String> identifyVerbs(Model m) {
        TreeSet<String> verbs = new TreeSet<String>();
        SortedSet<? extends PackageInfo> schemas = m.selectedSchemas();
        if (schemas != null) {
            verbs.add("has");
            verbs.add("have");
            for (PackageInfo packageInfo : schemas) {
                SortedSet<ClassInfo> classes = m.classes(packageInfo);
                if (classes == null) continue;
                for (ClassInfo ci : classes) {
                    SortedMap<StructuredNumber, PropertyInfo> pis = ci.properties();
                    if (pis == null) continue;
                    for (PropertyInfo pi : pis.values()) {
                        AssociationInfo ai;
                        if (pi.isAttribute() || (ai = pi.association()).name() == null || ai.name().length() <= 0) continue;
                        verbs.add(ai.name());
                    }
                }
            }
        }
        return verbs;
    }

    public static SbvrParserHelper createParserHelper(Model m) {
        SbvrParserHelper helper = new SbvrParserHelper();
        helper.nouns = SbvrUtil.identifyNouns(m);
        helper.verbs = SbvrUtil.identifyVerbs(m);
        return helper;
    }

    public static void printErrors(List<SbvrErrorInfo> errors, String sbvrRuleText, ShapeChangeResult result, boolean asWarnings) {
        for (SbvrErrorInfo err : errors) {
            int i;
            Object msg = "--- " + err.getErrorCategory() + ": " + err.getErrorMessage();
            if (asWarnings) {
                result.addWarning((String)msg);
            } else {
                result.addError((String)msg);
            }
            if (!err.hasOffendingTextInfo()) continue;
            msg = "--- rule: " + sbvrRuleText;
            if (asWarnings) {
                result.addWarning((String)msg);
            } else {
                result.addError((String)msg);
            }
            StringBuilder sb = new StringBuilder();
            int start = err.getOffendingTextStartIndex();
            int stop = err.getOffendingTextStopIndex();
            for (i = 0; i < start + "--- ".length() + "rule: ".length(); ++i) {
                sb.append(" ");
            }
            if (start >= 0 && stop >= 0) {
                for (i = start; i <= stop; ++i) {
                    sb.append("^");
                }
            }
            msg = sb.toString();
            if (asWarnings) {
                result.addWarning((String)msg);
                continue;
            }
            result.addError((String)msg);
        }
    }
}

