/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.SBVR;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericFolConstraint;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.SBVR.SbvrClassNameDetectionListener;
import de.interactive_instruments.ShapeChange.SBVR.SbvrErrorListener;
import de.interactive_instruments.ShapeChange.SBVR.SbvrRuleInfo;
import de.interactive_instruments.ShapeChange.SBVR.SbvrUtil;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.antlr.ShapeChangeAntlr.SbvrParserHelper;
import de.interactive_instruments.antlr.sbvr.SBVRLexer;
import de.interactive_instruments.antlr.sbvr.SBVRParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeMap;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class SbvrRuleLoader
implements MessageSource {
    private Options options;
    private ShapeChangeResult result;
    private Model model;
    private SbvrParserHelper helper;
    private TreeMap<String, TreeMap<String, List<SbvrRuleInfo>>> sbvrRules;
    public static final String UNSPECIFIED_SCHEMA_PACKAGE_NAME = "UNSPECIFIED";

    public SbvrRuleLoader(String sbvrFileLocation, Options options, ShapeChangeResult result, Model model) {
        this.options = options;
        this.result = result;
        this.model = model;
        if (sbvrFileLocation != null) {
            this.helper = SbvrUtil.createParserHelper(model);
            File sbvrFile = new File((String)sbvrFileLocation);
            boolean ex = true;
            if (!sbvrFile.exists()) {
                ex = false;
                if (!((String)sbvrFileLocation).toLowerCase().endsWith(".xlsx")) {
                    sbvrFileLocation = (String)sbvrFileLocation + ".xlsx";
                    sbvrFile = new File((String)sbvrFileLocation);
                    ex = sbvrFile.exists();
                }
            }
            if (!ex) {
                result.addError(this, 36, (String)sbvrFileLocation);
            } else {
                try {
                    Workbook sbvrXls = WorkbookFactory.create((File)sbvrFile);
                    this.sbvrRules = this.parseSBVRRuleInfos(sbvrXls);
                }
                catch (EncryptedDocumentException e) {
                    result.addError(this, 1, e.getMessage());
                }
                catch (IOException e) {
                    result.addError(this, 2, e.getMessage());
                }
            }
        }
    }

    private TreeMap<String, TreeMap<String, List<SbvrRuleInfo>>> parseSBVRRuleInfos(Workbook sbvrXls) {
        int i;
        TreeMap<String, TreeMap<String, List<SbvrRuleInfo>>> rules = new TreeMap<String, TreeMap<String, List<SbvrRuleInfo>>>();
        if (sbvrXls == null) {
            return null;
        }
        Sheet rulesSheet = null;
        for (int i2 = 0; i2 < sbvrXls.getNumberOfSheets(); ++i2) {
            String sheetName = sbvrXls.getSheetName(i2);
            if (!sheetName.equalsIgnoreCase("Constraints")) continue;
            rulesSheet = sbvrXls.getSheetAt(i2);
            break;
        }
        if (rulesSheet == null) {
            this.result.addError(this, 3);
            return null;
        }
        HashMap<String, Integer> fieldIndexes = new HashMap<String, Integer>();
        Row header = rulesSheet.getRow(rulesSheet.getFirstRowNum());
        if (header == null) {
            this.result.addError(this, 4);
            return null;
        }
        boolean classNameFound = false;
        boolean commentsFound = false;
        boolean ruleNameFound = false;
        boolean ruleTextFound = false;
        boolean schemaPackageFound = false;
        for (i = header.getFirstCellNum(); i < header.getLastCellNum(); i = (int)((short)(i + 1))) {
            Cell c = header.getCell(i, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
            if (c == null) continue;
            String value = c.getStringCellValue();
            if (value.equalsIgnoreCase("Class")) {
                fieldIndexes.put("Class", i);
                classNameFound = true;
                continue;
            }
            if (value.equalsIgnoreCase("Comments")) {
                fieldIndexes.put("Comments", i);
                commentsFound = true;
                continue;
            }
            if (value.equalsIgnoreCase("Schema Package")) {
                fieldIndexes.put("Schema Package", i);
                schemaPackageFound = true;
                continue;
            }
            if (value.equalsIgnoreCase("Text")) {
                fieldIndexes.put("Text", i);
                ruleTextFound = true;
                continue;
            }
            if (!value.equalsIgnoreCase("Name")) continue;
            fieldIndexes.put("Name", i);
            ruleNameFound = true;
        }
        if (!ruleNameFound && !ruleTextFound) {
            this.result.addError(this, 5);
            return null;
        }
        for (i = rulesSheet.getFirstRowNum() + 1; i <= rulesSheet.getLastRowNum(); ++i) {
            List<SbvrRuleInfo> rulesList;
            TreeMap<Object, Object> rulesBySchemaPackageName;
            Row r = rulesSheet.getRow(i);
            int rowNumber = i + 1;
            if (r == null) continue;
            SbvrRuleInfo sri = new SbvrRuleInfo();
            Cell c = r.getCell(((Integer)fieldIndexes.get("Name")).intValue(), Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
            if (c == null) {
                this.result.addWarning(this, 6, "" + rowNumber);
                continue;
            }
            String cellValue = c.getStringCellValue();
            if (cellValue != null) {
                if (cellValue.contains(":")) {
                    sri.setName(cellValue.substring(cellValue.lastIndexOf(":") + 1));
                } else {
                    sri.setName(cellValue);
                }
            }
            if ((c = r.getCell(((Integer)fieldIndexes.get("Text")).intValue(), Row.MissingCellPolicy.RETURN_BLANK_AS_NULL)) == null) {
                this.result.addWarning(this, 7, "" + rowNumber);
                continue;
            }
            sri.setText(c.getStringCellValue());
            if (commentsFound && (c = r.getCell(((Integer)fieldIndexes.get("Comments")).intValue(), Row.MissingCellPolicy.RETURN_BLANK_AS_NULL)) != null) {
                sri.setComment(c.getStringCellValue());
            }
            if (schemaPackageFound) {
                c = r.getCell(((Integer)fieldIndexes.get("Schema Package")).intValue(), Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                if (c == null) {
                    sri.setSchemaPackageName(UNSPECIFIED_SCHEMA_PACKAGE_NAME);
                } else {
                    sri.setSchemaPackageName(c.getStringCellValue());
                }
            }
            if (classNameFound && (c = r.getCell(((Integer)fieldIndexes.get("Class")).intValue(), Row.MissingCellPolicy.RETURN_BLANK_AS_NULL)) != null) {
                sri.setClassName(c.getStringCellValue());
            }
            if (sri.getClassName() == null) {
                this.result.addInfo(this, 10, sri.getName());
                String mainClassName = this.parseClassNameFromRuleText(sri.getText());
                if (mainClassName == null) {
                    this.result.addWarning(this, 8, sri.getName());
                    continue;
                }
                sri.setClassName(mainClassName);
            }
            if (rules.containsKey(sri.getClassName())) {
                rulesBySchemaPackageName = rules.get(sri.getClassName());
                if (rulesBySchemaPackageName.containsKey(sri.getSchemaPackageName())) {
                    rulesList = (List)rulesBySchemaPackageName.get(sri.getSchemaPackageName());
                } else {
                    rulesList = new ArrayList();
                    rulesBySchemaPackageName.put(sri.getSchemaPackageName(), rulesList);
                }
            } else {
                rulesBySchemaPackageName = new TreeMap();
                rules.put(sri.getClassName(), rulesBySchemaPackageName);
                rulesList = new ArrayList();
                rulesBySchemaPackageName.put(sri.getSchemaPackageName(), rulesList);
            }
            rulesList.add(sri);
        }
        for (TreeMap rulesBySchemaPackageName : rules.values()) {
            for (List rulesList : rulesBySchemaPackageName.values()) {
                Collections.sort(rulesList, new Comparator<SbvrRuleInfo>(){

                    @Override
                    public int compare(SbvrRuleInfo o1, SbvrRuleInfo o2) {
                        int classNameComparison = o1.getClassName().compareTo(o2.getClassName());
                        if (classNameComparison != 0) {
                            return classNameComparison;
                        }
                        return o1.getText().compareTo(o2.getText());
                    }
                });
            }
        }
        return rules;
    }

    private String parseClassNameFromRuleText(String text) {
        ANTLRInputStream input = new ANTLRInputStream(text);
        SBVRLexer lexer = new SBVRLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        SBVRParser parser = new SBVRParser((TokenStream)tokens);
        parser.helper = this.helper;
        parser.removeErrorListeners();
        SbvrErrorListener parsingErrorListener = new SbvrErrorListener();
        parser.addErrorListener((ANTLRErrorListener)parsingErrorListener);
        SBVRParser.SentenceContext tree = parser.sentence();
        if (parsingErrorListener.hasErrors()) {
            SbvrUtil.printErrors(parsingErrorListener.getErrors(), text, this.result, false);
            return null;
        }
        SbvrClassNameDetectionListener nameDetectionListener = new SbvrClassNameDetectionListener();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)nameDetectionListener, (ParseTree)tree);
        return nameDetectionListener.getMainClassName();
    }

    public void loadSBVRRulesAsConstraints(PackageInfo schemaPackage) {
        if (this.sbvrRules == null || this.sbvrRules.isEmpty()) {
            return;
        }
        SortedSet<ClassInfo> classesInSchema = this.model.classes(schemaPackage);
        for (ClassInfo ci : classesInSchema) {
            if (this.options.isAIXM() && ci.category() == 16) continue;
            GenericClassInfo genCi = (GenericClassInfo)ci;
            ArrayList rulesForClass = new ArrayList();
            if (this.sbvrRules.containsKey(genCi.name())) {
                TreeMap<String, List<SbvrRuleInfo>> rulesBySchemaPackageName = this.sbvrRules.get(genCi.name());
                if (rulesBySchemaPackageName.containsKey(schemaPackage.name())) {
                    rulesForClass.addAll(rulesBySchemaPackageName.get(schemaPackage.name()));
                }
                if (rulesBySchemaPackageName.containsKey(UNSPECIFIED_SCHEMA_PACKAGE_NAME)) {
                    rulesForClass.addAll(rulesBySchemaPackageName.get(UNSPECIFIED_SCHEMA_PACKAGE_NAME));
                }
            }
            ArrayList<Constraint> newFolConstraints = new ArrayList<Constraint>();
            for (SbvrRuleInfo rule : rulesForClass) {
                GenericFolConstraint genCon = new GenericFolConstraint(genCi, rule.getName(), "", "SBVR", rule.getText());
                newFolConstraints.add(genCon);
            }
            genCi.addConstraints(newFolConstraints);
        }
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Invalid format for excel file containing SBVR constraints. Message is: $1$";
            }
            case 2: {
                return "Could not read excel file containing SBVR rules. Message is: $1$";
            }
            case 3: {
                return "No constraints sheet found in excel file containing SBVR rules.";
            }
            case 4: {
                return "Header not found in SBVR rules sheet.";
            }
            case 5: {
                return "Did not find required columns in SBVR rules sheet.";
            }
            case 6: {
                return "No name found for rule declared in line $1$ of SBVR rules sheet. This kind of message can occur for rows the are seemingly empty in the excel sheet.";
            }
            case 7: {
                return "No text found for rule declared in line $1$ of SBVR rules sheet.";
            }
            case 8: {
                return "Parsing main class name for rule '$1$' was not successful. This rule will not be added to the model.";
            }
            case 9: {
                return "";
            }
            case 10: {
                return "No main class name provided for rule '$1$'. Parsing the name from the rule text.";
            }
            case 36: {
                return "??The excel spreadsheet with SBVR rules was not found at file location '$1$'.";
            }
        }
        return "(" + SbvrRuleLoader.class.getName() + ") Unknown message with number: " + mnr;
    }
}

