/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.SBVR;

import de.interactive_instruments.ShapeChange.FOL.FolExpression;
import de.interactive_instruments.ShapeChange.Model.FolConstraint;
import de.interactive_instruments.ShapeChange.SBVR.SbvrErrorInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class SbvrParsingResult {
    private TreeMap<String, List<SbvrErrorInfo>> errorsByCategory = new TreeMap();
    private FolConstraint con;
    private String ruleInvocationStackForHappyCase;
    private FolExpression folExpr;

    public TreeMap<String, List<SbvrErrorInfo>> getErrors() {
        return this.errorsByCategory;
    }

    public void setErrors(TreeMap<String, List<SbvrErrorInfo>> errorsByCategory) {
        this.errorsByCategory = errorsByCategory;
    }

    public void addError(SbvrErrorInfo error) {
        List<SbvrErrorInfo> errors;
        if (this.errorsByCategory == null) {
            this.errorsByCategory = new TreeMap();
        }
        if ((errors = this.errorsByCategory.get(error.getErrorCategory().getName())) == null) {
            errors = new ArrayList<SbvrErrorInfo>();
            this.errorsByCategory.put(error.getErrorCategory().getName(), errors);
        }
        errors.add(error);
    }

    public void addErrors(List<SbvrErrorInfo> errors) {
        if (errors != null) {
            for (SbvrErrorInfo error : errors) {
                this.addError(error);
            }
        }
    }

    public boolean hasRuleInvocationStack() {
        return this.ruleInvocationStackForHappyCase != null;
    }

    public void setRuleInvocationStack(String stack) {
        if (stack != null && stack.trim().length() > 0) {
            this.ruleInvocationStackForHappyCase = stack.trim();
        }
    }

    public String getRuleInvocationStack() {
        return this.ruleInvocationStackForHappyCase;
    }

    public FolConstraint getConstraint() {
        return this.con;
    }

    public void setConstraint(FolConstraint con) {
        this.con = con;
    }

    public FolExpression getFirstOrderLogicExpression() {
        return this.folExpr;
    }

    public void setFirstOrderLogicExpression(FolExpression folExpr) {
        this.folExpr = folExpr;
    }

    public boolean hasFirstOrderLogicExpression() {
        return this.folExpr != null;
    }
}

