/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.SBVR;

import de.interactive_instruments.ShapeChange.SBVR.SbvrErrorInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.apache.commons.lang3.StringUtils;

public class SbvrErrorListener
extends BaseErrorListener {
    private List<SbvrErrorInfo> errors = new ArrayList<SbvrErrorInfo>();

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        SbvrErrorInfo err = new SbvrErrorInfo();
        err.setErrorCategory(SbvrErrorInfo.Category.SYNTAX_ERROR);
        err.setErrorMessage(msg);
        err.setMetadataFromToken((Token)offendingSymbol);
        List stack = ((Parser)recognizer).getRuleInvocationStack();
        Collections.reverse(stack);
        err.setRuleInvocationStack(StringUtils.join((Iterable)stack, (String)" "));
        this.errors.add(err);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<SbvrErrorInfo> getErrors() {
        return this.errors;
    }

    protected <T extends Token> void underlineError(Recognizer<T, ?> recognizer, Token offendingToken, int line, int charPositionInLine) {
        CommonTokenStream tokens = (CommonTokenStream)recognizer.getInputStream();
        String input = tokens.getTokenSource().getInputStream().toString();
        String[] lines = input.split("\n");
        String errorLine = lines[line - 1];
        System.out.println(errorLine);
        for (int i = 0; i < charPositionInLine; ++i) {
            System.out.print(" ");
        }
        int start = offendingToken.getStartIndex();
        int stop = offendingToken.getStopIndex();
        if (start >= 0 && stop >= 0) {
            for (int i = start; i <= stop; ++i) {
                System.out.print("^");
            }
        }
        System.out.println();
    }
}

