/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.SBVR;

import de.interactive_instruments.ShapeChange.FOL.AndOr;
import de.interactive_instruments.ShapeChange.FOL.AndOrType;
import de.interactive_instruments.ShapeChange.FOL.BinaryComparisonPredicate;
import de.interactive_instruments.ShapeChange.FOL.ClassCall;
import de.interactive_instruments.ShapeChange.FOL.ClassLiteral;
import de.interactive_instruments.ShapeChange.FOL.EqualTo;
import de.interactive_instruments.ShapeChange.FOL.Expression;
import de.interactive_instruments.ShapeChange.FOL.FolExpression;
import de.interactive_instruments.ShapeChange.FOL.HigherOrEqualTo;
import de.interactive_instruments.ShapeChange.FOL.HigherThan;
import de.interactive_instruments.ShapeChange.FOL.IsNull;
import de.interactive_instruments.ShapeChange.FOL.IsTypeOf;
import de.interactive_instruments.ShapeChange.FOL.LowerOrEqualTo;
import de.interactive_instruments.ShapeChange.FOL.LowerThan;
import de.interactive_instruments.ShapeChange.FOL.Not;
import de.interactive_instruments.ShapeChange.FOL.Predicate;
import de.interactive_instruments.ShapeChange.FOL.PropertyCall;
import de.interactive_instruments.ShapeChange.FOL.Quantification;
import de.interactive_instruments.ShapeChange.FOL.Quantifier;
import de.interactive_instruments.ShapeChange.FOL.RealLiteral;
import de.interactive_instruments.ShapeChange.FOL.SchemaCall;
import de.interactive_instruments.ShapeChange.FOL.StringLiteral;
import de.interactive_instruments.ShapeChange.FOL.StringLiteralList;
import de.interactive_instruments.ShapeChange.FOL.Variable;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.FolConstraint;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.SBVR.SbvrErrorInfo;
import de.interactive_instruments.ShapeChange.SBVR.SbvrParsingException;
import de.interactive_instruments.ShapeChange.SBVR.SbvrUtil;
import de.interactive_instruments.ShapeChange.Type;
import de.interactive_instruments.antlr.sbvr.SBVRBaseVisitor;
import de.interactive_instruments.antlr.sbvr.SBVRParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;

public class Sbvr2FolVisitor
extends SBVRBaseVisitor<FolExpression> {
    private Stack<Variable> scopes = new Stack();
    private Stack<PropertyCall> verbContexts = new Stack();
    private Expression leftExpr;
    private List<SbvrErrorInfo> errors = new ArrayList<SbvrErrorInfo>();
    private Model model;
    private Set<String> namesOfAllPropertiesInSelectedSchema = new HashSet<String>();
    private FolConstraint con;

    public Sbvr2FolVisitor(Model m, FolConstraint con) {
        this.model = m;
        this.con = con;
        SortedSet<? extends PackageInfo> selectedSchemas = this.model.selectedSchemas();
        for (PackageInfo packageInfo : selectedSchemas) {
            SortedSet<ClassInfo> classes = this.model.classes(packageInfo);
            for (ClassInfo ci : classes) {
                for (PropertyInfo pi : ci.properties().values()) {
                    this.namesOfAllPropertiesInSelectedSchema.add(pi.name());
                }
            }
        }
    }

    public Quantification visitSentenceUsingObligation(SBVRParser.SentenceUsingObligationContext ctx) throws SbvrParsingException {
        Predicate predForQuantification;
        Quantification q = this.visitQuantification(ctx.quantification());
        Predicate p2 = this.visitConditionInSentenceUsingObligation(ctx.conditionInSentenceUsingObligation());
        if (ctx.prohibition != null) {
            Not negation = new Not();
            negation.setPredicate(p2);
            p2 = negation;
        }
        if (q.hasCondition()) {
            Predicate p1 = q.getCondition();
            Not n = new Not();
            n.setPredicate(p1);
            AndOr or = new AndOr();
            or.setType(AndOrType.or);
            or.addPredicate(n);
            or.addPredicate(p2);
            predForQuantification = or;
        } else {
            predForQuantification = p2;
        }
        q.setCondition(predForQuantification);
        this.scopes.pop();
        return q;
    }

    public Quantification visitSentenceUsingShall(SBVRParser.SentenceUsingShallContext ctx) throws SbvrParsingException {
        Predicate predForQuantification;
        Quantification q = this.visitQuantification(ctx.quantification());
        Predicate p2 = this.visitConditionInSentenceUsingShall(ctx.conditionInSentenceUsingShall());
        if (q.hasCondition()) {
            Predicate p1 = q.getCondition();
            Not n = new Not();
            n.setPredicate(p1);
            AndOr or = new AndOr();
            or.setType(AndOrType.or);
            or.addPredicate(n);
            or.addPredicate(p2);
            predForQuantification = or;
        } else {
            predForQuantification = p2;
        }
        q.setCondition(predForQuantification);
        this.scopes.pop();
        return q;
    }

    public Predicate visitConditionInSentenceUsingObligation(SBVRParser.ConditionInSentenceUsingObligationContext ctx) throws SbvrParsingException {
        Predicate firstVerbExpr = this.visitVerbExpr(ctx.verbExpr(0));
        if (ctx.verbExpr().size() == 1) {
            return firstVerbExpr;
        }
        boolean andFound = false;
        boolean orFound = false;
        for (int i = 0; i < ctx.andornot().size(); ++i) {
            SBVRParser.AndornotContext andOrNot = ctx.andornot(i);
            if (andOrNot.and != null || andOrNot.andNot != null) {
                andFound = true;
            }
            if (andOrNot.or != null || andOrNot.orNot != null) {
                orFound = true;
            }
            if (!andFound || !orFound) continue;
            SbvrErrorInfo error = new SbvrErrorInfo();
            error.setErrorCategory(SbvrErrorInfo.Category.MIX_OF_AND_AND_OR);
            error.setErrorMessage("The combination of verb expresions must not mix 'and' and 'or'.");
            error.setMetadataFromContext((ParserRuleContext)andOrNot);
            throw new SbvrParsingException(error);
        }
        AndOr logicExpr = new AndOr();
        if (andFound) {
            logicExpr.setType(AndOrType.and);
        } else {
            logicExpr.setType(AndOrType.or);
        }
        logicExpr.addPredicate(firstVerbExpr);
        for (int i = 1; i < ctx.verbExpr().size(); ++i) {
            Predicate pi = this.visitVerbExpr(ctx.verbExpr(i));
            SBVRParser.AndornotContext andOrNot = ctx.andornot(i - 1);
            if (andOrNot.andNot != null || andOrNot.orNot != null) {
                Not n = new Not();
                n.setPredicate(pi);
                logicExpr.addPredicate(n);
                continue;
            }
            logicExpr.addPredicate(pi);
        }
        return logicExpr;
    }

    public Predicate visitConditionInSentenceUsingShall(SBVRParser.ConditionInSentenceUsingShallContext ctx) throws SbvrParsingException {
        Predicate firstVerbExpr = this.visitVerbExpr(ctx.verbExpr(0));
        if (ctx.modality((int)0).shallNot != null) {
            Not n = new Not();
            n.setPredicate(firstVerbExpr);
            firstVerbExpr = n;
        }
        if (ctx.verbExpr().size() == 1) {
            return firstVerbExpr;
        }
        boolean andFound = false;
        boolean orFound = false;
        for (int i = 0; i < ctx.andor().size(); ++i) {
            SBVRParser.AndorContext andOr = ctx.andor(i);
            if (andOr.and != null) {
                andFound = true;
            }
            if (andOr.or != null) {
                orFound = true;
            }
            if (!andFound || !orFound) continue;
            SbvrErrorInfo error = new SbvrErrorInfo();
            error.setErrorCategory(SbvrErrorInfo.Category.MIX_OF_AND_AND_OR);
            error.setErrorMessage("The combination of verb expresions must not mix 'and' and 'or'.");
            error.setMetadataFromContext((ParserRuleContext)andOr);
            throw new SbvrParsingException(error);
        }
        AndOr logicExpr = new AndOr();
        if (andFound) {
            logicExpr.setType(AndOrType.and);
        } else {
            logicExpr.setType(AndOrType.or);
        }
        logicExpr.addPredicate(firstVerbExpr);
        for (int i = 1; i < ctx.verbExpr().size(); ++i) {
            Predicate pi = this.visitVerbExpr(ctx.verbExpr(i));
            if (ctx.modality((int)i).shallNot != null) {
                Not n = new Not();
                n.setPredicate(pi);
                logicExpr.addPredicate(n);
                continue;
            }
            logicExpr.addPredicate(pi);
        }
        return logicExpr;
    }

    public Predicate visitVerbExpr(SBVRParser.VerbExprContext ctx) throws SbvrParsingException {
        Predicate result = null;
        String verb = ctx.verb.getText();
        PropertyCall pcFromVerb = null;
        if (verb.equalsIgnoreCase("has") || verb.equalsIgnoreCase("have")) {
            this.verbContexts.push(null);
        } else {
            PropertyInfo piIdentifiedByVerb;
            ClassInfo contextForVerb;
            Variable var = this.scopes.peek();
            SchemaCall scLastSeg = var.getLastSegmentInValue();
            if (scLastSeg instanceof ClassCall) {
                ClassCall ccLastSeg = (ClassCall)scLastSeg;
                contextForVerb = ccLastSeg.getSchemaElement();
                piIdentifiedByVerb = this.findPropertyByAssociationNameInClassInfo(verb, contextForVerb);
            } else {
                PropertyCall pcLastSeg = (PropertyCall)scLastSeg;
                PropertyInfo pi = pcLastSeg.getSchemaElement();
                Type t = pi.typeInfo();
                contextForVerb = this.model.classById(t.id);
                if (contextForVerb == null) {
                    SbvrErrorInfo error = new SbvrErrorInfo();
                    error.setErrorCategory(SbvrErrorInfo.Category.UNKNOWN_PROPERTY_TYPE);
                    error.setErrorMessage("Property '" + pi.name() + "' in class '" + pi.inClass().name() + "' provides the context for the schema call represented by verb '" + verb + "', but the schema does not contain class '" + t.name + "' which is the type of property '" + pi.name() + "'.");
                    error.setMetadataFromToken(ctx.verb);
                    throw new SbvrParsingException(error);
                }
                piIdentifiedByVerb = this.findPropertyByAssociationNameInClassInfo(verb, contextForVerb);
            }
            if (piIdentifiedByVerb == null) {
                boolean stillNotFound = true;
                if (this.model.options().isAIXM() && contextForVerb.category() == 1) {
                    PropertyInfo ts = contextForVerb.property("timeSlice");
                    ClassInfo tsType = this.model.classById(ts.typeInfo().id);
                    piIdentifiedByVerb = this.findPropertyByAssociationNameInClassInfo(verb, tsType);
                    if (piIdentifiedByVerb != null) {
                        PropertyCall tsPC = new PropertyCall();
                        tsPC.setNameInSbvr("timeSlice");
                        tsPC.setSchemaElement(ts);
                        PropertyCall pcForVerb = new PropertyCall();
                        pcForVerb.setNameInSbvr(verb);
                        pcForVerb.setSchemaElement(piIdentifiedByVerb);
                        tsPC.setNextElement(pcForVerb);
                        pcFromVerb = tsPC;
                        stillNotFound = false;
                    }
                }
                if (stillNotFound) {
                    SbvrErrorInfo error = new SbvrErrorInfo();
                    error.setErrorCategory(SbvrErrorInfo.Category.VERB_UNKNOWN_IN_CONTEXT);
                    error.setErrorMessage("The context for verb (association name) '" + verb + "' is class '" + contextForVerb.name() + "'; neither that class nor one of its direct or indirect supertypes has a navigable property that is the role of an association with '" + verb + "' as its name.");
                    error.setMetadataFromToken(ctx.verb);
                    throw new SbvrParsingException(error);
                }
            } else {
                pcFromVerb = new PropertyCall();
                pcFromVerb.setNameInSbvr(verb);
                pcFromVerb.setSchemaElement(piIdentifiedByVerb);
            }
            this.verbContexts.push(pcFromVerb);
        }
        result = ctx.quantificationWithOptionalQuantifierInVerbExpression() != null ? this.visitQuantificationWithOptionalQuantifierInVerbExpression(ctx.quantificationWithOptionalQuantifierInVerbExpression()) : this.visitAssignmentPredicateInVerbExpression(ctx.assignmentPredicateInVerbExpression());
        this.verbContexts.pop();
        return result;
    }

    public Predicate visitAssignmentPredicateInVerbExpression(SBVRParser.AssignmentPredicateInVerbExpressionContext ctx) {
        if (this.verbContexts.peek() != null) {
            SbvrErrorInfo error = new SbvrErrorInfo();
            error.setErrorCategory(SbvrErrorInfo.Category.VERB_INVALID_FOR_GIVEN_PREDICATE);
            error.setErrorMessage("Verb '" + this.verbContexts.peek().getLastElement().getNameInSbvr() + "' is invalid for an assignment predicate in a verb expression; expected verb 'has' or 'have'.");
            error.setMetadataFromContext((ParserRuleContext)ctx);
            throw new SbvrParsingException(error);
        }
        if (ctx.assignmentPredicate() != null) {
            Quantifier quantifier;
            Quantification q = new Quantification();
            if (ctx.quantifier() != null) {
                quantifier = (Quantifier)this.visit((ParseTree)ctx.quantifier());
            } else {
                quantifier = new Quantifier();
                quantifier.setLowerBoundary(1);
            }
            q.setQuantifier(quantifier);
            Not p = this.visitAssignmentPredicate(ctx.assignmentPredicate());
            q.setCondition(p);
            Variable var = this.scopes.pop();
            q.setVar(var);
            return q;
        }
        AndOr and = new AndOr();
        and.setType(AndOrType.and);
        IsNull in = new IsNull();
        Variable var = this.scopes.peek();
        in.setExpr(var);
        Not not = new Not();
        not.setPredicate(in);
        and.addPredicate(not);
        Expression exprRight = this.visitNameExpr(ctx.assignmentAndOtherThan().nameExpr());
        EqualTo et = new EqualTo();
        et.setExprLeft(var);
        et.setExprRight(exprRight);
        Not n = new Not();
        n.setPredicate(et);
        and.addPredicate(n);
        return and;
    }

    private PropertyInfo findPropertyByAssociationNameInClassInfo(String name, ClassInfo ci) {
        for (PropertyInfo pi : ci.properties().values()) {
            if (pi.association() == null || pi.association().name() == null || !pi.association().name().equals(name)) continue;
            return pi;
        }
        for (String supertypeId : ci.supertypes()) {
            PropertyInfo pi;
            ClassInfo supertype = this.model.classById(supertypeId);
            if (supertype == null || (pi = this.findPropertyByAssociationNameInClassInfo(name, supertype)) == null) continue;
            return pi;
        }
        return null;
    }

    public Predicate visitRelativeClauseExpr(SBVRParser.RelativeClauseExprContext ctx) throws SbvrParsingException {
        Predicate p = this.visitRelativeClause((SBVRParser.RelativeClauseContext)ctx.relativeClause().get(0));
        if (ctx.relativeClause().size() == 1) {
            return p;
        }
        if (this.verbContexts.size() >= 1) {
            for (int i = 1; i < ctx.relativeClause().size(); ++i) {
                if (((SBVRParser.RelativeClauseContext)ctx.relativeClause().get(i)).verbExpr() == null) continue;
                SBVRParser.AndorContext andor = ctx.andor(i - 1);
                SbvrErrorInfo error = new SbvrErrorInfo();
                error.setErrorCategory(SbvrErrorInfo.Category.AMBIGUOUS_CONTEXT);
                error.setErrorMessage("The context for the and|or connected relative clause is ambiguous.");
                error.setOffendingTextStartIndex(andor.start.getStartIndex());
                error.setOffendingTextStopIndex(((SBVRParser.RelativeClauseContext)ctx.relativeClause().get((int)i)).verbExpr().stop.getStopIndex());
                throw new SbvrParsingException(error);
            }
        }
        boolean andFound = false;
        boolean orFound = false;
        for (int i = 0; i < ctx.andor().size(); ++i) {
            SBVRParser.AndorContext andOr = ctx.andor(i);
            if (andOr.and != null) {
                andFound = true;
            }
            if (andOr.or != null) {
                orFound = true;
            }
            if (!andFound || !orFound) continue;
            SbvrErrorInfo error = new SbvrErrorInfo();
            error.setErrorCategory(SbvrErrorInfo.Category.MIX_OF_AND_AND_OR);
            error.setErrorMessage("The combination of relative clauses must not mix 'and' and 'or'.");
            error.setMetadataFromContext((ParserRuleContext)andOr);
            throw new SbvrParsingException(error);
        }
        AndOr logExpr = new AndOr();
        if (andFound) {
            logExpr.setType(AndOrType.and);
        } else {
            logExpr.setType(AndOrType.or);
        }
        logExpr.addPredicate(p);
        for (int i = 1; i < ctx.relativeClause().size(); ++i) {
            Predicate pi = this.visitRelativeClause((SBVRParser.RelativeClauseContext)ctx.relativeClause().get(i));
            logExpr.addPredicate(pi);
        }
        return logExpr;
    }

    public Predicate visitRelativeClause(SBVRParser.RelativeClauseContext ctx) {
        Predicate result = null;
        if (ctx.singlePredicate() != null) {
            result = this.visitSinglePredicate(ctx.singlePredicate());
        } else {
            Predicate p = this.visitVerbExpr(ctx.verbExpr());
            if (ctx.not != null) {
                Not not = new Not();
                not.setPredicate(p);
                result = not;
            } else {
                result = p;
            }
        }
        return result;
    }

    public Quantification visitQuantificationWithOptionalQuantifierInVerbExpression(SBVRParser.QuantificationWithOptionalQuantifierInVerbExpressionContext ctx) {
        Quantification q;
        Quantifier quantifier;
        if (ctx.quantifier() != null) {
            quantifier = (Quantifier)this.visit((ParseTree)ctx.quantifier());
        } else {
            quantifier = new Quantifier();
            quantifier.setLowerBoundary(1);
        }
        if (ctx.relativeClauseExpr() != null) {
            q = this.parseQuantification(quantifier, ctx.noun, this.verbContexts.peek(), ctx.relativeClauseExpr());
        } else {
            Variable var;
            q = new Quantification();
            q.setQuantifier(quantifier);
            try {
                var = this.parseVariable(ctx.noun.getText(), this.verbContexts.peek());
                this.scopes.push(var);
                q.setVar(var);
            }
            catch (SbvrParsingException e) {
                SbvrErrorInfo error = e.getError();
                error.setMetadataFromToken(ctx.noun);
                throw e;
            }
            if (ctx.predicate() != null) {
                this.leftExpr = var;
                Predicate p = this.visitPredicate(ctx.predicate());
                this.leftExpr = null;
                q.setCondition(p);
            } else {
                Not n = new Not();
                IsNull in = new IsNull();
                in.setExpr(var);
                n.setPredicate(in);
                q.setCondition(n);
            }
        }
        this.scopes.pop();
        return q;
    }

    public Quantification visitQuantification(SBVRParser.QuantificationContext ctx) {
        Quantifier quantifier = (Quantifier)this.visit((ParseTree)ctx.quantifier());
        return this.parseQuantification(quantifier, ctx.noun, null, ctx.relativeClauseExpr());
    }

    private Quantification parseQuantification(Quantifier quantifier, Token noun, PropertyCall verbContext, SBVRParser.RelativeClauseExprContext relativeClauseExprCtx) {
        Quantification q = new Quantification();
        q.setQuantifier(quantifier);
        String n = noun.getText();
        try {
            Variable v = verbContext != null ? this.parseVariable(n, verbContext) : this.parseVariable(n);
            q.setVar(v);
            this.scopes.push(v);
        }
        catch (SbvrParsingException e) {
            SbvrErrorInfo error = e.getError();
            error.setMetadataFromToken(noun);
            throw e;
        }
        if (relativeClauseExprCtx != null) {
            Predicate p = this.visitRelativeClauseExpr(relativeClauseExprCtx);
            q.setCondition(p);
        }
        return q;
    }

    public FolExpression visitSentence(SBVRParser.SentenceContext ctx) {
        try {
            Variable v = new Variable("self");
            v.setNextOuterScope(null);
            v.setValue(null);
            this.scopes.push(v);
            if (ctx.sentenceUsingObligation() != null) {
                return this.visitSentenceUsingObligation(ctx.sentenceUsingObligation());
            }
            return this.visitSentenceUsingShall(ctx.sentenceUsingShall());
        }
        catch (SbvrParsingException e) {
            this.errors.add(e.getError());
            return null;
        }
    }

    private Variable parseVariable(String concept) throws SbvrParsingException {
        Variable v = new Variable();
        Variable nextOuterScope = this.scopes.isEmpty() ? null : this.scopes.peek();
        v.setNextOuterScope(nextOuterScope);
        String concept_ = concept.trim();
        String[] parts = concept_.split("\\.");
        SchemaCall firstCall = nextOuterScope == null || nextOuterScope.getValue() == null ? this.parseClassCall(parts[0]) : this.parsePropertyCall(parts[0], nextOuterScope);
        firstCall.setVariableContext(nextOuterScope);
        v.setValue(firstCall);
        SchemaCall previousElement = firstCall.getLastElement();
        for (int i = 1; i < parts.length; ++i) {
            SchemaCall sc = this.parseSchemaCall(parts[i], previousElement);
            previousElement.setNextElement(sc);
            previousElement = sc.getLastElement();
        }
        return v;
    }

    private Variable parseVariable(String concept, PropertyCall verbContext) throws SbvrParsingException {
        if (verbContext == null) {
            return this.parseVariable(concept);
        }
        SchemaCall verbContextCopy = SbvrUtil.copy(verbContext);
        Variable v = new Variable();
        Variable nextOuterScope = this.scopes.isEmpty() ? null : this.scopes.peek();
        v.setNextOuterScope(nextOuterScope);
        String concept_ = concept.trim();
        String[] parts = concept_.split("\\.");
        verbContextCopy.setVariableContext(nextOuterScope);
        v.setValue(verbContextCopy);
        SchemaCall previousElement = verbContextCopy.getLastElement();
        for (int i = 0; i < parts.length; ++i) {
            SchemaCall sc = this.parseSchemaCall(parts[i], previousElement);
            previousElement.setNextElement(sc);
            previousElement = sc.getLastElement();
        }
        return v;
    }

    private SchemaCall parseSchemaCall(String pathSegmentName, SchemaCall previousElement) throws SbvrParsingException {
        SchemaCall result;
        if (previousElement instanceof ClassCall) {
            ClassCall cc = (ClassCall)previousElement;
            result = this.parsePropertyCall(pathSegmentName, cc);
        } else {
            PropertyCall pc = (PropertyCall)previousElement;
            PropertyInfo pi = pc.getSchemaElement();
            Type ti = pi.typeInfo();
            ClassInfo classContext = this.model.classById(ti.id);
            if (classContext == null) {
                SbvrErrorInfo error = new SbvrErrorInfo();
                error.setErrorCategory(SbvrErrorInfo.Category.UNKNOWN_PROPERTY_TYPE);
                error.setErrorMessage("Property '" + pi.name() + "' in class '" + pi.inClass().name() + "' provides the scope for the schema call '" + pathSegmentName + "', but the schema does not contain class '" + ti.name + "' which is the type of property '" + pi.name() + "'.");
                throw new SbvrParsingException(error);
            }
            if (this.isKindOf(pathSegmentName, classContext)) {
                result = this.parseClassCall(pathSegmentName);
            } else if (classContext.property(pathSegmentName) != null) {
                PropertyCall newpc = new PropertyCall();
                newpc.setNameInSbvr(pathSegmentName);
                result = this.validateSchemaElement(newpc, classContext);
            } else {
                if (this.model.options().isAIXM() && classContext.category() == 1) {
                    PropertyInfo ts = classContext.property("timeSlice");
                    ClassInfo tsType = this.model.classById(ts.typeInfo().id);
                    PropertyInfo piInTSType = tsType.property(pathSegmentName);
                    if (piInTSType != null) {
                        PropertyCall tsPC = new PropertyCall();
                        tsPC.setNameInSbvr("timeSlice");
                        tsPC.setSchemaElement(ts);
                        PropertyCall pcForPathSegment = new PropertyCall();
                        pcForPathSegment.setNameInSbvr(pathSegmentName);
                        pcForPathSegment.setSchemaElement(piInTSType);
                        tsPC.setNextElement(pcForPathSegment);
                        return tsPC;
                    }
                }
                SbvrErrorInfo error = new SbvrErrorInfo();
                error.setErrorCategory(SbvrErrorInfo.Category.UNKNOWN_SCHEMA_CALL);
                error.setErrorMessage("The context for the schema call '" + pathSegmentName + "' is provided by property '" + pi.name() + "' (in class '" + pi.inClass().name() + "') which is of type '" + classContext.name() + "' but '" + pathSegmentName + "' neither identifies the value type of that property (or one of its subtypes) nor does it identify a property of that value type.");
                throw new SbvrParsingException(error);
            }
        }
        return result;
    }

    private boolean isKindOf(String className, ClassInfo ci) {
        if (className.equals(ci.name())) {
            return true;
        }
        if (ci.subtypes() == null || ci.subtypes().isEmpty()) {
            return false;
        }
        for (String subtypeId : ci.subtypes()) {
            ClassInfo subtype = this.model.classById(subtypeId);
            if (!this.isKindOf(className, subtype)) continue;
            return true;
        }
        return false;
    }

    private PropertyCall parsePropertyCall(String propertyName, ClassCall cc) throws SbvrParsingException {
        PropertyCall pc = new PropertyCall();
        pc.setNameInSbvr(propertyName);
        return this.validateSchemaElement(pc, cc.getSchemaElement());
    }

    private PropertyCall parsePropertyCall(String propertyName, Variable scope) throws SbvrParsingException {
        ClassInfo classContext;
        PropertyCall pc = new PropertyCall();
        pc.setNameInSbvr(propertyName);
        SchemaCall previousElementFromScope = scope.getLastSegmentInValue();
        if (previousElementFromScope instanceof ClassCall) {
            ClassCall tmp = (ClassCall)previousElementFromScope;
            classContext = tmp.getSchemaElement();
        } else {
            PropertyCall tmp = (PropertyCall)previousElementFromScope;
            PropertyInfo pi = tmp.getSchemaElement();
            Type ti = pi.typeInfo();
            classContext = this.model.classById(ti.id);
            if (classContext == null) {
                SbvrErrorInfo error = new SbvrErrorInfo();
                error.setErrorCategory(SbvrErrorInfo.Category.UNKNOWN_PROPERTY_TYPE);
                error.setErrorMessage("Property '" + pi.name() + "' in class '" + pi.inClass().name() + "' provides the scope for the schema call via property '" + propertyName + "', but the schema does not contain class '" + ti.name + "' which is the type of property '" + pi.name() + "'.");
                throw new SbvrParsingException(error);
            }
        }
        return this.validateSchemaElement(pc, classContext);
    }

    private PropertyCall validateSchemaElement(PropertyCall pc, ClassInfo context) throws SbvrParsingException {
        PropertyInfo pi = context.property(pc.getNameInSbvr());
        if (pi == null) {
            if (this.model.options().isAIXM() && context.category() == 1) {
                PropertyInfo ts = context.property("timeSlice");
                ClassInfo tsType = this.model.classById(ts.typeInfo().id);
                pi = tsType.property(pc.getNameInSbvr());
                if (pi != null) {
                    pc.setSchemaElement(pi);
                    PropertyCall tsPC = new PropertyCall();
                    tsPC.setNameInSbvr("timeSlice");
                    tsPC.setSchemaElement(ts);
                    if (pc.hasVariableContext()) {
                        tsPC.setVariableContext(pc.getVariableContext());
                        pc.setVariableContext(null);
                    }
                    tsPC.setNextElement(pc);
                    return tsPC;
                }
            }
            SbvrErrorInfo error = new SbvrErrorInfo();
            error.setErrorCategory(SbvrErrorInfo.Category.UNKNOWN_PROPERTY);
            error.setErrorMessage("Class '" + context.name() + "' provides the context for the property call '" + pc.getNameInSbvr() + "' - however, neither the class nor its supertypes have a property with that name.");
            throw new SbvrParsingException(error);
        }
        pc.setSchemaElement(pi);
        return pc;
    }

    private ClassCall parseClassCall(String className) throws SbvrParsingException {
        ClassInfo ci = this.model.classByName(className);
        if (ci == null) {
            SbvrErrorInfo error = new SbvrErrorInfo();
            error.setErrorCategory(SbvrErrorInfo.Category.UNKNOWN_CLASS);
            error.setErrorMessage("The schema does not contain a class with name '" + className + "'.");
            throw new SbvrParsingException(error);
        }
        ClassCall cc = new ClassCall();
        cc.setNameInSbvr(className);
        cc.setSchemaElement(ci);
        return cc;
    }

    public Quantifier visitUniversalQuantifier(SBVRParser.UniversalQuantifierContext ctx) {
        Quantifier q = new Quantifier();
        return q;
    }

    public Quantifier visitExistentialQuantifier(SBVRParser.ExistentialQuantifierContext ctx) {
        Quantifier q = new Quantifier();
        q.setLowerBoundary(1);
        return q;
    }

    public Quantifier visitExactlyOneQuantifier(SBVRParser.ExactlyOneQuantifierContext ctx) {
        Quantifier q = new Quantifier();
        q.setLowerBoundary(1);
        q.setUpperBoundary(1);
        return q;
    }

    public Quantifier visitExactlyNQuantifier(SBVRParser.ExactlyNQuantifierContext ctx) {
        Quantifier q = new Quantifier();
        Integer i = Integer.valueOf(ctx.value.getText());
        q.setLowerBoundary(i);
        q.setUpperBoundary(i);
        return q;
    }

    public Quantifier visitNumericRangeQuantifier(SBVRParser.NumericRangeQuantifierContext ctx) {
        Quantifier q = new Quantifier();
        Integer lv = Integer.valueOf(ctx.lowerValue.getText());
        Integer uv = Integer.valueOf(ctx.upperValue.getText());
        q.setLowerBoundary(lv);
        q.setUpperBoundary(uv);
        return q;
    }

    public Quantifier visitAtLeast2Quantifier(SBVRParser.AtLeast2QuantifierContext ctx) {
        Quantifier q = new Quantifier();
        q.setLowerBoundary(2);
        return q;
    }

    public Quantifier visitAtLeastNQuantifier(SBVRParser.AtLeastNQuantifierContext ctx) {
        Quantifier q = new Quantifier();
        Integer i = Integer.valueOf(ctx.value.getText());
        q.setLowerBoundary(i);
        return q;
    }

    public Quantifier visitAtMostOneQuantifier(SBVRParser.AtMostOneQuantifierContext ctx) {
        Quantifier q = new Quantifier();
        q.setUpperBoundary(1);
        return q;
    }

    public Quantifier visitAtMostNQuantifier(SBVRParser.AtMostNQuantifierContext ctx) {
        Quantifier q = new Quantifier();
        Integer i = Integer.valueOf(ctx.value.getText());
        q.setUpperBoundary(i);
        return q;
    }

    public Predicate visitSinglePredicate(SBVRParser.SinglePredicateContext ctx) {
        Quantifier quantifier;
        Quantification q = new Quantification();
        if (ctx.quantifier() != null) {
            quantifier = (Quantifier)this.visit((ParseTree)ctx.quantifier());
        } else {
            quantifier = new Quantifier();
            quantifier.setLowerBoundary(1);
        }
        q.setQuantifier(quantifier);
        Predicate p = ctx.assignmentPredicate() != null ? this.visitAssignmentPredicate(ctx.assignmentPredicate()) : this.visitPrefixedPredicate(ctx.prefixedPredicate());
        q.setCondition(p);
        Variable var = this.scopes.pop();
        q.setVar(var);
        return q;
    }

    public Predicate visitPrefixedPredicate(SBVRParser.PrefixedPredicateContext ctx) {
        try {
            Variable var = this.parseVariable(ctx.noun.getText());
            this.scopes.push(var);
            this.leftExpr = var;
            Predicate p = this.visitPredicate(ctx.predicate());
            this.leftExpr = null;
            return p;
        }
        catch (SbvrParsingException e) {
            SbvrErrorInfo error = e.getError();
            error.setMetadataFromToken(ctx.noun);
            throw e;
        }
    }

    public Predicate visitPredicate(SBVRParser.PredicateContext ctx) {
        Predicate p = ctx.comparisonPredicate() != null ? this.visitComparisonPredicate(ctx.comparisonPredicate()) : this.visitOfTypePredicate(ctx.ofTypePredicate());
        if (ctx.not != null) {
            Not not = new Not();
            not.setPredicate(p);
            return not;
        }
        return p;
    }

    public Predicate visitComparisonPredicate(SBVRParser.ComparisonPredicateContext ctx) {
        Predicate fol = (Predicate)this.visit((ParseTree)ctx.comparisonKeyword());
        Expression exprRight = ctx.nameExpr() != null ? this.visitNameExpr(ctx.nameExpr()) : this.visitNumber(ctx.number());
        Predicate actual = fol;
        if (fol instanceof Not) {
            actual = ((Not)fol).getPredicate();
        }
        if (actual instanceof BinaryComparisonPredicate) {
            BinaryComparisonPredicate bcp = (BinaryComparisonPredicate)actual;
            bcp.setExprLeft(this.leftExpr);
            bcp.setExprRight(exprRight);
            return fol;
        }
        SbvrErrorInfo error = new SbvrErrorInfo();
        error.setErrorMessage("Expected a binary comparison operator.");
        error.setErrorCategory(SbvrErrorInfo.Category.PARSER);
        error.setMetadataFromContext((ParserRuleContext)ctx);
        throw new SbvrParsingException(error);
    }

    public RealLiteral visitNumber(SBVRParser.NumberContext ctx) {
        String text = ctx.getText();
        double v = Double.parseDouble(text);
        RealLiteral rl = new RealLiteral();
        rl.setValue(v);
        return rl;
    }

    private boolean hasPropertyNameAsFirstElement(String noun) {
        String[] parts = noun.split("\\.");
        return this.namesOfAllPropertiesInSelectedSchema.contains(parts[0]);
    }

    public Expression visitNameExpr(SBVRParser.NameExprContext ctx) {
        ArrayList<String> names = new ArrayList<String>();
        for (Token t : ctx.values) {
            String s = t.getText();
            names.add(s.substring(1, s.length() - 1));
        }
        if (names.size() == 1) {
            StringLiteral sl = new StringLiteral();
            sl.setValue((String)names.get(0));
            return sl;
        }
        StringLiteralList sll = new StringLiteralList();
        sll.setValues(names);
        return sll;
    }

    public EqualTo visitEqualTo(SBVRParser.EqualToContext ctx) {
        return new EqualTo();
    }

    public HigherOrEqualTo visitHigherOrEqualTo(SBVRParser.HigherOrEqualToContext ctx) {
        return new HigherOrEqualTo();
    }

    public HigherThan visitHigherThan(SBVRParser.HigherThanContext ctx) {
        return new HigherThan();
    }

    public LowerOrEqualTo visitLowerOrEqualTo(SBVRParser.LowerOrEqualToContext ctx) {
        return new LowerOrEqualTo();
    }

    public LowerThan visitLowerThan(SBVRParser.LowerThanContext ctx) {
        return new LowerThan();
    }

    public Not visitOtherThan(SBVRParser.OtherThanContext ctx) {
        EqualTo et = new EqualTo();
        Not n = new Not();
        n.setPredicate(et);
        return n;
    }

    public Predicate visitOfTypePredicate(SBVRParser.OfTypePredicateContext ctx) throws SbvrParsingException {
        ArrayList<ClassLiteral> typeClassLiterals = new ArrayList<ClassLiteral>();
        List nameContexts = ctx.nameExpr();
        for (SBVRParser.NameExprContext nec : nameContexts) {
            Expression e = this.visitNameExpr(nec);
            TreeSet<String> typeNames = new TreeSet<String>();
            if (e instanceof StringLiteral) {
                typeNames.add(((StringLiteral)e).getValue());
            } else if (e instanceof StringLiteralList) {
                typeNames.addAll(((StringLiteralList)e).getValues());
            } else {
                SbvrErrorInfo error = new SbvrErrorInfo();
                error.setErrorCategory(SbvrErrorInfo.Category.PARSER);
                error.setErrorMessage("Simple name or list of names expected in 'type-of' predicate, but found expression of type '" + e.getClass().getSimpleName() + "'.");
                error.setMetadataFromContext((ParserRuleContext)nec);
                throw new SbvrParsingException(error);
            }
            for (String typeName : typeNames) {
                ClassInfo typeCi = this.model.classByName(typeName);
                if (typeCi != null) {
                    ClassLiteral cl = new ClassLiteral();
                    cl.setSchemaElement(typeCi);
                    typeClassLiterals.add(cl);
                    continue;
                }
                SbvrErrorInfo error = new SbvrErrorInfo();
                error.setErrorCategory(SbvrErrorInfo.Category.UNKNOWN_CLASS);
                error.setErrorMessage("The model does not contain a class called '" + typeName + "'.");
                error.setMetadataFromContext((ParserRuleContext)nec);
                throw new SbvrParsingException(error);
            }
        }
        if (typeClassLiterals.size() > 1) {
            Collections.sort(typeClassLiterals, new Comparator<ClassLiteral>(){

                @Override
                public int compare(ClassLiteral o1, ClassLiteral o2) {
                    return o1.getSchemaElement().name().compareTo(o2.getSchemaElement().name());
                }
            });
            AndOr andor = new AndOr();
            andor.setType(AndOrType.or);
            for (ClassLiteral typeClassLiteral : typeClassLiterals) {
                IsTypeOf ito = new IsTypeOf();
                ito.setExprLeft(this.leftExpr);
                ito.setExprRight(typeClassLiteral);
                andor.addPredicate(ito);
            }
            return andor;
        }
        IsTypeOf ito = new IsTypeOf();
        ito.setExprLeft(this.leftExpr);
        ito.setExprRight((Expression)typeClassLiterals.get(0));
        return ito;
    }

    public Not visitAssignmentPredicate(SBVRParser.AssignmentPredicateContext ctx) {
        IsNull p = new IsNull();
        try {
            Variable var = this.parseVariable(ctx.noun.getText());
            this.scopes.push(var);
            p.setExpr(var);
        }
        catch (SbvrParsingException e) {
            SbvrErrorInfo error = e.getError();
            error.setMetadataFromToken(ctx.noun);
            throw e;
        }
        Not not = new Not();
        not.setPredicate(p);
        return not;
    }

    public List<SbvrErrorInfo> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    protected FolExpression aggregateResult(FolExpression aggregate, FolExpression nextResult) {
        if (aggregate == null && nextResult == null) {
            return null;
        }
        if (nextResult != null) {
            return nextResult;
        }
        return aggregate;
    }
}

