/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.SBVR;

import de.interactive_instruments.ShapeChange.FOL.FolExpression;
import de.interactive_instruments.ShapeChange.FOL.Variable;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.FolConstraint;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.SBVR.Sbvr2FolVisitor;
import de.interactive_instruments.ShapeChange.SBVR.SbvrErrorInfo;
import de.interactive_instruments.ShapeChange.SBVR.SbvrErrorListener;
import de.interactive_instruments.ShapeChange.SBVR.SbvrParsingResult;
import de.interactive_instruments.ShapeChange.SBVR.SbvrUtil;
import de.interactive_instruments.ShapeChange.SBVR.SbvrValidationErrorListener;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.antlr.ShapeChangeAntlr.SbvrParserHelper;
import de.interactive_instruments.antlr.sbvr.SBVRLexer;
import de.interactive_instruments.antlr.sbvr.SBVRParser;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class Sbvr2FolParser
implements MessageSource {
    private ShapeChangeResult result;
    private Set<String> nouns = new TreeSet<String>();
    private Set<String> verbs = new TreeSet<String>();
    private Options options;
    private Model model;
    private SbvrParserHelper helper;
    private boolean logParsingErrorsAsInfos = false;
    private boolean hasErrors = false;

    public Sbvr2FolParser(Model m) {
        this.result = m.result();
        this.options = m.options();
        this.model = m;
        this.helper = SbvrUtil.createParserHelper(m);
        this.nouns = this.helper.nouns;
        this.verbs = this.helper.verbs;
    }

    public Sbvr2FolParser(Model m, boolean logParsingErrorsAsInfos) {
        this(m);
        this.logParsingErrorsAsInfos = logParsingErrorsAsInfos;
    }

    public FolExpression parse(FolConstraint con) {
        Variable.reset();
        SbvrParsingResult parsingResult = new SbvrParsingResult();
        parsingResult.setConstraint(con);
        ANTLRInputStream input = new ANTLRInputStream(con.text());
        SBVRLexer lexer = new SBVRLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        SBVRParser parser = new SBVRParser((TokenStream)tokens);
        parser.helper = this.helper;
        parser.removeErrorListeners();
        SbvrErrorListener parsingErrorListener = new SbvrErrorListener();
        parser.addErrorListener((ANTLRErrorListener)parsingErrorListener);
        SBVRParser.SentenceContext tree = parser.sentence();
        parsingResult.setRuleInvocationStack(tree.toStringTree((Parser)parser));
        if (parsingErrorListener.hasErrors()) {
            parsingResult.addErrors(parsingErrorListener.getErrors());
            this.hasErrors = true;
        } else {
            SbvrValidationErrorListener validationErrorListener = new SbvrValidationErrorListener(this.nouns, this.verbs);
            ParseTreeWalker walker = new ParseTreeWalker();
            walker.walk((ParseTreeListener)validationErrorListener, (ParseTree)tree);
            if (validationErrorListener.hasErrors()) {
                parsingResult.addErrors(validationErrorListener.getErrors());
                this.hasErrors = true;
            } else {
                Sbvr2FolVisitor folVisitor = new Sbvr2FolVisitor(this.model, con);
                FolExpression folExpr = (FolExpression)folVisitor.visit((ParseTree)tree);
                if (folExpr == null) {
                    if (folVisitor.hasErrors()) {
                        parsingResult.addErrors(folVisitor.getErrors());
                        this.hasErrors = true;
                    } else if (this.logParsingErrorsAsInfos) {
                        this.result.addInfo(this, 1);
                    } else {
                        this.result.addError(this, 1);
                    }
                } else {
                    parsingResult.setFirstOrderLogicExpression(folExpr);
                }
            }
        }
        this.logParsingResult(parsingResult);
        if (parsingResult.hasFirstOrderLogicExpression()) {
            return parsingResult.getFirstOrderLogicExpression();
        }
        return null;
    }

    private void logParsingResult(SbvrParsingResult parsingResult) {
        if (parsingResult != null) {
            FolConstraint con = parsingResult.getConstraint();
            if (parsingResult.getFirstOrderLogicExpression() != null) {
                this.result.addDebug("SBVR constraint " + con.name() + ": " + con.text() + (String)(con.contextModelElmt() instanceof ClassInfo ? " (on class '" + con.contextModelElmt().name() + "' in package '" + ((ClassInfo)con.contextModelElmt()).pkg().name() + ")" : ""));
                this.result.addDebug("--- " + parsingResult.getFirstOrderLogicExpression().toString());
            } else {
                TreeMap<String, List<SbvrErrorInfo>> errors = parsingResult.getErrors();
                if (!errors.isEmpty()) {
                    String message = "SBVR constraint " + con.name() + ": " + con.text() + (String)(con.contextModelElmt() instanceof ClassInfo ? " (on class '" + con.contextModelElmt().name() + "' in package '" + ((ClassInfo)con.contextModelElmt()).pkg().name() + ")" : "");
                    if (this.logParsingErrorsAsInfos) {
                        this.result.addInfo(message);
                    } else {
                        this.result.addError(message);
                    }
                    for (List<SbvrErrorInfo> ei : errors.values()) {
                        SbvrUtil.printErrors(ei, con.text(), this.result, this.logParsingErrorsAsInfos);
                    }
                }
            }
            if (parsingResult.hasRuleInvocationStack()) {
                this.result.addDebug("--- rule stack: " + parsingResult.getRuleInvocationStack());
            }
        }
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Translation to First Order Logic expression was not successfull but no errors were reported.";
            }
        }
        return "(" + Sbvr2FolParser.class.getName() + ") Unknown message with number: " + mnr;
    }
}

