/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.Target.Target;
import de.interactive_instruments.ShapeChange.TargetRegistry;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class RuleRegistry {
    protected HashSet<String> fAllRules = new HashSet();
    protected HashSet<String> fRulesInEncRule = new HashSet();
    protected HashMap<String, String> fExtendsEncRule = new HashMap();
    protected TargetRegistry targetRegistry;
    protected Map<String, ProcessRuleSet> ruleSetsByRuleName = new HashMap<String, ProcessRuleSet>();
    protected SortedSet<String> ruleRegistrationErrors = new TreeSet<String>();

    public RuleRegistry(TargetRegistry targetRegistry) {
        this.targetRegistry = targetRegistry;
        this.loadRulesAndRequirements();
    }

    protected void loadRulesAndRequirements() {
        for (Class<?> tc : this.targetRegistry.getTargetClasses()) {
            try {
                Target target = (Target)tc.getConstructor(new Class[0]).newInstance(new Object[0]);
                target.registerRulesAndRequirements(this);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                System.err.println("Exception occurred while loading target class " + tc.getName() + " and attempting to call registerRulesAndRequirements(..).");
                e.printStackTrace();
            }
        }
    }

    public void reset() {
        this.fAllRules = new HashSet();
        this.fExtendsEncRule = new HashMap();
        this.fRulesInEncRule = new HashSet();
        this.ruleRegistrationErrors = new TreeSet<String>();
        this.ruleSetsByRuleName = new HashMap<String, ProcessRuleSet>();
        this.loadRulesAndRequirements();
    }

    public void addRuleSet(ProcessRuleSet prs) {
        String encodingRuleIdentifier = prs.getName();
        if (this.ruleSetsByRuleName.containsKey(encodingRuleIdentifier.toLowerCase())) {
            ProcessRuleSet existingRuleSet = this.ruleSetsByRuleName.get(encodingRuleIdentifier.toLowerCase());
            if (!prs.equals(existingRuleSet)) {
                String msg = "Encountered another definition of encoding rule " + encodingRuleIdentifier + " (ignoring case in name comparison) which is different to the already established definition. The additional definition will be ignored. Rename it if you really want it to apply. The already established definition is (may be hard-coded in the ShapeChange target): " + existingRuleSet.toString() + " The additional definition is: " + prs.toString();
                this.ruleRegistrationErrors.add(msg);
            }
        } else {
            this.ruleSetsByRuleName.put(encodingRuleIdentifier.toLowerCase(), prs);
            String extendedEncodingRuleIdentifier = prs.getExtendedRuleSetName();
            this.addExtendsEncRule(encodingRuleIdentifier, extendedEncodingRuleIdentifier);
            if (prs.hasAdditionalRules()) {
                for (String requirementOrConversionRuleIdentifier : prs.getAdditionalRules()) {
                    this.addRule(requirementOrConversionRuleIdentifier, encodingRuleIdentifier);
                }
            }
        }
    }

    public void addRule(String requirementOrConversionRuleIdentifier) {
        this.fAllRules.add(requirementOrConversionRuleIdentifier.toLowerCase());
    }

    public boolean hasRule(String requirementOrConversionRuleIdentifier) {
        return this.fAllRules.contains(requirementOrConversionRuleIdentifier.toLowerCase());
    }

    private void addRule(String requirementOrConversionRuleIdentifier, String encodingRuleIdentifier) {
        this.fRulesInEncRule.add(requirementOrConversionRuleIdentifier.toLowerCase() + "#" + encodingRuleIdentifier.toLowerCase());
    }

    public boolean hasRule(String requirementOrConversionRuleIdentifier, String encodingRuleIdentifier) {
        boolean res = false;
        while (!res && encodingRuleIdentifier != null) {
            res = this.fRulesInEncRule.contains(requirementOrConversionRuleIdentifier.toLowerCase() + "#" + encodingRuleIdentifier.toLowerCase());
            encodingRuleIdentifier = this.extendsEncRule(encodingRuleIdentifier);
        }
        return res;
    }

    public boolean matchesEncRule(String encodingRuleIdentifier, String baseEncodingRuleIdentifier) {
        while (encodingRuleIdentifier != null) {
            if (encodingRuleIdentifier.equalsIgnoreCase(baseEncodingRuleIdentifier)) {
                return true;
            }
            encodingRuleIdentifier = this.extendsEncRule(encodingRuleIdentifier);
        }
        return false;
    }

    private void addExtendsEncRule(String encodingRuleIdentifier, String extendedEncodingRuleIdentifier) {
        this.fExtendsEncRule.put(encodingRuleIdentifier.toLowerCase(), extendedEncodingRuleIdentifier == null ? null : extendedEncodingRuleIdentifier.toLowerCase());
    }

    public String extendsEncRule(String encodingRuleIdentifier) {
        return this.fExtendsEncRule.get(encodingRuleIdentifier.toLowerCase());
    }

    public boolean encRuleExists(String encodingRuleIdentifier) {
        if ("*".equals(encodingRuleIdentifier)) {
            return true;
        }
        return this.fExtendsEncRule.containsKey(encodingRuleIdentifier.toLowerCase());
    }

    public SortedSet<String> getRuleRegistrationErrors() {
        return this.ruleRegistrationErrors;
    }
}

