/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Profile;

import de.interactive_instruments.ShapeChange.Profile.VersionNumber;

public class VersionRange {
    VersionNumber begin = null;
    VersionNumber end = null;

    public VersionRange(VersionNumber begin, VersionNumber end) {
        this.begin = begin;
        this.end = end;
    }

    public boolean before(VersionRange other) {
        return this.end.compareTo(other.begin) < 0;
    }

    public boolean meets(VersionRange other) {
        return this.end.compareTo(other.begin) == 0;
    }

    public boolean overlaps(VersionRange other) {
        return this.begin.compareTo(other.begin) < 0 && this.end.compareTo(other.begin) > 0 && this.end.compareTo(other.end) < 0;
    }

    public boolean begins(VersionRange other) {
        return this.begin.compareTo(other.begin) == 0 && this.end.compareTo(other.end) < 0;
    }

    public boolean begunBy(VersionRange other) {
        return this.begin.compareTo(other.begin) == 0 && this.end.compareTo(other.end) > 0;
    }

    public boolean during(VersionRange other) {
        return this.begin.compareTo(other.begin) > 0 && this.end.compareTo(other.end) < 0;
    }

    public boolean contains(VersionRange other) {
        return this.begin.compareTo(other.begin) < 0 && this.end.compareTo(other.end) > 0;
    }

    public boolean containsNonStrict(VersionRange other) {
        return this.begin.compareTo(other.begin) <= 0 && this.end.compareTo(other.end) >= 0;
    }

    public boolean equals(VersionRange other) {
        return this.begin.compareTo(other.begin) == 0 && this.end.compareTo(other.end) == 0;
    }

    public boolean overlappedBy(VersionRange other) {
        return this.begin.compareTo(other.begin) > 0 && this.begin.compareTo(other.end) < 0 && this.end.compareTo(other.end) > 0;
    }

    public boolean ends(VersionRange other) {
        return this.begin.compareTo(other.begin) > 0 && this.end.compareTo(other.end) == 0;
    }

    public boolean endedBy(VersionRange other) {
        return this.begin.compareTo(other.begin) < 0 && this.end.compareTo(other.end) == 0;
    }

    public boolean metBy(VersionRange other) {
        return this.begin.compareTo(other.end) == 0;
    }

    public boolean after(VersionRange other) {
        return this.begin.compareTo(other.end) > 0;
    }

    public VersionRange union(VersionRange other) {
        if (this.before(other) || this.after(other)) {
            return null;
        }
        VersionNumber begin_tmp = this.begin.compareTo(other.begin) < 0 ? this.begin : (this.begin.compareTo(other.begin) > 0 ? other.begin : (this.begin.components.length <= other.begin.components.length ? this.begin : other.begin));
        VersionNumber end_tmp = this.end.compareTo(other.end) > 0 ? this.end : (this.end.compareTo(other.end) < 0 ? other.end : (this.end.components.length <= other.end.components.length ? this.end : other.end));
        return new VersionRange(begin_tmp, end_tmp);
    }

    public String toString() {
        return this.begin + "-" + this.end;
    }

    public VersionRange createCopy() {
        VersionNumber beginCopy = this.begin.createCopy();
        VersionNumber endCopy = this.end.createCopy();
        return new VersionRange(beginCopy, endCopy);
    }

    public VersionNumber getBegin() {
        return this.begin;
    }

    public VersionNumber getEnd() {
        return this.end;
    }
}

