/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Profile;

import java.util.Arrays;

public class VersionNumber {
    public int[] components = null;

    public VersionNumber(String vn) {
        String[] cmp = vn.split("\\.");
        this.components = new int[cmp.length];
        for (int i = 0; i < cmp.length; ++i) {
            try {
                this.components[i] = Integer.parseInt(cmp[i]);
                continue;
            }
            catch (NumberFormatException e) {
                this.components[i] = 0;
            }
        }
    }

    public VersionNumber(int[] components) {
        this.components = components;
    }

    public VersionNumber(int component) {
        this.components = new int[]{component};
    }

    public int compareTo(VersionNumber other) {
        int[] otherComps;
        int[] thisComps;
        if (this.components.length == other.components.length) {
            thisComps = this.components;
            otherComps = other.components;
        } else if (this.components.length > other.components.length) {
            thisComps = this.components;
            otherComps = Arrays.copyOf(other.components, this.components.length);
        } else {
            thisComps = Arrays.copyOf(this.components, other.components.length);
            otherComps = other.components;
        }
        for (int i = 0; i < thisComps.length; ++i) {
            int diff = thisComps[i] - otherComps[i];
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public VersionNumber copyForVersionRangeEnd() {
        int[] componentCopy = Arrays.copyOf(this.components, this.components.length);
        int n = this.components.length - 1;
        componentCopy[n] = componentCopy[n] + 1;
        return new VersionNumber(componentCopy);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.components.length; ++i) {
            sb.append(this.components[i]);
            if (i >= this.components.length - 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    public VersionNumber createCopy() {
        int[] componentsCopy = Arrays.copyOf(this.components, this.components.length);
        return new VersionNumber(componentsCopy);
    }
}

