/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Profile;

import de.interactive_instruments.ShapeChange.Model.MalformedProfileIdentifierException;
import de.interactive_instruments.ShapeChange.Profile.ProfileIdentifier;
import de.interactive_instruments.ShapeChange.Profile.ProfileVersionIndicator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Profiles {
    public static final String PROFILES_TAGGED_VALUE = "profiles";
    public static final Pattern PATTERN_VALIDATE_PROFILES_FROM_CONFIG = Pattern.compile("(\\w|-)+(\\[[0-9]+(\\.[0-9]+)*\\])?(,(\\w|-)+(\\[[0-9]+(\\.[0-9]+)*\\])?)*");
    public static final Pattern PATTERN_VALIDATE_PROFILES_TAGGED_VALUE = Pattern.compile("([\\w|-]+)(?:\\[([-;\\.0-9]+)\\])?(?:\\((.*?)\\))?(,\\W*([\\w|-]+)(?:\\[([-;\\.0-9]+)\\])?(?:\\((.*?)\\))?)*");
    public static final Pattern PATTERN_PARSE_PROFILE = Pattern.compile("([\\w|-]+)(?:\\[([\\.0-9-;]+)\\])?(?:\\((.*?)\\))?");
    public static final Pattern PATTERN_VALIDATE_PROFILE_PARAMETERS = Pattern.compile("\\w+(\\[.*?\\])?(,\\w+(\\[.*?\\])?)*");
    public static final Pattern PATTERN_PARSE_PROFILE_PARAMETERS = Pattern.compile("(\\w+)(?:\\[(.*?)\\])?");
    private SortedMap<String, ProfileIdentifier> profileIdentifiersByName = null;

    public Profiles(SortedMap<String, ProfileIdentifier> profileIdentifiers) {
        this.profileIdentifiersByName = profileIdentifiers == null || profileIdentifiers.isEmpty() ? null : profileIdentifiers;
    }

    public Profiles(Collection<ProfileIdentifier> profileIdentifiers) {
        if (profileIdentifiers == null || profileIdentifiers.isEmpty()) {
            this.profileIdentifiersByName = null;
        } else {
            this.profileIdentifiersByName = new TreeMap<String, ProfileIdentifier>();
            for (ProfileIdentifier pi : profileIdentifiers) {
                this.profileIdentifiersByName.put(pi.getName(), pi);
            }
        }
    }

    public ProfileIdentifier put(ProfileIdentifier profile) {
        if (this.profileIdentifiersByName == null) {
            this.profileIdentifiersByName = new TreeMap<String, ProfileIdentifier>();
        }
        return this.profileIdentifiersByName.put(profile.getName(), profile);
    }

    public ProfileIdentifier put(String profileName) {
        if (this.profileIdentifiersByName == null) {
            this.profileIdentifiersByName = new TreeMap<String, ProfileIdentifier>();
        }
        ProfileIdentifier pi = new ProfileIdentifier(profileName, null, null);
        return this.profileIdentifiersByName.put(pi.getName(), pi);
    }

    public Profiles() {
    }

    public static Profiles parse(String profilesString, boolean isProfilesFromConfig) throws MalformedProfileIdentifierException {
        Pattern validationPattern = isProfilesFromConfig ? PATTERN_VALIDATE_PROFILES_FROM_CONFIG : PATTERN_VALIDATE_PROFILES_TAGGED_VALUE;
        Matcher profilesValidator = validationPattern.matcher(profilesString);
        if (!profilesValidator.matches()) {
            throw new MalformedProfileIdentifierException("Profiles value does not match regular expression " + validationPattern.pattern());
        }
        TreeMap<String, ProfileIdentifier> profileIdentifiersByName = new TreeMap<String, ProfileIdentifier>();
        TreeSet<String> duplicateProfileIdentifierNames = new TreeSet<String>();
        Matcher profilesParser = PATTERN_PARSE_PROFILE.matcher(profilesString);
        while (profilesParser.find()) {
            String profileName = profilesParser.group(1);
            if (profileIdentifiersByName.containsKey(profileName)) {
                duplicateProfileIdentifierNames.add(profileName);
                continue;
            }
            String versionIndicatorString = profilesParser.group(2);
            String parametersString = profilesParser.group(3);
            ProfileVersionIndicator versionIndicator = null;
            if (versionIndicatorString != null) {
                versionIndicator = ProfileVersionIndicator.parse(versionIndicatorString, profileName);
            }
            TreeMap<String, String> parameters = null;
            if (parametersString != null) {
                Matcher parametersValidator = PATTERN_VALIDATE_PROFILE_PARAMETERS.matcher(parametersString);
                if (!parametersValidator.matches()) {
                    throw new MalformedProfileIdentifierException("The parameters part of profile '" + profileName + "' does not match regular expression " + parametersValidator.pattern() + " The given parameters value was: " + parametersString);
                }
                parameters = new TreeMap<String, String>();
                Matcher parameterParser = PATTERN_PARSE_PROFILE_PARAMETERS.matcher(parametersString);
                while (parameterParser.find()) {
                    String parameterName = parameterParser.group(1);
                    String parameterValue = parameterParser.group(2);
                    parameters.put(parameterName, parameterValue);
                }
            }
            ProfileIdentifier profileIdentifier = new ProfileIdentifier(profileName, versionIndicator, parameters);
            profileIdentifiersByName.put(profileName, profileIdentifier);
        }
        if (!duplicateProfileIdentifierNames.isEmpty()) {
            throw new MalformedProfileIdentifierException("Duplicate profile name(s) encountered: " + StringUtils.join(duplicateProfileIdentifierNames, (String)","));
        }
        return new Profiles(profileIdentifiersByName);
    }

    public SortedMap<String, ProfileIdentifier> getProfileIdentifiersByName() {
        if (this.profileIdentifiersByName == null) {
            return new TreeMap<String, ProfileIdentifier>();
        }
        return this.profileIdentifiersByName;
    }

    public SortedSet<ProfileIdentifier> getProfileIdentifiers() {
        TreeSet<ProfileIdentifier> result = new TreeSet<ProfileIdentifier>();
        if (this.profileIdentifiersByName != null) {
            result.addAll(this.profileIdentifiersByName.values());
        }
        return result;
    }

    public boolean contains(Profiles other, List<String> messages) {
        HashSet<String> difference = new HashSet<String>(other.getProfileIdentifiersByName().keySet());
        difference.removeAll(this.profileIdentifiersByName.keySet());
        if (!difference.isEmpty()) {
            if (messages != null) {
                String s = StringUtils.join(difference, (String)" ");
                messages.add("These profiles do not contain the following other profiles: " + s);
            }
            return false;
        }
        boolean result = true;
        for (String key : other.getProfileIdentifiersByName().keySet()) {
            ProfileIdentifier pIdOther;
            ProfileIdentifier pIdThis = (ProfileIdentifier)this.profileIdentifiersByName.get(key);
            if (pIdThis.contains(pIdOther = (ProfileIdentifier)other.getProfileIdentifiersByName().get(key), messages)) continue;
            result = false;
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        ArrayList<ProfileIdentifier> identifiers = new ArrayList<ProfileIdentifier>(this.getProfileIdentifiersByName().values());
        if (identifiers.size() > 0) {
            for (int i = 0; i < identifiers.size() - 1; ++i) {
                ProfileIdentifier pi = (ProfileIdentifier)identifiers.get(i);
                sb.append(pi + ",");
            }
            sb.append(identifiers.get(identifiers.size() - 1));
        }
        return sb.toString();
    }

    public Profiles createCopy() {
        TreeMap<String, ProfileIdentifier> copy = new TreeMap<String, ProfileIdentifier>();
        for (Map.Entry<String, ProfileIdentifier> entry : this.getProfileIdentifiersByName().entrySet()) {
            ProfileIdentifier piCopy = entry.getValue().createCopy();
            copy.put(entry.getKey(), piCopy);
        }
        return new Profiles(copy);
    }

    public boolean isEmpty() {
        return this.profileIdentifiersByName == null || this.profileIdentifiersByName.isEmpty();
    }

    public boolean contains(String ownerName, Profiles otherProfiles, String otherOwnerName, boolean isExplicitProfileSettings, boolean profileInheritance, List<String> messages) {
        if (this.isEmpty() && otherProfiles.isEmpty()) {
            return true;
        }
        if (this.isEmpty() && !otherProfiles.isEmpty()) {
            return !isExplicitProfileSettings;
        }
        if (!this.isEmpty() && otherProfiles.isEmpty()) {
            if (isExplicitProfileSettings) {
                return true;
            }
            if (profileInheritance) {
                return true;
            }
            if (messages != null) {
                messages.add("The profiles owned by " + ownerName + " do not contain the profiles owned by " + otherOwnerName + " because the latter does not inherit the profiles from the former, and because the latter has an unlimited profile set while the former does not.");
            }
            return false;
        }
        return this.contains(otherProfiles, messages);
    }

    public int size() {
        if (this.profileIdentifiersByName == null) {
            return 0;
        }
        return this.profileIdentifiersByName.size();
    }

    public ProfileIdentifier get(int index) {
        if (this.isEmpty()) {
            return null;
        }
        int i = 0;
        for (ProfileIdentifier pi : this.profileIdentifiersByName.values()) {
            if (i != index) continue;
            return pi;
        }
        return null;
    }

    public ProfileIdentifier getProfile(String profileName) {
        if (this.profileIdentifiersByName == null) {
            return null;
        }
        return (ProfileIdentifier)this.profileIdentifiersByName.get(profileName);
    }

    public boolean hasProfile(String profileName) {
        if (this.profileIdentifiersByName == null) {
            return false;
        }
        return this.profileIdentifiersByName.containsKey(profileName);
    }

    public SortedSet<ProfileIdentifier> getProfiles(Set<String> profileNames) {
        TreeSet<ProfileIdentifier> result = new TreeSet<ProfileIdentifier>();
        if (profileNames != null && this.profileIdentifiersByName != null) {
            for (Map.Entry<String, ProfileIdentifier> profileEntry : this.profileIdentifiersByName.entrySet()) {
                if (!profileNames.contains(profileEntry.getKey())) continue;
                result.add(profileEntry.getValue());
            }
        }
        return result;
    }

    public String getProfileParameter(String profileName, String parameterName) {
        ProfileIdentifier profile;
        if (profileName != null && parameterName != null && (profile = this.getProfile(profileName)) != null && profile.hasParameters()) {
            return (String)profile.getParameter().get(parameterName);
        }
        return null;
    }

    public void put(Set<ProfileIdentifier> profiles) {
        for (ProfileIdentifier profile : profiles) {
            this.put(profile);
        }
    }

    public void put(Profiles profiles) {
        for (ProfileIdentifier profile : profiles.getProfileIdentifiers()) {
            this.put(profile);
        }
    }
}

