/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Profile;

import de.interactive_instruments.ShapeChange.Model.MalformedProfileIdentifierException;
import de.interactive_instruments.ShapeChange.Profile.VersionNumber;
import de.interactive_instruments.ShapeChange.Profile.VersionRange;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ProfileVersionIndicator {
    static final ProfileVersionIndicator MAX_RANGE_VERSION_INDICATOR = new ProfileVersionIndicator();
    private List<VersionRange> versionInfos = null;

    public ProfileVersionIndicator() {
        VersionNumber begin = new VersionNumber(0);
        VersionNumber end = new VersionNumber(Integer.MAX_VALUE);
        VersionRange vr = new VersionRange(begin, end);
        this.versionInfos = new ArrayList<VersionRange>();
        this.versionInfos.add(vr);
    }

    public ProfileVersionIndicator(List<VersionRange> versionInfos) {
        this.versionInfos = versionInfos;
    }

    public static ProfileVersionIndicator parse(String versionInformation, String identifierName) throws MalformedProfileIdentifierException {
        String[] versionValues = versionInformation.split(";");
        ArrayList<VersionRange> versionInfosTmp = new ArrayList<VersionRange>();
        for (String versionValue : versionValues) {
            VersionRange vr;
            VersionNumber end;
            VersionNumber begin;
            if (versionValue.contains("-")) {
                begin = null;
                end = null;
                if (versionValue.indexOf("-") == 0) {
                    begin = new VersionNumber(0);
                    end = new VersionNumber(versionValue.substring(1, versionValue.length()));
                } else if (versionValue.indexOf("-") == versionValue.length() - 1) {
                    begin = new VersionNumber(versionValue.substring(0, versionValue.length() - 1));
                    end = new VersionNumber(Integer.MAX_VALUE);
                } else {
                    begin = new VersionNumber(versionValue.substring(0, versionValue.indexOf("-")));
                    if (begin.compareTo(end = new VersionNumber(versionValue.substring(versionValue.indexOf("-") + 1, versionValue.length()))) >= 0) {
                        throw new MalformedProfileIdentifierException("Begin of version range '" + versionValue + "' is not lower than its end (in profile '" + identifierName + "').");
                    }
                }
                vr = new VersionRange(begin, end);
                versionInfosTmp.add(vr);
                continue;
            }
            begin = new VersionNumber(versionValue);
            end = begin.copyForVersionRangeEnd();
            vr = new VersionRange(begin, end);
            versionInfosTmp.add(vr);
        }
        ProfileVersionIndicator pVIndicator = null;
        if (versionInfosTmp.size() == 0) {
            throw new MalformedProfileIdentifierException("Version information '" + versionInformation + "' could not be parsed (in profile '" + identifierName + "').");
        }
        if (versionInfosTmp.size() == 1) {
            pVIndicator = new ProfileVersionIndicator(versionInfosTmp);
        } else {
            ArrayList<VersionRange> versionInfos = new ArrayList<VersionRange>();
            while (!versionInfosTmp.isEmpty()) {
                boolean mergeOccurred;
                VersionRange tmp = (VersionRange)versionInfosTmp.get(0);
                versionInfosTmp.remove(0);
                do {
                    mergeOccurred = false;
                    for (int i = 0; i < versionInfosTmp.size(); ++i) {
                        VersionRange tmp2 = (VersionRange)versionInfosTmp.get(i);
                        if (tmp2.before(tmp) || tmp2.after(tmp)) continue;
                        mergeOccurred = true;
                        tmp = tmp.union(tmp2);
                        versionInfosTmp.remove(i);
                    }
                } while (mergeOccurred);
                versionInfos.add(tmp);
                if (versionInfosTmp.size() != 1) continue;
                versionInfos.add((VersionRange)versionInfosTmp.remove(0));
            }
            pVIndicator = new ProfileVersionIndicator(versionInfos);
        }
        return pVIndicator;
    }

    public List<VersionRange> getVersionInfos() {
        return this.versionInfos;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.versionInfos.size(); ++i) {
            sb.append(this.versionInfos.get(i).toString());
            if (i >= this.versionInfos.size() - 1) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    public boolean contains(ProfileVersionIndicator other, StringBuffer sb) {
        boolean doesContain = true;
        ArrayList<CallSite> messages = new ArrayList<CallSite>();
        for (VersionRange vrOther : other.getVersionInfos()) {
            boolean vrOtherIsContainedByThis = false;
            for (VersionRange vrThis : this.versionInfos) {
                if (!vrThis.containsNonStrict(vrOther)) continue;
                vrOtherIsContainedByThis = true;
                break;
            }
            if (vrOtherIsContainedByThis) continue;
            messages.add((CallSite)((Object)("(" + vrOther.toString() + ")")));
            doesContain = false;
        }
        if (doesContain) {
            return true;
        }
        if (sb != null) {
            String s = StringUtils.join(messages, (String)",");
            sb.append(s);
        }
        return false;
    }

    public ProfileVersionIndicator createCopy() {
        ArrayList<VersionRange> vrListCopy = new ArrayList<VersionRange>();
        for (VersionRange vr : this.versionInfos) {
            vrListCopy.add(vr.createCopy());
        }
        return new ProfileVersionIndicator(vrListCopy);
    }
}

