/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Profile;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Profile.ProfileIdentifier;
import de.interactive_instruments.ShapeChange.Profile.Profiles;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class ProfileUtil {
    public static SortedSet<String> findNamesOfAllProfiles(Model model, boolean searchInWholeModel) {
        TreeSet<String> result = new TreeSet<String>();
        if (model != null) {
            SortedSet<PackageInfo> packagesToSearchIn = searchInWholeModel ? model.packages() : model.allPackagesFromSelectedSchemas();
            for (PackageInfo pkg : packagesToSearchIn) {
                for (ClassInfo ci : pkg.containedClasses()) {
                    result.addAll(ci.profiles().getProfileIdentifiersByName().keySet());
                    for (PropertyInfo pi : ci.properties().values()) {
                        result.addAll(pi.profiles().getProfileIdentifiersByName().keySet());
                    }
                }
            }
        }
        return result;
    }

    public static void convertToExplicitProfileDefinitions(GenericModel genModel, Profiles profilesForClassesBelongingToAllProfiles, Pattern schemaNameRegex, boolean convertWholeModel) {
        SortedSet<PackageInfo> selSchemaPkgs = genModel.allPackagesFromSelectedSchemas();
        HashSet<GenericClassInfo> genCisToProcess = new HashSet<GenericClassInfo>();
        for (GenericClassInfo genCi : genModel.getGenClasses().values()) {
            if (schemaNameRegex != null) {
                PackageInfo schemaPkg = genModel.schemaPackage(genCi);
                if (schemaPkg == null || !schemaNameRegex.matcher(schemaPkg.name()).matches()) continue;
                genCisToProcess.add(genCi);
                continue;
            }
            if (!convertWholeModel && !selSchemaPkgs.contains(genCi.pkg())) continue;
            genCisToProcess.add(genCi);
        }
        for (GenericClassInfo genCi : genCisToProcess) {
            if (genCi.profiles().isEmpty()) {
                genCi.setProfiles(profilesForClassesBelongingToAllProfiles.createCopy());
            }
            for (PropertyInfo pi : genCi.properties().values()) {
                if (!pi.profiles().isEmpty()) continue;
                GenericPropertyInfo genPi = (GenericPropertyInfo)pi;
                genPi.setProfiles(genCi.profiles().createCopy());
            }
        }
    }

    public static void removeProfiles(GenericModel genModel) {
        for (GenericClassInfo genCi : genModel.getGenClasses().values()) {
            genCi.setProfiles(null);
            genCi.removeTaggedValue("profiles");
        }
        for (GenericPropertyInfo genPi : genModel.getGenProperties().values()) {
            genPi.setProfiles(null);
            genPi.removeTaggedValue("profiles");
        }
    }

    public static void transferProfiles(SortedSet<String> namesOfProfilesToTransfer, ClassInfo sourceCi, ClassInfo targetCi) {
        SortedSet<ProfileIdentifier> profilesToTransfer = namesOfProfilesToTransfer == null ? sourceCi.profiles().getProfileIdentifiers() : sourceCi.profiles().getProfiles(namesOfProfilesToTransfer);
        for (ProfileIdentifier profile : profilesToTransfer) {
            targetCi.profiles().put(profile);
        }
    }

    public static void transferProfiles(SortedSet<String> namesOfProfilesToTransfer, PropertyInfo sourcePi, PropertyInfo targetPi) {
        SortedSet<ProfileIdentifier> profilesToTransfer = namesOfProfilesToTransfer == null ? sourcePi.profiles().getProfileIdentifiers() : sourcePi.profiles().getProfiles(namesOfProfilesToTransfer);
        for (ProfileIdentifier profile : profilesToTransfer) {
            targetPi.profiles().put(profile);
        }
    }
}

