/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Profile;

import com.google.common.base.Joiner;
import de.interactive_instruments.ShapeChange.Profile.ProfileVersionIndicator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ProfileIdentifier
implements Comparable<ProfileIdentifier> {
    private static final Joiner commaJoiner = Joiner.on((String)",").skipNulls();
    private String name;
    private ProfileVersionIndicator versionIndicator;
    private SortedMap<String, String> parameters;

    public ProfileIdentifier(String name, ProfileVersionIndicator versionIndicator, SortedMap<String, String> parameters) {
        this.name = name;
        this.versionIndicator = versionIndicator;
        this.parameters = parameters == null || parameters.isEmpty() ? null : parameters;
    }

    public SortedMap<String, String> getParameter() {
        if (this.parameters == null) {
            return new TreeMap<String, String>();
        }
        return this.parameters;
    }

    public String getName() {
        return this.name;
    }

    public ProfileVersionIndicator getVersionIndicator() {
        return this.versionIndicator;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        if (this.versionIndicator != null) {
            sb.append("[" + this.versionIndicator.toString() + "]");
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            sb.append("(");
            ArrayList<Object> parameterValues = new ArrayList<Object>();
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                if (entry.getValue() != null) {
                    parameterValues.add(entry.getKey() + "[" + entry.getValue() + "]");
                    continue;
                }
                parameterValues.add(entry.getKey());
            }
            sb.append(commaJoiner.join(parameterValues));
            sb.append(")");
        }
        return sb.toString();
    }

    public boolean contains(ProfileIdentifier other, List<String> messages) {
        if (!this.name.equalsIgnoreCase(other.getName())) {
            if (messages != null) {
                messages.add("Profile names do not match (this: " + this.getName() + ", other: " + other.getName() + ").");
            }
            return false;
        }
        boolean doesContain = true;
        ProfileVersionIndicator thisPVI = this.hasVersionIndicator() ? this.versionIndicator : ProfileVersionIndicator.MAX_RANGE_VERSION_INDICATOR;
        ProfileVersionIndicator otherPVI = other.hasVersionIndicator() ? other.getVersionIndicator() : ProfileVersionIndicator.MAX_RANGE_VERSION_INDICATOR;
        StringBuffer sb = null;
        if (messages != null) {
            sb = new StringBuffer();
            doesContain = thisPVI.contains(otherPVI, sb);
        } else {
            doesContain = thisPVI.contains(otherPVI, null);
        }
        if (!doesContain) {
            if (messages != null) {
                messages.add("The following version ranges from the other profile '" + other.getName() + "' are not contained in this profile '" + this.getName() + "': " + sb + ".");
            }
            return false;
        }
        return true;
    }

    public ProfileIdentifier createCopy() {
        TreeMap<String, String> parameterCopy = new TreeMap<String, String>();
        for (Map.Entry<String, String> parameterEntry : this.getParameter().entrySet()) {
            parameterCopy.put(parameterEntry.getKey(), parameterEntry.getValue());
        }
        ProfileVersionIndicator pviCopy = null;
        if (this.versionIndicator != null) {
            pviCopy = this.versionIndicator.createCopy();
        }
        return new ProfileIdentifier(this.name, pviCopy, parameterCopy);
    }

    public boolean hasVersionIndicator() {
        return this.versionIndicator != null;
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.toString().equals(other.toString());
    }

    @Override
    public int compareTo(ProfileIdentifier other) {
        if (other == null) {
            throw new NullPointerException();
        }
        return this.toString().compareTo(other.toString());
    }
}

