/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Profile;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Profile.ProfileIdentifier;
import de.interactive_instruments.ShapeChange.Profile.Profiles;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.ArrayList;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class ModelProfileValidator
implements MessageSource {
    private static final Splitter commaSplitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private static final Joiner commaJoiner = Joiner.on((String)", ").skipNulls();
    private Model model;
    private ShapeChangeResult result;

    public ModelProfileValidator(Model model, ShapeChangeResult result) {
        this.model = model;
        this.result = result;
    }

    public void validateModelConsistency(boolean isExplicitProfileSettings, boolean warnIfSupertypeProfilesDoNotContainSubtypeProfiles, boolean onlyProcessSelectedSchemas) {
        SortedSet<PackageInfo> selectedSchemaPkgs = this.model.allPackagesFromSelectedSchemas();
        SortedSet<PackageInfo> packages = this.model.packages();
        TreeSet<AssociationInfo> associations = new TreeSet<AssociationInfo>();
        for (PackageInfo pkg : packages) {
            if (onlyProcessSelectedSchemas && !selectedSchemaPkgs.contains(pkg)) continue;
            for (ClassInfo ci : pkg.containedClasses()) {
                ArrayList<String> messages;
                SortedSet<String> subtypeIds = ci.subtypes();
                for (String subtypeId : subtypeIds) {
                    ClassInfo subtype = this.model.classById(subtypeId);
                    if (onlyProcessSelectedSchemas && !selectedSchemaPkgs.contains(subtype.pkg())) continue;
                    messages = new ArrayList<String>();
                    if (ci.profiles().contains(ci.name(), subtype.profiles(), subtype.name(), isExplicitProfileSettings, false, messages)) continue;
                    if (warnIfSupertypeProfilesDoNotContainSubtypeProfiles) {
                        this.result.addWarning(this, 100, ci.name(), subtype.name(), StringUtils.join(messages, (String)" "));
                        continue;
                    }
                    this.result.addError(this, 100, ci.name(), subtype.name(), StringUtils.join(messages, (String)" "));
                }
                String geometryTV = ci.taggedValue("geometry");
                if (StringUtils.isNotBlank((CharSequence)geometryTV)) {
                    TreeSet geometryTVValues = new TreeSet(commaSplitter.splitToList((CharSequence)geometryTV));
                    for (ProfileIdentifier profile : ci.profiles().getProfileIdentifiers()) {
                        ShapeChangeResult.MessageContext mc;
                        String geometryProfile;
                        if (!profile.hasParameters() || (geometryProfile = (String)profile.getParameter().get("geometry")) == null) continue;
                        TreeSet geometryProfileValues = new TreeSet(commaSplitter.splitToList((CharSequence)geometryProfile));
                        Sets.SetView geometryIntersection = Sets.intersection(geometryProfileValues, (Set)geometryTVValues);
                        if (geometryIntersection.isEmpty()) {
                            ShapeChangeResult.MessageContext mc2 = this.result.addWarning(this, 104, profile.getName(), ci.name(), geometryTV, geometryProfile);
                            if (mc2 == null) continue;
                            mc2.addDetail(this, 1, ci.fullName());
                            continue;
                        }
                        Sets.SetView geometryDiff = Sets.difference(geometryProfileValues, (Set)geometryTVValues);
                        if (geometryDiff.isEmpty() || (mc = this.result.addWarning(this, 101, profile.getName(), ci.name(), commaJoiner.join((Iterable)geometryDiff))) == null) continue;
                        mc.addDetail(this, 1, ci.fullName());
                    }
                }
                for (PropertyInfo pi : ci.properties().values()) {
                    if (!pi.isAttribute()) {
                        associations.add(pi.association());
                    }
                    messages = new ArrayList();
                    if (ci.category() != 3 && ci.category() != 2 && !ci.profiles().contains(ci.name(), pi.profiles(), pi.name() + " (in class " + pi.inClass().name() + ")", isExplicitProfileSettings, true, messages)) {
                        this.result.addWarning(this, 20204, ci.name(), pi.name(), StringUtils.join(messages, (String)" "));
                    }
                    if (!(pi.cardinality().minOccurs <= 0 || ci.category() == 3 || ci.category() == 2 || ci.profiles().isEmpty() && pi.profiles().isEmpty())) {
                        if (ci.profiles().isEmpty() && !pi.profiles().isEmpty()) {
                            if (isExplicitProfileSettings) {
                                this.result.addWarning(this, 108, pi.name(), ci.name());
                            } else {
                                this.result.addWarning(this, 106, pi.name(), ci.name());
                            }
                        } else if (!ci.profiles().isEmpty() && pi.profiles().isEmpty()) {
                            if (isExplicitProfileSettings) {
                                this.result.addWarning(this, 106, pi.name(), ci.name());
                            }
                        } else if (!ci.profiles().contains(pi.profiles(), null) || !pi.profiles().contains(ci.profiles(), null)) {
                            this.result.addWarning(this, 108, pi.name(), ci.name());
                        }
                    }
                    ClassInfo typeCi = null;
                    if (pi.typeInfo().id != null) {
                        typeCi = this.model.classById(pi.typeInfo().id);
                    }
                    if (typeCi == null) {
                        typeCi = this.model.classByName(pi.typeInfo().name);
                    }
                    if (typeCi != null && (!onlyProcessSelectedSchemas || selectedSchemaPkgs.contains(typeCi.pkg()))) {
                        ArrayList<String> messages2 = new ArrayList<String>();
                        Profiles applicableProfilesForPi = pi.profiles();
                        if (pi.profiles().isEmpty() && !isExplicitProfileSettings) {
                            applicableProfilesForPi = pi.inClass().profiles();
                        }
                        if (!typeCi.profiles().contains(typeCi.name() + " (type of property " + pi.name() + ")", applicableProfilesForPi, pi.name() + " (property of class " + pi.inClass().name() + ")", isExplicitProfileSettings, false, messages2)) {
                            this.result.addWarning(this, 107, typeCi.name(), pi.name(), ci.name(), StringUtils.join(messages2, (String)" "));
                        }
                    }
                    for (ProfileIdentifier profile : pi.profiles().getProfileIdentifiers()) {
                        String isNavigable;
                        ShapeChangeResult.MessageContext mc;
                        if (!profile.hasParameters()) continue;
                        String mult = (String)profile.getParameter().get("multiplicity");
                        if (mult != null) {
                            Multiplicity multProfile = new Multiplicity(mult);
                            if ((multProfile.minOccurs < pi.cardinality().minOccurs || multProfile.maxOccurs > pi.cardinality().maxOccurs) && (mc = this.result.addWarning(this, 102, profile.getName(), pi.name(), ci.name())) != null) {
                                mc.addDetail(this, 2, pi.fullName());
                            }
                        }
                        if ((isNavigable = (String)profile.getParameter().get("isNavigable")) == null || !pi.isAttribute() || (mc = this.result.addWarning(this, 103, profile.getName(), pi.name(), ci.name())) == null) continue;
                        mc.addDetail(this, 2, pi.fullName());
                    }
                }
            }
        }
        for (AssociationInfo ai : associations) {
            TreeSet<String> profileNames = new TreeSet<String>();
            profileNames.addAll(ai.end1().profiles().getProfileIdentifiersByName().keySet());
            profileNames.addAll(ai.end2().profiles().getProfileIdentifiersByName().keySet());
            for (String profileName : profileNames) {
                ShapeChangeResult.MessageContext mc;
                boolean end2IsNavigableParamValue;
                boolean end1IsNavigableParamValue;
                boolean end1IsNavigableInProfile = ai.end1().isNavigable();
                boolean end2IsNavigableInProfile = ai.end2().isNavigable();
                String end1IsNavigableProfileParameterValue = ai.end1().profiles().getProfileParameter(profileName, "isNavigable");
                String end2IsNavigableProfileParameterValue = ai.end2().profiles().getProfileParameter(profileName, "isNavigable");
                if (!(onlyProcessSelectedSchemas && !selectedSchemaPkgs.contains(ai.end1().inClass().pkg()) || end1IsNavigableProfileParameterValue == null || (end1IsNavigableParamValue = this.parseBoolean(end1IsNavigableProfileParameterValue)))) {
                    end1IsNavigableInProfile = false;
                }
                if (!(onlyProcessSelectedSchemas && !selectedSchemaPkgs.contains(ai.end2().inClass().pkg()) || end2IsNavigableProfileParameterValue == null || (end2IsNavigableParamValue = this.parseBoolean(end2IsNavigableProfileParameterValue)))) {
                    end2IsNavigableInProfile = false;
                }
                if (end1IsNavigableInProfile || end2IsNavigableInProfile || (mc = this.result.addWarning(this, 105, profileName)) == null) continue;
                mc.addDetail(this, 3, ai.end1().fullName());
                mc.addDetail(this, 4, ai.end2().fullName());
            }
        }
    }

    private boolean parseBoolean(String s) {
        return s.trim().equalsIgnoreCase("1") || s.trim().equalsIgnoreCase("true");
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Context: class $1$";
            }
            case 2: {
                return "Context: property $1$";
            }
            case 3: {
                return "Context: association role (end1) '$1$'";
            }
            case 4: {
                return "Context: association role (end2) '$1$'";
            }
            case 100: {
                return "The profile set of class '$1$' does not contain the profile set of its subtype '$2$': $3$.";
            }
            case 101: {
                return "The geometry values defined in the parameter of profile '$1$' are not fully contained in the set of geometries defined for the class '$2$' (via tagged value 'geometry'). The following values are missing in the geometry definition of the class: $3$.";
            }
            case 102: {
                return "The multiplicity value defined in the parameter of profile '$1$' is (at least partly) outside of the range defined by the multiplicity of property '$2$' in class '$3$'.";
            }
            case 103: {
                return "The isNavigable parameter of profile '$1$' cannot be applied to property '$2$' in class '$3$' because that property is an attribute.";
            }
            case 104: {
                return "None of the geometry values defined in the parameter of profile '$1$' is contained in the set of geometries defined for the class '$2$' (via tagged value 'geometry'). The geometry definition of the class is: $3$. The geometry definition of the profile is: $4$.";
            }
            case 105: {
                return "The isNavigable parameter of profile '$1$' on the ends of the association will result in the whole association to no longer be navigable. It is better practice to completely remove the properties from the profile, instead of using the 'isNavigable' profile parameter to do so.";
            }
            case 106: {
                return "Required property '$1$' of class '$2$' does not belong to all profiles of the class. If one of these profiles would be created, the property would no longer belong to the class, which would result in an inconsistency.";
            }
            case 107: {
                return "Class '$1$' is the type of property '$2$' (which is in class '$3$'). The profile set of type '$1$' does not contain the profile set of the property. $4$";
            }
            case 108: {
                return "The set of profiles of required property '$1$' in class '$2$' does not equal the set of profiles of the class. The profile definition is inconsistent.";
            }
            case 20204: {
                return "The profile set of class '$1$' does not contain the profile set of its property '$2$': $3$";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

