/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import java.util.Objects;
import java.util.SortedSet;
import org.apache.commons.lang3.StringUtils;

public class ProcessRuleSet {
    private String name;
    private String extendedRuleSetName = null;
    private SortedSet<String> additionalRules = null;

    public ProcessRuleSet(String name, SortedSet<String> additionalRules) {
        this.name = name;
        this.additionalRules = additionalRules;
    }

    public ProcessRuleSet(String name, String extendedRuleSetName) {
        this.name = name;
        this.extendedRuleSetName = extendedRuleSetName;
    }

    public ProcessRuleSet(String name, String extendedRuleSetName, SortedSet<String> additionalRules) {
        this.name = name;
        this.extendedRuleSetName = extendedRuleSetName;
        this.additionalRules = additionalRules;
    }

    public String getName() {
        return this.name;
    }

    public String getExtendedRuleSetName() {
        return this.extendedRuleSetName;
    }

    public SortedSet<String> getAdditionalRules() {
        return this.additionalRules;
    }

    public boolean hasAdditionalRules() {
        return this.additionalRules != null && !this.additionalRules.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.additionalRules, this.extendedRuleSetName, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessRuleSet other = (ProcessRuleSet)obj;
        return Objects.equals(this.additionalRules, other.additionalRules) && Objects.equals(this.extendedRuleSetName, other.extendedRuleSetName) && Objects.equals(this.name, other.name);
    }

    public String toString() {
        return "ProcessRuleSet [name=" + this.name + ", extends=" + (this.extendedRuleSetName == null ? "<none>" : this.extendedRuleSetName) + ", rules=" + (this.additionalRules == null ? "<none>" : StringUtils.join(this.additionalRules, (String)", ")) + "]";
    }
}

